/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.IPBOMEntry;
import com.kingdee.eas.mm.basedata.PBOMEntryFactory;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.BOMCutTypeEnum;
import com.kingdee.eas.zjbom.convert.app.AbstractBomCutFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BomCutFacadeControllerBean
extends AbstractBomCutFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.convert.app.BomCutFacadeControllerBean");
    private String RESURL = "com.kingdee.eas.zjbom.convert.BomCutResource";
    private Map<String, String> errorMap = null;
    private Map<String, String> bomDesignModeMap = null;

    @Override
    protected Map _bomcut(Context ctx, String bomid) throws BOSException, EASBizException {
        if (bomid == null || "".equals(bomid)) {
            return null;
        }
        this.errorMap = new HashMap<String, String>();
        this.bomDesignModeMap = new HashMap<String, String>();
        Object errorString = null;
        try {
            this.checkParentMaterialPlanAndDesignMode(ctx, bomid);
            if (this.errorMap != null && this.errorMap.containsKey(bomid)) {
                return this.errorMap;
            }
            this.checkChildMaterialPlan(ctx, bomid, this.bomDesignModeMap.get(bomid));
            if (this.errorMap != null && this.errorMap.containsKey(bomid)) {
                return this.errorMap;
            }
            this.bakBomDatas(ctx, bomid);
            this.cutBomDatas(ctx, bomid, this.bomDesignModeMap.get(bomid));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return this.errorMap;
    }

    protected void cutBomDatas(Context ctx, String oldbomid, String designmodeid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        IBom ib = BomFactory.getLocalInstance((Context)ctx);
        BomInfo oldBominfo = ib.getBomInfo((IObjectPK)new ObjectUuidPK(oldbomid), BomCutFacadeControllerBean.getBomSelectSic());
        DesignModeInfo dsInfo = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designmodeid));
        if (oldBominfo.getBomType().equals((Object)BOMTypeEnum.OrderBOM)) {
            List<TrackNumberInfo> tList = this.getOrderBomTrackNumberInfo(ctx, oldbomid);
            if (tList != null && tList.size() > 0) {
                List<Map<String, TrackNumberInfo>> tZoneList = this.getTrackNumberZoneList(ctx, tList);
                BomInfo newBomInfo = this.getNewBomInfo(ctx, oldbomid, designmodeid);
                BomEntryCollection addBomEntrysColl = null;
                if (newBomInfo == null) {
                    oldBominfo.setDesignMode(dsInfo);
                    addBomEntrysColl = this.updateBomEntrysTrack(ctx, tZoneList, oldBominfo, true);
                    oldBominfo.put("isNotCheckHaveOtherBom", (Object)true);
                    ib.update((IObjectPK)new ObjectUuidPK(oldbomid), (CoreBaseInfo)oldBominfo);
                    this.deleteOrderBomPT(ctx, oldbomid);
                    this.updatePBomDatas(ctx, addBomEntrysColl, oldBominfo);
                } else {
                    newBomInfo = ib.getBomInfo((IObjectPK)new ObjectUuidPK(newBomInfo.getId().toString()), BomCutFacadeControllerBean.getBomSelectSic());
                    addBomEntrysColl = this.updateBomEntrysTrack(ctx, tZoneList, oldBominfo, false);
                    for (int i = 0; i < addBomEntrysColl.size(); ++i) {
                        newBomInfo.getEntrys().add(addBomEntrysColl.get(i));
                    }
                    newBomInfo.put("isNotCheckHaveOtherBom", (Object)true);
                    ib.update((IObjectPK)new ObjectUuidPK(newBomInfo.getId()), (CoreBaseInfo)newBomInfo);
                    HashMap paramMap = new HashMap();
                    ArrayList<String> wasteBomIdList = new ArrayList<String>();
                    wasteBomIdList.add(oldbomid);
                    paramMap.put("bomIDList", wasteBomIdList);
                    this._bomwaste(ctx, paramMap);
                }
            }
        } else {
            sql.append(" update t_mm_bom set fdesignmodeid = ? where fid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{designmodeid, oldbomid});
        }
    }

    protected void updatePBomDatas(Context ctx, BomEntryCollection addBomEntryColl, BomInfo bominfo) throws BOSException, EASBizException {
        IPBOMEntry ipe = PBOMEntryFactory.getLocalInstance((Context)ctx);
        PBOMEntryInfo pbeInfo = null;
        PBOMEntryInfo copypbeInfo = null;
        for (int k = 0; k < bominfo.getEntrys().size(); ++k) {
            String fsourceEntryID;
            BomEntryInfo bomEntryInfo = bominfo.getEntrys().get(k);
            boolean hasNew = false;
            for (int i = 0; i < addBomEntryColl.size(); ++i) {
                BomEntryInfo addBomEntryInfo = addBomEntryColl.get(i);
                if (addBomEntryInfo.getSourceEntryId() == null || !(fsourceEntryID = addBomEntryInfo.getSourceEntryId()).equals(bomEntryInfo.getId().toString())) continue;
                hasNew = true;
                break;
            }
            if (!hasNew) continue;
            CoreBaseCollection pbomentryColl = this.getPbomEntryCollByBomEntryID(ctx, bomEntryInfo.getId().toString());
            if (pbomentryColl != null && pbomentryColl.size() > 0) {
                for (int j = 0; j < pbomentryColl.size(); ++j) {
                    pbeInfo = (PBOMEntryInfo)pbomentryColl.get(j);
                    pbeInfo.setSTrace(bomEntryInfo.getBeginCarno());
                    pbeInfo.setETrace(bomEntryInfo.getEndCarno());
                    ipe.save((CoreBaseInfo)pbeInfo);
                }
            }
            for (int i = 0; i < addBomEntryColl.size(); ++i) {
                BomEntryInfo addBomEntryInfo = addBomEntryColl.get(i);
                if (addBomEntryInfo.getSourceEntryId() == null || !(fsourceEntryID = addBomEntryInfo.getSourceEntryId()).equals(bomEntryInfo.getId().toString()) || pbomentryColl == null || pbomentryColl.size() <= 0) continue;
                for (int j = 0; j < pbomentryColl.size(); ++j) {
                    pbeInfo = (PBOMEntryInfo)pbomentryColl.get(j);
                    copypbeInfo = (PBOMEntryInfo)pbeInfo.clone();
                    copypbeInfo.setBOM(bominfo);
                    copypbeInfo.setBomItem(addBomEntryInfo);
                    copypbeInfo.setSTrace(addBomEntryInfo.getBeginCarno());
                    copypbeInfo.setETrace(addBomEntryInfo.getEndCarno());
                    copypbeInfo.setId(BOSUuid.create((BOSObjectType)pbeInfo.getBOSType()));
                    ipe.addnew((CoreBaseInfo)copypbeInfo);
                }
            }
        }
    }

    protected CoreBaseCollection getPbomEntryCollByBomEntryID(Context ctx, String bomentryID) throws BOSException, EASBizException {
        CoreBaseCollection coll = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bomItem.id", (Object)bomentryID));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getPbomEntrySic());
        coll = PBOMEntryFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return coll;
    }

    protected SelectorItemCollection getPbomEntrySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    protected BomEntryCollection updateBomEntrysTrack(Context ctx, List<Map<String, TrackNumberInfo>> tZoneList, BomInfo bomInfo, boolean isOldBom) throws BOSException, EASBizException {
        int i;
        BomEntryInfo bomentryInfo = null;
        BomEntryInfo copybomentryInfo = null;
        BomEntryCollection newBomentryColl = new BomEntryCollection();
        for (i = 0; i < bomInfo.getEntrys().size(); ++i) {
            bomentryInfo = bomInfo.getEntrys().get(i);
            for (int j = 0; j < tZoneList.size(); ++j) {
                Map<String, TrackNumberInfo> tMap = tZoneList.get(j);
                TrackNumberInfo btInfo = tMap.get("btInfo");
                TrackNumberInfo etInfo = tMap.get("etInfo");
                if (j == 0 && isOldBom) {
                    bomentryInfo.setBeginCarno(btInfo);
                    bomentryInfo.setEndCarno(etInfo);
                    continue;
                }
                copybomentryInfo = (BomEntryInfo)bomentryInfo.clone();
                copybomentryInfo.setId(BOSUuid.create((BOSObjectType)bomentryInfo.getBOSType()));
                copybomentryInfo.setBeginCarno(btInfo);
                copybomentryInfo.setEndCarno(etInfo);
                copybomentryInfo.setSourceEntryId(bomentryInfo.getId().toString());
                newBomentryColl.add(copybomentryInfo);
            }
        }
        if (isOldBom) {
            for (i = 0; i < newBomentryColl.size(); ++i) {
                bomInfo.getEntrys().add(newBomentryColl.get(i));
            }
        }
        return newBomentryColl;
    }

    protected static final SelectorItemCollection getBomSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.id"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.number"));
        sic.add(new SelectorItemInfo("entrys.endCarno.id"));
        sic.add(new SelectorItemInfo("entrys.endCarno.number"));
        return sic;
    }

    protected List<Map<String, TrackNumberInfo>> getTrackNumberZoneList(Context ctx, List<TrackNumberInfo> tList) throws BOSException, EASBizException, SQLException {
        if (tList == null || tList.size() < 1) {
            return null;
        }
        ArrayList<Map<String, TrackNumberInfo>> zoneTList = new ArrayList<Map<String, TrackNumberInfo>>();
        HashMap<String, TrackNumberInfo> zoneTMap = new HashMap<String, TrackNumberInfo>();
        TrackNumberInfo tInfo = null;
        TrackNumberInfo btInfo = null;
        TrackNumberInfo etInfo = null;
        List<TrackNumberInfo> allTList = this.getProjectCarZoneTrackNumberInfo(ctx, tList.get(0), tList.get(tList.size() - 1));
        for (int i = 0; i < tList.size(); ++i) {
            tInfo = tList.get(i);
            if (i == 0) {
                btInfo = tInfo;
                etInfo = tInfo;
                continue;
            }
            if (this.checkTwoTrackIsContinue(ctx, allTList, etInfo, tInfo)) {
                etInfo = tInfo;
                continue;
            }
            zoneTMap = new HashMap();
            zoneTMap.put("btInfo", btInfo);
            zoneTMap.put("etInfo", etInfo);
            zoneTList.add(zoneTMap);
            btInfo = tInfo;
            etInfo = tInfo;
        }
        zoneTMap = new HashMap();
        zoneTMap.put("btInfo", btInfo);
        zoneTMap.put("etInfo", etInfo);
        zoneTList.add(zoneTMap);
        return zoneTList;
    }

    protected boolean checkTwoTrackIsContinue(Context ctx, List<TrackNumberInfo> allTList, TrackNumberInfo t1Info, TrackNumberInfo t2Info) throws BOSException, EASBizException, SQLException {
        if (t1Info.getId().toString().equals(t2Info.getId().toString())) {
            return true;
        }
        if (t1Info.get("projectid") == null) {
            return false;
        }
        if (t2Info.get("projectid") == null) {
            return false;
        }
        if (!t1Info.get("projectid").toString().equals(t2Info.get("projectid").toString())) {
            return false;
        }
        for (int i = 0; i < allTList.size(); ++i) {
            if (!allTList.get(i).getId().toString().equals(t1Info.getId().toString())) continue;
            if (i == allTList.size() - 1) {
                return false;
            }
            if (!allTList.get(i + 1).getId().toString().equals(t2Info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    protected void deleteOrderBomPT(Context ctx, String bomid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from t_mm_orderbompt where forderid = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
    }

    protected List<TrackNumberInfo> getOrderBomTrackNumberInfo(Context ctx, String bomid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" select t.fid,t.fnumber,t.fname_l2  as ftrackname,pc.fprojectid as fprojectid  ");
        sql.append(" from t_mm_orderbompt mpt ");
        sql.append(" inner join t_mm_tracknumber t on t.fid = mpt.ftrackid ");
        sql.append(" left outer join t_mm_projectcar pc on pc.ftracknumberid = t.fid ");
        sql.append(" where mpt.forderid = ? ");
        sql.append(" order by t.fnumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
        ArrayList<TrackNumberInfo> tList = new ArrayList<TrackNumberInfo>();
        while (rs.next()) {
            TrackNumberInfo tInfo = new TrackNumberInfo();
            tInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            tInfo.setNumber(rs.getString("fnumber"));
            tInfo.setName(rs.getString("ftrackname"));
            tInfo.put("projectid", (Object)rs.getString("fprojectid"));
            tList.add(tInfo);
        }
        return tList;
    }

    protected List<TrackNumberInfo> getProjectCarZoneTrackNumberInfo(Context ctx, TrackNumberInfo btInfo, TrackNumberInfo etInfo) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" select t.fid,t.fnumber,t.fname_l2  as ftrackname,pc.fprojectid as fprojectid ");
        sql.append(" from t_mm_tracknumber t ");
        sql.append(" left outer join t_mm_projectcar pc on pc.ftracknumberid = t.fid ");
        sql.append(" where t.fnumber >= ?  and t.fnumber <= ? ");
        sql.append(" order by t.fnumber ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{btInfo.getNumber(), etInfo.getNumber()});
        ArrayList<TrackNumberInfo> tList = new ArrayList<TrackNumberInfo>();
        while (rs.next()) {
            TrackNumberInfo tInfo = new TrackNumberInfo();
            tInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            tInfo.setNumber(rs.getString("fnumber"));
            tInfo.setName(rs.getString("ftrackname"));
            tInfo.put("projectid", (Object)rs.getString("fprojectid"));
            tList.add(tInfo);
        }
        return tList;
    }

    protected void checkParentMaterialPlanAndDesignMode(Context ctx, String bomid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select h.fid,h.fnumber,m.fnumber as fmaterialnumber,h.fbasestatus, ");
        sql.append(" m.fname_l2 as fmaterialname,s.fname_l2 as fstorageOrgUnitname, ");
        sql.append(" mp.fid as fmpid,mp.fstatus as fmpstatus,ms.fnumber as fmsnumber, ");
        sql.append(" mp.fisolatedrule,ds.fid as fdsid,ds.fname_l2 as fdsname,ds.fproject as fisproject,ds.ftracknumber as fistracknumber ");
        sql.append(" ,h.fprojectid,h.fbomtype,h.fmaterialid as fmaterialid,h.fstorageorgunitid as fstorageorgunitid ");
        sql.append(" ,mi.fid as fmiid,mi.fstatus as fmistatus ");
        sql.append(" from t_mm_bom h ");
        sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
        sql.append(" left outer join t_org_storage s on s.fid = h.fstorageorgunitid ");
        sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = h.fmaterialid and mp.forgunit = h.fstorageorgunitid ");
        sql.append(" left outer join t_bd_materialinventory mi on mi.fmaterialid = h.fmaterialid and mi.forgunit = h.fstorageorgunitid ");
        sql.append(" left outer join t_bd_manufacturestrategy ms on ms.fid = mp.fmanufacturestrategyid ");
        sql.append(" left outer join t_mm_designmodeentry dse on dse.fmanufacturestrategyid = mp.fmanufacturestrategyid ");
        sql.append(" and isnull(dse.fisolatedrule,'NONE') = isnull(mp.fisolatedrule,'NONE') ");
        sql.append(" left outer join t_mm_designmode ds on ds.fid = dse.fparentid and ds.fstatus = 8 ");
        sql.append(" where h.fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
        String errorString = null;
        while (rs.next()) {
            String fmaterialnumber = rs.getString("fmaterialnumber");
            String fbomnumber = rs.getString("fnumber");
            String fbomid = rs.getString("fid");
            String fstorageOrgUnitname = rs.getString("fstorageOrgUnitname");
            if (rs.getString("fbasestatus") != null && "3".equals(rs.getString("fbasestatus"))) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_007", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmpid") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_001", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmpstatus") == null || !rs.getString("fmpstatus").equals("1")) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_002", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmiid") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_012", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmistatus") == null || !rs.getString("fmistatus").equals("1")) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_013", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmsnumber") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_003", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fdsid") == null) {
                String fmsnumber = rs.getString("fmsnumber");
                String fisolatedrule = rs.getString("fisolatedrule");
                String fisolatedruleName = "";
                if (fisolatedrule != null && "ITEM_TRACKNO".equals(fisolatedrule)) {
                    fisolatedruleName = IsolatedRuleEnum.ITEM_TRACKNO.getAlias();
                } else if (fisolatedrule != null && "ITEM".equals(fisolatedrule)) {
                    fisolatedruleName = IsolatedRuleEnum.ITEM.getAlias();
                }
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_004", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname, fmsnumber, fisolatedruleName});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            int bomtype = rs.getInt("fbomtype");
            String fdesignmodename = rs.getString("fdsname");
            if (rs.getString("fisproject") != null && rs.getString("fisproject").equals("1") && rs.getString("fprojectid") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_005", (Locale)ctx.getLocale(), (Object[])new String[]{fdesignmodename, fbomnumber});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fistracknumber") != null && rs.getString("fistracknumber").equals("1") && !this.checkBomHaveTrackNumber(ctx, fbomid, bomtype)) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_006", (Locale)ctx.getLocale(), (Object[])new String[]{fdesignmodename, fbomnumber});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            BomInfo newBomInfo = this.getNewBomInfo(ctx, fbomid, rs.getString("fdsid"));
            if (newBomInfo != null) {
                if (bomtype != 45) {
                    errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_008", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, newBomInfo.getNumber()});
                    this.errorMap.put(fbomid, errorString);
                    return;
                }
                String fdumpTrackNumber = this.getOrderBomTrackDump(ctx, fbomid, newBomInfo.getId().toString());
                if (fdumpTrackNumber != null && !"".equals(fdumpTrackNumber)) {
                    errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_009", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fdumpTrackNumber, newBomInfo.getNumber()});
                    this.errorMap.put(fbomid, errorString);
                    return;
                }
            }
            this.bomDesignModeMap.put(fbomid, rs.getString("fdsid"));
        }
    }

    protected void checkChildMaterialPlan(Context ctx, String bomid, String parentDesignModeID) throws BOSException, EASBizException, SQLException {
        DesignModeInfo dsInfo = null;
        if (parentDesignModeID != null) {
            dsInfo = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(parentDesignModeID));
        }
        List childDesignModeIDList = MfgBomUtil.getChildDesignModeIDByParentDesignMode((Context)ctx, dsInfo);
        StringBuilder sql = new StringBuilder();
        sql.append(" select h.fid,h.fnumber,m.fnumber as fmaterialnumber, ");
        sql.append(" m.fname_l2 as fmaterialname,s.fname_l2 as fstorageOrgUnitname, ");
        sql.append(" mp.fid as fmpid,mp.fstatus as fmpstatus,mi.fid as fmiid,mi.fstatus as fmistatus ");
        sql.append(" ,ms.fnumber as fmsnumber, ");
        sql.append(" mp.fisolatedrule,ds.fid as fdsid,ds.fname_l2 as fdsname ");
        sql.append(" from t_mm_bom h ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
        sql.append(" left outer join t_bd_material m on m.fid = d.fmaterialid ");
        sql.append(" left outer join t_org_storage s on s.fid = d.fsupplystorageorgunitid ");
        sql.append(" left outer join t_bd_materialinventory mi on mi.fmaterialid = d.fmaterialid and mi.forgunit = d.fsupplystorageorgunitid ");
        sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = d.fmaterialid and mp.forgunit = d.fsupplystorageorgunitid ");
        sql.append(" left outer join t_bd_manufacturestrategy ms on ms.fid = mp.fmanufacturestrategyid ");
        sql.append(" left outer join t_mm_designmodeentry dse on dse.fmanufacturestrategyid = mp.fmanufacturestrategyid ");
        sql.append(" and isnull(dse.fisolatedrule,'NONE') = isnull(mp.fisolatedrule,'NONE') ");
        sql.append(" left outer join t_mm_designmode ds on ds.fid = dse.fparentid and ds.fstatus = 8 ");
        sql.append(" where h.fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
        String errorString = null;
        while (rs.next()) {
            String fmaterialnumber = rs.getString("fmaterialnumber");
            String fbomnumber = rs.getString("fnumber");
            String fbomid = rs.getString("fid");
            String fstorageOrgUnitname = rs.getString("fstorageOrgUnitname");
            if (rs.getString("fmpid") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_010", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmpstatus") == null || !rs.getString("fmpstatus").equals("1")) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_011", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmiid") == null) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_014", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fmistatus") == null || !rs.getString("fmistatus").equals("1")) {
                errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_015", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname});
                this.errorMap.put(fbomid, errorString);
                return;
            }
            if (rs.getString("fdsid") == null || childDesignModeIDList != null && childDesignModeIDList.contains(rs.getString("fdsid"))) continue;
            errorString = ResourceBase.getString((String)this.RESURL, (String)"bomCutError_016", (Locale)ctx.getLocale(), (Object[])new String[]{fbomnumber, fmaterialnumber, fstorageOrgUnitname, dsInfo.getName()});
            this.errorMap.put(fbomid, errorString);
            return;
        }
    }

    protected String getOrderBomTrackDump(Context ctx, String oldbomid, String newbomid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" Select distinct t.fnumber ");
        sql.append(" from t_mm_bom h ");
        sql.append(" inner join t_mm_orderbompt mpt on mpt.forderid = h.fid ");
        sql.append(" inner join t_mm_tracknumber t on t.fid = mpt.ftrackid ");
        sql.append(" where h.fid = ? ");
        sql.append(" and exists(select 1 from t_mm_bomentry d2 inner join t_mm_tracknumber bt on bt.fid = d2.fbegincarnoid ");
        sql.append(" inner join t_mm_tracknumber et on et.fid = d2.fendcarnoid where d2.fparentid = ? and bt.fnumber <= t.fnumber and et.fnumber >= t.fnumber ");
        sql.append(" ) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{oldbomid, newbomid});
        String dumpTrackNumber = "";
        while (rs.next()) {
            if (dumpTrackNumber == null || "".equals(dumpTrackNumber)) {
                dumpTrackNumber = rs.getString("fnumber");
                continue;
            }
            dumpTrackNumber = dumpTrackNumber + "\u3001" + rs.getString("fnumber");
        }
        return dumpTrackNumber;
    }

    protected BomInfo getNewBomInfo(Context ctx, String bomid, String fdsid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select distinct h.fid,h.fnumber ");
        sql.append(" from t_mm_bom h  ");
        sql.append(" inner join t_mm_bom h2 on h.fmaterialid = h2.fmaterialid and h.fstorageorgunitid = h2.fstorageorgunitid  ");
        sql.append(" where h2.fid = ? ");
        sql.append(" and h.fdesignmodeid = ? ");
        sql.append(" and h.fbasestatus <> 3 ");
        sql.append(" and (h.fprojectid is null or h2.fprojectid is null or h.fprojectid = h2.fprojectid) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid, fdsid});
        if (rs.next()) {
            BomInfo bomInfo = new BomInfo();
            bomInfo.setNumber(rs.getString("fnumber"));
            bomInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            return bomInfo;
        }
        return null;
    }

    protected boolean checkBomHaveTrackNumber(Context ctx, String bomid, int bomtype) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (bomtype == 45) {
            sql.append(" select a.fid from t_mm_orderbompt a where a.forderid = ? and a.ftrackid is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
            if (rs.next()) {
                return true;
            }
        } else {
            sql.append(" select a.fid from t_mm_bomentry a where a.fparentid = ? and (a.fbegincarnoid is null or a.fendcarnoid is null) ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
            if (!rs.next()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Map _bomwaste(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if (paramMap == null) {
            return null;
        }
        if (paramMap.get("bomIDList") == null) {
            return null;
        }
        ArrayList bomIDList = (ArrayList)paramMap.get("bomIDList");
        if (bomIDList == null || bomIDList.size() < 1) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        sql.append(" update t_mm_bom ");
        sql.append(" set fbasestatus = 3 ");
        sql.append(" ,flastupdateuserid = '").append(currentUserInfo.getId()).append("' ");
        sql.append(" ,flastupdatetime = sysdate ");
        sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_mm_bomentry ");
        sql.append(" set fdisabledate = to_date('1900-01-01 00:00:00') ");
        sql.append(" where fparentid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return null;
    }

    @Override
    protected IRowSet _querydatas(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if (paramMap == null) {
            return null;
        }
        if (paramMap.get("bomCutType") == null) {
            return null;
        }
        if (paramMap.get("storageOrgUnitIDSet") == null) {
            return null;
        }
        BOMCutTypeEnum bomCutType = (BOMCutTypeEnum)((Object)paramMap.get("bomCutType"));
        HashSet storageOrgUnitIDSet = (HashSet)paramMap.get("storageOrgUnitIDSet");
        BOMTypeEnum bomType = null;
        if (paramMap.get("bomtype") != null) {
            bomType = (BOMTypeEnum)paramMap.get("bomtype");
        }
        BillBaseStatusEnum billBaseStatus = null;
        if (paramMap.get("billBaseStatus") != null) {
            billBaseStatus = (BillBaseStatusEnum)((Object)paramMap.get("billBaseStatus"));
        }
        BomInfo bomInfo = null;
        if (paramMap.get("bomInfo") != null) {
            bomInfo = (BomInfo)paramMap.get("bomInfo");
        }
        ProjectInfo projectInfo = null;
        if (paramMap.get("projectInfo") != null) {
            projectInfo = (ProjectInfo)paramMap.get("projectInfo");
        }
        boolean isExpandChild = false;
        if (paramMap.get("isExpandChild") != null) {
            isExpandChild = (Boolean)paramMap.get("isExpandChild");
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (bomInfo != null && isExpandChild) {
            String fbomTempTable = null;
            try {
                fbomTempTable = MMUtils.createTmpTable((Context)ctx, (String)this.getReturnTableSQL());
                MMUtils.createTableIndex((Context)ctx, (String)fbomTempTable, (String[])new String[]{"flevel"});
                MMUtils.createTableIndex((Context)ctx, (String)fbomTempTable, (String[])new String[]{"Fmaterialid,FstorageOrgUnitID"});
                this.expandBomTempTable(ctx, bomInfo, fbomTempTable);
                sql.setLength(0);
                sql.append(" Select h.fid as fbomid, \r\n");
                sql.append("  h.fnumber as fbomnumber, \r\n");
                sql.append("  h.fname_l2 as fbomname, \r\n");
                sql.append("  m.fnumber as fmaterialnumber, \r\n");
                sql.append("  m.fname_l2 as fmaterialname, \r\n");
                sql.append("  s.fname_l2 as forgunitname, \r\n");
                sql.append("  p.fnumber as fprojectnumber, \r\n");
                sql.append("  p.fname_l2 as fprojectname, \r\n");
                sql.append("  ds.fname_l2 as fdesignmodename, \r\n");
                sql.append("  (case h.fbomtype when 40 then '\u5236\u9020BOM' when 45 then '\u8ba2\u5355BOM' when 50 then '\u914d\u7f6eBOM' when 80 then '\u9879\u76ee\u914d\u7f6eBOM' else '\u5176\u5b83' end) as fbomtype, \r\n");
                sql.append("  ms.fnumber as fmanufacturestrategy, \r\n");
                sql.append("  (case  mp.fisolatedrule when 'ITEM' then '\u6309\u9879\u76ee\u53f7' when 'ITEM_TRACKNO' then '\u6309\u9879\u76ee\u53f7+\u8ddf\u8e2a\u53f7' else '' end) as fisolatedrule \r\n");
                sql.append(" from (Select distinct fbomid from ").append(fbomTempTable).append(" ) a \r\n");
                sql.append(" inner join t_mm_bom h on h.fid = a.fbomid \r\n");
                sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid \r\n");
                sql.append(" inner join t_org_storage s on s.fid = h.fstorageorgunitid \r\n");
                sql.append(" left outer join t_mm_project p on p.fid = h.fprojectid \r\n");
                sql.append(" left outer join t_mm_designmode ds on ds.fid = h.fdesignmodeid \r\n");
                sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = h.fmaterialid and mp.forgunit = h.fstorageorgunitid \r\n");
                sql.append(" left outer join t_bd_manufacturestrategy ms on ms.fid = mp.fmanufacturestrategyid \r\n");
                sql.append(" where h.fstorageorgunitid in(").append(SQLUtil.arrayToString((Object[])storageOrgUnitIDSet.toArray())).append(") \r\n");
                if (bomType != null && !bomType.equals((Object)BOMTypeEnum.NULL)) {
                    sql.append(" and h.fbomtype = ").append(bomType.getValue());
                }
                if (projectInfo != null) {
                    sql.append(" and h.fprojectid = '").append(projectInfo.getId()).append("'");
                }
                if (billBaseStatus != null && !billBaseStatus.equals((Object)BillBaseStatusEnum.NULL)) {
                    sql.append(" and h.fbasestatus = ").append(billBaseStatus.getValue());
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            finally {
                if (fbomTempTable != null && !"".equals(fbomTempTable)) {
                    MMUtils.releaseTmpTable((Context)ctx, (String)fbomTempTable);
                }
            }
        } else {
            sql.setLength(0);
            sql.append(" Select h.fid as fbomid, \r\n");
            sql.append("  h.fnumber as fbomnumber, \r\n");
            sql.append("  h.fname_l2 as fbomname, \r\n");
            sql.append(" m.fnumber as fmaterialnumber, \r\n");
            sql.append("  m.fname_l2 as fmaterialname, \r\n");
            sql.append("  s.fname_l2 as forgunitname, \r\n");
            sql.append("  p.fnumber as fprojectnumber, \r\n");
            sql.append("  p.fname_l2 as fprojectname, \r\n");
            sql.append("  ds.fname_l2 as fdesignmodename, \r\n");
            sql.append("  (case h.fbomtype when 40 then '\u5236\u9020BOM' when 45 then '\u8ba2\u5355BOM' when 50 then '\u914d\u7f6eBOM' when 80 then '\u9879\u76ee\u914d\u7f6eBOM' else '\u5176\u5b83' end) as fbomtype, \r\n");
            sql.append("  ms.fnumber as fmanufacturestrategy, \r\n");
            sql.append("  (case  mp.fisolatedrule when 'ITEM' then '\u6309\u9879\u76ee\u53f7' when 'ITEM_TRACKNO' then '\u6309\u9879\u76ee\u53f7+\u8ddf\u8e2a\u53f7' else '' end) as fisolatedrule \r\n");
            sql.append(" from t_mm_bom h \r\n");
            sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid \r\n");
            sql.append(" inner join t_org_storage s on s.fid = h.fstorageorgunitid \r\n");
            sql.append(" left outer join t_mm_project p on p.fid = h.fprojectid \r\n");
            sql.append(" left outer join t_mm_designmode ds on ds.fid = h.fdesignmodeid \r\n");
            sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = h.fmaterialid and mp.forgunit = h.fstorageorgunitid \r\n");
            sql.append(" left outer join t_bd_manufacturestrategy ms on ms.fid = mp.fmanufacturestrategyid \r\n");
            sql.append(" where h.fstorageorgunitid in(").append(SQLUtil.arrayToString((Object[])storageOrgUnitIDSet.toArray())).append(") \r\n");
            if (bomInfo != null) {
                sql.append(" and h.fid = '").append(bomInfo.getId()).append("'");
            }
            if (bomCutType.equals((Object)BOMCutTypeEnum.OLDBOM)) {
                sql.append(" and h.fdesignmodeid is null \r\n");
            } else {
                sql.append(" and h.fdesignmodeid is not null \r\n");
            }
            if (bomType != null && !bomType.equals((Object)BOMTypeEnum.NULL)) {
                sql.append(" and h.fbomtype = ").append(bomType.getValue());
            }
            if (projectInfo != null) {
                sql.append(" and h.fprojectid = '").append(projectInfo.getId()).append("'");
            }
            if (billBaseStatus != null && !billBaseStatus.equals((Object)BillBaseStatusEnum.NULL)) {
                sql.append(" and h.fbasestatus = ").append(billBaseStatus.getValue());
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        return rs;
    }

    private String getReturnTableSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table returnTable ( ");
        sb.append("Fmaterialid varchar(44)");
        sb.append(",FstorageOrgUnitID varchar(44)");
        sb.append(",fmaterialAttr INT");
        sb.append(",flevel INT");
        sb.append(",fprojectid VARCHAR(44)  ");
        sb.append(",fbomid VARCHAR(44) ");
        sb.append(",fbomtype INT ");
        sb.append(",fdesignmodeid VARCHAR(44) ");
        sb.append(")");
        return sb.toString();
    }

    protected String getInsertTableSQL(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append(" Fmaterialid ");
        sb.append(",FstorageOrgUnitID  ");
        sb.append(",fmaterialAttr ");
        sb.append(",flevel");
        sb.append(",fprojectid");
        sb.append(",fbomid");
        sb.append(",fbomtype");
        sb.append(",fdesignmodeid");
        sb.append(")");
        return sb.toString();
    }

    private void expandBomTempTable(Context ctx, BomInfo bomInfo, String fbomExpandTable) throws EASBizException, BOSException, SQLException {
        int effectedRows = 0;
        int level = 0;
        boolean row = false;
        StringBuilder sql = new StringBuilder();
        while (level < 50) {
            if (++level >= 48) {
                throw new BOSException(ResourceBase.getString((String)this.RESURL, (String)"BOM_LOOP", (Locale)ctx.getLocale(), (Object[])new String[]{bomInfo.getNumber()}));
            }
            sql.setLength(0);
            sql.append(" ").append(this.getInsertTableSQL(fbomExpandTable)).append(" \r\n");
            if (level == 1) {
                sql.append(" Select \r\n");
                sql.append(" a.fmaterialid As Fmaterialid,\r\n");
                sql.append(" a.fstorageorgunitid As  FstorageOrgUnitID,\r\n");
                sql.append(" ").append(10030).append(" As fmaterialAttr, \r\n");
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" a.fprojectid As fprojectid,\r\n");
                sql.append(" a.fid As fbomid, \r\n");
                sql.append(" a.fbomtype As fbomtype, \r\n");
                sql.append(" a.fdesignmodeid As fdesignmodeid \r\n");
                sql.append(" From t_mm_bom a  \r\n");
                sql.append(" Where a.fid = '" + bomInfo.getId() + "'  \r\n");
            } else {
                sql.append(" Select \r\n");
                sql.append(" a.fmaterialid As Fmaterialid,\r\n");
                sql.append(" a.fstorageorgunitid As  FstorageOrgUnitID,\r\n");
                sql.append(" b.fmaterialprop As fmaterialAttr, \r\n");
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" a.fprojectid As fprojectid,\r\n");
                sql.append(" a.fid As fbomid, \r\n");
                sql.append(" a.fbomtype As fbomtype, \r\n");
                sql.append(" a.fdesignmodeid As fdesignmodeid \r\n");
                sql.append(" From ").append(fbomExpandTable).append(" T \r\n");
                sql.append(" Inner Join t_mm_bomentry b On T.fbomid = b.fparentid \r\n");
                sql.append(" Inner Join t_mm_bom a On  a.fmaterialid = b.fmaterialid and a.fstorageorgunitid = b.fsupplystorageorgunitid ");
                sql.append(" Where T.flevel = ").append(level - 1).append("  \r\n");
                sql.append(" AND b.FConsumeFixQty > 0  \r\n");
                if (bomInfo.getDesignMode() != null) {
                    sql.append(" AND a.fdesignmodeid is not null \r\n");
                    sql.append(" AND (a.fprojectid is  null or T.fprojectid is null or a.fprojectid =T.fprojectid )\r\n");
                } else {
                    sql.append(" AND a.fdesignmodeid is null \r\n");
                    sql.append(" AND (a.fprojectid is  null or T.fprojectid is null or a.fprojectid =T.fprojectid )\r\n");
                    sql.append(" AND ((T.fbomtype = 45 and a.fbomtype in (45,40) ) \r\n");
                    sql.append(" or (T.fbomtype = 80 and a.fbomtype in (80,40) ) \r\n");
                    sql.append(" or (T.fbomtype = 40 and a.fbomtype = 40 ))  \r\n");
                }
            }
            if ((effectedRows = this.executeSQL(ctx, sql.toString())) > 0) continue;
            break;
        }
    }

    protected int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected void bakBomDatas(Context ctx, String bomid) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        sql.append(" insert into T_MM_BOM_CUTBAK(  \r\n");
        sql.append(" FUNITID             , \r\n");
        sql.append("  FBASEUNITID         , \r\n");
        sql.append("  FSTORAGEORGUNITID   , \r\n");
        sql.append("  FNAME_L1            , \r\n");
        sql.append("  FNAME_L2            , \r\n");
        sql.append("  FNAME_L3            , \r\n");
        sql.append("  FBOMTYPE            , \r\n");
        sql.append("  FPRODUCTBASEQTY     , \r\n");
        sql.append(" FPRODUCTQTY         , \r\n");
        sql.append(" FUSAGETYPE          , \r\n");
        sql.append(" FMATERIALID         , \r\n");
        sql.append(" FMODEL              , \r\n");
        sql.append(" FYIELD              , \r\n");
        sql.append("  FMATERIALPLANID     , \r\n");
        sql.append("  FSOURCESOUID        , \r\n");
        sql.append("  FASSIGNERID         , \r\n");
        sql.append(" FASSIGNTIME        , \r\n");
        sql.append(" FSOURCEBOMID        , \r\n");
        sql.append("  FSOURCEBOMNUMBER   , \r\n");
        sql.append("  FISASSIGNED         , \r\n");
        sql.append("  FCFGOPTION          , \r\n");
        sql.append("  FPICTURENUMBER     , \r\n");
        sql.append("  FBOMGROUPID         , \r\n");
        sql.append(" FPROJECTID          , \r\n");
        sql.append("  FISPROJECTMANU      , \r\n");
        sql.append("  FAUDITTIME         , \r\n");
        sql.append("  FBASESTATUS         , \r\n");
        sql.append("  FBIZTYPEID          , \r\n");
        sql.append("  FSOURCEBILLTYPEID   , \r\n");
        sql.append("  FBILLTYPEID         , \r\n");
        sql.append("  FYEAR               , \r\n");
        sql.append("  FPERIOD             , \r\n");
        sql.append("  FMODIFIERID         , \r\n");
        sql.append("  FMODIFICATIONTIME  , \r\n");
        sql.append("  FNUMBER            , \r\n");
        sql.append("  FBIZDATE           , \r\n");
        sql.append("  FHANDLERID          , \r\n");
        sql.append("  FDESCRIPTION        , \r\n");
        sql.append("  FHASEFFECTED        , \r\n");
        sql.append("  FAUDITORID          , \r\n");
        sql.append(" FSOURCEBILLID       , \r\n");
        sql.append("  FSOURCEFUNCTION     , \r\n");
        sql.append("  FCREATORID          , \r\n");
        sql.append("  FCREATETIME        , \r\n");
        sql.append("  FLASTUPDATEUSERID   , \r\n");
        sql.append("  FLASTUPDATETIME    , \r\n");
        sql.append("  FCONTROLUNITID      , \r\n");
        sql.append("  FID                  , \r\n");
        sql.append("  FSOURCECFGBOMID     , \r\n");
        sql.append("  FSOURCECFGBOMNUMBER, \r\n");
        sql.append("  FUNITSOURCE        , \r\n");
        sql.append("  FGETSUPPLIERID      , \r\n");
        sql.append("  FDESIGNMODEID ,       \r\n");
        sql.append("  Fbaker  ,      \r\n");
        sql.append("  FBakDate        \r\n");
        sql.append("  ) \r\n");
        sql.append(" select \r\n");
        sql.append(" FUNITID             , \r\n");
        sql.append("  FBASEUNITID         , \r\n");
        sql.append("  FSTORAGEORGUNITID   , \r\n");
        sql.append("  FNAME_L1            , \r\n");
        sql.append("  FNAME_L2            , \r\n");
        sql.append("  FNAME_L3            , \r\n");
        sql.append("  FBOMTYPE            , \r\n");
        sql.append("  FPRODUCTBASEQTY     , \r\n");
        sql.append(" FPRODUCTQTY         , \r\n");
        sql.append(" FUSAGETYPE          , \r\n");
        sql.append(" FMATERIALID         , \r\n");
        sql.append(" FMODEL              , \r\n");
        sql.append(" FYIELD              , \r\n");
        sql.append("  FMATERIALPLANID     , \r\n");
        sql.append("  FSOURCESOUID        , \r\n");
        sql.append("  FASSIGNERID         , \r\n");
        sql.append(" FASSIGNTIME        , \r\n");
        sql.append(" FSOURCEBOMID        , \r\n");
        sql.append("  FSOURCEBOMNUMBER   , \r\n");
        sql.append("  FISASSIGNED         , \r\n");
        sql.append("  isnull(FCFGOPTION,0), \r\n");
        sql.append("  FPICTURENUMBER     , \r\n");
        sql.append("  FBOMGROUPID         , \r\n");
        sql.append(" FPROJECTID          , \r\n");
        sql.append("  FISPROJECTMANU      , \r\n");
        sql.append("  FAUDITTIME         , \r\n");
        sql.append("  FBASESTATUS         , \r\n");
        sql.append("  FBIZTYPEID          , \r\n");
        sql.append("  FSOURCEBILLTYPEID   , \r\n");
        sql.append("  FBILLTYPEID         , \r\n");
        sql.append("  FYEAR               , \r\n");
        sql.append("  FPERIOD             , \r\n");
        sql.append("  FMODIFIERID         , \r\n");
        sql.append("  FMODIFICATIONTIME  , \r\n");
        sql.append("  FNUMBER            , \r\n");
        sql.append("  FBIZDATE           , \r\n");
        sql.append("  FHANDLERID          , \r\n");
        sql.append("  FDESCRIPTION        , \r\n");
        sql.append("  FHASEFFECTED        , \r\n");
        sql.append("  FAUDITORID          , \r\n");
        sql.append(" FSOURCEBILLID       , \r\n");
        sql.append("  FSOURCEFUNCTION     , \r\n");
        sql.append("  FCREATORID          , \r\n");
        sql.append("  FCREATETIME        , \r\n");
        sql.append("  FLASTUPDATEUSERID   , \r\n");
        sql.append("  FLASTUPDATETIME    , \r\n");
        sql.append("  FCONTROLUNITID      , \r\n");
        sql.append("  FID                  , \r\n");
        sql.append("  FSOURCECFGBOMID     , \r\n");
        sql.append("  FSOURCECFGBOMNUMBER, \r\n");
        sql.append("  FUNITSOURCE        , \r\n");
        sql.append("  FGETSUPPLIERID      , \r\n");
        sql.append("  FDESIGNMODEID      ,  \r\n");
        sql.append("  '").append(currentUserInfo.getId()).append("'  as fbaker ,      \r\n");
        sql.append("  sysdate as fbakdate        \r\n");
        sql.append(" from t_mm_bom  \r\n");
        sql.append(" where fid = ? \r\n");
        sql.append("  and not exists(select  1 from T_MM_BOM_CUTBAK where fid = ? ) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid, bomid});
        sql.setLength(0);
        sql.append(" Insert Into T_MM_BOMENTRY_CUTBAK \r\n");
        sql.append(" ( \r\n");
        sql.append("  FPARENTID               , \r\n");
        sql.append("  FPROPORTION              , \r\n");
        sql.append("  FBASEPROPORTION          , \r\n");
        sql.append("  FSCRAPRATIO              , \r\n");
        sql.append("  FLEADTIME                , \r\n");
        sql.append("  FEFFECTIVEDATE          , \r\n");
        sql.append("  FDISABLEDATE            , \r\n");
        sql.append("   FCONSUMEFIXQTY           , \r\n");
        sql.append("   FCONSUMEFIXBASEQTY       , \r\n");
        sql.append("  FCONSUMETYPE              , \r\n");
        sql.append("  FMATERIALINVENTOID      , \r\n");
        sql.append("  FSUPPLYSTORAGEORGUNITID , \r\n");
        sql.append("  FOUTPUTTYPE              , \r\n");
        sql.append("  FPROVIDETYPE              , \r\n");
        sql.append("  FISSMODE                 , \r\n");
        sql.append("  FDEFAULTWAREHOUSEID     , \r\n");
        sql.append("  FPRODUCTRATE             , \r\n");
        sql.append("  FMATERIALCHAR             , \r\n");
        sql.append("  FBASERATE                , \r\n");
        sql.append("  FBASEPRODUCTRATE         , \r\n");
        sql.append("  FBLUEPRINT_L1            , \r\n");
        sql.append("  FBLUEPRINT_L2            , \r\n");
        sql.append("  FBLUEPRINT_L3            , \r\n");
        sql.append("  FREPLACEMODE             , \r\n");
        sql.append("  FSOURCEENTRYID          , \r\n");
        sql.append("  FISASSIGNED              , \r\n");
        sql.append("  FQCCERTIFICATE           , \r\n");
        sql.append("  FBLKSIZE                 , \r\n");
        sql.append("  FSPECIFIEDLENGTH         , \r\n");
        sql.append("  FUSEDUNITID             , \r\n");
        sql.append("  FDESIGNUNITID           , \r\n");
        sql.append("  FDESIGNREMARK            , \r\n");
        sql.append("  FFETURE                  , \r\n");
        sql.append("  FFIRSTCFG                , \r\n");
        sql.append("  FCANSELECTED             , \r\n");
        sql.append("  FMATERIALPROP             , \r\n");
        sql.append("  FSHOWPROJECT             , \r\n");
        sql.append("  FSHOWTRACK               , \r\n");
        sql.append("  FNETWEIGHT               , \r\n");
        sql.append("  FLOCATIONID             , \r\n");
        sql.append("  FISSTOCKTRANSFER         , \r\n");
        sql.append("  FTRANSFERORGUNITID      , \r\n");
        sql.append("  FTRANSFERWAREHOUSEID    , \r\n");
        sql.append("  FMATERIALID             , \r\n");
        sql.append("  FISBACKFLUSH             , \r\n");
        sql.append("  FASSISTPROPERTYID       , \r\n");
        sql.append("  FUNITID                 , \r\n");
        sql.append("  FSOURCEBILLID           , \r\n");
        sql.append("  FSOURCEBILLNUMBER        , \r\n");
        sql.append("  FSOURCEBILLENTRYID      , \r\n");
        sql.append("  FSOURCEBILLENTRYSEQ      , \r\n");
        sql.append("  FASSCOEFFICIENT          , \r\n");
        sql.append("  FBASESTATUS             , \r\n");
        sql.append("  FASSOCIATEQTY            , \r\n");
        sql.append("  FSOURCEBILLTYPEID       , \r\n");
        sql.append("  FBASEUNITID             , \r\n");
        sql.append("  FASSISTUNITID           , \r\n");
        sql.append("  FREMARK                  , \r\n");
        sql.append("  FREASONCODEID           , \r\n");
        sql.append("  FSEQ                    , \r\n");
        sql.append("  FID                      , \r\n");
        sql.append("  FOPERATIONNO             , \r\n");
        sql.append("  FRESERVATIONBILLOBJECTID, \r\n");
        sql.append("  FRESERVATIONID           , \r\n");
        sql.append("  FFIXSEQ                  , \r\n");
        sql.append("  FBEGINCARNOID           , \r\n");
        sql.append("  FENDCARNOID             , \r\n");
        sql.append("  FBOMFLOW                 , \r\n");
        sql.append("  FGTMENO                  , \r\n");
        sql.append("  FSOURCEPROCESS           , \r\n");
        sql.append("  FSOURCEPROCESSID         , \r\n");
        sql.append("  FSUPPLIERID             , \r\n");
        sql.append("  FBAKER                  , \r\n");
        sql.append("  FBAKDATE                 \r\n");
        sql.append(" ) \r\n");
        sql.append(" Select \r\n");
        sql.append("  FPARENTID               , \r\n");
        sql.append("  FPROPORTION              , \r\n");
        sql.append("  FBASEPROPORTION          , \r\n");
        sql.append("  FSCRAPRATIO              , \r\n");
        sql.append("  FLEADTIME                , \r\n");
        sql.append("  FEFFECTIVEDATE          , \r\n");
        sql.append("  FDISABLEDATE            , \r\n");
        sql.append("   FCONSUMEFIXQTY           , \r\n");
        sql.append("   FCONSUMEFIXBASEQTY       , \r\n");
        sql.append("  FCONSUMETYPE              , \r\n");
        sql.append("  FMATERIALINVENTOID      , \r\n");
        sql.append("  FSUPPLYSTORAGEORGUNITID , \r\n");
        sql.append("  FOUTPUTTYPE              , \r\n");
        sql.append("  FPROVIDETYPE              , \r\n");
        sql.append("  FISSMODE                 , \r\n");
        sql.append("  FDEFAULTWAREHOUSEID     , \r\n");
        sql.append("  FPRODUCTRATE             , \r\n");
        sql.append("  FMATERIALCHAR             , \r\n");
        sql.append("  FBASERATE                , \r\n");
        sql.append("  FBASEPRODUCTRATE         , \r\n");
        sql.append("  FBLUEPRINT_L1            , \r\n");
        sql.append("  FBLUEPRINT_L2            , \r\n");
        sql.append("  FBLUEPRINT_L3            , \r\n");
        sql.append("  FREPLACEMODE             , \r\n");
        sql.append("  FSOURCEENTRYID          , \r\n");
        sql.append("  FISASSIGNED              , \r\n");
        sql.append("  FQCCERTIFICATE           , \r\n");
        sql.append("  FBLKSIZE                 , \r\n");
        sql.append("  FSPECIFIEDLENGTH         , \r\n");
        sql.append("  FUSEDUNITID             , \r\n");
        sql.append("  FDESIGNUNITID           , \r\n");
        sql.append("  FDESIGNREMARK            , \r\n");
        sql.append("  FFETURE                  , \r\n");
        sql.append("  FFIRSTCFG                , \r\n");
        sql.append("  FCANSELECTED             , \r\n");
        sql.append("  FMATERIALPROP             , \r\n");
        sql.append("  FSHOWPROJECT             , \r\n");
        sql.append("  FSHOWTRACK               , \r\n");
        sql.append("  FNETWEIGHT               , \r\n");
        sql.append("  FLOCATIONID             , \r\n");
        sql.append("  FISSTOCKTRANSFER         , \r\n");
        sql.append("  FTRANSFERORGUNITID      , \r\n");
        sql.append("  FTRANSFERWAREHOUSEID    , \r\n");
        sql.append("  FMATERIALID             , \r\n");
        sql.append("  FISBACKFLUSH             , \r\n");
        sql.append("  FASSISTPROPERTYID       , \r\n");
        sql.append("  FUNITID                 , \r\n");
        sql.append("  FSOURCEBILLID           , \r\n");
        sql.append("  FSOURCEBILLNUMBER        , \r\n");
        sql.append("  FSOURCEBILLENTRYID      , \r\n");
        sql.append("  FSOURCEBILLENTRYSEQ      , \r\n");
        sql.append("  FASSCOEFFICIENT          , \r\n");
        sql.append("  FBASESTATUS             , \r\n");
        sql.append("  FASSOCIATEQTY            , \r\n");
        sql.append("  FSOURCEBILLTYPEID       , \r\n");
        sql.append("  FBASEUNITID             , \r\n");
        sql.append("  FASSISTUNITID           , \r\n");
        sql.append("  FREMARK                  , \r\n");
        sql.append("  FREASONCODEID           , \r\n");
        sql.append("  FSEQ                    , \r\n");
        sql.append("  FID                      , \r\n");
        sql.append("  FOPERATIONNO             , \r\n");
        sql.append("  FRESERVATIONBILLOBJECTID, \r\n");
        sql.append("  FRESERVATIONID           , \r\n");
        sql.append("  FFIXSEQ                  , \r\n");
        sql.append("  FBEGINCARNOID           , \r\n");
        sql.append("  FENDCARNOID             , \r\n");
        sql.append("  FBOMFLOW                 , \r\n");
        sql.append("  FGTMENO                  , \r\n");
        sql.append("  FSOURCEPROCESS           , \r\n");
        sql.append("  FSOURCEPROCESSID         , \r\n");
        sql.append("  FSUPPLIERID             , \r\n");
        sql.append("  '").append(currentUserInfo.getId()).append("'  as fbaker ,      \r\n");
        sql.append("  sysdate as fbakdate        \r\n");
        sql.append(" from t_mm_bomentry d \r\n");
        sql.append(" where d.fparentid = ? \r\n");
        sql.append("  and not exists(select  1 from t_mm_bomentry_CUTBAK dc where dc.fid = d.fid ) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
        sql.setLength(0);
        sql.append(" Insert Into T_MM_ORDERBOMPT_CUTBAK \r\n");
        sql.append(" ( \r\n");
        sql.append("   FPROJECTID , \r\n");
        sql.append("   FORDERID   , \r\n");
        sql.append("   FTRACKID   , \r\n");
        sql.append("   FID        , \r\n");
        sql.append("   FBAKER     , \r\n");
        sql.append("  FBAKDATE    \r\n");
        sql.append(" ) \r\n");
        sql.append(" Select \r\n");
        sql.append("   FPROJECTID , \r\n");
        sql.append("   FORDERID   , \r\n");
        sql.append("   FTRACKID   , \r\n");
        sql.append("   FID        , \r\n");
        sql.append("  '").append(currentUserInfo.getId()).append("'  as fbaker ,      \r\n");
        sql.append("  sysdate as fbakdate        \r\n");
        sql.append(" from T_MM_ORDERBOMPT a \r\n");
        sql.append(" where a.FORDERID = ? \r\n");
        sql.append("  and not exists(select  1 from T_MM_ORDERBOMPT_CUTBAK ac where ac.FID = a.FID ) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomid});
    }
}

