/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.mo.app.ManufactureOrderStockProcess;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IMaterialReqBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.EngineeringChangeFormMaterialAudit;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class SubMaterialListProcess {
    public static SubMaterialListInfo subQty(Context ctx, SubMaterialListInfo info, BigDecimal subQty, boolean isAutoDelSubMaterial) throws BOSException, EASBizException {
        if (subQty == null || subQty.compareTo(BigDecimal.ZERO) <= 0) {
            return info;
        }
        if (info == null) {
            return info;
        }
        boolean isSubAll = false;
        boolean isSubAllentry = false;
        if (subQty.compareTo(info.getQty()) >= 0) {
            isSubAll = true;
        }
        IRowSet rs = null;
        IRowSet rs2 = null;
        StringBuilder sql = new StringBuilder();
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        IMaterialReqBillEntry iMrqEntry = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
        boolean outHasNext = false;
        try {
            if (info != null && info.getId() != null) {
                BigDecimal fNextBillAllQty = BigDecimal.ZERO;
                rs = SubMaterialListProcess.getNextBill(ctx, info);
                while (rs.next()) {
                    fNextBillAllQty = fNextBillAllQty.add(rs.getBigDecimal("fqty"));
                }
                if (fNextBillAllQty == null) {
                    fNextBillAllQty = BigDecimal.ZERO;
                }
                BigDecimal fsyQty = null;
                BigDecimal thisSubQty = new BigDecimal(0);
                fsyQty = info.getQty().compareTo(fNextBillAllQty.add(subQty)) >= 0 ? BigDecimal.ZERO : subQty.add(fNextBillAllQty).subtract(info.getQty());
                if (fsyQty.compareTo(BigDecimal.ZERO) > 0) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        if (rs.getString("fbasestatus").equals("4")) continue;
                        String fid = rs.getString("fid");
                        String fentryid = rs.getString("fentryid");
                        String ftype = rs.getString("ftype");
                        BigDecimal fqty = rs.getBigDecimal("fqty");
                        isSubAllentry = false;
                        if (isSubAll) {
                            isSubAllentry = true;
                        }
                        if (!isSubAll && fsyQty.compareTo(BigDecimal.ZERO) > 0) {
                            if (fsyQty.compareTo(fqty) <= 0) {
                                thisSubQty = fsyQty;
                                fsyQty = BigDecimal.ZERO;
                            } else {
                                thisSubQty = fqty;
                                fsyQty = fsyQty.subtract(fqty);
                            }
                            if (thisSubQty.compareTo(fqty) >= 0) {
                                isSubAllentry = true;
                            } else {
                                sql.setLength(0);
                                if (ftype.equals("MRQBILL")) {
                                    sql.append(" update t_im_materialreqbillentry ");
                                    sql.append(" set fissueqty = fissueqty - ").append(thisSubQty).append("");
                                    sql.append(" , fbaseissueqty = fbaseissueqty - ").append(thisSubQty).append("");
                                    sql.append(" , fqty = fqty - ").append(thisSubQty).append("");
                                    sql.append(" , fbaseqty = fbaseqty - ").append(thisSubQty).append("");
                                    sql.append(" where fid = '").append(fentryid).append("'");
                                    DbUtil.execute((Context)ctx, (String)sql.toString());
                                }
                            }
                        }
                        if (!isSubAllentry) continue;
                        sql.setLength(0);
                        if (!ftype.equals("MRQBILL")) continue;
                        sql.append(" select fid from t_im_materialreqbillentry where fparentid = '").append(fid).append("'");
                        rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        if (rs2 != null && rs2.size() > 1) {
                            iMrqEntry.delete((IObjectPK)new ObjectUuidPK(fentryid));
                            continue;
                        }
                        iMrq.delete((IObjectPK)new ObjectUuidPK(fid));
                    }
                }
                if (fsyQty.compareTo(BigDecimal.ZERO) > 0) {
                    rs.beforeFirst();
                    SubMaterialListProcess.unNextBill(ctx, info, rs, isSubAll, fsyQty);
                }
            }
            if (info.get("onlyDelNextBill") != null && ((Boolean)info.get("onlyDelNextBill")).booleanValue()) {
                return info;
            }
            info.setQty(info.getQty().subtract(subQty));
            info.setBaseQty(info.getBaseQty().subtract(subQty));
            info.setAssociateQty(info.getQty());
            info.setStandardQty(info.getStandardQty().subtract(subQty));
            info.setUnIssueQty(info.getQty().subtract(info.getTotalIssueQty()));
            info.setUnIssueBaseQty(info.getQty().subtract(info.getTotalIssueBaseQty()));
            if (info.getQty().compareTo(BigDecimal.ZERO) > 0 || outHasNext) {
                info.put("isallowdel", (Object)false);
            } else {
                if (isAutoDelSubMaterial && info != null && info.getId() != null && info.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                    sql.setLength(0);
                    sql.append(" delete from t_sm_submateriallist where fid = '").append(info.getId()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    return null;
                }
                info.put("isallowdel", (Object)true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return info;
    }

    protected static void unNextBill(Context ctx, SubMaterialListInfo info, IRowSet rs, boolean isSubAll, BigDecimal subQty) throws BOSException, EASBizException {
        if (rs == null || rs.size() < 1) {
            return;
        }
        try {
            while (rs.next()) {
                if (!rs.getString("fbasestatus").equals("4")) continue;
                String fid = rs.getString("fid");
                String fentryid = rs.getString("fentryid");
                BigDecimal funQty = rs.getBigDecimal("fqty");
                String ftype = rs.getString("ftype");
                BigDecimal thisunQty = new BigDecimal(0);
                if (!isSubAll) {
                    if (subQty.compareTo(BigDecimal.ZERO) <= 0) break;
                    if (subQty.compareTo(funQty) > 0) {
                        thisunQty = funQty;
                        subQty = subQty.subtract(funQty);
                    } else {
                        thisunQty = subQty;
                        subQty = BigDecimal.ZERO;
                    }
                } else {
                    thisunQty = funQty;
                }
                if (!ftype.equals("MRQBILL")) continue;
                SubMaterialListProcess.createRetMaterialReqBill(ctx, fid, fentryid, thisunQty, info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
    }

    protected static void createRetMaterialReqBill(Context ctx, String fbillid, String fbillentryid, BigDecimal fRetqty, SubMaterialListInfo smlInfo) throws BOSException, EASBizException {
        if (fbillid == null || "".equals(fbillid)) {
            return;
        }
        if (fbillentryid == null || "".equals(fbillentryid)) {
            return;
        }
        if (fRetqty == null || fRetqty.compareTo(new BigDecimal(0)) <= 0) {
            return;
        }
        BigDecimal fqty = fRetqty.multiply(new BigDecimal(-1));
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        MaterialReqBillInfo info = iMrq.getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(fbillid));
        MaterialReqBillEntryInfo entryInfo = null;
        if (info.getEntry() != null && info.getEntry().size() > 0) {
            for (int i = 0; i < info.getEntry().size(); ++i) {
                if (!info.getEntry().get(i).getId().toString().equals(fbillentryid)) continue;
                entryInfo = info.getEntry().get(i);
                break;
            }
        }
        if (entryInfo == null) {
            return;
        }
        MaterialReqBillInfo copyinfo = (MaterialReqBillInfo)info.clone();
        BOSUuid reqid = BOSUuid.create((String)"500AB75E");
        copyinfo.setId(reqid);
        copyinfo.setBaseStatus(BillBaseStatusEnum.ADD);
        copyinfo.setNumber(null);
        AutoNumberUtil.initNumber(ctx, (IObjectValue)copyinfo);
        copyinfo.setTransactionType(SubMaterialListProcess.getTransactionType_SubOut_Back(ctx));
        copyinfo.setBaseStatus(BillBaseStatusEnum.ADD);
        copyinfo.setSourceBillId(smlInfo.getParent1().getParent().getId().toString());
        copyinfo.setAuditor(null);
        copyinfo.setAuditTime(null);
        copyinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        copyinfo.setCreateTime(new Timestamp(new Date().getTime()));
        copyinfo.getEntry().clear();
        MaterialReqBillEntryInfo copyentryinfo = (MaterialReqBillEntryInfo)entryInfo.clone();
        MaterialReqBillEntryCollection entrycoll = new MaterialReqBillEntryCollection();
        BOSUuid entryid = BOSUuid.create((String)"11774BB4");
        copyentryinfo.setId(entryid);
        copyentryinfo.setQty(fqty);
        copyentryinfo.setIssueQty(fqty);
        copyentryinfo.setBaseIssueQty(fqty);
        entrycoll.add(copyentryinfo);
        copyinfo.put("entry", (Object)entrycoll);
        copyinfo.put("priceInfo", null);
        IObjectPK pk = iMrq.save((CoreBaseInfo)copyinfo);
        SubMaterialListProcess.generateBOTPRelation(ctx, "F99EE589", "500AB75E", smlInfo.getParent1().getParent().getId().toString(), pk.toString());
    }

    protected static void generateBOTPRelation(Context ctx, String sourceBillType, String destBillType, String sourceBillID, String destBillID) throws BOSException, EASBizException {
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        SQLUtils.execute((Context)ctx, (String)EngineeringChangeFormMaterialAudit.sql_BOTPRelation.replace("CURDate()", "now()"), (Object[])new Object[]{sourceBillType, destBillType, sourceBillID, destBillID, curUserID});
    }

    protected static IRowSet getNextBill(Context ctx, SubMaterialListInfo info) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select h.fid as fid,d.fid as fentryid ");
        sql.append(" ,d.fqty  as fqty \r\n ");
        sql.append(" ,'MRQBILL' as ftype,h.fbasestatus \r\n ");
        sql.append(" from t_im_materialreqbill h \r\n ");
        sql.append(" inner join t_im_materialreqbillentry d on h.fid = d.fparentid \r\n ");
        sql.append(" where d.fsourcebillentryid = '").append(info.getId()).append("' \r\n ");
        sql.append(" and h.fbasestatus in(0,1,2,4) \r\n ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    public static TransactionTypeInfo getTransactionType_SubOut_Back(Context ctx) throws BOSException, EASBizException {
        TransactionTypeInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("riType.id", (Object)"u+XTTAQIOU+mpfQuwgYbs69Nlzg="));
        viewInfo.setFilter(filterInfo);
        TransactionTypeCollection coll = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(viewInfo);
        if (coll == null || coll.size() < 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.mo.EMMPROJECTMoResource", (String)"PROJECT_MYZDLTDSCLLDSWLX", (Locale)ctx.getLocale())));
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).getNumber().equals("443")) continue;
            info = coll.get(i);
            break;
        }
        if (info == null) {
            info = coll.get(0);
        }
        return info;
    }

    public static BigDecimal getbomRateQty(Context ctx, BomInfo bomInfo, SubContractOrderEntryInfo scoeInfo, BomEntryInfo bomentryInfo, BigDecimal foldqty) throws BOSException, EASBizException {
        BigDecimal fnewqty = foldqty;
        if (bomentryInfo != null) {
            if (bomInfo == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("productBaseQty"));
                sic.add(new SelectorItemInfo("productQty"));
                sic.add(new SelectorItemInfo("id"));
                bomInfo = bomentryInfo.getParent();
                bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()), sic);
            }
            BigDecimal FProductQty = bomInfo.getProductQty();
            MeasureUnitInfo productUnitInfo = ManufactureOrderStockProcess.getMPProductUnitInfo((Context)ctx, (String)scoeInfo.getMaterial().getId().toString(), (String)scoeInfo.getBom().getStorageOrgUnit().getId().toString());
            MultiMeasureUnitInfo billMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo((Context)ctx, (String)scoeInfo.getMaterial().getId().toString(), (String)scoeInfo.getUnit().getId().toString());
            MultiMeasureUnitInfo productMultiMeasureUnitInfo = null;
            if (productUnitInfo != null) {
                productMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo((Context)ctx, (String)scoeInfo.getMaterial().getId().toString(), (String)productUnitInfo.getId().toString());
            }
            BigDecimal converRate = new BigDecimal(1);
            if (billMultiMeasureUnitInfo != null && productMultiMeasureUnitInfo != null && billMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate().compareTo(BigDecimal.ZERO) != 0) {
                converRate = billMultiMeasureUnitInfo.getBaseConvsRate().divide(productMultiMeasureUnitInfo.getConversionRate(), 4, 4);
            }
            if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.VariableAmount) && converRate != null) {
                if (FProductQty != null && FProductQty.compareTo(BigDecimal.ZERO) != 0) {
                    fnewqty = new BigDecimal(1).divide(FProductQty, 4, 4).multiply(foldqty).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision());
                }
            } else if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.Proportion) && converRate != null && bomentryInfo.getBaseProductRate() != null && bomentryInfo.getBaseProductRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getBaseRate() != null && bomentryInfo.getBaseRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getProportion() != null) {
                fnewqty = bomInfo.getProductBaseQty().divide(bomentryInfo.getBaseProductRate(), 4, 4).divide(bomentryInfo.getBaseRate(), 4, 4).multiply(bomentryInfo.getProportion().multiply(new BigDecimal(0.01))).divide(bomInfo.getProductQty(), 4, 4).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision());
            }
        }
        return fnewqty;
    }

    public static boolean isNeedAddSubMaterialReqBill(Context ctx, SubContractOrderEntryInfo scoeInfo) throws BOSException, EASBizException {
        return false;
    }

    protected static BigDecimal getConvertRate(Context ctx, SubContractOrderEntryInfo subOrderEntryInfo, SubMaterialListInfo subMaterialInfo) throws BOSException, EASBizException {
        BigDecimal converRate = new BigDecimal(1);
        return converRate;
    }

    public static int getSubMaterialListMaxSeq(Context ctx, String fparentID) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Max(fseq) as fseq from t_sm_submateriallist where fparentid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fparentID});
        if (rs.next()) {
            return rs.getInt("fseq");
        }
        return 0;
    }

    public static int getMaterialPurLeadingTime(Context ctx, String materialID, String orgUnitID) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select (0 - isnull(fpurchasingaheaddate,0)) as fvalue from t_bd_materialinventory where fmaterialid = ? and forgunit = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, materialID});
        if (rs.next()) {
            return rs.getInt("fvalue");
        }
        return 0;
    }

    public static SubMaterialListInfo addSubMaterialListInfo(Context ctx, BomEntryInfo bomentryInfo, SubContractOrderEntryInfo subOrderEntryInfo, BigDecimal updateQty, BigDecimal funitUpdateQty) throws SQLException, EASBizException, BOSException {
        if (bomentryInfo == null) {
            return null;
        }
        SubMaterialListInfo addInfo = new SubMaterialListInfo();
        Timestamp now = new Timestamp(new Date().getTime());
        int fseq = SubMaterialListProcess.getSubMaterialListMaxSeq(ctx, subOrderEntryInfo.getId().toString());
        addInfo.setSeq(++fseq);
        addInfo.setParent1(subOrderEntryInfo);
        BOSUuid id = BOSUuid.create((BOSObjectType)addInfo.getBOSType());
        addInfo.setId(id);
        BigDecimal convertRate = SubMaterialListProcess.getConvertRate(ctx, subOrderEntryInfo, addInfo);
        addInfo.setQty(updateQty);
        addInfo.setBaseQty(updateQty.multiply(convertRate));
        addInfo.setStandardQty(updateQty);
        addInfo.setAssociateQty(updateQty);
        addInfo.setQtyRate(bomentryInfo.getConsumeFixQty());
        addInfo.setBaseQtyRate(bomentryInfo.getConsumeFixBaseQty());
        addInfo.setLossRate(bomentryInfo.getScrapRatio());
        addInfo.setIssuePerson(null);
        addInfo.setAdminOrgUnit(null);
        addInfo.setStorageOrgUnit(bomentryInfo.getSupplyOrgUnit());
        addInfo.setWareHouse(SubMaterialListProcess.getWarehouse(ctx, bomentryInfo));
        addInfo.setIsQtyUnCtrl(false);
        addInfo.setTotalIssueQty(BigDecimal.ZERO);
        addInfo.setTotalIssueBaseQty(BigDecimal.ZERO);
        addInfo.setUnIssueBaseQty(addInfo.getBaseQty().subtract(addInfo.getTotalIssueBaseQty()));
        addInfo.setUnIssueQty(addInfo.getQty().subtract(addInfo.getTotalIssueQty()));
        addInfo.setLossRateExp(MaterialScrapRateExpressionEnum.MUTIPLE);
        addInfo.setTotalIssueReturnQty(BigDecimal.ZERO);
        addInfo.setTotalIssueReturnBaseQty(BigDecimal.ZERO);
        addInfo.setTotalIssueReNeedQty(BigDecimal.ZERO);
        addInfo.setTotalIssueReNeedBaseQty(BigDecimal.ZERO);
        addInfo.setScrapQty(addInfo.getQty().multiply(addInfo.getScrapQty()).divide(new BigDecimal(100), 4));
        addInfo.setMaterial(bomentryInfo.getMaterial());
        addInfo.setUnit(bomentryInfo.getUnit());
        addInfo.setBaseUnit(bomentryInfo.getMaterial().getBaseUnit());
        addInfo.setSourceBillEntryId(null);
        addInfo.setSourceBillEntrySeq(0);
        addInfo.setSourceBillId(null);
        addInfo.setSourceBillNumber(null);
        addInfo.setSourceBillType(null);
        addInfo.setRemark(null);
        Date issueDate = DateUtil.addDay(subOrderEntryInfo.getDeliveryDate(), SubMaterialListProcess.getMaterialPurLeadingTime(ctx, bomentryInfo.getMaterial().getId().toString(), bomentryInfo.getSupplyOrgUnit().getId().toString()));
        addInfo.setIssueDate(issueDate);
        addInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        return addInfo;
    }

    protected static WarehouseInfo getWarehouse(Context ctx, BomEntryInfo bomentryInfo) throws SQLException, EASBizException, BOSException {
        Object minvInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("defaultWarehouse.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bomentryInfo.getSupplyOrgUnit().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)bomentryInfo.getMaterial().getId()));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(sic);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getDefaultWarehouse();
        }
        return null;
    }
}

