/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.netctrl.MutexServiceControlFacadeFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.DesignBomTempBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ConvertStatusEnum;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.IBomConvertLogEntry;
import com.kingdee.eas.zjbom.convert.app.AbstractbomConvertFacadeControllerBean;
import com.kingdee.eas.zjbom.convert.operationTypeEnum;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.process.BomConvertPBomBaseProcess;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBomMiddle_ProcessBom_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBomTemp_Bom_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBomTemp_DesignBom_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBom_Bom_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBom_DesignBomMiddle_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_DesignBom_ProcessBom_Process;
import com.kingdee.eas.zjbom.convert.process.BomConvert_ProcessBom_Bom_Process;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertDesignBomProcess;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertDesignBomTempProcess;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertProcessBomProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditBaseProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditBomCheckDataProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditBomProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditDesignBomCheckDataProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditDesignBomProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditDesignTempBomCheckDataProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditDesignTempBomProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditProcessBomCheckDataProcess;
import com.kingdee.eas.zjbom.convert.process.change.BomChangeAuditProcessBomProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class bomConvertFacadeControllerBean
extends AbstractbomConvertFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.convert.app.bomConvertFacadeControllerBean");
    private static String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";
    private BomConvertLogInfo info = null;
    private IBomConvertLogEntry ibe = null;
    private IBomConvertLog ib = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private long duration = 0L;
    private SelectorItemCollection updateSic = null;
    private Map<String, BomConvertBaseProcess> bomChangeProcessCacheMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BomConvertLogInfo _bomConvert(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null) {
            return null;
        }
        this.ibe = BomConvertLogEntryFactory.getLocalInstance(ctx);
        this.ib = BomConvertLogFactory.getLocalInstance(ctx);
        this.initeBomConvertLogInfo(ctx, dataMap);
        List<String> lockIDList = this.getLockIDList();
        String errorString = null;
        int execOkCount = 0;
        try {
            if (lockIDList != null && lockIDList.size() > 0) {
                MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(lockIDList);
            }
            BomConvertBaseProcess convertProcess = null;
            if (this.info.getOperationType().equals((Object)operationTypeEnum.bomConvert)) {
                convertProcess = this.getBomConvertTypeProcess();
            } else if (this.info.getOperationType().equals((Object)operationTypeEnum.pbomOneKey)) {
                convertProcess = new BomConvertPBomBaseProcess();
            } else if (this.info.getOperationType().equals((Object)operationTypeEnum.bomChange)) {
                this.bomChangeProcessCacheMap = new HashMap<String, BomConvertBaseProcess>();
            }
            ArrayList<String> errorSourceBomIDList = new ArrayList<String>();
            for (int i = 0; i < this.info.getEntrys().size(); ++i) {
                if (this._getConvertStatus(ctx, this.info.getId().toString()).equals((Object)ConvertStatusEnum.STOP)) {
                    this.info.setConvertStatus(ConvertStatusEnum.STOP);
                    BomConvertLogInfo bomConvertLogInfo = this.info;
                    return bomConvertLogInfo;
                }
                BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
                if (entryInfo.getSourceBomID() != null && errorSourceBomIDList != null && errorSourceBomIDList.contains(entryInfo.getSourceBomID())) continue;
                if (entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR)) {
                    errorSourceBomIDList.add(entryInfo.getSourceBomID());
                    continue;
                }
                if (entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ExecuteEnd)) continue;
                this.startTime = System.currentTimeMillis();
                entryInfo.setExecStatus(ExecStatusEnum.Executeing);
                entryInfo.setBeginDate(new Date());
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.updateSic.add(new SelectorItemInfo("beginDate"));
                this.ibe.updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                if (entryInfo.getChildStepID() > 0 && entryInfo.getChildStepID() == 999999) continue;
                if (this.info.getOperationType().equals((Object)operationTypeEnum.bomChange) && entryInfo.getChildStepID() > 0 && entryInfo.getChildStepID() != 999999) {
                    convertProcess = this.getBomChangeBillAuditProcess(entryInfo.getChildStepID());
                }
                try {
                    if (convertProcess != null) {
                        convertProcess.convert(ctx, entryInfo, this.info);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringWriter writer = new StringWriter();
                    e.printStackTrace(new PrintWriter(writer));
                    errorString = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : e.getMessage();
                    if (errorString == null || "".equals(errorString)) {
                        errorString = ResourceBase.getString((String)RESURL, (String)"systemError", (Locale)ctx.getLocale());
                    }
                    entryInfo.setExecResult(errorString);
                    entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execResult"));
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.ibe.updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                    this.ibe.updateErrorStr(writer.toString(), entryInfo.getId().toString());
                }
                if (entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR)) {
                    errorSourceBomIDList.add(entryInfo.getSourceBomID());
                    continue;
                }
                this.endTime = System.currentTimeMillis();
                this.duration = (this.endTime - this.startTime) / 1000L;
                if ((this.endTime - this.startTime) % 1000L > 0L) {
                    ++this.duration;
                }
                entryInfo.setEndDate(new Date());
                entryInfo.setExecTimeLong(Integer.parseInt(String.valueOf(this.duration)));
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execTimeLong"));
                this.updateSic.add(new SelectorItemInfo("endDate"));
                if (entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.Executeing)) {
                    entryInfo.setExecStatus(ExecStatusEnum.ExecuteEnd);
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                }
                this.ibe.updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                if (this.info.getOperationType().equals((Object)operationTypeEnum.bomChange) && entryInfo.getChildStepID() > 0 && entryInfo.getChildStepID() != 999999) {
                    if (!this.isLastChildStepID(ctx, entryInfo, i)) continue;
                    BomConvertLogEntryInfo parentEntryInfo = this.getParentBomConvertLogEntryInfo(ctx, entryInfo);
                    if (parentEntryInfo != null) {
                        parentEntryInfo.setEndDate(new Date());
                        this.duration = DateUtil.dateDiff(parentEntryInfo.getEndDate(), parentEntryInfo.getBeginDate()) / 1000L;
                        parentEntryInfo.setExecTimeLong(Integer.parseInt(String.valueOf(this.duration)));
                        parentEntryInfo.setExecStatus(ExecStatusEnum.ExecuteEnd);
                        parentEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"successful", (Locale)ctx.getLocale()));
                        this.updateSic = new SelectorItemCollection();
                        this.updateSic.add(new SelectorItemInfo("execTimeLong"));
                        this.updateSic.add(new SelectorItemInfo("endDate"));
                        this.updateSic.add(new SelectorItemInfo("execStatus"));
                        this.updateSic.add(new SelectorItemInfo("execResult"));
                        this.ibe.updatePartial((CoreBaseInfo)parentEntryInfo, this.updateSic);
                    }
                    ++execOkCount;
                    continue;
                }
                ++execOkCount;
            }
            if (execOkCount > 0) {
                this.info.setConvertStatus(ConvertStatusEnum.ConvertEnd);
            } else {
                this.info.setConvertStatus(ConvertStatusEnum.ERROR);
            }
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("convertStatus"));
            this.ib.updatePartial((CoreBaseInfo)this.info, this.updateSic);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConvertStatusEnum convertStatus = this._getConvertStatus(ctx, this.info.getId().toString());
            if (!convertStatus.equals((Object)ConvertStatusEnum.STOP)) {
                this.info.setConvertStatus(ConvertStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("convertStatus"));
                this.ib.updatePartial((CoreBaseInfo)this.info, this.updateSic);
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            if (lockIDList != null && lockIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockIDList);
            }
        }
        this.info.setConvertStatus(this.getConvertStatus(ctx, this.info.getId().toString()));
        return this.info;
    }

    protected List<String> getLockIDList() {
        if (this.info == null || this.info.getEntrys() == null || this.info.getEntrys().size() < 1) {
            return null;
        }
        ArrayList<String> lockIDList = new ArrayList<String>();
        for (int i = 0; i < this.info.getEntrys().size(); ++i) {
            BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
            if (entryInfo.getSourceBomID() == null || lockIDList.contains(entryInfo.getSourceBomID())) continue;
            lockIDList.add(entryInfo.getSourceBomID());
        }
        return lockIDList;
    }

    protected void initeBomConvertLogInfo(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap.get("info") == null) {
            return;
        }
        this.info = (BomConvertLogInfo)dataMap.get("info");
        DBOMTypeEnum beforeDBomtype = null;
        if (dataMap.get("beforeDBomtype") != null) {
            beforeDBomtype = (DBOMTypeEnum)((Object)dataMap.get("beforeDBomtype"));
        }
        DBOMTypeEnum afterDBomtype = null;
        if (dataMap.get("afterDBomtype") != null) {
            afterDBomtype = (DBOMTypeEnum)((Object)dataMap.get("afterDBomtype"));
        }
        this.info.setBeforeBomType(beforeDBomtype);
        this.info.setAfterBomType(afterDBomtype);
        this.info.setConvertStatus(ConvertStatusEnum.Converting);
        this.info.setBizDate(new Date());
        AutoNumberUtil.initNumber(ctx, (IObjectValue)this.info, "ControlUnit");
        if (this.info.getId() == null) {
            BomConvertLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.info);
        } else {
            BomConvertLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)this.info);
        }
    }

    protected BomConvertBaseProcess getBomChangeBillAuditProcess(int childStepID) throws BOSException, EASBizException {
        BomChangeAuditBaseProcess convertProcess = null;
        String fkey = null;
        fkey = this.info.getBeforeBomType().getValue() + "_" + childStepID;
        if (this.bomChangeProcessCacheMap != null && this.bomChangeProcessCacheMap.containsKey(fkey)) {
            return this.bomChangeProcessCacheMap.get(fkey);
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            if (childStepID == 1) {
                convertProcess = new BomChangeAuditProcessBomCheckDataProcess();
            }
            if (childStepID == 2) {
                convertProcess = new BomChangeAuditProcessBomProcess();
            }
        } else if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            if (childStepID == 1) {
                convertProcess = new BomChangeAuditBomCheckDataProcess();
            }
            if (childStepID == 2) {
                convertProcess = new BomChangeAuditBomProcess();
            }
        } else if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            if (childStepID == 1) {
                convertProcess = new BomChangeAuditDesignBomCheckDataProcess();
            }
            if (childStepID == 2) {
                convertProcess = new BomChangeAuditDesignBomProcess();
            }
        } else if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom)) {
            if (childStepID == 1) {
                convertProcess = new BomChangeAuditDesignTempBomCheckDataProcess();
            }
            if (childStepID == 2) {
                convertProcess = new BomChangeAuditDesignTempBomProcess();
            }
        }
        this.bomChangeProcessCacheMap.put(fkey, convertProcess);
        return convertProcess;
    }

    protected BomConvertBaseProcess getBomConvertTypeProcess() throws BOSException, EASBizException {
        BomConvertBaseProcess convertProcess = null;
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            convertProcess = new BomConvert_DesignBom_DesignBomMiddle_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            convertProcess = new BomConvert_DesignBom_ProcessBom_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            convertProcess = new BomConvert_DesignBom_Bom_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            convertProcess = new BomConvert_DesignBomMiddle_ProcessBom_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            convertProcess = new BomConvert_ProcessBom_Bom_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            convertProcess = new BomConvert_DesignBomTemp_DesignBom_Process();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom) && this.info.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            convertProcess = new BomConvert_DesignBomTemp_Bom_Process();
        }
        return convertProcess;
    }

    protected BomUnConvertBaseProcess getBomUnConvertProcess() throws BOSException, EASBizException {
        BomUnConvertBaseProcess unConvertProcess = null;
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom)) {
            unConvertProcess = new BomUnConvertDesignBomTempProcess();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            unConvertProcess = new BomUnConvertDesignBomProcess();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom)) {
            unConvertProcess = new BomUnConvertDesignBomTempProcess();
        }
        if (this.info.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            unConvertProcess = new BomUnConvertProcessBomProcess();
        }
        return unConvertProcess;
    }

    @Override
    protected ConvertStatusEnum _getConvertStatus(Context ctx, String fid) throws BOSException {
        Object convertStatusEnum = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" Select Fconvertstatus from T_BCO_BomConvertLog where  fid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fid});
        try {
            if (rs.next()) {
                return ConvertStatusEnum.getEnum(rs.getInt("Fconvertstatus"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected boolean isLastChildStepID(Context ctx, BomConvertLogEntryInfo entryInfo, int i) throws BOSException, EASBizException {
        if (i == this.info.getEntrys().size() - 1) {
            return true;
        }
        BomConvertLogEntryInfo entryInfo2 = this.info.getEntrys().get(i + 1);
        return entryInfo2.getSourceBomID() == null || !entryInfo2.getSourceBomID().equals(entryInfo.getSourceBomID());
    }

    protected BomConvertLogEntryInfo getParentBomConvertLogEntryInfo(Context ctx, BomConvertLogEntryInfo entryInfo) throws BOSException, EASBizException {
        BomConvertLogEntryInfo parentEntryInfo = null;
        for (int i = 0; i < this.info.getEntrys().size(); ++i) {
            parentEntryInfo = this.info.getEntrys().get(i);
            if (parentEntryInfo.getSourceBomID() == null || !parentEntryInfo.getSourceBomID().equals(entryInfo.getSourceBomID()) || parentEntryInfo.getChildStepID() <= 0 || parentEntryInfo.getChildStepID() != 999999) continue;
            return parentEntryInfo;
        }
        return null;
    }

    @Override
    protected void _stopConvert(Context ctx, String fid) throws BOSException, EASBizException {
        if (fid == null || "".equals(fid)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_BCO_BomConvertLog set Fconvertstatus = 3   where  fid = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{fid});
    }

    @Override
    protected IRowSet _getDiff(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null) {
            return null;
        }
        DBOMTypeEnum beforeDBomtype = (DBOMTypeEnum)((Object)dataMap.get("beforeDBomtype"));
        DBOMTypeEnum afterDBomtype = (DBOMTypeEnum)((Object)dataMap.get("afterDBomtype"));
        ArrayList bomIDlist = (ArrayList)dataMap.get("beforeBomIDList");
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignBOM) && afterDBomtype.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            return this.getDiff_DesginBom_DesginBomMiddle(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignBOM) && afterDBomtype.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            return this.getDiff_DesginBom_ProcessBom(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignBOM) && afterDBomtype.equals((Object)DBOMTypeEnum.MfgBom)) {
            return this.getDiff_DesginBom_Bom(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignBomMiddle) && afterDBomtype.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            return this.getDiff_DesginBomMiddle_ProcessBom(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.ProcessBOM) && afterDBomtype.equals((Object)DBOMTypeEnum.MfgBom)) {
            return this.getDiff_ProcessBom_Bom(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignTempBom) && afterDBomtype.equals((Object)DBOMTypeEnum.DesignBOM)) {
            return this.getDiff_DesginTempBom_DesginBom(ctx, bomIDlist);
        }
        if (beforeDBomtype.equals((Object)DBOMTypeEnum.DesignTempBom) && afterDBomtype.equals((Object)DBOMTypeEnum.MfgBom)) {
            return this.getDiff_DesginTempBom_Bom(ctx, bomIDlist);
        }
        return null;
    }

    protected IRowSet getDiff_DesginBom_DesginBomMiddle(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.cfparentno as parentmaterialnumber,  \r\n");
        sql.append(" sbom.cfparentname as parentmaterialname, \r\n");
        sql.append(" sbom.cfpartno as materialnumber, \r\n");
        sql.append(" sbom.cfname as materialname, \r\n");
        sql.append(" sbom.cfcz as model, \r\n");
        sql.append(" sbom.cfunit as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.cfquantity,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(tbom.cfquantity) from ct_zjb_designbommiddlebill tbom \r\n");
        sql.append(" where tbom.cfparentno = sbom.cfparentno \r\n");
        sql.append(" and tbom.cfportno = sbom.cfpartno \r\n");
        sql.append(" and tbom.fsourcebillid = sbom.fid \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from ct_zjb_designbombill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.cfprojectid \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.cferpbatchno1id \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.cferpbatchno2id \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_DesginBom_ProcessBom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.cfparentno as parentmaterialnumber,  \r\n");
        sql.append(" sbom.cfparentname as parentmaterialname, \r\n");
        sql.append(" sbom.cfpartno as materialnumber, \r\n");
        sql.append(" sbom.cfname as materialname, \r\n");
        sql.append(" sbom.cfcz as model, \r\n");
        sql.append(" sbom.cfunit as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.cfquantity,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(tbom.cfration) from ct_zjb_processbombill tbom \r\n");
        sql.append(" where tbom.cfparentno = sbom.cfparentno \r\n");
        sql.append(" and tbom.cfportno = sbom.cfpartno \r\n");
        sql.append(" and tbom.fsourcebillid = sbom.fid \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from ct_zjb_designbombill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.cfprojectid \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.cferpbatchno1id \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.cferpbatchno2id \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_DesginBom_Bom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.cfparentno as parentmaterialnumber,  \r\n");
        sql.append(" sbom.cfparentname as parentmaterialname, \r\n");
        sql.append(" sbom.cfpartno as materialnumber, \r\n");
        sql.append(" sbom.cfname as materialname, \r\n");
        sql.append(" sbom.cfcz as model, \r\n");
        sql.append(" sbom.cfunit as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.cfquantity,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(d.fconsumefixqty) \r\n");
        sql.append(" from t_mm_bom h \r\n");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid \r\n");
        sql.append(" inner join t_bd_material pm on pm.fid = h.fmaterialid \r\n");
        sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid \r\n");
        sql.append(" where pm.fnumber = sbom.cfparentno \r\n");
        sql.append(" and m.fnumber = sbom.cfpartno \r\n");
        sql.append(" and h.fdesignModeID = sbom.fdesignmodeid \r\n");
        sql.append(" and h.fstorageorgunitid = sbom.fstorageorgunitid \r\n");
        sql.append(" and d.fsupplystorageorgunitid = sbom.fsupplyorgunitid \r\n");
        sql.append(" and ((h.fdesignModeID in('").append("ySgAAAADJLbK0P+Y").append("','").append("ySgAAAADJLDK0P+Y").append("') and  \r\n");
        sql.append(" h.fprojectid = sbom.cfprojectid) \r\n");
        sql.append(" or (h.fdesignModeID in('").append("ySgAAAADJLnK0P+Y").append("','").append("ySgAAAADJLDK0P+Y").append("') and  \r\n");
        sql.append(" d.fbegincarnoid = sbom.cferpbatchno1id and d.fendcarnoid = sbom.cferpbatchno2id)  \r\n");
        sql.append(" or h.fdesignModeID = '").append("ySgAAAADJLPK0P+Y").append("'  \r\n");
        sql.append(" ) \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from ct_zjb_designbombill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.cfprojectid \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.cferpbatchno1id \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.cferpbatchno2id \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_DesginTempBom_DesginBom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.FPMaterialNumber as parentmaterialnumber,  \r\n");
        sql.append(" sbom.FPMaterialName as parentmaterialname, \r\n");
        sql.append(" sbom.FMaterialNumber as materialnumber, \r\n");
        sql.append(" sbom.FMaterialName as materialname, \r\n");
        sql.append(" sbom.FMaterialModel as model, \r\n");
        sql.append(" sbom.FUnitName as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.FQty,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(tbom.cfquantity) from ct_zjb_designbombill tbom \r\n");
        sql.append(" where tbom.cfparentno = sbom.FPMaterialNumber \r\n");
        sql.append(" and tbom.cfpartno = sbom.FMaterialNumber \r\n");
        sql.append(" and tbom.fsourcebillid = isnull(sbom.fsourcebillid,sbom.fid) \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from T_ZJB_DesignBomTempBill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.FProjectID \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.FBTrackNumberID \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.FETrackNumberID \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_DesginTempBom_Bom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.FPMaterialNumber as parentmaterialnumber,  \r\n");
        sql.append(" sbom.FPMaterialName as parentmaterialname, \r\n");
        sql.append(" sbom.FMaterialNumber as materialnumber, \r\n");
        sql.append(" sbom.FMaterialName as materialname, \r\n");
        sql.append(" sbom.FMaterialModel as model, \r\n");
        sql.append(" sbom.FUnitName as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.FQty,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(d.fconsumefixqty) \r\n");
        sql.append(" from t_mm_bom h \r\n");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid \r\n");
        sql.append(" inner join t_bd_material pm on pm.fid = h.fmaterialid \r\n");
        sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid \r\n");
        sql.append(" where pm.fnumber = sbom.FPMaterialNumber \r\n");
        sql.append(" and m.fnumber = sbom.FMaterialNumber \r\n");
        sql.append(" and d.fsourcebillentryid = sbom.fid \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from T_ZJB_DesignBomTempBill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.FProjectID \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.FBTrackNumberID \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.FETrackNumberID \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_DesginBomMiddle_ProcessBom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.cfparentno as parentmaterialnumber,  \r\n");
        sql.append(" sbom.cfparentname as parentmaterialname, \r\n");
        sql.append(" sbom.cfportno as materialnumber, \r\n");
        sql.append(" sbom.cfname as materialname, \r\n");
        sql.append(" sbom.cfcz as model, \r\n");
        sql.append(" sbom.cfunit as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append(" bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.cfration,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(tbom.cfration) from ct_zjb_processbombill tbom \r\n");
        sql.append(" where tbom.cfparentno = sbom.cfparentno \r\n");
        sql.append(" and tbom.cfportno = sbom.cfportno \r\n");
        sql.append(" and isnull(tbom.cfprojectid,'*') = isnull(sbom.cfprojectid,'*') \r\n");
        sql.append(" and isnull(tbom.cfbegincarnoid,'*') = isnull(sbom.cfbegincarnoid,'*') \r\n");
        sql.append(" and isnull(tbom.cfendcarnoid,'*') = isnull(sbom.cfendcarnoid,'*')),0) as afterqty \r\n");
        sql.append(" from ct_zjb_designbommiddlebill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.cfprojectid \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.cfbegincarnoid \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.cfendcarnoid \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getDiff_ProcessBom_Bom(Context ctx, List<String> bomIDlist) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" select sbom.cfparentno as parentmaterialnumber,  \r\n");
        sql.append(" sbom.cfparentname as parentmaterialname, \r\n");
        sql.append(" sbom.cfportno as materialnumber, \r\n");
        sql.append(" sbom.cfname as materialname, \r\n");
        sql.append(" sbom.cfcz as model, \r\n");
        sql.append(" sbom.cfunit as unitname, \r\n");
        sql.append(" p.fnumber as projectnumber, \r\n");
        sql.append(" p.fname_l2 as projectname, \r\n");
        sql.append("  bt.fnumber as begintracknumber, \r\n");
        sql.append(" et.fnumber as endtracknumber, \r\n");
        sql.append(" isnull(sbom.cfration,0) as beforeqty, \r\n");
        sql.append(" isnull((Select sum(d.fconsumefixqty) \r\n");
        sql.append(" from t_mm_bom h \r\n");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid \r\n");
        sql.append(" inner join t_bd_material pm on pm.fid = h.fmaterialid \r\n");
        sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid \r\n");
        sql.append(" where pm.fnumber = sbom.cfparentno \r\n");
        sql.append(" and m.fnumber = sbom.cfportno \r\n");
        sql.append(" and h.fdesignModeID = sbom.fdesignModeID \r\n");
        sql.append(" and h.fstorageorgunitid = sbom.cfstorageorgunitid \r\n");
        sql.append(" and d.fsupplystorageorgunitid = sbom.cfdrawbillorgid \r\n");
        sql.append(" and ((h.fdesignModeID in('").append("ySgAAAADJLbK0P+Y").append("','").append("ySgAAAADJLDK0P+Y").append("') and  \r\n");
        sql.append(" h.fprojectid = sbom.cfprojectid) \r\n");
        sql.append(" or (h.fdesignModeID in('").append("ySgAAAADJLnK0P+Y").append("','").append("ySgAAAADJLDK0P+Y").append("') and  \r\n");
        sql.append(" d.fbegincarnoid = sbom.cfbegincarnoid and d.fendcarnoid = sbom.cfendcarnoid)  \r\n");
        sql.append(" or h.fdesignModeID = '").append("ySgAAAADJLPK0P+Y").append("'  \r\n");
        sql.append(" ) \r\n");
        sql.append(" ),0) as afterqty \r\n");
        sql.append(" from ct_zjb_processbombill sbom \r\n");
        sql.append(" left outer join t_mm_project p on p.fid = sbom.cfprojectid \r\n");
        sql.append(" left outer join t_mm_tracknumber bt on bt.fid = sbom.cfbegincarnoid \r\n");
        sql.append(" left outer join t_mm_tracknumber et on et.fid = sbom.cfendcarnoid \r\n");
        sql.append(" where sbom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDlist.toArray())).append(") \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected BomConvertLogInfo _unbomConvert(Context ctx, Map dataMap) throws BOSException, EASBizException {
        block10: {
            if (dataMap == null) {
                return null;
            }
            this.ibe = BomConvertLogEntryFactory.getLocalInstance(ctx);
            this.ib = BomConvertLogFactory.getLocalInstance(ctx);
            this.initeBomConvertLogInfo(ctx, dataMap);
            try {
                BomUnConvertBaseProcess unConvertProcess = this.getBomUnConvertProcess();
                for (int i = 0; i < this.info.getEntrys().size(); ++i) {
                    if (this._getConvertStatus(ctx, this.info.getId().toString()).equals((Object)ConvertStatusEnum.STOP)) {
                        this.info.setConvertStatus(ConvertStatusEnum.STOP);
                        return this.info;
                    }
                    BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
                    if (entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR) || entryInfo.getExecStatus() != null && entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ExecuteEnd)) continue;
                    this.startTime = System.currentTimeMillis();
                    entryInfo.setExecStatus(ExecStatusEnum.Executeing);
                    entryInfo.setBeginDate(new Date());
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.updateSic.add(new SelectorItemInfo("beginDate"));
                    this.ibe.updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                    try {
                        if (unConvertProcess != null) {
                            unConvertProcess.unConvert(ctx, entryInfo, this.info);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        StringWriter writer = new StringWriter();
                        e.printStackTrace(new PrintWriter(writer));
                        String errorString = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : e.getMessage();
                        if (errorString == null || "".equals(errorString)) {
                            errorString = ResourceBase.getString((String)RESURL, (String)"systemError", (Locale)ctx.getLocale());
                        }
                        entryInfo.setExecResult(errorString);
                        entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                        this.updateSic = new SelectorItemCollection();
                        this.updateSic.add(new SelectorItemInfo("execResult"));
                        this.updateSic.add(new SelectorItemInfo("execStatus"));
                        BomConvertLogEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                        BomConvertLogEntryFactory.getLocalInstance(ctx).updateErrorStr(writer.toString(), entryInfo.getId().toString());
                    }
                    this.endTime = System.currentTimeMillis();
                    this.duration = (this.endTime - this.startTime) / 1000L;
                    if ((this.endTime - this.startTime) % 1000L > 0L) {
                        ++this.duration;
                    }
                    entryInfo.setEndDate(new Date());
                    entryInfo.setExecTimeLong(Integer.parseInt(String.valueOf(this.duration)));
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execTimeLong"));
                    this.updateSic.add(new SelectorItemInfo("endDate"));
                    this.ibe.updatePartial((CoreBaseInfo)entryInfo, this.updateSic);
                }
                this.info.setConvertStatus(ConvertStatusEnum.ConvertEnd);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("convertStatus"));
                this.ib.updatePartial((CoreBaseInfo)this.info, this.updateSic);
            }
            catch (Exception e) {
                e.printStackTrace();
                ConvertStatusEnum convertStatus = this._getConvertStatus(ctx, this.info.getId().toString());
                if (convertStatus.equals((Object)ConvertStatusEnum.STOP)) break block10;
                this.info.setConvertStatus(ConvertStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("convertStatus"));
                this.ib.updatePartial((CoreBaseInfo)this.info, this.updateSic);
                throw new BOSException((Throwable)e);
            }
        }
        this.info.setConvertStatus(this.getConvertStatus(ctx, this.info.getId().toString()));
        return this.info;
    }

    @Override
    protected boolean _convertRequired(Context ctx, CoreBillBaseInfo corebillbaseinfo, BomConvertLogInfo bomConvertLogInfo, BomConvertLogEntryInfo bomConvertLogEntryInfo) throws BOSException, EASBizException {
        if (bomConvertLogInfo == null) {
            DBOMTypeEnum afterConvertType = null;
            if (corebillbaseinfo != null && corebillbaseinfo instanceof DesignBOMBillInfo) {
                afterConvertType = ((DesignBOMBillInfo)corebillbaseinfo).getConvertBomType();
                if (afterConvertType != null && afterConvertType.equals((Object)DBOMTypeEnum.MfgBom)) {
                    BomConvert_DesignBom_Bom_Process.convertBom(ctx, (DesignBOMBillInfo)corebillbaseinfo, null, null);
                }
            } else if (corebillbaseinfo != null && corebillbaseinfo instanceof DesignBomTempBillInfo && (afterConvertType = ((DesignBomTempBillInfo)corebillbaseinfo).getConvertBomType()) != null && afterConvertType.equals((Object)DBOMTypeEnum.MfgBom)) {
                BomConvert_DesignBomTemp_Bom_Process.convertBom(ctx, (DesignBomTempBillInfo)corebillbaseinfo, null, null);
            }
        } else if (bomConvertLogInfo.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM) && bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            BomConvert_ProcessBom_Bom_Process.convertBom(ctx, (ProcessBomBillInfo)corebillbaseinfo, bomConvertLogInfo, bomConvertLogEntryInfo);
        } else if (bomConvertLogInfo.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom) && bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            BomConvert_DesignBomTemp_Bom_Process.convertBom(ctx, (DesignBomTempBillInfo)corebillbaseinfo, bomConvertLogInfo, bomConvertLogEntryInfo);
        } else if (bomConvertLogInfo.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM) && bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            BomConvert_DesignBom_Bom_Process.convertBom(ctx, (DesignBOMBillInfo)corebillbaseinfo, bomConvertLogInfo, bomConvertLogEntryInfo);
        }
        return true;
    }

    @Override
    protected boolean _unconvertRequired(Context ctx, CoreBillBaseInfo corebillbaseinfo, BomConvertLogInfo bomconvertloginfo, BomConvertLogEntryInfo bomconvertlogentryinfo) throws BOSException, EASBizException {
        if (bomconvertloginfo.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            BomUnConvertProcessBomProcess.execUnConvert(ctx, (ProcessBomBillInfo)corebillbaseinfo);
        } else if (bomconvertloginfo.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            BomUnConvertDesignBomProcess.execUnConvert(ctx, (DesignBOMBillInfo)corebillbaseinfo);
        } else if (bomconvertloginfo.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom)) {
            BomUnConvertDesignBomTempProcess.execUnConvert(ctx, (DesignBomTempBillInfo)corebillbaseinfo);
        }
        return true;
    }
}

