/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryFactory;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.MainTenanceLevelFactory;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.convert.app.AbstractbomConvertToPBomFacadeControllerBean;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class bomConvertToPBomFacadeControllerBean
extends AbstractbomConvertToPBomFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.convert.app.bomConvertToPBomFacadeControllerBean");
    private static int MAX_BOM_LEVEL = 50;
    private static String RESURL = "com.kingdee.eas.zjbom.convert.BomConvertToPBOMResource";

    @Override
    protected StandardRootingInfo _getDefaultStandardRooting(Context ctx, Map dataMap) throws BOSException, EASBizException {
        StandardRootingInfo stdInfo = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        BomInfo bomInfo = null;
        ProjectInfo projectInfo = null;
        TrackNumberInfo trackNumberInfo = null;
        String storageOrgUnitID = null;
        String materialID = null;
        String projectID = null;
        String trackNumberID = null;
        String fbomID = null;
        SelectorItemCollection sic = null;
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (dataMap.get("fbomID") != null) {
            fbomID = (String)dataMap.get("fbomID");
            sql.setLength(0);
            sql.append(" Select h.fid,h.fmaterialid,h.fstorageorgunitid,h.fprojectid,d.fbegincarnoid as ftrackid ");
            sql.append(" from t_mm_bom h inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fid = ? and rownum = 1 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fbomID});
            try {
                while (rs.next()) {
                    storageOrgUnitID = rs.getString("fstorageorgunitid");
                    materialID = rs.getString("fmaterialid");
                    projectID = rs.getString("fprojectid");
                    trackNumberID = rs.getString("ftrackid");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            if (dataMap.get("stdSic") == null) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
            }
        } else {
            if (dataMap.get("storageOrgUnitInfo") != null) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)dataMap.get("storageOrgUnitInfo");
                storageOrgUnitID = storageOrgUnitInfo.getId().toString();
            }
            if (dataMap.get("bomInfo") != null) {
                bomInfo = (BomInfo)dataMap.get("bomInfo");
                materialID = bomInfo.getMaterial().getId().toString();
            }
            if (dataMap.get("projectInfo") != null) {
                projectInfo = (ProjectInfo)dataMap.get("projectInfo");
                projectID = projectInfo.getId().toString();
            }
            if (dataMap.get("trackNumberInfo") != null) {
                trackNumberInfo = (TrackNumberInfo)dataMap.get("trackNumberInfo");
                trackNumberID = trackNumberInfo.getId().toString();
            }
        }
        if (dataMap.get("stdSic") != null) {
            sic = (SelectorItemCollection)dataMap.get("stdSic");
        }
        String fstdId = null;
        try {
            if (projectID != null && trackNumberID != null) {
                fstdId = this.getfprojectTrackStdID(ctx, materialID, storageOrgUnitID, projectID, trackNumberID);
            }
            if (fstdId == null && projectID != null) {
                fstdId = this.getfprojectTrackStdID(ctx, materialID, storageOrgUnitID, projectID, null);
            }
            if (fstdId == null && trackNumberID != null) {
                fstdId = this.getfprojectTrackStdID(ctx, materialID, storageOrgUnitID, null, trackNumberID);
            }
            if (fstdId == null) {
                fstdId = this.getfprojectTrackStdID(ctx, materialID, storageOrgUnitID, null, null);
            }
            if (fstdId != null) {
                sql.setLength(0);
                sql.append(" Select h.fid,h.fismainrooting,h.fnumber ");
                sql.append(" from t_mm_standardrooting h ");
                sql.append(" where fid = ? ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fstdId});
            } else {
                return null;
            }
            while (rs.next()) {
                fstdId = rs.getString("fid");
                if (fstdId == null || "".equals(fstdId)) continue;
                if (sic == null) {
                    return StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(fstdId));
                }
                return StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(fstdId), sic);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return stdInfo;
    }

    protected String getfprojectTrackStdID(Context ctx, String materialID, String storageOrgUnitID, String projectID, String trackNumberID) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        Object fstdId = null;
        sql.append(" Select h.fid  ");
        sql.append(" from t_mm_standardrooting h ");
        sql.append(" where h.fstatus =  60 ");
        sql.append(" And h.fstorageorgunitid = ? ");
        sql.append(" And h.fmaterialid = ? ");
        if (projectID != null) {
            sql.append(" And h.fid in(Select fparentid from T_MM_StandardRootingProEntry a ");
            sql.append(" where a.Cfprojectid = '" + projectID + "'  ");
            if (trackNumberID != null) {
                sql.append(" and a.Cftracknumberid = '" + trackNumberID + "'  ");
            }
            sql.append(" ) ");
        } else if (trackNumberID != null) {
            sql.append(" And h.fid in( Select fparentid from T_MM_StandardRootingProEntry a ");
            sql.append(" where a.Cftracknumberid = '" + trackNumberID + "'  ");
            sql.append(" ) ");
        }
        sql.append(" order by h.fismainrooting desc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitID, materialID});
        if (rs.next()) {
            return rs.getString("fid");
        }
        return null;
    }

    @Override
    protected IRowSet _getBomDatas(Context ctx, Map dataMap) throws BOSException, EASBizException {
        IRowSet rs = null;
        BomInfo bomInfo = null;
        boolean isExpandAllChild = false;
        if (dataMap.get("bomInfo") != null) {
            bomInfo = (BomInfo)dataMap.get("bomInfo");
            if (bomInfo.getStorageOrgUnit() == null || bomInfo.getBomType() == null || bomInfo.getDesignMode() == null) {
                bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()), this.getBomSic());
            }
        } else {
            return null;
        }
        if (dataMap.get("isExpandAllChild") != null) {
            isExpandAllChild = (Boolean)dataMap.get("isExpandAllChild");
        }
        HashSet storageOrgUnitIDSet = null;
        if (dataMap.get("storageOrgUnitIDSet") != null) {
            storageOrgUnitIDSet = (HashSet)dataMap.get("storageOrgUnitIDSet");
        }
        StringBuilder sql = new StringBuilder();
        String fbomTempTable = null;
        try {
            fbomTempTable = MMUtils.createTmpTable((Context)ctx, (String)this.getReturnTableSQL());
            MMUtils.createTableIndex((Context)ctx, (String)fbomTempTable, (String[])new String[]{"flevel"});
            MMUtils.createTableIndex((Context)ctx, (String)fbomTempTable, (String[])new String[]{"fchildmaterialid,FSupplyStorageOrgUnitID,Fprojectid"});
            this.expandBomTempTable(ctx, bomInfo, fbomTempTable, isExpandAllChild);
            if (isExpandAllChild) {
                if (storageOrgUnitIDSet != null && storageOrgUnitIDSet.size() > 0) {
                    sql.append(" Select distinct fbomid from ").append(fbomTempTable).append(" where fmaterialAttr not in(10020,10040)  ");
                    sql.append(" and fstorageOrgUnitID in (").append(SQLUtil.arrayToString((Object[])storageOrgUnitIDSet.toArray())).append(") ");
                } else {
                    sql.append(" Select h.fid,h.fnumber,h.fmaterialid,h.fprojectid,h.fbomtype,m.fnumber as fmaterialnumber,m.fname_l2 as fmaterialname ");
                    sql.append(" from (Select distinct fbomid from ").append(fbomTempTable).append(" where fmaterialAttr  not in(10020,10040)  ) a ");
                    sql.append(" inner join t_mm_bom h on h.fid = a.fbomid ");
                    sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
                    sql.append(" where h.fstorageOrgunitid = '" + bomInfo.getStorageOrgUnit().getId() + "' ");
                }
            } else {
                sql.append(" Select ");
                sql.append(" a.FChildMaterialID ");
                sql.append(",a.FBaseQty  ");
                if (dataMap.get("stand") == null) {
                    sql.append(",Isnull((Select sum(pd.fconsumequota) from t_mm_pbomentry pd inner join t_mm_pbom ph on ph.fid = pd.fparentid where ph.fbomid = '" + bomInfo.getId() + "' and pd.fbomitemid = a.fbomentryid And pd.fmaterialid = a.FChildMaterialID),0) As FpbomQty ");
                } else {
                    StandardRootingInfo stand = (StandardRootingInfo)dataMap.get("stand");
                    sql.append(",Isnull((Select sum(pd.fconsumequota) from t_mm_pbomentry pd inner join t_mm_pbom ph on ph.fid = pd.fparentid where ph.fbomid = '" + bomInfo.getId() + "' and pd.fbomitemid = a.fbomentryid And pd.fmaterialid = a.FChildMaterialID and ph.FRoutingID = '" + stand.getId().toString() + "'),0) As FpbomQty ");
                }
                sql.append(",a.FSupplyStorageOrgUnitID ");
                sql.append(",a.fmaterialAttr");
                sql.append(",a.flevel");
                sql.append(",a.fparentMaterialid");
                sql.append(",a.fbomnumber");
                sql.append(",a.fprovidetype");
                sql.append(",a.fstorageOrgUnitID");
                sql.append(",a.funitid");
                sql.append(",a.fprojectid");
                sql.append(",a.fbeginTrackNumberID");
                sql.append(",a.fendTrackNumberid");
                sql.append(",a.fbomentryid");
                sql.append(",a.fbomid");
                sql.append(",m.fnumber as fmaterialnumber ");
                sql.append(",m.fname_l2 as fmaterialname");
                sql.append(",m.fmodel as fmodel");
                sql.append(",pm.fnumber as fparentmaterialnumber ");
                sql.append(",pm.fname_l2 as fparentmaterialname");
                sql.append(",p.fnumber as fprojectnumber");
                sql.append(",p.fname_l2 as fprojectname");
                sql.append(",s.fname_l2 as fstorageOrgUnitname");
                sql.append(",s1.fname_l2 as fsupplyOrgUnitname");
                sql.append(",bt.fnumber as fbeginTrackNumber");
                sql.append(",et.fnumber as fendTrackNumber");
                sql.append(",u.fname_l2 as funitname");
                sql.append(",a.FMainTenanceLevelID as FMainTenanceLevelID");
                sql.append(",ml.fname_l2 as FMainTenanceLevelName");
                sql.append(",bd.fissueprop As FissueProp");
                sql.append(" from ").append(fbomTempTable).append(" a ");
                sql.append(" left outer join t_bd_material m on m.fid = a.fchildmaterialid ");
                sql.append(" left outer join t_bd_material pm on pm.fid = a.fparentMaterialid ");
                sql.append(" left outer join t_mm_project p on p.fid = a.Fprojectid ");
                sql.append(" left outer join t_org_storage s on s.fid = a.fstorageOrgUnitID ");
                sql.append(" left outer join t_org_storage s1 on s1.fid = a.FSupplyStorageOrgUnitID ");
                sql.append(" left outer join t_mm_tracknumber bt on bt.fid = a.fbeginTrackNumberID ");
                sql.append(" left outer join t_mm_tracknumber et on et.fid = a.fendTrackNumberID ");
                sql.append(" left outer join t_bd_measureunit u on u.fid = a.funitid ");
                sql.append(" left outer join t_mm_maintenancelevel ml on ml.fid = a.FMainTenanceLevelID ");
                sql.append(" left outer join t_mm_bomentry bd on bd.fid = a.fbomentryid ");
                sql.append(" where a.fmaterialAttr  <> 10020  ");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fbomTempTable != null && !"".equals(fbomTempTable)) {
                MMUtils.releaseTmpTable((Context)ctx, (String)fbomTempTable);
            }
        }
        return rs;
    }

    private String getReturnTableSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table returnTable ( ");
        sb.append("FChildMaterialID varchar(44)");
        sb.append(",FBaseQty NUMERIC(21, 8) ");
        sb.append(",FSupplyStorageOrgUnitID varchar(44)");
        sb.append(",fmaterialAttr INT");
        sb.append(",flevel INT");
        sb.append(",fparentMaterialid varchar(44)");
        sb.append(",fbomnumber varchar(100)");
        sb.append(",fprovidetype INT");
        sb.append(",fstorageOrgUnitID varchar(44)");
        sb.append(",funitid varchar(44)");
        sb.append(",fprojectid VARCHAR(44)  ");
        sb.append(",FMainTenanceLevelID VARCHAR(44)  ");
        sb.append(",fbeginTrackNumberID VARCHAR(44) ");
        sb.append(",fendTrackNumberid VARCHAR(44) ");
        sb.append(",fbomentryid VARCHAR(44) ");
        sb.append(",fbomid VARCHAR(44) ");
        sb.append(")");
        return sb.toString();
    }

    protected String getInsertTableSQL(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append(" FChildMaterialID ");
        sb.append(",FBaseQty  ");
        sb.append(",FSupplyStorageOrgUnitID ");
        sb.append(",fmaterialAttr");
        sb.append(",flevel");
        sb.append(",fparentMaterialid");
        sb.append(",fbomnumber");
        sb.append(",fprovidetype");
        sb.append(",fstorageOrgUnitID");
        sb.append(",funitid");
        sb.append(",fprojectid");
        sb.append(",FMainTenanceLevelID");
        sb.append(",fbeginTrackNumberID");
        sb.append(",fendTrackNumberid");
        sb.append(",fbomentryid");
        sb.append(",fbomid");
        sb.append(")");
        return sb.toString();
    }

    private void expandBomTempTable(Context ctx, BomInfo bomInfo, String fbomExpandTable, boolean isExpandAllChild) throws EASBizException, BOSException, SQLException {
        int effectedRows = 0;
        int level = 0;
        boolean row = false;
        StringBuilder sql = new StringBuilder();
        while (level < MAX_BOM_LEVEL) {
            if (++level >= MAX_BOM_LEVEL - 2) {
                throw new BOSException(ResourceBase.getString((String)RESURL, (String)"BOM_LOOP", (Locale)ctx.getLocale(), (Object[])new String[]{bomInfo.getNumber()}));
            }
            sql.setLength(0);
            sql.append(" ").append(this.getInsertTableSQL(fbomExpandTable)).append(" \r\n");
            if (level == 1) {
                sql.append(" Select\r\n");
                sql.append(" b.fmaterialid FChildMaterialID,\r\n");
                sql.append(" b.FConsumeFixQty As FBaseQty, \r\n");
                sql.append(" b.fsupplystorageorgunitid As  FSupplyStorageOrgUnitID,\r\n");
                if (isExpandAllChild) {
                    sql.append(" ").append(10030).append(" As fmaterialAttr, \r\n");
                } else {
                    sql.append(" b.fmaterialprop As fmaterialAttr, \r\n");
                }
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" a.fmaterialid fparentMaterialid,\r\n");
                sql.append(" a.fnumber fbomnumber,\r\n");
                sql.append(" b.fprovidetype fprovidetype,\r\n");
                sql.append(" a.fstorageorgunitid fstorageOrgUnitID,\r\n");
                sql.append(" b.funitid funitid,\r\n");
                sql.append(" a.fprojectid As fprojectid,\r\n");
                sql.append(" a.FMainTenanceLevelID As FMainTenanceLevelID,\r\n");
                sql.append(" b.fbegincarnoid As fbeginTrackNumberID,\r\n");
                sql.append(" b.fendcarnoid As fendTrackNumberid,\r\n");
                sql.append(" b.fid As fbomentryid, \r\n");
                sql.append(" a.fid As fbomid \r\n");
                sql.append(" From t_mm_bom a  \r\n");
                sql.append(" Inner Join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                sql.append(" Where a.fid = '" + bomInfo.getId() + "'  \r\n");
                sql.append(" AND b.FConsumeFixQty > 0  \r\n");
            } else {
                sql.append(" Select\r\n");
                sql.append(" b.fmaterialid FChildMaterialID,\r\n");
                sql.append(" b.FConsumeFixQty * T.FBaseQty As FBaseQty, \r\n");
                sql.append(" b.fsupplystorageorgunitid As  FSupplyStorageOrgUnitID,\r\n");
                if (isExpandAllChild) {
                    sql.append(" b2.fmaterialprop As fmaterialAttr, \r\n");
                } else {
                    sql.append(" b.fmaterialprop As fmaterialAttr, \r\n");
                }
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" a.fmaterialid fparentMaterialid,\r\n");
                sql.append(" a.fnumber fbomnumber,\r\n");
                sql.append(" b.fprovidetype fprovidetype,\r\n");
                sql.append(" a.fstorageorgunitid fstorageOrgUnitID,\r\n");
                sql.append(" b.funitid funitid,\r\n");
                sql.append(" a.fprojectid As fprojectid,\r\n");
                sql.append(" a.FMainTenanceLevelID As FMainTenanceLevelID,\r\n");
                sql.append(" b.fbegincarnoid As fbeginTrackNumberID,\r\n");
                sql.append(" b.fendcarnoid As fendTrackNumberid,\r\n");
                sql.append(" b.fid As fbomentryid, \r\n");
                sql.append(" a.fid As fbomid  \r\n");
                sql.append(" From ").append(fbomExpandTable).append(" T \r\n");
                sql.append(" Inner Join t_mm_bom a On  a.fmaterialid = T.FChildMaterialID and a.fstorageorgunitid = T.FSupplyStorageOrgUnitID ");
                sql.append(" Inner Join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                sql.append(" Inner Join t_mm_bomentry b2 On T.fbomentryid = b2.fid \r\n");
                sql.append(" Where T.flevel = ").append(level - 1).append("  \r\n");
                if (!isExpandAllChild) {
                    sql.append(" And T.fmaterialAttr = 10020  \r\n");
                }
                sql.append(" AND b.FConsumeFixQty > 0  \r\n");
                sql.append(" AND a.fbasestatus = ").append(4).append("  \r\n");
                sql.append(" AND a.fdesignModeID in ( ").append(SQLUtil.arrayToString((Object[])BomUtil.getAllDesignModeIDList().toArray())).append(" ) \r\n");
                sql.append(" AND (a.fprojectid = T.fprojectid  or  a.fprojectid is null)  \r\n");
                sql.append(" AND (b.fbegincarnoid = T.fbeginTrackNumberID  or  b.fbegincarnoid is null)  \r\n");
                sql.append(" AND isnull(a.FMainTenanceLevelID,'*') = isnull(T.FMainTenanceLevelID,'*') \r\n");
            }
            if ((effectedRows = this.executeSQL(ctx, sql.toString())) > 0) continue;
            break;
        }
    }

    protected int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    @Override
    protected IRowSet _getMRWorkProcessDatas(Context ctx, Map dataMap) throws BOSException, EASBizException {
        IRowSet rs = null;
        StandardRootingInfo stdInfo = null;
        if (dataMap.get("standardRootingInfo") == null) {
            return null;
        }
        stdInfo = (StandardRootingInfo)dataMap.get("standardRootingInfo");
        StringBuilder sql = new StringBuilder();
        sql.append(" Select d.fwpseq, \r\n");
        sql.append(" h.fid as fid, \r\n");
        sql.append(" d.fid as fentryid, \r\n");
        sql.append(" op.fnumber as foperationnumber, \r\n");
        sql.append(" op.fname_l2 as foperationname, \r\n");
        sql.append(" wc.fname_l2 as fworkcentername, \r\n");
        sql.append(" s.fname_l2 as fstorageorgunitname, \r\n");
        sql.append(" d.fentrusttype \r\n");
        sql.append(" from t_mm_standardrooting h \r\n");
        sql.append(" inner join t_mm_materialrwp d on h.fmaterialrootingid = d.fparentid \r\n");
        sql.append(" left outer join t_mm_operation op on op.fid  = d.foperationid \r\n");
        sql.append(" left outer join t_mm_workcenter wc on wc.fid = d.fworkcenterid \r\n");
        sql.append(" left outer join t_org_storage s on s.fid = d.fcoostorageorgunitid \r\n");
        sql.append(" where h.fid = ? ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{stdInfo.getId().toString()});
        return rs;
    }

    protected SelectorItemCollection getPbomSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("bom.id"));
        sic.add(new SelectorItemInfo("bom.number"));
        sic.add(new SelectorItemInfo("bom.productQty"));
        sic.add(new SelectorItemInfo("bom.mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("bom.mainTenanceLevel.name"));
        sic.add(new SelectorItemInfo("routing.id"));
        sic.add(new SelectorItemInfo("routing.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("pbomEntry.*"));
        sic.add(new SelectorItemInfo("pbomEntry.material.id"));
        sic.add(new SelectorItemInfo("pbomEntry.material.number"));
        sic.add(new SelectorItemInfo("pbomEntry.material.name"));
        sic.add(new SelectorItemInfo("pbomEntry.material.model"));
        sic.add(new SelectorItemInfo("pbomEntry.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("pbomEntry.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("pbomEntry.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("pbomEntry.BOM.id"));
        sic.add(new SelectorItemInfo("pbomEntry.BOM.material.id"));
        sic.add(new SelectorItemInfo("pbomEntry.BOM.material.number"));
        sic.add(new SelectorItemInfo("pbomEntry.BOM.material.name"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.id"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.materialProp"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.supplyOrgUnit.id"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.supplyOrgUnit.number"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.supplyOrgUnit.name"));
        sic.add(new SelectorItemInfo("pbomEntry.bomItem.parent.id"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.wpSeq"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.operation.id"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.operation.number"));
        sic.add(new SelectorItemInfo("pbomEntry.routingItem.operation.name"));
        sic.add(new SelectorItemInfo("pbomEntry.sTrace.id"));
        sic.add(new SelectorItemInfo("pbomEntry.sTrace.number"));
        sic.add(new SelectorItemInfo("pbomEntry.sTrace.name"));
        sic.add(new SelectorItemInfo("pbomEntry.eTrace.id"));
        sic.add(new SelectorItemInfo("pbomEntry.eTrace.number"));
        sic.add(new SelectorItemInfo("pbomEntry.eTrace.name"));
        return sic;
    }

    protected SelectorItemCollection getBomSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bomType"));
        sic.add(new SelectorItemInfo("productQty"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        return sic;
    }

    protected SelectorItemCollection getmrwSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("operation.number"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    protected SelectorItemCollection getStandardRootingSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    protected SelectorItemCollection getbomentrySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.bomType"));
        sic.add(new SelectorItemInfo("parent.designMode.*"));
        sic.add(new SelectorItemInfo("parent.mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("parent.material.id"));
        sic.add(new SelectorItemInfo("parent.material.number"));
        sic.add(new SelectorItemInfo("parent.material.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.number"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("supplyOrgUnit.id"));
        sic.add(new SelectorItemInfo("supplyOrgUnit.number"));
        sic.add(new SelectorItemInfo("supplyOrgUnit.name"));
        sic.add(new SelectorItemInfo("beginCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("beginCarno.name"));
        sic.add(new SelectorItemInfo("endCarno.id"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.name"));
        return sic;
    }

    @Override
    protected PBOMInfo _getPBomDatas(Context ctx, Map dataMap) throws BOSException, EASBizException {
        StandardRootingInfo stdInfo = null;
        if (dataMap.get("standardRootingInfo") == null) {
            return null;
        }
        stdInfo = (StandardRootingInfo)dataMap.get("standardRootingInfo");
        BomInfo bomInfo = null;
        if (dataMap.get("bomInfo") == null) {
            return null;
        }
        bomInfo = (BomInfo)dataMap.get("bomInfo");
        boolean notSetOOQty = false;
        if (dataMap.get("notSetOOQty") != null) {
            notSetOOQty = (Boolean)dataMap.get("notSetOOQty");
        }
        PBOMInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bom.id", (Object)bomInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("routing.id", (Object)stdInfo.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getPbomSic());
        CoreBaseCollection pbomCol = PBOMFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (pbomCol.size() > 0 && pbomCol.get(0) != null) {
            info = (PBOMInfo)pbomCol.get(0);
        }
        if (!notSetOOQty) {
            this.setPBomEntryPermission(ctx, info);
            this.setPBomEntryOtherOOQty(ctx, info);
        }
        return info;
    }

    protected void setPBomEntryPermission(Context ctx, PBOMInfo info) throws BOSException, EASBizException {
        if (info != null && info.getPbomEntry() != null && info.getPbomEntry().size() > 0) {
            for (int i = 0; i < info.getPbomEntry().size(); ++i) {
                info.getPbomEntry().get(i).put("isPermission", (Object)true);
            }
        }
    }

    protected void setPBomEntryOtherOOQty(Context ctx, PBOMInfo info) throws BOSException, EASBizException {
        if (info != null && info.getPbomEntry() != null && info.getPbomEntry().size() > 0) {
            String bomitemID = null;
            BigDecimal otherQty = null;
            String routingItemID = null;
            String routingItemID2 = null;
            for (int i = 0; i < info.getPbomEntry().size(); ++i) {
                PBOMEntryInfo entryInfo = info.getPbomEntry().get(i);
                if (entryInfo.getBomItem() == null) continue;
                bomitemID = entryInfo.getBomItem().getId().toString();
                routingItemID = entryInfo.getRoutingItem() != null ? entryInfo.getRoutingItem().getId().toString() : "";
                otherQty = BigDecimal.ZERO;
                for (int j = 0; j < info.getPbomEntry().size(); ++j) {
                    PBOMEntryInfo entryInfo2 = info.getPbomEntry().get(j);
                    if (entryInfo2.getBomItem() == null || !entryInfo2.getBomItem().getId().toString().equals(bomitemID) || routingItemID.equals(routingItemID2 = entryInfo2.getRoutingItem() != null ? entryInfo2.getRoutingItem().getId().toString() : "")) continue;
                    otherQty = otherQty.add(entryInfo2.getConsumeQuota());
                }
                entryInfo.put("otherOOQty", (Object)otherQty);
            }
        }
    }

    @Override
    protected PBOMInfo _addPbomDatas(Context ctx, PBOMInfo pbomInfo, String fmrwID, Map bomQtyMap, String bomID, String stdID) throws BOSException, EASBizException {
        if (bomQtyMap == null || bomQtyMap.size() < 1) {
            return pbomInfo;
        }
        if (fmrwID == null || "".equals(fmrwID)) {
            return pbomInfo;
        }
        if (bomID == null || "".equals(bomID)) {
            return pbomInfo;
        }
        if (pbomInfo == null) {
            BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomID), this.getBomSic());
            StandardRootingInfo stdInfo = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(stdID), this.getStandardRootingSic());
            pbomInfo = this.addPbomInfo(ctx, stdInfo, bomInfo);
        }
        Set set = bomQtyMap.keySet();
        Iterator it = set.iterator();
        int maxSeq = this.getMaxSeqFromPbom(ctx, pbomInfo);
        MRWorkProcesEntryInfo mrwInfo = MRWorkProcesEntryFactory.getLocalInstance((Context)ctx).getMRWorkProcesEntryInfo((IObjectPK)new ObjectUuidPK(fmrwID), this.getmrwSic());
        while (it.hasNext()) {
            String fbomentryID = String.valueOf(it.next());
            BigDecimal addQty = null;
            BigDecimal bomQty = new BigDecimal(bomQtyMap.get(fbomentryID).toString());
            BigDecimal pbomQty = this.getPbomEntryQty(ctx, pbomInfo, fbomentryID);
            if (bomQty.compareTo(BigDecimal.ZERO) <= 0 || (addQty = bomQty.subtract(pbomQty)).compareTo(BigDecimal.ZERO) <= 0) continue;
            PBOMEntryInfo pbomEntryInfo = this.getPbomEntryInfoByBomentryID(ctx, pbomInfo, fbomentryID, fmrwID);
            this.addPbomEntryInfo(ctx, pbomInfo, pbomEntryInfo, addQty, fbomentryID, mrwInfo, ++maxSeq, bomQty);
        }
        this.setPBomEntryPermission(ctx, pbomInfo);
        this.setPBomEntryOtherOOQty(ctx, pbomInfo);
        return pbomInfo;
    }

    protected PBOMInfo addPbomInfo(Context ctx, StandardRootingInfo stdInfo, BomInfo bomInfo) {
        PBOMInfo pbomInfo = new PBOMInfo();
        pbomInfo.setStorageOrgUnit(bomInfo.getStorageOrgUnit());
        pbomInfo.setBom(bomInfo);
        pbomInfo.setProject(bomInfo.getProject());
        pbomInfo.setRouting(stdInfo);
        pbomInfo.setBomType(bomInfo.getBomType());
        pbomInfo.setName(bomInfo.getMaterial().getName());
        return pbomInfo;
    }

    protected int getMaxSeqFromPbom(Context ctx, PBOMInfo pbomInfo) {
        if (pbomInfo == null || pbomInfo.getPbomEntry() == null || pbomInfo.getPbomEntry().size() < 1) {
            return 0;
        }
        int seq = 0;
        for (int i = 0; i < pbomInfo.getPbomEntry().size(); ++i) {
            PBOMEntryInfo pbomentryInfo = pbomInfo.getPbomEntry().get(i);
            if (pbomentryInfo.getSeq() <= seq) continue;
            seq = pbomentryInfo.getSeq();
        }
        return seq;
    }

    protected BigDecimal getPbomEntryQty(Context ctx, PBOMInfo pbomInfo, String fbomnentryID) {
        BigDecimal qty = BigDecimal.ZERO;
        if (pbomInfo == null || pbomInfo.getPbomEntry() == null || pbomInfo.getPbomEntry().size() < 1) {
            return qty;
        }
        for (int i = 0; i < pbomInfo.getPbomEntry().size(); ++i) {
            PBOMEntryInfo pbomentryInfo = pbomInfo.getPbomEntry().get(i);
            if (pbomentryInfo.getBomItem() == null || !pbomentryInfo.getBomItem().getId().toString().equals(fbomnentryID)) continue;
            qty = qty.add(pbomentryInfo.getConsumeQuota());
        }
        return qty;
    }

    protected void addPbomEntryInfo(Context ctx, PBOMInfo pbomInfo, PBOMEntryInfo pbomEntryInfo, BigDecimal addQty, String fbomentryID, MRWorkProcesEntryInfo mrwInfo, int maxSeq, BigDecimal bomQty) throws BOSException, EASBizException {
        BomEntryInfo bomentryInfo = this.getBomEntryInfo(ctx, fbomentryID);
        if (pbomEntryInfo == null) {
            pbomEntryInfo = new PBOMEntryInfo();
            pbomEntryInfo.setId(BOSUuid.create((BOSObjectType)pbomEntryInfo.getBOSType()));
        }
        pbomEntryInfo.setBOM(bomentryInfo.getParent());
        pbomEntryInfo.setSeq(maxSeq);
        pbomEntryInfo.setRoutingItem(mrwInfo);
        if (pbomEntryInfo.getConsumeQuota() == null) {
            pbomEntryInfo.setConsumeQuota(BigDecimal.ZERO);
        }
        pbomEntryInfo.setConsumeQuota(pbomEntryInfo.getConsumeQuota().add(addQty));
        pbomEntryInfo.setConsumeRate("0");
        pbomEntryInfo.setIsMustReq(true);
        pbomEntryInfo.setRemark(null);
        pbomEntryInfo.setBomItem(bomentryInfo);
        pbomEntryInfo.setSTrace(bomentryInfo.getBeginCarno());
        pbomEntryInfo.setETrace(bomentryInfo.getEndCarno());
        pbomEntryInfo.setOrderSeq(bomentryInfo.getFixSeq());
        pbomEntryInfo.setAssembleSeq(bomentryInfo.getFixSeq());
        pbomEntryInfo.setIssueMode(bomentryInfo.getIssMode().getValue());
        pbomEntryInfo.setMaterialAttr(bomentryInfo.getMaterialProp());
        pbomEntryInfo.setMaterial(bomentryInfo.getMaterial());
        pbomEntryInfo.setUnitQty(bomQty);
        pbomEntryInfo.setParent(pbomInfo);
        pbomEntryInfo.setIssueProp(bomentryInfo.getIssueProp());
        pbomInfo.getPbomEntry().add(pbomEntryInfo);
    }

    protected BomEntryInfo getBomEntryInfo(Context ctx, String fbomentryID) throws BOSException, EASBizException {
        BomEntryInfo bomentryInfo = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryInfo((IObjectPK)new ObjectUuidPK(fbomentryID), this.getbomentrySic());
        return bomentryInfo;
    }

    protected PBOMEntryInfo getPbomEntryInfoByBomentryID(Context ctx, PBOMInfo pbomInfo, String fbomentryID, String fmrwID) throws BOSException, EASBizException {
        if (pbomInfo == null || pbomInfo.getPbomEntry() == null || pbomInfo.getPbomEntry().size() < 1) {
            return null;
        }
        for (int i = 0; i < pbomInfo.getPbomEntry().size(); ++i) {
            PBOMEntryInfo pbomentryInfo = pbomInfo.getPbomEntry().get(i);
            if (pbomentryInfo.getBomItem() == null || !pbomentryInfo.getBomItem().getId().toString().equals(fbomentryID) || pbomentryInfo.getRoutingItem() == null || !pbomentryInfo.getRoutingItem().getId().toString().equals(fmrwID)) continue;
            return pbomentryInfo;
        }
        return null;
    }

    @Override
    protected PBOMInfo _saveData(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null || dataMap.get("pbomInfo") == null) {
            return null;
        }
        PBOMInfo pbomInfo = (PBOMInfo)dataMap.get("pbomInfo");
        if (pbomInfo.getNumber() == null) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)pbomInfo);
        }
        if (pbomInfo != null && (pbomInfo.getPbomEntry() == null || pbomInfo.getPbomEntry().size() < 1)) {
            PBOMFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(pbomInfo.getId()));
            pbomInfo = null;
        } else if (pbomInfo.getId() == null) {
            PBOMFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pbomInfo);
        } else {
            PBOMFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)pbomInfo);
        }
        if (pbomInfo != null && pbomInfo.getId() != null) {
            this._addStandardRootingProjTrack(ctx, pbomInfo.getId().toString());
        }
        return pbomInfo;
    }

    @Override
    protected Map _getBomChild(Context ctx, String bomID, String mainOrgUnitID, String trackNumberID, boolean isValidPbom, boolean baseStatusIsAudit) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" Select  ");
        sql.append(" m.fid As fmaterialid ");
        sql.append(" ,m.fnumber As fmaterialnumber ");
        sql.append(" ,m.fname_l2 As fmaterialname ");
        sql.append(" ,d.FSupplyStorageOrgUnitID As fstorageorgunitid ");
        sql.append(" ,s.fname_l2 As fstorageorgunitname ");
        sql.append(" ,d.fmaterialprop As fmaterialAttr ");
        sql.append(" ,h.fprojectid As fprojectid ");
        sql.append(" ,p.fname_l2 As fprojectname ");
        sql.append(" ,p.fnumber As fprojectnumber ");
        sql.append(" ,h.fdesignmodeid as fdesignmodeid ");
        sql.append(" ,h.fbomtype as fbomtype ");
        sql.append(" ,bt.fnumber as fbegintracknumber ");
        sql.append(" ,et.fnumber as fendtracknumber ");
        sql.append(" ,h.FMainTenanceLevelID as FMainTenanceLevelID ");
        sql.append(" from t_mm_bom h \r\n");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid \r\n");
        sql.append(" left outer join  T_ORG_Storage s on s.fid = d.FSupplyStorageOrgUnitID \r\n");
        sql.append(" left outer join  t_bd_material m on m.fid = d.fmaterialid \r\n");
        sql.append(" left outer join  t_mm_project p on p.fid = h.fprojectid \r\n");
        sql.append(" left outer join  t_mm_tracknumber bt on bt.fid = d.fbegincarnoid \r\n");
        sql.append(" left outer join  t_mm_tracknumber et on et.fid = d.fendcarnoid \r\n");
        sql.append(" Where h.fid = ? \r\n");
        sql.append(" Order by m.fnumber \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bomID});
        ArrayList<String> bomIDList = new ArrayList<String>();
        ArrayList dataList = new ArrayList();
        try {
            BomInfo bomInfo = null;
            while (rs.next()) {
                boolean isDesignMode;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("fmaterialid", rs.getString("fmaterialid"));
                dataMap.put("fmaterialnumber", rs.getString("fmaterialnumber"));
                dataMap.put("fmaterialname", rs.getString("fmaterialname"));
                dataMap.put("fstorageorgunitid", rs.getString("fstorageorgunitid"));
                dataMap.put("fstorageorgunitname", rs.getString("fstorageorgunitname"));
                dataMap.put("fmaterialAttr", rs.getString("fmaterialAttr"));
                dataMap.put("fprojectid", rs.getString("fprojectid"));
                dataMap.put("fprojectname", rs.getString("fprojectname"));
                dataMap.put("fprojectnumber", rs.getString("fprojectnumber"));
                dataMap.put("fbegintracknumber", rs.getString("fbegintracknumber"));
                dataMap.put("fendtracknumber", rs.getString("fendtracknumber"));
                dataMap.put("ftrackNumberId", trackNumberID);
                dataMap.put("ftrackNumber", "");
                dataMap.put("ftrackName", "");
                dataMap.put("FMainTenanceLevelID", rs.getString("FMainTenanceLevelID"));
                String fexpandChildTrackNumber = null;
                boolean bl = isDesignMode = rs.getString("fdesignmodeid") != null;
                if (trackNumberID != null && !"".equals(trackNumberID)) {
                    if (trackNumberID.equals("*")) {
                        fexpandChildTrackNumber = null;
                    } else {
                        TrackNumberInfo trackInfo = BomUtil.getTrackNumberInfo(ctx, trackNumberID);
                        dataMap.put("ftrackNumber", trackInfo.getNumber());
                        dataMap.put("ftrackName", trackInfo.getName());
                        fexpandChildTrackNumber = trackInfo.getNumber();
                    }
                } else if (rs.getInt("fbomtype") == 45 && !isDesignMode) {
                    List<TrackNumberInfo> orderTList = BomUtil.getOrderBomTrackNumberInfoList(ctx, bomID);
                    if (orderTList != null && orderTList.size() > 0) {
                        fexpandChildTrackNumber = orderTList.get(0).getNumber();
                        dataMap.put("fbegintracknumber", orderTList.get(0).getNumber());
                        dataMap.put("fendtracknumber", orderTList.get(orderTList.size() - 1).getNumber());
                    }
                } else {
                    fexpandChildTrackNumber = rs.getString("fbegintracknumber");
                }
                bomInfo = this._getBomInfo(ctx, rs.getString("fmaterialid"), rs.getString("fstorageorgunitid"), rs.getString("fprojectid"), fexpandChildTrackNumber, baseStatusIsAudit, isDesignMode, rs.getInt("fbomtype"), rs.getString("FMainTenanceLevelID"));
                if (bomInfo != null) {
                    dataMap.put("fbomid", bomInfo.getId().toString());
                    dataMap.put("fbomtype", bomInfo.getBomType().getValue());
                    dataMap.put("fdesignmode", bomInfo.getDesignMode());
                    dataMap.put("fbomnumber", bomInfo.getNumber());
                    dataMap.put("fmainTenanceLevel", bomInfo.getMainTenanceLevel());
                } else {
                    dataMap.put("fbomid", null);
                }
                if (mainOrgUnitID != null && (rs.getInt("fmaterialAttr") == 10030 || rs.getInt("fmaterialAttr") == 10050) && rs.getString("fstorageorgunitid").equals(mainOrgUnitID) && bomInfo != null) {
                    bomIDList.add(bomInfo.getId().toString());
                }
                dataList.add(dataMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, List> returnMap = new HashMap<String, List>();
        returnMap.put("dataList", dataList);
        if (isValidPbom && bomIDList != null && bomIDList.size() > 0) {
            List pbomValidList = this._validPbom(ctx, bomIDList);
            returnMap.put("pbomNoValidList", pbomValidList);
        }
        return returnMap;
    }

    @Override
    protected List _validPbom(Context ctx, List bomIDList) throws BOSException, EASBizException {
        if (bomIDList == null || bomIDList.size() < 1) {
            return null;
        }
        ArrayList<String> returnIDList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        String fbomTempTable = null;
        try {
            fbomTempTable = this.createBomExpandTemptable(ctx);
            this.expandBomTempTable2(ctx, bomIDList, fbomTempTable);
            sql.setLength(0);
            sql.append(" Select distinct fbomid from ( ");
            sql.append(" Select ");
            sql.append("  Sum(fbomqty) As fbomqty ");
            sql.append(" ,Sum(fpbomqty) As fpbomqty ");
            sql.append(" ,fbomid ");
            sql.append(" ,fbomentryid ");
            sql.append(" from ( ");
            sql.append(" Select ");
            sql.append(" a.FBaseQty As fbomqty  ");
            sql.append(",a.fbomid");
            sql.append(",a.fbomentryid");
            sql.append(",0 As fpbomqty");
            sql.append(",1 As ftype");
            sql.append(" from ").append(fbomTempTable).append(" a \r\n");
            sql.append(" where a.fmaterialAttr <> 10020 \r\n");
            sql.append(" union ");
            sql.append(" Select ");
            sql.append(" 0 As fbomqty  ");
            sql.append(",h.fbomid As fbomid ");
            sql.append(",d.fbomitemid As fbomentryid");
            sql.append(",sum(d.fconsumequota) As fpbomqty");
            sql.append(",2 As ftype");
            sql.append(" from t_mm_pbom h  \r\n");
            sql.append(" inner join t_mm_pbomentry d on h.fid = d.fparentid  \r\n");
            sql.append(" inner join t_mm_bom bh on bh.fid = h.fbomid  \r\n");
            sql.append(" inner join t_mm_standardrooting std on std.fstatus = 60   \r\n");
            sql.append(" And std.fstorageorgunitid = bh.fstorageorgunitid ");
            sql.append(" And std.fmaterialid = bh.fmaterialid ");
            sql.append(" And std.fismainrooting = 1 ");
            sql.append(" where h.fbomid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") \r\n");
            sql.append(" group by h.fbomid,d.fbomitemid \r\n");
            sql.append(" ) bb group by fbomid,fbomentryid \r\n");
            sql.append(" ) cc where cc.fbomqty <> cc.fpbomqty \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                returnIDList.add(rs.getString("fbomid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fbomTempTable != null && !"".equals(fbomTempTable)) {
                MMUtils.releaseTmpTable((Context)ctx, (String)fbomTempTable);
            }
        }
        return returnIDList;
    }

    private String getReturnTableSQL2() {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table returnTable ( ");
        sb.append("FChildMaterialID varchar(44)");
        sb.append(",FBaseQty NUMERIC(21, 8) ");
        sb.append(",FSupplyStorageOrgUnitID varchar(44)");
        sb.append(",fmaterialAttr INT");
        sb.append(",flevel INT");
        sb.append(",fprojectid VARCHAR(44) DEFAULT '*' NOT NULL ");
        sb.append(",FMainTenanceLevelID VARCHAR(44)  ");
        sb.append(",fbomentryid VARCHAR(44) ");
        sb.append(",fbomid VARCHAR(44) ");
        sb.append(")");
        return sb.toString();
    }

    protected String getInsertTableSQL2(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append("FChildMaterialID ");
        sb.append(",FBaseQty  ");
        sb.append(",FSupplyStorageOrgUnitID ");
        sb.append(",fmaterialAttr");
        sb.append(",flevel");
        sb.append(",fprojectid");
        sb.append(",FMainTenanceLevelID");
        sb.append(",fbomentryid");
        sb.append(",fbomid");
        sb.append(")");
        return sb.toString();
    }

    private BOMTypeEnum getBomTypeEnum(Context ctx, String bomID) throws EASBizException, BOSException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(" Select fbomtype from t_mm_bom where fid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{bomID});
        if (rs.next()) {
            return BOMTypeEnum.getEnum((int)rs.getInt("fbomtype"));
        }
        return null;
    }

    private void expandBomTempTable2(Context ctx, List bomIDList, String fbomExpandTable) throws EASBizException, BOSException, SQLException {
        int effectedRows = 0;
        int level = 0;
        boolean row = false;
        StringBuilder sql = new StringBuilder();
        while (level < MAX_BOM_LEVEL) {
            if (++level >= MAX_BOM_LEVEL - 2) {
                throw new BOSException(ResourceBase.getString((String)RESURL, (String)"BOM_LOOP", (Locale)ctx.getLocale(), (Object[])new String[]{""}));
            }
            sql.setLength(0);
            sql.append(" ").append(this.getInsertTableSQL2(fbomExpandTable)).append(" \r\n");
            if (level == 1) {
                sql.append("Select\r\n");
                sql.append(" b.fmaterialid FChildMaterialID,\r\n");
                sql.append(" b.FConsumeFixQty As FBaseQty, \r\n");
                sql.append(" b.fsupplystorageorgunitid As  FSupplyStorageOrgUnitID,\r\n");
                sql.append(" b.fmaterialprop As fmaterialAttr, \r\n");
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" (case a.fdesignModeID when 'ySgAAAADJLDK0P+Y' then isnull(a.fprojectid,'*') when 'ySgAAAADJLbK0P+Y' then isnull(a.fprojectid,'*') else '*' end ) As fprojectid,\r\n");
                sql.append(" a.FMainTenanceLevelID As FMainTenanceLevelID, \r\n");
                sql.append(" b.fid As fbomentryid, \r\n");
                sql.append(" a.fid As fbomid \r\n");
                sql.append(" From t_mm_bom a \r\n");
                sql.append(" inner join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                sql.append(" Where a.fbasestatus = 4  \r\n");
                sql.append(" And a.fid in( ").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(" ) \r\n");
                sql.append(" AND b.FConsumeFixQty > 0  \r\n");
            } else {
                sql.append(" Select\r\n");
                sql.append(" b.fmaterialid FChildMaterialID,\r\n");
                sql.append(" b.FConsumeFixQty * T.FBaseQty As FBaseQty, \r\n");
                sql.append(" b.fsupplystorageorgunitid As  FSupplyStorageOrgUnitID,\r\n");
                sql.append(" b.fmaterialprop As fmaterialAttr, \r\n");
                sql.append(" " + level + " As flevel, \r\n");
                sql.append(" (case a.fdesignModeID when 'ySgAAAADJLDK0P+Y' then isnull(a.fprojectid,'*') when 'ySgAAAADJLbK0P+Y' then isnull(a.fprojectid,'*') else '*' end ) As fprojectid,\r\n");
                sql.append(" a.FMainTenanceLevelID As FMainTenanceLevelID, \r\n");
                sql.append(" b.fid As fbomentryid, \r\n");
                sql.append(" T.fbomid As fbomid \r\n");
                sql.append(" From ").append(fbomExpandTable).append(" T \r\n");
                sql.append(" Inner Join t_mm_bom a On  a.fmaterialid = T.FChildMaterialID and a.fstorageorgunitid = T.FSupplyStorageOrgUnitID  \r\n");
                sql.append(" Inner Join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                sql.append(" Where T.flevel = ").append(level - 1).append("  \r\n");
                sql.append(" And T.fmaterialAttr = 10020  \r\n");
                sql.append(" AND b.FConsumeFixQty > 0  \r\n");
                sql.append(" AND a.fbasestatus = ").append(4).append("  \r\n");
                sql.append(" AND a.fdesignModeID in ( ").append(SQLUtil.arrayToString((Object[])BomUtil.getAllDesignModeIDList().toArray())).append(" ) \r\n");
                sql.append(" AND (a.fprojectid = T.fprojectid  or  a.fprojectid is null)  \r\n");
                sql.append(" AND isnull(a.FMainTenanceLevelID,'*') = isnull(T.FMainTenanceLevelID,'*')   \r\n");
            }
            if ((effectedRows = this.executeSQL(ctx, sql.toString())) > 0) continue;
            break;
        }
    }

    @Override
    protected boolean _checkRtHasManu(Context ctx, Map dataMap) throws BOSException, EASBizException {
        IRowSet rs;
        if (dataMap.get("stdInfo") == null) {
            return false;
        }
        StandardRootingInfo stdInfo = (StandardRootingInfo)dataMap.get("stdInfo");
        BomInfo bomInfo = null;
        ProjectInfo projectInfo = null;
        if (dataMap.get("projectInfo") != null) {
            projectInfo = (ProjectInfo)dataMap.get("projectInfo");
        }
        if (dataMap.get("bomInfo") != null) {
            bomInfo = (BomInfo)dataMap.get("bomInfo");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" Select h.fid ");
        sb.append(" from t_mm_manufactureorder h ");
        sb.append(" where h.froutingid = ? ");
        if (bomInfo != null) {
            sb.append(" and h.fbomid = '" + bomInfo.getId() + "' ");
        }
        if (projectInfo != null) {
            sb.append(" and h.fprojectid = '" + projectInfo.getId() + "' ");
        }
        return (rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{stdInfo.getId().toString()})) != null && rs.size() > 0;
    }

    @Override
    protected MRWorkProcesEntryInfo _getMRWorkProcessInfo(Context ctx, String fid, int idType) throws BOSException, EASBizException {
        if (fid == null || "".equals(fid)) {
            return null;
        }
        if (idType == 1) {
            return MRWorkProcesEntryFactory.getLocalInstance((Context)ctx).getMRWorkProcesEntryInfo((IObjectPK)new ObjectUuidPK(fid), this.getmrwSic());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" Select d.fid ");
        sb.append(" from t_mm_standardrooting h ");
        sb.append(" inner join t_mm_materialrwp d on d.fparentid = h.fmaterialrootingid ");
        sb.append(" where h.fid = ? ");
        sb.append(" order by d.fwpseq ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{fid});
        try {
            if (rs.next()) {
                return MRWorkProcesEntryFactory.getLocalInstance((Context)ctx).getMRWorkProcesEntryInfo((IObjectPK)new ObjectUuidPK(rs.getString("fid")), this.getmrwSic());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected StandardRootingInfo _getStandardRootingInfo(Context ctx, String fid) throws BOSException, EASBizException {
        if (fid == null || "".equals(fid)) {
            return null;
        }
        return StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(fid), this.getStandardRootingSic());
    }

    protected void removePbomNoValidData(Context ctx, PBOMInfo pbomInfo) throws BOSException, EASBizException {
        boolean needUpdate = false;
        if (pbomInfo != null && pbomInfo.getPbomEntry() != null && pbomInfo.getPbomEntry().size() > 0) {
            int i;
            PBOMEntryCollection removeColl = new PBOMEntryCollection();
            for (i = 0; i < pbomInfo.getPbomEntry().size(); ++i) {
                PBOMEntryInfo pbomentryInfo = pbomInfo.getPbomEntry().get(i);
                if (pbomentryInfo.getMaterial() == null) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getBomItem() == null) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getRoutingItem() == null) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getBomItem() != null && pbomentryInfo.getBomItem().getSupplyOrgUnit() == null) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getRoutingItem() != null && pbomentryInfo.getRoutingItem().getOperation() == null) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getBomItem() != null && pbomentryInfo.getBomItem().getMaterialProp() != null && pbomentryInfo.getBomItem().getMaterialProp().equals((Object)MaterialAttributeEnum.PHANTOMPART)) {
                    removeColl.add(pbomentryInfo);
                    continue;
                }
                if (pbomentryInfo.getBOM() == null || pbomentryInfo.getBOM().getMaterial() != null) continue;
                removeColl.add(pbomentryInfo);
            }
            if (removeColl != null && removeColl.size() > 0) {
                for (i = 0; i < removeColl.size(); ++i) {
                    pbomInfo.getPbomEntry().remove(removeColl.get(i));
                }
                needUpdate = true;
            }
        }
        if (needUpdate) {
            HashMap<PBOMInfo, PBOMInfo> pbomMap = new HashMap<PBOMInfo, PBOMInfo>();
            pbomMap.put(pbomInfo, pbomInfo);
            this._saveData(ctx, pbomMap);
        }
    }

    @Override
    protected PBOMInfo _convertToPBOM(Context ctx, Map dataMap) throws BOSException, EASBizException {
        String fbomid = dataMap.get("bomID").toString();
        StandardRootingInfo stdInfo = (StandardRootingInfo)dataMap.get("standInfo");
        MRWorkProcesEntryInfo mrwInfo = (MRWorkProcesEntryInfo)dataMap.get("mrwInfo");
        BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(fbomid), this.getBomSic());
        boolean needUpdate = false;
        HashMap<String, Object> pbomMap = new HashMap<String, Object>();
        pbomMap.put("standardRootingInfo", stdInfo);
        pbomMap.put("bomInfo", bomInfo);
        pbomMap.put("notSetOOQty", true);
        PBOMInfo pbomInfo = this._getPBomDatas(ctx, pbomMap);
        this.removePbomNoValidData(ctx, pbomInfo);
        needUpdate = false;
        HashMap<String, BomInfo> bomMap = new HashMap<String, BomInfo>();
        bomMap.put("bomInfo", bomInfo);
        IRowSet rs = this._getBomDatas(ctx, bomMap);
        try {
            HashMap<String, BigDecimal> bomQtyMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                BigDecimal fbomqty = rs.getBigDecimal("FBaseQty");
                BigDecimal fpbomqty = rs.getBigDecimal("FpbomQty");
                String fbomentryid = rs.getString("fbomentryid");
                bomQtyMap.put(fbomentryid, fbomqty);
                needUpdate = true;
            }
            if (needUpdate) {
                pbomInfo = this._addPbomDatas(ctx, pbomInfo, mrwInfo.getId().toString(), bomQtyMap, fbomid, stdInfo.getId().toString());
                pbomMap = new HashMap();
                pbomMap.put("pbomInfo", pbomInfo);
                this._saveData(ctx, pbomMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return pbomInfo;
    }

    protected BomInfo setBomInfoValue(Context ctx, String bomId, String designModeID, BOMTypeEnum bomType, String fbomnumber, String FMainTenanceLevelID) throws BOSException, EASBizException {
        BomInfo bomInfo = new BomInfo();
        bomInfo.setId(BOSUuid.read((String)bomId));
        bomInfo.setNumber(fbomnumber);
        if (designModeID != null && !"".equals(designModeID)) {
            DesignModeInfo dsInfo = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designModeID));
            bomInfo.setBomType(dsInfo.getBomType());
            bomInfo.setDesignMode(dsInfo);
        } else {
            bomInfo.setBomType(bomType);
        }
        if (FMainTenanceLevelID != null && !"".equals(FMainTenanceLevelID)) {
            MainTenanceLevelInfo mainTenanceLevelInfo = MainTenanceLevelFactory.getLocalInstance((Context)ctx).getMainTenanceLevelInfo((IObjectPK)new ObjectUuidPK(FMainTenanceLevelID));
            bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
        }
        return bomInfo;
    }

    @Override
    protected BomInfo _getBomInfo(Context ctx, String materialID, String storageOrgunitID, String projectID, String trackNumber, boolean baseStatusIsAudit, boolean isDesignMode, int parentbomtype, String FMainTenanceLevelID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        ArrayList<String> paramList = null;
        try {
            sql.setLength(0);
            paramList = new ArrayList<String>();
            sql.append(" Select distinct h.fid,h.fdesignModeID,h.fbomtype,h.fnumber,h.FMainTenanceLevelID ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" left outer join t_mm_tracknumber bt on bt.fid = d.fbegincarnoid ");
            sql.append(" left outer join t_mm_tracknumber et on et.fid = d.fendcarnoid ");
            sql.append(" where h.fmaterialid = ? ");
            paramList.add(materialID);
            sql.append(" And h.fstorageOrgUnitid = ? ");
            paramList.add(storageOrgunitID);
            if (isDesignMode) {
                sql.append(" And h.fdesignmodeid is not null ");
                if (projectID != null) {
                    sql.append(" And (h.fprojectid = ?  or h.fprojectid is null)");
                    paramList.add(projectID);
                }
                if (trackNumber != null) {
                    sql.append(" And ((bt.fnumber <= ? and et.fnumber >= ? )  or d.fbegincarnoid is null)");
                    paramList.add(trackNumber);
                    paramList.add(trackNumber);
                }
            } else {
                sql.append(" And h.fdesignmodeid is null ");
                if (parentbomtype == 45 || parentbomtype == 80) {
                    if (projectID != null) {
                        sql.append(" And (h.fprojectid = ?  or h.fprojectid is null)");
                        paramList.add(projectID);
                    }
                    if (parentbomtype == 45) {
                        sql.append(" And h.fbomtype in ( ").append(45).append(",").append(40).append(")");
                    } else if (parentbomtype == 80) {
                        sql.append(" And h.fbomtype in ( ").append(80).append(",").append(40).append(")");
                    }
                } else if (parentbomtype == 40) {
                    sql.append(" And h.fbomtype = ").append(40);
                }
                if (trackNumber != null) {
                    if (parentbomtype == 80) {
                        sql.append(" And ((bt.fnumber <= ? and et.fnumber >= ? )  or d.fbegincarnoid is null)");
                        paramList.add(trackNumber);
                        paramList.add(trackNumber);
                    } else if (parentbomtype == 45) {
                        sql.append(" And h.fid in(Select ob.forderid from t_mm_orderbompt ob inner join t_mm_tracknumber ot on ob.ftrackid = ot.fid  where ot.fnumber = ? ) ");
                        paramList.add(trackNumber);
                    }
                }
            }
            if (baseStatusIsAudit) {
                sql.append(" And h.fbasestatus = 4  \r\n");
            } else {
                sql.append(" And h.fbasestatus <> 3  \r\n");
            }
            if (FMainTenanceLevelID == null || "".equals(FMainTenanceLevelID)) {
                sql.append(" And h.FMainTenanceLevelID is null  \r\n");
            } else {
                sql.append(" And h.FMainTenanceLevelID = ? \r\n");
                paramList.add(FMainTenanceLevelID);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            if (rs.next()) {
                return this.setBomInfoValue(ctx, rs.getString("fid"), rs.getString("fdesignModeID"), BOMTypeEnum.getEnum((int)rs.getInt("fbomtype")), rs.getString("fnumber"), rs.getString("FMainTenanceLevelID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected void _addStandardRootingProjTrack(Context ctx, String pbomid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into T_MM_StandardRootingProEntry(fid,fseq,fparentid,Cfprojectid,Cftracknumberid) ");
        sql.append(" Select distinct newbosid('9F7A0771') as fid, ");
        sql.append(" 0 as fseq, ");
        sql.append(" std.fid as fparentid, ");
        sql.append(" h.fprojectid as fprojectid, ");
        sql.append(" t.fid as ftrackid ");
        sql.append(" from t_mm_pbom h ");
        sql.append(" inner join t_mm_standardrooting std on std.fid = h.froutingid ");
        sql.append(" inner join t_mm_pbomentry d on h.fid = d.fparentid ");
        sql.append(" inner join t_mm_projectcar pc on pc.fprojectid = h.fprojectid ");
        sql.append(" inner join t_mm_tracknumber t on t.fid = pc.ftracknumberid ");
        sql.append(" inner join t_mm_tracknumber bt on bt.fid = d.fstraceid ");
        sql.append(" inner join t_mm_tracknumber et on et.fid = d.fetraceid ");
        sql.append(" where bt.fnumber <= t.fnumber ");
        sql.append(" and et.fnumber >= t.fnumber ");
        sql.append(" and h.fid = ? ");
        sql.append(" and not exists(Select 1 from T_MM_StandardRootingProEntry a where a.fparentid = std.fid and a.cfprojectid = h.fprojectid and a.cftracknumberid = t.fid) ");
        sql.append(" group by std.fid ,h.fprojectid ,t.fid ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{pbomid});
    }

    @Override
    protected List _getChildBomIDList(Context ctx, Map queryDataMap) throws BOSException, EASBizException {
        if (queryDataMap == null) {
            return null;
        }
        if (queryDataMap.get("storageOrgUnitIDSet") == null) {
            return null;
        }
        HashSet storageOrgUnitIDSet = (HashSet)queryDataMap.get("storageOrgUnitIDSet");
        DesignModeInfo dsInfo = null;
        if (queryDataMap.get("designMode") != null) {
            dsInfo = (DesignModeInfo)queryDataMap.get("designMode");
        }
        BomInfo bomInfo = null;
        if (queryDataMap.get("bomInfo") != null) {
            bomInfo = (BomInfo)queryDataMap.get("bomInfo");
        }
        ProjectInfo projectInfo = null;
        if (queryDataMap.get("projectInfo") != null) {
            projectInfo = (ProjectInfo)queryDataMap.get("projectInfo");
        }
        TrackNumberInfo trackNumberInfo = null;
        if (queryDataMap.get("trackNumberInfo") != null) {
            trackNumberInfo = (TrackNumberInfo)queryDataMap.get("trackNumberInfo");
        }
        int queryBomType = 0;
        if (queryDataMap.get("queryBomType") != null) {
            queryBomType = Integer.parseInt(queryDataMap.get("queryBomType").toString());
        }
        IRowSet rs = this.expandChildBom(ctx, bomInfo, queryBomType, storageOrgUnitIDSet, projectInfo, trackNumberInfo, dsInfo);
        ArrayList<String> bomIDList = new ArrayList<String>();
        try {
            while (rs.next()) {
                bomIDList.add(rs.getString("fbomid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return bomIDList;
    }

    protected IRowSet expandChildBom(Context ctx, BomInfo bomInfo, int queryBomType, Set<String> storageOrgUnitIDSet, ProjectInfo projectInfo, TrackNumberInfo trackNumberInfo, DesignModeInfo dsInfo) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (queryBomType == 0) {
            if (bomInfo == null) {
                return null;
            }
            sql.append(" Select h.fid as fbomid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" where h.fid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomInfo.getId().toString()});
        } else if (queryBomType == 1) {
            if (bomInfo == null) {
                return null;
            }
            if (storageOrgUnitIDSet == null || storageOrgUnitIDSet.size() < 1) {
                return null;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("bomInfo", bomInfo);
            dataMap.put("isExpandAllChild", true);
            dataMap.put("storageOrgUnitIDSet", storageOrgUnitIDSet);
            rs = this._getBomDatas(ctx, dataMap);
        } else if (queryBomType == 2) {
            TrackNumberInfo minTrackInfo = null;
            if (dsInfo != null && dsInfo.getId().toString().equals("ySgAAAADJLnK0P+Y")) {
                minTrackInfo = trackNumberInfo == null ? BomUtil.getBomTrackNumberInfo(ctx, bomInfo, "MIN") : trackNumberInfo;
            }
            sql.setLength(0);
            sql.append(" Select h.fid as fbomid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" where h.fbasestatus = 4 ");
            sql.append(" And Exists(Select 1 from t_mm_bomentry d where d.fparentid = h.fid) ");
            sql.append(" And Not Exists(Select 1 from t_mm_bom ph inner join t_mm_bomentry pd on pd.fparentid = ph.fid ");
            sql.append(" where pd.fmaterialid = h.fmaterialid ");
            sql.append(" and pd.fsupplystorageorgunitid = h.fstorageOrgunitid ");
            sql.append(" and pd.fmaterialprop in(  ").append(10020).append(",").append(10040).append(")");
            if (minTrackInfo != null) {
                sql.append(" And pd.fbegincarnoid = '" + minTrackInfo.getId() + "' ");
                sql.append(" ) ");
                sql.append(" And h.fid in(Select fparentid from t_mm_bomentry where fbegincarnoid = '" + minTrackInfo.getId() + "')  ");
            } else if (projectInfo != null) {
                sql.append(" And ph.fprojectid = '").append(projectInfo.getId().toString()).append("'  ");
                sql.append(" ) ");
                sql.append(" And h.fprojectid = '").append(projectInfo.getId().toString()).append("'  ");
            }
            sql.append(" And h.fstorageorgunitid in(").append(SQLUtil.arrayToString((Object[])storageOrgUnitIDSet.toArray())).append(")  ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else {
            return null;
        }
        return rs;
    }

    @Override
    protected IRowSet _getStdInfoDatas(Context ctx, Map queryDataMap) throws BOSException, EASBizException {
        if (queryDataMap == null || queryDataMap.get("bomIDList") == null) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        ArrayList bomIDList = (ArrayList)queryDataMap.get("bomIDList");
        int rtQueryType = Integer.parseInt(queryDataMap.get("rtQueryType").toString());
        sql.append(" Select h.fid as fbomid, \r\n");
        sql.append(" h.fbomtype as fbomtype, \r\n");
        sql.append(" h.fnumber as fbomnumber, \r\n");
        sql.append(" m.fnumber as fmaterialnumber, \r\n");
        sql.append(" m.fname_l2 as fmaterialname, \r\n");
        sql.append(" m.fid as fmaterialid, \r\n");
        sql.append(" s.fid as fstorageorgunitid, \r\n");
        sql.append(" s.fnumber as fstorageoegunitnumber, \r\n");
        sql.append(" s.fname_l2 as fstorageorgunitname, \r\n");
        sql.append(" std.fid as fstdid, \r\n");
        sql.append(" std.fnumber as fstdnumber, \r\n");
        sql.append(" std.fstatus as fstdstatus, \r\n");
        sql.append(" auditor.fname_l2 as fauditorname, \r\n");
        sql.append(" to_char(std.faudittime,'yyyy-MM-dd') as faudittime, \r\n");
        sql.append(" std.fismainrooting as fismainrooting \r\n");
        sql.append(" from t_mm_bom h \r\n");
        sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid \r\n");
        sql.append(" inner join t_org_storage s on s.fid = h.fstorageorgunitid \r\n");
        sql.append(" left outer join t_mm_standardrooting std on std.fmaterialid = h.fmaterialid and std.fstorageorgunitid = h.fstorageorgunitid \r\n");
        sql.append(" left outer join t_pm_user auditor on auditor.fid = std.fauditorid \r\n");
        sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") \r\n");
        if (rtQueryType == 2) {
            sql.append(" and std.fid is  null \r\n");
        } else if (rtQueryType == 3) {
            sql.append(" and std.fid is not null and std.fstatus <> \r\n").append(60);
        }
        sql.append(" and h.fbasestatus = 4 \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected String createBomExpandTemptable(Context ctx) throws BOSException, EASBizException {
        String fbomExpandTempTable = MMUtils.createTmpTable((Context)ctx, (String)this.getReturnTableSQL2());
        MMUtils.createTableIndex((Context)ctx, (String)fbomExpandTempTable, (String[])new String[]{"flevel"});
        MMUtils.createTableIndex((Context)ctx, (String)fbomExpandTempTable, (String[])new String[]{"fchildmaterialid,FSupplyStorageOrgUnitID,Fprojectid"});
        MMUtils.createTableIndex((Context)ctx, (String)fbomExpandTempTable, (String[])new String[]{"fbomid"});
        return fbomExpandTempTable;
    }

    @Override
    protected IRowSet _getBomStdPboms(Context ctx, Map queryDataMap) throws BOSException, EASBizException {
        String fbomExpandTempTable;
        IRowSet rs;
        block11: {
            if (queryDataMap == null || queryDataMap.get("bomIDList") == null) {
                return null;
            }
            StringBuilder sql = new StringBuilder();
            rs = null;
            ArrayList bomIDList = (ArrayList)queryDataMap.get("bomIDList");
            int pbomQueryType = Integer.parseInt(queryDataMap.get("pbomQueryType").toString());
            Map defStdMap = this._getBomDefStdMap(ctx, bomIDList);
            String fbomRtTemptable = null;
            fbomExpandTempTable = null;
            try {
                fbomRtTemptable = MMUtils.createTmpTable((Context)ctx, (String)this.getBomStdRelationTempTableCreateTableSql());
                MMUtils.createTableIndex((Context)ctx, (String)fbomRtTemptable, (String[])new String[]{"fbomid,fstdid"});
                sql.setLength(0);
                sql.append(this.getInsertBomStdRelationTempTableSQL(fbomRtTemptable));
                sql.append(" Select h.fid as fbomid, \r\n");
                sql.append(" std.fid as fstdid, \r\n");
                sql.append(" 0 As fisdef \r\n");
                sql.append(" from t_mm_bom h \r\n");
                sql.append(" inner join t_mm_standardrooting std on std.fmaterialid = h.fmaterialid and std.fstorageorgunitid = h.fstorageorgunitid  and std.fstatus = \r\n").append(60);
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") \r\n");
                sql.append(" and h.fbasestatus = 4 \r\n");
                sql.append(" and std.fstatus =  60 \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                if (defStdMap != null && defStdMap.size() > 0) {
                    Set set = defStdMap.keySet();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        String fbomid = String.valueOf(it.next());
                        if (defStdMap.get(fbomid) == null || "".equals(((String)defStdMap.get(fbomid)).toString())) continue;
                        sql.setLength(0);
                        sql.append(" update ").append(fbomRtTemptable);
                        sql.append(" set fisdef = 1 ");
                        sql.append(" where fbomid = ? and fstdid = ? ");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{fbomid, ((String)defStdMap.get(fbomid)).toString()});
                    }
                }
                if (pbomQueryType == 2) {
                    DbUtil.execute((Context)ctx, (String)(" delete from " + fbomRtTemptable + " where fisdef = 0"));
                }
                fbomExpandTempTable = this.createBomExpandTemptable(ctx);
                this.expandBomTempTable2(ctx, bomIDList, fbomExpandTempTable);
                sql.setLength(0);
                sql.append(" Select dd.fbomid as fbomid, \r\n");
                sql.append(" bom.fbomtype as fbomtype, \r\n");
                sql.append(" bom.fnumber as fbomnumber, \r\n");
                sql.append(" m.fnumber as fmaterialnumber, \r\n");
                sql.append(" m.fname_l2 as fmaterialname, \r\n");
                sql.append(" m.fid as fmaterialid, \r\n");
                sql.append(" s.fid as fstorageorgunitid, \r\n");
                sql.append(" s.fnumber as fstorageoegunitnumber, \r\n");
                sql.append(" s.fname_l2 as fstorageorgunitname, \r\n");
                sql.append(" p.fid as fprojectid, \r\n");
                sql.append(" p.fnumber as fprojectnumber, \r\n");
                sql.append(" p.fname_l2 as fprojectname, \r\n");
                sql.append(" dd.fstdid as fstdid, \r\n");
                sql.append(" std.fnumber as fstdnumber, \r\n");
                sql.append(" pbom.fid as fpbomid, \r\n");
                sql.append(" pbom.fnumber as fpbomnumber, \r\n");
                sql.append(" dd.fisdef as fisdef  ");
                sql.append(" from (  ");
                sql.append(" Select distinct fbomid,fstdid,fisdef from ( ");
                sql.append(" Select ");
                sql.append("  Sum(fbomqty) As fbomqty ");
                sql.append(" ,Sum(fpbomqty) As fpbomqty ");
                sql.append(" ,fbomid ");
                sql.append(" ,fbomentryid ");
                sql.append(" ,fstdid ");
                sql.append(" ,fisdef ");
                sql.append(" from ( ");
                sql.append(" Select ");
                sql.append(" Sum(a.FBaseQty) As fbomqty  ");
                sql.append(",a.fbomid");
                sql.append(",a.fbomentryid");
                sql.append(",0 As fpbomqty");
                sql.append(",1 As ftype");
                sql.append(",temp.fstdid");
                sql.append(",temp.fisdef");
                sql.append(" from ").append(fbomExpandTempTable).append(" a \r\n");
                sql.append(" inner join ").append(fbomRtTemptable).append(" temp on temp.fbomid = a.fbomid  \r\n");
                sql.append(" where a.fmaterialAttr <> 10020 \r\n");
                sql.append(" group by a.fbomid,a.fbomentryid,temp.fstdid,temp.fisdef \r\n");
                sql.append(" union ");
                sql.append(" Select ");
                sql.append(" 0 As fbomqty  ");
                sql.append(",h.fbomid As fbomid ");
                sql.append(",d.fbomitemid As fbomentryid");
                sql.append(",sum(d.fconsumequota) As fpbomqty");
                sql.append(",2 As ftype");
                sql.append(",temp.fstdid");
                sql.append(",temp.fisdef");
                sql.append(" from t_mm_pbom h  \r\n");
                sql.append(" inner join t_mm_pbomentry d on h.fid = d.fparentid  \r\n");
                sql.append(" inner join t_mm_bom bh on bh.fid = h.fbomid  \r\n");
                sql.append(" inner join ").append(fbomRtTemptable).append(" temp on temp.fbomid = h.fbomid and h.froutingid = temp.fstdid  \r\n");
                sql.append(" group by h.fbomid,d.fbomitemid,temp.fstdid,temp.fisdef \r\n");
                sql.append(" ) bb group by fbomid,fbomentryid,fstdid,fisdef  \r\n");
                sql.append(" ) cc where cc.fbomqty <> cc.fpbomqty \r\n");
                sql.append(" ) dd \r\n");
                sql.append(" left outer join t_mm_pbom pbom on pbom.fbomid = dd.fbomid and pbom.froutingid = dd.fstdid \r\n");
                sql.append(" left outer join t_mm_bom bom on bom.fid = dd.fbomid  \r\n");
                sql.append(" left outer join t_mm_standardrooting std on std.fid = dd.fstdid  \r\n");
                sql.append(" left outer join t_bd_material m on m.fid = bom.fmaterialid \r\n");
                sql.append(" left outer join t_org_storage s on s.fid = bom.fstorageorgunitid \r\n");
                sql.append(" left outer join t_mm_project p on p.fid = bom.fprojectid \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (fbomRtTemptable == null || "".equals(fbomRtTemptable)) break block11;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (fbomRtTemptable != null && !"".equals(fbomRtTemptable)) {
                        MMUtils.releaseTmpTable((Context)ctx, (String)fbomRtTemptable);
                    }
                    if (fbomExpandTempTable != null && !"".equals(fbomExpandTempTable)) {
                        MMUtils.releaseTmpTable((Context)ctx, fbomExpandTempTable);
                    }
                    throw throwable;
                }
            }
            MMUtils.releaseTmpTable((Context)ctx, (String)fbomRtTemptable);
        }
        if (fbomExpandTempTable != null && !"".equals(fbomExpandTempTable)) {
            MMUtils.releaseTmpTable((Context)ctx, (String)fbomExpandTempTable);
        }
        return rs;
    }

    @Override
    protected Map _getBomDefStdMap(Context ctx, List bomIDList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" Select bom.fid as fbomid,bom.fstorageorgunitid,bom.fmaterialid,bom.fprojectid,bom.fdesignmodeid  ");
        sql.append(" ,(Select top 1 fbegincarnoid from t_mm_bomentry where fparentid = bom.fid) as ftrackid ");
        sql.append(" from t_mm_bom bom ");
        sql.append(" where bom.fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> defStdMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String bomid = rs.getString("fbomid");
                String storageorgunitid = rs.getString("fstorageorgunitid");
                String materialid = rs.getString("fmaterialid");
                String projectid = rs.getString("fprojectid");
                String fdesignmodeid = rs.getString("fdesignmodeid");
                String trackid = rs.getString("ftrackid");
                String stdid = null;
                if (projectid != null && trackid != null) {
                    stdid = this.getfprojectTrackStdID(ctx, materialid, storageorgunitid, projectid, trackid);
                }
                if (stdid == null && projectid != null) {
                    stdid = this.getfprojectTrackStdID(ctx, materialid, storageorgunitid, projectid, null);
                }
                if (stdid == null && trackid != null) {
                    stdid = this.getfprojectTrackStdID(ctx, materialid, storageorgunitid, null, trackid);
                }
                if (stdid == null) {
                    stdid = this.getfprojectTrackStdID(ctx, materialid, storageorgunitid, null, null);
                }
                defStdMap.put(bomid, stdid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return defStdMap;
    }

    private String getBomStdRelationTempTableCreateTableSql() {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table returnTable ( ");
        sb.append("fbomid varchar(44)");
        sb.append(",fstdid varchar(44)");
        sb.append(",fisdef INT");
        sb.append(")");
        return sb.toString();
    }

    protected String getInsertBomStdRelationTempTableSQL(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append("fbomid ");
        sb.append(",fstdid  ");
        sb.append(",fisdef ");
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected BomCollection _getBomInfoByRtID(Context ctx, String rtid) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" Select bom.fid from t_mm_bom bom ");
        sb.append(" inner join t_mm_standardrooting std on std.fmaterialid = bom.fmaterialid and std.fstorageorgunitid = bom.fstorageorgunitid ");
        sb.append(" where std.fid = '" + rtid + "' and bom.fbasestatus = 4 and bom.fdesignmodeid is not null ");
        BomCollection coll = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.getBomSic());
        coll = BomFactory.getLocalInstance((Context)ctx).getBomCollection(viewInfo);
        return coll;
    }

    protected List<String> getBomEntryIDList(Context ctx, List idList) throws BOSException, EASBizException, SQLException {
        ArrayList<String> entryIDList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" Select d.fid from t_mm_bom h inner join t_mm_bomentry d on h.fid = d.fparentid where h.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            entryIDList.add(rs.getString("fid"));
        }
        return entryIDList;
    }

    public static String getErrorNumber(Context ctx, IRowSet rs) throws BOSException, EASBizException, SQLException {
        if (rs == null) {
            return null;
        }
        String errorNumber = null;
        while (rs.next()) {
            if (errorNumber == null) {
                errorNumber = rs.getString("fnumber");
                continue;
            }
            errorNumber = errorNumber + "\u3001" + rs.getString("fnumber");
        }
        return errorNumber;
    }

    @Override
    protected String _checkBomCanUnAudit(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() < 1) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        String errorNumber = null;
        try {
            List<String> bomEntryIDList = this.getBomEntryIDList(ctx, idList);
            if (bomEntryIDList == null || bomEntryIDList.size() < 1) {
                return null;
            }
            sql.append(" Select distinct h.fnumber ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_mm_pbomentry pd on pd.fbomitemid = d.fid ");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            sql.append(" And h.fbasestatus = 4 ");
            sql.append(" And h.fdesignmodeid is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
            if (errorNumber != null) {
                String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_001", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                return successful;
            }
            sql.setLength(0);
            sql.append(" Select distinct h.fnumber ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_mm_bomchange ch on ch.fbomid = h.fid ");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            sql.append(" And h.fbasestatus = 4 ");
            sql.append(" And h.fdesignmodeid is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
            if (errorNumber != null) {
                String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_002", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                return successful;
            }
            sql.setLength(0);
            sql.append(" Select distinct h.fnumber ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_mm_mftorderstock mo on mo.fbomentryid = d.fid ");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            sql.append(" And h.fbasestatus = 4 ");
            sql.append(" And h.fdesignmodeid is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
            if (errorNumber != null) {
                String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_003", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                return successful;
            }
            sql.setLength(0);
            sql.append(" Select distinct h.fnumber ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_sm_subcontractorderentry so on so.fbomid = h.fid ");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            sql.append(" And h.fbasestatus = 4 ");
            sql.append(" And h.fdesignmodeid is not null ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
            if (errorNumber != null) {
                String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_004", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                return successful;
            }
            BomCollection bomcoll = BomUtil.getbomCollection(ctx, bomEntryIDList);
            ArrayList<String> topBomIDList = new ArrayList<String>();
            if (bomcoll != null && bomcoll.size() > 0) {
                for (int i = 0; i < bomcoll.size(); ++i) {
                    BomInfo bomInfo = bomcoll.get(i);
                    List topBomInfoList = BomUtil.getTopZZBomInfo(ctx, bomInfo);
                    for (int j = 0; j < topBomInfoList.size(); ++j) {
                        BomInfo topZZBom = (BomInfo)topBomInfoList.get(j);
                        topBomIDList.add(topZZBom.getId().toString());
                    }
                }
            }
            if (topBomIDList != null && topBomIDList.size() > 0) {
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_pbom ph on ph.fbomid = h.fid ");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_001", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomchange ch on ch.fbomid = h.fid ");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_002", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_manufactureorder mo on mo.fbomid = h.fid ");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_003", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_sm_subcontractorderentry so on so.fbomid = h.fid ");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = bomConvertToPBomFacadeControllerBean.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    String successful = ResourceBase.getString((String)RESURL, (String)"BomUnAudit_004", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

