/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BomConvertDesignBomBaseProcess
extends BomConvertBaseProcess {
    public DesignBOMBillInfo designBOMBillInfo = null;

    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getDesignBomBillInfo(ctx, entryInfo.getSourceBomID());
        this.isException = !this.checkData_DesignBom(ctx);
    }

    public DesignBOMBillInfo getDesignBomBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("erpbatchno1.id"));
        sic.add(new SelectorItemInfo("erpbatchno2.id"));
        sic.add(new SelectorItemInfo("erpbatchno1.number"));
        sic.add(new SelectorItemInfo("erpbatchno2.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.name"));
        this.designBOMBillInfo = DesignBOMBillFactory.getLocalInstance(ctx).getDesignBOMBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.designBOMBillInfo;
    }

    public void updateDesignBomStatus(Context ctx) throws BOSException, EASBizException {
        this.designBOMBillInfo.setIsImport(true);
        this.designBOMBillInfo.setConvertBomType(this.bomConvertLogInfo.getAfterBomType());
        this.designBOMBillInfo.setConvertDate(this.currentDate);
        this.designBOMBillInfo.setConverter(this.currentUserInfo);
        updateSic = new SelectorItemCollection();
        updateSic.add(new SelectorItemInfo("isImport"));
        updateSic.add(new SelectorItemInfo("convertBomType"));
        updateSic.add(new SelectorItemInfo("convertDate"));
        updateSic.add(new SelectorItemInfo("converter"));
        DesignBOMBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.designBOMBillInfo, updateSic);
    }

    public boolean checkData_DesignBom(Context ctx) throws BOSException, EASBizException {
        MaterialInfo parentMaterialInfo = null;
        MaterialInfo materialInfo = null;
        if (this.designBOMBillInfo.getState() == null || !this.designBOMBillInfo.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.designBOMBillInfo.getDesignMode() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"DesignModeNull", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        DesignModeInfo dsInfo = this.designBOMBillInfo.getDesignMode();
        if (this.designBOMBillInfo.isIsImport()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"isConverted", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (this.bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            sql.append(" Select fid from CT_ZJB_DESIGNBOMMIDDLEBILL where  CFPORTNO = ? and CFPARENTNO = ? and CFBATCH = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getPartNo(), this.designBOMBillInfo.getParentNo(), this.designBOMBillInfo.getBatch()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"isExists_DesignBom_DesignBomMiddle", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBOMBillInfo.getCU().getId().toString(), "emm_mm_zjbom_gybom_gybommid_add").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByDesignMiddleBomAddNew", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getCU().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        } else if (this.bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.append(" Select fid from ct_zjb_processbombill where  cfportno = ? and cfparentno = ? and cfbatch = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getPartNo(), this.designBOMBillInfo.getParentNo(), this.designBOMBillInfo.getBatch()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"isExists_DesignBom_ProcessBom", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBOMBillInfo.getCU().getId().toString(), "emm_mm_zjbom_gybom_gybom_add").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByProcessBomAddNew", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getCU().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        } else if (this.bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            List<String> allChildDrawOrgUnitIDList;
            parentMaterialInfo = BomConvertDesignBomBaseProcess.getMaterialInfo(ctx, this.designBOMBillInfo.getParentNo());
            materialInfo = BomConvertDesignBomBaseProcess.getMaterialInfo(ctx, this.designBOMBillInfo.getPartNo());
            if (materialInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialNumberNoBaseData", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (parentMaterialInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ParentMaterialNumberNoBaseData", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!BomConvertDesignBomBaseProcess.checkMaterialDisCU(ctx, this.designBOMBillInfo.getPartNo(), null)) {
                CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getPartNo(), ctrlUnitInfo.getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!BomConvertDesignBomBaseProcess.checkMaterialDisCU(ctx, this.designBOMBillInfo.getParentNo(), null)) {
                CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ParentMaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getParentNo(), ctrlUnitInfo.getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getStorageOrgUnit() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"StorageOrgUnitIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), "mm_bom_addnew").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByMMBomAddNew", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getStorageOrgUnit().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getSupplyOrgUnit() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"SupplyOrgUnitIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getMaterialAttr() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialAttrIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isProject() && this.designBOMBillInfo.getProject() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ProjectIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isTrackNumber() && this.designBOMBillInfo.getErpbatchno1() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"STrackNumberIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isTrackNumber() && this.designBOMBillInfo.getErpbatchno2() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ETrackNumberIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getParentQty() == null || this.designBOMBillInfo.getParentQty().compareTo(BigDecimal.ZERO) <= 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"parentQty_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getPMUnit() == null || "".equals(this.designBOMBillInfo.getPMUnit())) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"parentMUnit_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.designBOMBillInfo.getUnit() == null || "".equals(this.designBOMBillInfo.getUnit())) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MUnit_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            MeasureUnitInfo pUnitInfo = BomConvertDesignBomBaseProcess.getMeasureUnitInfo(ctx, this.designBOMBillInfo.getPMUnit(), parentMaterialInfo);
            if (pUnitInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getPMUnit()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            MeasureUnitInfo unitInfo = BomConvertDesignBomBaseProcess.getMeasureUnitInfo(ctx, this.designBOMBillInfo.getUnit(), materialInfo);
            if (unitInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getUnit()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            List<String> allParentStorageOrgUnitIDList = this.getAllParentStorageOrgUnitIDList(ctx);
            if (allParentStorageOrgUnitIDList != null && allParentStorageOrgUnitIDList.size() > 0) {
                if (!allParentStorageOrgUnitIDList.contains(this.designBOMBillInfo.getStorageOrgUnit().getId().toString())) {
                    allParentStorageOrgUnitIDList.add(this.designBOMBillInfo.getStorageOrgUnit().getId().toString());
                }
                if (this.checkMaterialOrgUnitIsMul(ctx, allParentStorageOrgUnitIDList, this.designBOMBillInfo.getParentNo(), "DesignBomParentMaterialMulOrgUnit", true)) {
                    return false;
                }
            }
            if ((allChildDrawOrgUnitIDList = this.getAllChildDrawOrgUnitIDList(ctx)) != null && allChildDrawOrgUnitIDList.size() > 0) {
                if (!allChildDrawOrgUnitIDList.contains(this.designBOMBillInfo.getSupplyOrgUnit().getId().toString())) {
                    allChildDrawOrgUnitIDList.add(this.designBOMBillInfo.getSupplyOrgUnit().getId().toString());
                }
                if (this.checkMaterialOrgUnitIsMul(ctx, allChildDrawOrgUnitIDList, this.designBOMBillInfo.getPartNo(), "DesignBomChildMaterialMulOrgUnit", false)) {
                    return false;
                }
            }
            if ((allParentStorageOrgUnitIDList = BomConvertDesignBomBaseProcess.getMaterialBomOrgUnitList(ctx, null, this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), this.designBOMBillInfo.getProject() == null ? null : this.designBOMBillInfo.getProject().getId().toString(), this.designBOMBillInfo.getErpbatchno1() == null ? null : this.designBOMBillInfo.getErpbatchno1().getId().toString(), this.designBOMBillInfo.getParentNo())) != null && allParentStorageOrgUnitIDList.size() > 1 && this.checkMaterialOrgUnitIsMul(ctx, allParentStorageOrgUnitIDList, this.designBOMBillInfo.getParentNo(), "BomParentMaterialMulOrgUnit", true)) {
                return false;
            }
            allChildDrawOrgUnitIDList = BomConvertDesignBomBaseProcess.getMaterialBomOrgUnitList(ctx, null, this.designBOMBillInfo.getSupplyOrgUnit().getId().toString(), this.designBOMBillInfo.getProject() == null ? null : this.designBOMBillInfo.getProject().getId().toString(), this.designBOMBillInfo.getErpbatchno1() == null ? null : this.designBOMBillInfo.getErpbatchno1().getId().toString(), this.designBOMBillInfo.getPartNo());
            if (allChildDrawOrgUnitIDList != null && allChildDrawOrgUnitIDList.size() > 1 && this.checkMaterialOrgUnitIsMul(ctx, allChildDrawOrgUnitIDList, this.designBOMBillInfo.getPartNo(), "BomChildMaterialMulOrgUnit", false)) {
                return false;
            }
            if (BomUtil.getBomInfo(ctx, parentMaterialInfo.getId().toString(), this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), this.designBOMBillInfo.getProject() == null ? null : this.designBOMBillInfo.getProject().getId().toString(), this.designBOMBillInfo.getDesignMode(), this.designBOMBillInfo.getErpbatchno1() == null ? null : this.designBOMBillInfo.getErpbatchno1().getId().toString(), null) != null && !this.checkPermission(ctx, this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), "mm_bom_update").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByMMBomUpdate", (Locale)ctx.getLocale(), (Object[])new String[]{this.designBOMBillInfo.getStorageOrgUnit().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            sql.append(" Select d.fid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid ");
            sql.append(" inner join t_bd_material pm on pm.fid = h.fmaterialid ");
            if (dsInfo.isTrackNumber()) {
                sql.append(" left outer join t_mm_tracknumber bt on bt.fid = d.fbegincarnoid ");
                sql.append(" left outer join t_mm_tracknumber et on et.fid = d.fendcarnoid ");
            }
            sql.append(" where  m.fnumber = ? and pm.fnumber = ? and h.fstorageorgunitid = ? and h.fdesignModeID = ? ");
            sql.append(" and d.fsupplystorageorgunitid = ? ");
            if (dsInfo.isProject()) {
                sql.append(" and h.fprojectid = '" + this.designBOMBillInfo.getProject().getId() + "' ");
            }
            if (dsInfo.isTrackNumber()) {
                sql.append(" and bt.fnumber <= '" + this.designBOMBillInfo.getErpbatchno2().getNumber() + "' ");
                sql.append(" and et.fnumber >= '" + this.designBOMBillInfo.getErpbatchno1().getNumber() + "' ");
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.designBOMBillInfo.getPartNo(), this.designBOMBillInfo.getParentNo(), this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), dsInfo.getId().toString(), this.designBOMBillInfo.getSupplyOrgUnit().getId().toString()})) != null && rs.size() > 0) {
                String errNumber = "isExists_DesignBom_ManuBom";
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)errNumber, (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            String errorStr = null;
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialPlan(ctx, parentMaterialInfo.getId().toString(), this.designBOMBillInfo.getStorageOrgUnit().getId().toString(), this.designBOMBillInfo.getDesignMode(), this.bomConvertLogInfo.getAfterBomType(), true, true, pUnitInfo);
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialPlan(ctx, materialInfo.getId().toString(), this.designBOMBillInfo.getSupplyOrgUnit().getId().toString(), this.designBOMBillInfo.getDesignMode(), this.bomConvertLogInfo.getAfterBomType(), true, false, unitInfo);
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialInventroy(ctx, parentMaterialInfo.getId().toString(), this.designBOMBillInfo.getStorageOrgUnit().getId().toString());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialInventroy(ctx, materialInfo.getId().toString(), this.designBOMBillInfo.getSupplyOrgUnit().getId().toString());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialUnitConvertRate(ctx, parentMaterialInfo, pUnitInfo, parentMaterialInfo.getBaseUnit());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertDesignBomBaseProcess.checkMaterialUnitConvertRate(ctx, materialInfo, unitInfo, materialInfo.getBaseUnit());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        }
        return true;
    }

    @Override
    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        super.afterConvert(ctx);
        this.updateDesignBomStatus(ctx);
    }

    public List<String> getAllParentStorageOrgUnitIDList(Context ctx) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select distinct fsupplyorgunitid As fDrawOrgUnitID  ");
        sql.append(" from ct_zjb_designbombill  ");
        sql.append(" where cfpartno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND (CFIsImport = 0 or cfquantity > 0)  ");
        paramList.add(this.designBOMBillInfo.getParentNo());
        paramList.add(4);
        if (this.designBOMBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.designBOMBillInfo.getProject().getId().toString());
        }
        if (this.designBOMBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.designBOMBillInfo.getDesignMode().getId().toString());
        }
        sql.append(" union  ");
        sql.append(" select distinct fstorageorgunitid As fDrawOrgUnitID  ");
        sql.append(" from ct_zjb_designbombill  ");
        sql.append(" where Cfparentno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND (CFIsImport = 0 or cfquantity > 0)  ");
        paramList.add(this.designBOMBillInfo.getParentNo());
        paramList.add(4);
        if (this.designBOMBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.designBOMBillInfo.getProject().getId().toString());
        }
        if (this.designBOMBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.designBOMBillInfo.getDesignMode().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fDrawOrgUnitID") == null || "".equals(rs.getString("fDrawOrgUnitID"))) continue;
                idList.add(rs.getString("fDrawOrgUnitID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    public List<String> getAllChildDrawOrgUnitIDList(Context ctx) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select distinct fsupplyorgunitid As fDrawOrgUnitID  ");
        sql.append(" from ct_zjb_designbombill  ");
        sql.append(" where cfpartno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND (CFIsImport = 0 or cfquantity > 0)  ");
        paramList.add(this.designBOMBillInfo.getPartNo());
        paramList.add(4);
        if (this.designBOMBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.designBOMBillInfo.getProject().getId().toString());
        }
        if (this.designBOMBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.designBOMBillInfo.getDesignMode().getId().toString());
        }
        sql.append(" union  ");
        sql.append(" select distinct fstorageorgunitid As fDrawOrgUnitID  ");
        sql.append(" from ct_zjb_designbombill  ");
        sql.append(" where cfparentno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND (cfisimport = 0 or cfquantity > 0)  ");
        paramList.add(this.designBOMBillInfo.getPartNo());
        paramList.add(4);
        if (this.designBOMBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.designBOMBillInfo.getProject().getId().toString());
        }
        if (this.designBOMBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.designBOMBillInfo.getDesignMode().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fDrawOrgUnitID") == null || "".equals(rs.getString("fDrawOrgUnitID"))) continue;
                idList.add(rs.getString("fDrawOrgUnitID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return idList;
    }
}

