/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBomTempBillFactory;
import com.kingdee.eas.zjbom.DesignBomTempBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class BomUnConvertDesignBomTempProcess
extends BomUnConvertBaseProcess {
    public DesignBomTempBillInfo designBomTempBillInfo = null;

    @Override
    public void unConvert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.unConvert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getDesignBomTempBillInfo(ctx, entryInfo.getSourceBomID());
        if (this.checkData(ctx) && bomConvertFacadeFactory.getLocalInstance(ctx).unconvertRequired(this.designBomTempBillInfo, this.bomConvertLogInfo, this.bomConvertLogEntryInfo)) {
            this.afterUnConvert(ctx);
        }
    }

    public DesignBomTempBillInfo getDesignBomTempBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        this.designBomTempBillInfo = DesignBomTempBillFactory.getLocalInstance(ctx).getDesignBomTempBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.designBomTempBillInfo;
    }

    public boolean checkData(Context ctx) throws BOSException, EASBizException {
        if (!this.designBomTempBillInfo.isIsConvert()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoConvertStatus", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return false;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (this.designBomTempBillInfo.getConvertBomType() != null && this.designBomTempBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            sql.setLength(0);
            sql.append(" Select fid from ct_zjb_designbombill where  fsourcebillid = ? And cfstate =  4 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBomTempBillInfo.getId().toString()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"designBom_IsAudit", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBomTempBillInfo.getCU().getId().toString(), "emm_mm_zjbom_sjbom_sjbom_delete").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_DesignBom_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertDesignBomTempProcess.getOrgUnitName(ctx, this.designBomTempBillInfo.getCU().getId().toString())}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
        } else if (this.designBomTempBillInfo.getConvertBomType() != null && this.designBomTempBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fstorageorgunitid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourcebillentryid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.designBomTempBillInfo.getDesignMode().getId().toString(), this.designBomTempBillInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> orgUnitIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    if (orgUnitIDList.contains(rs.getString("fstorageorgunitid"))) continue;
                    orgUnitIDList.add(rs.getString("fstorageorgunitid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String errorNumber = null;
            sql.setLength(0);
            sql.append(" Select distinct h.fnumber ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            sql.append(" And h.fbasestatus = 4 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    if (errorNumber == null) {
                        errorNumber = rs.getString("fnumber");
                        continue;
                    }
                    errorNumber = errorNumber + "\u3001" + rs.getString("fnumber");
                }
                if (errorNumber != null && !errorNumber.equals("")) {
                    errorNumber = BomUtil.getBomTypeName(ctx, (String)bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsAudit_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    this.bomConvertLogEntryInfo.setExecResult(errorNumber);
                    this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execResult"));
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                    return false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String bomCheckResule = BomUtil.checkBomCanUnConvert(ctx, bomEntryIDList);
            if (bomCheckResule == null || !bomCheckResule.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(bomCheckResule);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (orgUnitIDList != null && orgUnitIDList.size() > 0) {
                for (int i = 0; i < orgUnitIDList.size(); ++i) {
                    if (this.checkPermission(ctx, ((String)orgUnitIDList.get(i)).toString(), "mm_bom_delete").booleanValue()) continue;
                    this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_BOM_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertDesignBomTempProcess.getOrgUnitName(ctx, ((String)orgUnitIDList.get(i)).toString())}));
                    this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execResult"));
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean execUnConvert(Context ctx, DesignBomTempBillInfo dbTempBillInfo) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (dbTempBillInfo.getConvertBomType() != null && dbTempBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            sql.setLength(0);
            sql.append(" delete from ct_zjb_designbombill where  fsourcebillid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbTempBillInfo.getId().toString()});
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbTempBillInfo.getId().toString(), "64455A59"});
        } else if (dbTempBillInfo.getConvertBomType() != null && dbTempBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fid As fbomid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourcebillentryid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{dbTempBillInfo.getDesignMode().getId().toString(), dbTempBillInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> bomIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    bomIDList.add(rs.getString("fbomid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            sql.setLength(0);
            sql.append(" delete from t_mm_bomentry where  fid in (").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_mm_bom where  fid in (").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And Not Exists(Select 1 from t_mm_bomentry where fparentid =  t_mm_bom .fid ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbTempBillInfo.getId().toString(), "8F409A89"});
        }
        return true;
    }

    @Override
    public void afterUnConvert(Context ctx) throws BOSException, EASBizException {
        super.afterUnConvert(ctx);
        this.updateDesignBomTempStatus(ctx);
    }

    public void updateDesignBomTempStatus(Context ctx) throws BOSException, EASBizException {
        this.designBomTempBillInfo.setIsConvert(false);
        this.designBomTempBillInfo.setConvertBomType(DBOMTypeEnum.NULL);
        this.designBomTempBillInfo.setConverDate(null);
        this.designBomTempBillInfo.setConverter(null);
        this.updateSic = new SelectorItemCollection();
        this.updateSic.add(new SelectorItemInfo("isConvert"));
        this.updateSic.add(new SelectorItemInfo("convertBomType"));
        this.updateSic.add(new SelectorItemInfo("converDate"));
        this.updateSic.add(new SelectorItemInfo("converter"));
        DesignBomTempBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.designBomTempBillInfo, this.updateSic);
    }
}

