/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.imm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.imm.ProjectBillBaseInfo;
import com.kingdee.eas.industry.emm.imm.app.AbstractProjectBillBaseControllerBean;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class ProjectBillBaseControllerBean
extends AbstractProjectBillBaseControllerBean {
    private static final long serialVersionUID = -4380387043119994739L;

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    private void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        ProjectBillBaseInfo prjBillInfo = (ProjectBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditDate = ?, FAuditorID = ? , FBillStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
                preStmt.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            } else {
                preStmt.setString(2, null);
            }
            preStmt.setInt(3, 15);
            preStmt.setString(4, prjBillInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    private void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        ProjectBillBaseInfo prjBillInfo = (ProjectBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditDate = ?, FAuditorID = ? , FBillStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, null);
            preStmt.setString(2, null);
            preStmt.setInt(3, 10);
            preStmt.setString(4, prjBillInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    protected boolean _checkAudit(Context ctx, IObjectValue model, boolean isOk) throws SCMBillException {
        ProjectBillBaseInfo prjBillBaseInfo = (ProjectBillBaseInfo)model;
        if (prjBillBaseInfo.getBillStatus() != null) {
            if (isOk) {
                if (prjBillBaseInfo.getBillStatus().getValue() == 15) {
                    throw new SCMBillException(SCMBillException.CHECKAUDITEDOK, new Object[]{prjBillBaseInfo.getString("number"), ""});
                }
            } else if (prjBillBaseInfo.getBillStatus().getValue() != 15) {
                throw new SCMBillException(SCMBillException.CHECKAUDITEDNOTOK, new Object[]{prjBillBaseInfo.getString("number"), ""});
            }
        }
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectBillBaseInfo prjBillBaseInfo = this.getProjectBillBaseInfo(ctx, pk);
        this._checkAudit(ctx, (IObjectValue)prjBillBaseInfo, true);
        super._delete(ctx, pk);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null && model == null) {
            return;
        }
        if (pk == null) {
            pk = new ObjectUuidPK(((ProjectBillBaseInfo)model).getId());
        }
        ProjectBillBaseInfo prjBillInfo = this.getProjectBillBaseInfo(ctx, pk);
        this.updateAuditStatus(ctx, (IObjectValue)prjBillInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)model;
        this._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)model;
        this._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), model);
        return super._submit(ctx, model);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.unpassAudit(ctx, pk, null);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null && model == null) {
            return;
        }
        if (pk == null) {
            pk = new ObjectUuidPK(((ProjectBillBaseInfo)model).getId());
        }
        ProjectBillBaseInfo prjBillInfo = this.getProjectBillBaseInfo(ctx, pk);
        this.updateUnAuditStatus(ctx, (IObjectValue)prjBillInfo);
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        return null;
    }
}

