/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.imm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.imm.ProjectCharterInfo;
import com.kingdee.eas.industry.emm.imm.app.AbstractProjectCharterControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;

public class ProjectCharterControllerBean
extends AbstractProjectCharterControllerBean {
    private static final long serialVersionUID = 2482873379324862410L;
    private String resClassName = "com.kingdee.eas.industry.emm.imm.EMMPROJECTImmResource";

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    private boolean isBillNumberDuplicate(Context ctx, BOSUuid id, String number) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        return this.getProjectCharterCollection(ctx, evi).size() > 0;
    }

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCharterInfo info = (ProjectCharterInfo)model;
        if (BillBaseStatusEnum.AUDITED.getAlias().equals(info.getBillstatus().getAlias())) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_YSHDJ")));
        }
        this._passAudit(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        ProjectCharterInfo charterInfo = (ProjectCharterInfo)model;
        String sql = "update CT_IMM_ProjectCharter set CFBillstatus=4, CFAuditTtime=GETDATE(),fauditorid='" + currentUser.getId() + "' where fid='" + charterInfo.getId() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        super._passAudit(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCharterInfo info = (ProjectCharterInfo)model;
        if (this.isBillNumberDuplicate(ctx, info.getId(), info.getNumber())) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_BMBNCF")));
        }
        if (BillBaseStatusEnum.ADD.getAlias().equals(info.getBillstatus().getAlias())) {
            info.setBillstatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCharterInfo info = (ProjectCharterInfo)model;
        if (this.isBillNumberDuplicate(ctx, info.getId(), info.getNumber())) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_BMBNCF")));
        }
        if (BillBaseStatusEnum.ADD.getAlias().equals(info.getBillstatus().getAlias()) || BillBaseStatusEnum.TEMPORARILYSAVED.getAlias().equals(info.getBillstatus().getAlias())) {
            info.setBillstatus(BillBaseStatusEnum.SUBMITED);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _unaudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectCharterInfo info = (ProjectCharterInfo)model;
        if (!BillBaseStatusEnum.AUDITED.getAlias().equals(info.getBillstatus().getAlias())) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_WSHBNFSH")));
        }
        this._unpassAudit(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectCharterInfo charterInfo = (ProjectCharterInfo)model;
        String sql = "update CT_IMM_ProjectCharter set CFBillstatus=2, CFAuditTtime=null,fauditorid=null where fid='" + charterInfo.getId() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        super._unpassAudit(ctx, pk, model);
    }
}

