/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.manufacturelocation.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedInfo;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.MaterialNameRuleEnum;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.MaterialNumRuleEnum;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.WGVBaseStatusEnum;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.WGVirtualMaterialDefFactory;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.WGVirtualMaterialDefInfo;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.app.AbstractWGVirtualMaterialDefControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WGVirtualMaterialDefControllerBean
extends AbstractWGVirtualMaterialDefControllerBean {
    private static final long serialVersionUID = -104990087422529291L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.app.WGVirtualMaterialDefControllerBean");
    private String resClassName = "com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource";

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WGVirtualMaterialDefInfo mdInfo = (WGVirtualMaterialDefInfo)model;
        mdInfo.setStatus(WGVBaseStatusEnum.CLOSE);
        super._cancel(ctx, pk, (IObjectValue)mdInfo);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("location"));
        selector.add(new SelectorItemInfo("location.name"));
        selector.add(new SelectorItemInfo("location.id"));
        WGVirtualMaterialDefInfo mdInfo = this.getWGVirtualMaterialDefInfo(ctx, pk, selector);
        LocationDefinedInfo locationInfo = mdInfo.getLocation();
        if (locationInfo != null) {
            String locationId = locationInfo.getId().toString();
            String locationName = locationInfo.getName();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("location.id", (Object)locationId, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)WGVBaseStatusEnum.OPEN, CompareType.EQUALS));
            boolean isExist = WGVirtualMaterialDefFactory.getLocalInstance(ctx).exists(filter);
            if (isExist) {
                throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_QYSB"), locationName + this.getResourceString(ctx, this.resClassName, "PROJECT_YJCZQYZTDGZ")));
            }
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("location", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)WGVBaseStatusEnum.OPEN, CompareType.EQUALS));
            boolean isExist = WGVirtualMaterialDefFactory.getLocalInstance(ctx).exists(filter);
            if (isExist) {
                throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_QYSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_YJCZQYZTDKGWGZ")));
            }
        }
        mdInfo.setStatus(WGVBaseStatusEnum.OPEN);
        super._cancelCancel(ctx, pk, (IObjectValue)mdInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WGVirtualMaterialDefInfo mdInfo = (WGVirtualMaterialDefInfo)model;
        String number = mdInfo.getNumber();
        if (!StringUtils.isEmpty((String)number)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim(), CompareType.INCLUDE));
            boolean isExist = WGVirtualMaterialDefFactory.getLocalInstance(ctx).exists(filter);
            if (isExist) {
                throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", "0EMMPROJECTBasedata-0005"), ResourceBase.getString((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", (String)"YJCZBMWJDGZ", (Locale)ctx.getLocale(), (Object[])new Object[]{number.trim()})));
            }
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isExist;
        WGVirtualMaterialDefInfo mdInfo = (WGVirtualMaterialDefInfo)model;
        String number = mdInfo.getNumber();
        BOSUuid id = mdInfo.getId();
        String name = mdInfo.getName();
        MeasureUnitInfo unit = mdInfo.getMeasureUnit();
        MaterialNameRuleEnum NameRule = mdInfo.getMaterialNameRule();
        MaterialNumRuleEnum numRule = mdInfo.getMaterialNumRule();
        MaterialGroupInfo mgroup = mdInfo.getMaterialGroup();
        mdInfo.setStatus(WGVBaseStatusEnum.SAVE);
        if (StringUtils.isEmpty((String)number)) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_GZBM_NOTNULL")));
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_GZMC_NOTNULL")));
        }
        if (NameRule == null) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_WLMCSCGZ_NOTNULL")));
        }
        if (numRule == null) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_WLBMSCGZ_NOTNULL")));
        }
        if (unit == null) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_JLDW_NOTNULL")));
        }
        if (mgroup == null) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_WLZ_NOTNULL")));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim(), CompareType.INCLUDE));
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        if (isExist = WGVirtualMaterialDefFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", "0EMMPROJECTBasedata-0005"), ResourceBase.getString((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", (String)"YJCZBMWJDGZ", (Locale)ctx.getLocale(), (Object[])new Object[]{number.trim()})));
        }
        return super._submit(ctx, (IObjectValue)mdInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WGVirtualMaterialDefInfo objInfo = this.getWGVirtualMaterialDefInfo(ctx, pk);
        if (WGVBaseStatusEnum.OPEN.equals((Object)objInfo.getStatus())) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_SCSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_QYZTWFSC")));
        }
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    protected void _deleteBatchData(Context arg0, IObjectPK[] arg1) throws BOSException, EASBizException {
        super._deleteBatchData(arg0, arg1);
    }
}

