/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialFactory;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialInfo;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanFactory;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanInfo;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialReplaceTypeEnum;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class ManufactureOrderStockProcess {
    public static ManufactureOrderStockInfo addStocksInfo(Context ctx, BomEntryInfo bomentryInfo, ManufactureOrderInfo moInfo, PBOMEntryInfo pbomentryInfo, ManufactureOrderTechnicsInfo techInfo, BigDecimal updateQty, BigDecimal funitUpdateQty) throws SQLException, EASBizException, BOSException {
        if (bomentryInfo == null && pbomentryInfo != null) {
            bomentryInfo = pbomentryInfo.getBomItem();
        }
        if (bomentryInfo == null) {
            return null;
        }
        ManufactureOrderStockInfo stockinfo = new ManufactureOrderStockInfo();
        Timestamp now = new Timestamp(new Date().getTime());
        int fseq = 0;
        if (moInfo.getStocks() != null && moInfo.getStocks().size() > 0) {
            for (int i = 0; i < moInfo.getStocks().size(); ++i) {
                if (moInfo.getStocks().get(i).getSeq() < fseq) continue;
                fseq = moInfo.getStocks().get(i).getSeq() + 1;
            }
        } else {
            fseq = moInfo.getId() != null ? ManufactureOrderStockProcess.getManufactureOrderStockMaxSeq(ctx, moInfo.getId().toString()) + 1 : 1;
        }
        stockinfo.setSeq(fseq);
        stockinfo.setParent(moInfo);
        BOSUuid id = BOSUuid.create((String)"ED498839");
        stockinfo.setId(id);
        BigDecimal convertRate = ManufactureOrderStockProcess.getConvertRate(ctx, moInfo, stockinfo);
        stockinfo.setQty(updateQty);
        stockinfo.setBaseQty(updateQty.multiply(convertRate));
        stockinfo.setDemandTime(techInfo.getEarlistWoktime());
        stockinfo.setOperationNo(techInfo.getOperationNo());
        stockinfo.setFlow(bomentryInfo.getBomFlow());
        stockinfo.setOperation(techInfo.getOperation());
        stockinfo.setWorkcenter(techInfo.getWorkcenter());
        stockinfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        stockinfo.setLineSeq(Integer.toString(10));
        stockinfo.setReplaceGroupFlag(0);
        ManufactureOrderStockProcess.setStocksInfoValue(ctx, bomentryInfo, moInfo, stockinfo, pbomentryInfo, funitUpdateQty, true);
        return stockinfo;
    }

    protected static BigDecimal getConvertRate(Context ctx, ManufactureOrderInfo moInfo, ManufactureOrderStockInfo stockInfo) throws BOSException, EASBizException {
        BigDecimal converRate = new BigDecimal(1);
        return converRate;
    }

    public static int getManufactureOrderStockMaxSeq(Context ctx, String fparentID) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Max(fseq) as fseq from t_mm_mftorderstock where fparentid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fparentID});
        if (rs.next()) {
            return rs.getInt("fseq");
        }
        return 0;
    }

    public static void setStocksInfoValue(Context ctx, BomEntryInfo bomentryInfo, ManufactureOrderInfo moInfo, ManufactureOrderStockInfo stockinfo, PBOMEntryInfo pbomentryInfo, BigDecimal funitUpdateQty, boolean isaddnew) throws SQLException, EASBizException, BOSException {
        if (bomentryInfo == null && pbomentryInfo != null) {
            bomentryInfo = pbomentryInfo.getBomItem();
        }
        if (bomentryInfo == null) {
            return;
        }
        stockinfo.setMaterial(bomentryInfo.getMaterial());
        stockinfo.setUnit(bomentryInfo.getMaterial().getBaseUnit());
        stockinfo.setBaseUnit(bomentryInfo.getMaterial().getBaseUnit());
        StorageOrgUnitInfo parentOrgUnitInfo = moInfo.getStorageOrgUnit();
        StorageOrgUnitInfo supplyOrgUnitInfo = null;
        supplyOrgUnitInfo = bomentryInfo != null && bomentryInfo.getSupplyOrgUnit() != null ? bomentryInfo.getSupplyOrgUnit() : null;
        CompanyOrgUnitInfo parentCompanyOrgUnitInfo = null;
        CompanyOrgUnitInfo supplyCompanyOrgUnitInfo = null;
        if (supplyOrgUnitInfo != null && parentOrgUnitInfo != null && !parentOrgUnitInfo.getId().toString().equals(supplyOrgUnitInfo.getId().toString())) {
            OrgUnitInfo orgUnitInfo = null;
            orgUnitInfo = ManufactureOrderStockProcess.getWTOrgUnitInfo(ctx, parentOrgUnitInfo.getId().toString(), 4, 1);
            if (orgUnitInfo != null) {
                parentCompanyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitInfo;
                orgUnitInfo = ManufactureOrderStockProcess.getWTOrgUnitInfo(ctx, supplyOrgUnitInfo.getId().toString(), 4, 1);
                if (orgUnitInfo != null) {
                    supplyCompanyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitInfo;
                }
            }
        }
        if (bomentryInfo != null) {
            stockinfo.setProvideType(bomentryInfo.getProvideType());
        }
        stockinfo.setStorageOrgUnit(supplyOrgUnitInfo);
        StorageOrgUnitInfo dispatchOrgUnitInfo = null;
        EMMMaterialPlanInfo ematerialplanInfo = null;
        ematerialplanInfo = EMMMaterialPlanFactory.getLocalInstance((Context)ctx).queryInfoByMaterial(parentOrgUnitInfo.getId().toString(), stockinfo.getMaterial().getId().toString());
        if (ematerialplanInfo != null) {
            dispatchOrgUnitInfo = ematerialplanInfo.getDistributionOrgUnit();
        }
        stockinfo.setDispatchOrgUnit(dispatchOrgUnitInfo);
        MaterialPlanInfo mpInfo = null;
        if (supplyOrgUnitInfo != null) {
            mpInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(stockinfo.getMaterial().getId().toString(), supplyOrgUnitInfo.getId().toString());
            String EMMIssueModeValueMode = ManufactureOrderStockProcess.getParamValue(ctx, "EMMIssueModeValueMode", supplyOrgUnitInfo.getId().toString());
            MaterialInventoryInfo minvInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getInventoryInfo(stockinfo.getMaterial().getId().toString(), supplyOrgUnitInfo.getId().toString());
            EMMMaterialInfo info = EMMMaterialFactory.getLocalInstance((Context)ctx).queryInfoByMaterial(supplyOrgUnitInfo.getId().toString(), stockinfo.getMaterial().getId().toString());
            stockinfo.setIslineStorehouse(info == null ? false : info.isIsLineStorehouse());
            if (minvInfo != null) {
                minvInfo.put("isWarehouse", (Object)(info == null ? false : info.isIsWarehouse()));
                minvInfo.put("islineStorehouse", (Object)(info == null ? false : info.isIsLineStorehouse()));
                stockinfo.put("islineStorehouse", (Object)((Boolean)minvInfo.get("isLineStorehouse")));
            }
            if (EMMIssueModeValueMode != null && "2".equals(EMMIssueModeValueMode)) {
                stockinfo.setIssueMode(mpInfo.getIssMode());
            } else if (EMMIssueModeValueMode != null && "3".equals(EMMIssueModeValueMode)) {
                if (minvInfo != null && minvInfo.get("isWarehouse") != null && ((Boolean)minvInfo.get("isWarehouse")).booleanValue()) {
                    stockinfo.setIssueMode(MaterialIssueModeEnum.PRODUCEISSMODE);
                } else {
                    stockinfo.setIssueMode(MaterialIssueModeEnum.NOTISSMODE);
                }
            } else {
                stockinfo.setIssueMode(bomentryInfo.getIssMode());
            }
            if (stockinfo.getIssueMode() == null) {
                stockinfo.setIssueMode(MaterialIssueModeEnum.NOTISSMODE);
            }
        } else if (supplyOrgUnitInfo != null) {
            mpInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(stockinfo.getMaterial().getId().toString(), supplyOrgUnitInfo.getId().toString());
        }
        if (bomentryInfo.getTransferOrgUnit() != null) {
            stockinfo.setReceiptStroageOrgUnit(bomentryInfo.getTransferOrgUnit());
        } else {
            stockinfo.setReceiptStroageOrgUnit(bomentryInfo.getSupplyOrgUnit());
        }
        stockinfo.setBomEntryID(bomentryInfo.getId().toString());
        stockinfo.setIsStockAllot(bomentryInfo.isIsStockTransfer());
        if (stockinfo.getProvideType() == MaterialProvideTypeEnum.CURRENTORGPROVIDE) {
            stockinfo.setPickType(PickTypeEnum.INNERORG);
        } else if (stockinfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE && stockinfo.getStorageOrgUnit() != null && stockinfo.getReceiptStroageOrgUnit() != null && StringUtils.equals((String)stockinfo.getStorageOrgUnit().getId().toString(), (String)stockinfo.getReceiptStroageOrgUnit().getId().toString())) {
            stockinfo.setPickType(PickTypeEnum.INNERORG);
        } else {
            stockinfo.setPickType(PickTypeEnum.OTHERSTORAGE);
        }
        if (stockinfo.isIsStockAllot() && stockinfo.getReceiptStroageOrgUnit() != null) {
            StorageOrgUnitInfo issueStorageOrgUnit = stockinfo.getReceiptStroageOrgUnit();
            if (parentOrgUnitInfo.getId().toString().equals(issueStorageOrgUnit.getId().toString())) {
                stockinfo.setTransferType(OrderStockTransferTypeEnum.WAREHOUSE);
            } else {
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection issueCompanyOrgCol = iUnitRel.getToUnit(issueStorageOrgUnit.getId().toString(), 4, 1);
                CompanyOrgUnitInfo issueCompanyOrgUnit = (CompanyOrgUnitInfo)issueCompanyOrgCol.get(0);
                if (parentCompanyOrgUnitInfo != null && issueCompanyOrgUnit != null && parentCompanyOrgUnitInfo.getId().toString().equals(issueCompanyOrgUnit.getId().toString())) {
                    stockinfo.setTransferType(OrderStockTransferTypeEnum.STORAGE);
                } else {
                    stockinfo.setTransferType(OrderStockTransferTypeEnum.FINANCE);
                }
            }
        } else {
            stockinfo.setTransferType(OrderStockTransferTypeEnum.NULL);
        }
        stockinfo.setNewnetWeight(bomentryInfo.getConsumeFixQty());
        stockinfo.setBlkSize(bomentryInfo.getBlkSize());
        stockinfo.setSpecifiedLength(bomentryInfo.getSpecifiedLength());
        stockinfo.setIsReplaced(false);
        ManufactureOrderStockProcess.setStocksInfoNumberValue(ctx, moInfo, bomentryInfo, stockinfo, funitUpdateQty, isaddnew, mpInfo);
        if (stockinfo.getWorkcenter() != null) {
            if (stockinfo.getWorkcenter().getAdminOrgUnit() == null) {
                WorkCenterInfo wcInfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(stockinfo.getWorkcenter().getId()));
                stockinfo.setPickDept(wcInfo.getAdminOrgUnit());
            } else {
                stockinfo.setPickDept(stockinfo.getWorkcenter().getAdminOrgUnit());
            }
        }
        if (pbomentryInfo != null) {
            stockinfo.setIsMustReq(pbomentryInfo.isIsMustReq());
        } else {
            stockinfo.setIsMustReq(false);
        }
        if (stockinfo.getWarehouse() == null) {
            ManufactureOrderStockProcess.setStockWarehouseInfo(ctx, moInfo, stockinfo, bomentryInfo);
        }
        if (pbomentryInfo != null) {
            stockinfo.setIssueProp(pbomentryInfo.getIssueProp());
        } else if (bomentryInfo != null) {
            stockinfo.setIssueProp(bomentryInfo.getIssueProp());
        }
    }

    public static BigDecimal getbomRateQty(Context ctx, BomInfo bomInfo, ManufactureOrderInfo moInfo, BomEntryInfo bomentryInfo, BigDecimal foldqty) throws BOSException, EASBizException {
        BigDecimal fnewqty = foldqty;
        if (bomentryInfo != null) {
            if (bomInfo == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("productBaseQty"));
                sic.add(new SelectorItemInfo("productQty"));
                sic.add(new SelectorItemInfo("id"));
                bomInfo = bomentryInfo.getParent();
                bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()), sic);
            }
            BigDecimal FProductQty = bomInfo.getProductQty();
            MeasureUnitInfo productUnitInfo = ManufactureOrderStockProcess.getMPProductUnitInfo(ctx, moInfo.getMaterial().getId().toString(), moInfo.getStorageOrgUnit().getId().toString());
            MultiMeasureUnitInfo billMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo(ctx, moInfo.getMaterial().getId().toString(), moInfo.getUnit().getId().toString());
            MultiMeasureUnitInfo productMultiMeasureUnitInfo = null;
            if (productUnitInfo != null) {
                productMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo(ctx, moInfo.getMaterial().getId().toString(), productUnitInfo.getId().toString());
            }
            BigDecimal converRate = new BigDecimal(1);
            if (billMultiMeasureUnitInfo != null && productMultiMeasureUnitInfo != null && billMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate().compareTo(BigDecimal.ZERO) != 0) {
                converRate = billMultiMeasureUnitInfo.getBaseConvsRate().divide(productMultiMeasureUnitInfo.getConversionRate(), 4, 4);
            }
            if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.VariableAmount) && converRate != null) {
                if (FProductQty != null && FProductQty.compareTo(BigDecimal.ZERO) != 0) {
                    fnewqty = new BigDecimal(1).divide(FProductQty, 4, 4).multiply(foldqty).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision(), 4);
                }
            } else if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.Proportion) && converRate != null && bomentryInfo.getBaseProductRate() != null && bomentryInfo.getBaseProductRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getBaseRate() != null && bomentryInfo.getBaseRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getProportion() != null) {
                fnewqty = bomInfo.getProductBaseQty().divide(bomentryInfo.getBaseProductRate(), 4, 4).divide(bomentryInfo.getBaseRate(), 4, 4).multiply(bomentryInfo.getProportion().multiply(new BigDecimal(0.01))).divide(bomInfo.getProductQty(), 4, 4).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision(), 4);
            }
        }
        return fnewqty;
    }

    public static MeasureUnitInfo getMPProductUnitInfo(Context ctx, String materialid, String orgUnitID) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("productUnit.id"));
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.setSelector(sic);
        MaterialPlanCollection coll = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(ev);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getProductUnit();
        }
        return null;
    }

    protected static void setStocksInfoNumberValue(Context ctx, ManufactureOrderInfo moInfo, BomEntryInfo bomentryInfo, ManufactureOrderStockInfo stockinfo, BigDecimal funitUpdateQty, boolean isaddnew, MaterialPlanInfo mpInfo) throws SQLException, EASBizException, BOSException {
        BigDecimal convertRate = ManufactureOrderStockProcess.getConvertRate(ctx, moInfo, stockinfo);
        BigDecimal updateQty = stockinfo.getQty();
        if (funitUpdateQty != null && funitUpdateQty.compareTo(BigDecimal.ZERO) > 0) {
            stockinfo.setUnitQty(funitUpdateQty);
            stockinfo.setUnitBaseQty(funitUpdateQty.multiply(convertRate));
        } else if (stockinfo.getUnitQty() == null) {
            stockinfo.setUnitQty(BigDecimal.ZERO);
            stockinfo.setUnitBaseQty(BigDecimal.ZERO);
        }
        if (bomentryInfo != null && bomentryInfo.getScrapRatio() != null) {
            stockinfo.setLossRatio(bomentryInfo.getScrapRatio());
        } else {
            stockinfo.setLossRatio(BigDecimal.ZERO);
        }
        stockinfo.setLossQty(updateQty.multiply(stockinfo.getLossRatio().multiply(new BigDecimal(0.01))));
        stockinfo.setLossBaseQty(stockinfo.getLossQty().multiply(convertRate));
        BigDecimal fplannedQty = ManufactureOrderStockProcess.getStockPlannedQty(ctx, moInfo, bomentryInfo, stockinfo);
        stockinfo.setPlannedBaseQty(fplannedQty.multiply(convertRate));
        stockinfo.setPlannedQty(fplannedQty);
        stockinfo.setAssociateQty(updateQty);
        stockinfo.setOriginalPlanQty(stockinfo.getPlannedQty());
        stockinfo.setOriginalPlanBaseQty(stockinfo.getPlannedBaseQty());
        stockinfo.setDividedQty(stockinfo.getOriginalPlanQty());
        if (isaddnew) {
            stockinfo.setExtraRatio(BigDecimal.ZERO);
            stockinfo.setLackRatio(BigDecimal.ZERO);
            stockinfo.setActureLossRatio(BigDecimal.ZERO);
            stockinfo.setActIssueQty(BigDecimal.ZERO);
            stockinfo.setActIssueBaseQty(BigDecimal.ZERO);
            stockinfo.setActLossQty(BigDecimal.ZERO);
            stockinfo.setActureLossRatio(BigDecimal.ZERO);
            stockinfo.setRejectedQty(BigDecimal.ZERO);
            stockinfo.setFeedingQty(BigDecimal.ZERO);
            stockinfo.setMaterialFeedingQty(BigDecimal.ZERO);
            stockinfo.setScrapQty(BigDecimal.ZERO);
            stockinfo.setMaterialScrapQty(BigDecimal.ZERO);
            stockinfo.setWipQty(BigDecimal.ZERO);
            stockinfo.setTotalDirectReceiveQty(BigDecimal.ZERO);
            stockinfo.setTotalReceiptBaseQty(BigDecimal.ZERO);
            stockinfo.setTotalReceiptQty(BigDecimal.ZERO);
            stockinfo.setReplaceGroupFlag(0);
            stockinfo.setReplaceRatio(SysConstant.BIGZERO);
            stockinfo.setUnitReplaceQty(SysConstant.BIGZERO);
            stockinfo.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
            stockinfo.setUnReceiptQty(BigDecimal.ZERO);
            stockinfo.setUnReceiptBaseQty(BigDecimal.ZERO);
            stockinfo.setDirectPurchaseQty(SysConstant.BIGZERO);
        }
        stockinfo.setUnIssueQty(fplannedQty.subtract(stockinfo.getActIssueQty()));
        stockinfo.setUnIssueBaseQty(stockinfo.getPlannedBaseQty().subtract(stockinfo.getActIssueBaseQty()));
        BigDecimal extraRatio = new BigDecimal(0);
        if (mpInfo != null) {
            stockinfo.setIsQtyLimit(mpInfo.isIsQuotaControl());
        }
        if (mpInfo != null && mpInfo.isIsQuotaControl() && mpInfo.getIssInHightLimit() != null) {
            extraRatio = mpInfo.getIssInHightLimit();
            stockinfo.setExtraRatio(extraRatio);
        }
        BigDecimal lackRatio = new BigDecimal(0);
        if (mpInfo != null && mpInfo.isIsQuotaControl() && mpInfo.getIssInLowLimit() != null) {
            lackRatio = mpInfo.getIssInLowLimit();
            stockinfo.setLackRatio(lackRatio);
        }
        BigDecimal PickExtraQty = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0")).multiply(fplannedQty);
        stockinfo.setPickExtraQty(PickExtraQty);
        stockinfo.setPickExtraBaseQty(PickExtraQty.multiply(convertRate));
        BigDecimal PickLackQty = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4)).multiply(fplannedQty);
        stockinfo.setPickLackQty(PickLackQty);
        stockinfo.setPickLackBaseQty(PickLackQty.multiply(convertRate));
    }

    protected static OrgUnitInfo getWTOrgUnitInfo(Context ctx, String fromOrgUnitID, int fromOrgType, int toOrgType) throws SQLException, EASBizException, BOSException {
        IOrgUnitRelation iUnitRel;
        OrgUnitCollection cols;
        OrgUnitInfo orgUnitInfo = null;
        if (fromOrgUnitID != null && (cols = (iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(fromOrgUnitID, fromOrgType, toOrgType)).size() > 0) {
            orgUnitInfo = cols.get(0);
        }
        return orgUnitInfo;
    }

    protected static void setStockWarehouseInfo(Context ctx, ManufactureOrderInfo moInfo, ManufactureOrderStockInfo stockInfo, BomEntryInfo bomentryInfo) throws SQLException, EASBizException, BOSException {
        FullOrgUnitInfo unit1;
        String isWarehouseFromBOMEntryValue;
        Boolean isWarehouseFromBOMEntry;
        boolean isContinue = true;
        WarehouseInfo warehouseInfo = new WarehouseInfo();
        String fstorageOrgUnitID = null;
        String fsupplyOrgUnitID = null;
        fstorageOrgUnitID = moInfo.getStorageOrgUnit().getId().toString();
        if (stockInfo != null && stockInfo.getStorageOrgUnit() != null) {
            fsupplyOrgUnitID = stockInfo.getStorageOrgUnit().getId().toString();
        }
        if ((isWarehouseFromBOMEntry = Boolean.valueOf((isWarehouseFromBOMEntryValue = ManufactureOrderStockProcess.getParamValue(ctx, "GMOSWHFBOM", (unit1 = (FullOrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString())) == null ? false : "true".equals(isWarehouseFromBOMEntryValue))).booleanValue() && bomentryInfo != null && bomentryInfo.getDefaultWarehouse() != null) {
            warehouseInfo.setId(bomentryInfo.getDefaultWarehouse().getId());
            warehouseInfo.setName(bomentryInfo.getDefaultWarehouse().getName());
            stockInfo.setWarehouse(warehouseInfo);
            isContinue = false;
        }
        if (isContinue) {
            String defaultWarehouse;
            Boolean isMOSWarehouseFromOrderStorageOrgUnit = false;
            String isMOSWarehouseFromOrderStorageOrgUnitValue = ManufactureOrderStockProcess.getParamValue(ctx, "MPSGMOSWFOS", unit1.getId().toString());
            Boolean isMOSWarehouse = isMOSWarehouseFromOrderStorageOrgUnitValue == null ? false : "true".equals(isMOSWarehouseFromOrderStorageOrgUnitValue);
            if (stockInfo.getProvideType().getValue() == 10920 && isMOSWarehouse.booleanValue()) {
                isMOSWarehouseFromOrderStorageOrgUnit = true;
            }
            Boolean defaultWarehousemodel = (defaultWarehouse = ManufactureOrderStockProcess.getParamValue(ctx, "defaultWarehouse", unit1.getId().toString())) == null ? false : "true".equals(defaultWarehouse);
            MaterialInventoryInfo minvInfo = null;
            minvInfo = isMOSWarehouseFromOrderStorageOrgUnit != false ? Material8FacadeFactory.getLocalInstance((Context)ctx).getInventoryInfo(stockInfo.getMaterial().getId().toString(), fstorageOrgUnitID) : Material8FacadeFactory.getLocalInstance((Context)ctx).getInventoryInfo(stockInfo.getMaterial().getId().toString(), fsupplyOrgUnitID);
            if (defaultWarehousemodel.booleanValue() && minvInfo != null && minvInfo.getDefaultWarehouse() != null && warehouseInfo.getId() == null) {
                warehouseInfo.setId(minvInfo.getDefaultWarehouse().getId());
                warehouseInfo.setName(minvInfo.getDefaultWarehouse().getName());
                stockInfo.setWarehouse(warehouseInfo);
            }
        }
        if (stockInfo.getProvideType().equals((Object)10920)) {
            stockInfo.setReceiptStock(stockInfo.getWarehouse());
        }
    }

    public static boolean isConsiderLossRatio(Context ctx, ManufactureOrderInfo moInfo) throws BOSException, EASBizException {
        if (moInfo == null || moInfo.getTransactionType() == null) {
            return false;
        }
        ProductTransactionTypeInfo transInfo = moInfo.getTransactionType();
        if (transInfo.get("isConsiderLossRatio") == null) {
            transInfo = ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transInfo.getId()));
        }
        return transInfo.isIsConsiderLossRatio();
    }

    protected static BigDecimal getStockPlannedQty(Context ctx, ManufactureOrderInfo moInfo, BomEntryInfo bomentryInfo, ManufactureOrderStockInfo stockInfo) throws BOSException, EASBizException {
        BigDecimal fplannedQty = stockInfo.getQty();
        if (ManufactureOrderStockProcess.isConsiderLossRatio(ctx, moInfo)) {
            fplannedQty = stockInfo.getQty().add(stockInfo.getLossQty());
        }
        return fplannedQty;
    }

    protected static String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    public static MultiMeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String fmaterialid, String funitid) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)fmaterialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)funitid, CompareType.EQUALS));
        ev.setFilter(filter);
        MultiMeasureUnitCollection coll = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(ev);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static boolean isNeedAddMaterialReqBill(Context ctx, ManufactureOrderTechnicsInfo techInfo) throws SQLException, EASBizException, BOSException {
        return false;
    }

    public static void updateStockInfoMpValue(Context ctx, ManufactureOrderStockInfo stockinfo) throws SQLException, EASBizException, BOSException {
        if (stockinfo == null) {
            return;
        }
        if (stockinfo.getMaterial() == null || stockinfo.getStorageOrgUnit() == null) {
            return;
        }
        MaterialPlanInfo mpInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(stockinfo.getMaterial().getId().toString(), stockinfo.getStorageOrgUnit().getId().toString());
        BigDecimal convertRate = new BigDecimal(1);
        BigDecimal updateQty = stockinfo.getQty();
        stockinfo.setLossQty(updateQty.multiply(stockinfo.getLossRatio().multiply(new BigDecimal(0.01))));
        stockinfo.setLossBaseQty(stockinfo.getLossQty().multiply(convertRate));
        stockinfo.setAssociateQty(updateQty);
        stockinfo.setOriginalPlanQty(stockinfo.getPlannedQty());
        stockinfo.setOriginalPlanBaseQty(stockinfo.getPlannedBaseQty());
        BigDecimal extraRatio = new BigDecimal(0);
        if (mpInfo != null) {
            stockinfo.setIsQtyLimit(mpInfo.isIsQuotaControl());
        }
        if (mpInfo != null && mpInfo.isIsQuotaControl() && mpInfo.getIssInHightLimit() != null) {
            extraRatio = mpInfo.getIssInHightLimit();
            stockinfo.setExtraRatio(extraRatio);
        }
        BigDecimal lackRatio = new BigDecimal(0);
        if (mpInfo != null && mpInfo.isIsQuotaControl() && mpInfo.getIssInLowLimit() != null) {
            lackRatio = mpInfo.getIssInLowLimit();
            stockinfo.setLackRatio(lackRatio);
        }
        BigDecimal PickExtraQty = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0")).multiply(stockinfo.getPlannedQty());
        stockinfo.setPickExtraQty(PickExtraQty);
        stockinfo.setPickExtraBaseQty(PickExtraQty.multiply(convertRate));
        BigDecimal PickLackQty = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4)).multiply(stockinfo.getPlannedQty());
        stockinfo.setPickLackQty(PickLackQty);
        stockinfo.setPickLackBaseQty(PickLackQty.multiply(convertRate));
    }
}

