/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.binv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.binv.BalInventoryRecordEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.binv.BalInventoryRecordFactory;
import com.kingdee.eas.industry.emm.project.biz.binv.BalInventoryRecordInfo;
import com.kingdee.eas.industry.emm.project.biz.binv.IBalInventoryRecord;
import com.kingdee.eas.industry.emm.project.biz.binv.app.AbstractBalInventoryRecordControllerBean;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPElementEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillFactory;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BalInventoryRecordControllerBean
extends AbstractBalInventoryRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.binv.app.BalInventoryRecordControllerBean");

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    protected IRowSet _getTransBill(Context ctx, Map dataMap) throws BOSException, EASBizException {
        IRowSet rs = null;
        if (dataMap == null || dataMap.get("plannedOrderID") == null || "".equals(dataMap.get("plannedOrderID").toString())) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        String plannedOrderID = dataMap.get("plannedOrderID").toString();
        sql.append(" Select a.fid As ftransBillid,  \r\n");
        sql.append(" a.fid as ftransBillEntryID,  \r\n");
        sql.append(" '\u5373\u65f6\u5e93\u5b58' As ftransBillType,  \r\n");
        sql.append(" '\u5373\u65f6\u5e93\u5b58' As ftransBillNumber,  \r\n");
        sql.append(" m.fid as fmaterialid,  \r\n");
        sql.append(" m.fnumber as fmaterialNumber,  \r\n");
        sql.append(" m.fname_l2 as fmaterialName,  \r\n");
        sql.append("  m.fmodel as fmaterialModel,  \r\n");
        sql.append(" unit.fname_l2 as funitName,  \r\n");
        sql.append(" s.fid as fstorageOrgUnitID,  \r\n");
        sql.append(" s.fname_l2 as fstorageOrgUnitName,  \r\n");
        sql.append(" warehouse.fid as fwarehouseid,  \r\n");
        sql.append(" warehouse.fname_l2 as fwarehouseName,  \r\n");
        sql.append(" location.fid as flocationid,  \r\n");
        sql.append(" location.fname_l2 as flocationName,  \r\n");
        sql.append(" project.fid as fprojectid,  \r\n");
        sql.append(" project.fnumber as fprojectnumber,  \r\n");
        sql.append(" project.fname_l2 as fprojectName,  \r\n");
        sql.append(" track.fid as ftrackid,  \r\n");
        sql.append("  track.fnumber as ftrackNumber,  \r\n");
        sql.append("  track.fname_l2 as ftrakcName,  \r\n");
        sql.append("  a.fcurstoreqty as fqty,  \r\n");
        sql.append("  a.flot as flot,  \r\n");
        sql.append("  b.fid as fplannedOrderID,  \r\n");
        sql.append("  b.fnumber as fplannedOrderNumber  \r\n");
        sql.append(" from t_im_inventory a  \r\n");
        sql.append(" inner join t_mrp_pmrpplannedorder b on b.fmaterialid = a.fmaterialid and b.fstorageorgunitid = a.fstorageorgunitid \r\n");
        sql.append(" left outer join t_bd_material m on m.fid  = a.fmaterialid  \r\n");
        sql.append(" left outer join t_org_storage s on s.fid = a.fstorageorgunitid  \r\n");
        sql.append(" left outer join t_db_warehouse warehouse on warehouse.fid = a.fwarehouseid  \r\n");
        sql.append(" left outer join t_db_location location on location.fid = a.flocationid  \r\n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = a.funitid  \r\n");
        sql.append(" left outer join t_mm_project project on project.fid = a.fprojectid  \r\n");
        sql.append(" left outer join t_mm_tracknumber track on track.fid = a.ftracknumberid  \r\n");
        sql.append(" left outer join t_mm_project p1 on p1.fid = b.fprojectid  \r\n");
        sql.append(" left outer join t_mm_tracknumber t1 on t1.fid = b.ftrackid  \r\n");
        sql.append(" where a.fcurstoreqty > 0 and (project.fbasestatus = 7 or track.FStatus = 80 )  \r\n");
        sql.append(" And  b.fid = '").append(plannedOrderID).append("'  \r\n");
        sql.append(" and (p1.fid is not null and p1.fbasestatus <> 7 )  \r\n");
        sql.append(" and (t1.fid is null or t1.FStatus <> 80 )  \r\n");
        sql.append(" union  \r\n");
        sql.append(" select mh.fid As ftransBillid,  \r\n");
        sql.append(" mh.fid as ftransBillEntryID,  \r\n");
        sql.append(" '\u751f\u4ea7\u8ba2\u5355' As ftransBillType,  \r\n");
        sql.append(" to_char(mh.fnumber) As ftransBillNumber,  \r\n");
        sql.append(" m.fid as fmaterialid,  \r\n");
        sql.append(" m.fnumber as fmaterialNumber,  \r\n");
        sql.append(" m.fname_l2 as fmaterialName,  \r\n");
        sql.append(" m.fmodel as fmaterialModel,  \r\n");
        sql.append(" unit.fname_l2 as funitName,  \r\n");
        sql.append(" s.fid as fstorageOrgUnitID,  \r\n");
        sql.append(" s.fname_l2 as fstorageOrgUnitName,  \r\n");
        sql.append(" null as fwarehouseid,  \r\n");
        sql.append(" null as fwarehouseName,  \r\n");
        sql.append(" null as flocationid,  \r\n");
        sql.append(" null as flocationName,  \r\n");
        sql.append("  project.fid as fprojectid,  \r\n");
        sql.append("  project.fnumber as fprojectnumber,  \r\n");
        sql.append("  project.fname_l2 as fprojectName,  \r\n");
        sql.append(" track.fid as ftrackid,  \r\n");
        sql.append(" track.fnumber as ftrackNumber,  \r\n");
        sql.append(" track.fname_l2 as ftrakcName,  \r\n");
        sql.append("  (mh.fqty - isnull(mh.ftostroreqty,0)) as fqty,  \r\n");
        sql.append("  null as flot,  \r\n");
        sql.append("  b.fid as fplannedOrderID,  \r\n");
        sql.append("  b.fnumber as fplannedOrderNumber  \r\n");
        sql.append(" from t_mm_manufactureorder mh  \r\n");
        sql.append(" inner join t_mrp_pmrpplannedorder b on b.fmaterialid = mh.fmaterialid and b.fstorageorgunitid = mh.fstorageorgunitid \r\n");
        sql.append(" left outer join t_bd_material m on m.fid  = mh.fmaterialid  \r\n");
        sql.append(" left outer join t_org_storage s on s.fid = mh.fstorageorgunitid  \r\n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = mh.funitid  \r\n");
        sql.append(" left outer join t_mm_project project on project.fid = mh.fprojectid  \r\n");
        sql.append(" left outer join t_mm_tracknumber track on track.fid = mh.ftrackid  \r\n");
        sql.append(" where mh.fbasestatus in(0,1,2,4,5)  \r\n");
        sql.append(" and mh.fqty - isnull(mh.ftostroreqty,0) > 0  \r\n");
        sql.append(" And  b.fid = '").append(plannedOrderID).append("'  \r\n");
        sql.append(" And  b.fprojectid is not null  \r\n");
        sql.append(" And  b.fordertype = 10  \r\n");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected void _balInventory(Context ctx, List dataList) throws BOSException, EASBizException {
        if (dataList == null || dataList.size() < 1) {
            return;
        }
        IBalInventoryRecord ib = BalInventoryRecordFactory.getLocalInstance(ctx);
        for (int i = 0; i < dataList.size(); ++i) {
            NumericExceptionSubItem interfaceException;
            String thisqty;
            BigDecimal ftransQty;
            HashMap datamap = new HashMap();
            datamap = (HashMap)dataList.get(i);
            String plannedorderID = datamap.get("plannedorderID").toString();
            String transBillID = datamap.get("transBillID").toString();
            String transBillType = datamap.get("transBillType").toString();
            if (datamap.get("thisqty") == null || "".equals(datamap.get("thisqty").toString()) || (ftransQty = new BigDecimal(thisqty = datamap.get("thisqty").toString())) == null || ftransQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BalInventoryRecordInfo info = new BalInventoryRecordInfo();
            BalInventoryRecordEntryInfo entryInfo = new BalInventoryRecordEntryInfo();
            PMRPPlannedOrderInfo plannedOrderInfo = PMRPPlannedOrderFactory.getLocalInstance(ctx).getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(plannedorderID));
            if (plannedOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
                interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0000") + "[" + plannedOrderInfo.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0001"));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (!plannedOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0000") + "[" + plannedOrderInfo.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0002"));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (plannedOrderInfo.getQty().compareTo(plannedOrderInfo.getTotalReleaseQty()) <= 0) {
                interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0000") + "[" + plannedOrderInfo.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0003"));
                throw new InterfaceDataBaseException(interfaceException);
            }
            MaterialInfo materialInfo = null;
            WarehouseInfo outwarehouseInfo = null;
            LocationInfo outlocationInfo = null;
            String outflot = null;
            ProjectInfo outprojectInfo = null;
            TrackNumberInfo outtrackNumberInfo = null;
            if (transBillType.equals("\u5373\u65f6\u5e93\u5b58")) {
                InventoryInfo invInfo = InventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo((IObjectPK)new ObjectUuidPK(transBillID));
                outwarehouseInfo = invInfo.getWarehouse();
                outlocationInfo = invInfo.getLocation();
                outflot = invInfo.getLot();
                outprojectInfo = invInfo.getProject();
                outtrackNumberInfo = invInfo.getTrackNumber();
                materialInfo = invInfo.getMaterial();
                entryInfo.setTransBillEntryID(null);
                entryInfo.setTransBillID(invInfo.getId().toString());
                entryInfo.setTransBillNumber(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0004"));
                entryInfo.setTransBillType(PMRPElementEnum.I_CurInv);
            } else if (transBillType.equals("\u751f\u4ea7\u8ba2\u5355")) {
                ManufactureOrderInfo mInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(transBillID));
                outflot = mInfo.getLot();
                outprojectInfo = mInfo.getProject();
                outtrackNumberInfo = mInfo.getTrackNumber();
                materialInfo = mInfo.getMaterial();
                entryInfo.setTransBillEntryID(null);
                entryInfo.setTransBillID(mInfo.getId().toString());
                entryInfo.setTransBillNumber(mInfo.getNumber());
                entryInfo.setTransBillType(PMRPElementEnum.S_ManufactureOrder);
            }
            entryInfo.setMaterial(materialInfo);
            entryInfo.setOutLocation(outlocationInfo);
            entryInfo.setOutLot(outflot);
            entryInfo.setOutProject(outprojectInfo);
            entryInfo.setOutTrackNumber(outtrackNumberInfo);
            entryInfo.setOutWarehouse(outwarehouseInfo);
            entryInfo.setQty(ftransQty);
            entryInfo.setInLocation(outlocationInfo);
            entryInfo.setInLot(outflot);
            entryInfo.setInTrackNumber(plannedOrderInfo.getTrackNumber());
            entryInfo.setInProject(plannedOrderInfo.getProject());
            entryInfo.setInWarehouse(outwarehouseInfo);
            info.setStorageOrgUnit(plannedOrderInfo.getStorageOrgUnit());
            this.setBillNumber(ctx, (IObjectValue)info, plannedOrderInfo.getStorageOrgUnit().getId().toString());
            info.setBizDate(new Date());
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            info.setDescription(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0000") + "[" + plannedOrderInfo.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0005"));
            info.setSourceBillId(plannedOrderInfo.getId().toString());
            info.getEntrys().add(entryInfo);
            IObjectPK pk = ib.submit((CoreBaseInfo)info);
            ib.passAudit(pk, info);
        }
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    @Override
    protected void _unbalInventory(Context ctx, List dataList) throws BOSException, EASBizException {
        if (dataList == null || dataList.size() < 1) {
            return;
        }
        IBalInventoryRecord ib = BalInventoryRecordFactory.getLocalInstance(ctx);
        ArrayList<String> execList = new ArrayList<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            String fid = dataList.get(i).toString();
            if (execList.contains(fid)) continue;
            execList.add(fid);
            ObjectUuidPK pk = new ObjectUuidPK(fid);
            if (!ib.exists((IObjectPK)pk)) continue;
            BalInventoryRecordInfo info = ib.getBalInventoryRecordInfo((IObjectPK)pk);
            if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                ib.unpassAudit((IObjectPK)pk, info);
            }
            ib.delete((IObjectPK)pk);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        BalInventoryRecordInfo info = BalInventoryRecordFactory.getLocalInstance(ctx).getBalInventoryRecordInfo(pk);
        if (info.getBaseStatus() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0007"));
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BalInventoryRecordInfo info = (BalInventoryRecordInfo)model;
        this.checkSubmit(ctx, info);
        return super._submit(ctx, model);
    }

    protected void checkSubmit(Context ctx, BalInventoryRecordInfo info) throws BOSException, EASBizException {
        if (info.getNumber() == null || "".equals(info.getNumber())) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0008"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getBaseStatus() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0009"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getStorageOrgUnit() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0010"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getEntrys() == null || info.getEntrys().size() < 1) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0011"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getMaterial() == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0012"));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (info.getEntrys().get(i).getQty() != null && info.getEntrys().get(i).getQty().compareTo(BigDecimal.ZERO) > 0) continue;
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0013"));
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BalInventoryRecordInfo info = null;
        info = model != null ? (BalInventoryRecordInfo)model : BalInventoryRecordFactory.getLocalInstance(ctx).getBalInventoryRecordInfo(pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0014"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        super._passAudit(ctx, pk, model);
        BalInventoryRecordEntryInfo entryInfo = null;
        PMRPPlannedOrderInfo plannedOrderInfo = null;
        if (info.getSourceBillId() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0015"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        plannedOrderInfo = PMRPPlannedOrderFactory.getLocalInstance(ctx).getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entryInfo = info.getEntrys().get(i);
            String ftransBillID = null;
            ftransBillID = entryInfo.getTransBillID();
            if (entryInfo.getTransBillType().equals((Object)PMRPElementEnum.I_CurInv)) {
                if (!InventoryFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(ftransBillID))) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0016") + "[" + ftransBillID + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0017"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                InventoryInfo invInfo = InventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo((IObjectPK)new ObjectUuidPK(ftransBillID));
                if (invInfo.getCurStoreQty().compareTo(entryInfo.getQty()) < 0) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0018") + "[" + invInfo.getCurStoreQty() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0019") + entryInfo.getQty() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0020"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                MatAttrChangeBillInfo billInfo = new MatAttrChangeBillInfo();
                billInfo.setStorageOrgUnit(info.getStorageOrgUnit());
                billInfo.setBizDate(new Date());
                billInfo.setDescription(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0021") + info.getNumber() + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0022"));
                billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                BizTypeInfo bizTypeInfo = new BizTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)"kXeVPjHuchDgQKjAYj1RYCQHQ1w="));
                billInfo.setBizType(bizTypeInfo);
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-888880a812fd463ED552"));
                billInfo.setBillType(billTypeInfo);
                this.setBillNumber(ctx, (IObjectValue)billInfo, info.getStorageOrgUnit().getId().toString());
                billInfo.setSourceBillId(info.getId().toString());
                MatAttrChangeBeforeEntryInfo beforebillEntryInfo = new MatAttrChangeBeforeEntryInfo();
                beforebillEntryInfo.setMaterial(invInfo.getMaterial());
                beforebillEntryInfo.setQty(entryInfo.getQty());
                beforebillEntryInfo.setBaseQty(entryInfo.getQty());
                beforebillEntryInfo.setSourceBillEntryId(entryInfo.getId().toString());
                beforebillEntryInfo.setSourceBillEntrySeq(entryInfo.getSeq());
                beforebillEntryInfo.setSourceBillId(info.getId().toString());
                beforebillEntryInfo.setSourceBillNumber(info.getNumber());
                beforebillEntryInfo.setCustomer(invInfo.getCustomer());
                beforebillEntryInfo.setSupplier(invInfo.getSupplier());
                beforebillEntryInfo.setLocation(invInfo.getLocation());
                beforebillEntryInfo.setWarehouse(invInfo.getWarehouse());
                beforebillEntryInfo.setLot(invInfo.getLot());
                beforebillEntryInfo.setProject(invInfo.getProject());
                beforebillEntryInfo.setTrackNumber(invInfo.getTrackNumber());
                beforebillEntryInfo.setUnit(invInfo.getUnit());
                beforebillEntryInfo.setBaseUnit(invInfo.getBaseUnit());
                beforebillEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                beforebillEntryInfo.setCompanyOrgUnit(invInfo.getCompanyOrgUnit());
                beforebillEntryInfo.setStorageOrgUnit(invInfo.getStorageOrgUnit());
                beforebillEntryInfo.setStoreStatus(invInfo.getStorestatus());
                beforebillEntryInfo.setStoreType(invInfo.getStoretype());
                beforebillEntryInfo.setAssistUnit(invInfo.getAssistUnit());
                beforebillEntryInfo.setAssistProperty(invInfo.getAssistProperty());
                beforebillEntryInfo.setExp(invInfo.getExp());
                billInfo.getEntry().add(beforebillEntryInfo);
                MatAttrChangeAfterEntryInfo afterbillEntryInfo = new MatAttrChangeAfterEntryInfo();
                afterbillEntryInfo.setMaterial(invInfo.getMaterial());
                afterbillEntryInfo.setQty(entryInfo.getQty());
                afterbillEntryInfo.setBaseQty(entryInfo.getQty());
                afterbillEntryInfo.setSourceBillEntryId(entryInfo.getId().toString());
                afterbillEntryInfo.setSourceBillEntrySeq(entryInfo.getSeq());
                afterbillEntryInfo.setSourceBillId(info.getId().toString());
                afterbillEntryInfo.setSourceBillNumber(info.getNumber());
                afterbillEntryInfo.setCustomer(invInfo.getCustomer());
                afterbillEntryInfo.setSupplier(invInfo.getSupplier());
                afterbillEntryInfo.setLocation(invInfo.getLocation());
                afterbillEntryInfo.setWarehouse(invInfo.getWarehouse());
                afterbillEntryInfo.setLot(invInfo.getLot());
                afterbillEntryInfo.setProject(plannedOrderInfo.getProject());
                afterbillEntryInfo.setTrackNumber(plannedOrderInfo.getTrackNumber());
                afterbillEntryInfo.setUnit(invInfo.getUnit());
                afterbillEntryInfo.setBaseUnit(invInfo.getBaseUnit());
                afterbillEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                afterbillEntryInfo.setCompanyOrgUnit(invInfo.getCompanyOrgUnit());
                afterbillEntryInfo.setStorageOrgUnit(invInfo.getStorageOrgUnit());
                afterbillEntryInfo.setStoreStatus(invInfo.getStorestatus());
                afterbillEntryInfo.setStoreType(invInfo.getStoretype());
                afterbillEntryInfo.setAssistUnit(invInfo.getAssistUnit());
                afterbillEntryInfo.setAssistProperty(invInfo.getAssistProperty());
                afterbillEntryInfo.setExp(invInfo.getExp());
                beforebillEntryInfo.getEntry1().add(afterbillEntryInfo);
                IObjectPK changeID = MatAttrChangeBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)billInfo);
                MatAttrChangeBillFactory.getLocalInstance((Context)ctx).audit(changeID);
            } else {
                if (!entryInfo.getTransBillType().equals((Object)PMRPElementEnum.S_ManufactureOrder)) continue;
                sql.setLength(0);
                sql.append(" update t_mm_manufactureorder set fprojectid = '");
                sql.append(plannedOrderInfo.getProject().getId());
                sql.append("' ");
                if (plannedOrderInfo.getTrackNumber() == null) {
                    sql.append(", ftrackid = null ");
                } else {
                    sql.append(", ftrackid = '").append(plannedOrderInfo.getTrackNumber().getId()).append("' ");
                }
                sql.append(" where fid =  '").append(ftransBillID).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder set ftotalreleaseqty = isnull(ftotalreleaseqty,0) + ");
            sql.append(entryInfo.getQty());
            sql.append(" , fbasetotalreleaseqty = isnull(fbasetotalreleaseqty,0) + ");
            sql.append(entryInfo.getQty());
            sql.append(" where fid =  '").append(plannedOrderInfo.getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder set fbasestatus = 7 ");
            sql.append(" where fid =  '").append(plannedOrderInfo.getId()).append("'");
            sql.append(" and ftotalreleaseqty >= fqty");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        sql.setLength(0);
        sql.append(" update T_BV_BalInventoryRecord set fbasestatus = 4,FAuditorID = '" + userInfo.getId() + "',FAuditDate = sysdate ");
        sql.append(" where fid =  '").append(info.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BalInventoryRecordInfo info = null;
        info = model != null ? (BalInventoryRecordInfo)model : BalInventoryRecordFactory.getLocalInstance(ctx).getBalInventoryRecordInfo(pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0023"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        super._unpassAudit(ctx, pk, model);
        BalInventoryRecordEntryInfo entryInfo = null;
        PMRPPlannedOrderInfo plannedOrderInfo = null;
        if (info.getSourceBillId() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0015"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        plannedOrderInfo = PMRPPlannedOrderFactory.getLocalInstance(ctx).getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entryInfo = info.getEntrys().get(i);
            String ftransBillID = null;
            ftransBillID = entryInfo.getTransBillID();
            if (entryInfo.getTransBillType().equals((Object)PMRPElementEnum.I_CurInv)) {
                if (!InventoryFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(ftransBillID))) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0006") + "[" + info.getNumber() + "]" + ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0016") + "[" + ftransBillID + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", "0EMMPROJECTBizBinv-0017"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                MatAttrChangeBillCollection billColl = MatAttrChangeBillFactory.getLocalInstance((Context)ctx).getMatAttrChangeBillCollection(" where sourceBillId = '" + info.getId().toString() + "'");
                if (billColl != null && billColl.size() > 0) {
                    for (int j = 0; j < billColl.size(); ++j) {
                        MatAttrChangeBillInfo billInfo = billColl.get(j);
                        if (billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                            MatAttrChangeBillFactory.getLocalInstance((Context)ctx).unAudit((IObjectPK)new ObjectUuidPK(billInfo.getId()));
                        }
                        MatAttrChangeBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(billInfo.getId()));
                    }
                }
            } else {
                if (!entryInfo.getTransBillType().equals((Object)PMRPElementEnum.S_ManufactureOrder)) continue;
                sql.setLength(0);
                sql.append(" update t_mm_manufactureorder set fprojectid = '");
                sql.append(entryInfo.getOutProject().getId());
                sql.append("' ");
                if (entryInfo.getOutTrackNumber() == null) {
                    sql.append(", ftrackid = null ");
                } else {
                    sql.append(", ftrackid = '").append(entryInfo.getOutTrackNumber().getId()).append("' ");
                }
                sql.append(" where fid =  '").append(ftransBillID).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder set ftotalreleaseqty = isnull(ftotalreleaseqty,0) - ");
            sql.append(entryInfo.getQty());
            sql.append(" , fbasetotalreleaseqty = isnull(fbasetotalreleaseqty,0) - ");
            sql.append(entryInfo.getQty());
            sql.append(" where fid =  '").append(plannedOrderInfo.getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder set fbasestatus = 4 ");
            sql.append(" where fid =  '").append(plannedOrderInfo.getId()).append("'");
            sql.append(" and ftotalreleaseqty < fqty and fbasestatus = 7 ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append(" update T_BV_BalInventoryRecord set fbasestatus = 2,FAuditorID = null,FAuditDate = null ");
        sql.append(" where fid =  '").append(info.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

