/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.dp.app.run.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.basedata.scm.sm.pur.DPOperationSchemeInfo;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCbFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleCbInfo;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleFactory;
import com.kingdee.eas.industry.emm.scm.sm.ConsignmentScheduleInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailFactory;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanDetailInfo;
import com.kingdee.eas.industry.emm.scm.sm.DeliveryPlanType;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.CalculateResultScopeVO;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DPMatchInventroy
extends PMRPStep
implements IConfigurableStep {
    private static String RESURL = "com.kingdee.eas.industry.emm.project.biz.dp.DeliveryPlanGenResource";

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        int i;
        StringBuffer sql = new StringBuffer();
        int exceptionDay = runParam.getRunLog().getDpOperationScheme().getExpection();
        int delayDay = runParam.getRunLog().getDpOperationScheme().getDelay();
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        java.util.Date thisDate = new java.util.Date();
        if (delayDay != -1) {
            startDate = DateUtil.addDay((java.util.Date)thisDate, (int)(delayDay * -1));
        }
        endDate = DateUtil.addDay((java.util.Date)thisDate, (int)exceptionDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> materialIDList = new ArrayList<String>();
        ArrayList<CalculateResultScopeVO> dataList = new ArrayList<CalculateResultScopeVO>();
        runParam.getEasCtx().put((Object)"startDate", (Object)startDate);
        runParam.getEasCtx().put((Object)"endDate", (Object)endDate);
        sql.append(" select d.FID,d.CFProjectID,d.CFTrackNoID ,  \r\n");
        sql.append(" d.CFSupplyStorageOrg ,d.CFStorageOrgUnitID ,d.CFMaterialID , d.CFDistributionorder, \r\n");
        sql.append(" d.CFFarrivedays , d.CFDemandQty - isnull(d.CFCloseQty,0) As Fqty ,isnull(d.CFPlanReTime,d.CFDemandDate) As fdate,d.CFLeadingIn,  \r\n");
        sql.append(" d.CFDemandType,d.fsourcebillid,d.cfsupplierid ");
        sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule \n");
        sql.append(" from CT_SM_DeliveryPlanDemand d  \r\n");
        sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = d.CFMaterialID and mp.forgunit = d.CFSupplyStorageOrg  \r\n");
        sql.append(" where d.CFDemandQty > isnull(d.Cfcloseqty,0)  \r\n");
        sql.append(" and d.CFSupplyStorageOrg in(Select Cfsupplyorgunitid from CT_BAS_SupplyRDE where fparentid = ?)  \r\n");
        if (startDate != null) {
            sql.append(" and d.CFDemandDate >= {ts'").append(sdf.format(startDate) + " 00:00:00").append("'}   \r\n");
        }
        sql.append(" and d.CFDemandDate <= {ts'").append(sdf.format(endDate) + " 23:59:59").append("'}   \r\n");
        sql.append(" and not exists(Select 1 from CT_DIR_DirectFeedingmMaterial zs   \r\n");
        sql.append(" where zs.CFMATERIALID = d.CFMaterialID  \r\n");
        sql.append(" And zs.cfprojectid = d.CFProjectID  \r\n");
        sql.append(" And zs.CFTRACKID = d.CFTrackNoID  \r\n");
        sql.append(" And isnull(zs.CFISZJ,0) = 1  \r\n");
        sql.append(" )  \r\n");
        sql.append(" order by d.CFMaterialID,d.CFStorageOrgUnitID,d.CFSupplyStorageOrg,d.CFProjectID,d.CFTrackNoID,d.CFDistributionorder  \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getDpOperationScheme().getSupplyRelation().getId().toString()});
        try {
            while (rs.next()) {
                String fmaterialid = rs.getString("CFMaterialID");
                if (!materialIDList.contains(fmaterialid)) {
                    materialIDList.add(fmaterialid);
                }
                CalculateResultScopeVO vo = new CalculateResultScopeVO();
                vo.setProjectid(rs.getString("CFProjectID"));
                vo.setTracknumberid(rs.getString("CFTrackNoID"));
                vo.setSupplystorageorgid(rs.getString("CFSupplyStorageOrg"));
                vo.setStorageorgid(rs.getString("CFStorageOrgUnitID"));
                vo.setMaterialid(fmaterialid);
                vo.setReqDate(rs.getDate("fdate"));
                vo.setQty(rs.getBigDecimal("fqty"));
                vo.setActqty(rs.getBigDecimal("fqty"));
                vo.setAdvanceday(rs.getInt("CFFarrivedays"));
                vo.setSupplierID(rs.getString("cfsupplierid"));
                vo.setMfID(rs.getString("fmanufacturestrategyid"));
                vo.setIsolated(rs.getString("fisolatedrule"));
                vo.setId(rs.getString("FID"));
                vo.setSupplierID(rs.getString("cfsupplierid"));
                dataList.add(vo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (materialIDList == null || materialIDList.size() < 1) {
            return null;
        }
        int splitCount = 200;
        int times = materialIDList.size() / splitCount;
        if (materialIDList.size() % splitCount > 0) {
            ++times;
        }
        List subList = new ArrayList();
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)runParam.getService());
        for (i = 1; i <= times; ++i) {
            subList = i < times ? materialIDList.subList(splitCount * (i - 1), splitCount * i) : materialIDList.subList(splitCount * (i - 1), materialIDList.size());
            UpdateWorker worker = new UpdateWorker(runParam, subList, dataList);
            try {
                ecs.submit((Callable)worker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        try {
            for (i = 1; i <= times; ++i) {
                this.dataAmount += ((Integer)ecs.take().get()).intValue();
                if (this.logInfo == null) continue;
                sql.setLength(0);
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        return null;
    }

    public static void saveDeliveryPlans(PMRPCalcParam runParam, CalculateResultScopeVO vo, boolean isLast) throws BOSException, PMRPException {
        DeliveryPlanDetailInfo info;
        int i;
        CoreBaseCollection coll;
        int count = 0;
        if (!isLast) {
            count = 300;
        }
        if (vo.getConsignmentList() != null && vo.getConsignmentList().size() > count) {
            coll = new CoreBaseCollection();
            for (i = 0; i < vo.getConsignmentList().size(); ++i) {
                info = (DeliveryPlanDetailInfo)vo.getConsignmentList().get(i);
                coll.add((CoreBaseInfo)info);
            }
            try {
                DeliveryPlanDetailFactory.getLocalInstance((Context)runParam.getEasCtx()).addnewBatchData(coll);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            vo.getConsignmentList().clear();
        }
        if (vo.getConsignmentCbList() != null && vo.getConsignmentCbList().size() > count) {
            coll = new CoreBaseCollection();
            for (i = 0; i < vo.getConsignmentCbList().size(); ++i) {
                info = (ConsignmentScheduleCbInfo)vo.getConsignmentCbList().get(i);
                coll.add((CoreBaseInfo)info);
            }
            try {
                ConsignmentScheduleCbFactory.getLocalInstance((Context)runParam.getEasCtx()).addnewBatchData(coll);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            vo.getConsignmentCbList().clear();
        }
    }

    public static DeliveryPlanDetailInfo addDeliveryPlanDetailInfo(PMRPCalcParam runParam, CalculateResultScopeVO vo, String purorderentryID, BigDecimal qty) throws BOSException, PMRPException {
        MaterialInventoryInfo miInfo;
        String storageid;
        DeliveryPlanDetailInfo info = new DeliveryPlanDetailInfo();
        String supOrgID = vo.getSupplystorageorgid();
        if (supOrgID != null) {
            StorageOrgUnitInfo supStorgetinfo = new StorageOrgUnitInfo();
            supStorgetinfo.setId(BOSUuid.read((String)supOrgID));
            info.setSupplyStorageOrgUnit(supStorgetinfo);
        }
        if ((storageid = vo.getStorageorgid()) != null) {
            StorageOrgUnitInfo storgetinfo = new StorageOrgUnitInfo();
            storgetinfo.setId(BOSUuid.read((String)storageid));
            info.setStorageOrgUnit(storgetinfo);
        }
        if (purorderentryID != null) {
            PurOrderEntryInfo purentryInfo = DPMatchInventroy.getPurOrderEntryInfo(runParam, purorderentryID);
            info.setPurchaseOrgUnit(purentryInfo.getParent().getPurchaseOrgUnit());
            info.setPurOrderEntryID(purorderentryID);
            info.setPurOrder(purentryInfo.getParent());
            info.setMaterial(purentryInfo.getMaterial());
            info.setMaterialName(purentryInfo.getMaterial().getName());
            info.setUnit(purentryInfo.getMaterial().getBaseUnit());
            info.setSupplier(purentryInfo.getParent().getSupplier());
            info.setPurGroup(purentryInfo.getParent().getPurchaseGroup());
            info.setPurPerson(purentryInfo.getParent().getPurchasePerson());
        } else if (vo.getMaterialid() != null) {
            MaterialInfo mInfo = DPMatchInventroy.getMaterialInfo(runParam, vo.getMaterialid());
            info.setMaterial(mInfo);
            info.setMaterialName(mInfo.getName());
            info.setUnit(mInfo.getBaseUnit());
        }
        if (!IndustryUtils.isEmptyString((String)vo.getProjectid())) {
            ProjectInfo proInfo = new ProjectInfo();
            proInfo.setId(BOSUuid.read((String)vo.getProjectid()));
            info.setProject(proInfo);
        }
        if (!IndustryUtils.isEmptyString((String)vo.getTracknumberid())) {
            TrackNumberInfo troInfo = new TrackNumberInfo();
            troInfo.setId(BOSUuid.read((String)vo.getTracknumberid()));
            info.setTrackNumber(troInfo);
        }
        if (info.getSupplier() == null && !IndustryUtils.isEmptyString((String)vo.getSupplierID())) {
            SupplierInfo suppplierInfo = new SupplierInfo();
            suppplierInfo.setId(BOSUuid.read((String)vo.getSupplierID()));
            info.setSupplier(suppplierInfo);
        }
        info.setDemandDate((java.util.Date)vo.getReqDate());
        info.setDemandQty(qty);
        info.setOrderQty(qty);
        if (info.getMaterial() != null && info.getSupplyStorageOrgUnit() != null && (miInfo = DPMatchInventroy.getMaterialInventoryInfo(runParam, info.getMaterial().getId().toString(), info.getSupplyStorageOrgUnit().getId().toString())) != null) {
            info.setDeliveryWareHouse(miInfo.getDefaultWarehouse());
            if (miInfo.getDefaultWarehouse() != null) {
                info.setWmPerson(miInfo.getDefaultWarehouse().getWhman());
            }
        }
        info.setDpType(DeliveryPlanType.HOST);
        info.setIsolatedRule(vo.getIsolated() == null ? IsolatedRuleEnum.NONE : IsolatedRuleEnum.getEnum((String)vo.getIsolated()));
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        Context ctx = runParam.getEasCtx();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp thisTime = new Timestamp(new java.util.Date().getTime());
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setCreateTime(thisTime);
        info.setCreator(userInfo);
        String devIDs = vo.getDeliveryplanpks();
        devIDs = devIDs == null || "".equals(devIDs) ? "'" + info.getId() + "'" : devIDs + ",'" + info.getId() + "'";
        vo.setDeliveryplanpks(devIDs);
        vo.getConsignmentList().add(info);
        return info;
    }

    public static PurOrderEntryInfo getPurOrderEntryInfo(PMRPCalcParam runParam, String fentryID) throws BOSException, PMRPException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("parent.*"));
        PurOrderEntryInfo entryInfo = null;
        try {
            entryInfo = PurOrderEntryFactory.getLocalInstance((Context)runParam.getEasCtx()).getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(fentryID), sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return entryInfo;
    }

    public static MaterialInfo getMaterialInfo(PMRPCalcParam runParam, String fid) throws BOSException, PMRPException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        MaterialInfo materialInfo = null;
        try {
            materialInfo = MaterialFactory.getLocalInstance((Context)runParam.getEasCtx()).getMaterialInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return materialInfo;
    }

    public static MaterialInventoryInfo getMaterialInventoryInfo(PMRPCalcParam runParam, String materialID, String orgUnitID) throws BOSException, PMRPException {
        MaterialInventoryInfo miInfo = new MaterialInventoryInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select a.fdefaultwarehouseid,w.fwhmanid,a.fid  \n");
        sql.append(" from t_bd_materialinventory a  \n");
        sql.append(" left outer join t_db_warehouse w on w.fid = a.fdefaultwarehouseid  \n");
        sql.append(" where a.fmaterialid = ? and a.forgunit = ?  \n");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{materialID, orgUnitID});
        try {
            if (rs.next()) {
                miInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                if (rs.getString("fdefaultwarehouseid") != null) {
                    WarehouseInfo whInfo = new WarehouseInfo();
                    whInfo.setId(BOSUuid.read((String)rs.getString("fdefaultwarehouseid")));
                    if (rs.getString("fwhmanid") != null) {
                        PersonInfo whmanInfo = new PersonInfo();
                        whmanInfo.setId(BOSUuid.read((String)rs.getString("fwhmanid")));
                        whInfo.setWhman(whmanInfo);
                    }
                    miInfo.setDefaultWarehouse(whInfo);
                }
                return miInfo;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw new BOSException((Throwable)e1);
        }
        return null;
    }

    public static void updateVODeliveryPlanDatas(PMRPCalcParam runParam, CalculateResultScopeVO vo, List<Map> dpDataList) throws BOSException, PMRPException {
        BigDecimal deliveryPlanQty = BigDecimal.ZERO;
        BigDecimal syQty = vo.getActqty();
        String billIDString = "";
        for (int i = 0; i < dpDataList.size(); ++i) {
            HashMap dpMap = (HashMap)dpDataList.get(i);
            String fid = (String)dpMap.get("fid");
            String fsupplyID = (String)dpMap.get("fsupplierid");
            BigDecimal dpQty = new BigDecimal(dpMap.get("fqty").toString());
            if (dpQty.compareTo(BigDecimal.ZERO) <= 0 || vo.getSupplierID() != null && !"".equals(vo.getSupplierID()) && fsupplyID != null && !fsupplyID.equals(vo.getSupplierID())) continue;
            deliveryPlanQty = deliveryPlanQty.add(dpQty);
            billIDString = billIDString.equals("") ? "'" + fid + "'" : billIDString + ",'" + fid + "'";
            if (syQty.compareTo(dpQty) == 0) {
                dpMap.put(fid, BigDecimal.ZERO);
                syQty = BigDecimal.ZERO;
                continue;
            }
            if (syQty.compareTo(dpQty) > 0) {
                dpMap.put(fid, BigDecimal.ZERO);
                syQty = syQty.subtract(dpQty);
                continue;
            }
            dpQty = dpQty.subtract(syQty);
            syQty = BigDecimal.ZERO;
            dpMap.put(fid, dpQty);
            ConsignmentScheduleCbInfo info = new ConsignmentScheduleCbInfo();
            info.setBasestatus(1);
            ConsignmentScheduleInfo sinfo = DPMatchInventroy.getConsignmentScheduleInfo(runParam, fid);
            info.setMaterialid(vo.getMaterialid());
            info.setParentid(fid);
            info.setNeedAmt(dpQty.multiply(new BigDecimal(-1)));
            info.setNeedDate((java.util.Date)vo.getReqDate());
            info.setPreNeedDate(sinfo.getNeedDate());
            info.setPreNeedAmt(sinfo.getNeedAmt());
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            vo.getConsignmentCbList().add(info);
        }
        vo.setActDeliveryqty(deliveryPlanQty);
        vo.setActqty(syQty);
        vo.setExistdeliveryplanpks(billIDString);
    }

    public static ConsignmentScheduleInfo getConsignmentScheduleInfo(PMRPCalcParam runParam, String billID) throws BOSException, PMRPException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("NeedDate"));
        sic.add(new SelectorItemInfo("NeedAmt"));
        ConsignmentScheduleInfo info = null;
        try {
            info = ConsignmentScheduleFactory.getLocalInstance((Context)runParam.getEasCtx()).getConsignmentScheduleInfo((IObjectPK)new ObjectUuidPK(billID), sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public static Map<String, BigDecimal> getInvDatasMap(PMRPCalcParam runParam, String materialID, String supplyOrgUnitID, String fproductionOrgUnitID, String fprojectID, String ftrackNumberID) throws BOSException, PMRPException {
        SupplyRelationshipDefinitionInfo info = runParam.getRunLog().getDpOperationScheme().getSupplyRelation();
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select  ttv.fid , ttv.Fcurstoreqty as qty,s.Cfprioritylevel \n");
        sql.append(" from T_IM_Inventory ttv  \n");
        sql.append(" inner join CT_BAS_SupplyRDE s on s.Cfproductorgunitid = ? And s.Cfsupplyorgunitid = ttv.fstorageorgunitid   \n");
        sql.append(" and ttv.fwarehouseid = Isnull(s.Cfwarehouseid,ttv.fwarehouseid) ");
        sql.append(" and Isnull(ttv.flocationid,'EgkAAABc3XMgX/hq') = Isnull(s.Cflocationid,Isnull(ttv.flocationid,'EgkAAABc3XMgX/hq')) ");
        paramList.add(fproductionOrgUnitID);
        sql.append(" where ttv.fmaterialid = ? ");
        paramList.add(materialID);
        sql.append(" And ttv.fstorageorgunitid = ? ");
        paramList.add(supplyOrgUnitID);
        if (fprojectID != null && !"".equals(fprojectID)) {
            sql.append(" and ttv.fprojectid = ? ");
            paramList.add(fprojectID);
        }
        if (ftrackNumberID != null && !"".equals(ftrackNumberID)) {
            sql.append(" and ttv.fprojectid = ? ");
            paramList.add(ftrackNumberID);
        }
        sql.append(" And ttv.FBaseQty > 0 ");
        if (info.getWsRange() == 1) {
            sql.append(" and ttv.Fwarehouseid in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = ? ) ");
            paramList.add(info.getId().toString());
        } else if (info.getWsRange() == 2) {
            sql.append(" and ttv.Fwarehouseid not in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = ? ) ");
            paramList.add(info.getId().toString());
        }
        sql.append(" order by s.Cfprioritylevel desc  \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        try {
            while (irs.next()) {
                String fid = irs.getString("fid");
                BigDecimal qty = irs.getBigDecimal("qty");
                if (returnMap != null && returnMap.containsKey(fid)) continue;
                returnMap.put(fid, qty);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    public static Map<String, List<Map>> getDeliveryPlanDatasMap(PMRPCalcParam runParam, List<String> materialIDList) throws BOSException, PMRPException {
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        Context ctx = runParam.getEasCtx();
        java.util.Date startDate = ctx.get((Object)"startDate") == null ? null : (java.util.Date)ctx.get((Object)"startDate");
        java.util.Date endDate = ctx.get((Object)"endDate") == null ? null : (java.util.Date)ctx.get((Object)"endDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("  select a.fid, \r\n");
        sql.append("  a.fneeddate,  \r\n");
        sql.append("  b.fprojectid,  \r\n");
        sql.append("  c.fsupplierid,  \r\n");
        sql.append("  a.fmaterialid,  \r\n");
        sql.append("  a.fproduceorgid,  \r\n");
        sql.append("  a.cftracknumberid,  \r\n");
        sql.append("  a.fneedamt - isnull(a.fwarehouseamt,0) fqty  \r\n");
        sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule \n");
        sql.append("  from t_sm_consignmentschedule a  \r\n");
        sql.append("  left outer join t_bd_materialplan mp on mp.fmaterialid = a.fmaterialid and mp.forgunit = a.fproduceorgid  \r\n");
        sql.append("  left join t_sm_purorderentry b on a.fparentid = b.fid  \r\n");
        sql.append("  left join t_sm_purorder c on c.fid = b.fparentid  \r\n");
        sql.append("  where a.fbasestatus = 4  \r\n");
        if (startDate != null) {
            sql.append(" and a.fneeddate >= {ts'").append(sdf.format(startDate) + " 00:00:00").append("'}   \r\n");
        }
        if (endDate != null) {
            sql.append(" and a.fneeddate <= {ts'").append(sdf.format(endDate) + " 23:59:59").append("'}   \r\n");
        }
        sql.append("  and (  \r\n");
        for (int i = 0; i < materialIDList.size(); ++i) {
            sql.append(" a.FMaterialID = ? ");
            if (i == materialIDList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append("  )  \r\n");
        paramList.addAll(materialIDList);
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<String, List<Map>> returnMap = new HashMap<String, List<Map>>();
        String key = null;
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fmaterialid = rs.getString("fmaterialid");
                String fproduceorgid = rs.getString("fproduceorgid");
                String fprojectid = rs.getString("fprojectid");
                String ftrackID = rs.getString("cftracknumberid");
                BigDecimal fqty = rs.getBigDecimal("fqty");
                String fisolatedrule = rs.getString("fisolatedrule");
                String fmanufacturestrategyid = rs.getString("fmanufacturestrategyid");
                String fsupplierid = rs.getString("fsupplierid");
                Date fdate = rs.getDate("fneeddate");
                if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                    if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                        ftrackID = "";
                    }
                } else {
                    fprojectid = "";
                    ftrackID = "";
                }
                key = fmaterialid + fproduceorgid;
                if (fprojectid == null) {
                    fprojectid = "";
                }
                if (ftrackID == null) {
                    ftrackID = "";
                }
                key = key + fprojectid + ftrackID + sdf.format(fdate);
                List dataList = null;
                dataList = returnMap != null && returnMap.containsKey(key) ? (List)returnMap.get(key) : new ArrayList();
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("fid", fid);
                dataMap.put("fqty", fqty);
                dataMap.put("fsupplierid", fsupplierid);
                dataList.add(dataMap);
                returnMap.put(key, dataList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    public static Map<String, List<Map>> getPurDatasMap(PMRPCalcParam runParam, List<String> materialIDList) throws BOSException, PMRPException {
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select  h.fid , d.fid as entryid \n");
        sql.append(" ,d.fmaterialid As fmaterialid \n");
        sql.append(" ,h.fsupplierid As fsupplierid \n");
        sql.append(" ,h.fpurchaseorgunitid As fpurchaseorgunitid \n");
        sql.append(" ,d.fstorageorgunitid As fstorageorgunitid \n");
        sql.append(" ,d.fprojectid As fprojectid \n");
        sql.append(" ,d.ftracknoid As ftrackid \n");
        sql.append(" ,d.fqty - isnull(d.ftotalreceiveqty,0) As fpurqty \n");
        sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule \n");
        sql.append(" from t_sm_purorder h  \n");
        sql.append(" inner join  t_sm_purorderentry d on h.fid = d.fparentid  \n");
        sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = d.FMaterialID and mp.forgunit = d.fstorageorgunitid \n");
        sql.append(" where ( \n");
        for (int i = 0; i < materialIDList.size(); ++i) {
            sql.append(" d.FMaterialID = ? ");
            if (i == materialIDList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" )  \n");
        paramList.addAll(materialIDList);
        sql.append(" And h.fpurchaseorgunitid in(Select distinct CFPurchaseOrgUnitI from CT_BAS_PurRDE where fparentid = ? ) ");
        paramList.add(runParam.getRunLog().getDpOperationScheme().getPurRelation().getId().toString());
        sql.append(" And h.fsupplierid is not null ");
        sql.append(" and  d.fqty - isnull(d.ftotalreceiveqty,0)  > 0 and h.FBASESTATUS = 4 And d.fbasestatus <> 7 ");
        sql.append(" order by d.fmaterialid,d.fstorageorgunitid,d.fprojectid,d.ftracknoid,h.fpurchaseorgunitid,h.fbizdate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<String, List<Map>> returnMap = new HashMap<String, List<Map>>();
        try {
            while (irs.next()) {
                String fid = irs.getString("fid");
                String entryid = irs.getString("entryid");
                String fmaterialid = irs.getString("fmaterialid");
                String fstorageorgunitid = irs.getString("fstorageorgunitid");
                String fprojectid = irs.getString("fprojectid");
                String ftrackid = irs.getString("ftrackid");
                BigDecimal fpurqty = irs.getBigDecimal("fpurqty");
                String fmanufacturestrategyid = irs.getString("fmanufacturestrategyid");
                String fisolatedrule = irs.getString("fisolatedrule");
                String fpurchaseorgunitid = irs.getString("fpurchaseorgunitid");
                String fsupplierid = irs.getString("fsupplierid");
                String key = fmaterialid + fstorageorgunitid;
                if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                    if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                        ftrackid = "";
                    }
                } else {
                    fprojectid = "";
                    ftrackid = "";
                }
                if (fprojectid == null) {
                    fprojectid = "";
                }
                if (ftrackid == null) {
                    ftrackid = "";
                }
                key = key + fprojectid + ftrackid + fpurchaseorgunitid;
                HashMap<String, Object> purMap = new HashMap<String, Object>();
                purMap.put("purentryid", entryid);
                purMap.put("qty", fpurqty);
                purMap.put("supplierid", fsupplierid);
                List<HashMap<String, Object>> aList = null;
                aList = returnMap != null && returnMap.containsKey(key) ? (List)returnMap.get(key) : new ArrayList<HashMap<String, Object>>();
                aList.add(purMap);
                returnMap.put(key, aList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return ResourceBase.getString((String)RESURL, (String)"label22", (Locale)locale);
    }

    public static PurchaseOrgUnitInfo getPurChaseOrgUnitInfo(PurRelationshipDefinitionEntryCollection coll, String fproductionorgUnitID) {
        if (coll == null || coll.size() < 1) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).getProductOrgUnit().getId().toString().equals(fproductionorgUnitID)) continue;
            return coll.get(i).getPurchaseOrgUnit();
        }
        return null;
    }

    public static List<StorageOrgUnitInfo> getSupplyOrgUnitInfo(SupplyRelationshipDefinitionEntryCollection coll, String fproductionorgUnitID) {
        if (coll == null || coll.size() < 1) {
            return null;
        }
        ArrayList<StorageOrgUnitInfo> list = new ArrayList<StorageOrgUnitInfo>();
        ArrayList<String> noList = new ArrayList<String>();
        StorageOrgUnitInfo sInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).getProductOrgUnit().getId().toString().equals(fproductionorgUnitID) || (sInfo = coll.get(i).getSupplyOrgUnit()) == null || noList.contains(sInfo.getId().toString())) continue;
            list.add(sInfo);
            noList.add(sInfo.getId().toString());
        }
        return list;
    }

    private static class UpdateWorker
    implements Callable {
        private List<String> materialIDList;
        private PMRPCalcParam runParam;
        private int dataAmount;
        private List<CalculateResultScopeVO> allDemandDatas;

        public UpdateWorker(PMRPCalcParam runParam, List<String> materialidList, List<CalculateResultScopeVO> alldemandDatas) {
            this.runParam = runParam;
            this.materialIDList = materialidList;
            this.allDemandDatas = alldemandDatas;
        }

        public Object call() throws Exception {
            if (this.materialIDList.size() > 0 && this.allDemandDatas.size() > 0) {
                DPOperationSchemeInfo dpInfo = this.runParam.getRunLog().getDpOperationScheme();
                SupplyRelationshipDefinitionInfo suphInfo = dpInfo.getSupplyRelation();
                SupplyRelationshipDefinitionEntryCollection supeCol = suphInfo.getEntry();
                PurRelationshipDefinitionInfo purhInfo = dpInfo.getPurRelation();
                PurRelationshipDefinitionEntryCollection pureColl = purhInfo.getEntry();
                StringBuffer sql = new StringBuffer();
                ArrayList paramList = new ArrayList();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                HashMap<String, BigDecimal> invUsedCacheMap = new HashMap<String, BigDecimal>();
                Map<String, List<Map>> deliveryPlanMap = DPMatchInventroy.getDeliveryPlanDatasMap(this.runParam, this.materialIDList);
                Map<String, List<Map>> purDataList = DPMatchInventroy.getPurDatasMap(this.runParam, this.materialIDList);
                String dpkey = "";
                String ppkey = "";
                for (int i = 0; i < this.allDemandDatas.size(); ++i) {
                    BigDecimal demandQty;
                    CalculateResultScopeVO vo = this.allDemandDatas.get(i);
                    if (!this.materialIDList.contains(vo.getMaterialid())) continue;
                    String fproductorgunitid = vo.getStorageorgid();
                    String fsupplystorageorgunitid = vo.getSupplystorageorgid();
                    String fprojectid = vo.getProjectid() == null ? "" : vo.getProjectid();
                    String ftracknumberid = vo.getTracknumberid() == null ? "" : vo.getTracknumberid();
                    String FMaterialID = vo.getMaterialid();
                    String fmanufacturestrategyid = vo.getMfID();
                    String fisolatedrule = vo.getIsolated();
                    BigDecimal initDemandQty = demandQty = vo.getQty();
                    Date fdate = vo.getReqDate();
                    if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                        if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                            ftracknumberid = "";
                        }
                    } else {
                        fprojectid = "";
                        ftracknumberid = "";
                    }
                    dpkey = vo.getMaterialid() + fsupplystorageorgunitid + fprojectid + ftracknumberid + sdf.format(fdate);
                    BigDecimal invQty = null;
                    BigDecimal invUsedQty = null;
                    BigDecimal allinvQty = BigDecimal.ZERO;
                    BigDecimal updateInvqty = BigDecimal.ZERO;
                    Map<String, BigDecimal> invMap = DPMatchInventroy.getInvDatasMap(this.runParam, FMaterialID, fsupplystorageorgunitid, fproductorgunitid, fprojectid, ftracknumberid);
                    if (invMap != null && invMap.size() > 0) {
                        Set<String> keys = invMap.keySet();
                        for (String key : keys) {
                            invQty = invMap.get(key);
                            invUsedQty = BigDecimal.ZERO;
                            if (invUsedCacheMap != null && invUsedCacheMap.containsKey(key)) {
                                invUsedQty = (BigDecimal)invUsedCacheMap.get(key);
                            }
                            allinvQty = allinvQty.add(invQty.subtract(invUsedQty));
                            if (demandQty.compareTo(BigDecimal.ZERO) <= 0 || (invQty = invQty.subtract(invUsedQty)).compareTo(BigDecimal.ZERO) <= 0) continue;
                            if (invQty.compareTo(demandQty) >= 0) {
                                updateInvqty = updateInvqty.add(demandQty);
                                invUsedQty = invUsedQty.add(demandQty);
                                demandQty = BigDecimal.ZERO;
                            } else {
                                updateInvqty = updateInvqty.add(invQty);
                                invUsedQty = invUsedQty.add(invQty);
                                demandQty = demandQty.subtract(invQty);
                            }
                            invUsedCacheMap.put(key, invUsedQty);
                        }
                    }
                    if (updateInvqty.compareTo(BigDecimal.ZERO) > 0) {
                        vo.setOccupyInventory(updateInvqty);
                        vo.setActInvqty(initDemandQty.subtract(updateInvqty));
                        vo.setInventoryqty(allinvQty);
                        vo.setActqty(initDemandQty.subtract(updateInvqty));
                        ++this.dataAmount;
                    }
                    if (deliveryPlanMap != null && deliveryPlanMap.containsKey(dpkey)) {
                        List<Map> dpDataList = deliveryPlanMap.get(dpkey);
                        DPMatchInventroy.updateVODeliveryPlanDatas(this.runParam, vo, dpDataList);
                        DPMatchInventroy.saveDeliveryPlans(this.runParam, vo, false);
                        ++this.dataAmount;
                    }
                    if (vo.getMaterialid().equals("/uwtgCUUSSKOT7CXCqbIs0QJ5/A=")) {
                        vo.getActqty();
                    }
                    if (vo.getActqty().compareTo(BigDecimal.ZERO) > 0) {
                        List<StorageOrgUnitInfo> suppluOrgUnitList;
                        demandQty = vo.getActqty();
                        PurchaseOrgUnitInfo purChaseOrgUnitInfo = DPMatchInventroy.getPurChaseOrgUnitInfo(pureColl, fproductorgunitid);
                        if (purChaseOrgUnitInfo == null || (suppluOrgUnitList = DPMatchInventroy.getSupplyOrgUnitInfo(supeCol, fproductorgunitid)) == null || suppluOrgUnitList.size() < 1) continue;
                        for (int purCount = 0; purCount < suppluOrgUnitList.size() && demandQty.compareTo(BigDecimal.ZERO) > 0; ++purCount) {
                            StorageOrgUnitInfo supplyOrgUnitInfo = suppluOrgUnitList.get(purCount);
                            if (!supplyOrgUnitInfo.getId().toString().equals(fsupplystorageorgunitid)) continue;
                            ppkey = vo.getMaterialid() + fsupplystorageorgunitid + fprojectid + ftracknumberid + purChaseOrgUnitInfo.getId().toString();
                            if (purDataList == null || !purDataList.containsKey(ppkey)) continue;
                            List<Map> aList = purDataList.get(ppkey);
                            if (aList != null && aList.size() > 0) {
                                for (int k = 0; k < aList.size(); ++k) {
                                    BigDecimal updatePurQty;
                                    Map purMap = aList.get(k);
                                    String purentryid = purMap.get("purentryid").toString();
                                    BigDecimal purQty = new BigDecimal(purMap.get("qty").toString());
                                    String fsupplierid = (String)purMap.get("fsupplierid");
                                    if (vo.getSupplierID() != null && !"".equals(vo.getSupplierID()) && fsupplierid != null && !fsupplierid.equals(vo.getSupplierID()) || purQty.compareTo(BigDecimal.ZERO) <= 0 || demandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                                    if (purQty.compareTo(demandQty) >= 0) {
                                        updatePurQty = demandQty;
                                        purQty = purQty.subtract(demandQty);
                                        demandQty = BigDecimal.ZERO;
                                        purMap.put("qty", purQty);
                                    } else {
                                        updatePurQty = purQty;
                                        demandQty = demandQty.subtract(purQty);
                                        purQty = BigDecimal.ZERO;
                                        purMap.put("qty", purQty);
                                    }
                                    vo.setActqty(demandQty);
                                    if (updatePurQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                                    DPMatchInventroy.addDeliveryPlanDetailInfo(this.runParam, vo, purentryid, updatePurQty);
                                    DPMatchInventroy.saveDeliveryPlans(this.runParam, vo, false);
                                }
                            }
                            ++this.dataAmount;
                        }
                    }
                    DPMatchInventroy.saveDeliveryPlans(this.runParam, vo, true);
                }
                invUsedCacheMap.clear();
                deliveryPlanMap.clear();
                purDataList.clear();
            }
            return this.dataAmount;
        }
    }
}

