/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPAsyncRunParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.AbstractPMRPAsyncFacadeControllerBean;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.PMRPAsyncRunThread;
import com.kingdee.eas.mm.common.AsyrunLog;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PMRPAsyncFacadeControllerBean
extends AbstractPMRPAsyncFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected void _asyncRun(Context ctx, PMRPAsyncRunParam runParam) throws BOSException, EASBizException {
        BPOption bpOption = new BPOption();
        bpOption.setImmediately(true);
        DynamicBackground bd = new DynamicBackground(ctx);
        bd.invokeBackound(this.getBOSType(), "backRun", new Class[]{PMRPAsyncRunParam.class}, new Object[]{runParam}, bpOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _backRun(Context ctx, PMRPAsyncRunParam runParam) throws BOSException, EASBizException {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)runParam.getBosType()));
        Class[] classes = new Class[runParam.getParamClassNames().length];
        Method method = null;
        for (int i = 0; i < runParam.getParamClassNames().length; ++i) {
            try {
                classes[i] = Class.forName(runParam.getParamClassNames()[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            method = DynamicBackground.getMethod((IBOSObject)obj, (String)runParam.getMethed(), (Class[])classes);
        }
        catch (NoSuchMethodException e1) {
            throw new BOSException((Throwable)e1);
        }
        Object[] objects = runParam.getParam();
        Map[] map = (Map[])objects[1];
        int size = map.length;
        int batchs = size / 250 + (size % 250 > 0 ? 1 : 0);
        Map[] tempo = null;
        ctx.put((Object)"size", (Object)new Integer(size));
        ctx.put((Object)"seq", (Object)new Integer(0));
        ExecutorService exec = Executors.newFixedThreadPool((int)batchs);
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)exec);
        for (int batch = 0; batch < batchs; ++batch) {
            PMRPAsyncRunThread runThread = new PMRPAsyncRunThread();
            runThread.setMethod(method);
            tempo = new Map[batch != batchs - 1 ? 250 : size - 250 * batch];
            System.arraycopy(map, 250 * batch, tempo, 0, tempo.length);
            runThread.setObject(new Object[]{runParam.getParam()[0], tempo});
            runThread.setObj(obj);
            runThread.setCtx(ctx);
            runThread.setOpType((String)ctx.get((Object)runParam.getBosType()));
            ecs.submit((Callable)runThread);
        }
        int j = 0;
        try {
            for (j = 0; j < batchs; ++j) {
                ecs.take().get();
            }
        }
        catch (InterruptedException e) {
            AsyrunLog asyrunLog = new AsyrunLog();
        }
        catch (ExecutionException e) {
            AsyrunLog asyrunLog = new AsyrunLog();
        }
        finally {
            exec.shutdown();
        }
    }

    @Override
    protected void _addLog(Context ctx, List logList) throws BOSException, EASBizException {
        Connection con = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        PreparedStatement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            AsyrunLog log = null;
            sql.append("insert into t_mm_asychLog(FrunFlag,FdetailLog,FopType,FparamQty ) values(?,?,?,?)");
            batchStatement = con.prepareStatement(sql.toString());
            for (int i = 0; i < logList.size(); ++i) {
                log = (AsyrunLog)logList.get(i);
                batchStatement.setInt(1, log.getRunFlag());
                if (log.getDetailLog().length() <= 255) {
                    batchStatement.setString(2, log.getDetailLog());
                } else {
                    batchStatement.setString(2, log.getDetailLog().substring(0, 255));
                }
                batchStatement.setString(3, log.getOptype());
                batchStatement.setInt(4, log.getParamQty());
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected List _getLog(Context ctx, String opType, int seq) throws BOSException, EASBizException {
        Object log;
        Connection con = null;
        ArrayList<AsyrunLog> list = new ArrayList<AsyrunLog>();
        PreparedStatement batchStatement = null;
        String sql = "select  FrunFlag ,FdetailLog,FparamQty from t_mm_asychLog  where fopType = ?  ";
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            batchStatement = con.prepareStatement(sql);
            batchStatement.setString(1, opType);
            rs = batchStatement.executeQuery();
            while (rs.next()) {
                log = null;
                log = new AsyrunLog();
                log.setDetailLog(rs.getString("FdetailLog"));
                log.setRunFlag(rs.getInt("FrunFlag"));
                log.setParamQty(rs.getInt("FparamQty"));
                list.add((AsyrunLog)log);
            }
            sql = "update t_mm_asychLog set FrunFlag=3  where fopType = ? ";
            batchStatement = con.prepareStatement(sql);
            batchStatement.setString(1, opType);
            batchStatement.executeUpdate();
            log = list;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        return log;
    }

    @Override
    protected void _addFlag(Context ctx, String billID) throws BOSException {
        if (null == billID || "".equals(billID)) {
            return;
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        PreparedStatement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            sql.append("insert into t_mm_asychLog(FopType,FdetailLog,FrunFlag,FparamQty ) values(?,?,?,?)");
            batchStatement = con.prepareStatement(sql.toString());
            batchStatement.setString(1, billID);
            batchStatement.setString(2, billID);
            batchStatement.setInt(3, 0);
            batchStatement.setInt(4, 0);
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected void _removeFlag(Context ctx, String billID) throws BOSException {
        if (null == billID || "".equals(billID)) {
            return;
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        PreparedStatement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            sql.append("delete from t_mm_asychLog where FrunFlag = ?");
            batchStatement = con.prepareStatement(sql.toString());
            batchStatement.setString(1, billID);
            batchStatement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected void _addFlag(Context ctx, Object[] ids) throws BOSException {
        if (null == ids || ids.length < 1) {
            return;
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        Statement batchStatement = null;
        String billID = null;
        try {
            con = this.getConnection(ctx);
            for (int i = 0; i < ids.length; ++i) {
                billID = ids[i].toString();
                sql.append("insert into t_mm_asychLog(FopType,FdetailLog,FrunFlag,FparamQty ) values(?,?,?,?)");
                batchStatement = con.prepareStatement(sql.toString());
                batchStatement.setString(1, billID);
                batchStatement.setString(2, billID);
                batchStatement.setInt(3, 0);
                batchStatement.setInt(4, 0);
            }
            if (batchStatement != null) {
                batchStatement.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected void _removeFlag(Context ctx, Object[] ids) throws BOSException {
        if (null == ids || ids.length < 1) {
            return;
        }
        Connection con = null;
        StringBuffer sql = new StringBuffer();
        Statement batchStatement = null;
        String billID = null;
        try {
            con = this.getConnection(ctx);
            for (int i = 0; i < ids.length; ++i) {
                billID = ids[i].toString();
                sql.append("delete from t_mm_asychLog where FrunFlag = ?");
                batchStatement = con.prepareStatement(sql.toString());
                batchStatement.setString(1, billID);
            }
            if (batchStatement != null) {
                batchStatement.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }
}

