/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.basedata.BOMTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.CalculateProp;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPCheckChildExceptionTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.AbstractPMRPDataAnalysisFacadeControllerBean;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PMRPDataAnalysisFacadeControllerBean
extends AbstractPMRPDataAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.mrp.app.PMRPDataAnalysisFacadeControllerBean");
    private PlanDefinedInfo planDefinedInfo = null;
    private ProjectInfo projectInfo = null;
    private Map errorMap = new HashMap();
    private java.util.Date endDate = null;
    private java.util.Date StartDate_Require = null;
    private java.util.Date StartDate_Supply = null;
    private java.util.Date planTodayDate = null;
    private StringBuffer sql = new StringBuffer();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
    private String successful = "\u6210\u529f";
    private List usedLDBomStorageOrgUnitList = new ArrayList();
    private List ProductOrgUnitList = new ArrayList();
    private List PurRecvStOrgUnitList = new ArrayList();
    private List<String> ProjectIDList = new ArrayList<String>();

    @Override
    protected Map _billAnalysis(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.getParamMapData(ctx, paramMap);
        this.getMinMaxDate(ctx);
        this.errorMap = new HashMap();
        this.ProjectIDList = new ArrayList<String>();
        StringBuffer sqlerrText = new StringBuffer();
        CalculateProp cProp = this.planDefinedInfo.getCalculateProp();
        try {
            if (CalculateProp.SelfProduct.equals((Object)cProp)) {
                this.bill_pcp(ctx);
                this.bill_yxpj_ZZ(ctx);
            } else if (CalculateProp.OutSourcing.equals((Object)cProp)) {
                this.bill_pcp(ctx);
                this.bill_PojectPurBill(ctx);
                this.bill_requirementBill(ctx);
            } else if (this.planDefinedInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM)) {
                this.bill_pcp(ctx);
                this.bill_PojectPurBill(ctx);
                this.bill_requirementBill(ctx);
            } else {
                this.bill_pcp(ctx);
                this.bill_yxpj_ZZ(ctx);
                this.bill_requirementBill(ctx);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        this.errorMap.put("ProjectIDList", this.ProjectIDList);
        return this.errorMap;
    }

    protected void getParamMapData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        int i;
        if (paramMap.get("planDefinedInfo") == null) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u4f20\u5165\u53c2\u6570\u672a\u5305\u542b\u8ba1\u5212\u65b9\u6848planDefinedInfo"));
        }
        this.planDefinedInfo = (PlanDefinedInfo)paramMap.get("planDefinedInfo");
        this.projectInfo = paramMap.get("projectInfo") != null ? (ProjectInfo)paramMap.get("projectInfo") : null;
        if (paramMap.get("ProjectIDList") != null) {
            this.ProjectIDList = (ArrayList)paramMap.get("ProjectIDList");
        }
        this.ProductOrgUnitList = new ArrayList();
        for (i = 0; i < this.planDefinedInfo.getSupplyRelation().getEntry().size(); ++i) {
            this.ProductOrgUnitList.add(this.planDefinedInfo.getSupplyRelation().getEntry().get(i).getProductOrgUnit().getId().toString());
        }
        this.PurRecvStOrgUnitList = new ArrayList();
        for (i = 0; i < this.planDefinedInfo.getPurchaseRelation().getEntry().size(); ++i) {
            this.PurRecvStOrgUnitList.add(this.planDefinedInfo.getPurchaseRelation().getEntry().get(i).getCenSupplyOrgUnit().getId().toString());
        }
    }

    protected void getMinMaxDate(Context ctx) throws BOSException, EASBizException {
        java.util.Date todayDay = new java.util.Date();
        try {
            todayDay = this.sdf.parse(this.sf.format(todayDay) + " 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String planOutLook = this.planDefinedInfo.getPlanOutlook();
        int dpRequire = this.planDefinedInfo.getDpRequire();
        int dpSupply = this.planDefinedInfo.getDpSupply();
        Calendar todayCal = Calendar.getInstance();
        todayCal.setTime(todayDay);
        if (planOutLook == null) {
            planOutLook = "0";
        }
        todayCal.add(5, Integer.parseInt(planOutLook));
        this.endDate = todayCal.getTime();
        if (dpRequire == 0) {
            this.StartDate_Require = todayDay;
        } else if (dpRequire > 0) {
            Calendar beginDateRequirecal = Calendar.getInstance();
            beginDateRequirecal.setTime(todayDay);
            beginDateRequirecal.add(5, dpRequire * -1);
            this.StartDate_Require = beginDateRequirecal.getTime();
        } else {
            this.StartDate_Require = null;
        }
        if (dpSupply == 0) {
            this.StartDate_Supply = todayDay;
        } else if (dpSupply > 0) {
            Calendar beginDateSupplycal = Calendar.getInstance();
            beginDateSupplycal.setTime(todayDay);
            beginDateSupplycal.add(5, dpSupply * -1);
            this.StartDate_Supply = beginDateSupplycal.getTime();
        } else {
            this.StartDate_Supply = null;
        }
        this.planTodayDate = todayDay;
    }

    protected void factorycalendar_analysis(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> orgIDList = new ArrayList<String>();
        for (int i = 0; i < this.planDefinedInfo.getSupplyRelation().getEntry().size(); ++i) {
            SupplyRelationshipDefinitionEntryInfo entryInfo = this.planDefinedInfo.getSupplyRelation().getEntry().get(i);
            if (!orgIDList.contains(entryInfo.getProductOrgUnit().getId().toString())) {
                orgIDList.add(entryInfo.getProductOrgUnit().getId().toString());
            }
            if (orgIDList.contains(entryInfo.getSupplyOrgUnit().getId().toString())) continue;
            orgIDList.add(entryInfo.getSupplyOrgUnit().getId().toString());
        }
        String fdateStr = this.sdf.format(this.endDate);
        this.sql.setLength(0);
        this.sql.append(" Select s.fnumber as forgnumber,s.fname_l2 as forgname  ");
        this.sql.append(" from t_org_storage s ");
        this.sql.append(" where s.fid in (").append(SQLUtil.arrayToString((Object[])orgIDList.toArray())).append(") ");
        this.sql.append(" And Not exists( Select 1  ");
        this.sql.append(" from T_MM_FactoryCalendar c ");
        this.sql.append(" inner join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid  ");
        this.sql.append(" where c.fstorageorgunitid= s.fid and c.FIsDefault = 1 ");
        this.sql.append("and ( ce.fworkdate = {d'");
        this.sql.append(this.sdf.format(this.endDate));
        this.sql.append("'}");
        if (this.StartDate_Require != null && !this.sf.format(this.endDate).equals(this.sf.format(this.StartDate_Require))) {
            this.sql.append(" or ce.fworkdate = {d'");
            this.sql.append(this.sdf.format(this.StartDate_Require));
            this.sql.append("'}");
            fdateStr = fdateStr + "," + this.sdf.format(this.StartDate_Require);
        }
        if (this.StartDate_Supply != null && !this.sf.format(this.endDate).equals(this.sf.format(this.StartDate_Supply)) && this.StartDate_Require != null && !this.sf.format(this.StartDate_Supply).equals(this.sf.format(this.StartDate_Require))) {
            this.sql.append(" or ce.fworkdate = {d'");
            this.sql.append(this.sdf.format(this.StartDate_Supply));
            this.sql.append("'}");
            fdateStr = fdateStr + "," + this.sdf.format(this.StartDate_Supply);
        }
        if (!(this.planTodayDate == null || this.sf.format(this.endDate).equals(this.sf.format(this.planTodayDate)) || this.StartDate_Supply == null || this.sf.format(this.StartDate_Supply).equals(this.sf.format(this.planTodayDate)) || this.StartDate_Require == null || this.sf.format(this.StartDate_Require).equals(this.sf.format(this.planTodayDate)))) {
            this.sql.append(" or ce.fworkdate = {d'");
            this.sql.append(this.sdf.format(this.planTodayDate));
            this.sql.append("'}");
            fdateStr = fdateStr + "," + this.sdf.format(this.planTodayDate);
        }
        this.sql.append(" )) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        try {
            String noEndDateOrgName = null;
            while (rs.next()) {
                if (noEndDateOrgName == null) {
                    noEndDateOrgName = "[" + rs.getString("forgnumber") + "]" + rs.getString("forgname");
                    continue;
                }
                noEndDateOrgName = noEndDateOrgName + ",[" + rs.getString("forgnumber") + "]" + rs.getString("forgname");
            }
            if (noEndDateOrgName != null) {
                noEndDateOrgName = "\u4ee5\u4e0b\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u7ef4\u62a4\u9ed8\u8ba4\u5de5\u5382\u65e5\u5386\uff0c\u6216\u8005\u5de5\u5382\u65e5\u5386\u4e0d\u5305\u542b\u76f8\u5173\u65e5\u671f[" + fdateStr + "]:" + noEndDateOrgName;
                this.errorMap.put("\u5de5\u5382\u65e5\u5386\u6821\u9a8c:", noEndDateOrgName);
            } else {
                this.errorMap.put("\u5de5\u5382\u65e5\u5386\u6821\u9a8c:", this.successful);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        int beforeDay = 180;
        int afterDay = 180;
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        String noEndDateOrgName = null;
        for (int i = 0; i < orgIDList.size(); ++i) {
            String forgUnitID = orgIDList.get(i).toString();
            this.sql.setLength(0);
            this.sql.append(" Select max(Isnull(mp.fproduceleadtime,0)) As fproduceleadtime,max(Isnull(mp.frecevingleadtime,0)) As frecevingleadtime from t_bd_materialplan mp ");
            this.sql.append(" where mp.forgunit = ? ");
            if (bomtype.equals((Object)BOMTypeEnum.ProcessBOM)) {
                this.sql.append(" and exists(Select 1 from ct_zjb_processbombill bom  ");
                this.sql.append(" where bom.cfdrawbillorgid = mp.forgunit and bom.cfmaterialid = mp.fmaterialid ");
                if (this.projectInfo != null) {
                    this.sql.append(" and (bom.cfprojectid is null or bom.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" and (bom.cfprojectid is null or bom.cfprojectid  in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append("  and bom.cfstate = 4 ) ");
            } else {
                this.sql.append(" and exists(Select 1 from t_mm_bom bom  inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
                this.sql.append(" where bomentry.fsupplystorageorgunitid = mp.forgunit and bomentry.fmaterialid = mp.fmaterialid ");
                if (this.projectInfo != null) {
                    this.sql.append(" and (bom.fprojectid is null or bom.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" and (bom.fprojectid is null or bom.fprojectid  in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and bom.fbasestatus = 4 and bom.fdesignmodeid is not null) ");
            }
            IRowSet rs2 = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])new Object[]{forgUnitID});
            try {
                while (rs.next()) {
                    int fproduceleadtime = rs.getInt("fproduceleadtime");
                    int frecevingleadtime = rs.getInt("frecevingleadtime");
                    Calendar minDateCal = Calendar.getInstance();
                    minDateCal.setTime(this.planTodayDate);
                    minDateCal.add(5, fproduceleadtime + frecevingleadtime + beforeDay);
                    this.sql.setLength(0);
                    this.sql.append(" Select s.fnumber as forgnumber,s.fname_l2 as forgname  ");
                    this.sql.append(" from t_org_storage s ");
                    this.sql.append(" where s.fid = '").append(forgUnitID).append("' ");
                    this.sql.append(" And Not exists( Select 1  ");
                    this.sql.append(" from T_MM_FactoryCalendar c ");
                    this.sql.append(" inner join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid  ");
                    this.sql.append(" where c.fstorageorgunitid= s.fid and c.FIsDefault = 1 ");
                    this.sql.append("and ce.fworkdate = {d'");
                    this.sql.append(this.sdf.format(minDateCal.getTime()));
                    this.sql.append("'})");
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                    if (rs2.next()) {
                        noEndDateOrgName = noEndDateOrgName == null ? "\u5e93\u5b58\u7ec4\u7ec7[" + rs2.getString("forgnumber") + "]" + rs2.getString("forgname") + "\u5bf9\u5e94\u7684\u9ed8\u8ba4\u5de5\u4f5c\u65e5\u5386\u4e0d\u5305\u542b\u76f8\u5173\u65e5\u671f[" + this.sdf.format(minDateCal.getTime()) + "]" : noEndDateOrgName + "\r\n,\u5e93\u5b58\u7ec4\u7ec7[" + rs2.getString("forgnumber") + "]" + rs2.getString("forgname") + "\u5bf9\u5e94\u7684\u9ed8\u8ba4\u5de5\u4f5c\u65e5\u5386\u4e0d\u5305\u542b\u76f8\u5173\u65e5\u671f[" + this.sdf.format(minDateCal.getTime()) + "]";
                    }
                    Calendar maxDateCal = Calendar.getInstance();
                    maxDateCal.setTime(this.planTodayDate);
                    maxDateCal.add(5, afterDay);
                    this.sql.setLength(0);
                    this.sql.append(" Select s.fnumber as forgnumber,s.fname_l2 as forgname  ");
                    this.sql.append(" from t_org_storage s ");
                    this.sql.append(" where s.fid = '").append(forgUnitID).append("' ");
                    this.sql.append(" And Not exists( Select 1  ");
                    this.sql.append(" from T_MM_FactoryCalendar c ");
                    this.sql.append(" inner join t_Mm_Factorycalendarentry ce on c.fid=ce.fparentid  ");
                    this.sql.append(" where c.fstorageorgunitid= s.fid and c.FIsDefault = 1 ");
                    this.sql.append("and ce.fworkdate = {d'");
                    this.sql.append(this.sdf.format(maxDateCal.getTime()));
                    this.sql.append("'})");
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                    if (!rs2.next()) continue;
                    if (noEndDateOrgName == null) {
                        noEndDateOrgName = "\u5e93\u5b58\u7ec4\u7ec7[" + rs2.getString("forgnumber") + "]" + rs2.getString("forgname") + "\u5bf9\u5e94\u7684\u9ed8\u8ba4\u5de5\u4f5c\u65e5\u5386\u4e0d\u5305\u542b\u76f8\u5173\u65e5\u671f[" + this.sdf.format(maxDateCal.getTime()) + "]";
                        continue;
                    }
                    noEndDateOrgName = noEndDateOrgName + "\r\n,\u5e93\u5b58\u7ec4\u7ec7[" + rs2.getString("forgnumber") + "]" + rs2.getString("forgname") + "\u5bf9\u5e94\u7684\u9ed8\u8ba4\u5de5\u4f5c\u65e5\u5386\u4e0d\u5305\u542b\u76f8\u5173\u65e5\u671f[" + this.sdf.format(maxDateCal.getTime()) + "]";
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        if (noEndDateOrgName != null) {
            noEndDateOrgName = "\u5e93\u5b58\u7ec4\u7ec7\u7269\u6599\u6700\u5927\u63d0\u524d\u671f\u6240\u5728\u7684\u5de5\u5382\u65e5\u5386\u6821\u9a8c:" + noEndDateOrgName;
            this.errorMap.put("\u6700\u5927\u63d0\u524d\u671f\u5de5\u5382\u65e5\u5386\u6821\u9a8c:", noEndDateOrgName);
        } else {
            this.errorMap.put("\u6700\u5927\u63d0\u524d\u671f\u5de5\u5382\u65e5\u5386\u6821\u9a8c:", this.successful);
        }
    }

    protected void bill_pcp(Context ctx) throws BOSException, EASBizException, SQLException {
        String pcpstatusSt = this.planDefinedInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM) ? "4,6" : "4";
        this.sql.setLength(0);
        this.sql.append(" /*dialect*/ ");
        this.sql.append(" select h.fnumber as fbillnumber");
        this.sql.append(" ,morg.fstorageorgunitid as forgid ");
        this.sql.append(" ,mp.fmaterialattr as fmaterialattr");
        this.sql.append(" ,mp.fstatus as fmpstatus");
        this.sql.append(" ,h.Ffinishtime as fbilldate");
        this.sql.append(" ,mp.fplanningmode as fplanningmode");
        this.sql.append(" ,mp.fmanufacturestrategyid as fmanufacturestrategyid");
        this.sql.append(" ,mp.fisolatedrule as fisolatedrule");
        this.sql.append(" ,h.fmaterialid as fmaterialid");
        this.sql.append(" ,h.fprojectid as fprojectid");
        this.sql.append(" ,t.fnumber as ftrackNumber");
        this.sql.append(" ,s.fname_l2 as forgname");
        this.sql.append(" ,m.fnumber as fmaterialname");
        this.sql.append(" from T_PCP_ProjectCP h \r\n");
        this.sql.append(" left outer join T_PCP_ProjectCPSE morg on  morg.FParentID = h.FID");
        this.sql.append(" and not exists(select 1 from T_PCP_ProjectCPSE e where e.FParentID = h.FID and e.FSeq < morg.FSeq)");
        this.sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = h.fmaterialid and mp.Forgunit = morg.fstorageorgunitid ");
        this.sql.append(" left outer join t_mm_tracknumber t on t.fid = h.Ftracknumberid ");
        this.sql.append(" left outer join t_org_storage s on s.fid = morg.fstorageorgunitid ");
        this.sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
        this.sql.append(" where h.fstate in (" + pcpstatusSt + ")");
        this.sql.append(" AND h.Fstorageorgunitid  = '").append(this.planDefinedInfo.getStorageOrg().getId()).append("' ");
        this.sql.append("  AND h.fqty - nvl(h.Fcloseqty,0) > 0 ");
        if (this.projectInfo != null) {
            this.sql.append("  AND h.fprojectid = '" + this.projectInfo.getId().toString() + "' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        this.checkBillData(ctx, rs, "PCP");
    }

    protected String checkHaveBom(Context ctx, String fmaterialid, String fstorageOrgUnitID, String fprojectid, String ftrackNumber, String bomtype) throws BOSException, EASBizException, SQLException {
        IRowSet rs;
        String fbomid = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.sql.setLength(0);
        this.sql.append(" SELECT top 1 h.fid ");
        this.sql.append(" from  ");
        if (bomtype.equals("PROCESSBOM")) {
            this.sql.append(" ct_zjb_processbombill h  ");
            if (ftrackNumber != null) {
                this.sql.append(" left outer join  t_mm_trackNumber bt on bt.fid = h.cfbegincarnoid");
                this.sql.append(" left outer join  t_mm_trackNumber et on et.fid = h.cfendcarnoid");
            }
            this.sql.append(" where h.cfparentid = ? ");
            this.sql.append(" and h.cfstorageorgunitid = ? ");
            if (fprojectid != null) {
                this.sql.append(" and (h.cfprojectid is null or h.cfprojectid = ? )");
            }
            this.sql.append(" and h.cfstate = ? ");
            this.sql.append(" and h.cfration > ? ");
        } else {
            this.sql.append(" t_mm_bom h  ");
            this.sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid  ");
            if (ftrackNumber != null) {
                this.sql.append(" left outer join  t_mm_trackNumber bt on bt.fid = d.fbegincarnoid");
                this.sql.append(" left outer join  t_mm_trackNumber et on et.fid = d.fendcarnoid");
            }
            this.sql.append(" where h.fmaterialid = ? ");
            this.sql.append(" and h.fstorageorgunitid = ? ");
            if (fprojectid != null) {
                this.sql.append(" and (h.fprojectid is null or h.fprojectid = ? ) ");
            }
            this.sql.append(" and h.fbasestatus = ? ");
            this.sql.append(" and d.fconsumefixqty > ? ");
            this.sql.append(" and h.fdesignModeid is not null ");
        }
        paramList.add(fmaterialid);
        paramList.add(fstorageOrgUnitID);
        if (fprojectid != null) {
            paramList.add(fprojectid);
        }
        paramList.add(Integer.parseInt("4"));
        paramList.add(BigDecimal.ZERO);
        if (ftrackNumber != null) {
            this.sql.append(" and (bt.fid is null or bt.fnumber <= ?) ");
            this.sql.append(" and (et.fid is null or et.fnumber >= ?) ");
            paramList.add(ftrackNumber);
            paramList.add(ftrackNumber);
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])paramList.toArray())).next()) {
            fbomid = rs.getString("fid");
        }
        return fbomid;
    }

    protected boolean isNeedBom(Context ctx, String fmanufacturestrategyid, String fisolatedrule) throws BOSException, EASBizException {
        if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(fmanufacturestrategyid)) {
            return "ITEM_TRACKNO".equals(fisolatedrule);
        }
        return false;
    }

    protected void bill_yxpj_ZZ(Context ctx) throws BOSException, EASBizException, SQLException {
        this.sql.setLength(0);
        this.sql.append(" SELECT h.fnumber as fbillnumber");
        this.sql.append(" ,d.cfactualprocessunitid as forgid ");
        this.sql.append(" ,mp.fmaterialattr as fmaterialattr");
        this.sql.append(" ,mp.fstatus as fmpstatus");
        this.sql.append(" ,d.cfdeliverdate as fbilldate");
        this.sql.append(" ,mp.fplanningmode as fplanningmode");
        this.sql.append(" ,mp.fmanufacturestrategyid as fmanufacturestrategyid");
        this.sql.append(" ,mp.fisolatedrule as fisolatedrule");
        this.sql.append(" ,d.Cfmaterialid as fmaterialid");
        this.sql.append(" ,h.Cfprojectid as fprojectid");
        this.sql.append(" ,t.fnumber as ftrackNumber");
        this.sql.append(" ,s.fname_l2 as forgname");
        this.sql.append(" ,m.fnumber as fmaterialname");
        this.sql.append(" from CT_PM_MarketingFRP h \r\n");
        this.sql.append(" left outer join Ct_Pm_Marketingfrpe d on h.fid = d.fparentid");
        this.sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = d.Cfmaterialid and mp.Forgunit = d.cfactualprocessunitid ");
        this.sql.append(" left outer join t_mm_tracknumber t on t.fid = d.Cftracknumberid ");
        this.sql.append(" left outer join t_org_storage s on s.fid = d.cfactualprocessunitid ");
        this.sql.append(" left outer join t_bd_material m on m.fid = d.Cfmaterialid ");
        this.sql.append(" WHERE h.Cfbasestatus = ").append(4).append("");
        this.sql.append(" AND h.Cfstorageorgunitid  = '").append(this.planDefinedInfo.getStorageOrg().getId()).append("' ");
        this.sql.append(" AND d.fpurchaseorgunitid  is null ");
        this.sql.append(" And d.Cfrequireqty - Isnull(d.Fcloseqty,0) > 0  ");
        this.sql.append(this.getPlanDefineRequireSetWhere_YXPJ());
        if (this.projectInfo != null) {
            this.sql.append("  AND h.Cfprojectid = '" + this.projectInfo.getId().toString() + "' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        this.checkBillData(ctx, rs, "YXPJ_ZZ");
    }

    protected String getPlanDefineRequireSetWhere_YXPJ() {
        StringBuilder sql = new StringBuilder();
        Object CfmfrpbilltypeID = null;
        return sql.toString();
    }

    protected void checkBillData(Context ctx, IRowSet rs, String billtype) throws BOSException, EASBizException, SQLException {
        String ferrorText = "";
        String fRowerrorText = null;
        boolean hasError = false;
        int okcount = 0;
        String fstorageOrgUnitID = null;
        String fmaterialattr = null;
        String fmaterialid = null;
        String fprojectid = null;
        String ftrackNumber = null;
        Date fbilldate = null;
        String fplanningmode = null;
        String fmanufacturestrategyid = null;
        String fisolatedrule = null;
        String fbomid = null;
        String fmaterialname = null;
        String forgunitname = null;
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        while (rs.next()) {
            fRowerrorText = null;
            if (fRowerrorText == null) {
                fRowerrorText = "\u5355\u636e\u53f7[" + rs.getString("fbillnumber") + "]";
            }
            hasError = false;
            if (rs.getString("forgid") == null) {
                hasError = true;
                fRowerrorText = "REQUIREMENTBILL".equals(billtype) ? fRowerrorText + ",\u5206\u5f55\u4e0d\u5b58\u5728\u6536\u8d27\u7ec4\u7ec7." : fRowerrorText + ",\u5206\u5f55\u7b2c\u4e00\u884c\u4e0d\u5b58\u5728\u751f\u4ea7\u7ec4\u7ec7.";
            } else {
                fstorageOrgUnitID = rs.getString("forgid");
                fmaterialattr = rs.getString("fmaterialattr");
                fmaterialid = rs.getString("fmaterialid");
                fprojectid = rs.getString("fprojectid");
                ftrackNumber = rs.getString("ftrackNumber");
                fbilldate = rs.getDate("fbilldate");
                fplanningmode = rs.getString("fplanningmode");
                fmanufacturestrategyid = rs.getString("fmanufacturestrategyid");
                fisolatedrule = rs.getString("fisolatedrule");
                fmaterialname = rs.getString("fmaterialname");
                forgunitname = rs.getString("forgname");
                if (!this.ProjectIDList.contains(fprojectid)) {
                    this.ProjectIDList.add(fprojectid);
                }
                if (!"REQUIREMENTBILL".equals(billtype) && !this.ProductOrgUnitList.contains(fstorageOrgUnitID)) {
                    hasError = true;
                    fRowerrorText = fRowerrorText + ",\u751f\u4ea7\u7ec4\u7ec7[" + rs.getString("forgname") + "]\u4e0d\u5b58\u5728\u4e8e\u8ba1\u5212\u65b9\u6848\u7684\u4f9b\u5e94\u5173\u7cfb\u7684[\u751f\u4ea7\u7ec4\u7ec7]\u8303\u56f4\u5185.";
                } else {
                    if ("REQUIREMENTBILL".equals(billtype) && !this.PurRecvStOrgUnitList.contains(fstorageOrgUnitID)) {
                        hasError = true;
                        fRowerrorText = fRowerrorText + ",\u6536\u8d27\u7ec4\u7ec7[" + rs.getString("forgname") + "]\u4e0d\u5b58\u5728\u4e8e\u8ba1\u5212\u65b9\u6848\u7684\u91c7\u8d2d\u5173\u7cfb\u7684\u3010\u96c6\u4e2d\u4f9b\u8d27\u7ec4\u7ec7\u3011\u8303\u56f4\u5185.";
                    }
                    if (fmaterialid == null || "".equals(fmaterialid)) {
                        if ("PCP".equals(billtype)) {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u8868\u5934\u7684\u7269\u6599ID\u4e3a\u7a7a.";
                        } else {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u7269\u6599ID\u4e3a\u7a7a.";
                        }
                    } else {
                        fRowerrorText = fRowerrorText + ",\u7269\u6599[" + fmaterialname + "],\u5e93\u5b58\u7ec4\u7ec7[" + forgunitname + "]";
                        if (rs.getString("fmpstatus") == null || !rs.getString("fmpstatus").equals("1")) {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u672a\u6838\u51c6\u6216\u4e0d\u5b58\u5728.";
                        } else {
                            if (!("REQUIREMENTBILL".equals(billtype) || fmaterialattr != null && "10030".equals(fmaterialattr))) {
                                hasError = true;
                                fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5bf9\u5e94\u7684\u7269\u6599\u5c5e\u6027\u4e0d\u662f\u81ea\u5236\u4ef6.";
                            }
                            if (fplanningmode == null || !"2".equals(fplanningmode) && !"3".equals(fplanningmode)) {
                                hasError = true;
                                fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u7684\u8ba1\u5212\u6a21\u5f0f\u4e0d\u662fMRP/MPS.";
                            }
                            if (fmanufacturestrategyid == null || fisolatedrule == null) {
                                hasError = true;
                                fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5bf9\u5e94\u7684\u5236\u9020\u7b56\u7565\u3001\u9694\u79bb\u89c4\u5219\u4e3a\u7a7a.";
                            } else {
                                fbomid = null;
                                if (!"REQUIREMENTBILL".equals(billtype)) {
                                    if (fmaterialattr.equals("10030") || fmaterialattr.equals("10020")) {
                                        if (!this.isNeedBom(ctx, fmanufacturestrategyid, fisolatedrule)) {
                                            hasError = true;
                                            fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u7269\u6599\u5c5e\u6027\u4e3a\u81ea\u5236\u6216\u8005\u865a\u62df\u4ef6\uff0c\u5236\u9020\u7b56\u7565\u5fc5\u987b\u4e3aETO20\u4e14\u9694\u79bb\u89c4\u5219\u5fc5\u987b\u662f\u6309\u9879\u76ee\u53f7+\u8ddf\u8e2a\u53f7.";
                                        } else {
                                            fbomid = this.checkHaveBom(ctx, fmaterialid, fstorageOrgUnitID, fprojectid, ftrackNumber, "PROCONFIGBOM");
                                            if (fbomid == null || "".equals(fbomid)) {
                                                hasError = true;
                                                fRowerrorText = fRowerrorText + ",\u6ca1\u6709\u5ba1\u6838\u7684\u9879\u76ee\u914d\u7f6eBOM.";
                                            }
                                        }
                                    } else if (this.isNeedBom(ctx, fmanufacturestrategyid, fisolatedrule) && ((fbomid = this.checkHaveBom(ctx, fmaterialid, fstorageOrgUnitID, fprojectid, ftrackNumber, "PROCONFIGBOM")) == null || "".equals(fbomid))) {
                                        hasError = true;
                                        fRowerrorText = fRowerrorText + ",\u6ca1\u6709\u5ba1\u6838\u7684\u9879\u76ee\u914d\u7f6eBOM.";
                                    }
                                }
                                if (!"REQUIREMENTBILL".equals(billtype)) {
                                    if (this.sf.format(this.endDate).compareTo(this.sf.format(fbilldate)) < 0) {
                                        hasError = true;
                                        fRowerrorText = fRowerrorText + ",\u5b8c\u5de5\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u8d85\u8fc7\u4e86\u8ba1\u5212\u5c55\u671b\u671f[" + this.sf.format(this.endDate) + "].";
                                    } else if (this.StartDate_Require != null && this.sf.format(this.StartDate_Require).compareTo(this.sf.format(fbilldate)) > 0) {
                                        fRowerrorText = fRowerrorText + ",\u5b8c\u5de5\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u5c0f\u4e8e\u9700\u6c42\u62d6\u671f[" + this.sf.format(this.StartDate_Require) + "].";
                                    }
                                } else if (this.sf.format(this.endDate).compareTo(this.sf.format(fbilldate)) < 0) {
                                    hasError = true;
                                    fRowerrorText = fRowerrorText + ",\u5206\u5f55\u5230\u8d27\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u8d85\u8fc7\u4e86\u8ba1\u5212\u5c55\u671b\u671f[" + this.sf.format(this.endDate) + "].";
                                } else if (this.StartDate_Require != null && this.sf.format(this.StartDate_Require).compareTo(this.sf.format(fbilldate)) > 0) {
                                    fRowerrorText = fRowerrorText + ",\u5206\u5f55\u5230\u8d27\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u5c0f\u4e8e\u9700\u6c42\u62d6\u671f[" + this.sf.format(this.StartDate_Require) + "].";
                                }
                            }
                        }
                    }
                }
            }
            if (hasError) {
                if (fRowerrorText == null) {
                    ferrorText = fRowerrorText + "\r\n";
                    continue;
                }
                ferrorText = ferrorText + fRowerrorText + "\r\n";
                continue;
            }
            ++okcount;
        }
        String checkTitle = null;
        checkTitle = billtype.equals("PCP") ? "\u9879\u76ee\u534f\u540c\u8ba1\u5212\u5355\u636e\u6821\u9a8c" : (billtype.equals("YXPJ_ZZ") ? "\u8425\u9500\u914d\u4ef6\u6eda\u52a8\u8ba1\u5212(\u81ea\u5236)\u5355\u636e\u6821\u9a8c" : (billtype.equals("REQUIREMENTBILL") ? "\u9700\u6c42\u7533\u8bf7\u5355\u636e\u6821\u9a8c" : "\u672a\u77e5\u7c7b\u578b"));
        if (ferrorText == null || "".equals(ferrorText)) {
            this.errorMap.put(checkTitle, this.successful);
        } else {
            this.errorMap.put(checkTitle, ferrorText + " \u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u6570\u91cf=" + okcount);
        }
    }

    @Override
    protected Map _baseSetAnalysis(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.getParamMapData(ctx, paramMap);
        this.errorMap = new HashMap();
        ArrayList<String> tempTableNamList = new ArrayList<String>();
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        try {
            String materialOrgUnitTempTable = this.createMaterialOrgUnitTempTable(ctx);
            tempTableNamList.add(materialOrgUnitTempTable);
            if (bomtype.equals((Object)BOMTypeEnum.ProcessBOM)) {
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,FneedDisOrgUnitID)");
                this.sql.append(" Select distinct a.cfmaterialid,a.cfstorageorgunitid,a.cfmaterialproperty,1 ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=a.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfdrawbillorgid <> a.cfstorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and a.cfmaterialproperty in(10030)  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = a.cfstorageorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct a.cfmaterialid,a.cfdrawbillorgid,a.cfmaterialproperty ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfstate = 4 And  a.cfmaterialid is not null  and a.cfdrawbillorgid is not  null ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = a.cfdrawbillorgid and b.FmaterialAttr = a.cfmaterialproperty  ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct a.cfparentid,a.cfstorageorgunitid,0 ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4  and a.cfparentid is not null and a.cfstorageorgunitid is not null ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfparentid and b.FStorageOrgUnitID = a.cfstorageorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct a.cfmaterialid,mpEx.Fdistributionorgunitid,10040 ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=a.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left outer join  T_MAT_EMMMaterialPlan mpEx on mpEx.fmaterialid = a.cfmaterialid and mpEx.Fstorageorgunitid = a.cfstorageorgunitid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfdrawbillorgid <> a.cfstorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and a.cfmaterialproperty in(10030)  ");
                this.sql.append(" and mpEx.Fdistributionorgunitid is not null  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = mpEx.Fdistributionorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
            } else if (bomtype.equals((Object)BOMTypeEnum.MfgBOM)) {
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,FneedDisOrgUnitID)");
                this.sql.append(" Select distinct d.fmaterialid,a.fstorageorgunitid,d.fmaterialprop,1 ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=d.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.fstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "' ) ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and d.fconsumefixqty > 0 ");
                this.sql.append(" and a.fstorageorgunitid <> d.fsupplystorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and d.fmaterialprop in(10030)  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = a.FStorageOrgUnitID ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct d.fmaterialid,d.fsupplystorageorgunitid,d.fmaterialprop ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and d.fconsumefixqty > 0 ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = d.fsupplystorageorgunitid and b.FmaterialAttr = d.fmaterialprop  ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct a.fmaterialid,a.fstorageorgunitid,0 ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.fmaterialid and b.FStorageOrgUnitID = a.fstorageorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr)");
                this.sql.append(" Select distinct d.fmaterialid,mpEx.Fdistributionorgunitid,10040 ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=d.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.fstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left outer join  T_MAT_EMMMaterialPlan mpEx on mpEx.fmaterialid = d.fmaterialid and mpEx.Fstorageorgunitid = a.fstorageorgunitid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and d.fconsumefixqty > 0 ");
                this.sql.append(" and a.fstorageorgunitid <> d.fsupplystorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and d.fmaterialprop in(10030,10070,10090)  ");
                this.sql.append(" and mpEx.fdistributionorgunitid is not null  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = mpEx.fdistributionorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
            }
            this.checkMaterialBaseData(ctx, materialOrgUnitTempTable);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableNamList != null && tempTableNamList.size() > 0) {
                for (int i = 0; i < tempTableNamList.size(); ++i) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableNamList.get(i).toString());
                }
            }
        }
        return this.errorMap;
    }

    protected String createMaterialOrgUnitTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MamterialOrgUnitTempTable(\r\n");
        sql.append("FMATERIALID VARCHAR(44) NOT Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) NOT Null, \r\n");
        sql.append("FmaterialAttr INTEGER  Null, \r\n");
        sql.append("FneedDisOrgUnitID INTEGER  Null, \r\n");
        sql.append("FprojectID VARCHAR(44) \r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMATERIALID,FStorageOrgUnitID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FprojectID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected void checkMaterialBaseData(Context ctx, String materialOrgUnitTempTable) throws BOSException, EASBizException, SQLException {
        String ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where Not Exists(Select 1 from t_bd_materialplan mp where mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u4ee5\u4e0b\u7269\u6599\u4e0d\u5b58\u5728\u6838\u51c6\u72b6\u6001\u7684\u8ba1\u5212\u9875\u7b7e\u6570\u636e: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u662f\u5426\u6838\u51c6\u6821\u9a8c", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u662f\u5426\u6838\u51c6\u6821\u9a8c", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" left outer join T_MAT_EMMMaterialPlan mp on mp.fmaterialid = a.FMATERIALID and mp.Fstorageorgunitid = a.FStorageOrgUnitID and mp.Fbasestatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where FneedDisOrgUnitID = 1 And mp.fdistributionorgunitid is null ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u4ee5\u4e0b\u7269\u6599\u8ba1\u5212\u9875\u7b7e(\u6269\u5c55\u5c5e\u6027)\u6ca1\u6709\u8bbe\u7f6e\u914d\u9001\u7ec4\u7ec7: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u6269\u5c55\u5c5e\u6027\u662f\u5426\u8bbe\u7f6e\u4e86\u914d\u9001\u7ec4\u7ec7", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u6269\u5c55\u5c5e\u6027\u662f\u5426\u8bbe\u7f6e\u4e86\u914d\u9001\u7ec4\u7ec7", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where (mp.fmaterialattr is null or mp.fmaterialattr in(10010,-1,10060)) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u7269\u6599\u5c5e\u6027\u4e3a\u7a7a\u6216\u4e3a\u89c4\u5212\u4ef6\u3001\u5176\u5b83: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u7269\u6599\u5c5e\u6027", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u7269\u6599\u5c5e\u6027", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where (mp.fplanningmode is null or mp.fplanningmode not in(2,3)) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u8ba1\u5212\u6a21\u5f0f\u4e0d\u4e3aMRP/MPS: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u8ba1\u5212\u6a21\u5f0f", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u8ba1\u5212\u6a21\u5f0f", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where (mp.foutputtype is null or mp.foutputtype not in(10710,10740)) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u4e3b\u8054\u526f\u4ea7\u54c1\u4e0d\u4e3a\u4e3b\u4ea7\u54c1\u6216\u5176\u5b83: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u4e3b\u8054\u526f\u4ea7\u54c1", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u4e3b\u8054\u526f\u4ea7\u54c1", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where (mp.fmanufacturestrategyid is null or mp.fmanufacturestrategyid not in ('NUnM+gEcEADgAA3cwKgL09g0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=')) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u5236\u9020\u7b56\u7565\u4e0d\u4e3a ETO20 \u6216 MTS10: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u5236\u9020\u7b56\u7565", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u5236\u9020\u7b56\u7565", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where mp.fmanufacturestrategyid in ( 'qAXoUB/uBg/gQKjAYj0WQ9g0uEU=') ");
        this.sql.append(" And a.FmaterialAttr in (0,10030,10020) ");
        this.sql.append(" And (mp.fisolatedrule is null or mp.fisolatedrule in ('NONE') )  ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u9694\u79bb\u89c4\u5219\u4e3a\u7a7a: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u9694\u79bb\u89c4\u5219", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u9694\u79bb\u89c4\u5219", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" inner join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID and mp.fstatus = 1 ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where mp.fissmode =  ").append(11040);
        this.sql.append(" and a.FmaterialAttr in (").append(10040);
        this.sql.append(",").append(10050);
        this.sql.append("  )  ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u8ba1\u5212\u9875\u7b7e\u7684\u9886\u9001\u6599\u65b9\u5f0f\u4e3a\u4e0d\u9886\u6599\uff0c\u4e14\u7269\u6599\u5c5e\u6027\u4e3a(\u5916\u8d2d\u59d4\u5916\u76f4\u6d41\u5382\u5916\u76f4\u6d41),\u8bf7\u68c0\u67e5\u662f\u5426\u5408\u7406\uff1f: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u9886\u9001\u6599\u65b9\u5f0f", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u8ba1\u5212\u9875\u7b7e-\u9886\u9001\u6599\u65b9\u5f0f", ferrorText);
        }
        ferrorText = null;
        this.sql.setLength(0);
        this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
        this.sql.append(" ,m.fname_l2 as fmaterialname ");
        this.sql.append(" ,s.fname_l2 as forgname ");
        this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
        this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
        this.sql.append(" Where Not Exists(Select 1 from t_bd_materialinventory mi where mi.fmaterialid = a.FMATERIALID and mi.forgunit = a.FStorageOrgUnitID and mi.fstatus = 1 ) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        while (rs.next()) {
            if (ferrorText == null) {
                ferrorText = " \u4ee5\u4e0b\u7269\u6599\u4e0d\u5b58\u5728\u6838\u51c6\u72b6\u6001\u7684\u5e93\u5b58\u9875\u7b7e\u6570\u636e: ";
            }
            ferrorText = ferrorText + "[" + rs.getString("fmaterialnumber") + "]" + rs.getString("fmaterialname") + " - " + rs.getString("forgname") + "\r\n";
        }
        if (ferrorText == null) {
            this.errorMap.put("\u7269\u6599\u5e93\u5b58\u9875\u7b7e\u662f\u5426\u6838\u51c6\u6821\u9a8c", this.successful);
        } else {
            this.errorMap.put("\u7269\u6599\u5e93\u5b58\u9875\u7b7e\u662f\u5426\u6838\u51c6\u6821\u9a8c", ferrorText);
        }
    }

    @Override
    protected Map _bomAnalysis(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.getParamMapData(ctx, paramMap);
        this.errorMap = new HashMap();
        ArrayList tempTableNamList = new ArrayList();
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        try {
            String ferrorText = null;
            IRowSet rs = null;
            if (BOMTypeEnum.ProcessBOM.equals((Object)bomtype)) {
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfparentno as fparentmaterialnumber,a.cfparentname as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate <> 4 ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u7236\u9879\u7269\u6599\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u662f\u5426\u5408\u7406\uff1f: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-\u662f\u5426\u5ba1\u6838", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-\u662f\u5426\u5ba1\u6838", ferrorText);
                }
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfparentno as fparentmaterialnumber,a.cfparentname as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfparentid is null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u7236\u9879\u7269\u6599\u4e0d\u5b58\u5728cfparentid\uff1f: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-cfparentid\u662f\u5426\u5b58\u5728", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-cfparentid\u662f\u5426\u5b58\u5728", ferrorText);
                }
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfportno as fparentmaterialnumber,a.cfname as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfmaterialid is null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u5b50\u9879\u7269\u6599\u4e0d\u5b58\u5728cfmaterialid,\u8bf7\u68c0\u67e5\u662f\u5426\u5408\u7406\uff1f: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-cfmaterialid\u662f\u5426\u5b58\u5728", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-cfmaterialid\u662f\u5426\u5b58\u5728", ferrorText);
                }
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfparentno as fparentmaterialnumber,a.cfparentname as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" inner join t_bd_material m on a.cfparentid = m.fid ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfparentno  <> m.fnumber ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u7236\u9879\u7269\u6599\u7f16\u7801\u4e0ecfparentid\u5bf9\u5e94\u7684\u7269\u6599\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u4e00\u81f4: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-\u7236\u9879\u7269\u6599\u7f16\u7801\u662f\u5426\u4e0e\u57fa\u7840\u8d44\u6599\u4e00\u81f4", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-\u7236\u9879\u7269\u6599\u7f16\u7801\u662f\u5426\u4e0e\u57fa\u7840\u8d44\u6599\u4e00\u81f4", ferrorText);
                }
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfportno as fparentmaterialnumber,a.cfname as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" inner join t_bd_material m on a.cfmaterialid = m.fid ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfportno  <> m.fnumber ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u5b50\u9879\u7269\u6599\u7f16\u7801\u4e0ecfmaterialid\u5bf9\u5e94\u7684\u7269\u6599\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e0d\u4e00\u81f4: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-\u5b50\u9879\u7269\u6599\u7f16\u7801\u662f\u5426\u4e0e\u57fa\u7840\u8d44\u6599\u4e00\u81f4", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-\u5b50\u9879\u7269\u6599\u7f16\u7801\u662f\u5426\u4e0e\u57fa\u7840\u8d44\u6599\u4e00\u81f4", ferrorText);
                }
                ferrorText = null;
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct a.cfparentno as fparentmaterialnumber,a.cfparentname as fparentmaterialname ,p.fnumber as fprojectnumber");
                this.sql.append(" ,s.fname_l2 as forgname ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" inner join t_org_storage s  on s.fid = a.cfdrawbillorgid ");
                this.sql.append(" inner join t_bd_materialplan mp  on mp.fmaterialid = a.cfparentid and mp.forgunit = a.cfstorageorgunitid ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.cfprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfmaterialproperty  in(10030,10020,10070,10050) ");
                this.sql.append(" and (Isnull(mp.FManufactureStrategyID,'*') not in ('GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=') \r\n");
                this.sql.append(" or Isnull(mp.fisolatedrule,'NONE') not in ( 'ITEM','ITEM_TRACKNO') ) ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5de5\u827aBOM\u7236\u9879\u7269\u6599\u7f16\u7801\u4e3a\u81ea\u5236\u4ef6\u6216\u8005\u865a\u62df\u3001\u5382\u5185\u76f4\u6d41\u4ef6\u3001\u59d4\u5916\u4ef6\uff0c\u4f46\u9694\u79bb\u89c4\u5219\u8bbe\u7f6e\u4e3a\u975eETO20(ETO10)+\u6309\u9879\u76ee\u8ddf\u8e2a\u53f7(\u6309\u9879\u76ee\u53f7)\uff0c\u53ef\u80fd\u9020\u6210MRP\u8fd0\u7b97\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u8fdb\u884cBOM\u5c55\u5f00: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + " \u5e93\u5b58\u7ec4\u7ec7=" + rs.getString("forgname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5de5\u827aBOM-\u7236\u9879\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u5236\u9020\u7b56\u7565\u6821\u9a8c", this.successful);
                } else {
                    this.errorMap.put("\u5de5\u827aBOM-\u7236\u9879\u7269\u6599\u8ba1\u5212\u9875\u7b7e\u5236\u9020\u7b56\u7565\u6821\u9a8c", ferrorText);
                }
            } else if (BOMTypeEnum.MfgBOM.equals((Object)bomtype)) {
                this.sql.setLength(0);
                this.sql.append(" Select distinct m.fnumber as fparentmaterialnumber,m.fname_l2 as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_bd_material m on m.fid = a.fmaterialid ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.fprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fdesignmodeid is not null ");
                this.sql.append(" and a.fbasestatus <> 4 ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u9879\u76ee\u914d\u7f6eBOM\u7236\u9879\u7269\u6599\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u662f\u5426\u5408\u7406\uff1f: ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5236\u9020BOM-\u662f\u5426\u5ba1\u6838", this.successful);
                } else {
                    this.errorMap.put("\u5236\u9020BOM-\u662f\u5426\u5ba1\u6838", ferrorText);
                }
                ferrorText = null;
                this.sql.setLength(0);
                this.sql.append(" Select distinct m.fnumber as fparentmaterialnumber,m.fname_l2 as fparentmaterialname,p.fnumber as fprojectnumber ");
                this.sql.append(" ,s.fname_l2 as forgname ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry b on a.fid = b.fparentid ");
                this.sql.append(" inner join t_org_storage s  on s.fid = a.fstorageorgunitid ");
                this.sql.append(" inner join t_bd_materialplan mp  on mp.fmaterialid = a.fmaterialid and mp.forgunit = a.fstorageorgunitid ");
                this.sql.append(" inner join t_bd_material m  on m.fid = a.fmaterialid ");
                this.sql.append(" left outer join t_mm_project p on p.fid = a.fprojectid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid = '" + this.projectInfo.getId().toString() + "') ");
                } else {
                    this.sql.append(" (a.fprojectid is null or a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and a.fdesignmodeid is not null ");
                this.sql.append(" and b.fconsumefixqty > 0 ");
                this.sql.append(" and (Isnull(mp.FManufactureStrategyID,'*') not in ('GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=') \r\n");
                this.sql.append(" or Isnull(mp.fisolatedrule,'NONE') not in ( 'ITEM','ITEM_TRACKNO') ) ");
                rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
                while (rs.next()) {
                    if (ferrorText == null) {
                        ferrorText = " \u4ee5\u4e0b\u5236\u9020BOM\u7236\u9879\u7269\u6599\u7f16\u7801\u7684\u9694\u79bb\u89c4\u5219\u8bbe\u7f6e\u4e3a\u975eETO20(ETO10)+\u6309\u9879\u76ee\u8ddf\u8e2a\u53f7(\u6309\u9879\u76ee\u53f7)\uff0c\u53ef\u80fd\u9020\u6210MRP\u8fd0\u7b97\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u8fdb\u884cBOM\u5c55\u5f00\uff0c\u8bf7\u786e\u8ba4\uff01 ";
                    }
                    ferrorText = ferrorText + "[" + rs.getString("fparentmaterialnumber") + "]" + rs.getString("fparentmaterialname") + " \u5e93\u5b58\u7ec4\u7ec7=" + rs.getString("forgname") + ",\u9879\u76ee\u53f7\u3010" + rs.getString("fprojectnumber") + "\u3011\r\n";
                }
                if (ferrorText == null) {
                    this.errorMap.put("\u5236\u9020BOM-\u7236\u9879\u7269\u6599\u5236\u9020\u7b56\u7565\u6821\u9a8c", this.successful);
                } else {
                    this.errorMap.put("\u5236\u9020BOM-\u7236\u9879\u7269\u6599\u5236\u9020\u7b56\u7565\u6821\u9a8c", ferrorText);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableNamList != null && tempTableNamList.size() > 0) {
                for (int i = 0; i < tempTableNamList.size(); ++i) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableNamList.get(i).toString());
                }
            }
        }
        return this.errorMap;
    }

    @Override
    protected Map _otherAnalysis(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.getParamMapData(ctx, paramMap);
        this.getMinMaxDate(ctx);
        this.errorMap = new HashMap();
        this.factorycalendar_analysis(ctx);
        return this.errorMap;
    }

    protected void bill_requirementBill(Context ctx) throws BOSException, EASBizException, SQLException {
        this.sql.setLength(0);
        this.sql.append(" SELECT h.fnumber as fbillnumber");
        this.sql.append(" ,d.FReceivedOrgUnitID as forgid ");
        this.sql.append(" ,mp.fmaterialattr as fmaterialattr");
        this.sql.append(" ,mp.fstatus as fmpstatus");
        this.sql.append(" ,d.FRequirementDate as fbilldate");
        this.sql.append(" ,mp.fplanningmode as fplanningmode");
        this.sql.append(" ,mp.fmanufacturestrategyid as fmanufacturestrategyid");
        this.sql.append(" ,mp.fisolatedrule as fisolatedrule");
        this.sql.append(" ,d.fmaterialid as fmaterialid");
        this.sql.append(" ,d.FProjectID as fprojectid");
        this.sql.append(" ,t.fnumber as ftrackNumber");
        this.sql.append(" ,RT.FDestinationType as FDestinationType");
        this.sql.append(" ,s.fname_l2 as forgname");
        this.sql.append(" ,m.fnumber as fmaterialname");
        this.sql.append(" from T_SM_PurRequirement h \r\n");
        this.sql.append(" left outer join T_SM_PurRequirementEntry d on h.fid = d.fparentid");
        this.sql.append(" left outer join T_SM_DemandType DT ON h.FDemandTypeID = DT.FID left outer JOIN T_SCM_RowType RT ON DT.FRowTypeID = RT.FID");
        this.sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = d.fmaterialid and mp.Forgunit = d.FReceivedOrgUnitID ");
        this.sql.append(" left outer join t_mm_tracknumber t on t.fid = d.FTrackNoID ");
        this.sql.append(" left outer join t_org_storage s on s.fid = d.FReceivedOrgUnitID ");
        this.sql.append(" left outer join t_bd_material m on m.fid = d.fmaterialid ");
        this.sql.append(" WHERE h.fbasestatus = ").append(4).append("");
        this.sql.append(" AND d.Fbasestatus  <> 7  ");
        this.sql.append(" AND d.fqty - isnull((Select sum(fcloseqty)  \r\n");
        this.sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
        this.sql.append(" where ir.findepentrequirebillentryid = d.fid \r\n");
        this.sql.append(" and ir.findepentrequirebilltype = ").append(4).append("),0)   > 0");
        this.sql.append(this.getPlanDefineRequireSetWhere_Required(this.planDefinedInfo));
        if (this.projectInfo != null) {
            this.sql.append("  AND (d.FProjectID = '" + this.projectInfo.getId().toString() + "' or d.FProjectID is null )");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        this.checkBillData(ctx, rs, "REQUIREMENTBILL");
    }

    protected String getPlanDefineRequireSetWhere_Required(PlanDefinedInfo pdInfo) {
        StringBuilder sql = new StringBuilder();
        Object fwhereStr = null;
        return sql.toString();
    }

    protected List getBomSupplyOrgUnitIDList(Context ctx, String fmaterialid, String fprojectid, String ftracknumber) throws BOSException, EASBizException, SQLException {
        ArrayList<String> orgIDList = new ArrayList<String>();
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        IRowSet rs = null;
        this.sql.setLength(0);
        if (bomtype.equals((Object)BOMTypeEnum.MfgBOM)) {
            this.sql.append(" Select distinct bom.fstorageorgunitid \r\n");
            this.sql.append(" from t_mm_bom bom inner join t_mm_bomentry bomd on bom.fid = bomd.fparentid \r\n");
            this.sql.append(" left outer join t_mm_tracknumber bt on bt.fid = bomd.fbegincarnoid \r\n");
            this.sql.append(" left outer join t_mm_tracknumber et on et.fid = bomd.fendcarnoid \r\n");
            this.sql.append(" where bom.fmaterialid = ? \r\n");
            this.sql.append(" and (bom.fprojectid is null or bom.fprojectid = ? ) \r\n");
            this.sql.append(" and (bomd.fbegincarnoid is null or bt.fnumber <= ? ) \r\n");
            this.sql.append(" and (bomd.fendcarnoid is null or et.fnumber >= ? ) \r\n");
            this.sql.append(" and bom.fbasestatus = 4 \r\n");
            this.sql.append(" and bomd.fconsumefixqty > 0 \r\n");
            this.sql.append(" and bom.fdesignmodeid is not null  \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])new Object[]{fmaterialid, fprojectid, ftracknumber, ftracknumber});
        } else {
            this.sql.append(" select distinct bom.cfstorageorgunitid as fstorageorgunitid from ct_zjb_processbombill bom \r\n");
            this.sql.append(" left outer join t_mm_tracknumber bt on bt.fid = bom.cfbegincarnoid \r\n");
            this.sql.append(" left outer join t_mm_tracknumber et on et.fid = bom.cfendcarnoid \r\n");
            this.sql.append(" where bom.cfparentid = ? \r\n");
            this.sql.append(" and (bom.cfprojectid is null or bom.cfprojectid = ? ) \r\n");
            this.sql.append(" and (bomd.cfbegincarnoid is null or bt.fnumber <= ? ) \r\n");
            this.sql.append(" and (bomd.cfendcarnoid is null or et.fnumber >= ? ) \r\n");
            this.sql.append(" and bom.cfstate = 4 \r\n");
            this.sql.append(" and bom.cfration > 0 \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])new Object[]{fmaterialid, fprojectid, ftracknumber, ftracknumber});
        }
        while (rs.next()) {
            orgIDList.add(rs.getString("fstorageorgunitid"));
        }
        return orgIDList;
    }

    protected void bill_PojectPurBill(Context ctx) throws BOSException, EASBizException, SQLException {
        this.sql.setLength(0);
        this.sql.append(" SELECT h.fnumber as fbillnumber");
        this.sql.append(" ,h.Cfplantime as fbilldate");
        this.sql.append(" ,h.Cfmaterialid as fmaterialid");
        this.sql.append(" ,h.Cfprojectnoid as fprojectid");
        this.sql.append(" ,t.fnumber as ftrackNumber");
        this.sql.append(" ,m.fnumber as fmaterialname");
        this.sql.append(" from CT_PUR_BOMPurRequest h \r\n");
        this.sql.append(" left outer join CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid");
        this.sql.append(" left outer join t_mm_tracknumber t on t.fid = d.Cftracknumberid ");
        this.sql.append(" left outer join t_bd_material m on m.fid = h.Cfmaterialid ");
        this.sql.append(" WHERE h.Cfbasestatus = ").append(4).append("");
        this.sql.append(" AND d.CFStatus  <> 7  ");
        this.sql.append(" AND h.CFPurchaseOrgID IN (");
        this.sql.append(" SELECT CFPurchaseOrgUnitI FROM CT_BAS_PurRDE WHERE FParentID='").append(this.planDefinedInfo.getPurchaseRelation().getId()).append("'");
        this.sql.append(" )  ");
        this.sql.append("  AND d.CFQty  - Isnull(d.Fcloseqty,0)   > 0 ");
        if (this.projectInfo != null) {
            this.sql.append("  AND h.Cfprojectnoid = '" + this.projectInfo.getId().toString() + "' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
        String ferrorText = null;
        String fRowerrorText = null;
        boolean hasError = false;
        int okcount = 0;
        String fstorageOrgUnitID = null;
        String fmaterialattr = null;
        String fmaterialid = null;
        String fprojectid = null;
        String ftrackNumber = null;
        Date fbilldate = null;
        String fplanningmode = null;
        String fmanufacturestrategyid = null;
        String fisolatedrule = null;
        Object fbomid = null;
        String fmaterialname = null;
        IRowSet rs2 = null;
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        while (rs.next()) {
            fRowerrorText = null;
            if (fRowerrorText == null) {
                fRowerrorText = "\u5355\u636e\u53f7[" + rs.getString("fbillnumber") + "]";
            }
            hasError = false;
            fmaterialid = rs.getString("fmaterialid");
            fprojectid = rs.getString("fprojectid");
            ftrackNumber = rs.getString("ftrackNumber");
            fbilldate = rs.getDate("fbilldate");
            fmaterialname = rs.getString("fmaterialname");
            if (!this.ProjectIDList.contains(fprojectid)) {
                this.ProjectIDList.add(fprojectid);
            }
            List orgIDList = this.getBomSupplyOrgUnitIDList(ctx, fmaterialid, fprojectid, ftrackNumber);
            ArrayList<String> neworgIDList = new ArrayList<String>();
            if (orgIDList == null || orgIDList.size() < 1) {
                hasError = true;
                fRowerrorText = fRowerrorText + ",\u7269\u6599+\u9879\u76ee+\u8ddf\u8e2a\u53f7\u4e0d\u5b58\u5728BOM(\u5305\u62ec\u914d\u7f6eBOM\u3001\u5de5\u827aBOM\u7b49).";
            } else {
                for (int j = 0; j < orgIDList.size(); ++j) {
                    if (!this.ProductOrgUnitList.contains(orgIDList.get(j).toString())) continue;
                    neworgIDList.add(orgIDList.get(j).toString());
                }
                if (neworgIDList.size() < 1) {
                    hasError = true;
                    fRowerrorText = fRowerrorText + ",\u7269\u6599+\u9879\u76ee+\u8ddf\u8e2a\u53f7\u5bf9\u5e94\u7684BOM\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4e8e\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u7684\u4f9b\u5e94\u5173\u7cfb\u7684\u751f\u4ea7\u7ec4\u7ec7\u8303\u56f4\u5185.";
                } else if (neworgIDList.size() > 1) {
                    hasError = true;
                    fRowerrorText = fRowerrorText + ",\u7269\u6599+\u9879\u76ee+\u8ddf\u8e2a\u53f7\u5bf9\u5e94\u7684BOM\u5305\u542b\u591a\u4e2a\u751f\u4ea7\u7ec4\u7ec7." + ((Object)neworgIDList).toString();
                } else {
                    fstorageOrgUnitID = neworgIDList.get(0).toString();
                    StorageOrgUnitInfo sinfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(fstorageOrgUnitID));
                    this.sql.setLength(0);
                    this.sql.append(" Select mp.fmaterialattr as fmaterialattr");
                    this.sql.append(" ,mp.fplanningmode as fplanningmode");
                    this.sql.append(" ,mp.fmanufacturestrategyid as fmanufacturestrategyid");
                    this.sql.append(" ,mp.fisolatedrule as fisolatedrule");
                    this.sql.append(" from t_bd_materialplan mp  ");
                    this.sql.append("  where mp.fmaterialid = ? and mp.forgunit = ? and mp.fstatus = 1  ");
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])new Object[]{fmaterialid, fstorageOrgUnitID});
                    if (rs2 == null || rs2.size() < 1) {
                        hasError = true;
                        fRowerrorText = fRowerrorText + ",\u7269\u6599\u5728\u5e93\u5b58\u7ec4\u7ec7[" + sinfo.getName() + "]\u7684\u8ba1\u5212\u9875\u7b7e\u672a\u6838\u51c6\u6216\u4e0d\u5b58\u5728.";
                    } else if (rs2.next()) {
                        fmaterialattr = rs2.getString("fmaterialattr");
                        fplanningmode = rs2.getString("fplanningmode");
                        fmanufacturestrategyid = rs2.getString("fmanufacturestrategyid");
                        fisolatedrule = rs2.getString("fisolatedrule");
                        if (fmaterialattr == null || !"10030".equals(fmaterialattr)) {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5728\u5e93\u5b58\u7ec4\u7ec7[" + sinfo.getName() + "]\u5bf9\u5e94\u7684\u7269\u6599\u5c5e\u6027\u4e0d\u662f\u81ea\u5236\u4ef6.";
                        }
                        if (fplanningmode == null || !"2".equals(fplanningmode) && !"3".equals(fplanningmode)) {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5728\u5e93\u5b58\u7ec4\u7ec7[" + sinfo.getName() + "]\u7684\u8ba1\u5212\u6a21\u5f0f\u4e0d\u662fMRP/MPS.";
                        }
                        if (fmanufacturestrategyid == null || fisolatedrule == null) {
                            hasError = true;
                            fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5728\u5e93\u5b58\u7ec4\u7ec7[" + sinfo.getName() + "]\u5bf9\u5e94\u7684\u5236\u9020\u7b56\u7565\u3001\u9694\u79bb\u89c4\u5219\u4e3a\u7a7a.";
                        } else {
                            fbomid = null;
                            if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(fmanufacturestrategyid) || "GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(fmanufacturestrategyid)) {
                                if (fisolatedrule.equals("NONE")) {
                                    hasError = true;
                                    fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u9875\u7b7e\u5728\u5e93\u5b58\u7ec4\u7ec7[" + sinfo.getName() + "]\u5236\u9020\u7b56\u7565\u4e3aETO20\u6216ETO10\u65f6,\u9694\u79bb\u89c4\u5219\u4e0d\u80fd\u662fNONE.";
                                }
                            } else {
                                hasError = true;
                                fRowerrorText = fRowerrorText + ",\u5236\u9020\u7b56\u7565\u4e0d\u662fETO10\u6216\u8005ETO20\uff0c\u4e14\u9694\u79bb\u89c4\u5219\u4e0d\u662f\u6309\u9879\u76ee\u6216\u8005\u6309\u9879\u76ee\u53f7+\u8ddf\u8e2a\u53f7\uff0c\u65e0\u6cd5\u8fdb\u884cBOM\u5c55\u5f00.";
                            }
                        }
                    }
                }
                if (this.sf.format(this.endDate).compareTo(this.sf.format(fbilldate)) < 0) {
                    hasError = true;
                    fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u8d85\u8fc7\u4e86\u8ba1\u5212\u5c55\u671b\u671f[" + this.sf.format(this.endDate) + "].";
                } else if (this.StartDate_Require != null && this.sf.format(this.StartDate_Require).compareTo(this.sf.format(fbilldate)) > 0) {
                    fRowerrorText = fRowerrorText + ",\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f[" + this.sf.format(fbilldate) + "]\u5c0f\u4e8e\u9700\u6c42\u62d6\u671f[" + this.sf.format(this.StartDate_Require) + "].";
                }
            }
            if (hasError) {
                ferrorText = ferrorText + fRowerrorText + "\r\n";
                continue;
            }
            ++okcount;
        }
        String checkTitle = "\u9879\u76ee\u91c7\u8d2d\u9700\u6c42-\u5f52\u6863\u90e8\u4ef6\u5355\u636e\u6821\u9a8c";
        if (ferrorText == null) {
            this.errorMap.put(checkTitle, this.successful);
        } else {
            this.errorMap.put(checkTitle, ferrorText + "; \u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u6570\u91cf=" + okcount);
        }
    }

    protected void getMaterialOrgUnitData(Context ctx, String materialOrgUnitTempTable, String getType) throws BOSException, EASBizException {
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        if (bomtype.equals((Object)BOMTypeEnum.ProcessBOM)) {
            this.sql.setLength(0);
            this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,FneedDisOrgUnitID,FprojectID)");
            this.sql.append(" Select distinct a.cfmaterialid,a.cfstorageorgunitid,a.cfmaterialproperty,1,a.cfprojectid ");
            this.sql.append(" from ct_zjb_processbombill a ");
            this.sql.append(" inner join T_MAT_EMMMaterialPlan mp on mp.fmaterialid = a.cfmaterialid and mp.fstorageorgunitid = a.cfstorageorgunitid  ");
            this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=a.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
            this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
            this.sql.append(" where  ");
            if (this.projectInfo != null) {
                this.sql.append(" (a.cfprojectid is null or a.cfprojectid = '" + this.projectInfo.getId().toString() + "') ");
            } else {
                this.sql.append(" (a.cfprojectid is null or a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ")) ");
            }
            this.sql.append(" and a.cfstate = 4 ");
            this.sql.append(" and a.cfration > 0 ");
            this.sql.append(" and a.cfdrawbillorgid <> a.cfstorageorgunitid  ");
            this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
            this.sql.append(" and a.cfmaterialproperty in(10030,10070,10090)  ");
            this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = a.cfstorageorgunitid ) ");
            this.sql.append(" And mp.fdistributionorgunitid is null ");
            DbUtil.execute((Context)ctx, (String)this.sql.toString());
            if (!getType.equals("onlyGetDisOrgUnit")) {
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct a.cfmaterialid,a.cfdrawbillorgid,a.cfmaterialproperty,a.cfprojectid ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.cfprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfstate = 4 And  a.cfmaterialid is not null  and a.cfdrawbillorgid is not  null ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = a.cfdrawbillorgid and b.FmaterialAttr = a.cfmaterialproperty  ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct a.cfparentid,a.cfstorageorgunitid,10030,a.cfprojectid ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.cfprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.cfstate = 4  and a.cfparentid is not null and a.cfstorageorgunitid is not null ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfparentid and b.FStorageOrgUnitID = a.cfstorageorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct a.cfmaterialid,mpEx.fdistributionorgunitid,10040,a.cfprojectid ");
                this.sql.append(" from ct_zjb_processbombill a ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=a.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left outer join  T_MAT_EMMMaterialPlan mpEx on mpEx.fmaterialid = a.cfmaterialid and mpEx.fstorageorgunitid = a.cfstorageorgunitid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.cfprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.cfprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.cfstate = 4 ");
                this.sql.append(" and a.cfration > 0 ");
                this.sql.append(" and a.cfdrawbillorgid <> a.cfstorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and a.cfmaterialproperty in(10030,10070,10090)  ");
                this.sql.append(" and mpEx.fdistributionorgunitid is not null  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.cfmaterialid and b.FStorageOrgUnitID = mpEx.fdistributionorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
            }
        } else if (bomtype.equals((Object)BOMTypeEnum.MfgBOM)) {
            this.sql.setLength(0);
            this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,FneedDisOrgUnitID,fprojectid)");
            this.sql.append(" Select distinct d.fmaterialid,a.fstorageorgunitid,d.fmaterialprop,1 ,a.fprojectid");
            this.sql.append(" from t_mm_bom a ");
            this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
            this.sql.append(" left outer join T_MAT_EMMMaterialPlan mp on mp.fmaterialid = d.fmaterialid and mp.fstorageorgunitid = a.fstorageorgunitid  ");
            this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=d.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
            this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.fstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
            this.sql.append(" where  ");
            if (this.projectInfo != null) {
                this.sql.append(" a.fprojectid = '" + this.projectInfo.getId().toString() + "' ");
            } else {
                this.sql.append(" a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
            }
            this.sql.append(" and a.fbasestatus = 4 ");
            this.sql.append(" and d.fconsumefixqty > 0 ");
            this.sql.append(" and a.fstorageorgunitid <> d.fsupplystorageorgunitid  ");
            this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
            this.sql.append(" and d.fmaterialprop in(10030,10070,10090)  ");
            this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = a.FStorageOrgUnitID ) ");
            this.sql.append(" And mp.fdistributionorgunitid is null ");
            DbUtil.execute((Context)ctx, (String)this.sql.toString());
            if (!getType.equals("onlyGetDisOrgUnit")) {
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct d.fmaterialid,d.fsupplystorageorgunitid,d.fmaterialprop,a.fprojectid ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.fprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and d.fconsumefixqty > 0 ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = d.fsupplystorageorgunitid and b.FmaterialAttr = d.fmaterialprop  ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct a.fmaterialid,a.fstorageorgunitid,10030,a.fprojectid");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.fprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = a.fmaterialid and b.FStorageOrgUnitID = a.fstorageorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                this.sql.setLength(0);
                this.sql.append(" Insert Into ").append(materialOrgUnitTempTable).append("(FMATERIALID,FStorageOrgUnitID,FmaterialAttr,fprojectid)");
                this.sql.append(" Select distinct d.fmaterialid,mpEx.fdistributionorgunitid,10040,a.fprojectid ");
                this.sql.append(" from t_mm_bom a ");
                this.sql.append(" inner join t_mm_bomentry d on a.fid = d.fparentid ");
                this.sql.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=d.fsupplystorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=a.fstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                this.sql.append(" left outer join  T_MAT_EMMMaterialPlan mpEx on mpEx.fmaterialid = d.fmaterialid and mpEx.Fstorageorgunitid = a.fstorageorgunitid ");
                this.sql.append(" where  ");
                if (this.projectInfo != null) {
                    this.sql.append(" a.fprojectid = '" + this.projectInfo.getId().toString() + "' ");
                } else {
                    this.sql.append(" a.fprojectid in (" + SQLUtil.arrayToString((Object[])this.ProjectIDList.toArray()) + ") ");
                }
                this.sql.append(" and a.fbasestatus = 4 ");
                this.sql.append(" and d.fconsumefixqty > 0 ");
                this.sql.append(" and a.fstorageorgunitid <> d.fsupplystorageorgunitid  ");
                this.sql.append(" and isnull(r0.FToUnitID,'*')  <> isnull(r1.FToUnitID,'*')   ");
                this.sql.append(" and d.fmaterialprop in(10030)  ");
                this.sql.append(" and mpEx.fdistributionorgunitid is not null  ");
                this.sql.append(" And Not Exists(Select 1 from ").append(materialOrgUnitTempTable).append(" b where b.FMATERIALID = d.fmaterialid and b.FStorageOrgUnitID = mpEx.fdistributionorgunitid ) ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
            }
        }
    }

    protected String getMaterialAttrCHN(Context ctx, String materialAttrCol) {
        String sql = null;
        sql = " (case " + materialAttrCol + " when 10020 then '\u865a\u62df\u4ef6' when 10030 then '\u81ea\u5236\u4ef6' when 10040 then '\u5916\u8d2d\u4ef6' when 10050 then '\u59d4\u5916\u4ef6' when 10070 then '\u5382\u5185\u76f4\u6d41\u4ef6' when 10080 then '\u5382\u5916\u76f4\u6d41\u4ef6' when 10090 then '\u76f4\u6d41\u4ef6' else '\u5176\u4ed6' end)  ";
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchGet_NoPlanInv(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, IRowSet> returnMap = new HashMap<String, IRowSet>();
        this.getParamMapData(ctx, paramMap);
        ArrayList<String> tempTableNamList = new ArrayList<String>();
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        try {
            String materialOrgUnitTempTable = this.createMaterialOrgUnitTempTable(ctx);
            tempTableNamList.add(materialOrgUnitTempTable);
            this.getMaterialOrgUnitData(ctx, materialOrgUnitTempTable, "All");
            this.sql.setLength(0);
            this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
            this.sql.append(" ,m.fname_l2 as fmaterialname ");
            this.sql.append(" ,m.fid as fmaterialid ");
            this.sql.append(" ,m.fmodel as fmodel ");
            this.sql.append(" ,s.fname_l2 as forgname ");
            this.sql.append(" ,s.fid as forgunitid ");
            this.sql.append(" ,s.fnumber as forgnumber ");
            this.sql.append(" ,p.fnumber as fprojectnumber ");
            this.sql.append(" ,p.fname_l2 as fprojectname ");
            this.sql.append(" ,a.FmaterialAttr as fmaterialattr ");
            this.sql.append(" ,").append(1).append(" as fexceptionType ");
            this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
            this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
            this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
            this.sql.append(" left outer join t_mm_project p on p.fid = a.FprojectID ");
            this.sql.append(" Where Not Exists(Select 1 from t_bd_materialplan mp where mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID  ) ");
            this.sql.append(" union ");
            this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
            this.sql.append(" ,m.fname_l2 as fmaterialname ");
            this.sql.append(" ,m.fid as fmaterialid ");
            this.sql.append(" ,m.fmodel as fmodel ");
            this.sql.append(" ,s.fname_l2 as forgname ");
            this.sql.append(" ,s.fid as forgunitid ");
            this.sql.append(" ,s.fnumber as forgnumber ");
            this.sql.append(" ,p.fnumber as fprojectnumber ");
            this.sql.append(" ,p.fname_l2 as fprojectname ");
            this.sql.append(" ,a.FmaterialAttr as fmaterialattr ");
            this.sql.append(" ,").append(2).append(" as fexceptionType ");
            this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
            this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
            this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
            this.sql.append(" left outer join t_mm_project p on p.fid = a.FprojectID ");
            this.sql.append(" Where Not Exists(Select 1 from t_bd_materialinventory mi where mi.fmaterialid = a.FMATERIALID and mi.forgunit = a.FStorageOrgUnitID ) ");
            this.sql.append(" union ");
            this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
            this.sql.append(" ,m.fname_l2 as fmaterialname ");
            this.sql.append(" ,m.fid as fmaterialid ");
            this.sql.append(" ,m.fmodel as fmodel ");
            this.sql.append(" ,s.fname_l2 as forgname ");
            this.sql.append(" ,s.fid as forgunitid ");
            this.sql.append(" ,s.fnumber as forgnumber ");
            this.sql.append(" ,p.fnumber as fprojectnumber ");
            this.sql.append(" ,p.fname_l2 as fprojectname ");
            this.sql.append(" ,a.FmaterialAttr as fmaterialattr ");
            this.sql.append(" ,").append(4).append(" as fexceptionType ");
            this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
            this.sql.append(" Inner Join t_bd_materialplan mp on mp.fmaterialid = a.FMATERIALID and mp.forgunit = a.FStorageOrgUnitID  ");
            this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
            this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
            this.sql.append(" left outer join t_mm_project p on p.fid = a.FprojectID ");
            this.sql.append(" Where mp.fstatus <> 1  ");
            this.sql.append(" union ");
            this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
            this.sql.append(" ,m.fname_l2 as fmaterialname ");
            this.sql.append(" ,m.fid as fmaterialid ");
            this.sql.append(" ,m.fmodel as fmodel ");
            this.sql.append(" ,s.fname_l2 as forgname ");
            this.sql.append(" ,s.fid as forgunitid ");
            this.sql.append(" ,s.fnumber as forgnumber ");
            this.sql.append(" ,p.fnumber as fprojectnumber ");
            this.sql.append(" ,p.fname_l2 as fprojectname ");
            this.sql.append(" ,a.FmaterialAttr as fmaterialattr ");
            this.sql.append(" ,").append(3).append(" as fexceptionType ");
            this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
            this.sql.append(" Inner Join t_bd_materialinventory mi on mi.fmaterialid = a.FMATERIALID and mi.forgunit = a.FStorageOrgUnitID   ");
            this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
            this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
            this.sql.append(" left outer join t_mm_project p on p.fid = a.FprojectID ");
            this.sql.append(" Where mi.fstatus <> 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
            returnMap.put("returnRS", rs);
        }
        finally {
            if (tempTableNamList != null && tempTableNamList.size() > 0) {
                for (int i = 0; i < tempTableNamList.size(); ++i) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableNamList.get(i).toString());
                }
            }
        }
        return returnMap;
    }

    @Override
    protected void _batchDeal_NoPlanInv(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if (paramMap == null) {
            return;
        }
        if (paramMap.get("dataList") == null) {
            return;
        }
        ArrayList dataList = (ArrayList)paramMap.get("dataList");
        if (dataList == null || dataList.size() < 1) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        ArrayList<String> sqls = new ArrayList<String>();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        for (int i = 0; i < dataList.size(); ++i) {
            MaterialInfo materialInfo;
            HashMap dataMap = (HashMap)dataList.get(i);
            String fmaterialid = dataMap.get("materialid").toString();
            String storageOrgunitid = dataMap.get("storageOrgunitid").toString();
            PMRPCheckChildExceptionTypeEnum pmrpCheckChildExceptionTypeEnum = (PMRPCheckChildExceptionTypeEnum)((Object)dataMap.get("exceptionType"));
            MaterialAttributeEnum materialAttributeEnum = (MaterialAttributeEnum)dataMap.get("materialattr");
            if (pmrpCheckChildExceptionTypeEnum.equals((Object)PMRPCheckChildExceptionTypeEnum.NO_INV)) {
                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(fmaterialid), sic);
                BomUtil.addMaterialInventory((Context)ctx, (MaterialInfo)materialInfo, (Integer)materialAttributeEnum.getValue(), (String)storageOrgunitid);
                this.updateMaterialInventoryProp(ctx, fmaterialid, storageOrgunitid);
                continue;
            }
            if (pmrpCheckChildExceptionTypeEnum.equals((Object)PMRPCheckChildExceptionTypeEnum.NO_PLAN)) {
                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(fmaterialid), sic);
                BomUtil.addMaterialPlan((Context)ctx, (MaterialInfo)materialInfo, (Integer)materialAttributeEnum.getValue(), (String)storageOrgunitid, (String)storageOrgunitid);
                this.updateMaterialPlanProp(ctx, fmaterialid, storageOrgunitid, paramMap);
                continue;
            }
            if (pmrpCheckChildExceptionTypeEnum.equals((Object)PMRPCheckChildExceptionTypeEnum.INV_NO_STATUS)) {
                this.sql.setLength(0);
                this.sql.append(" update t_bd_materialinventory set fstatus = 1,flastupdateuserid = '" + userInfo.getId() + "',flastupdatetime = sysdate where fmaterialid = '" + fmaterialid + "' and forgunit = '" + storageOrgunitid + "' ");
                sqls.add(this.sql.toString());
                continue;
            }
            if (!pmrpCheckChildExceptionTypeEnum.equals((Object)PMRPCheckChildExceptionTypeEnum.PLAN_NO_STATUS)) continue;
            this.sql.setLength(0);
            this.sql.append(" update t_bd_materialplan set fstatus = 1,flastupdateuserid = '" + userInfo.getId() + "',flastupdatetime = sysdate where fmaterialid = '" + fmaterialid + "' and forgunit = '" + storageOrgunitid + "' ");
            sqls.add(this.sql.toString());
        }
        if (sqls != null && sqls.size() > 0) {
            DBUtil.execBatchSql((Context)ctx, sqls, (boolean)true);
        }
    }

    protected void updateMaterialPlanProp(Context ctx, String fmaterialid, String forgunitid, Map paramMap) throws BOSException, EASBizException {
        PlanningModeEnum planningModeEnum = null;
        ManufactureStrategyInfo manufactureStrategyInfo = null;
        IsolatedRuleEnum isolatedRuleEnum = null;
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (paramMap.get("planningModeEnum") == null) {
            return;
        }
        planningModeEnum = (PlanningModeEnum)paramMap.get("planningModeEnum");
        paramList.add(planningModeEnum.getValue());
        if (paramMap.get("manufactureStrategy") != null) {
            manufactureStrategyInfo = (ManufactureStrategyInfo)paramMap.get("manufactureStrategy");
            paramList.add(manufactureStrategyInfo.getId().toString());
        } else {
            paramList.add(null);
        }
        if (paramMap.get("isolatedRuleEnum") != null) {
            isolatedRuleEnum = (IsolatedRuleEnum)paramMap.get("isolatedRuleEnum");
            paramList.add(isolatedRuleEnum.getValue());
        } else {
            paramList.add(null);
        }
        paramList.add(fmaterialid);
        paramList.add(forgunitid);
        this.sql.setLength(0);
        this.sql.append(" update t_bd_materialplan set  ");
        this.sql.append(" fplanningmode = ?  ");
        this.sql.append(" ,fmanufacturestrategyid = ?  ");
        this.sql.append(" ,fisolatedrule = ?  ");
        this.sql.append(" where fmaterialid = ? and forgunit =  ? ");
        DbUtil.execute((Context)ctx, (String)this.sql.toString(), (Object[])paramList.toArray());
        paramList = new ArrayList();
        this.getIsProjectTrackNumber(ctx, manufactureStrategyInfo, isolatedRuleEnum, paramList);
        paramList.add(fmaterialid);
        paramList.add(forgunitid);
        this.sql.setLength(0);
        this.sql.append(" update t_bd_materialinventory set  ");
        this.sql.append(" fisprojectnumber = ?  ");
        this.sql.append(" ,fistrackingnumber = ?  ");
        this.sql.append(" where fmaterialid = ? and forgunit =  ? ");
        DbUtil.execute((Context)ctx, (String)this.sql.toString(), (Object[])paramList.toArray());
    }

    protected void getIsProjectTrackNumber(Context ctx, ManufactureStrategyInfo manufactureStrategyInfo, IsolatedRuleEnum isolatedRuleEnum, List<Object> paramList) {
        if (manufactureStrategyInfo != null && manufactureStrategyInfo.getId().toString().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            if (isolatedRuleEnum != null && (isolatedRuleEnum.equals((Object)IsolatedRuleEnum.ITEM) || isolatedRuleEnum.equals((Object)IsolatedRuleEnum.ITEM_TRACKNO))) {
                paramList.add(1);
                if (isolatedRuleEnum != null && isolatedRuleEnum.equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                    paramList.add(1);
                } else {
                    paramList.add(0);
                }
            } else {
                paramList.add(0);
                paramList.add(0);
            }
        } else {
            paramList.add(0);
            paramList.add(0);
        }
    }

    protected void updateMaterialInventoryProp(Context ctx, String fmaterialid, String forgunitid) throws BOSException, EASBizException {
        this.sql.setLength(0);
        this.sql.append(" Select fmanufacturestrategyid,fisolatedrule from  t_bd_materialplan   ");
        this.sql.append(" where fmaterialid = ? and forgunit =  ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString(), (Object[])new Object[]{fmaterialid, forgunitid});
        try {
            if (rs.next()) {
                String fmanufacturestrategyid = rs.getString("fmanufacturestrategyid");
                String fisolatedrule = rs.getString("fisolatedrule");
                ArrayList<Object> paramList = new ArrayList<Object>();
                ManufactureStrategyInfo manufactureStrategyInfo = null;
                IsolatedRuleEnum isolatedRuleEnum = null;
                if (fmanufacturestrategyid != null && !"".equals(fmanufacturestrategyid)) {
                    manufactureStrategyInfo = new ManufactureStrategyInfo();
                    manufactureStrategyInfo.setId(BOSUuid.read((String)fmanufacturestrategyid));
                }
                if (fisolatedrule != null && !"".equals(fisolatedrule)) {
                    isolatedRuleEnum = IsolatedRuleEnum.getEnum((String)fisolatedrule);
                }
                this.getIsProjectTrackNumber(ctx, manufactureStrategyInfo, isolatedRuleEnum, paramList);
                paramList.add(fmaterialid);
                paramList.add(forgunitid);
                this.sql.setLength(0);
                this.sql.append(" update t_bd_materialinventory set  ");
                this.sql.append(" fisprojectnumber = ?  ");
                this.sql.append(" ,fistrackingnumber = ?  ");
                this.sql.append(" where fmaterialid = ? and forgunit =  ? ");
                DbUtil.execute((Context)ctx, (String)this.sql.toString(), (Object[])paramList.toArray());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchGet_PlanNoDisOrgUnit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, IRowSet> returnMap = new HashMap<String, IRowSet>();
        this.getParamMapData(ctx, paramMap);
        ArrayList<String> tempTableNamList = new ArrayList<String>();
        BOMTypeEnum bomtype = this.planDefinedInfo.getBomType();
        try {
            String materialOrgUnitTempTable = this.createMaterialOrgUnitTempTable(ctx);
            tempTableNamList.add(materialOrgUnitTempTable);
            this.getMaterialOrgUnitData(ctx, materialOrgUnitTempTable, "onlyGetDisOrgUnit");
            this.sql.setLength(0);
            this.sql.append(" Select distinct m.fnumber as fmaterialnumber ");
            this.sql.append(" ,m.fname_l2 as fmaterialname ");
            this.sql.append(" ,m.fid as fmaterialid ");
            this.sql.append(" ,m.fmodel as fmodel ");
            this.sql.append(" ,s.fname_l2 as forgname ");
            this.sql.append(" ,s.fid as forgunitid ");
            this.sql.append(" ,s.fnumber as forgnumber ");
            this.sql.append(" ,p.fnumber as fprojectnumber ");
            this.sql.append(" ,p.fname_l2 as fprojectname ");
            this.sql.append(" ,a.FmaterialAttr as fmaterialattr ");
            this.sql.append(" ,").append(5).append(" as fexceptionType ");
            this.sql.append(" From  ").append(materialOrgUnitTempTable).append(" a ");
            this.sql.append(" left outer join t_bd_material m on m.fid = a.FMATERIALID ");
            this.sql.append(" left outer join t_org_storage s on s.fid = a.FStorageOrgUnitID ");
            this.sql.append(" left outer join t_mm_project p on p.fid = a.FprojectID ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
            returnMap.put("returnRS", rs);
        }
        finally {
            if (tempTableNamList != null && tempTableNamList.size() > 0) {
                for (int i = 0; i < tempTableNamList.size(); ++i) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableNamList.get(i).toString());
                }
            }
        }
        return returnMap;
    }

    @Override
    protected void _batchDeal_PlanNoDisOrgUnit(Context ctx, List dataList, String disOrgUnitID) throws BOSException, EASBizException {
        if (dataList == null || dataList.size() < 1) {
            return;
        }
        if (disOrgUnitID == null || "".equals(disOrgUnitID)) {
            return;
        }
        ArrayList<String> sqls = new ArrayList<String>();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        for (int i = 0; i < dataList.size(); ++i) {
            HashMap dataMap = (HashMap)dataList.get(i);
            String fmaterialid = dataMap.get("materialid").toString();
            String storageOrgunitid = dataMap.get("storageOrgunitid").toString();
            PMRPCheckChildExceptionTypeEnum pmrpCheckChildExceptionTypeEnum = (PMRPCheckChildExceptionTypeEnum)((Object)dataMap.get("exceptionType"));
            MaterialAttributeEnum materialAttributeEnum = (MaterialAttributeEnum)dataMap.get("materialattr");
            if (!pmrpCheckChildExceptionTypeEnum.equals((Object)PMRPCheckChildExceptionTypeEnum.PLAN_NO_DISORGUNIT)) continue;
            this.sql.setLength(0);
            this.sql.append(" select 1 FROM t_mat_emmmaterialplan WHERE fstorageorgunitid = '");
            this.sql.append(storageOrgunitid).append("' AND fmaterialid = '");
            this.sql.append(fmaterialid).append("'");
            StringBuffer val = new StringBuffer();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.sql.toString());
            if (rs.size() == 0) {
                this.sql.setLength(0);
                val.setLength(0);
                this.sql.append("insert into t_mat_emmmaterialplan(");
                val.append("values(");
                this.sql.append("FID,");
                val.append("newbosid('D1C4EC46'),");
                this.sql.append("fmaterialid,");
                val.append("'" + fmaterialid + "',");
                this.sql.append("fstorageorgunitid,");
                val.append("'" + storageOrgunitid.toString() + "',");
                this.sql.append("FDISTRIBUTIONORGUNITID,");
                val.append("'" + disOrgUnitID + "',");
                this.sql.append("FBASESTATUS,");
                val.append("").append(1).append(",");
                this.sql.append("fcreatorid,");
                val.append("'" + userInfo.getId() + "',");
                this.sql.append("FLastUpdateUserID,");
                val.append("'" + userInfo.getId() + "',");
                this.sql.append("FCONTROLUNITID,");
                val.append("'" + userInfo.getCU().getId().toString() + "',");
                this.sql.append("FDESCRIPTION_L2,");
                val.append("'MRP\u8fd0\u7b97\u68c0\u67e5\u4ea7\u751f',");
                this.sql.append("fcreatetime)");
                val.append("sysdate)");
                this.sql.append(val);
                DbUtil.execute((Context)ctx, (String)this.sql.toString());
                continue;
            }
            this.sql.setLength(0);
            this.sql.append(" update T_MAT_EMMMaterialPlan set FBASESTATUS = 1,fdistributionorgunitid = '" + disOrgUnitID + "',flastupdateuserid = '" + userInfo.getId() + "',flastupdatetime = sysdate where fmaterialid = '" + fmaterialid + "' and Fstorageorgunitid = '" + storageOrgunitid + "' ");
            sqls.add(this.sql.toString());
        }
        if (sqls != null && sqls.size() > 0) {
            DBUtil.execBatchSql((Context)ctx, sqls, (boolean)true);
        }
    }
}

