/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryInfo;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeInfo;
import com.kingdee.eas.emm.mo.IEMMManufactureOrderChange;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.mm.basedata.OperationScheduleUtils;
import com.kingdee.eas.industry.emm.project.biz.mrp.IPMRPPlannedOrder;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderChangeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderChangeInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.AbstractPMRPPlannedOrderMappingFacadeControllerBean;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.runner.IPlannedOrderReleaseRunner;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.runner.impl.DefaultPOReleaseRunner;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.MaterialRootingInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PMRPPlannedOrderMappingFacadeControllerBean
extends AbstractPMRPPlannedOrderMappingFacadeControllerBean {
    private static final long serialVersionUID = -7987130903843223084L;
    private String Resource_Name = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    private String resClassName = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    public Map<String, String> fcOrgMap = null;

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    protected Map _getCouOrgUnit(Context ctx, String[] orgUnitID) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        if (orgUnitID == null || orgUnitID.length == 0) {
            return map;
        }
        sql.append("select orgRe.FFromUnitID ,orgRe.FTOUnitID from T_ORG_UnitRelation orgRe where orgRe.FFromUnitID in (");
        for (int i = 0; i < orgUnitID.length; ++i) {
            sql.append("'");
            sql.append(orgUnitID[i]);
            if (i != orgUnitID.length - 1) {
                sql.append("' , ");
                continue;
            }
            sql.append("' )");
        }
        sql.append("  and orgRe.ftyperelationid='");
        sql.append("00000000-0000-0000-0000-0000000000070FE9F8B5");
        sql.append("'  ");
        try {
            rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.eas.scm.common.tools.SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        com.kingdee.eas.scm.common.tools.SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    protected SelectorItemCollection getPlanOderSelectorForRelease() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scheme.*"));
        sic.add(new SelectorItemInfo("material.Number"));
        sic.add(new SelectorItemInfo("material.Name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.Number"));
        sic.add(new SelectorItemInfo("unit.Name"));
        sic.add(new SelectorItemInfo("productUnit.id"));
        sic.add(new SelectorItemInfo("productUnit.Number"));
        sic.add(new SelectorItemInfo("productUnit.Name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.Number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.Name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("productionOrgUnit.Number"));
        sic.add(new SelectorItemInfo("productionOrgUnit.Name"));
        sic.add(new SelectorItemInfo("productionOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.*"));
        return sic;
    }

    @Override
    protected Map<String, Object> _mapping(Context ctx, BOSUuid botpRuleId, Map[] plannedOrders, String runnerClassName) throws BOSException, EASBizException {
        IPlannedOrderReleaseRunner runner;
        if (botpRuleId == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_BOTPID_NULL")));
        }
        if (plannedOrders == null || plannedOrders.length < 1) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_JHDD_NULL")));
        }
        try {
            String orgUnitID = String.valueOf(plannedOrders[0].get("storageOrgUnit.id"));
            boolean check = true;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FValue_L2 FROM T_BAS_PARAMITEM WHERE FKEYID IN (SELECT FID FROM T_BAS_PARAM WHERE FNUMBER='PMRPPOReleaseStrategy') AND FORGUNITID='" + orgUnitID + "'"));
            if (rs != null && rs.size() > 0 && rs.next()) {
                boolean bl = check = Boolean.valueOf(rs.getString("FValue_L2")) == false;
            }
            if (check) {
                this.checkBeforeRelease(ctx, plannedOrders);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtil.isEmptyString((String)runnerClassName)) {
            runnerClassName = DefaultPOReleaseRunner.class.getName();
        }
        try {
            runner = (IPlannedOrderReleaseRunner)Class.forName(runnerClassName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return runner.release(ctx, botpRuleId, plannedOrders);
    }

    private void checkBeforeRelease(Context ctx, Map[] plannedOrders) throws EASBizException, SQLException, BOSException {
        StringBuilder idFilter = new StringBuilder();
        idFilter.append("'").append(plannedOrders[0].get("BillID")).append("'");
        for (int i = 1; i < plannedOrders.length; ++i) {
            Map map = plannedOrders[i];
            String id = String.valueOf(map.get("BillID"));
            idFilter.append(",'").append(id).append("'");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct pd.FNumber pdNumber,rl.FMrpCalcDetailTbl FMrpCalcDetailTbl FROM T_MRP_PMRPRunLog rl");
        sql.append(" INNER JOIN CT_BAS_PlanDefined pd ON rl.FPLanDefinedID=pd.FID ");
        sql.append(" WHERE rl.fpercent = 100  and  NOT EXISTS(SELECT 1 FROM T_MRP_PMRPRunLog rl2 WHERE rl2.fpercent = 100 and rl2.fplandefinedid=rl.fplandefinedid and rl2.fcreatetime > rl.fcreatetime)");
        sql.append(" AND rl.FMrpCalcDetailTbl IS NOT NULL");
        sql.append(" AND Exists (Select 1 From KSQL_USERTABLES Where KSQL_TABNAME = rl.FMrpCalcDetailTbl) ");
        sql.append(" AND Exists (Select 1 From t_mrp_pmrpplannedorder p Where p.fid in (").append((CharSequence)idFilter).append(") and p.fschemeid = rl.fplandefinedid ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuilder errorMsg = new StringBuilder();
        while (rs.next()) {
            String content = this.checkPlannedOrder(ctx, rs.getString("pdNumber"), rs.getString("FMrpCalcDetailTbl"), idFilter.toString());
            if (content == null) continue;
            if (errorMsg.length() == 0) {
                errorMsg.append(this.getResourceString(ctx, this.resClassName, "PROJECT_CZWCLJHJYXX"));
            }
            errorMsg.append(content).append("\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errorMsg.toString()));
        }
    }

    private String checkPlannedOrder(Context ctx, String pdNumber, String detailTbl, String idFilter) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FNumber FROM T_MRP_PMRPPlannedOrder WHERE FID IN (").append(idFilter).append(")");
        sql.append(" AND FID IN (");
        sql.append("SELECT distinct FBillID FROM ").append(detailTbl).append(" detail WHERE detail.FAjustFlag in (2, 3, 4) and FISProcessed=0");
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (!rs.next()) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        ret.append(this.getResourceString(ctx, this.resClassName, "PROJECT_JHFA")).append(pdNumber).append("):\r\n");
        ret.append("").append(rs.getString("FNumber"));
        do {
            ret.append("\r\n").append(rs.getString("FNumber"));
        } while (rs.next());
        return ret.toString();
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID, String mainOrgKey) throws EASBizException, BOSException {
        AutoNumberUtil.initNumber((Context)ctx, (IObjectValue)billInfo, (String)mainOrgKey);
    }

    protected void operationpSchedul(Context ctx, ManufactureOrderInfo info) throws BOSException, EASBizException {
        StandardRootingInfo routingInfo;
        info.getTechnics().clear();
        StandardRootingInfo stdInfo = info.getRouting();
        if (stdInfo == null) {
            return;
        }
        MaterialRootingInfo materialRootingInfo = stdInfo.getMaterialRooting();
        if (materialRootingInfo == null) {
            return;
        }
        HashMap<String, Object> inData = new HashMap<String, Object>();
        if (info.getBomID() != null) {
            BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(info.getBomID()));
            inData.put("BOM", bomInfo);
        }
        if ((routingInfo = info.getRouting()) != null) {
            inData.put("ROUTINGID", routingInfo.getId().toString());
        }
        inData.put("STORAGEORG", info.getStorageOrgUnit());
        inData.put("TRANSTYPE", info.getTransactionType());
        inData.put("MATERIAL", info.getMaterial());
        inData.put("BEGINTIME", info.getPlanBeginDate());
        inData.put("ENDTIME", info.getPlanEndDate());
        inData.put("BILL_UNIT", info.getUnit());
        inData.put("BASEUNIT", info.getUnit());
        inData.put("BILL_QTY", info.getQty());
        inData.put("SPLIT_QTY", info.getTotalSplitQty());
        inData.put("projectID", info.getProject());
        inData.put("trackID", info.getTrackNumber());
        inData.put("LOTNUMBER", info.getLot());
        inData.put("adminOrgUnit", info.getAdminOrgUnit());
        inData.put("IsRoutingChange", new Boolean(true));
        inData.put("isReplaced", false);
        Map retData = ManufactureOrderFactory.getLocalInstance((Context)ctx).getRoutingData(inData);
        if (retData.get("TECHNICS") != null) {
            info.put("technics", retData.get("TECHNICS"));
        }
        if (retData.get("STOCKS") != null) {
            ManufactureOrderStockCollection stockCol = (ManufactureOrderStockCollection)retData.get("STOCKS");
            info.put("stocks", (Object)stockCol);
        }
        if (retData.get("EXPECTOUTPUTS") != null) {
            ManufactureOrderExpectOutputCollection expectOutputs = (ManufactureOrderExpectOutputCollection)retData.get("EXPECTOUTPUTS");
            info.put("expectOutputs", (Object)expectOutputs);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("scheduleType", info.getTransactionType().getScheduleType());
        param.put("orderInfo", info);
        Map result = ManufactureOrderFactory.getLocalInstance((Context)ctx).operationpSchedul(param);
        if (result.get("result") != null) {
            if (result.get("result").toString().equals("0")) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_SCSWLX") + info.getTransactionType().getNumber() + " " + info.getTransactionType().getName() + this.getResourceString(ctx, this.resClassName, "PROJECT_WKHZBPC")));
            }
            if (result.get("result").toString().equals("-2")) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_KCZZ") + info.getStorageOrgUnit().getNumber() + " " + info.getStorageOrgUnit().getName() + this.getResourceString(ctx, this.resClassName, "PROJECT_MYWHGZRL")));
            }
            if (result.get("result").toString().equals("-1")) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_KCZZ") + info.getStorageOrgUnit().getNumber() + " " + info.getStorageOrgUnit().getName() + this.getResourceString(ctx, this.resClassName, "PROJECT_QWHGZZXBZ")));
            }
            if (result.get("result").toString().equals("1")) {
                info = (ManufactureOrderInfo)result.get("orderInfo");
            }
        }
    }

    @Override
    protected Map _dealMRPException(Context ctx, Map[] detailDataMappings) throws BOSException, EASBizException {
        if (detailDataMappings == null || detailDataMappings.length < 1) {
            return null;
        }
        HashMap returnMap = new HashMap();
        StringBuffer sql = new StringBuffer();
        if (detailDataMappings == null || detailDataMappings.length < 1) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYXXWK")));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        String FResetDateStr = null;
        BigDecimal FResetQty = new BigDecimal(0);
        String fdetailID = null;
        String fCaldetailtableName = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date FResetDate = null;
        String FProcessedRemark = null;
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp now = new Timestamp(new Date().getTime());
        FProcessedRemark = this.getResourceString(ctx, this.resClassName, "PROJECT_YCCLCG") + curUserInfo.getName() + sdf.format(now);
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < detailDataMappings.length; ++i) {
            HashMap dataMap = (HashMap)detailDataMappings[i];
            if (dataMap.get("FDetailID") == null || dataMap.get("CalDetialtable") == null) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0013")));
            }
            fdetailID = dataMap.get("FDetailID").toString();
            fCaldetailtableName = dataMap.get("CalDetialtable").toString();
            sql.setLength(0);
            sql.append("SELECT FIsProcessed FROM ").append(fCaldetailtableName).append(" WHERE FID='").append(fdetailID).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next() && rs.getInt("FIsProcessed") != 0) {
                    throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0014")));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (dataMap.get("AjustType") == null) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0015")));
            }
            int FAdjustType = Integer.parseInt(dataMap.get("AjustType").toString());
            if (FAdjustType != 2 && FAdjustType != 3 && FAdjustType != 4) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0016")));
            }
            FResetQty = dataMap.get("FResetQty") != null ? new BigDecimal(dataMap.get("FResetQty").toString()) : BigDecimal.ZERO;
            FResetDate = null;
            FResetDateStr = null;
            if (dataMap.get("FResetDate") != null) {
                FResetDate = (Date)dataMap.get("FResetDate");
                FResetDateStr = sdf.format(FResetDate);
            }
            String fbillid = null;
            String fbillEntryid = null;
            int fmrpItemEnum = 0;
            Map detialMap = this.getDetialValue(ctx, fCaldetailtableName, fdetailID);
            if (detialMap.get("FIsProcessed") == null || detialMap.get("FIsProcessed").toString().equals("1")) {
                // empty if block
            }
            fbillid = (String)detialMap.get("FBillID");
            fbillEntryid = (String)detialMap.get("FBillEntryID");
            if (detialMap.get("FMRPItem") == null) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0017")));
            }
            fmrpItemEnum = Integer.parseInt(detialMap.get("FMRPItem").toString());
            if (fmrpItemEnum == 205) {
                String error = this.dealMRPExceptionManufactureOrder(ctx, fbillid, FResetQty, FResetDateStr, FAdjustType, i + 1);
                if (error != null && !"".equals(error)) {
                    strbuf.append(error).append("\r\n");
                }
            } else if (fmrpItemEnum == 240) {
                this.dealMRPExceptionPurRequest(ctx, fbillid, fbillEntryid, FResetQty, FResetDateStr, FAdjustType);
            } else if (fmrpItemEnum == 230) {
                this.dealMRPExceptionPurOrder(ctx, fbillid, fbillEntryid, FResetQty, FResetDateStr, FAdjustType);
            } else if (fmrpItemEnum == 250) {
                this.dealMRPExceptionPlannedOrder(ctx, fbillid, FResetQty, FResetDateStr, FAdjustType);
            }
            sql.setLength(0);
            sql.append(" update ").append(fCaldetailtableName);
            sql.append(" set FIsProcessed = 1,FProcessedRemark = '").append(FProcessedRemark).append("' ");
            sql.append(" where fid in(").append(this.getCalDetialIDStr(ctx, fCaldetailtableName, fdetailID)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (strbuf != null && !"".equals(strbuf.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("", strbuf.toString()));
        }
        return returnMap;
    }

    private void copyBOTRelation(Context ctx, BOSUuid newPKID, CoreBillBaseInfo info) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_BOT_Relation(FID, FSrcEntityID, FDestEntityID, FSrcObjectID, FDestObjectID, FDate, FOperatorID, FIsEffected, FBotMappingID, FType)");
        sql.append("SELECT NEWBOSID('59302EC6'), FSrcEntityID, FDestEntityID, FSrcObjectID");
        sql.append(", '").append(newPKID).append("', sysDate, '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getNumber()).append("' ");
        sql.append(",FIsEffected, FBotMappingID, FType FROM T_BOT_Relation WHERE FSrcObjectID='").append(info.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected Map getDetialValue(Context ctx, String ftableName, String fid) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        try {
            sql.append(" select ").append("mcal.FID As FID,").append("mcal.Fmaterialid As FMaterialID ,").append("mcal.FOrgUnitID As FOrgUnitID ,").append("mcal.FMRPItem As FMRPItem, ").append("mcal.FBillID As FBillID, ").append("mcal.FBillEntryID As FBillEntryID, ").append("to_char(mcal.FBillDate,'yyyy-MM-dd') As FBillDate, ").append("mcal.FPeriod As FPeriod, ").append("mcal.FIsProcessed As FIsProcessed, ").append("mcal.FPlanVersionID As FPlanVersionID ").append("from ").append(ftableName).append(" mcal ").append(" where fid = '").append(fid).append("' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                resultMap.put("FID", rs.getString("FID"));
                resultMap.put("FMaterialID", rs.getString("FMaterialID"));
                resultMap.put("FOrgUnitID", rs.getString("FOrgUnitID"));
                resultMap.put("FMRPItem", rs.getString("FMRPItem"));
                resultMap.put("FBillID", rs.getString("FBillID"));
                resultMap.put("FBillEntryID", rs.getString("FBillEntryID"));
                resultMap.put("FBillDate", rs.getString("FBillDate"));
                resultMap.put("FPeriod", rs.getString("FPeriod"));
                resultMap.put("FIsProcessed", rs.getString("FIsProcessed"));
                resultMap.put("FPlanVersionID", rs.getString("FPlanVersionID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return resultMap;
    }

    protected void getXTPlandate(Context ctx, PMRPPlannedOrderInfo info, Date xtBeginDate, Date xtEndDate) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" Select min(h.Fstarttime) As Fstarttime, Max(h.Ffinishtime) As Ffinishtime  ");
        sb.append(" from T_PCP_ProjectCP h \r\n");
        sb.append(" inner join (Select fmaterialid,fprojectid,Max(fstorageorgunitid) As fstorageorgunitid   from t_mm_bom where fbasestatus = 4 and fbomtype = ").append(80).append(" group by fmaterialid,fprojectid) morg ON morg.fmaterialid= h.Fmaterialid and morg.fprojectid = h.fprojectid \r\n");
        sb.append(" left outer JOIN t_mm_project P ON P.FID= h.fprojectid \r\n");
        sb.append(" left outer JOIN t_mm_tracknumber T ON T.FID= h.ftracknumberid  \r\n");
        sb.append(" WHERE h.fstate = ").append(4).append("");
        if (info.getScheme() != null && info.getScheme().getStorageOrg() != null) {
            sb.append("  AND h.Fstorageorgunitid  = '" + info.getScheme().getStorageOrg().getId().toString() + "' ");
        }
        sb.append("  AND h.fqty  > 0 ");
        sb.append("  AND P.fbasestatus = 4 ");
        sb.append("  AND t.FStatus <> 80 ");
        sb.append("  AND h.fmaterialid = '").append(info.getMaterial().getId()).append("' ");
        sb.append("  AND morg.fstorageorgunitid = '").append(info.getStorageOrgUnit().getId()).append("' ");
        if (info.getProject() != null) {
            sb.append("  AND h.Fprojectid = '").append(info.getProject().getId()).append("'  ");
        } else {
            sb.append("  AND h.Fprojectid  is null  ");
        }
        if (info.getTrackNumber() != null) {
            sb.append("  AND h.ftracknumberid = '").append(info.getTrackNumber().getId()).append("'  ");
        } else {
            sb.append("  AND h.ftracknumberid  is null  ");
        }
        if (info.getProjectPlanModel() != null) {
            sb.append("  AND h.fprojectplanmodelid = '").append(info.getProjectPlanModel().getId()).append("'  ");
        } else {
            sb.append("  AND h.fprojectplanmodelid  is null  ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                xtBeginDate = rs.getDate("Fstarttime");
                xtEndDate = rs.getDate("Ffinishtime");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected PMRPPlannedOrderChangeInfo createPlannedOrderChangeBill(Context ctx, PMRPPlannedOrderInfo info, BigDecimal changeQty, Date changeDate, int FAjustType, int diffday, Date xtBeginDate, Date xtEndDate) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PMRPPlannedOrderChangeInfo changeInfo = new PMRPPlannedOrderChangeInfo();
        changeInfo.setPlanedOrderSrc(info);
        changeInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        changeInfo.setChangeUser(userInfo);
        changeInfo.setChangeTime(new Timestamp(new Date().getTime()));
        changeInfo.setTrackNumber(info.getTrackNumber());
        changeInfo.setQty(info.getQty());
        changeInfo.setBaseQty(info.getBaseQty());
        changeInfo.setBaseTotalReleaseQty(info.getBaseTotalReleaseQty());
        changeInfo.setTotalReleaseQty(info.getTotalReleaseQty());
        changeInfo.setStartDate(info.getStartDate());
        changeInfo.setScheduleQty(info.getScheduleQty());
        changeInfo.setBaseScheduleQty(info.getBaseScheduleQty());
        changeInfo.setEndDate(info.getEndDate());
        changeInfo.setAvilableDate(info.getAvilableDate());
        changeInfo.setTrackNumberChange(info.getTrackNumber());
        if (FAjustType == 4) {
            changeInfo.setDescription(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYQX"));
        } else if (FAjustType == 2) {
            changeInfo.setDescription(this.getResourceString(ctx, this.resClassName, "PROJECT_JYTQ"));
        } else if (FAjustType == 3) {
            changeInfo.setDescription(this.getResourceString(ctx, this.resClassName, "PROJECT_JYYH"));
        }
        if (changeDate != null) {
            changeInfo.setAvilableDateChange(changeDate);
            if (xtBeginDate != null && xtEndDate != null) {
                changeInfo.setStartDateChange(xtBeginDate);
                changeInfo.setEndDateChange(xtEndDate);
            } else {
                Date fnewbeginDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getStartDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1);
                Date fnewendDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0);
                changeInfo.setStartDateChange(fnewbeginDate);
                changeInfo.setEndDateChange(fnewendDate);
            }
        }
        if (changeQty != null && changeQty.compareTo(new BigDecimal(0)) != 0) {
            changeInfo.setChangeQty(changeQty);
            changeInfo.setBaseChangeQty(changeQty);
        }
        PMRPPlannedOrderChangeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)changeInfo);
        return changeInfo;
    }

    protected PMRPPlannedOrderCollection dealPlannedOrderBill(Context ctx, PMRPPlannedOrderInfo info, BigDecimal changeQty, Timestamp changeDate, String FAjustType) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        int begin_end_diffDay = 0;
        int end_Avilable_diffDay = 0;
        BigDecimal oldQty = info.getQty();
        BigDecimal changeRate = new BigDecimal(0);
        if (changeQty != null) {
            changeRate = changeQty.divide(oldQty, 10, 4);
        }
        PMRPPlannedOrderCollection coll = new PMRPPlannedOrderCollection();
        if ("CANCLE_AJUST".equals(FAjustType)) {
            info.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED);
            info.setDescription(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPYCJYQX"));
        } else if (changeQty != null || changeDate != null) {
            Date fnewbeginDate = null;
            Date fnewendDate = null;
            if (changeDate != null) {
                fnewendDate = DateUtil.addDay((Date)changeDate, (int)end_Avilable_diffDay);
                fnewbeginDate = DateUtil.addDay((Date)fnewendDate, (int)begin_end_diffDay);
            }
            if (changeQty != null && changeQty.compareTo(BigDecimal.ZERO) > 0) {
                if (changeQty.compareTo(info.getQty()) >= 0) {
                    info.setAvilableDate(changeDate);
                    info.setEndDate(fnewendDate);
                    info.setStartDate(fnewbeginDate);
                } else {
                    PMRPPlannedOrderInfo copyInfo = (PMRPPlannedOrderInfo)info.clone();
                    info.setQty(info.getQty().subtract(changeQty));
                    info.setBaseQty(info.getBaseQty().subtract(changeQty));
                    BigDecimal oldChangeRate = new BigDecimal(1).subtract(changeRate);
                    this.dealPlannedOrderEntry(ctx, info, oldChangeRate);
                    copyInfo.setId(null);
                    copyInfo.setNumber(this.getPlannedOrderNumber(ctx, copyInfo));
                    copyInfo.setDescription(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYTZ"));
                    copyInfo.setQty(changeQty);
                    copyInfo.setBaseQty(changeQty);
                    copyInfo.setTotalReleaseQty(BigDecimal.ZERO);
                    copyInfo.setAvilableDate(changeDate);
                    copyInfo.setEndDate(fnewendDate);
                    copyInfo.setStartDate(fnewbeginDate);
                    copyInfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.TEMPORARILYSAVED);
                    this.dealPlannedOrderEntry(ctx, copyInfo, changeRate);
                    PMRPPlannedOrderFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)copyInfo);
                    coll.add(copyInfo);
                }
            } else {
                info.setAvilableDate(changeDate);
                info.setEndDate(fnewendDate);
                info.setStartDate(fnewbeginDate);
            }
        }
        coll.add(info);
        return coll;
    }

    protected String getPlannedOrderNumber(Context ctx, PMRPPlannedOrderInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        AutoNumberUtil.initNumber((Context)ctx, (IObjectValue)info);
        return info.getNumber() == null ? "AutoNoNumberRule_" + BOSUuid.create((String)"46D6DB79").toString() : info.getNumber();
    }

    protected void dealPlannedOrderEntry(Context ctx, PMRPPlannedOrderInfo info, BigDecimal changeRate) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getEntries() == null || info.getEntries().size() < 1) {
            return;
        }
        PMRPPlannedOrderEntryInfo entryInfo = null;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            entryInfo = info.getEntries().get(i);
            entryInfo.setBaseDemandQty(entryInfo.getBaseDemandQty().multiply(changeRate));
            entryInfo.setDemandQty(entryInfo.getDemandQty().multiply(changeRate));
            if (info.getId() != null) continue;
            entryInfo.setId(null);
        }
    }

    private static int daysOfTwo(Date fDate, Date oDate) {
        Calendar aCalendar = Calendar.getInstance();
        aCalendar.setTime(fDate);
        int day1 = aCalendar.get(6);
        aCalendar.setTime(oDate);
        int day2 = aCalendar.get(6);
        return day2 - day1;
    }

    private boolean isHaveUnAuditDownSream(ManufactureOrderInfo moInfo, Context ctx) throws BOSException {
        boolean result = false;
        try {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection botcoll = iBTPManager.getDestRelation(moInfo.getId().toString());
            if (botcoll != null && botcoll.size() > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected String dealMRPExceptionManufactureOrder(Context ctx, String fmanuOrderID, BigDecimal ajustQty, String ajustDateStr, int FAjustType, int line) throws BOSException, EASBizException {
        ManufactureOrderInfo info = null;
        boolean needUpdateInfo = false;
        IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        if (!iManufactureOrder.exists((IObjectPK)new ObjectUuidPK(fmanuOrderID))) {
            String error = ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_DELETEADVICE", (Locale)ctx.getLocale(), (Object[])new Object[]{line});
            return error;
        }
        info = iManufactureOrder.getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(fmanuOrderID));
        if (this.isHaveUnAuditDownSream(info, ctx)) {
            String error = ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_DownADVICE", (Locale)ctx.getLocale(), (Object[])new Object[]{line, info.getNumber()});
            return error;
        }
        if (info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
            String error = ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_CLOSEADVICE", (Locale)ctx.getLocale(), (Object[])new Object[]{line, info.getNumber()});
            return error;
        }
        boolean isNeedChange = this.manuNeedChange(info);
        BigDecimal oldQty = info.getQty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        int diffday = 0;
        if (ajustDateStr != null && FAjustType != 4) {
            try {
                diffday = PMRPPlannedOrderMappingFacadeControllerBean.daysOfTwo(info.getPlanEndDate(), sdf.parse(ajustDateStr + " 00:00:00"));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        Date fnewbeginDate = null;
        if (info.getPlanBeginDate() != null && info.getStorageOrgUnit() != null) {
            fnewbeginDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanBeginDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1);
        }
        Date fnewendDate = null;
        if (info.getPlanEndDate() != null && info.getStorageOrgUnit() != null) {
            fnewendDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0);
        }
        ManufactureOrderInfo newInfo = null;
        if (ajustQty != null && ajustQty.compareTo(new BigDecimal(0)) > 0) {
            if (oldQty.compareTo(ajustQty) > 0) {
                if (FAjustType == 4) {
                    if (isNeedChange) {
                        this.createManuOrderChangeBill(ctx, info, ajustQty, diffday, FAjustType);
                    } else {
                        this.setManufactureOrderQty(ctx, info, oldQty.subtract(ajustQty));
                        this.setManuOrderEntryQty(ctx, info, oldQty.subtract(ajustQty), false);
                        needUpdateInfo = true;
                    }
                } else {
                    newInfo = (ManufactureOrderInfo)info.clone();
                    newInfo.setNumber(null);
                    BOSUuid newpkid = BOSUuid.create((String)"1D0D80DD");
                    this.setBillNumber(ctx, (IObjectValue)newInfo, newInfo.getStorageOrgUnit().getId().toString(), "storageOrgUnit");
                    newInfo.setId(newpkid);
                    newInfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.TEMPORARILYSAVED);
                    this.setManufactureOrderQty(ctx, newInfo, ajustQty);
                    this.setManuOrderEntryQty(ctx, newInfo, ajustQty, true);
                    if (!isNeedChange && diffday != 0) {
                        newInfo.setPlanEndDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)newInfo.getPlanEndDate(), (int)diffday).getTime()), newInfo.getStorageOrgUnit().getId().toString(), 0));
                        newInfo.setPlanBeginDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)newInfo.getPlanBeginDate(), (int)diffday).getTime()), newInfo.getStorageOrgUnit().getId().toString(), 1));
                        this.setManuOrderEntryDate(ctx, newInfo, diffday);
                    }
                    IObjectPK pk = iManufactureOrder.save((CoreBaseInfo)newInfo);
                    sql.setLength(0);
                    sql.append(" update t_mm_manufactureorder set fbasestatus = ");
                    sql.append(info.getBaseStatus().getValue());
                    sql.append(" where fid = '").append(pk).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    this.adjustManuOrderStatus(ctx, pk.toString());
                    if (isNeedChange && diffday != 0) {
                        newInfo.setBaseStatus(info.getBaseStatus());
                        this.createManuOrderChangeBill(ctx, newInfo, new BigDecimal(0), diffday, FAjustType);
                    }
                    this.setManufactureOrderQty(ctx, info, oldQty.subtract(ajustQty));
                    this.setManuOrderEntryQty(ctx, info, oldQty.subtract(ajustQty), false);
                    needUpdateInfo = true;
                    this.copyBOTRelation(ctx, newpkid, (CoreBillBaseInfo)info);
                }
            } else if (FAjustType == 4) {
                if (isNeedChange) {
                    this.createManuOrderChangeBill(ctx, info, info.getQty(), 0, FAjustType);
                }
                sql.setLength(0);
                sql.append(" update t_mm_manufactureorder set fremark_l2 = '");
                sql.append(this.getResourceString(ctx, this.resClassName, "PROJECT_QXHZDGB"));
                sql.append("'");
                if (!isNeedChange) {
                    sql.append(" , fqty = 0 ");
                    sql.append(" , fbaseqty = 0 ");
                    sql.append(" , funtostoreqty = 0 ");
                    sql.append(" , funtostorebaseqty = 0 ");
                }
                sql.append(" where fid = '").append(info.getId()).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append(" update t_mm_manufactureorder set fbasestatus = ");
                sql.append(7);
                sql.append(" where fid = '").append(info.getId()).append("'");
                sql.append(" And Isnull((Select Sum(d.fqty) from t_im_materialreqbill h inner join t_im_materialreqbillentry d on h.fid = d.fparentid where d.FSourceBillID = t_mm_manufactureorder.fid  and h.fbasestatus = 4),0) <=0");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (!isNeedChange) {
                if (diffday != 0) {
                    info.setPlanEndDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0));
                    info.setPlanBeginDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanBeginDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1));
                    this.setManuOrderEntryDate(ctx, info, diffday);
                    needUpdateInfo = true;
                }
            } else if (diffday != 0) {
                this.createManuOrderChangeBill(ctx, info, new BigDecimal(0), diffday, FAjustType);
            }
        } else if (!isNeedChange) {
            if (diffday != 0) {
                info.setPlanEndDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0));
                info.setPlanBeginDate(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanBeginDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1));
                this.setManuOrderEntryDate(ctx, info, diffday);
                needUpdateInfo = true;
            }
        } else if (diffday != 0) {
            this.createManuOrderChangeBill(ctx, info, new BigDecimal(0), diffday, FAjustType);
        }
        if (needUpdateInfo) {
            iManufactureOrder.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.adjustManuOrderStatus(ctx, info.getId().toString());
        }
        return null;
    }

    protected Map getBeginEndDate(Timestamp beginTimestamp, Timestamp endTimestamp, String ajustDateStr) throws BOSException, EASBizException {
        HashMap<String, Timestamp> dataMap = new HashMap<String, Timestamp>();
        int daysDiff = 0;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date beignDate = beginTimestamp;
        Date endDate = endTimestamp;
        try {
            beignDate = sdf.parse(dft.format(beginTimestamp));
            endDate = sdf.parse(dft.format(endTimestamp));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String beginDate_Time = null;
        String endDate_Time = null;
        beginDate_Time = dft.format(beignDate).substring(11);
        endDate_Time = dft.format(endDate).substring(11);
        daysDiff = PMRPPlannedOrderMappingFacadeControllerBean.daysOfTwo(beignDate, endDate);
        Timestamp newbeginTimestamp = new Timestamp(System.currentTimeMillis());
        Timestamp newendTimestamp = new Timestamp(System.currentTimeMillis());
        if (ajustDateStr != null) {
            Date ajustDate = null;
            try {
                ajustDate = sdf.parse(ajustDateStr);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
                throw new BOSException((Throwable)e1);
            }
            String fnewEndDateStr = ajustDateStr + " " + endDate_Time;
            newendTimestamp = Timestamp.valueOf(fnewEndDateStr);
            Date newBeginDate = DateUtil.addDay((Date)ajustDate, (int)daysDiff);
            String fnewBeginDateStr = df.format(newBeginDate) + " " + beginDate_Time;
            newbeginTimestamp = Timestamp.valueOf(fnewBeginDateStr);
        } else {
            newbeginTimestamp = beginTimestamp;
            newendTimestamp = endTimestamp;
        }
        dataMap.put("beginDate", newbeginTimestamp);
        dataMap.put("endDate", newendTimestamp);
        return dataMap;
    }

    protected void setManuOrderEntryQty(Context ctx, ManufactureOrderInfo info, BigDecimal newOrderQty, boolean isaddnew) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        BigDecimal ajustRate = null;
        if (info.getTechnics() != null && info.getTechnics().size() > 0) {
            for (int i = 0; i < info.getTechnics().size(); ++i) {
                BigDecimal fnewQty;
                ManufactureOrderTechnicsInfo entryInfo = info.getTechnics().get(i);
                BigDecimal ffinishQty = entryInfo.getFinishedQty();
                if (ffinishQty == null) {
                    ffinishQty = new BigDecimal(0);
                }
                if (entryInfo.getProcessBatch() == null || entryInfo.getProcessBatch().compareTo(BigDecimal.ZERO) <= 0) {
                    entryInfo.setProcessBatch(new BigDecimal(1));
                }
                if ((fnewQty = newOrderQty.multiply(entryInfo.getProcessBatch())).compareTo(ffinishQty) < 0) {
                    fnewQty = ffinishQty;
                    if (isaddnew) {
                        fnewQty = entryInfo.getQty().subtract(ffinishQty);
                    }
                }
                ajustRate = fnewQty.divide(entryInfo.getQty(), 10, 4);
                entryInfo.setQty(fnewQty);
                entryInfo.setBaseQty(fnewQty);
                entryInfo.setUnDispatchQty(fnewQty);
                entryInfo.setUnDispatchBaseQty(fnewQty);
                entryInfo.setOperQty(fnewQty);
                entryInfo.setUnFinishBaseQty(entryInfo.getBaseQty().subtract(entryInfo.getFinishedBaseQty()));
                entryInfo.setUnFinishQty(entryInfo.getQty().subtract(entryInfo.getFinishedQty()));
                entryInfo.setUnMoveOutBaseQty(entryInfo.getBaseQty().subtract(entryInfo.getOutBaseQty()));
                entryInfo.setUnMoveOutQty(entryInfo.getQty().subtract(entryInfo.getOutQty()));
                entryInfo.setUnTestBaseQty(entryInfo.getBaseQty().subtract(entryInfo.getTestBaseQty()));
                entryInfo.setUnTestQty(entryInfo.getQty().subtract(entryInfo.getTestQty()));
                entryInfo.setTotalBaseQtyUpper(entryInfo.getBaseQty());
                entryInfo.setTotalQtyUpper(entryInfo.getQty());
                entryInfo.setTotalUpperBaseQty(entryInfo.getBaseQty());
                entryInfo.setTotalUpperQty(entryInfo.getQty());
                if (isaddnew) {
                    entryInfo.setParent(info);
                    entryInfo.setId(BOSUuid.create((String)"9A3656FE"));
                    entryInfo.setMergeID(entryInfo.getId());
                }
                if (info.getStocks() == null || info.getStocks().size() <= 0) continue;
                for (int j = 0; j < info.getStocks().size(); ++j) {
                    ManufactureOrderStockInfo stocksInfo = info.getStocks().get(j);
                    if (stocksInfo.getOperationNo() != entryInfo.getOperationNo()) continue;
                    MaterialInfo materialInfo = stocksInfo.getMaterial();
                    materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId().toString()));
                    MeasureUnitInfo muInfo = materialInfo.getBaseUnit();
                    MultiMeasureUnitInfo measureUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), muInfo.getId().toString());
                    BigDecimal fissueQty = new BigDecimal(0);
                    if (stocksInfo.getId() != null) {
                        try {
                            fissueQty = this.getNextBillIssueQtyFromStockID(ctx, stocksInfo);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            throw new BOSException((Throwable)e);
                        }
                    }
                    BigDecimal fStocknewQty = new BigDecimal(0);
                    fStocknewQty = stocksInfo.getQty().multiply(ajustRate);
                    if (isaddnew) {
                        if (stocksInfo.getQty().subtract(fStocknewQty).compareTo(fissueQty) < 0) {
                            fStocknewQty = stocksInfo.getQty().subtract(fissueQty);
                        }
                        stocksInfo.setActIssueBaseQty(BigDecimal.ZERO);
                        stocksInfo.setActIssueQty(BigDecimal.ZERO);
                    } else if (fStocknewQty.compareTo(fissueQty) < 0) {
                        fStocknewQty = fissueQty;
                    }
                    fStocknewQty = fStocknewQty.setScale(measureUnitInfo.getQtyPrecision(), 4);
                    stocksInfo.setQty(fStocknewQty);
                    stocksInfo.setBaseQty(fStocknewQty);
                    stocksInfo.setAssociateQty(fStocknewQty);
                    stocksInfo.setUnIssueQty(stocksInfo.getQty().subtract(stocksInfo.getActIssueQty()).setScale(measureUnitInfo.getQtyPrecision(), 4));
                    stocksInfo.setUnIssueBaseQty(stocksInfo.getBaseQty().subtract(stocksInfo.getActIssueBaseQty()).setScale(measureUnitInfo.getQtyPrecision(), 4));
                    stocksInfo.setPickExtraBaseQty(stocksInfo.getBaseQty().setScale(measureUnitInfo.getQtyPrecision(), 4));
                    stocksInfo.setPickExtraQty(stocksInfo.getQty().setScale(measureUnitInfo.getQtyPrecision(), 4));
                    stocksInfo.setPlannedQty(stocksInfo.getPlannedQty().multiply(ajustRate).setScale(measureUnitInfo.getQtyPrecision(), 4));
                    stocksInfo.setPlannedBaseQty(stocksInfo.getPlannedBaseQty().multiply(ajustRate).setScale(measureUnitInfo.getQtyPrecision(), 4));
                    MeasureUnitInfo mmui = stocksInfo.getUnit();
                    MultiMeasureUnitInfo stockMuInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), mmui.getId().toString());
                    int prec = null == mmui ? 4 : stockMuInfo.getQtyPrecision();
                    BigDecimal extraRatio = new BigDecimal("1.0").add(stocksInfo.getExtraRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
                    BigDecimal lackRatio = new BigDecimal("1.0").subtract(stocksInfo.getLackRatio().divide(new BigDecimal("100.00"), 4, 4).setScale(prec, 4));
                    BigDecimal pickExtraQty = stocksInfo.getPlannedQty().multiply(extraRatio).setScale(prec, 4);
                    BigDecimal pickLackQty = stocksInfo.getPlannedQty().multiply(lackRatio).setScale(prec, 4);
                    stocksInfo.setPickExtraQty(pickExtraQty);
                    stocksInfo.setPickLackQty(pickLackQty);
                    stocksInfo.setUnReceiptBaseQty(stocksInfo.getPlannedBaseQty());
                    stocksInfo.setUnReceiptQty(stocksInfo.getPlannedQty());
                    stocksInfo.setOriginalPlanBaseQty(stocksInfo.getPlannedBaseQty());
                    stocksInfo.setOriginalPlanQty(stocksInfo.getPlannedQty());
                    if (!isaddnew) continue;
                    stocksInfo.setId(null);
                    stocksInfo.setParent(info);
                    stocksInfo.setId(BOSUuid.create((String)"ED498839"));
                }
            }
        }
    }

    protected void setManuOrderEntryDate(Context ctx, ManufactureOrderInfo info, int diffday) throws BOSException, EASBizException {
        int i;
        if (info == null) {
            return;
        }
        if (info.getTechnics() != null && info.getTechnics().size() > 0) {
            for (i = 0; i < info.getTechnics().size(); ++i) {
                ManufactureOrderTechnicsInfo entryInfo = info.getTechnics().get(i);
                if (entryInfo.getEarlistCmpTime() != null) {
                    entryInfo.setEarlistCmpTime(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)entryInfo.getEarlistCmpTime(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0));
                }
                if (entryInfo.getEarlistWoktime() != null) {
                    entryInfo.setEarlistWoktime(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)entryInfo.getEarlistWoktime(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1));
                }
                if (entryInfo.getLastCmpTime() != null) {
                    entryInfo.setLastCmpTime(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)entryInfo.getLastCmpTime(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0));
                }
                if (entryInfo.getLastWorktime() == null) continue;
                entryInfo.setLastWorktime(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)entryInfo.getLastWorktime(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1));
            }
        }
        if (info.getStocks() != null && info.getStocks().size() > 0) {
            for (i = 0; i < info.getStocks().size(); ++i) {
                ManufactureOrderStockInfo stocksInfo = info.getStocks().get(i);
                if (stocksInfo.getDemandTime() == null) continue;
                stocksInfo.setDemandTime(this.getNewDateTimeStamp(ctx, new Timestamp(DateUtil.addDay((Date)stocksInfo.getDemandTime(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1));
                if (stocksInfo == null || stocksInfo.getId() == null) continue;
                StringBuilder sql = new StringBuilder();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sql.append(" update t_im_materialreqbillentry d ");
                sql.append(" set fdemanddate = TO_DATE('").append(sdf.format(stocksInfo.getDemandTime())).append("') ");
                sql.append(" where exists(select 1 from t_im_materialreqbill h where h.fid = d.fparentid and h.fbasestatus <> 4 ) ");
                sql.append(" and d.fcorebillentryid = '").append(stocksInfo.getId()).append("' ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    protected boolean manuNeedChange(ManufactureOrderInfo info) {
        return !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.TEMPORARILYSAVED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.ADD) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.SUBMITED);
    }

    protected PurRequestInfo dealMRPExceptionPurRequest(Context ctx, String fpureRequestID, String fpureRequestEntryID, BigDecimal ajustQty, String ajustDateStr, int FAjustType) throws BOSException, EASBizException {
        PurRequestInfo info = null;
        boolean needUpdateInfo = false;
        IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)ctx);
        if (!iPurRequest.exists((IObjectPK)new ObjectUuidPK(fpureRequestID))) {
            throw new BOSException(this.getResourceString(ctx, this.resClassName, "PROJECT_CGSQDYBSC"));
        }
        info = iPurRequest.getPurRequestInfo((IObjectPK)new ObjectUuidPK(fpureRequestID));
        if (info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
            return info;
        }
        PurRequestEntryInfo purRequestEntryInfo = null;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            if (!info.getEntries().get(i).getId().toString().equals(fpureRequestEntryID)) continue;
            purRequestEntryInfo = info.getEntries().get(i);
            break;
        }
        if (purRequestEntryInfo == null) {
            throw new BOSException(this.getResourceString(ctx, this.resClassName, "PROJECT_CGSQDFLYBSC"));
        }
        BigDecimal oldQty = purRequestEntryInfo.getQty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        Date newAjustDate = null;
        if (ajustDateStr != null && FAjustType != 4) {
            try {
                newAjustDate = sdf.parse(ajustDateStr + " 00:00:00");
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        String lS_description = null;
        if (ajustQty != null && ajustQty.compareTo(new BigDecimal(0)) > 0) {
            if (oldQty.compareTo(ajustQty) > 0) {
                if (FAjustType != 4) {
                    if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                        PurRequestEntryInfo newEntryInfo = (PurRequestEntryInfo)purRequestEntryInfo.clone();
                        newEntryInfo.setId(BOSUuid.create((String)"2B7DD5E4"));
                        newEntryInfo.setBaseQty(ajustQty);
                        newEntryInfo.setQty(ajustQty);
                        newEntryInfo.setRequestQty(ajustQty);
                        if (ajustDateStr != null) {
                            newEntryInfo.setProposeDeliveryDate(newAjustDate);
                            newEntryInfo.setProposePurchaseDate(newAjustDate);
                            newEntryInfo.setRequirementDate(newAjustDate);
                        }
                        newEntryInfo.setRemark(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPTZJYHCFL"));
                        info.getEntries().add(newEntryInfo);
                        purRequestEntryInfo.setQty(oldQty.subtract(ajustQty));
                        purRequestEntryInfo.setBaseQty(oldQty.subtract(ajustQty));
                        purRequestEntryInfo.setRequestQty(oldQty.subtract(ajustQty));
                        needUpdateInfo = true;
                    } else {
                        this.createPurRequestChangeBill(ctx, info, purRequestEntryInfo, ajustQty, newAjustDate, FAjustType, true);
                    }
                } else if (info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) || info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                    ajustQty = ajustQty.multiply(new BigDecimal(-1));
                    this.createPurRequestChangeBill(ctx, info, purRequestEntryInfo, ajustQty, purRequestEntryInfo.getRequirementDate(), FAjustType, false);
                } else {
                    purRequestEntryInfo.setQty(oldQty.subtract(ajustQty));
                    purRequestEntryInfo.setBaseQty(oldQty.subtract(ajustQty));
                    purRequestEntryInfo.setRequestQty(oldQty.subtract(ajustQty));
                    needUpdateInfo = true;
                }
            } else if (FAjustType == 4) {
                if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                    sql.setLength(0);
                    sql.append(" update t_sm_purrequest set fdescription = '").append(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPQXHZDGB")).append("'");
                    sql.append(" where fid = '").append(info.getId()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql.setLength(0);
                    sql.append(" update t_sm_purrequestentry set fqty = 0");
                    sql.append(" ,fbaseqty = 0");
                    sql.append(" ,funorderedbaseqty = 0");
                    sql.append(" ,funorderedqty = 0");
                    sql.append(" where fparentid = '").append(info.getId()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                } else {
                    this.createPurRequestChangeBill(ctx, info, purRequestEntryInfo, oldQty.multiply(new BigDecimal(-1)), newAjustDate, FAjustType, false);
                }
            } else if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                if (newAjustDate != null) {
                    purRequestEntryInfo.setProposeDeliveryDate(newAjustDate);
                    purRequestEntryInfo.setProposePurchaseDate(newAjustDate);
                    purRequestEntryInfo.setRequirementDate(newAjustDate);
                    lS_description = info.getDescription() + this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYTZRQ");
                    if (lS_description.length() > 254) {
                        lS_description = lS_description.substring(1, 254);
                    }
                    info.setDescription(lS_description);
                    needUpdateInfo = true;
                }
            } else if (newAjustDate != null) {
                this.createPurRequestChangeBill(ctx, info, purRequestEntryInfo, ajustQty, newAjustDate, FAjustType, false);
            }
        } else if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
            if (newAjustDate != null) {
                purRequestEntryInfo.setProposeDeliveryDate(newAjustDate);
                purRequestEntryInfo.setProposePurchaseDate(newAjustDate);
                purRequestEntryInfo.setRequirementDate(newAjustDate);
                lS_description = info.getDescription() + this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYTZRQ");
                if (lS_description.length() > 254) {
                    lS_description = lS_description.substring(1, 254);
                }
                info.setDescription(lS_description);
                needUpdateInfo = true;
            }
        } else if (newAjustDate != null) {
            this.createPurRequestChangeBill(ctx, info, purRequestEntryInfo, BigDecimal.ZERO, newAjustDate, FAjustType, false);
        }
        if (needUpdateInfo) {
            iPurRequest.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        return info;
    }

    protected PurOrderInfo dealMRPExceptionPurOrder(Context ctx, String fpureOrderID, String fpureOrderEntryID, BigDecimal ajustQty, String ajustDateStr, int FAjustType) throws BOSException, EASBizException {
        PurOrderInfo info = null;
        boolean needUpdateInfo = false;
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
        if (!iPurOrder.exists((IObjectPK)new ObjectUuidPK(fpureOrderID))) {
            throw new BOSException(this.getResourceString(ctx, this.resClassName, "PROJECT_CGDDYBSC"));
        }
        info = iPurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(fpureOrderID), this.getPurOrderSelectors());
        if (info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
            return info;
        }
        PurOrderEntryInfo purOrderEntryInfo = null;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            if (!info.getEntries().get(i).getId().toString().equals(fpureOrderEntryID)) continue;
            purOrderEntryInfo = info.getEntries().get(i);
            break;
        }
        if (purOrderEntryInfo == null) {
            throw new BOSException(this.getResourceString(ctx, this.resClassName, "PROJECT_CGDDFLYBSC"));
        }
        BigDecimal oldQty = purOrderEntryInfo.getQty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        Date newAjustDate = null;
        if (ajustDateStr != null && FAjustType != 4) {
            try {
                newAjustDate = sdf.parse(ajustDateStr + " 00:00:00");
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        String lS_description = null;
        if (ajustQty != null && ajustQty.compareTo(new BigDecimal(0)) > 0) {
            if (oldQty.compareTo(ajustQty) > 0) {
                if (FAjustType != 4) {
                    if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                        PurOrderEntryInfo newEntryInfo = (PurOrderEntryInfo)purOrderEntryInfo.clone();
                        newEntryInfo.setId(BOSUuid.create((String)"26041CC5"));
                        newEntryInfo.setBaseQty(ajustQty);
                        newEntryInfo.setQty(ajustQty);
                        newEntryInfo.put("totalDawnQty", (Object)ajustQty);
                        if (ajustDateStr != null && FAjustType != 4) {
                            newEntryInfo.setDeliveryDate(newAjustDate);
                        }
                        info.getEntries().add(newEntryInfo);
                        purOrderEntryInfo.setQty(oldQty.subtract(ajustQty));
                        purOrderEntryInfo.setBaseQty(oldQty.subtract(ajustQty));
                        purOrderEntryInfo.put("totalDawnQty", (Object)oldQty.subtract(ajustQty));
                        needUpdateInfo = true;
                    } else {
                        this.createPurorderChangeBill(ctx, info, purOrderEntryInfo, ajustQty, newAjustDate, FAjustType, true);
                    }
                } else if (info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) || info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                    ajustQty = ajustQty.multiply(new BigDecimal(-1));
                    this.createPurorderChangeBill(ctx, info, purOrderEntryInfo, ajustQty, newAjustDate, FAjustType, false);
                } else {
                    purOrderEntryInfo.setQty(oldQty.subtract(ajustQty));
                    purOrderEntryInfo.setBaseQty(oldQty.subtract(ajustQty));
                    purOrderEntryInfo.put("totalDawnQty", (Object)oldQty.subtract(ajustQty));
                    needUpdateInfo = true;
                }
            } else if (FAjustType == 4) {
                if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                    sql.setLength(0);
                    sql.append(" update t_sm_purOrder set fdescription = '").append(this.getResourceString(ctx, this.resClassName, "PROJECT_MRPQXHZDGB")).append("'");
                    sql.append(" where fid = '").append(info.getId()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql.setLength(0);
                    sql.append(" update t_sm_purOrderentry set fqty = 0 ");
                    sql.append(" ,fbaseqty = 0");
                    sql.append(" ,funorderedqty = 0");
                    sql.append(" where fparentid = '").append(info.getId()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                } else {
                    this.createPurorderChangeBill(ctx, info, purOrderEntryInfo, oldQty.multiply(new BigDecimal(-1)), newAjustDate, FAjustType, false);
                }
            } else if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
                if (newAjustDate != null) {
                    purOrderEntryInfo.setDeliveryDate(newAjustDate);
                    needUpdateInfo = true;
                    lS_description = info.getDescription() + this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYTZRQ");
                    if (lS_description.length() > 254) {
                        lS_description = lS_description.substring(1, 254);
                    }
                    info.setDescription(lS_description);
                }
            } else if (newAjustDate != null) {
                this.createPurorderChangeBill(ctx, info, purOrderEntryInfo, BigDecimal.ZERO, newAjustDate, FAjustType, false);
            }
        } else if (!info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED)) {
            if (newAjustDate != null) {
                purOrderEntryInfo.setDeliveryDate(newAjustDate);
                lS_description = info.getDescription() + this.getResourceString(ctx, this.resClassName, "PROJECT_MRPJYTZRQ");
                if (lS_description.length() > 254) {
                    lS_description = lS_description.substring(1, 254);
                }
                info.setDescription(lS_description);
                needUpdateInfo = true;
            }
        } else if (newAjustDate != null) {
            this.createPurorderChangeBill(ctx, info, purOrderEntryInfo, BigDecimal.ZERO, newAjustDate, FAjustType, false);
        }
        if (needUpdateInfo) {
            iPurOrder.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        return info;
    }

    protected PurRequestChangeInfo createPurRequestChangeBill(Context ctx, PurRequestInfo purRequestInfo, PurRequestEntryInfo purRequestEntryInfo, BigDecimal ajustQty, Date newAjustDate, int FAjustType, boolean isdec) throws BOSException, EASBizException {
        PurRequestChangeInfo changeInfo = new PurRequestChangeInfo();
        changeInfo.setCompanyOrgUnit(purRequestInfo.getCompanyOrgUnit());
        changeInfo.setAlterrationReason(this.getResourceString(ctx, this.resClassName, "PROJECT_XMJHDDJYTZ"));
        changeInfo.setSourceBillId(purRequestInfo.getId().toString());
        changeInfo.setSourceBillType(purRequestInfo.getBillType());
        changeInfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.TEMPORARILYSAVED);
        if (isdec) {
            changeInfo.setChangeType(ChangeTypeEnum.entryChange);
        } else {
            changeInfo.setChangeType(ChangeTypeEnum.fieldChange);
        }
        changeInfo.setBizDate(new Date());
        this.setBillNumber(ctx, (IObjectValue)changeInfo, changeInfo.getCompanyOrgUnit().getId().toString(), "companyOrgUnit");
        BillTypeInfo purRequestChangeBillTypeInfo = new BillTypeInfo();
        purRequestChangeBillTypeInfo.setId(BOSUuid.read((String)"6SQLZ27vQbCc0KPDBC5yHEY+1VI="));
        changeInfo.setBillType(purRequestChangeBillTypeInfo);
        PurRequestChangeEntryInfo changeentryInfo = new PurRequestChangeEntryInfo();
        changeentryInfo.setQty(purRequestEntryInfo.getQty());
        changeentryInfo.setPurRequestEntry(purRequestEntryInfo);
        changeentryInfo.setPurRequest(purRequestInfo);
        changeentryInfo.setMaterial(purRequestEntryInfo.getMaterial());
        changeentryInfo.setProject(purRequestEntryInfo.getProject());
        changeentryInfo.setTrack(purRequestEntryInfo.getTrackNo());
        changeentryInfo.setBaseUnit(purRequestEntryInfo.getBaseUnit());
        changeentryInfo.setUnit(purRequestEntryInfo.getUnit());
        changeentryInfo.setSourceBillEntryId(purRequestEntryInfo.getId().toString());
        changeentryInfo.setSourceBillEntrySeq(purRequestEntryInfo.getSeq());
        changeentryInfo.setSourceBillId(purRequestInfo.getId().toString());
        changeentryInfo.setSourceBillNumber(purRequestInfo.getNumber());
        changeentryInfo.setSourceBillType(purRequestInfo.getBillType());
        if (newAjustDate == null) {
            changeentryInfo.setChangeDemandDate(purRequestEntryInfo.getRequirementDate());
            changeentryInfo.setChangeDays(BigDecimal.ZERO);
        } else {
            changeentryInfo.setChangeDemandDate(newAjustDate);
            changeentryInfo.setChangeDays(new BigDecimal(this.getDiffDays(purRequestEntryInfo.getRequirementDate(), newAjustDate)));
        }
        changeentryInfo.setDemandDate(purRequestEntryInfo.getRequirementDate());
        changeentryInfo.setChangeQty(ajustQty);
        changeentryInfo.setChangeBaseQty(ajustQty);
        changeentryInfo.setRealChangeBaseQty(BigDecimal.ZERO);
        changeentryInfo.setRealChangeQty(BigDecimal.ZERO);
        changeentryInfo.setParent(changeInfo);
        changeInfo.getEntries().add(changeentryInfo);
        IObjectPK pk = PurRequestChangeFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)changeInfo);
        BOTMappingInfo botMapRule = this.getBOTMappingInfo(ctx, "PURC-POC001");
        try {
            PurRequestChangeFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)changeInfo);
        }
        catch (BOSException ex) {
            if (ex.getMessage() != null && ex.getMessage().indexOf("BOTP") >= 0) {
                if (botMapRule == null) {
                    throw new BOSException("BOTP\u89c4\u5219\uff1aPURC-POC001\u4e0d\u5b58\u5728\uff01");
                }
                if (botMapRule.getExtRule() != null && !botMapRule.getExtRule().isIsEffected()) {
                    throw new BOSException("BOTP\u89c4\u5219\uff1aPURC-POC001\u672a\u542f\u52a8\uff01");
                }
                throw ex;
            }
            throw ex;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select fid from t_sm_purrequest where fid = '").append(pk.toString()).append("' and fbasestatus = 2 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            PurRequestChangeFactory.getLocalInstance((Context)ctx).audit(pk);
        }
        return changeInfo;
    }

    protected BOTMappingInfo getBOTMappingInfo(Context ctx, String name) throws BOSException, EASBizException {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            return null;
        }
        BOTMappingInfo botMappingInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BOTMappingCollection botMappingCollection = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(entityViewInfo);
        if (botMappingCollection != null && botMappingCollection.size() > 0) {
            botMappingInfo = botMappingCollection.get(0);
        }
        return botMappingInfo;
    }

    protected PurOrderChangeInfo createPurorderChangeBill(Context ctx, PurOrderInfo purOrderInfo, PurOrderEntryInfo purOrderEntryInfo, BigDecimal ajustQty, Date newAjustDate, int FAjustType, boolean isdec) throws BOSException, EASBizException {
        PurOrderChangeInfo changeInfo = new PurOrderChangeInfo();
        PurOrderChangeEntryInfo changeentryInfo = new PurOrderChangeEntryInfo();
        changeInfo.setPurchaseOrgUnit(purOrderInfo.getPurchaseOrgUnit());
        changeInfo.setAlterrationReason(this.getResourceString(ctx, this.resClassName, "PROJECT_XMJHDDJYTZ"));
        changeInfo.setPurRequest(StringUtil.isEmptyString((String)purOrderEntryInfo.getPurRequestID()) ? null : PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getPurRequestID())));
        changeInfo.setSourceBillId(purOrderInfo.getId().toString());
        changeInfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.TEMPORARILYSAVED);
        changeInfo.setBizDate(new Date());
        if (isdec) {
            changeInfo.setChangeType(ChangeTypeEnum.entryChange);
        } else {
            changeInfo.setChangeType(ChangeTypeEnum.fieldChange);
        }
        this.setBillNumber(ctx, (IObjectValue)changeInfo, purOrderInfo.getPurchaseOrgUnit().getId().toString(), "purchaseOrgUnit");
        changeentryInfo.setPurOrder(purOrderInfo);
        changeentryInfo.setPurOrderEntry(purOrderEntryInfo);
        changeentryInfo.setAfterChangeQty(purOrderEntryInfo.getQty().add(ajustQty));
        changeentryInfo.setApprovalQty(purOrderEntryInfo.getQty());
        changeentryInfo.setMaterial(purOrderEntryInfo.getMaterial());
        changeentryInfo.setBaseUnit(purOrderEntryInfo.getBaseUnit());
        changeentryInfo.setUnit(purOrderEntryInfo.getUnit());
        changeentryInfo.setSourceBillEntryId(purOrderEntryInfo.getId().toString());
        changeentryInfo.setSourceBillEntrySeq(purOrderEntryInfo.getSeq());
        changeentryInfo.setSourceBillId(purOrderInfo.getId().toString());
        changeentryInfo.setSourceBillNumber(purOrderInfo.getNumber());
        changeentryInfo.setSourceBillType(purOrderInfo.getBillType());
        changeentryInfo.setParent(changeInfo);
        changeentryInfo.setOriginDeliver((Date)(purOrderEntryInfo.getDeliveryDate() == null ? null : new Timestamp(purOrderEntryInfo.getDeliveryDate().getTime())));
        changeInfo.getEntries().add(changeentryInfo);
        changeentryInfo.setChangeQty(ajustQty);
        changeentryInfo.setChangeBaseQty(ajustQty);
        if (newAjustDate != null) {
            changeentryInfo.setDeliverTime((Date)new Timestamp(newAjustDate.getTime()));
            changeentryInfo.setChangeDays(new BigDecimal(this.getDiffDays(changeentryInfo.getOriginDeliver(), newAjustDate)));
        } else {
            changeentryInfo.setDeliverTime(changeentryInfo.getOriginDeliver());
            changeentryInfo.setChangeDays(BigDecimal.ZERO);
        }
        IObjectPK pk = PurOrderChangeFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)changeInfo);
        PurOrderChangeFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)changeInfo);
        StringBuilder sql = new StringBuilder();
        sql.append(" select fid from T_SM_PurOrderChange where fid = '").append(pk.toString()).append("' and fbasestatus = 2 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            PurOrderChangeFactory.getLocalInstance((Context)ctx).audit(pk);
        }
        return changeInfo;
    }

    protected PMRPPlannedOrderInfo dealMRPExceptionPlannedOrder(Context ctx, String fbillid, BigDecimal ajustQty, String ajustDateStr, int FAjustType) throws BOSException, EASBizException {
        PMRPPlannedOrderInfo info = null;
        boolean needUpdateInfo = false;
        IPMRPPlannedOrder iPMRPPlannedOrder = PMRPPlannedOrderFactory.getLocalInstance(ctx);
        if (!iPMRPPlannedOrder.exists((IObjectPK)new ObjectUuidPK(fbillid))) {
            throw new BOSException(this.getResourceString(ctx, this.resClassName, "PROJECT_JHDDYBSC"));
        }
        info = iPMRPPlannedOrder.getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(fbillid));
        boolean isNeedChange = this.plannedOrderNeedChange(info);
        BigDecimal oldQty = info.getQty();
        BigDecimal oldTotalReleaseQty = info.getTotalReleaseQty();
        BigDecimal oldScheduleQty = info.getScheduleQty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int diffday = 0;
        Date ajustDate = null;
        if (ajustDateStr != null && FAjustType != 4) {
            try {
                ajustDate = sdf.parse(ajustDateStr + " 00:00:00");
                diffday = PMRPPlannedOrderMappingFacadeControllerBean.daysOfTwo(info.getAvilableDate(), ajustDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        if (ajustDate == null) {
            diffday = 0;
        }
        BigDecimal ajustRate = new BigDecimal(0);
        if (ajustQty != null && ajustQty.compareTo(new BigDecimal(0)) > 0) {
            ajustRate = oldQty.compareTo(ajustQty) > 0 ? ajustQty.divide(oldQty, 10, 4) : new BigDecimal(1);
        }
        if (ajustQty == null) {
            ajustQty = new BigDecimal(0);
        }
        Date xtBeginDate = null;
        Date xtEndDate = null;
        this.getXTPlandate(ctx, info, xtBeginDate, xtEndDate);
        if (isNeedChange) {
            this.createPlannedOrderChangeBill(ctx, info, oldQty.subtract(ajustQty), ajustDate, FAjustType, diffday, xtBeginDate, xtEndDate);
        }
        if (FAjustType == 4) {
            this.updatePlannedOrderQty(ctx, info, ajustRate, ajustQty);
        } else {
            PMRPPlannedOrderInfo newInfo = null;
            if (oldQty.compareTo(ajustQty) > 0) {
                newInfo = (PMRPPlannedOrderInfo)info.clone();
                info.setQty(oldQty.subtract(ajustQty));
                info.setFinalProductsQty(oldQty.subtract(ajustQty));
                info.setBaseQty(oldQty.subtract(ajustQty));
                this.setPlannedOrderEntryQty(ctx, info, new BigDecimal(1).subtract(ajustRate), diffday, false);
                if (oldTotalReleaseQty.compareTo(info.getQty()) > 0) {
                    info.setTotalReleaseQty(info.getQty());
                    oldTotalReleaseQty = oldTotalReleaseQty.subtract(info.getQty());
                } else {
                    oldTotalReleaseQty = BigDecimal.ZERO;
                }
                if (oldScheduleQty.compareTo(info.getQty()) > 0) {
                    info.setScheduleQty(info.getQty());
                    oldScheduleQty = oldScheduleQty.subtract(info.getQty());
                } else {
                    oldScheduleQty = BigDecimal.ZERO;
                }
                needUpdateInfo = true;
                if (newInfo != null) {
                    BOSUuid newpkid = BOSUuid.create((String)"46D6DB79");
                    newInfo.setNumber(null);
                    newInfo.setNumber(this.getPlannedOrderNumber(ctx, newInfo));
                    newInfo.setId(newpkid);
                    newInfo.setQty(ajustQty);
                    newInfo.setBaseTotalReleaseQty(BigDecimal.ZERO);
                    newInfo.setBaseQty(ajustQty);
                    newInfo.setScheduleQty(oldScheduleQty);
                    newInfo.setTotalReleaseQty(oldTotalReleaseQty);
                    if (diffday != 0 && ajustDate != null) {
                        if (xtBeginDate != null && xtEndDate != null) {
                            newInfo.setStartDate(xtBeginDate);
                            newInfo.setEndDate(xtEndDate);
                        } else {
                            Date fnewbeginDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)newInfo.getStartDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1);
                            Date fnewendDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)newInfo.getEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0);
                            newInfo.setStartDate(fnewbeginDate);
                            newInfo.setEndDate(fnewendDate);
                        }
                        newInfo.setAvilableDate(ajustDate);
                    }
                    this.setPlannedOrderEntryQty(ctx, newInfo, ajustRate, diffday, true);
                    newInfo.setFinalProductsQty(newInfo.getQty());
                    iPMRPPlannedOrder.save((CoreBaseInfo)newInfo);
                }
            } else {
                if (diffday != 0 && ajustDate != null) {
                    if (xtBeginDate != null && xtEndDate != null) {
                        newInfo.setStartDate(xtBeginDate);
                        newInfo.setEndDate(xtEndDate);
                    } else {
                        Date fnewbeginDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getStartDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1);
                        Date fnewendDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0);
                        info.setStartDate(fnewbeginDate);
                        info.setEndDate(fnewendDate);
                    }
                    info.setAvilableDate(ajustDate);
                }
                this.setPlannedOrderEntryQty(ctx, info, null, diffday, false);
                needUpdateInfo = true;
            }
        }
        if (needUpdateInfo) {
            info.setFinalProductsQty(info.getQty());
            iPMRPPlannedOrder.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        return info;
    }

    protected boolean plannedOrderNeedChange(PMRPPlannedOrderInfo info) {
        if (info.getTotalReleaseQty() != null && info.getTotalReleaseQty().compareTo(new BigDecimal(0)) > 0) {
            return true;
        }
        return info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED) || info.getBaseStatus().equals((Object)com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED);
    }

    protected void setPlannedOrderEntryQty(Context ctx, PMRPPlannedOrderInfo info, BigDecimal ajustRate, int diffday, boolean isaddnew) throws BOSException, EASBizException {
        PMRPPlannedOrderEntryInfo entryInfo;
        int i;
        if (info == null) {
            return;
        }
        if (ajustRate != null && ajustRate.compareTo(new BigDecimal(1)) != 0 && info.getEntries() != null && info.getEntries().size() > 0) {
            for (i = 0; i < info.getEntries().size(); ++i) {
                entryInfo = info.getEntries().get(i);
                entryInfo.setDemandQty(entryInfo.getDemandQty().multiply(ajustRate));
                entryInfo.setBaseDemandQty(entryInfo.getBaseDemandQty().multiply(ajustRate));
                if (!isaddnew) continue;
                entryInfo.setParent(info);
                entryInfo.setId(BOSUuid.create((String)"16B48079"));
            }
        }
        if (info.getEntries() != null && info.getEntries().size() > 0 && diffday != 0) {
            for (i = 0; i < info.getEntries().size(); ++i) {
                entryInfo = info.getEntries().get(i);
                if (entryInfo.getReqDate() == null) continue;
                Date fnewbeginDate = info.getStartDate();
                entryInfo.setReqDate(fnewbeginDate);
            }
        }
    }

    protected void updatePlannedOrderQty(Context ctx, PMRPPlannedOrderInfo info, BigDecimal ajustRate, BigDecimal ajustQty) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update t_mrp_pmrpplannedorder set fbaseqty = fbaseqty - ");
        sql.append(ajustQty);
        sql.append(" , fqty = fqty - ");
        sql.append(ajustQty);
        sql.append(" , FFinalProductsQty = FFinalProductsQty - ");
        sql.append(ajustQty);
        sql.append(" where fid = '").append(info.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_mrp_pmrpplannedorderentry set fdemandqty = fdemandqty - fdemandqty * ");
        sql.append(ajustRate);
        sql.append(" , fbasedemandqty = fbasedemandqty - fbasedemandqty * ");
        sql.append(ajustRate);
        sql.append(" , FStandardQty = FStandardQty - FStandardQty * ");
        sql.append(ajustRate);
        sql.append(" where fparentid = '").append(info.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_mrp_pmrpplannedorder set fbasestatus = 7 ");
        sql.append(" where fid = '").append(info.getId()).append("' and fbaseqty <= 0");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void adjustManuOrderStatus(Context ctx, String fid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_mm_mftordertechnics set fbasestatus = ");
        sql.append(14);
        sql.append(" where fparentid = '").append(fid).append("'");
        sql.append(" and fbasestatus = ");
        sql.append(15);
        sql.append(" and ffinishedqty >= fqty ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_mm_manufactureorder h set fbasestatus = ");
        sql.append(8);
        sql.append(" where fid = '").append(fid).append("'");
        sql.append(" and not exists(Select 1 from t_mm_mftordertechnics d where d.fparentid = '").append(fid).append("' and d.fbasestatus <> ");
        sql.append(14);
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        ManufactureOrderInfo manu = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(fid));
        sql.setLength(0);
        if (manu.getBaseStatus() != com.kingdee.eas.scm.common.BillBaseStatusEnum.COMPLETE) {
            sql.append(" update t_mm_mftordertechnics set fbasestatus = ");
            sql.append(manu.getBaseStatus().getValue());
            sql.append(" where fparentid = '").append(fid).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else {
            sql.append(" update t_mm_mftordertechnics set fbasestatus = ");
            sql.append(14);
            sql.append(" where fparentid = '").append(fid).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void setManufactureOrderQty(Context ctx, ManufactureOrderInfo manuOrderInfo, BigDecimal qty) throws BOSException, EASBizException {
        manuOrderInfo.setQty(qty);
        manuOrderInfo.setBaseQty(qty);
        BigDecimal actualQty = qty;
        BigDecimal yield = manuOrderInfo.getYield();
        BigDecimal convertRate = new BigDecimal(1);
        BigDecimal extraRatio = new BigDecimal(0);
        MaterialPlanInfo materialPlanInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(manuOrderInfo.getMaterial().getId().toString(), manuOrderInfo.getStorageOrgUnit().getId().toString());
        if (materialPlanInfo.isIsQuotaControl() && materialPlanInfo.getIssInHightLimit() != null) {
            extraRatio = manuOrderInfo.getExtraRatio();
        }
        BigDecimal lackRatio = new BigDecimal(0);
        if (materialPlanInfo.isIsQuotaControl() && materialPlanInfo.getIssInLowLimit() != null) {
            lackRatio = manuOrderInfo.getLackRatio();
        }
        int precision = 2;
        MultiMeasureUnitCollection multUnitColl = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(" where material.id = '" + manuOrderInfo.getMaterial().getId() + "' and measureUnit.id = '" + manuOrderInfo.getUnit().getId() + "'");
        if (multUnitColl != null && multUnitColl.size() > 0) {
            precision = multUnitColl.get(0).getQtyPrecision();
        }
        manuOrderInfo.setDeliveryQty(actualQty.multiply(yield.divide(new BigDecimal(100)).setScale(precision, 4)));
        manuOrderInfo.setDeliveryBaseQty(manuOrderInfo.getDeliveryQty().multiply(convertRate).setScale(precision));
        BigDecimal extraUpperLimit = extraRatio.divide(new BigDecimal("100.00"), 4, 4).add(new BigDecimal("1.0")).multiply(actualQty);
        manuOrderInfo.setExtraUpperLimit(extraUpperLimit);
        manuOrderInfo.setExtraUpperLimitBase(manuOrderInfo.getExtraUpperLimit().multiply(convertRate).setScale(precision));
        BigDecimal lackLowerLimit = new BigDecimal("1.0").subtract(lackRatio.divide(new BigDecimal("100.00"), 4, 4)).multiply(actualQty);
        manuOrderInfo.setLackLowerLimit(lackLowerLimit);
        manuOrderInfo.setLackLowerLimitBase(manuOrderInfo.getLackLowerLimit().multiply(convertRate).setScale(precision));
        manuOrderInfo.setUnRepairQty(manuOrderInfo.getQty());
        manuOrderInfo.setUnRepairBaseQty(manuOrderInfo.getUnRepairQty().multiply(convertRate).setScale(precision));
        boolean isUnLimitQTY = false;
        if (materialPlanInfo.getRcvInHightLimit() == null && materialPlanInfo.getRcvInLowLimit() == null) {
            isUnLimitQTY = true;
        }
        if (isUnLimitQTY) {
            manuOrderInfo.setUnToStoreQty(manuOrderInfo.getQty().subtract(manuOrderInfo.getToStroreQty()));
            manuOrderInfo.setUnToStoreBaseQty(manuOrderInfo.getBaseQty().subtract(manuOrderInfo.getToStoreBaseQty()));
        } else {
            manuOrderInfo.setUnToStoreQty(manuOrderInfo.getExtraUpperLimit().subtract(manuOrderInfo.getToStroreQty()));
            manuOrderInfo.setUnToStoreBaseQty(manuOrderInfo.getExtraUpperLimitBase().subtract(manuOrderInfo.getToStoreBaseQty()));
        }
    }

    protected EMMManufactureOrderChangeInfo createManuOrderChangeBill(Context ctx, ManufactureOrderInfo info, BigDecimal ajustQty, int diffday, int FAjustType) throws BOSException, EASBizException {
        EMMManufactureOrderChangeInfo changeInfo = new EMMManufactureOrderChangeInfo();
        changeInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        changeInfo.setBillBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        changeInfo.setChangeReason(this.getResourceString(ctx, this.resClassName, "PROJECT_XMJHDDJYTZ"));
        changeInfo.setSourceBillId(info.getId().toString());
        changeInfo.setBizDate(new Date());
        AutoNumberUtil.initNumber((Context)ctx, (IObjectValue)changeInfo);
        EMMManufactureOrderChangeEntryInfo changeentryInfo = new EMMManufactureOrderChangeEntryInfo();
        changeentryInfo.setManuOrder(info);
        MaterialInfo m = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        changeentryInfo.setMaterial(m);
        changeentryInfo.setMaterialNum(m.getNumber());
        changeentryInfo.setOrderStatus(info.getBaseStatus());
        changeentryInfo.setOldQty(info.getQty());
        changeentryInfo.setNewQty(info.getQty().subtract(ajustQty));
        changeentryInfo.setOldPlanBeginDate((Date)info.getPlanBeginDate());
        changeentryInfo.setOldPlanEndDate((Date)info.getPlanEndDate());
        if (diffday != 0) {
            Date fnewbeginDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanBeginDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 1);
            Date fnewendDate = this.getNewDate(ctx, new Timestamp(DateUtil.addDay((Date)info.getPlanEndDate(), (int)diffday).getTime()), info.getStorageOrgUnit().getId().toString(), 0);
            changeentryInfo.setNewPlanBeginDate(fnewbeginDate);
            changeentryInfo.setNewPlanEndDate(fnewendDate);
        } else {
            changeentryInfo.setNewPlanBeginDate((Date)info.getPlanBeginDate());
            changeentryInfo.setNewPlanEndDate((Date)info.getPlanEndDate());
        }
        changeentryInfo.setParent(changeInfo);
        changeInfo.getEntrys().add(changeentryInfo);
        IEMMManufactureOrderChange imc = EMMManufactureOrderChangeFactory.getLocalInstance((Context)ctx);
        IObjectPK pk = imc.addnew((CoreBaseInfo)changeInfo);
        imc.submit((CoreBaseInfo)changeInfo);
        changeInfo = imc.getEMMManufactureOrderChangeInfo(pk);
        imc.passAudit(pk, (CoreBillBaseInfo)changeInfo);
        return changeInfo;
    }

    protected String getCalDetialIDStr(Context ctx, String ftableName, String fid) throws BOSException, EASBizException {
        String fdetialIDStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        sql.append(" distinct a.fid ");
        sql.append(" From ").append(ftableName).append(" a ");
        sql.append(" Inner Join ").append(ftableName).append(" b ");
        sql.append(" on b.FMaterialID = a.FMaterialID ");
        sql.append(" and b.FMRPClassify = a.FMRPClassify ");
        sql.append(" and b.FMRPItem = a.FMRPItem ");
        sql.append(" and b.FBillID = a.FBillID ");
        sql.append(" and isnull(b.FBillEntryID, 'null') = isnull(a.FBillEntryID, 'null') ");
        sql.append(" and b.FSupplyOrgUnitID = a.FSupplyOrgUnitID ");
        sql.append(" and isnull(b.FPROJECTID, '*') = isnull(a.FPROJECTID, '*') ");
        sql.append(" and isnull(b.FTRACKID, '*') = isnull(a.FTRACKID, '*') ");
        sql.append(" and b.FAjustFlag = a.FAjustFlag ");
        sql.append(" and isnull(b.FRePlanDATE, to_date('1970-01-01')) = isnull(a.FRePlanDATE, to_date('1970-01-01')) ");
        sql.append(" and b.FMaterialAttr = a.FMaterialAttr ");
        sql.append(" where b.fid = '").append(fid).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (fdetialIDStr == null) {
                    fdetialIDStr = "'" + rs.getString("fid") + "'";
                    continue;
                }
                fdetialIDStr = fdetialIDStr + ",'" + rs.getString("fid") + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return fdetialIDStr;
    }

    private SelectorItemCollection getPurOrderSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.isInternalCompany"));
        sic.add(new SelectorItemInfo("supplier.taxRate"));
        sic.add(new SelectorItemInfo("supplier.isOuter"));
        sic.add(new SelectorItemInfo("supplier.internalCompany"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchasePerson.id"));
        sic.add(new SelectorItemInfo("purchasePerson.name"));
        sic.add(new SelectorItemInfo("purchasePerson.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.CU.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.CU.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("cashDiscount.id"));
        sic.add(new SelectorItemInfo("cashDiscount.name"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.cashDiscType"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.id"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.number"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.name"));
        sic.add(new SelectorItemInfo("entries.material.useAsstAttrRelation"));
        sic.add(new SelectorItemInfo("entries.nonummaterialmodel"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.coefficient"));
        sic.add(new SelectorItemInfo("entries.unit.isBaseUnit"));
        sic.add(new SelectorItemInfo("entries.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.name"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.assistUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("entries.assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.baseUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("entries.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.requestOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.requestOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.requestOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.rowType.id"));
        sic.add(new SelectorItemInfo("entries.rowType.name"));
        sic.add(new SelectorItemInfo("entries.rowType.number"));
        sic.add(new SelectorItemInfo("entries.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("entries.rowType.precision"));
        sic.add(new SelectorItemInfo("entries.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("entries.rowType.destinationType"));
        sic.add(new SelectorItemInfo("entries.wareHouse.id"));
        sic.add(new SelectorItemInfo("entries.wareHouse.name"));
        sic.add(new SelectorItemInfo("entries.wareHouse.number"));
        sic.add(new SelectorItemInfo("entries.qcStandard.id"));
        sic.add(new SelectorItemInfo("entries.qcStandard.name"));
        sic.add(new SelectorItemInfo("entries.qcStandard.number"));
        sic.add(new SelectorItemInfo("entries.project.id"));
        sic.add(new SelectorItemInfo("entries.project.name"));
        sic.add(new SelectorItemInfo("entries.project.number"));
        sic.add(new SelectorItemInfo("entries.trackNo.id"));
        sic.add(new SelectorItemInfo("entries.trackNo.name"));
        sic.add(new SelectorItemInfo("entries.trackNo.number"));
        sic.add(new SelectorItemInfo("entries.purContractID.id"));
        sic.add(new SelectorItemInfo("entries.purContractID.name"));
        sic.add(new SelectorItemInfo("entries.purContractID.number"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.id"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.id"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.name"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.number"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.isInternalCompany"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.taxRate"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.isOuter"));
        sic.add(new SelectorItemInfo("entries.entries.supplier.supplier.internalCompany"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.expenseType.number"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.id"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.name"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.number"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("entries.entries.expenseItem.defaultUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("paymentCondition.id"));
        sic.add(new SelectorItemInfo("paymentCondition.name"));
        sic.add(new SelectorItemInfo("paymentCondition.number"));
        sic.add(new SelectorItemInfo("warehouse.id"));
        sic.add(new SelectorItemInfo("warehouse.name"));
        sic.add(new SelectorItemInfo("warehouse.number"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("isMatched"));
        sic.add(new SelectorItemInfo("unPrepaidAmount"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("entries.oldID"));
        sic.add(new SelectorItemInfo("isNetOrder"));
        sic.add(new SelectorItemInfo("entries.netQuotationItemId"));
        sic.add(new SelectorItemInfo("purType.id"));
        sic.add(new SelectorItemInfo("purType.number"));
        sic.add(new SelectorItemInfo("entries.endTrackNo.id"));
        sic.add(new SelectorItemInfo("entries.endTrackNo.name"));
        sic.add(new SelectorItemInfo("entries.endTrackNo.number"));
        return sic;
    }

    protected BigDecimal getNextBillIssueQtyFromStockID(Context ctx, ManufactureOrderStockInfo stocksInfo) throws BOSException, EASBizException, SQLException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        BigDecimal fissueqty = BigDecimal.ZERO;
        sql.append(" Select  Isnull(sum( case  h.fbasestatus when 4  then  Isnull(d.fqty,0)  else Isnull(d.fissueqty,0) end),0)  as fissueqty ");
        sql.append(" from t_im_materialreqbill h \r\n ");
        sql.append(" inner join t_im_materialreqbillentry d on h.fid = d.fparentid \r\n ");
        sql.append(" where d.fcorebillentryid = '").append(stocksInfo.getId()).append("' \r\n ");
        sql.append(" and h.fbasestatus in (0,1,2,4) \r\n ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            fissueqty = rs.getBigDecimal("fissueqty");
        }
        return fissueqty;
    }

    protected String getdefFactoryCalendarID(Context ctx, String forgID) throws BOSException, EASBizException {
        String fid = "";
        if (this.fcOrgMap == null || this.fcOrgMap.size() < 1 || !this.fcOrgMap.containsKey(forgID)) {
            if (this.fcOrgMap == null) {
                this.fcOrgMap = new HashMap<String, String>();
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" Select top 1 fid from T_MM_FactoryCalendar a \r\n");
            sql.append(" where a.Fstorageorgunitid = '").append(forgID).append("' \r\n");
            sql.append(" and a.Fisdefault = 1 \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    fid = rs.getString("fid");
                }
                if (fid == null) {
                    fid = "";
                }
                this.fcOrgMap.put(forgID, fid);
                return fid;
            }
            catch (SQLException e) {
                e.printStackTrace();
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
        return this.fcOrgMap.get(forgID).toString();
    }

    protected Date getNewDate(Context ctx, Date oldDate, String forgID, int updateWay) throws BOSException, EASBizException {
        String ffcID = this.getdefFactoryCalendarID(ctx, forgID);
        if (ffcID == null || "".equals(ffcID)) {
            return oldDate;
        }
        Date newDate = oldDate;
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("FWorkDate \"FWorkDate\"\r\n");
        sql.append("From T_MM_FactoryCalendarEntry \r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FParentID='").append(ffcID).append("'\r\n");
        sql.append("And FWorkDate Is Not Null\r\n");
        sql.append("And (\r\n");
        sql.append("FDateType=").append(1).append("\r\n");
        sql.append("Or FDateType=").append(4).append("\r\n");
        sql.append(")\r\n");
        if (updateWay == 0) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate ASC\r\n");
        } else if (updateWay == 1) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate DESC\r\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                newDate = rs.getDate("FWorkDate");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return newDate;
    }

    protected Timestamp getNewDateTimeStamp(Context ctx, Date oldDate, String forgID, int updateWay) throws BOSException, EASBizException {
        String ffcID = this.getdefFactoryCalendarID(ctx, forgID);
        if (ffcID == null || "".equals(ffcID)) {
            return new Timestamp(oldDate.getTime());
        }
        Date newDate = oldDate;
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("FWorkDate \"FWorkDate\"\r\n");
        sql.append("From T_MM_FactoryCalendarEntry \r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FParentID='").append(ffcID).append("'\r\n");
        sql.append("And FWorkDate Is Not Null\r\n");
        sql.append("And (\r\n");
        sql.append("FDateType=").append(1).append("\r\n");
        sql.append("Or FDateType=").append(4).append("\r\n");
        sql.append(")\r\n");
        if (updateWay == 0) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate ASC\r\n");
        } else if (updateWay == 1) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate DESC\r\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                newDate = rs.getDate("FWorkDate");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return new Timestamp(newDate.getTime());
    }

    protected Integer getDiffDays(Date date1, Date date2) throws BOSException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String day1 = sdf.format(date1);
        String day2 = sdf.format(date2);
        try {
            date1 = sdf.parse(day1);
            date2 = sdf.parse(day2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        Integer changeDays = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return changeDays;
    }
}

