/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.MergeDimensionEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.AbstractPMRPRunFacadeControllerBean;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.runner.PMRPRunner;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.runner.impl.PMRPRunner4Global;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ProcessBomLLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.ProcessBOMExpandTableDefine;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestFactory;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestInfo;
import com.kingdee.eas.scm.sm.pur.IBOMPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class PMRPRunFacadeControllerBean
extends AbstractPMRPRunFacadeControllerBean {
    private static final long serialVersionUID = -4364522813742512290L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.mrp.app.PMRPRunFacadeControllerBean");
    private String Resource_Name = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    private String resClassName = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    private static final WeakHashMap<String, PMRPRunner> runners = new WeakHashMap();

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runPMRP(Context ctx, IObjectValue runLog) throws BOSException, PMRPException {
        PMRPRunLogInfo runLogInfo = (PMRPRunLogInfo)runLog;
        boolean isPMRPTraceSQL = false;
        if (runLogInfo != null && runLogInfo.get("isPMRPTraceSQL") != null && ((Boolean)runLogInfo.get("isPMRPTraceSQL")).booleanValue()) {
            isPMRPTraceSQL = true;
        }
        if (runLogInfo != null && runLogInfo.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            try {
                PMRPRunLogCollection c = new PMRPRunLogCollection();
                c.add(runLogInfo);
                try {
                    AutoNumberUtil.initNumber((Context)ctx, (IObjectCollection)c);
                }
                catch (EASBizException e) {
                    runLogInfo.setNumber(runLogInfo.getId().toString());
                    System.out.println("------------------------------MRP(GEN_PLANORDER_NUMBER_FAILED) coding rule exsists,failed to gen number AutoNumberUtil.initNumber(runParam.getEasCtx(), coll);----------------------------------");
                    e.printStackTrace();
                    System.out.println("-----------------------------------------------------------------------------------------------------------------------------------------");
                }
                PMRPRunLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)runLogInfo);
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("storageOrgUnit.*"));
                sic.add(new SelectorItemInfo("planDefined.*"));
                sic.add(new SelectorItemInfo("planDefined.SupplyRelation.*"));
                sic.add(new SelectorItemInfo("planDefined.PurchaseRelation.*"));
                sic.add(new SelectorItemInfo("entrys.*"));
                sic.add(new SelectorItemInfo("runSettings.*"));
                sic.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
                runLogInfo = PMRPRunLogFactory.getLocalInstance(ctx).getPMRPRunLogInfo((IObjectPK)new ObjectUuidPK(runLogInfo.getId()), sic);
                runLogInfo.setStatus(PMRPStepStatusEnum.RUNNING);
            }
            catch (Exception e) {
                e.printStackTrace();
                runLogInfo.setNumber(runLogInfo.getId().toString());
            }
            finally {
                sic.clear();
                sic.add(new SelectorItemInfo("status"));
                try {
                    PMRPRunLogFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)runLogInfo, sic);
                }
                catch (EASBizException e) {
                    throw new PMRPException(new NumericExceptionSubItem("", "failed to save logInfo"), e);
                }
            }
        }
        runLogInfo.put("isPMRPTraceSQL", isPMRPTraceSQL);
        PMRPRunner4Global runner = new PMRPRunner4Global(ctx);
        runner.run(runLogInfo);
        runners.put(runLogInfo.getId().toString(), runner);
    }

    @Override
    protected IObjectValue _getRunLog(Context ctx, BOSUuid logID) throws BOSException, PMRPException {
        return null;
    }

    @Override
    protected void _stopMRP(Context ctx, BOSUuid runLogID) throws BOSException, PMRPException {
        block6: {
            String querySql = "select rl.FCreatorID,rl.FStatus,user0.FNumber from T_MRP_PMRPRunLog rl left join t_pm_user user0 on rl.fcreatorid=user0.fid where rl.fid=?";
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{runLogID.toString()});
            try {
                if (rs.next()) {
                    if (!ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(rs.getString("FCreatorID"))) {
                        throw new PMRPException(PMRPException.CAN_STOP_RUNNING, new Object[]{rs.getString("FNumber")});
                    }
                    int status = rs.getInt("FStatus");
                    if (status != 40) {
                        throw new PMRPException(PMRPException.RUN_END);
                    }
                    break block6;
                }
                throw new PMRPException(PMRPException.NO_MRP_RUNLOG);
            }
            catch (SQLException e) {
                logger.error((Object)("failed to stop pmrp actvity. id=" + runLogID), (Throwable)e);
            }
        }
        String updateSql = "update T_MRP_PMRPRunLog set FLastUpdateTime = ?, fstatus = ?, FDescription = ?  where fid = ?";
        SQLUtils.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), new Integer(50), this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "PROJECT_YHZZMRP"), runLogID.toString()});
        if (runners.containsKey(runLogID.toString())) {
            runners.get(runLogID.toString()).shutDownNow();
        }
    }

    private void validateBill(Context ctx, BOMPurRequestInfo info) throws EASBizException {
        StringBuilder tips = new StringBuilder();
        if (info.getMaterial() == null) {
            tips.append(this.getResourceString(ctx, this.resClassName, "PROJECT_WL"));
        }
        if (info.getProjectNo() == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append(this.getResourceString(ctx, this.resClassName, "PROJECT_XM"));
        }
        if (info.getBigTrackNumber() == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append(this.getResourceString(ctx, this.resClassName, "PROJECT_KSGZH"));
        }
        if (info.getEndTrackNumber() == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append(this.getResourceString(ctx, this.resClassName, "PROJECT_JSGZH"));
        }
        if (tips.length() > 0) {
            tips.insert(0, this.getResourceString(ctx, this.resClassName, "PROJECT_QTX"));
            throw new EASBizException(new NumericExceptionSubItem("", tips.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] _getServerFileContent(Context ctx, String filePath) throws BOSException, EASBizException {
        ByteArrayOutputStream buffer = null;
        FileInputStream in = null;
        try {
            buffer = new ByteArrayOutputStream();
            File file = new File(System.getProperty("EAS_HOME") + File.separator + filePath);
            if (!file.exists()) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_WJBCZ") + file.getPath()));
            }
            try {
                in = new FileInputStream(file);
                int len = -1;
                byte[] bytes = new byte[1024];
                while ((len = in.read(bytes)) > 0) {
                    buffer.write(bytes, 0, len);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _doFilePartBillWrittenOffAndAudit(Context ctx, BOMPurRequestInfo billInfo, IObjectCollection writteOffBills) throws BOSException, EASBizException {
        this.validateBill(ctx, billInfo);
        IBOMPurRequest ctrl = BOMPurRequestFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection update4BomPur = new CoreBaseCollection();
        CoreBaseCollection update4PurRequirement = new CoreBaseCollection();
        for (int i = 0; i < writteOffBills.size(); ++i) {
            IObjectValue ov = writteOffBills.getObject(i);
            if (ov instanceof BOMPurRequestEntryInfo) {
                update4BomPur.addObject(ov);
                continue;
            }
            if (!(ov instanceof PurRequirementEntryInfo)) continue;
            update4PurRequirement.addObject(ov);
        }
        if (!update4BomPur.isEmpty()) {
            BOMPurRequestEntryFactory.getLocalInstance((Context)ctx).update(update4BomPur);
        }
        if (!update4PurRequirement.isEmpty()) {
            PurRequirementEntryFactory.getLocalInstance((Context)ctx).update(update4PurRequirement);
        }
        ctrl.audit(billInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getFilePartBillWrittenOffBills(Context ctx, BOMPurRequestInfo billInfo) throws BOSException, EASBizException {
        this.validateBill(ctx, billInfo);
        MaterialInfo mInfo = billInfo.getMaterial();
        ProjectInfo pInfo = billInfo.getProjectNo();
        BOMPurRequestEntryCollection entrys = billInfo.getEntry();
        if (entrys.isEmpty()) {
            return new CoreBillEntryBaseCollection();
        }
        PMRPCalcParam param = new PMRPCalcParam(ctx, false);
        ProcessBomLLCComputer computer = new ProcessBomLLCComputer();
        for (int i = 0; i < entrys.size(); ++i) {
            computer.calcLLC(param, pInfo.getId().toString(), mInfo.getId().toString(), entrys.get(i).getTrackNumber().getId().toString());
        }
        String tableName = param.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class).getTableName();
        if (StringUtil.isEmptyString((String)tableName)) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, this.resClassName, "PROJECT_BOMZKSB"), this.getResourceString(ctx, this.resClassName, "PROJECT_AGZHZKDQWLSB")));
        }
        CoreBillEntryBaseCollection updates = new CoreBillEntryBaseCollection();
        try {
            String key;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT distinct FParentMaterialID,FMaterialID,FProjectID,FTrackNumberID,FQty,FLevel FROM " + tableName + " ORDER BY FLevel"));
            HashMap<String, TreeNode> cache = new HashMap<String, TreeNode>();
            try {
                while (rs.next()) {
                    TreeNode node;
                    String pmID = rs.getString("FParentMaterialID");
                    String mID = rs.getString("FMaterialID");
                    String pID = rs.getString("FProjectID");
                    String tnID = rs.getString("FTrackNumberID");
                    key = pID + "@" + tnID;
                    if (StringUtil.isEmptyString((String)pmID)) {
                        cache.put(key, new TreeNode(mID, rs.getBigDecimal("FQty")));
                        continue;
                    }
                    TreeNode root = (TreeNode)cache.get(key);
                    if (root == null || (node = root.searchNode(pmID)) == null) continue;
                    node.addChild(new TreeNode(mID, rs.getBigDecimal("FQty")));
                }
            }
            catch (SQLException e) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, this.resClassName, "PROJECT_JYCXSLJSSB")));
            }
            if (cache.isEmpty()) {
                CoreBillEntryBaseCollection e = new CoreBillEntryBaseCollection();
                return e;
            }
            for (int i = 0; i < entrys.size(); ++i) {
                key = pInfo.getId().toString() + "@" + entrys.get(i).getTrackNumber().getId().toString();
                ((TreeNode)cache.get((Object)key)).qty = entrys.get(i).getQty();
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT *,parent.number,parent.projectNo.*,parent.material.*,tracknumber.* WHERE ID IN");
            sql.append("(");
            sql.append("SELECT entrys.FID FROM CT_PUR_BOMPurRequestEntry entrys");
            sql.append(" INNER JOIN CT_PUR_BOMPurRequest head ON entrys.FParentID=head.FID");
            sql.append(" INNER JOIN ").append(tableName).append(" llc");
            sql.append(" ON llc.FProjectID=head.CFProjectNoID AND llc.FMaterialID=head.CFMaterialID AND llc.FTrackNumberID=entrys.CFTrackNumberID");
            sql.append(") AND parent.billType=").append("1");
            sql.append(" AND parent.id<>'").append(billInfo.getId()).append("'");
            sql.append(" AND status = ").append(4);
            entrys = BOMPurRequestEntryFactory.getLocalInstance((Context)ctx).getBOMPurRequestEntryCollection(sql.toString());
            if (entrys.size() != 0) {
                for (int i = 0; i < entrys.size(); ++i) {
                    BOMPurRequestEntryInfo e = entrys.get(i);
                    key = e.getParent().getProjectNo().getId() + "@" + e.getTrackNumber().getId();
                    BigDecimal qty = ((TreeNode)cache.get(key)).searchNode(e.getParent().getMaterial().getId().toString()).calcQty();
                    if (qty.compareTo(e.getQty()) <= 0) {
                        e.put("suggestQty", (Object)qty);
                    } else {
                        e.put("suggestQty", (Object)e.getQty());
                    }
                    BigDecimal s = e.getBigDecimal("suggestQty");
                    if (BigDecimal.ZERO.equals(s)) continue;
                    updates.add((CoreBillEntryBaseInfo)e);
                }
            }
            sql.setLength(0);
            sql.append("SELECT *,parent.*,material.*,project.*,trackNo.* WHERE ID IN (").append("\r\n");
            sql.append("SELECT entry.FID FROM T_SM_PurRequirementEntry entry").append("\r\n");
            sql.append("INNER JOIN T_SM_PurRequirement head on entry.FParentID = head.FID").append("\r\n");
            sql.append("INNER JOIN ").append(tableName).append(" llc ON llc.FProjectID = entry.FProjectID AND llc.FMaterialID = entry.FMaterialID AND llc.FTrackNumberID = entry.FTrackNoID").append("\r\n");
            sql.append("WHERE head.FSourceBillTypeID = '/4qVQGTpQS2XmR1OXz8xnUY+1VI='").append("\r\n");
            sql.append("AND head.FBaseStatus = ").append(4).append("\r\n");
            sql.append(")");
            PurRequirementEntryCollection entrys2 = PurRequirementEntryFactory.getLocalInstance((Context)ctx).getPurRequirementEntryCollection(sql.toString());
            if (entrys2.size() > 0) {
                for (int i = 0; i < entrys2.size(); ++i) {
                    PurRequirementEntryInfo e = entrys2.get(i);
                    key = e.getProject().getId() + "@" + e.getTrackNo().getId();
                    BigDecimal qty = ((TreeNode)cache.get(key)).searchNode(e.getMaterial().getId().toString()).calcQty();
                    if (qty.compareTo(e.getQty()) <= 0) {
                        e.put("suggestQty", (Object)qty);
                    } else {
                        e.put("suggestQty", (Object)e.getQty());
                    }
                    BigDecimal s = e.getBigDecimal("suggestQty");
                    if (BigDecimal.ZERO.equals(s)) continue;
                    updates.add((CoreBillEntryBaseInfo)e);
                }
            }
        }
        finally {
            param.getTableManager().realeaseTempTableDefine(ctx, ProcessBOMExpandTableDefine.class);
            param.getTableManager().realeaseTempTableDefine(ctx, BOMLLCTableDefine.class);
        }
        return updates;
    }

    @Override
    protected String _getBOMExpandResult(Context ctx, String inTable, int bomType, PMRPCalcParam runParam) throws BOSException, PMRPException {
        String returnTableSql = this.getReturnTableSQL();
        String returnTable = MMUtils.createTmpTable((Context)ctx, (String)returnTableSql);
        MMUtils.createTableIndex((Context)ctx, (String)returnTable, (String[])new String[]{"FTraceID"});
        MMUtils.createTableIndex((Context)ctx, (String)returnTable, (String[])new String[]{"fchildmaterialid,FSupplyStorageOrgUnitID"});
        MMUtils.createTableIndex((Context)ctx, (String)returnTable, (String[])new String[]{"FDaySeq"});
        StringBuffer sb = new StringBuffer();
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        PurRelationshipDefinitionInfo info = pdInfo.getPurchaseRelation();
        if (bomType == 1) {
            this.expandProcessBom(runParam.getEasCtx(), returnTable, inTable, info.getId(), runParam);
        }
        if (bomType == 2) {
            this.expand908040BOM(runParam.getEasCtx(), returnTable, inTable, bomType, info.getId(), runParam);
        }
        PMRPRunTableManager manager = runParam.getTableManager();
        String calendarTable = manager.getTempTableDefine(FactoryCalendarTableDefine.class).getTableName();
        if (pdInfo.getMergeDimension() != null && pdInfo.getMergeDimension().equals((Object)MergeDimensionEnum.ByReqDate)) {
            if (bomType == 2) {
                try {
                    sb.setLength(0);
                    sb.append(" Select FChildMaterialID,FSupplyStorageOrgUnitID,fprojectid,ftrackid,fprojectplanmodelid  ");
                    sb.append(" from ").append(returnTable).append(" t1 ");
                    sb.append(" where exists (Select h.fid ");
                    sb.append(" from T_PCP_ProjectCP h \r\n");
                    sb.append(" left outer JOIN t_mm_project P ON P.FID= h.fprojectid \r\n");
                    sb.append(" left outer JOIN t_mm_tracknumber T ON T.FID= h.ftracknumberid  \r\n");
                    sb.append(" WHERE h.fstate = ").append(4).append("");
                    sb.append("  AND h.Fstorageorgunitid  = '" + runParam.getRunLog().getPlanDefined().getStorageOrg().getId().toString() + "' ");
                    sb.append("  AND h.fqty  > 0 ");
                    sb.append("  AND P.fbasestatus = 4 ");
                    sb.append("  AND t.FStatus <> 80 ");
                    sb.append("  AND h.fmaterialid = t1.FChildMaterialID ");
                    sb.append("  AND h.Fprojectid = t1.fprojectid  ");
                    sb.append("  AND h.ftracknumberid = t1.ftrackid ");
                    sb.append("  AND h.fprojectplanmodelid = t1.fprojectplanmodelid  ");
                    sb.append("  AND h.Ffinishtime is not null )");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    IRowSet rs2 = null;
                    while (rs.next()) {
                        String FChildMaterialID = rs.getString("FChildMaterialID");
                        String FSupplyStorageOrgUnitID = rs.getString("FSupplyStorageOrgUnitID");
                        String fprojectid = rs.getString("fprojectid");
                        String ftrackid = rs.getString("ftrackid");
                        String fprojectplanmodelid = rs.getString("fprojectplanmodelid");
                        sb.setLength(0);
                        sb.append(" Select min(h.Fstarttime) As FNeedBeginDate, ");
                        sb.append(" (case when Max(h.Ffinishtime) is null then null else to_date(CONCAT(to_char(Max(h.Ffinishtime), 'yyyy-MM-dd'), ' 00:00:00')) end )  As fDate ");
                        sb.append(" from T_PCP_ProjectCP h \r\n");
                        sb.append(" inner join T_PCP_ProjectCPSE morg on  morg.FParentID = h.FID");
                        sb.append(" and not exists(select 1 from T_PCP_ProjectCPSE e where e.FParentID = h.FID and e.FSeq < morg.FSeq)");
                        sb.append(" WHERE h.fstate = ").append(4).append("");
                        sb.append("  AND h.Fstorageorgunitid  = '" + runParam.getRunLog().getPlanDefined().getStorageOrg().getId().toString() + "' ");
                        sb.append("  AND h.fqty  > 0 ");
                        sb.append("  AND h.fmaterialid = ?  ");
                        sb.append("  AND morg.fstorageorgunitid = ? ");
                        sb.append("  AND h.Fprojectid = ?  ");
                        sb.append("  AND h.ftracknumberid = ?  ");
                        sb.append("  AND h.fprojectplanmodelid = ?  ");
                        sb.append("  AND h.Ffinishtime is not null  ");
                        rs2 = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{FChildMaterialID, FSupplyStorageOrgUnitID, fprojectid, ftrackid, fprojectplanmodelid});
                        while (rs2.next()) {
                            if (rs2.getDate("fDate") == null || rs2.getDate("FNeedBeginDate") == null) continue;
                            sb.setLength(0);
                            sb.append("update ").append(returnTable).append(" t1 ");
                            sb.append(" set FNeedBeginDate = ?, fDate = ? ");
                            sb.append("  where FChildMaterialID = ? ");
                            sb.append("  AND FSupplyStorageOrgUnitID = ?  ");
                            sb.append("  AND fprojectid = ?   ");
                            sb.append("  AND t1.ftrackid = ? ");
                            sb.append("  AND t1.fprojectplanmodelid = ?  ");
                            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{rs2.getDate("FNeedBeginDate"), rs2.getDate("fDate"), FChildMaterialID, FSupplyStorageOrgUnitID, fprojectid, ftrackid, fprojectplanmodelid});
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
        } else {
            Date toDate = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String thisDate = df.format(toDate);
            sb.setLength(0);
            sb.append("update ").append(returnTable).append(" t1 ");
            sb.append(" set fDate= to_date('" + thisDate + "'||' 00:00:00')");
            MRPUtil.executeUpdate((Context)ctx, (String)sb.toString());
        }
        sb.setLength(0);
        sb.append("update ").append(returnTable).append(" t1 ");
        sb.append(" set FDaySeq= ");
        sb.append(" Isnull((select c.FRWorkDateSeq ");
        sb.append(" from ").append(calendarTable).append(" c ");
        sb.append(" where t1.fDate = c.FRealDate");
        sb.append(" AND c.FStorageOrgUnitID = t1.FSupplyStorageOrgUnitID");
        sb.append("), (select c.FRWorkDateSeq from ").append(calendarTable).append(" c ");
        sb.append(" where t1.fDate = c.FRealDate");
        sb.append(" AND c.FStorageOrgUnitID = '").append(runParam.getStorageOrgUnitID()).append("'");
        sb.append("))");
        sb.append(" where Isnull(t1.FDaySeq,0) <= 0 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" delete from ").append(returnTable);
        sb.append(" where fmaterialAttr = '10020'");
        MRPUtil.executeUpdate((Context)ctx, (String)sb.toString());
        return returnTable;
    }

    private boolean isContainsMTSMaterial(Context ctx, String inTable) throws BOSException, PMRPException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(1) AS COUNT FROM ").append(inTable).append(" WHERE FManufactureStrategyID = '").append("NUnM+gEcEADgAA3cwKgL09g0uEU=").append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean flag = false;
        try {
            flag = rs.next() && rs.getInt("COUNT") > 0;
        }
        catch (Exception e) {
            throw new PMRPException(new NumericExceptionSubItem("", "failed to fetch process bom summarize data"), e);
        }
        return flag;
    }

    private void expandProcessBom(Context easCtx, String returnTable, String inTable, BOSUuid purRelationshipDefinitionID, PMRPCalcParam runParam) throws BOSException, PMRPException {
        int effectedRows1 = 0;
        boolean effectedRows2 = false;
        StringBuilder sb = new StringBuilder();
        for (int level = 0; level < 50; ++level) {
            sb.setLength(0);
            sb.append(this.getInsertTableSQL(returnTable)).append(" \r\n");
            sb.append(" Select \r\n");
            if (level == 0) {
                sb.append("bom.cfmaterialid As FChildMaterialID ");
                sb.append(",Isnull(bomentry.foutputtype,10740) As FOutputType ");
                sb.append(",m.fbaseunit As fBaseUnitId  ");
                sb.append(",a.FBaseQty * bom.cfration As FBaseQty  ");
                sb.append(",a.FBaseQty * bom.cfration As fPerfectBaseQty  ");
                sb.append(",a.FBaseQty * bom.cfration As fPerfectProductQty ");
                sb.append(",m.fbaseunit As fProductUnitId ");
                sb.append(",a.FBaseQty * bom.cfration As FProductQty  ");
                sb.append(",bom.cfdrawbillorgid As FSupplyStorageOrgUnitID ");
                sb.append(",bom.fid as FParentBOMID ");
                sb.append(",Isnull(bomentry.fprovidetype,10910) As FProvideType ");
                sb.append(",a.FTraceID As FTraceID ");
                sb.append(",a.FDate As fDate ");
                sb.append(",Null As FDaySeq ");
                sb.append(",bom.cfstorageorgunitid As fstorageOrgUnitId ");
                sb.append(",Null As fBomEntryBillId ");
                sb.append(",Null As fBomEntryId ");
                sb.append(",bom.cfration As FUnitQty ");
                sb.append(",newbosid('").append(Constants.BosType.MRP_PLAN_ORDER_ENTRY).append("') as FPlannedOrderEntryID ");
                sb.append(",Isnull(bomentry.fscrapratio,0) As fScrapRatio ");
                sb.append(",0 As fScrapRateExpression ");
                sb.append(",mi.fdefaultwarehouseid As FDefaultWarehouseID ");
                sb.append(",Null As FLocationID ");
                sb.append(",Isnull(mp.fisbackflush,0) As FIsBackFlush ");
                sb.append(",Isnull(bomentry.fisstocktransfer,0) As FIsStockTransfer ");
                sb.append(",bomentry.ftransferorgunitid As FTransferOrgUnitID ");
                sb.append(",bomentry.ftransferwarehouseid As FTransferWarehouseID ");
                sb.append(",Isnull(bomentry.fissmode,11010) As FIssMode ");
                sb.append(",Isnull(bomentry.fnetweight,0) As fnetweight ");
                sb.append(",Isnull(bomentry.fblksize,0) As FBlkSize ");
                sb.append(",Isnull(bomentry.fspecifiedlength,0) As FSpecifiedLength ");
                sb.append(",Null As fOperationNo ");
                sb.append(",Isnull(bom.cfmaterialproperty,mp.fmaterialattr) As fmaterialAttr");
                sb.append(",").append(level).append("  As flevel");
                sb.append(",a.FProjectID  As fprojectid");
                sb.append(",bom.FmainTenanceLevelID  As FmainTenanceLevelID");
                sb.append(",bom.FissueProp  As FissueProp");
                sb.append(",a.FTrackNumberID As ftrackid ");
                sb.append(",t.fnumber As ftracknumber ");
                sb.append(",mpEx.fdistributionorgunitid as FdispatchOrgUnitID");
                sb.append(",(case isnull(r0.FToUnitID,'*') when isnull(r1.FToUnitID,'*') then 0 else (case bom.cfmaterialproperty when 10030 then 1 else 0  end) end) as FisInnerZS");
                sb.append(",(case bom.cfmaterialproperty when 10030 then  a.fprojectplanmodelid else null end) As fprojectplanmodelid ");
                sb.append(" From ct_zjb_processbombill bom");
                sb.append(" inner Join ").append(inTable).append(" a on a.FMaterialID = bom.cfparentid and bom.cfstorageorgunitid = a.FStorageorgUnitID ");
                sb.append(" left outer join  t_bd_material m on m.fid = bom.cfmaterialid");
                sb.append(" left outer join  t_bd_materialplan mp on mp.fmaterialid = bom.cfmaterialid and mp.forgunit = bom.cfdrawbillorgid");
                sb.append(" left outer join  t_mat_emmmaterialplan mpEx on mpEx.fstorageorgunitid = bom.cfstorageorgunitid and mpEx.fmaterialid = bom.cfmaterialid ");
                sb.append(" left outer join  t_bd_materialinventory mi on mi.fmaterialid = bom.cfmaterialid and mi.forgunit = bom.cfdrawbillorgid");
                sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=bom.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=bom.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" Left Outer Join  t_mm_bomentry bomentry on bomentry.fsourceprocessid = bom.fid ");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bom.cfbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bom.cfendcarnoid");
                sb.append(" left outer join  t_mm_trackNumber t on t.fid = a.FTrackNumberID");
                sb.append(" where bom.cfstate = 4");
                sb.append(" and (bom.cfprojectid = a.FProjectID or bom.cfprojectid is null) ");
                sb.append(" and bom.cfration > 0");
                sb.append(" and (bt.fnumber <= t.fnumber or bom.cfbegincarnoid is null) ");
                sb.append(" and (et.fnumber >= t.fnumber or bom.cfendcarnoid is null) ");
                sb.append(" and (mp.FIssMode<>").append(11040);
                sb.append(" or bom.cfmaterialproperty in (").append(10040);
                sb.append(",").append(10050);
                sb.append("))");
                sb.append(" and (bom.CFBomMaterialPro=").append("0").append(" or bom.CFBomMaterialPro is null)");
                effectedRows1 = this.executeSQL(easCtx, sb.toString());
            } else {
                sb.append("bom.cfmaterialid As FChildMaterialID ");
                sb.append(",Isnull(bomentry.foutputtype,10740) As FOutputType ");
                sb.append(",m.fbaseunit As fBaseUnitId  ");
                sb.append(",a.FBaseQty * bom.cfration As FBaseQty  ");
                sb.append(",a.fPerfectBaseQty * bom.cfration As fPerfectBaseQty  ");
                sb.append(",a.fPerfectProductQty * bom.cfration As fPerfectProductQty ");
                sb.append(",m.fbaseunit As fProductUnitId ");
                sb.append(",a.FProductQty * bom.cfration As FProductQty  ");
                sb.append(",bom.cfdrawbillorgid As FSupplyStorageOrgUnitID ");
                sb.append(",bom.fid as FParentBOMID ");
                sb.append(",Isnull(bomentry.fprovidetype,10910) As FProvideType ");
                sb.append(",a.FTraceID As FTraceID ");
                sb.append(",a.fDate As fDate ");
                sb.append(",Null As FDaySeq ");
                sb.append(",bom.cfstorageorgunitid As fstorageOrgUnitId ");
                sb.append(",Null As fBomEntryBillId ");
                sb.append(",Null As fBomEntryId ");
                sb.append(",bom.cfration * a.FUnitQty As FUnitQty ");
                sb.append(",newbosid('").append(Constants.BosType.MRP_PLAN_ORDER_ENTRY).append("') as FPlannedOrderEntryID ");
                sb.append(",Isnull(bomentry.fscrapratio,0) As fScrapRatio ");
                sb.append(",0 As fScrapRateExpression ");
                sb.append(",mi.fdefaultwarehouseid As FDefaultWarehouseID ");
                sb.append(",Null As FLocationID ");
                sb.append(",Isnull(mp.fisbackflush,0) As FIsBackFlush ");
                sb.append(",Isnull(bomentry.fisstocktransfer,0) As FIsStockTransfer ");
                sb.append(",bomentry.ftransferorgunitid As FTransferOrgUnitID ");
                sb.append(",bomentry.ftransferwarehouseid As FTransferWarehouseID ");
                sb.append(",Isnull(bomentry.fissmode,11010) As FIssMode ");
                sb.append(",Isnull(bomentry.fnetweight,0) As fnetweight ");
                sb.append(",Isnull(bomentry.fblksize,0) As FBlkSize ");
                sb.append(",Isnull(bomentry.fspecifiedlength,0) As FSpecifiedLength ");
                sb.append(",Null As fOperationNo ");
                sb.append(",Isnull(bom.cfmaterialproperty,mp.fmaterialattr) As fmaterialAttr");
                sb.append(",").append(level).append("  As flevel");
                sb.append(",a.fprojectid  As fprojectid");
                sb.append(",bom.FmainTenanceLevelID  As FmainTenanceLevelID");
                sb.append(",bom.FissueProp  As FissueProp");
                sb.append(",a.ftrackid As ftrackid ");
                sb.append(",a.ftracknumber As ftracknumber ");
                sb.append(",mpEx.fdistributionorgunitid as FdispatchOrgUnitID");
                sb.append(",(case isnull(r0.FToUnitID,'*') when isnull(r1.FToUnitID,'*') then 0 else (case bom.cfmaterialproperty  when 10030 then 1 else 0  end) end) as FisInnerZS");
                sb.append(",(case bom.cfmaterialproperty when 10030 then  a.fprojectplanmodelid else null end) As fprojectplanmodelid ");
                sb.append(" From ct_zjb_processbombill bom");
                sb.append(" inner Join ").append(returnTable).append(" a on a.FChildMaterialID = bom.cfparentid and bom.cfstorageorgunitid = a.FSupplyStorageOrgUnitID  ");
                sb.append(" left outer join  t_bd_material m on m.fid = bom.cfmaterialid");
                sb.append(" left outer join  t_bd_materialplan mp on mp.fmaterialid = bom.cfmaterialid and mp.forgunit = bom.cfdrawbillorgid");
                sb.append(" left outer join  t_mat_emmmaterialplan mpEx on mpEx.fstorageorgunitid = bom.cfstorageorgunitid and mpEx.fmaterialid = bom.cfmaterialid ");
                sb.append(" left outer join  t_bd_materialinventory mi on mi.fmaterialid = bom.cfmaterialid and mi.forgunit = bom.cfdrawbillorgid ");
                sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=bom.cfdrawbillorgid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=bom.cfstorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" Left Outer Join  t_mm_bomentry bomentry on bomentry.fsourceprocessid = bom.fid ");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bom.cfbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bom.cfendcarnoid");
                sb.append(" where bom.cfstate = 4");
                sb.append(" and (bom.cfprojectid = a.fprojectid or bom.cfprojectid is null)  ");
                sb.append(" and isnull(bom.FmainTenanceLevelID,'*') = isnull(a.FmainTenanceLevelID,'*')  ");
                sb.append(" and bom.cfration > 0");
                sb.append(" and (bt.fnumber <= a.ftracknumber or bom.cfbegincarnoid is null)  ");
                sb.append(" and (et.fnumber >= a.ftracknumber or bom.cfendcarnoid is null)  ");
                sb.append(" and a.flevel = " + (level - 1) + "");
                sb.append(" and a.fmaterialAttr = '10020'");
                sb.append(" and (mp.FIssMode<>").append(11040);
                sb.append(" or bom.cfmaterialproperty in (").append(10040);
                sb.append(",").append(10050);
                sb.append("))");
                sb.append(" and (bom.CFBomMaterialPro=").append("0").append(" or bom.CFBomMaterialPro is null ) ");
                effectedRows1 = this.executeSQL(easCtx, sb.toString());
            }
            if (effectedRows1 <= 0) break;
        }
    }

    private void expand908040BOM(Context easCtx, String returnTable, String inTable, int bomType, BOSUuid purRelationshipDefinitionID, PMRPCalcParam runParam) throws BOSException, PMRPException {
        int effectedRows = 0;
        StringBuilder sb = new StringBuilder();
        for (int level = 0; level < 50; ++level) {
            effectedRows = 0;
            sb.setLength(0);
            sb.append(this.getInsertTableSQL(returnTable)).append(" \r\n");
            sb.append(" Select \r\n");
            if (level == 0) {
                sb.append("bomentry.fmaterialid As FChildMaterialID ");
                sb.append(",Isnull(bomentry.foutputtype,10740) As FOutputType ");
                sb.append(",m.fbaseunit As fBaseUnitId  ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty As FBaseQty  ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty  As fPerfectBaseQty  ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty As fPerfectProductQty ");
                sb.append(",m.fbaseunit As fProductUnitId ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty  As FProductQty  ");
                sb.append(",bomentry.fsupplystorageorgunitid As FSupplyStorageOrgUnitID ");
                sb.append(",bom.fid as FParentBOMID ");
                sb.append(",bomentry.fprovidetype As FProvideType ");
                sb.append(",a.FTraceID As FTraceID ");
                sb.append(",a.FDate + Isnull(bomentry.FLeadtime,0)  As fDate ");
                sb.append(",Null As FDaySeq ");
                sb.append(",bom.fstorageorgunitid As fstorageOrgUnitId ");
                sb.append(",bomentry.fid As fBomEntryBillId ");
                sb.append(",bomentry.fid As fBomEntryId ");
                sb.append(",bomentry.fconsumefixqty / bom.fproductqty  As FUnitQty ");
                sb.append(",newbosid('").append(Constants.BosType.MRP_PLAN_ORDER_ENTRY).append("') as FPlannedOrderEntryID ");
                sb.append(",bomentry.fscrapratio As fScrapRatio ");
                sb.append(",0 As fScrapRateExpression ");
                sb.append(",mi.fdefaultwarehouseid As FDefaultWarehouseID ");
                sb.append(",Null As FLocationID ");
                sb.append(",isnull(mp.fisbackflush,0) As FIsBackFlush ");
                sb.append(",bomentry.fisstocktransfer As FIsStockTransfer ");
                sb.append(",bomentry.ftransferorgunitid As FTransferOrgUnitID ");
                sb.append(",bomentry.ftransferwarehouseid As FTransferWarehouseID ");
                sb.append(",bomentry.fissmode As FIssMode ");
                sb.append(",bomentry.fnetweight As fnetweight ");
                sb.append(",bomentry.fblksize As FBlkSize ");
                sb.append(",bomentry.fspecifiedlength As FSpecifiedLength ");
                sb.append(",Null As fOperationNo ");
                sb.append(",isnull(bomentry.fmaterialprop,mp.fmaterialattr) As fmaterialAttr");
                sb.append(",").append(level).append("  As flevel");
                sb.append(",a.FProjectID As FProjectID ");
                sb.append(",bom.FmainTenanceLevelID  As FmainTenanceLevelID");
                sb.append(",bomentry.FissueProp  As FissueProp");
                sb.append(",a.FTrackNumberID As ftrackid ");
                sb.append(",t.fnumber As ftracknumber ");
                sb.append(",mpEx.fdistributionorgunitid as FdispatchOrgUnitID");
                sb.append(",(case isnull(r0.FToUnitID,'*') when isnull(r1.FToUnitID,'*') then 0 else (case bomentry.fmaterialprop when 10030 then 1 else 0  end) end) as FisInnerZS");
                sb.append(",(case bomentry.fmaterialprop when 10030 then  a.fprojectplanmodelid else null end) As fprojectplanmodelid ");
                sb.append(" From t_mm_bom bom");
                sb.append(" inner Join ").append(inTable).append(" a on a.FMaterialID = bom.fmaterialid and bom.fstorageorgunitid = a.FStorageorgUnitID  ");
                sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                sb.append(" left outer join  t_bd_material m on m.fid = bomentry.fmaterialid");
                sb.append(" left outer join  t_bd_materialplan mp on mp.fmaterialid =  bomentry.fmaterialid and mp.forgunit = bomentry.fsupplystorageorgunitid");
                sb.append(" left outer join  t_mat_emmmaterialplan mpEx on mpEx.fstorageorgunitid = bom.fstorageorgunitid and mpEx.fmaterialid = bomentry.fmaterialid ");
                sb.append(" left outer join  t_bd_materialinventory mi on mi.fmaterialid = bomentry.fmaterialid and mi.forgunit = bomentry.fsupplystorageorgunitid");
                sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=bom.fstorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=bomentry.fsupplystorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bomentry.fbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bomentry.fendcarnoid");
                sb.append(" left outer join  t_mm_trackNumber t on t.fid = a.FTrackNumberID");
                sb.append(" where bom.fbasestatus = 4");
                sb.append(" and bomentry.fconsumefixqty > 0");
                sb.append(" and (bomentry.FIssMode<>").append(11040);
                sb.append(" or bomentry.fmaterialprop not in (").append(10040);
                sb.append(",").append(10050);
                sb.append("))");
                sb.append(" and Isnull(bomentry.FISOwnObject,0) =0");
                sb.append(" and (bom.fprojectID = a.FProjectID or bom.fprojectID is null)  \r\n");
                sb.append(" and (bt.fnumber <= t.fnumber or bomentry.fbegincarnoid is null)  ");
                sb.append(" and (et.fnumber >= t.fnumber or bomentry.fendcarnoid is null)");
                sb.append(" and bom.FdesignModeid is not null ");
                sb.append(" and not exists(select 1 from ct_zjb_processbombill pbom where pbom.fid = bomentry.fsourceprocessid and pbom.CFBomMaterialPro <>").append("0").append(")");
            } else {
                sb.append("bomentry.fmaterialid As FChildMaterialID ");
                sb.append(",Isnull(bomentry.foutputtype,10740) As FOutputType ");
                sb.append(",m.fbaseunit As fBaseUnitId  ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty As FBaseQty  ");
                sb.append(",(a.fPerfectBaseQty * bomentry.fconsumefixqty) / bom.fproductqty As fPerfectBaseQty  ");
                sb.append(",(a.fPerfectProductQty * bomentry.fconsumefixqty) / bom.fproductqty As fPerfectProductQty ");
                sb.append(",m.fbaseunit As fProductUnitId ");
                sb.append(",(a.FProductQty * bomentry.fconsumefixqty) / bom.fproductqty As FProductQty  ");
                sb.append(",bomentry.fsupplystorageorgunitid As FSupplyStorageOrgUnitID ");
                sb.append(",bom.fid as FParentBOMID ");
                sb.append(",bomentry.fprovidetype As FProvideType ");
                sb.append(",a.FTraceID As FTraceID ");
                sb.append(",a.FDate + Isnull(bomentry.FLeadtime,0) As fDate ");
                sb.append(",Null As FDaySeq ");
                sb.append(",bom.fstorageorgunitid As fstorageOrgUnitId ");
                sb.append(",bomentry.fid As fBomEntryBillId ");
                sb.append(",bomentry.fid As fBomEntryId ");
                sb.append(",(a.FBaseQty * bomentry.fconsumefixqty) / bom.fproductqty /a.FBaseQty * a.FUnitQty As FUnitQty ");
                sb.append(",newbosid('").append(Constants.BosType.MRP_PLAN_ORDER_ENTRY).append("') as FPlannedOrderEntryID ");
                sb.append(",bomentry.fscrapratio As fScrapRatio ");
                sb.append(",0 As fScrapRateExpression ");
                sb.append(",mi.fdefaultwarehouseid As FDefaultWarehouseID ");
                sb.append(",Null As FLocationID ");
                sb.append(",isnull(mp.fisbackflush,0) As FIsBackFlush ");
                sb.append(",bomentry.fisstocktransfer As FIsStockTransfer ");
                sb.append(",bomentry.ftransferorgunitid As FTransferOrgUnitID ");
                sb.append(",bomentry.ftransferwarehouseid As FTransferWarehouseID ");
                sb.append(",bomentry.fissmode As FIssMode ");
                sb.append(",bomentry.fnetweight As fnetweight ");
                sb.append(",bomentry.fblksize As FBlkSize ");
                sb.append(",bomentry.fspecifiedlength As FSpecifiedLength ");
                sb.append(",Null As fOperationNo ");
                sb.append(",isNull(bomentry.fmaterialprop,mp.fmaterialattr) As fmaterialAttr");
                sb.append(",").append(level).append("  As flevel");
                sb.append(",a.FProjectID As FProjectID ");
                sb.append(",bom.FmainTenanceLevelID  As FmainTenanceLevelID");
                sb.append(",bomentry.FissueProp  As FissueProp");
                sb.append(",a.ftrackid As ftrackid ");
                sb.append(",a.ftracknumber As ftracknumber ");
                sb.append(",mpEx.fdistributionorgunitid as FdispatchOrgUnitID");
                sb.append(",(case isnull(r0.FToUnitID,'*') when isnull(r1.FToUnitID,'*') then 0 else (case bomentry.fmaterialprop when 10030 then 1 else 0  end) end) as FisInnerZS");
                sb.append(",(case bomentry.fmaterialprop when 10030 then  a.fprojectplanmodelid else null end) As fprojectplanmodelid ");
                sb.append(" From t_mm_bom bom");
                sb.append(" inner Join ").append(returnTable).append(" a on a.FChildMaterialID = bom.fmaterialid and bom.fstorageorgunitid = a.FSupplyStorageOrgUnitID   ");
                sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                sb.append(" left outer join  t_bd_material m on m.fid = bomentry.fmaterialid");
                sb.append(" left outer join  t_bd_materialplan mp on mp.fmaterialid =  bomentry.fmaterialid and mp.forgunit = bomentry.fsupplystorageorgunitid");
                sb.append(" left outer join  t_mat_emmmaterialplan mpEx on mpEx.fstorageorgunitid = bom.fstorageorgunitid and mpEx.fmaterialid = bomentry.fmaterialid ");
                sb.append(" left outer join  t_bd_materialinventory mi on mi.fmaterialid = bomentry.fmaterialid and mi.forgunit = bomentry.fsupplystorageorgunitid");
                sb.append(" left join T_ORG_UnitRelation r0 on r0.FFromUnitID=bom.fstorageorgunitid and r0.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left join T_ORG_UnitRelation r1 on r1.FFromUnitID=bomentry.fsupplystorageorgunitid and r1.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bomentry.fbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bomentry.fendcarnoid");
                sb.append(" where bom.fbasestatus = 4");
                sb.append(" and bomentry.fconsumefixqty > 0");
                sb.append(" and a.flevel = " + (level - 1) + "");
                sb.append(" and a.fmaterialAttr = '10020'");
                sb.append(" and (bomentry.FIssMode<>").append(11040);
                sb.append(" or bomentry.fmaterialprop not in (").append(10040);
                sb.append(",").append(10050);
                sb.append("))");
                sb.append(" and Isnull(bomentry.FISOwnObject,0)=0");
                sb.append(" and (bom.fprojectID = a.FProjectID or bom.fprojectID is null)  \r\n");
                sb.append(" and (bt.fnumber <= a.ftracknumber or bomentry.fbegincarnoid is null)  ");
                sb.append(" and (et.fnumber >= a.ftracknumber or bomentry.fendcarnoid is null)");
                sb.append(" and bom.FdesignModeid is not null ");
                sb.append(" and isnull(bom.FmainTenanceLevelID,'*') = isnull(a.FmainTenanceLevelID,'*') ");
                sb.append(" and not exists(select 1 from ct_zjb_processbombill pbom where pbom.fid = bomentry.fsourceprocessid and pbom.CFBomMaterialPro <>").append("0").append(")");
            }
            effectedRows = this.executeSQL(easCtx, sb.toString());
            if (effectedRows <= 0) break;
        }
    }

    private String getReturnTableSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(" create table returnTable ( ");
        sb.append("FChildMaterialID varchar(44)");
        sb.append(",FOutputType int");
        sb.append(",fBaseUnitId VARCHAR(44) ");
        sb.append(",FBaseQty NUMERIC(21, 8) ");
        sb.append(",fPerfectBaseQty NUMERIC(21, 8) ");
        sb.append(",fPerfectProductQty NUMERIC(21, 8) ");
        sb.append(",fProductUnitId VARCHAR(44)");
        sb.append(",FProductQty NUMERIC(21, 8) ");
        sb.append(",FSupplyStorageOrgUnitID varchar(44)");
        sb.append(",FParentBOMID varchar(44)");
        sb.append(",FProvideType int");
        sb.append(",FTraceID varchar(44)");
        sb.append(",fDate datetime");
        sb.append(",FDaySeq int");
        sb.append(",fstorageOrgUnitId varchar(44)");
        sb.append(",fBomEntryBillId varchar(44)");
        sb.append(",fBomEntryId varchar(44)");
        sb.append(",FUnitQty NUMERIC(21, 8)");
        sb.append(",FPlannedOrderEntryID VARCHAR(44)");
        sb.append(",fScrapRatio NUMERIC(21, 8) default 0 not null");
        sb.append(",fScrapRateExpression int default 0 not null");
        sb.append(",FDefaultWarehouseID VARCHAR(44)");
        sb.append(",FLocationID VARCHAR(44)");
        sb.append(",FIsBackFlush int default 0 not null");
        sb.append(",FIsStockTransfer int default 0 not null");
        sb.append(",FTransferOrgUnitID VARCHAR(44)");
        sb.append(",FTransferWarehouseID VARCHAR(44)");
        sb.append(",FIssMode int default 0 not null");
        sb.append(",fnetweight NUMERIC(21, 8) default 0 not null");
        sb.append(",FBlkSize VARCHAR(100)");
        sb.append(",FSpecifiedLength VARCHAR(100)");
        sb.append(",fOperationNo INT");
        sb.append(",fmaterialAttr INT");
        sb.append(",flevel INT");
        sb.append(",fprojectid VARCHAR(44)");
        sb.append(",fmainTenanceLevelID VARCHAR(44)");
        sb.append(",fissueProp INT");
        sb.append(",ftrackid VARCHAR(44) ");
        sb.append(",FdispatchOrgUnitID VARCHAR(44) ");
        sb.append(",FisInnerZS INT ");
        sb.append(",FisZSPur INT ");
        sb.append(",ftracknumber VARCHAR(150) ");
        sb.append(",FNeedBeginDate datetime");
        sb.append(",fprojectplanmodelid VARCHAR(44) ");
        sb.append(")");
        return sb.toString();
    }

    protected String getInsertTableSQL(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into ").append(tableName).append("(\r\n");
        sb.append("FChildMaterialID ");
        sb.append(",FOutputType ");
        sb.append(",fBaseUnitId  ");
        sb.append(",FBaseQty  ");
        sb.append(",fPerfectBaseQty  ");
        sb.append(",fPerfectProductQty ");
        sb.append(",fProductUnitId ");
        sb.append(",FProductQty  ");
        sb.append(",FSupplyStorageOrgUnitID ");
        sb.append(",FParentBOMID ");
        sb.append(",FProvideType ");
        sb.append(",FTraceID ");
        sb.append(",fDate ");
        sb.append(",FDaySeq ");
        sb.append(",fstorageOrgUnitId ");
        sb.append(",fBomEntryBillId ");
        sb.append(",fBomEntryId ");
        sb.append(",FUnitQty ");
        sb.append(",FPlannedOrderEntryID ");
        sb.append(",fScrapRatio ");
        sb.append(",fScrapRateExpression ");
        sb.append(",FDefaultWarehouseID ");
        sb.append(",FLocationID ");
        sb.append(",FIsBackFlush ");
        sb.append(",FIsStockTransfer ");
        sb.append(",FTransferOrgUnitID ");
        sb.append(",FTransferWarehouseID ");
        sb.append(",FIssMode");
        sb.append(",fnetweight ");
        sb.append(",FBlkSize ");
        sb.append(",FSpecifiedLength ");
        sb.append(",fOperationNo ");
        sb.append(",fmaterialAttr");
        sb.append(",flevel");
        sb.append(",fprojectid");
        sb.append(",fmainTenanceLevelID ");
        sb.append(",fissueProp ");
        sb.append(",ftrackid");
        sb.append(",ftracknumber");
        sb.append(",FdispatchOrgUnitID");
        sb.append(",FisInnerZS");
        sb.append(",fprojectplanmodelid");
        sb.append(")");
        return sb.toString();
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    @Override
    protected String _getBomByTrcAndPrjID(Context ctx, String materialID, String projectID, String TrackID, String storageOrgUnitID, int bomType) throws BOSException, PMRPException {
        String fbomid = null;
        IRowSet rs = null;
        try {
            TrackNumberInfo trackInfo = null;
            if (TrackID != null && !"".equals(TrackID)) {
                try {
                    trackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(TrackID));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            if (bomType == 1) {
                sb.append(" Select \r\n");
                sb.append(" top 1 bom.fid As fbomid ");
                sb.append(" From ct_zjb_processbombill bom");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bom.cfbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bom.cfendcarnoid");
                sb.append(" where bom.cfstate = 4");
                sb.append(" and bom.cfparentid = '").append(materialID).append("'");
                sb.append(" and bom.cfstorageorgunitid = '").append(storageOrgUnitID).append("'");
                sb.append(PMRPCalcParam.getSqlWhereETO20("bom.Cfparentid", "bom.Cfstorageorgunitid"));
                if (projectID != null && !"".equals(projectID)) {
                    sb.append(" and bom.cfprojectid = '").append(projectID).append("'");
                } else {
                    sb.append(" and bom.cfprojectid is null");
                }
                if (trackInfo != null) {
                    sb.append(" and bt.fnumber <= '").append(trackInfo.getNumber()).append("'");
                    sb.append(" and et.fnumber >= '").append(trackInfo.getNumber()).append("'");
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString())).next()) {
                    fbomid = rs.getString("fbomid");
                }
                if (fbomid == null || "".equals(fbomid)) {
                    sb.setLength(0);
                    sb.append(" Select \r\n");
                    sb.append(" top 1 bom.fid As fbomid ");
                    sb.append(" From t_mm_bom bom");
                    sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                    sb.append(" where bom.fbasestatus = 4");
                    sb.append(" and bomentry.fconsumefixqty > 0");
                    sb.append(" and bom.fmaterialid = '").append(materialID).append("'");
                    sb.append(" and bom.fstorageorgunitid = '").append(storageOrgUnitID).append("'");
                    sb.append(PMRPCalcParam.getSqlWhereMTS("bom.fmaterialid", "bom.fstorageorgunitid"));
                    sb.append(" and bom.fprojectid is null ");
                    sb.append(" and bom.fbomtype = ").append(40).append(" \r\n");
                    sb.append(" and bom.FUsageType = ").append(10).append(" \r\n");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    if (rs.next()) {
                        fbomid = rs.getString("fbomid");
                    }
                }
            } else {
                sb.append(" Select \r\n");
                sb.append(" top 1 bom.fid As fbomid ");
                sb.append(" From t_mm_bom bom");
                sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bomentry.fbegincarnoid");
                sb.append(" left outer join  t_mm_trackNumber et on et.fid = bomentry.fendcarnoid");
                sb.append(" where bom.fbasestatus = 4");
                sb.append(" and bomentry.fconsumefixqty > 0");
                sb.append(" and bom.fmaterialid = '").append(materialID).append("'");
                sb.append(" and bom.fstorageorgunitid = '").append(storageOrgUnitID).append("'");
                sb.append(PMRPCalcParam.getSqlWhereETO20("bom.fmaterialid", "bom.fstorageorgunitid"));
                if (projectID != null && !"".equals(projectID)) {
                    sb.append(" and bom.fprojectid = '").append(projectID).append("'");
                } else {
                    sb.append(" and bom.fprojectid is null ");
                }
                sb.append(" And bom.fbomtype = ").append(90).append(" \r\n");
                sb.append(" and exists(Select 1 from t_bas_param bh inner join t_bas_paramitem bd on bh.fid = bd.fkeyid \r\n ");
                sb.append(" where bh.fnumber = 'PMRP_USELDBOM' and bd.forgunitid = bom.fstorageorgunitid and bd.fvalue_l2 = 'true' ) \r\n ");
                if (trackInfo != null) {
                    sb.append(" and bt.fnumber <= '").append(trackInfo.getNumber()).append("'");
                    sb.append(" and et.fnumber >= '").append(trackInfo.getNumber()).append("'");
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString())).next()) {
                    fbomid = rs.getString("fbomid");
                }
                if (fbomid == null || "".equals(fbomid)) {
                    sb.setLength(0);
                    sb.append(" Select \r\n");
                    sb.append(" top 1 bom.fid As fbomid ");
                    sb.append(" From t_mm_bom bom");
                    sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                    sb.append(" left outer join  t_mm_trackNumber bt on bt.fid = bomentry.fbegincarnoid");
                    sb.append(" left outer join  t_mm_trackNumber et on et.fid = bomentry.fendcarnoid");
                    sb.append(" where bom.fbasestatus = 4");
                    sb.append(" and bomentry.fconsumefixqty > 0");
                    sb.append(" and bom.fmaterialid = '").append(materialID).append("'");
                    sb.append(" and bom.fstorageorgunitid = '").append(storageOrgUnitID).append("'");
                    sb.append(PMRPCalcParam.getSqlWhereETO20("bom.fmaterialid", "bom.fstorageorgunitid"));
                    if (projectID != null && !"".equals(projectID)) {
                        sb.append(" and bom.fprojectid = '").append(projectID).append("'");
                    } else {
                        sb.append(" and bom.fprojectid is null ");
                    }
                    sb.append(" And bom.fbomtype = ").append(80).append(" \r\n");
                    if (trackInfo != null) {
                        sb.append(" and bt.fnumber <= '").append(trackInfo.getNumber()).append("'");
                        sb.append(" and et.fnumber >= '").append(trackInfo.getNumber()).append("'");
                    }
                    if ((rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString())).next()) {
                        fbomid = rs.getString("fbomid");
                    }
                    if (fbomid == null || "".equals(fbomid)) {
                        sb.setLength(0);
                        sb.append(" Select \r\n");
                        sb.append(" top 1 bom.fid As fbomid ");
                        sb.append(" From t_mm_bom bom");
                        sb.append(" inner Join  t_mm_bomentry bomentry on bomentry.fparentid = bom.fid ");
                        sb.append(" where bom.fbasestatus = 4");
                        sb.append(" and bomentry.fconsumefixqty > 0");
                        sb.append(" and bom.fmaterialid = '").append(materialID).append("'");
                        sb.append(" and bom.fstorageorgunitid = '").append(storageOrgUnitID).append("'");
                        sb.append(PMRPCalcParam.getSqlWhereMTS("bom.fmaterialid", "bom.fstorageorgunitid"));
                        sb.append(" and bom.fprojectid is null ");
                        sb.append(" and bom.fbomtype = ").append(40).append(" \r\n");
                        sb.append(" and bom.FUsageType = ").append(10).append(" \r\n");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                        if (rs.next()) {
                            fbomid = rs.getString("fbomid");
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return fbomid;
    }

    private class TreeNode {
        TreeNode parent;
        List<TreeNode> children = new ArrayList<TreeNode>();
        String mID;
        BigDecimal qty;

        TreeNode(String mID, BigDecimal qty) {
            this.mID = mID;
            this.qty = qty;
        }

        void addChild(TreeNode child) {
            this.children.add(child);
            child.parent = this;
        }

        BigDecimal calcQty() {
            BigDecimal rootQty = this.qty;
            TreeNode p = this.parent;
            while (p != null) {
                rootQty = rootQty.multiply(p.qty);
                p = p.parent;
            }
            return rootQty;
        }

        TreeNode searchNode(String mID) {
            if (mID.equals(this.mID)) {
                return this;
            }
            for (TreeNode node : this.children) {
                if ((node = node.searchNode(mID)) == null) continue;
                return node;
            }
            return null;
        }
    }
}

