/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.platform;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.mm.basedata.BalanceAllocationRuleEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonUnitEnum;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.IProductionOrderStockEntry;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.IManufactureOrderStock;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.planning.IPlannedOrderEntry;
import com.kingdee.eas.mm.planning.PlannedOrderEntryFactory;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.report.IReportServer;
import com.kingdee.eas.mm.report.MRPResultReportTitles;
import com.kingdee.eas.mm.report.util.PeriodDivideInfo;
import com.kingdee.eas.mm.report.util.PlanerWorkUtil;
import com.kingdee.eas.scm.im.inv.IStockTransferBillEntry;
import com.kingdee.eas.scm.im.inv.ITransferOrderBillEntry;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurContractEntry;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurContractEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.sc.ISubContractOrderEntry;
import com.kingdee.eas.scm.sm.sc.ISubMaterialList;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListFactory;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PMRPPlanerWorkPlatformMaterialServer
extends ReportServerBase
implements IReportServer {
    private String calcDetailTbl;
    private String[] material;
    private String[] planVesion;
    private String[] storageUnit;
    private String resClassName = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    private static Logger logger = MMLogger.getLogger();
    private static final String REPORTTITLE = "reporttitle";
    private String[] planDate = new String[3];
    private String dayStatTable = null;
    private String weekStatTable = null;
    private String monthStatTable = null;
    private String periodStatTable = null;
    private MRPResultReportTitles reportTitles = null;
    private PlanDefinedInfo pvInfo = null;
    private boolean isMTS11 = false;

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    public HashMap<?, ?> getAjust(RptParams filter) throws BOSException, BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String billid = filter.getString("billid");
        String billRowSeq = filter.getString("billRowSeq");
        String id = filter.getString("id");
        String mrpItem = filter.getString("mrpItem");
        String trackNumber = filter.getString("trackNumber");
        this.prepareData(filter);
        IRowSet rs = null;
        String detailTbl = this.calcDetailTbl;
        StringBuffer sb = new StringBuffer();
        sb.append(" select t.fId as fcurId, u1.FQtyPrecision as FQtyPrecision,");
        if ("1".equals(this.material[1])) {
            sb.append(" t.FAjustQty as FAjustQty, \n");
        } else {
            sb.append("(case when t.FAjustFlag = 4 then t.FNetReq ");
            sb.append(" else (t.fsr-t.FAjustQty)  end )as FAjustQty, \n");
        }
        sb.append(" t.FAjustFlag as FAjustFlag, ");
        sb.append(" (case when t.FAjustFlag=4 then null when t.FAjustFlag=8 then t.FBillDate else caentry.FWorkDate end) as FReDate, ");
        sb.append("(case when t.FAjustFlag=4 or t.FAjustFlag=6 or t.FAjustFlag=8 then null else abs(t.FSPeriod -t.FPeriod) end)as fAjustDays ");
        sb.append(", t.FTrackNumber as FTrackNumber ");
        sb.append(" from ");
        sb.append(detailTbl);
        sb.append(" t  \n");
        sb.append("inner join T_MM_FactoryCalendar ca on ca.FStorageOrgUnitID = t.FSupplyOrgUnitID and ca.FIsDefault=1\n");
        sb.append("inner join T_MM_FactoryCalendarEntry caentry  on caentry.FWorkDateSeq = t.FPeriod and ca.FID = caentry.FParentID\n");
        sb.append("inner join t_bd_material m on m.fid=t.FMaterialID\n");
        sb.append("inner join t_bd_materialplan mp on mp.FMaterialID = t.FMaterialID and mp.forgunit=t.FOrgUnitID\n");
        sb.append("inner join T_BD_MultiMeasureUnit u1 on t.FMaterialID=u1.FMaterialID and m.FBaseUnit=u1.FMeasureUnitID\n");
        sb.append(" where t.fmaterialid = '");
        sb.append(this.material[0]);
        sb.append("' and t.FAjustFlag >0 ");
        if ("110".equals(mrpItem)) {
            sb.append(" and t.FSID='").append(id).append("' ");
            sb.append("and t.FTrackNumber<>'").append(trackNumber).append("' ");
        } else {
            sb.append(" and t.FBillId = '").append(billid);
            sb.append("' and t.FBillRowSeq = ");
            sb.append(billRowSeq);
        }
        sb.append(" order by caentry.FWorkDate\n");
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        logger.info((Object)("#########\u83b7\u53d6\u8c03\u6574\u5efa\u8baeSQL\uff1a" + sb.toString()));
        map.put("rs", rs);
        sb.setLength(0);
        sb.append(" select t.FSrcBillID as FSrcBillID,t.fbillid as fbillid ,t.fbillentryid as fbillentryid,");
        sb.append("t.fmrpitem as fmrpitem, t.FYield as FYield, t.FMaterialID as FMaterialID,");
        sb.append("FAvaliable as FQty,t.FOrgUnitID ");
        sb.append(" from ").append(detailTbl).append(" t  \n");
        sb.append(" where t.fid = '").append(id).append("'");
        IRowSet rowstet = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        this.getOrderQty(rowstet, map);
        return map;
    }

    private HashMap<String, Object> getOrderQty(IRowSet rs, HashMap<String, Object> map) throws BOSException, EASBizException {
        block48: {
            String id = null;
            try {
                rs.beforeFirst();
                String materialId = "";
                Locale locale = this.getContext().getLocale();
                StringBuffer sql = new StringBuffer();
                IRowSet orderRs = null;
                if (!rs.next() || rs.getObject("fmrpitem") == null) break block48;
                int mrpItem = new Integer(rs.getObject("fmrpitem").toString());
                map.put("yield", new BigDecimal("100").toString());
                map.put("materialId", rs.getObject("FMaterialID"));
                materialId = "" + rs.getObject("FMaterialID");
                switch (mrpItem) {
                    case 200: {
                        if (rs.getObject("fbillid") == null || "".equals((id = rs.getObject("fbillid").toString()).trim())) break;
                        IProductionOrder iProductionOrder = ProductionOrderFactory.getLocalInstance((Context)this.getContext());
                        ProductionOrderInfo info = iProductionOrder.getProductionOrderInfo("select qty,baseQty,unit.name,unit.qtyPrecision, yield, bom where id = '" + id + "'");
                        map.put("unit", info.getUnit());
                        map.put("qty", info.getQty());
                        map.put("baseQty", info.getBaseQty());
                        if (info.getYield() != null) {
                            map.put("yield", info.getYield().toString());
                            break;
                        }
                        if (info.getBom() != null) {
                            BomInfo bomInfo = this.getBomInfo(info.getBom().getId().toString());
                            if (bomInfo.getYield() != null) {
                                map.put("yield", bomInfo.getYield().toString());
                            }
                            break;
                        }
                        this.setMaterialPlanYield(materialId, rs.getString("FOrgUnitID"), map);
                        break;
                    }
                    case 250: {
                        if (rs.getObject("fbillid") == null || "".equals((id = rs.getObject("fbillid").toString()).trim())) break;
                        sql.append(" select po.fQty as qty,po.fBaseQty as baseQty,unit.fid as unitId,unit.fName_").append(locale).append(" as unitName,bom.fYield  as bomYield");
                        sql.append(" ,po.FFinalProductsQty as finalProductsQty from T_MRP_PMRPPlannedOrder po  ");
                        sql.append("    left outer join T_MM_Bom bom on po.FBomInterID = bom.fId ");
                        sql.append("    inner join T_BD_MeasureUnit unit on  unit.fid = po.FProductUnitID ");
                        sql.append(" where po.fId = '").append(id).append("'");
                        orderRs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                        if (orderRs.next()) {
                            map.put("qty", orderRs.getBigDecimal("qty"));
                            map.put("baseQty", orderRs.getBigDecimal("baseQty"));
                            MeasureUnitInfo unit = new MeasureUnitInfo();
                            unit.setName(orderRs.getString("unitName"));
                            unit.setId(BOSUuid.read((String)orderRs.getString("unitId")));
                            map.put("unit", unit);
                            map.put("finalProductsQty", orderRs.getBigDecimal("finalProductsQty"));
                            if (orderRs.getBigDecimal("bomYield") != null) {
                                if (orderRs.getBigDecimal("bomYield").compareTo(MMConstant.BIGDECIMAL_ZERO) == 0) {
                                    map.put("yield", MMConstant.BIGDECIMAL_ZERO.toString());
                                } else {
                                    map.put("yield", orderRs.getBigDecimal("bomYield").toString());
                                }
                                map.put("yield", orderRs.getBigDecimal("bomYield").toString());
                                break;
                            }
                            this.setMaterialPlanYield(materialId, rs.getString("FOrgUnitID"), map);
                            break;
                        }
                        throw new EASBizException(EASBizException.CHECKEXIST);
                    }
                    case 210: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IStockTransferBillEntry iStockTransferBillEntry = StockTransferBillEntryFactory.getLocalInstance((Context)this.getContext());
                        StockTransferBillEntryInfo stockTransferBillEntryInfo = (StockTransferBillEntryInfo)iStockTransferBillEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (stockTransferBillEntryInfo != null) {
                            map.put("qty", stockTransferBillEntryInfo.getQty());
                            map.put("baseQty", stockTransferBillEntryInfo.getBaseQty());
                            map.put("unit", stockTransferBillEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 220: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        ITransferOrderBillEntry iTransferOrderBillEntry = TransferOrderBillEntryFactory.getLocalInstance((Context)this.getContext());
                        TransferOrderBillEntryInfo transferOrderBillEntryInfo = (TransferOrderBillEntryInfo)iTransferOrderBillEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (transferOrderBillEntryInfo != null) {
                            map.put("qty", transferOrderBillEntryInfo.getQty());
                            map.put("baseQty", transferOrderBillEntryInfo.getBaseQty());
                            map.put("unit", transferOrderBillEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 230: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)this.getContext());
                        PurOrderEntryInfo purOrderEntryInfo = (PurOrderEntryInfo)iPurOrderEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (purOrderEntryInfo != null) {
                            map.put("qty", purOrderEntryInfo.getQty());
                            map.put("baseQty", purOrderEntryInfo.getBaseQty());
                            map.put("unit", purOrderEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 235: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IPurContractEntry iPurContractEntry = PurContractEntryFactory.getLocalInstance((Context)this.getContext());
                        PurContractEntryInfo purContractEntryInfo = (PurContractEntryInfo)iPurContractEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        map.put("qty", purContractEntryInfo.getQty());
                        map.put("baseQty", purContractEntryInfo.getBaseQty());
                        map.put("unit", purContractEntryInfo.getUnit());
                        break;
                    }
                    case 207: 
                    case 240: 
                    case 370: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance((Context)this.getContext());
                        PurRequestEntryInfo purRequestEntryInfo = (PurRequestEntryInfo)iPurRequestEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (purRequestEntryInfo != null) {
                            map.put("qty", purRequestEntryInfo.getQty());
                            map.put("baseQty", purRequestEntryInfo.getBaseQty());
                            map.put("unit", purRequestEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 300: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)this.getContext());
                        SaleOrderEntryInfo saleOrderEntryInfo = (SaleOrderEntryInfo)iSaleOrderEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (saleOrderEntryInfo != null) {
                            map.put("qty", saleOrderEntryInfo.getQty());
                            map.put("baseQty", saleOrderEntryInfo.getBaseQty());
                            map.put("unit", saleOrderEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 310: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IStockTransferBillEntry iStockTransferBillEntry = StockTransferBillEntryFactory.getLocalInstance((Context)this.getContext());
                        StockTransferBillEntryInfo saleOrderEntryInfo = (StockTransferBillEntryInfo)iStockTransferBillEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (saleOrderEntryInfo != null) {
                            map.put("qty", saleOrderEntryInfo.getQty());
                            map.put("baseQty", saleOrderEntryInfo.getBaseQty());
                            map.put("unit", saleOrderEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 320: {
                        break;
                    }
                    case 330: {
                        break;
                    }
                    case 340: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IPlannedOrderEntry iPlannedOrderEntry = PlannedOrderEntryFactory.getLocalInstance((Context)this.getContext());
                        PlannedOrderEntryInfo plannedOrderEntryInfo = (PlannedOrderEntryInfo)iPlannedOrderEntry.getCoreBillEntryBaseInfo("select demandQty,baseDemandQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (plannedOrderEntryInfo != null) {
                            map.put("qty", plannedOrderEntryInfo.getDemandQty());
                            map.put("baseQty", plannedOrderEntryInfo.getBaseDemandQty());
                            map.put("unit", plannedOrderEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 350: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IProductionOrderStockEntry iProductionOrderStockEntry = ProductionOrderStockEntryFactory.getLocalInstance((Context)this.getContext());
                        ProductionOrderStockEntryInfo productionOrderStockEntryInfo = (ProductionOrderStockEntryInfo)iProductionOrderStockEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (productionOrderStockEntryInfo != null) {
                            map.put("qty", productionOrderStockEntryInfo.getQty());
                            map.put("baseQty", productionOrderStockEntryInfo.getBaseQty());
                            map.put("unit", productionOrderStockEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 360: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        IManufactureOrderStock iManufactureOrderStock = ManufactureOrderStockFactory.getLocalInstance((Context)this.getContext());
                        ManufactureOrderStockInfo msInfo = (ManufactureOrderStockInfo)iManufactureOrderStock.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (msInfo != null) {
                            map.put("unit", msInfo.getUnit());
                            MeasureUnitInfo unitinfo = msInfo.getUnit();
                            map.put("qty", msInfo.getQty().setScale(unitinfo.getQtyPrecision()));
                            map.put("baseQty", msInfo.getBaseQty());
                        }
                        break;
                    }
                    case 205: {
                        if (rs.getObject("fbillid") == null || "".equals((id = rs.getObject("fbillid").toString()).trim())) break;
                        IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)this.getContext());
                        ManufactureOrderInfo mInfo = iManufactureOrder.getManufactureOrderInfo("select qty,baseQty,totalSplitQty,totalSplitBaseQty,unit.name,unit.qtyPrecision, yield, bomID where id = '" + id + "'");
                        map.put("qty", mInfo.getQty().subtract(mInfo.getTotalSplitQty()));
                        map.put("baseQty", mInfo.getBaseQty().subtract(mInfo.getTotalSplitBaseQty()));
                        map.put("unit", mInfo.getUnit());
                        if (mInfo.getYield() != null) {
                            map.put("yield", mInfo.getYield().toString());
                            break;
                        }
                        if (mInfo.getBomID() != null) {
                            BomInfo bomInfo = this.getBomInfo(mInfo.getBomID().toString());
                            if (bomInfo.getYield() != null) {
                                map.put("yield", bomInfo.getYield().toString());
                            }
                            break;
                        }
                        this.setMaterialPlanYield(materialId, rs.getString("FOrgUnitID"), map);
                        break;
                    }
                    case 209: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        ISubContractOrderEntry iSubContractOrderEntry = SubContractOrderEntryFactory.getLocalInstance((Context)this.getContext());
                        SubContractOrderEntryInfo subContractOrderEntryInfo = (SubContractOrderEntryInfo)iSubContractOrderEntry.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (subContractOrderEntryInfo != null) {
                            map.put("qty", subContractOrderEntryInfo.getQty());
                            map.put("baseQty", subContractOrderEntryInfo.getBaseQty());
                            map.put("unit", subContractOrderEntryInfo.getUnit());
                        }
                        break;
                    }
                    case 365: {
                        if (rs.getObject("fbillentryid") == null || "".equals((id = rs.getObject("fbillentryid").toString()).trim())) break;
                        ISubMaterialList iSubMaterialList = SubMaterialListFactory.getLocalInstance((Context)this.getContext());
                        SubMaterialListInfo subMaterialListInfo = (SubMaterialListInfo)iSubMaterialList.getCoreBillEntryBaseInfo("select qty,baseQty,unit.name,unit.qtyPrecision where id = '" + id + "'");
                        if (subMaterialListInfo != null) {
                            map.put("qty", subMaterialListInfo.getQty());
                            map.put("baseQty", subMaterialListInfo.getBaseQty());
                            map.put("unit", subMaterialListInfo.getUnit());
                        }
                        break;
                    }
                    case 251: {
                        break;
                    }
                    case 270: {
                        if (rs.getObject("fbillid") == null) break;
                        id = rs.getObject("fbillid").toString();
                        sql.append("select sum(entry.fqty) as fqty ,productUnit.fid as fPUId, productUnit.fname_").append(locale).append(" as funitName from t_mm_CooperatePlanOrderEntry entry ").append(" inner join t_mm_CooperatePlanOrder t on entry.fParentId = t.fid and t.fid ='").append(id).append("'").append(" inner join T_BD_MeasureUnit productUnit on t.FProductUnitID = productUnit.fid ").append("  group by productUnit.fid, productUnit.fname_").append(locale);
                        IRowSet coPORs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                        if (coPORs.next()) {
                            MeasureUnitInfo unitinfo = new MeasureUnitInfo();
                            unitinfo.setId(BOSUuid.read((String)coPORs.getString("fPUId")));
                            unitinfo.setName(coPORs.getString("funitName"));
                            map.put("unit", unitinfo);
                            BigDecimal sqt = coPORs.getBigDecimal("fqty");
                            if (MMConstant.BIGDECIMAL_ZERO.compareTo(sqt) == 0) {
                                map.put("qty", MMConstant.BIGDECIMAL_ZERO);
                                break;
                            }
                            map.put("qty", sqt);
                        }
                        break;
                    }
                    case 110: {
                        map.put("qty", rs.getBigDecimal("FQty"));
                        break;
                    }
                    case 140: {
                        map.put("qty", rs.getBigDecimal("FQty"));
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    private BomInfo getBomInfo(String bomId) throws EASBizException, BOSException {
        BomInfo bomInfo = BomFactory.getLocalInstance((Context)this.getContext()).getBomInfo((IObjectPK)new ObjectUuidPK(bomId));
        return bomInfo;
    }

    private void setMaterialPlanYield(String materialId, String storageUnit, HashMap<String, Object> map) throws EASBizException, BOSException {
        if (!MaterialPlanFactory.getLocalInstance((Context)this.getContext()).exists("select * where material='" + materialId + "' and OrgUnit='" + storageUnit + "'")) {
            return;
        }
        MaterialPlanInfo materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)this.getContext()).getMaterialPlanInfo("select yield where material='" + materialId + "' and OrgUnit='" + storageUnit + "'");
        if (materialPlanInfo.getYield() != null) {
            map.put("yield", materialPlanInfo.getYield().toString());
        }
    }

    private void prepareData(RptParams filter) throws BOSException, EASBizException {
        PMRPRunLogInfo info;
        Locale locale = this.getContext().getLocale();
        this.material = new String[2];
        this.planVesion = new String[3];
        this.storageUnit = new String[1];
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            this.storageUnit[0] = filter.getString("storageOrgUnitid");
        }
        if (filter.getString("planNum") != null && !"".equals(filter.getString("planNum"))) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 'MRP' ");
            sql.append(", t.fname_" + locale + " , t.fid");
            sql.append(" from CT_BAS_PlanDefined t \n");
            sql.append(" left outer join  t_org_storage s on t.CFStorageOrgID = s.fid \n");
            sql.append(" where t.fnumber in ('");
            sql.append(filter.getString("planNum"));
            sql.append("')");
            sql.append(" and  s.fid in ('");
            sql.append(this.storageUnit[0]);
            sql.append("')");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.planVesion);
        }
        if (this.planVesion[2] == null || "".equals(this.planVesion[2].trim())) {
            throw new MMCommonException(MMCommonException.PLANVERSION_NOT_EXIST, new Object[]{filter.getString("planNum")});
        }
        String oql = "SELECT * WHERE ID IN (";
        oql = oql + "SELECT TOP 1 FID FROM T_MRP_PMRPRunLog WHERE FstorageOrgUnitID='" + this.storageUnit[0];
        oql = oql + "' and FPlanDefinedID='" + this.planVesion[2];
        oql = oql + "' and fpercent = 100 and FMRPCalcDetailTbl IS NOT NULL order by fbizdate desc";
        oql = oql + ")";
        try {
            info = PMRPRunLogFactory.getLocalInstance(this.getContext()).getPMRPRunLogInfo(oql);
            this.calcDetailTbl = info.getMrpCalcDetailTbl();
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(this.getContext(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0000")));
        }
        if (filter.getString("materialNum") != null && !"".equals(filter.getString("materialNum"))) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid ,p.FIsMargin ");
            sql.append(" from ").append(info.getMrpCalcDetailTbl()).append("  t \n");
            sql.append("inner join t_bd_material m on m.fid=t.FMaterialID\n");
            sql.append("left outer join  t_bd_materialplan p on p.fmaterialid =  t.fid and p.forgunit=t.FOrgUnitID\n");
            sql.append("where m.fnumber in ( '");
            sql.append(filter.getString("materialNum"));
            sql.append("') ");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.material);
            sql = null;
        }
        filter.setString("TABLE", "table");
        PlanerWorkUtil.checkNull((String[])this.storageUnit);
        PlanerWorkUtil.checkNull((String[])this.material);
        PlanerWorkUtil.checkNull((String[])this.planVesion);
    }

    public int executeUpdateProcess(String sqlParams) throws BaseException {
        return 0;
    }

    public int executeUpdateProcess(ArrayList list) throws BaseException {
        return 0;
    }

    public IObjectPK getMainBizOrgById(String fid, String sql) throws BOSException {
        ObjectUuidPK orgPK = null;
        OrgUnitInfo orgUnit = new OrgUnitInfo();
        StringBuffer sb = new StringBuffer(sql);
        sb.append(" where fid = '").append(fid).append("'");
        String forgId = null;
        try {
            IRowSet coPORs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
            if (coPORs.next()) {
                forgId = coPORs.getString("orgId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (forgId != null) {
            orgUnit.setId(BOSUuid.read((String)forgId));
        }
        if (orgUnit != null) {
            orgPK = new ObjectUuidPK(orgUnit.getId());
        }
        return orgPK;
    }

    public HashMap<?, ?> prepareData(String reportID, RptParams filter, String tableName) throws BaseException {
        HashMap result = super.prepareData(reportID, filter, tableName);
        this.reportTitles = (MRPResultReportTitles)result.get(REPORTTITLE);
        this.reportTitles.addUserObject("tblDispInDay", (Object)this.dayStatTable);
        this.reportTitles.addUserObject("tblDispInWeek", (Object)this.weekStatTable);
        this.reportTitles.addUserObject("tblDispInMonth", (Object)this.monthStatTable);
        this.reportTitles.addUserObject("tblDispInPeriods", (Object)this.periodStatTable);
        this.reportTitles.addUserObject("mainTable", (Object)this.getTablename());
        this.reportTitles.addUserObject("plavVersionSetInfo", (Object)this.pvInfo);
        this.reportTitles.addUserObject("materialInfo", (Object)this.material);
        this.reportTitles.addUserObject("planDate", (Object)this.planDate[1]);
        return result;
    }

    public void dropTempTable(String reportID, RptParams filter, String tableName) throws BaseException {
        super.dropTempTable(reportID, filter, tableName);
        if (this.dayStatTable != null) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.dayStatTable);
        }
        if (this.weekStatTable != null) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.weekStatTable);
        }
        if (this.monthStatTable != null) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.monthStatTable);
        }
        if (this.periodStatTable != null) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(this.periodStatTable);
        }
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        RptParams p = new RptParams();
        p.setString("materialNum", (String)rowData.get("FMATERIALNUM"));
        p.setString("storageOrgUnit", totalFilter.getString("storageOrgUnit"));
        p.setString("planNum", (String)rowData.get("FPLANNUM"));
        p.setString("displayUnit", filter.getString("displayUnit"));
        p.setString("isSimulantResult", totalFilter.getString("isSimulantResult"));
        p.setString("projectID", (String)rowData.get("projectID"));
        p.setString("projectNumber", (String)rowData.get("projectNumber"));
        p.setInt("materialAttr", ((MaterialAttributeEnum)rowData.get("materialAttr")).getValue());
        return p;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        if (this.storageUnit == null) {
            this.storageUnit = new String[3];
        }
        if (this.material == null) {
            this.material = new String[15];
        }
        if (this.planVesion == null) {
            this.planVesion = new String[6];
        }
        if (filter.getString("statType") == null) {
            return null;
        }
        PlanerWorkUtil.testTempTable((Context)this.getContext(), (String)filter.getString("mainTable"));
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select  to_char(FBilldate,'YYYY-MM-DD') as FBilldate,FMRP ,FBillnum , FBillnumWithoutSeq, ");
        sql.append("  to_char(FReDate,'YYYY-MM-DD') as FReDate ,");
        sql.append(" Fproject,FTrackNumber,Fexception ");
        sql.append(",FAmount ,FPab ,FOrg ,FID ,FBaseQtyPrc ,to_decimal(FMrpItem) as FMRPItem,  ");
        sql.append(" fBizType, fBillType,fbaseStatus,fUnit,FAjustQty,FAjustFlag,");
        sql.append("FIsAjust,FSrcBillId,FBillId,FPlanBeginDate,FPlanEndDate,");
        sql.append("to_char(Fexception1) as Fexception1,to_char(Fexception2) as Fexception2, ");
        sql.append("to_char(Fexception3) as Fexception3,to_char(Fexception4) as Fexception4, ");
        sql.append("to_char(Fexception5) as Fexception5,to_char(Fexception6) as Fexception6, ");
        sql.append("to_char(Fexception7) as Fexception7,to_char(Fexception8) as Fexception8, ");
        sql.append("fOrgId,fcurId ,FQty,FBillRowSeq,to_char(Fexception0) as Fexception0, ");
        sql.append("FRequireMentID,FProdQtyPrc,FConvertRate, \n");
        sql.append(" FIsCanNotThrow,FMrpItemType,FIsSurplusDivert,FDataType  \n");
        sql.append(" from ").append(filter.getString("mainTable"));
        sql.append(" where \n");
        if (filter.getString("statType").equals("day")) {
            sql.append(" FDayOfYear='").append(filter.getString("periodDispName")).append("' ");
        }
        if (filter.getString("statType").equals("week")) {
            sql.append(" FWeekOfYear='").append(filter.getString("periodDispName")).append("' ");
        }
        if (filter.getString("statType").equals("month")) {
            sql.append(" FMonthOfYear='").append(filter.getString("periodDispName")).append("' ");
        }
        if (filter.getString("statType").equals("period")) {
            sql.append(" FPeriodDispName='").append(filter.getString("periodDispName")).append("' ");
        }
        sql.append(" and FMrpItemType=").append(filter.getString("mrpItemType"));
        sql.append(" order by KSQL_seq ");
        rs = SQLUtils.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        int i;
        Locale locale = this.getContext().getLocale();
        MRPResultReportTitles titles = new MRPResultReportTitles();
        String planMode = "MRP";
        if (this.material[5] != null && !this.material[5].trim().equalsIgnoreCase("") && PlanningModeEnum.getEnum((int)(i = Integer.parseInt(this.material[5]))) != null) {
            planMode = PlanningModeEnum.getEnum((int)i).toString();
        }
        titles.AddTitle(0, this.getResourceString(this.getContext(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0001") + "  " + this.storageUnit[1] + "," + this.storageUnit[0]);
        titles.AddTitle(1, PlanerWorkUtil.getString((Context)this.getContext(), (String)"PLANVERSION") + "  " + this.planVesion[1]);
        titles.AddTitle(2, PlanerWorkUtil.getString((Context)this.getContext(), (String)"PLANMODE") + "  " + planMode);
        titles.AddTitle(3, PlanerWorkUtil.getString((Context)this.getContext(), (String)"MATERIALNUM") + "  " + filter.getString("materialNum"));
        titles.AddTitle(4, PlanerWorkUtil.getString((Context)this.getContext(), (String)"MATERIALNAME") + "  " + this.material[1]);
        titles.AddTitle(5, PlanerWorkUtil.getString((Context)this.getContext(), (String)"MATERIALMOTEL") + "  " + this.material[0]);
        if (this.material[4] != null && !"".equalsIgnoreCase(this.material[4].trim())) {
            titles.AddTitle(6, PlanerWorkUtil.getString((Context)this.getContext(), (String)"MATERIALATT") + "  " + MaterialAttributeEnum.getEnum((int)Integer.parseInt(this.material[4])).toString());
        } else {
            titles.AddTitle(6, PlanerWorkUtil.getString((Context)this.getContext(), (String)"MATERIALATT") + "  ");
        }
        String unitName = this.material[2];
        String unitLabel = PlanerWorkUtil.getString((Context)this.getContext(), (String)"BASEUNIT");
        if ("productionUnit".equals(filter.getString("displayUnit"))) {
            unitName = this.material[11];
            unitLabel = PlanerWorkUtil.getString((Context)this.getContext(), (String)"PRODUCT_UNIT");
        }
        titles.AddTitle(7, unitLabel + "  " + unitName);
        BigDecimal SafeStock = new BigDecimal("0.0");
        if (this.material[6] != null && !"".equalsIgnoreCase(this.material[6].trim())) {
            SafeStock = new BigDecimal(this.material[6]);
            int qtypre = 4;
            if (this.material[7] != null && !"".equalsIgnoreCase(this.material[7].trim())) {
                qtypre = Integer.parseInt(this.material[7]);
            }
            if ("productionUnit".equals(filter.getString("displayUnit"))) {
                BigDecimal convsRate = new BigDecimal(this.material[9]);
                int precision = new Integer(this.material[10]);
                SafeStock = SafeStock.divide(convsRate, precision, 4);
                qtypre = precision;
            }
            StringBuffer formatStr = new StringBuffer();
            formatStr.append("###0");
            if (qtypre > 0) {
                formatStr.append(".");
            }
            for (int i2 = 0; i2 < qtypre; ++i2) {
                formatStr.append("0");
            }
            DecimalFormat df = new DecimalFormat(formatStr.toString());
            titles.AddTitle(8, PlanerWorkUtil.getString((Context)this.getContext(), (String)"SAFESTOCK") + "  " + df.format(SafeStock));
        } else {
            titles.AddTitle(8, PlanerWorkUtil.getString((Context)this.getContext(), (String)"SAFESTOCK"));
        }
        titles.AddTitle(9, PlanerWorkUtil.getString((Context)this.getContext(), (String)"ManufactureStrategy") + "  " + this.material[8]);
        titles.AddTitle(10, PlanerWorkUtil.getString((Context)this.getContext(), (String)"PLANDATE") + "  " + this.planDate[1]);
        String lan = locale.getLanguage();
        if (lan.equals("l1")) {
            this.planDate[0] = PlanerWorkUtil.getString((Context)this.getContext(), (String)"NO").equals(this.planDate[0]) ? "Unfinished" : "Finished";
        }
        titles.AddTitle(11, PlanerWorkUtil.getString((Context)this.getContext(), (String)"PROCESS") + "  " + this.planDate[0]);
        titles.AddTitle(12, this.getResourceString(this.getContext(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0002") + "  " + this.material[16] + "," + this.material[15]);
        String isSurplusDivert = PlanerWorkUtil.getString((Context)this.getContext(), (String)"NO");
        if ("1".equals(this.material[14])) {
            isSurplusDivert = PlanerWorkUtil.getString((Context)this.getContext(), (String)"YES");
            titles.AddTitle(14, "");
        }
        titles.AddTitle(13, PlanerWorkUtil.getString((Context)this.getContext(), (String)"SUPLUS_DIVERT") + "  " + isSurplusDivert);
        return titles;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        StringBuffer sql = new StringBuffer();
        if ("day".equals(filter.getString("statType")) || "week".equals(filter.getString("statType")) || "month".equals(filter.getString("statType")) || "period".equals(filter.getString("statType"))) {
            sql.append("select * from ").append(tableName);
            sql.append(" where KSQL_seq >").append(start);
            sql.append(" and KSQL_seq <=").append(start + rows);
            sql.append(" order by KSQL_seq ");
            IRowSet rs = SQLUtils.executeQuery((Context)this.getContext(), (String)sql.toString());
            return rs;
        }
        sql.append("select  to_char(FBilldate,'YYYY-MM-DD') as FBilldate,FMRP ,FBillnum , FBillnumWithoutSeq, ");
        sql.append("  to_char(FReDate,'YYYY-MM-DD') as FReDate,");
        sql.append(" Fproject,FTrackNumber,Fexception ");
        sql.append(",FAmount ,FPab ,FOrg ,FID ,FBaseQtyPrc ,to_decimal(FMrpItem) as FMRPItem,  ");
        sql.append(" fBizType, fBillType,fbaseStatus,fUnit,FAjustQty,FAjustFlag,");
        sql.append("FIsAjust,FSrcBillId,FBillId,FPlanBeginDate,FPlanEndDate,");
        sql.append("to_char(Fexception1) as Fexception1,to_char(Fexception2) as Fexception2, ");
        sql.append("to_char(Fexception3) as Fexception3,to_char(Fexception4) as Fexception4, ");
        sql.append("to_char(Fexception5) as Fexception5,to_char(Fexception6) as Fexception6, ");
        sql.append("to_char(Fexception7) as Fexception7,to_char(Fexception8) as Fexception8, ");
        sql.append("fOrgId,fcurId ,FQty,FBillRowSeq,to_char(Fexception0) as Fexception0, ");
        sql.append("FRequireMentID,FProdQtyPrc,FConvertRate, \n");
        sql.append(" FIsCanNotThrow,FMrpItemType,FIsSurplusDivert,FDataType,FDesc64 \n");
        sql.append(" from  " + tableName + "\n");
        sql.append(" where KSQL_seq >");
        sql.append(start);
        sql.append(" and KSQL_seq <=");
        sql.append(start + rows);
        sql.append(" order by KSQL_seq ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        StringBuffer createTableMain = this.getTempTableMain();
        String tempTableNameMain = null;
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.buildTitles(filter);
        DbUtil.execute((Context)this.getContext(), (String)this.insertTempTable(tempTableNameMain, filter));
        this.updateExceptions2TempMainTable(tempTableNameMain);
        this.updateException(tempTableNameMain);
        this.updatePab(tempTableNameMain);
        this.setTablename(tempTableNameMain);
        if ("true".equals(filter.getString("isCPlanerWorkPlatForm"))) {
            return tempTableNameMain;
        }
        try {
            this.buildStatData(tempTableNameMain);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        return tempTableNameMain;
    }

    private void updateException(String tempTableNameMain) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTableNameMain);
        sql.append(" as t set (Fexception) = (select to_char(e.fnumber) from T_MM_MRPRunException e  ");
        sql.append(" where to_char(e.fpriority) = t.Fexception and e.FStorageOrgUnitID = '");
        sql.append(this.storageUnit[2]);
        sql.append("')");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
    }

    protected StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getPlanerWorkPlatformResult (");
        createTable.append("FReportDataID  varchar(44) not null ");
        createTable.append(",KSQL_SEQ INT IDENTITY (1, 1)");
        createTable.append(",KSQL_SEQ2 INT ");
        createTable.append(",FBilldate DATETIME   ");
        createTable.append(",FMRP  varchar(255)  DEFAULT(' ')");
        createTable.append(",FBillnum varchar(150)   DEFAULT(' ') ");
        createTable.append(",FBillnumWithoutSeq varchar(150)   DEFAULT(' ') ");
        createTable.append(",FReDate DATETIME ");
        createTable.append(",Fexception varchar(21) DEFAULT('0') ");
        createTable.append(",FAmount  NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",FPab     NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",FOrg     Nvarchar(255) DEFAULT(' ') ");
        createTable.append(",Fproject     Nvarchar(255) DEFAULT(' ') ");
        createTable.append(",FTrackNumber     Nvarchar(255) DEFAULT(' ') ");
        createTable.append(",FID      varchar(44) DEFAULT('123456') ");
        createTable.append(",FBaseQtyPrc Integer     DEFAULT(4) ");
        createTable.append(",FMrpItem  INTEGER not null default 0 ");
        createTable.append(",fBizType  varchar(255) DEFAULT ('')");
        createTable.append(",fBillType  varchar(255) DEFAULT ('')");
        createTable.append(",fbaseStatus Int ");
        createTable.append(",fUnit Nvarchar(255)   DEFAULT(' ') ");
        createTable.append(",FPlanBeginDate DATETIME");
        createTable.append(",FPlanEndDate DATETIME");
        createTable.append(",FAjustQty  NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",FAjustFlag int ");
        createTable.append(",FIsAjust int ");
        createTable.append(",FSrcBillId  varchar(44) DEFAULT('') ");
        createTable.append(",FBillId  varchar(44) DEFAULT('') ");
        createTable.append(",Fexception1 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception2 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception3 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception4 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception5 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception6 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception7 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception8 NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",Fexception0 varchar(160) ");
        createTable.append(",fOrgId   varchar(44) DEFAULT('')");
        createTable.append(",fcurId   varchar(44) ");
        createTable.append(",fSId   varchar(44) ");
        createTable.append(",FQty  NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",FBillRowSeq varchar(44)   DEFAULT(' ') ");
        createTable.append(",FRequireMentID varchar(44)   DEFAULT('') ");
        createTable.append(",FProdQtyPrc Integer  DEFAULT(4) ");
        createTable.append(",FConvertRate NUMERIC(21,8) DEFAULT(1) ");
        createTable.append(",FSR NUMERIC(21,8) DEFAULT(0) ");
        createTable.append(",FIndependent NUMERIC(21,8) DEFAULT 0 ");
        createTable.append(",FDependent NUMERIC(21,8) DEFAULT 0 ");
        createTable.append(",FYear INT not null default 0 ");
        createTable.append(",FDayOfYear NVarchar(80) ");
        createTable.append(",FMonthOfYear NVarchar(80) ");
        createTable.append(",FWeekSeq INT not null default 0 ");
        createTable.append(",FWeekOfYear NVarchar(80) ");
        createTable.append(",FPeriodInCycle INT not null default 0 ");
        createTable.append(",FPeriodDispName NVarchar(80) ");
        createTable.append(",FIsCanNotThrow INT ");
        createTable.append(",FMRPItemType INT not null default 0 ");
        createTable.append(",FAttachProjectNumber Nvarchar(255) ");
        createTable.append(",FAttachTrackNumber Nvarchar(255)  ");
        createTable.append(",FDataType INT not null default 0 ");
        createTable.append(",FIsSurplusDivert INT not null default 0 ");
        createTable.append(",FDesc64 varchar(255) ");
        createTable.append(" ) ");
        return createTable;
    }

    private String insertTempTable(String tempTableNameMain, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into  " + tempTableNameMain);
        sql.append("( KSQL_SEQ ,FReportDataID,FBilldate");
        sql.append(",FMRP , FBillnum , FBillnumWithoutSeq, FReDate, Fproject,FTrackNumber,Fexception ");
        sql.append(",FAmount , FPab , FOrg ,FID ,FBaseQtyPrc ,FMrpItem ,");
        sql.append(" fBizType, fBillType,fbaseStatus,fUnit,FPlanBeginDate,FPlanEndDate,FAjustQty,");
        sql.append(" FAjustFlag,FIsAjust,FSrcBillId,FBillId ,");
        sql.append("Fexception1,Fexception2,Fexception3,Fexception4,Fexception5,");
        sql.append("Fexception6,Fexception7,Fexception8,fOrgId,fcurId,FSId,FBillRowSeq,FRequireMentID,");
        sql.append("FProdQtyPrc,FConvertRate,FSR,FIndependent,FDependent,FIsCanNotThrow, \n");
        sql.append("FAttachProjectNumber, FAttachTrackNumber,FDataType,FIsSurplusDivert,FDesc64 ) \r\n");
        sql.append(this.buildTempSelectResult(filter));
        return sql.toString();
    }

    private String buildTempSelectResult(RptParams filter) throws BaseException {
        Locale locale = this.getContext().getLocale();
        String detail = this.calcDetailTbl;
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        sb.append("newbosid('B844D41F') as FRowID, FBillDate, FMrpItem0, FBillnum, FBillnumWithoutSeq, FReDate, FBProjectNumber, FBTrackNumber, FException, sum(FAmount), sum(FPab)");
        sb.append(",FOrg, FID, FBaseQtyPrc, FMrpItem, FBizType, FBillType, FBaseStatus, FMaterialName, FPlanBeginDate, FPlanEndDate, FAjustQty, FAjustFlag, FIsAjust");
        sb.append(",FSrcBillId, FBillId, FException1, FException2, FException3, FException4, FException5, FException6, FException7, FException8, FSupplyOrgUnitID, max(FCurId), FSID");
        sb.append(",FBillRowSeq, MAX(FRequireMentID), FProdQtyPrc, FConvertRate, sum(FSR), FIndependent, FDependent, FIsCanNotThrow, FProjectNumber, FTrackNumber, FDataType, FIsMargin, FDesc64");
        sb.append(" from (");
        sb.append(" select (case t.FMRPItem when 131 then 100 when 120 then 99 when 110 then 101 else t.FMRPClassify end) as FMRPClassify,t.fbilldate as FBillDate, t.fmrpitem as FMrpItem0, \n");
        sb.append("(case when  t.fbillnumber is null then ' '   ");
        sb.append("else   CONCAT( CONCAT( TOCHAR(t.fbillnumber ), '/'),");
        sb.append("TOCHAR(t.FBillRowSeq)) end ) as FBillnum ,\n");
        sb.append("(case when  t.fbillnumber is null or t.fmrpitem = 260 or t.fmrpitem = 380 then ' '   ");
        sb.append("else   TOCHAR(t.fbillnumber) end) as FBillnumWithoutSeq ,\n");
        sb.append("  (case when t.FAjustFlag=4 then null ");
        sb.append("        when t.fmrpitem=110 then null ");
        sb.append("        when t.fmrpitem=120 then null ");
        sb.append("        when t.fmrpitem=131 then null ");
        sb.append("        when t.fmrpitem=132 then null ");
        sb.append("        when t.fmrpitem=140 then null ");
        sb.append("        when t.fmrpitem=270 then null ");
        sb.append("        when t.fmrpitem=320 then null ");
        sb.append("        when t.fmrpitem=330 then null ");
        sb.append("        when t.fmrpitem=340 then null ");
        sb.append("        when t.fmrpitem=331 then null ");
        sb.append("        when t.fmrpitem=390 then null ");
        sb.append("        when t.fmrpitem=400 then null ");
        sb.append("        when mt.FIsMargin=1 then null ");
        sb.append("        when caentry.FWorkDate = t.FBillDate  then null ");
        sb.append("        else caentry.FWorkDate end )as FReDate, \n ");
        sb.append("    t.FBProjectNumber  , \n ");
        sb.append("    t.FBTrackNumber  , \n ");
        sb.append(" (select to_char(min(e.fpriority)) from T_MM_MRPRunException e where (to_number(e.fnumber) in ");
        sb.append(" ( t.fexception8,t.fexception7,t.fexception6,t.fexception5,t.fexception4,");
        sb.append(" t.fexception3,t.fexception2,t.fexception1) or e.fnumber=t.FDesc64) ");
        sb.append(" and e.FStorageOrgUnitID= '");
        sb.append(this.storageUnit[2]);
        sb.append("' and e.fisshow = 1)");
        sb.append(" as FException ,");
        sb.append("isnull(( case when t.fmrpitem = 110  then t.FAvaliable  when t.fmrpitem = 131  then 0  \n");
        sb.append("       when t.fmrpitem = 120  then t.FAvaliable \n");
        sb.append("       when t.fmrpitem = 140  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 200  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 210  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 220  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 230  then t.fsr  \n");
        sb.append("       when t.fmrpitem = 235  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 240  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 207  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 209  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 260  then t.fsr   \n");
        sb.append("       when t.fmrpitem = 205  then t.fsr \n");
        sb.append("       when t.fmrpitem = 250  then t.fsr \n");
        sb.append("       when t.fmrpitem = 270  then t.findependent  \n");
        sb.append("       when t.fmrpitem = 300  then t.findependent  \n");
        sb.append("       when t.fmrpitem = 310  then t.findependent  \n");
        sb.append("       when t.fmrpitem = 320  then t.findependent \n");
        sb.append("       when t.fmrpitem = 331  then t.findependent \n");
        sb.append("       when t.fmrpitem = 390  then t.findependent \n");
        sb.append("       when t.fmrpitem = 400  then t.findependent \n");
        sb.append("       when t.fmrpitem = 330  then t.findependent  \n");
        sb.append("       when t.fmrpitem = 340  then t.fdependent - t.fsr \n");
        sb.append("  \t  when t.fmrpitem = 251  then t.fdependent  \n");
        sb.append("       when t.fmrpitem = 365  then t.fdependent  \n");
        sb.append("       when t.fmrpitem = 370  then t.fdependent  \n");
        sb.append("       when t.fmrpitem = 380  then t.fdependent  \n");
        sb.append("       when t.fmrpitem = 350  then t.fdependent  \n");
        sb.append("       when t.fmrpitem = 132  then t.FAvaliable  \n  ");
        sb.append("       when t.fmrpitem = 450  then t.findependent + t.fdependent  \n  ");
        sb.append("       when t.fmrpitem = 255  then t.findependent  \n  ");
        sb.append("       when t.fmrpitem = 256  then t.findependent  \n  ");
        sb.append("       when t.fmrpitem = 257  then t.findependent  \n  ");
        sb.append("       when t.fmrpitem = 258  then t.findependent  \n  ");
        sb.append("       when t.fmrpitem = 360  then t.fdependent  end), 0) as FAmount  , \n");
        sb.append(" (case when mt.FIsMargin=0 and (t.fmrpitem=110) then t.FAvaliable ");
        sb.append("  when mt.FIsMargin=1 and (t.fmrpitem=110 or t.fmrpitem=140) then t.FSR \n");
        sb.append("  when t.fmrpitem=131 then 0 ");
        sb.append("  when t.fmrpitem=132 then 0 ");
        sb.append("\t else t.FPAB end) as FPab, ");
        sb.append(" sorg.fname_" + locale + " as FOrg  ,\n");
        sb.append(" (case  when t.fmrpitem = 300  then  T.FSrcBillID  else T.FBILLID  end) as FID  ,");
        sb.append(" u1.FQtyPrecision as  FBaseQtyPrc ,t.fmrpitem as FMrpItem ,\n ");
        sb.append(" (case when t.fbiztypeid is null then bi.FName_" + locale);
        sb.append(" else biz.FName_" + locale + " end) as FBizType,");
        sb.append(" bi.FName_" + locale).append(" as FBillType,");
        sb.append(" (case when t.fmrpitem = 300  then ").append(4);
        sb.append("  when t.fmrpitem = 260 or t.fmrpitem = 380  then null ");
        sb.append(" else  t.fbaseStatus end)");
        sb.append(" as FBaseStatus,'");
        sb.append(this.material[2]).append("' AS FMaterialName").append(",(case when t.fmrpitem = 230 then null when t.fmrpitem = 240 then (select FPROPOSEPURCHASEDATE  from T_SM_PurRequestEntry where fid = t.Fbillentryid)  else t.FPlanBeginDate end) as FPlanBeginDate").append(",(case when t.fmrpitem = 230 then (select FDELIVERYDATE from T_SM_PurOrderEntry where fid = t.fbillentryid) when t.fmrpitem = 240 then (select FREQUIREMENTDATE from T_SM_PurRequestEntry where fid = t.Fbillentryid) else t.FPlanEndDate end) as FPlanEndDate");
        sb.append(",t.FAjustQty,t.FAjustFlag,t.FIsAjust, ");
        sb.append(" t.FSid as FSrcBillId,t.FBillId ,t.FException1,t.FException2,t.FException3,");
        sb.append("t.FException4,t.FException5,t.FException6,t.FException7,t.FException8, '");
        sb.append(this.storageUnit[2]).append("' AS FSUPPLYORGUNITID");
        sb.append(", t.fid as FCurId,t.FSID as FSID,");
        sb.append("TOCHAR(t.FBillRowSeq) as FBillRowSeq, ");
        sb.append("t.FRequireMentID as FRequireMentID,\n");
        sb.append("u3.FQTYPRECISION as FProdQtyPrc, \n");
        sb.append("u3.FBASECONVSRATE as FConvertRate, \n");
        sb.append("t.fsr as FSR,\n");
        sb.append("t.findependent as FIndependent,\n");
        sb.append("t.fdependent as FDependent, \n");
        sb.append("(case when t.FMRPItem=250 then t.FIsCanNotThrow ");
        sb.append("else null end) as FIsCanNotThrow, \n");
        sb.append("t.FProjectNumber, \n");
        sb.append("t.FTrackNumber, \n");
        sb.append("case when mt.FIsMargin=1 and (t.FSID is null or t.FSID=t.fid) and t.FHasSplit=1 then 1 \n");
        sb.append(" when mt.FIsMargin=1 and (t.FSID is not null and t.FSID!=t.fid) \n");
        sb.append(" then 2 else 0 end as FDataType,\n");
        sb.append("mt.FIsMargin,t.FDesc64 \n");
        sb.append(" from  ").append(detail).append(" t  \n");
        sb.append("left outer join T_MRP_PMRPRunLog log      on t.frunlogid = log.fid \n");
        sb.append("left outer join T_ORG_Storage sorg      on t.FSupplyOrgUnitID = sorg.fid\n");
        sb.append("left outer join T_SCM_BizType biz      on t.fbiztypeid = biz.fid\n");
        sb.append("left outer join T_SCM_BillType bi      on t.fbilltype = bi.fid\n");
        sb.append("inner join T_MM_FactoryCalendar ca on  ca.FStorageOrgUnitID = t.FSupplyOrgUnitID and ca.FIsDefault = 1 ");
        sb.append("left join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID and caentry.FWorkDateSeq = t.FPeriod ");
        sb.append("inner join t_bd_material m on m.fid=t.FMaterialID\n");
        sb.append("inner join t_bd_materialplan mt on mt.FMaterialID = t.FMaterialID and mt.forgunit=t.FSupplyOrgUnitID\n");
        sb.append("inner join T_BD_MultiMeasureUnit u1 on mt.FMaterialID=u1.FMaterialID and m.FBaseUnit=u1.FMeasureUnitID\n");
        sb.append("inner join T_BD_MultiMeasureUnit u3 on mt.FMaterialID=u3.FMaterialID and mt.FProductUnitID=u3.FMeasureUnitID\n");
        if ("1".equals(this.material[14])) {
            sb.append(" where t.fmaterialid = '");
            sb.append(this.material[3]);
            sb.append("' and t.FMaterialAttr=").append(this.material[4]);
            sb.append(" and t.FAjustFlag <> -1");
            sb.append("  and  (t.FSID is null or t.FSID=t.fid)");
            if (filter.getString("projectID") != null) {
                sb.append(" and t.fprojectid='").append(filter.getString("projectID")).append("'");
            }
            if ("0".equals(this.planVesion[3]) || "".equals(this.material[6])) {
                sb.append(" and t.FMrpItem != 120 ");
            }
            sb.append(" order by t.FProjectNumber,t.FTrackNumber asc,t.FMRPClassify desc,t.FIsDefaultTNO desc,t.FMRPITEM asc\n");
        } else {
            sb.append(" where t.fmaterialid = '");
            sb.append(this.material[3]);
            sb.append("' and t.FMaterialAttr=").append(this.material[4]);
            sb.append("  and  (t.FSID is null or t.FSID=t.fid)");
            if (filter.getString("projectID") != null) {
                sb.append(" and t.fprojectid='").append(filter.getString("projectID")).append("'");
            }
            if ("0".equals(this.planVesion[3]) || "".equals(this.material[6])) {
                sb.append(" and t.FMrpItem != 120 ");
            }
            if (!(this.material[8].equals("MTO10") || this.material[8].equals("ETO10") || this.material[8].equals("ATO10"))) {
                sb.append(" and t.fmrpitem != 132");
            }
            sb.append("  order by t.FProjectNumber,t.FTrackNumber asc,t.FMRPClassify desc,t.FIsDefaultTNO desc,t.FMRPITEM asc  \n");
        }
        sb.append(") tmp0");
        sb.append(" group by FBillDate, FMrpItem0, FBillnum, FBillnumWithoutSeq, FReDate, FBProjectNumber, FBTrackNumber, FException");
        sb.append(",FOrg, FID, FBaseQtyPrc, FMrpItem, FBizType, FBillType, FBaseStatus, FMaterialName, FPlanBeginDate, FPlanEndDate, FAjustQty, FAjustFlag, FIsAjust");
        sb.append(",FSrcBillId, FBillId, FException1, FException2, FException3, FException4, FException5, FException6, FException7, FException8, FSupplyOrgUnitID, FSID");
        sb.append(",FBillRowSeq, FProdQtyPrc, FConvertRate, FIndependent, FDependent, FIsCanNotThrow, FProjectNumber, FTrackNumber, FDataType, FIsMargin, FDesc64, FMRPClassify");
        sb.append(" order by FProjectNumber, FTrackNumber asc, FMRPClassify desc, FMrpItem desc\n");
        logger.info((Object)("#########\u663e\u793a\u5217\u8868SQL\uff1a" + sb.toString()));
        return sb.toString();
    }

    private void updateExceptions2TempMainTable(String tempTableNameMain) throws BOSException {
        String detail = this.calcDetailTbl;
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTableNameMain).append(" as currTable set (Fexception,FReDate) =  \n");
        sql.append("(select  distinct \n");
        sql.append("    case when isnull(tmp.fpriority,10000)<isnull(to_number(currTable.Fexception),10000) then to_char(tmp.fpriority) \n");
        sql.append("\telse currTable.Fexception  end, \n");
        sql.append("    case when currTable.FAjustFlag=4 or FException6=62 then null when tmp.fredate<currTable.FReDate or currTable.FReDate is null then tmp.fredate ");
        sql.append("    else currTable.FReDate end \n");
        sql.append("from ( \n");
        sql.append("    select fbillnumber,FBillRowSeq,min(caentry.FWorkDate) as fredate,  \n");
        sql.append("    case when min(isnull(e.FPriority,10000))<min(isnull(e1.FPriority,10000)) then ");
        sql.append(" \tmin(isnull(e.FPriority,10000)) else min(isnull(e1.FPriority,10000)) end as FPriority \n");
        sql.append("    from ").append(detail).append(" t \n");
        sql.append("    inner join T_MM_FactoryCalendar ca on ca.FStorageOrgUnitID = t.FSupplyOrgUnitID and ca.FIsDefault = 1  \n");
        sql.append("    inner join T_MM_FactoryCalendarEntry caentry  on ca.FID = caentry.FParentID and caentry.FWorkDateSeq = t.FPeriod  \n");
        sql.append("    left outer join T_MM_MRPRunException e on e.fnumber = to_char(t.fexception6) and (e.fisshow=1 and e.FStorageOrgUnitID ='").append(this.storageUnit[2]).append("') \n");
        sql.append("    left outer join T_MM_MRPRunException e1 on e1.fnumber = to_char(t.fexception8) and (e1.fisshow = 1 and e1.FStorageOrgUnitID ='").append(this.storageUnit[2]).append("') \n");
        sql.append("    where ");
        sql.append("    ((t.FException6 > 0 or t.FException8>0) or (t.FajustFlag in (1,2,3,4,5,6)))  \n");
        sql.append("          and (fsid is not null and t.fid!= t.fsid)  \n");
        sql.append("                    and t.fmaterialid='").append(this.material[3]).append("' \n");
        sql.append("              group by  fbillnumber,FBillRowSeq) as  tmp \n");
        sql.append("where currTable.fbillnumwithoutseq=tmp.fbillnumber and currTable.FBillRowSeq=to_char(tmp.FBillRowSeq) ) \n");
        sql.append(" where (FSID is null or FSID=fcurId) and FMrpItem not in (120,320,330,331,390,251,400,300,310,340,350,360,365,370,380)");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        StringBuffer allExceptionSql = new StringBuffer();
        allExceptionSql.append("select fbillnumber,fbillrowseq, fmrpItem, Fexception6,Fexception8 from ").append(detail).append(" where fsid is not null").append(" and fmaterialid = '").append(this.material[3]).append("' group by fbillnumber,fbillrowseq,fmrpItem, Fexception6,Fexception8");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)allExceptionSql.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String billNumber = rs.getString("fbillnumber");
                String billRowSeq = rs.getString("fbillrowseq");
                String mrpItem = rs.getString("fmrpItem");
                String exception6 = rs.getString("Fexception6") + "','" + rs.getString("Fexception8");
                if (map.keySet().contains(billNumber + "/" + billRowSeq + mrpItem)) {
                    exception6 = (String)map.get(billNumber + "/" + billRowSeq + mrpItem) + "','" + exception6;
                }
                map.put(billNumber + "/" + billRowSeq + mrpItem, exception6);
            }
            Iterator keySet = map.keySet().iterator();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            while (keySet.hasNext()) {
                String key = (String)keySet.next();
                list.add(new Object[]{(String)map.get(key), key});
            }
            String updateException6Sql = "update " + tempTableNameMain + " set Fexception0 = ? where (to_char(FBillnum)||to_char(fmrpItem)) = ?";
            DbUtil.executeBatch((Context)this.getContext(), (String)updateException6Sql, list);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if ("1".equals(this.material[14])) {
            StringBuffer updateAjustOrderSql = new StringBuffer();
            updateAjustOrderSql.append("update ").append(tempTableNameMain).append(" set FReDate=null where FDataType=1");
            DbUtil.execute((Context)this.getContext(), (String)updateAjustOrderSql.toString());
            updateAjustOrderSql.setLength(0);
            updateAjustOrderSql.append("update ").append(tempTableNameMain).append(" set FException0='0',FException='0',FException1=decimal(0,21,8),FException2=decimal(0,21,8),");
            updateAjustOrderSql.append(" FReDate= (select case when FException=62 then null else FReDate end), ");
            updateAjustOrderSql.append(" FException3=decimal(0,21,8), FException4=decimal(0,21,8), ");
            updateAjustOrderSql.append(" FException5=decimal(0,21,8), FException6=decimal(0,21,8), ");
            updateAjustOrderSql.append(" FException7=decimal(0,21,8), FException8=decimal(0,21,8) ");
            updateAjustOrderSql.append(" where FDataType=2");
            DbUtil.execute((Context)this.getContext(), (String)updateAjustOrderSql.toString());
            StringBuffer stocksql = new StringBuffer();
            stocksql.append("update ").append(tempTableNameMain).append(" as currTable set Fexception =  \n");
            stocksql.append("(select  distinct \n");
            stocksql.append("  min(isnull(e.FPriority,10000)) as FPriority \n");
            stocksql.append("  from ").append(detail).append(" t \n");
            stocksql.append("    left outer join T_MM_MRPRunException e on e.fnumber = to_char(t.fexception8) and (e.fisshow=1 and e.FStorageOrgUnitID ='").append(this.storageUnit[2]).append("') \n");
            stocksql.append("  where t.FajustFlag = 8  \n");
            stocksql.append("    and (t.fsid is not null and t.fid!= t.fsid)  \n");
            stocksql.append("    and t.fmaterialid='").append(this.material[3]).append("' \n");
            stocksql.append("    and t.fsid = currTable.fcurId)  \n");
            stocksql.append(" where (currTable.FSID is null or currTable.FSID=currTable.fcurId) and currTable.FMrpItem = 110");
            DbUtil.execute((Context)this.getContext(), (String)stocksql.toString());
            StringBuffer exceptionSql = new StringBuffer();
            exceptionSql.append("select fsid,Fexception8 from ").append(detail).append(" where fmrpitem = 140 ").append(" and fmaterialid = '").append(this.material[3]).append("'");
            IRowSet exrs = DbUtil.executeQuery((Context)this.getContext(), (String)exceptionSql.toString());
            try {
                ArrayList<Object[]> list = new ArrayList<Object[]>();
                while (exrs.next()) {
                    String id = exrs.getString("fsid");
                    String exception = exrs.getString("Fexception8");
                    list.add(new Object[]{exception, id});
                }
                String updateExceptionSql = "update " + tempTableNameMain + " set Fexception0 = ? where fcurId = ?";
                DbUtil.executeBatch((Context)this.getContext(), (String)updateExceptionSql, list);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void buildTitles(RptParams filter) throws BaseException {
        this.isMTS11 = false;
        Locale locale = this.getLocale();
        this.storageUnit = new String[3];
        this.material = new String[17];
        this.planVesion = new String[6];
        PlanerWorkUtil.clearStrings((String[])this.planDate);
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select FName_" + locale + ", FNumber, Fid  ");
            sql.append("from T_ORG_Storage storage where  storage.FNumber in ('");
            sql.append(filter.getString("storageOrgUnit"));
            sql.append("')");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.storageUnit);
        }
        String planVersionNumber = null;
        if (filter.getString("planNum") != null && !"".equals(filter.getString("planNum"))) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 'MRP' ");
            sql.append(", t.fname_" + locale + " , t.fid, 1, t.FNumber, 1 ");
            sql.append(" from CT_BAS_PlanDefined t \n");
            sql.append(" left outer join  t_org_storage s on t.CFStorageOrgID = s.fid \n");
            sql.append(" where t.fnumber in ('");
            sql.append(filter.getString("planNum"));
            sql.append("')");
            sql.append(" and  s.fid in ('");
            sql.append(this.storageUnit[2]);
            sql.append("')");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.planVesion);
            planVersionNumber = filter.getString("planNum");
        }
        if (this.planVesion[2] == null || "".equals(this.planVesion[2].trim())) {
            throw new MMCommonException(MMCommonException.PLANVERSION_NOT_EXIST, new Object[]{planVersionNumber});
        }
        String oql = "SELECT * WHERE ID IN (";
        oql = oql + "SELECT TOP 1 FID FROM T_MRP_PMRPRunLog WHERE FPercent=100 AND FstorageOrgUnitID='" + this.storageUnit[2] + "' and FPlanDefinedID='" + this.planVesion[2] + "' order by fbizdate desc";
        oql = oql + ")";
        PMRPRunLogInfo info = PMRPRunLogFactory.getLocalInstance(this.getContext()).getPMRPRunLogInfo(oql);
        this.calcDetailTbl = info.getMrpCalcDetailTbl();
        if (filter.getString("materialNum") != null && !"".equals(filter.getString("materialNum"))) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct t.fmodel ,t.fname_");
            sql.append(locale);
            sql.append(", unit.fname_");
            sql.append(locale);
            sql.append(" , t.fid ,to_char(p.fmaterialattr),to_char(pm.FPlanningMode),");
            sql.append("to_char(isnull(round(decimal(isnull(im.FQtySafety,0) * u2.FBASECONVSRATE,21,8), isnull(u1.FQTYPRECISION, 4)), 0)),to_char(u1.FQtyPrecision),to_char(ms.fnumber)");
            sql.append(", ISNULL(u3.FBASECONVSRATE, 1), to_char(u3.FQTYPRECISION), prodUnit.fname_");
            sql.append(locale);
            sql.append(", t.fbaseunit, p.FOrgUnitID,p.FIsSurplusDivert,org.FName_l2,org.FNumber ");
            sql.append(" from t_bd_material  t ");
            sql.append(" left outer join t_bd_measureunit unit on t.fbaseunit = unit.fid \n");
            sql.append(" inner join  ").append(info.getMrpCalcDetailTbl()).append(" p on p.fmaterialid =  t.fid \n");
            sql.append(" left outer join t_bd_measureunit prodUnit on p.FOrgUnitID = prodUnit.fid \n");
            sql.append(" inner join t_bd_materialplan pm on pm.fmaterialid =  t.fid and pm.FORGUNIT = p.FSupplyOrgUnitID \n");
            sql.append(" inner join t_org_storage org on org.fid = p.FSupplyOrgUnitID \n");
            sql.append(" left join T_BD_MultiMeasureUnit u3 on pm.FMaterialID=u3.FMaterialID and pm.FProductUnitID=u3.FMeasureUnitID \n");
            sql.append(" left join T_BD_MultiMeasureUnit u1 on t.FID=u1.FMaterialID and t.FBaseUnit=u1.FMeasureUnitID \n");
            sql.append(" left join T_BD_MaterialInventory im on im.fmaterialid =  t.fid and im.FORGUNIT  =  p.FOrgUnitID \n");
            sql.append(" left join T_BD_MultiMeasureUnit u2 on im.FMaterialID=u2.FMaterialID and im.FUnitID=u2.FMeasureUnitID \n");
            sql.append(" left outer join T_BD_ManufactureStrategy ms on pm.FManufactureStrategyID =  ms.fid \n");
            sql.append(" where t.fnumber in ( '");
            sql.append(filter.getString("materialNum"));
            sql.append("')\n");
            sql.append("and p.fmaterialattr=").append(filter.getInt("materialAttr"));
            sql.append("\n");
            sql.append("and p.FOrgUnitID is not null");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.material);
            sql = new StringBuffer();
            sql.append("select  case when t.fisprocessed=0 then '");
            sql.append(this.getResourceString(this.getContext(), this.resClassName, "PROJECT_NO"));
            sql.append("'");
            sql.append(" when t.fisprocessed = 1 then '");
            sql.append(this.getResourceString(this.getContext(), this.resClassName, "PROJECT_YES"));
            sql.append("'");
            sql.append(" else '");
            sql.append(this.getResourceString(this.getContext(), this.resClassName, "PROJECT_NO"));
            sql.append("' end  ");
            sql.append(" ,to_char(log.FBizDate,'YYYY-MM-DD HH24:MI:SS'),log.fnumber  from " + info.getMrpCalcDetailTbl() + " t \n");
            sql.append("inner join T_MRP_PMRPRunLog log on t.frunlogid = log.fid \n");
            sql.append("inner join t_bd_material m on t.fmaterialid=m.fid");
            sql.append(" where m.fnumber in ('");
            sql.append(filter.getString("materialNum"));
            sql.append("') ");
            filter.setString("table", info.getMrpCalcDetailTbl());
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.planDate);
        }
        filter.setString("TABLE", "table");
        PlanerWorkUtil.checkNull((String[])this.storageUnit);
        PlanerWorkUtil.checkNull((String[])this.material);
        PlanerWorkUtil.checkNull((String[])this.planDate);
        PlanerWorkUtil.checkNull((String[])this.planVesion);
        if (this.material[8].indexOf("MTS11") > -1) {
            this.isMTS11 = true;
        }
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.foreColor = Color.BLUE;
        Appearance app = new Appearance();
        app.foreColor = Color.RED;
        Appearance appOrange = new Appearance();
        appOrange.foreColor = new Color(228, 109, 10);
        Appearance appGreen = new Appearance();
        appGreen.foreColor = new Color(52, 162, 107);
        reportFormatConditions.add("FMrpItem", 1, (Object)new BigDecimal("120"), a);
        reportFormatConditions.add("FMrpItem", 1, (Object)new BigDecimal("130"), a);
        reportFormatConditions.add("FMrpItem", 1, (Object)new BigDecimal("131"), a);
        reportFormatConditions.add("FMrpItem", 1, (Object)new BigDecimal("132"), app);
        reportFormatConditions.add("FDataType", 1, (Object)new Integer("1"), appOrange);
        reportFormatConditions.add("FDataType", 1, (Object)new Integer("2"), appGreen);
        reportFormatConditions.add("FMrpItem", 1, (Object)new BigDecimal("110"), a);
        return reportFormatConditions;
    }

    private Locale getLocale() {
        try {
            return this.getContext().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    private void buildStatData(String tableName) throws Exception {
        StringBuffer updateMainTableSql = new StringBuffer();
        updateMainTableSql.append("update ").append(tableName).append(" set FYear=?,FDayOfYear=?,FMonthOfYear=?,FWeekSeq=?,FWeekOfYear=?,FPeriodInCycle=?,FPeriodDispName=? ").append("where FReportDataID=? ");
        this.pvInfo = PlanDefinedFactory.getLocalInstance(this.getContext()).getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(this.planVesion[2]));
        StringBuffer startDateSql = new StringBuffer();
        startDateSql.append("select min(FBillDate) as FStartDate from ").append(tableName);
        IRowSet startDateRs = SQLUtils.executeQuery((Context)this.getContext(), (String)startDateSql.toString());
        java.sql.Date startDate = null;
        if (startDateRs.next()) {
            startDate = startDateRs.getDate("FStartDate");
        }
        if (startDate == null) {
            return;
        }
        StringBuffer mrpDateSql = new StringBuffer();
        String detailTable = this.calcDetailTbl;
        mrpDateSql.append("select top 1 log.FBizDate as FMRPDate from ").append(detailTable).append(" t ");
        mrpDateSql.append("inner join T_MRP_PMRPRunLog log on log.fid=t.frunlogid where t.FMaterialId='").append(this.material[3]).append("'");
        IRowSet mrpDateRs = SQLUtils.executeQuery((Context)this.getContext(), (String)mrpDateSql.toString());
        java.sql.Date mrpDate = null;
        if (mrpDateRs.next()) {
            mrpDate = mrpDateRs.getDate("FMRPDate");
        }
        if (mrpDate == null) {
            return;
        }
        List<PeriodDivideInfo> periodDivision = this.calculatePeriodDivision(startDate, mrpDate, Integer.parseInt(this.pvInfo.getPlanOutlook()));
        StringBuffer sql = new StringBuffer();
        sql.append("select FReportDataID, FBillDate from ").append(tableName).append(" order by KSQL_seq ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.getContext(), (String)sql.toString());
        String reportDataId = null;
        java.sql.Date billDate = null;
        Object[] param = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                reportDataId = rs.getString("FReportDataID");
                billDate = rs.getDate("FBillDate");
                param = PlanerWorkUtil.getUpdateParam((Date)billDate, (String)reportDataId, periodDivision);
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SQLUtils.executeBatch((Context)this.getContext(), (String)updateMainTableSql.toString(), paramList);
    }

    private void updatePab(String tableName) throws BOSException {
        StringBuffer updateMainTableSql = new StringBuffer();
        updateMainTableSql.append("update ").append(tableName).append(" set FPab=?, FMRPItemType=? where FReportDataID=? ");
        StringBuffer sql = new StringBuffer();
        sql.append("select FReportDataID, FMRPItem, FPab, FAmount, FAttachProjectNumber, FAttachTrackNumber from ").append(tableName).append(" order by KSQL_seq ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.getContext(), (String)sql.toString());
        String reportDataId = null;
        BigDecimal mrpItem = null;
        BigDecimal lastPab = new BigDecimal("0.00");
        BigDecimal currentPab = new BigDecimal("0.00");
        HashMap pabMap = new HashMap();
        HashMap invMap = new HashMap();
        BigDecimal saveInv = new BigDecimal("0.00");
        boolean isFirst = false;
        String preProjectNumber = null;
        String preTrackNumber = null;
        String projectNumber = null;
        String trackNumber = null;
        boolean isNewProjectAndTrackNumber = false;
        Object[] param = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                projectNumber = rs.getString("FAttachProjectNumber");
                trackNumber = rs.getString("FAttachTrackNumber");
                isNewProjectAndTrackNumber = this.isNewProjectAndTrackNumber(preProjectNumber, preTrackNumber, projectNumber, trackNumber);
                preProjectNumber = projectNumber;
                preTrackNumber = trackNumber;
                mrpItem = rs.getBigDecimal("FMRPItem");
                boolean isStock = false;
                if (mrpItem.compareTo(new BigDecimal("110")) == 0 || mrpItem.compareTo(new BigDecimal("130")) == 0 || mrpItem.compareTo(new BigDecimal("131")) == 0) {
                    currentPab = new BigDecimal(rs.getObject("FPab").toString());
                    if (mrpItem.compareTo(new BigDecimal("110")) == 0 && rs.getObject("FPab") != null && !this.isMTS11) {
                        BigDecimal startQty;
                        lastPab = currentPab = (startQty = new BigDecimal(rs.getObject("FPab").toString()));
                    }
                    if (mrpItem.compareTo(new BigDecimal("131")) == 0) {
                        isFirst = true;
                    }
                    isStock = true;
                } else if (mrpItem.compareTo(new BigDecimal("132")) == 0) {
                    isStock = true;
                    if (rs.getObject("FAmount") != null) {
                        currentPab = new BigDecimal(rs.getObject("FAmount").toString());
                        if (lastPab.compareTo(new BigDecimal("0.00")) < 0 && isFirst) {
                            currentPab = currentPab.add(lastPab);
                            isFirst = false;
                        }
                        lastPab = currentPab;
                    }
                } else {
                    if (mrpItem.compareTo(new BigDecimal("120")) == 0 || mrpItem.compareTo(new BigDecimal("132")) == 0 || mrpItem.compareTo(new BigDecimal("140")) == 0) {
                        isStock = true;
                    }
                    BigDecimal amoutValue = new BigDecimal("0.00");
                    if (rs.getObject("FAmount") != null) {
                        amoutValue = new BigDecimal(rs.getObject("FAmount").toString());
                    }
                    currentPab = isNewProjectAndTrackNumber ? amoutValue : amoutValue.add(lastPab);
                    lastPab = currentPab;
                }
                reportDataId = rs.getString("FReportDataID");
                int mrpItemType = 0;
                if (isStock) {
                    mrpItemType = 1;
                }
                param = new Object[]{currentPab, new Integer(mrpItemType), reportDataId};
                paramList.add(param);
            }
            SQLUtils.executeBatch((Context)this.getContext(), (String)updateMainTableSql.toString(), paramList);
        }
        catch (Exception e) {
            for (Throwable exception = e.getCause(); exception != null; exception = exception.getCause()) {
                Exception exp;
                if (!(exception instanceof SQLException) || !((exp = JDBCExceptionHandler.convertException((SQLException)((SQLException)exception))) instanceof DataLimitExceedException)) continue;
                String msg = MRPResource.getString((Context)this.getContext(), (String)"RUNDATA_OUTOFRANG");
                MMCommonException commonExcep = new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
                throw new BOSException((Throwable)commonExcep);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isNewProjectAndTrackNumber(String preProjectNumber, String preTrackNumber, String projectNumber, String trackNumber) {
        boolean isNewProjectNumber = false;
        boolean isNewTracNumber = false;
        if (preProjectNumber == null) {
            isNewProjectNumber = projectNumber != null;
        } else {
            boolean bl = isNewProjectNumber = !preProjectNumber.equals(projectNumber);
        }
        isNewTracNumber = preTrackNumber == null ? trackNumber != null : !preTrackNumber.equals(trackNumber);
        return isNewProjectNumber || isNewTracNumber;
    }

    private String createStatTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append(" create TABLE tmpReportData ( ");
        sql.append(" KSQL_SEQ INT IDENTITY (1, 1), ");
        sql.append(" FMrpItemType INT not null default 0, ");
        sql.append(" FYear INT not null default 0, ");
        sql.append(" FWeekSeq INT not null default 0, ");
        sql.append(" FSR NUMERIC(21,8) not null default 0, ");
        sql.append(" FPAB NUMERIC(21,8) not null default 0, ");
        sql.append(" FIndependent NUMERIC(21,8) not null default 0, ");
        sql.append(" FDependent NUMERIC(21,8) not null default 0, ");
        sql.append(" FPeriodInCycle INT not null default 0, ");
        sql.append(" FPeriodDispName NVarchar(80) ");
        sql.append(" ) ");
        return sql.toString();
    }

    private void insertDayStatData(String dayStatTable, String tempTableNameMain) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(dayStatTable);
        sql.append(" (KSQL_SEQ,FMrpItemType,FSR,FIndependent,FDependent, FPeriodDispName) \n");
        sql.append("select ");
        sql.append(" t.FMrpItemType, sum(case when t.fmrpItem=110 then t.FPab else t.FSR end) as FSR, \n");
        sql.append("sum(isnull(case when t.fmrpItem=380 then 0 when t.fmrpItem=120 then t.fAmount ");
        sql.append(" else t.FIndependent end,0)) as FIndependent, \n");
        sql.append("sum(case when t.FMrpItemType=1 then 0 else t.FDependent end) as FDependent, \n");
        sql.append("t.FDayOfYear as FPeriodDispName \n");
        sql.append(" from ").append(tempTableNameMain).append(" t ");
        sql.append("\n group by t.FMrpItemType, t.FDayOfYear order by t.FMrpItemType desc, t.FDayOfYear asc ");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
        this.updateStatData(dayStatTable, tempTableNameMain);
    }

    private void insertWeekStatData(String dayStatTable, String tempTableNameMain) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(dayStatTable);
        sql.append(" (KSQL_SEQ,FMrpItemType,FYear,FWeekSeq,FSR,FIndependent,FDependent, FPeriodDispName) \n");
        sql.append("select ");
        sql.append(" t.FMrpItemType, t.FYear,t.FWeekSeq,sum(case when t.fmrpItem=110 then t.FPab else t.FSR end) as FSR, \n");
        sql.append("sum(isnull(case when t.fmrpItem=380 then 0 when t.fmrpItem=120 then t.fAmount ");
        sql.append(" else t.FIndependent end,0)) as FIndependent, \n");
        sql.append("sum(case when t.FMrpItemType=1 then 0 else t.FDependent end) as FDependent, \n");
        sql.append(" t.FWeekOfYear as FPeriodDispName \n");
        sql.append(" from ").append(tempTableNameMain).append(" t ");
        sql.append("\n group by t.FMrpItemType,t.FYear,t.FWeekSeq,t.FWeekOfYear order by t.FMrpItemType desc, t.FYear asc, t.FWeekSeq asc");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
        this.updateStatData(dayStatTable, tempTableNameMain);
    }

    private void insertMonthStatData(String dayStatTable, String tempTableNameMain) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(dayStatTable);
        sql.append(" (KSQL_SEQ,FMrpItemType,FSR,FIndependent,FDependent, FPeriodDispName) \n");
        sql.append("select ");
        sql.append(" t.FMrpItemType, sum(case when t.fmrpItem=110 then t.FPab else t.FSR end) as FSR, \n");
        sql.append("sum(isnull(case when t.fmrpItem=380 then 0 when t.fmrpItem=120 then t.fAmount ");
        sql.append(" else t.FIndependent end,0)) as FIndependent, \n");
        sql.append("sum(case when t.FMrpItemType=1 then 0 else t.FDependent end) as FDependent, \n");
        sql.append(" t.FMonthOfYear as FPeriodDispName \n");
        sql.append(" from ").append(tempTableNameMain).append(" t ");
        sql.append("\n group by t.FMrpItemType,t.FMonthOfYear order by t.FMrpItemType desc,t.FMonthOfYear asc");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
        this.updateStatData(dayStatTable, tempTableNameMain);
    }

    private void insertPeriodStatData(String dayStatTable, String tempTableNameMain) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(dayStatTable);
        sql.append(" (KSQL_SEQ,FMrpItemType,FSR,FIndependent,FDependent, FPeriodDispName, FPeriodInCycle) \n");
        sql.append("select ");
        sql.append(" t.FMrpItemType, sum(case when t.fmrpItem=110  then t.FPab else t.FSR end) as FSR, \n");
        sql.append("sum(isnull(case when t.fmrpItem=380 then 0 when t.fmrpItem=120 then t.fAmount ");
        sql.append(" else t.FIndependent end,0)) as FIndependent, \n");
        sql.append("sum(case when t.FMrpItemType=1 then 0 else t.FDependent end) as FDependent, \n");
        sql.append(" FPeriodDispName as FPeriodDispName, FPeriodInCycle \n");
        sql.append(" from ").append(tempTableNameMain).append(" t ");
        sql.append("\n group by t.FMrpItemType,t.FPeriodDispName,t.FPeriodInCycle order by t.FMrpItemType desc, t.FPeriodInCycle asc");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from ").append(dayStatTable);
        sql.append(" where FMrpItemType=0 and FPeriodDispName is null ");
        SQLUtils.execute((Context)this.getContext(), (String)sql.toString());
        this.updateStatData(dayStatTable, tempTableNameMain);
    }

    private void updateStatData(String statTable, String tempTableNameMain) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.setLength(0);
        updateSql.append("update ").append(statTable).append(" set FPAB=? where KSQL_SEQ=?");
        StringBuffer sql = new StringBuffer();
        sql.append("select KSQL_SEQ, FMrpItemType, (FSR+FIndependent+FDependent) as FAmount, FPab from ").append(statTable).append(" order by KSQL_seq ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.getContext(), (String)sql.toString());
        Object[] param = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BigDecimal lastPab = new BigDecimal("0.00");
        BigDecimal currentPab = new BigDecimal("0.00");
        int seq = 0;
        try {
            while (rs.next()) {
                seq = rs.getInt("KSQL_SEQ");
                BigDecimal amoutValue = new BigDecimal("0.00");
                amoutValue = new BigDecimal(rs.getObject("FAmount").toString());
                lastPab = currentPab = amoutValue.add(lastPab);
                param = new Object[]{currentPab, new Integer(seq)};
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        SQLUtils.executeBatch((Context)this.getContext(), (String)updateSql.toString(), paramList);
    }

    private List<PeriodDivideInfo> calculatePeriodDivision(Date startDate, Date mrpDate, int horizon) {
        boolean isEqualCycle = true;
        PlanningHorizonUnitEnum horizonUnit = PlanningHorizonUnitEnum.WEEK;
        BalanceAllocationRuleEnum balanceAllocationRule = BalanceAllocationRuleEnum.UNITEATLAST;
        ArrayList<PeriodDivideInfo> periods = new ArrayList<PeriodDivideInfo>();
        Calendar divideDate = PMRPPlanerWorkPlatformMaterialServer.getCalendar(startDate);
        Calendar mrpCalendar = PMRPPlanerWorkPlatformMaterialServer.getCalendar(mrpDate);
        long interval = (mrpCalendar.getTimeInMillis() - divideDate.getTimeInMillis()) / 86400000L;
        divideDate.add(6, -1);
        Calendar endDate = (Calendar)divideDate.clone();
        endDate.add(6, horizon + new Long(interval).intValue());
        Calendar lastDivideDate = (Calendar)divideDate.clone();
        PeriodDivideInfo pdInfo = null;
        Calendar entryEndDate = null;
        while (divideDate.before(endDate)) {
            lastDivideDate.add(6, 1);
            PMRPPlanerWorkPlatformMaterialServer.rollDate(divideDate, 1, horizonUnit.getValue());
            pdInfo = new PeriodDivideInfo(lastDivideDate, (Calendar)divideDate.clone(), isEqualCycle, horizonUnit);
            periods.add(pdInfo);
            lastDivideDate = (Calendar)divideDate.clone();
        }
        if (divideDate.after(endDate) && (entryEndDate == null || entryEndDate.before(endDate))) {
            if (BalanceAllocationRuleEnum.UNITEATLAST.equals((Object)balanceAllocationRule)) {
                periods.remove(periods.size() - 1);
                if (!periods.isEmpty()) {
                    PeriodDivideInfo obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                    obj.setEndDate(endDate);
                }
            } else if (BalanceAllocationRuleEnum.ADDCYCLE.equals((Object)balanceAllocationRule)) {
                if (!periods.isEmpty()) {
                    PeriodDivideInfo obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                    obj.setDisplayName(this.getResourceString(this.getContext(), "com.kingdee.eas.mm.report.PlannerResource", "PERIOD_SUPLUS"));
                    obj.setEndDate(endDate);
                }
            } else if (!periods.isEmpty()) {
                periods.remove(periods.size() - 1);
            }
        } else if (divideDate.before(endDate)) {
            if (BalanceAllocationRuleEnum.UNITEATLAST.equals((Object)balanceAllocationRule)) {
                if (!periods.isEmpty()) {
                    PeriodDivideInfo obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                    obj.setEndDate(endDate);
                }
            } else if (BalanceAllocationRuleEnum.ADDCYCLE.equals((Object)balanceAllocationRule)) {
                lastDivideDate.add(6, 1);
                pdInfo = new PeriodDivideInfo(lastDivideDate, endDate, isEqualCycle, horizonUnit);
                pdInfo.setDisplayName(this.getResourceString(this.getContext(), "com.kingdee.eas.mm.report.PlannerResource", "PERIOD_SUPLUS"));
                periods.add(pdInfo);
            }
        }
        return periods;
    }

    private static void rollDate(Calendar date, int length, int periodUnit) {
        switch (periodUnit) {
            case 10: {
                date.add(6, length);
                break;
            }
            case 20: {
                int dayOfWeek = date.get(7);
                int maxOfWeek = date.getActualMaximum(7);
                if (dayOfWeek > 1) {
                    date.add(7, maxOfWeek + 1 - dayOfWeek);
                    date.add(3, length - 1);
                    break;
                }
                date.add(3, length);
                break;
            }
            case 40: {
                int dayOfMonth = date.get(5);
                int maxOfMonth = date.getActualMaximum(5);
                if (dayOfMonth > 1 && dayOfMonth < maxOfMonth) {
                    date.add(5, maxOfMonth - dayOfMonth);
                    date.add(2, length - 1);
                    break;
                }
                date.add(2, length);
                break;
            }
            default: {
                date.add(6, length);
            }
        }
    }

    private static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar1 = (Calendar)calendar.clone();
        calendar1.set(calendar.get(1), 0, 1);
        int firstDay = calendar1.get(7);
        int minimalDaysInFirstWeek = 1;
        if (firstDay > 1) {
            minimalDaysInFirstWeek = calendar1.getMaximum(7) - firstDay + 2;
        }
        calendar.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        return calendar;
    }
}

