/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.platform;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.planning.MRPAjustEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.customization.CustomizationConfigBase;
import com.kingdee.eas.mm.report.IReportServer;
import com.kingdee.eas.mm.report.util.PlanerWorkUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PMRPPlanerWorkPlatformTotalServer
extends AbstractBOSObject
implements IReportServer {
    private static Logger logger = Logger.getLogger((String)PMRPPlanerWorkPlatformTotalServer.class.getName());
    public static final String EXCEPTION_TABLE_NAME = "exceptionTableName";
    public static final String COLLECTION_TABLE_NAME = "collectionTableName";
    public static final String ADJUST_TABLE_NAME = "adjustTableName";
    public static final String EXCEPTION_DETAIL_TABLE_NAME = "exceptionDetailTableName";
    private String[] storageUnit = new String[3];
    private String[] planVesion = new String[1];
    private String calcDetailTbl;
    public static final String REPORT_TITLE = "reporttTitle";
    private boolean isByLed = false;
    private static final String COLUMN_KEY = "Ksql_seq1";
    private String resClassName = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    public HashMap<?, ?> getData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ");
        sql.append(tableName);
        sql.append("   where ");
        if (this.isByLed) {
            sql.append(COLUMN_KEY);
        } else {
            sql.append(" KSQL_seq ");
        }
        sql.append(" >=");
        sql.append(new Integer(start).toString());
        if (this.isByLed) {
            sql.append(" and Ksql_seq1 < ");
        } else {
            sql.append(" and KSQL_seq <");
        }
        sql.append(new Integer(start + rows).toString());
        sql.append(" order by ");
        if (this.isByLed) {
            sql.append(COLUMN_KEY);
        } else {
            sql.append(" KSQL_seq ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    public HashMap<?, ?> prepareData(String reportID, RptParams filter, String tableName) throws BaseException {
        this.buildTitles(filter);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String exceptionTableName = null;
        String collectionTableName = null;
        String adjustTableName = null;
        String adjustTableName_Temp = null;
        String exceptionDetailTableName = null;
        try {
            exceptionTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getCreateExceptionTableSql().toString());
            collectionTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getTempCollectTable().toString());
            adjustTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getCreateAdjustTableSql());
            adjustTableName_Temp = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getCreateAdjustTableSql());
            exceptionDetailTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getTempExceptionTable());
            DbUtil.execute((Context)this.getContext(), (String)this.insertIntoExceptionTable(exceptionTableName, filter));
            DbUtil.execute((Context)this.getContext(), (String)this.insertIntoCollectTable(collectionTableName, exceptionTableName, filter));
            DbUtil.execute((Context)this.getContext(), (String)this.insertIntoAdjustTable(adjustTableName_Temp, exceptionTableName, filter));
            this.mergeAdjustTableName(this.getContext(), adjustTableName_Temp, adjustTableName);
            DbUtil.execute((Context)this.getContext(), (String)this.updateTempCollectTable(collectionTableName));
            this.updateTempExceptionTable(exceptionDetailTableName, exceptionTableName, filter);
            String strLedAll = filter.getString("Led_All");
            if (strLedAll != null && strLedAll.toUpperCase(Locale.ENGLISH).equals("FALSE")) {
                this.isByLed = true;
                this.filterExceptionColor(exceptionTableName, collectionTableName, adjustTableName, filter);
                this.resetAutoSeq(exceptionTableName);
                this.resetAutoSeq(collectionTableName);
                this.resetAutoSeq(adjustTableName);
            } else {
                this.isByLed = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"79_PlanerWorkPlatformServer", (Locale)this.getContext().getLocale()) + e.getCause()));
            for (Throwable exception = e.getCause(); exception != null; exception = exception.getCause()) {
                Exception exp;
                if (!(exception instanceof SQLException) || !((exp = JDBCExceptionHandler.convertException((SQLException)((SQLException)exception))) instanceof DataLimitExceedException)) continue;
                String msg = MRPResource.getString((Context)this.getContext(), (String)"RUNDATA_OUTOFRANG");
                MMCommonException commonExcep = new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
                throw new BOSException((Throwable)commonExcep);
            }
            throw new BOSException((Throwable)e);
        }
        result.put(EXCEPTION_TABLE_NAME, exceptionTableName);
        result.put(COLLECTION_TABLE_NAME, collectionTableName);
        result.put(ADJUST_TABLE_NAME, adjustTableName);
        result.put(REPORT_TITLE, this.storageUnit);
        result.put(EXCEPTION_DETAIL_TABLE_NAME, exceptionDetailTableName);
        return result;
    }

    public void dropTempTable(String reportID, RptParams filter, String tableName) throws BaseException {
        if (tableName != null && !"".equalsIgnoreCase(tableName.trim())) {
            TempTablePool.getInstance((Context)this.getContext()).releaseTable(tableName);
        }
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        return null;
    }

    public BOSObjectType getType() {
        return null;
    }

    protected StringBuffer getCreateExceptionTableSql() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getPlanerWorkPlatform(");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FPlanNum        nvarchar(80)  DEFAULT(' ')");
        createTable.append(",FMaterialNum   nvarchar(80)   DEFAULT(' ')");
        createTable.append(",FMaterialName  nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FMaterialModel  nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FMaterialAtr   Integer        DEFAULT(0)");
        createTable.append(",Fprocess       varchar(10)    DEFAULT(' ')");
        createTable.append(",FProcessedRemark   varchar(500)   ");
        createTable.append(",Fexception1     Integer       DEFAULT(0)");
        createTable.append(",Fexception2     Integer       DEFAULT(0)");
        createTable.append(",Fexception3     Integer       DEFAULT(0)");
        createTable.append(",Fexception4     Integer       DEFAULT(0)");
        createTable.append(",Fexception5     Integer       DEFAULT(0)");
        createTable.append(",Fexception6     Integer       DEFAULT(0)");
        createTable.append(",Fexception7     Integer       DEFAULT(0)");
        createTable.append(",Fexception8 Integer  DEFAULT(0) ");
        createTable.append(",Funit          nvarchar(55)   DEFAULT(' ')");
        createTable.append(",FStorageNum   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FsafeStock   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",Fplanner      nvarchar(44)    DEFAULT(' ')");
        createTable.append(",FMRPDate      nvarchar(255)         ");
        createTable.append(",FBaseQtyPrc     Integer      DEFAULT(4)");
        createTable.append(",FMaterialId    varchar(44)   DEFAULT(' ')");
        createTable.append(",FColor          Integer      DEFAULT(-1)");
        createTable.append(",FProjectID varchar(44)");
        createTable.append(",FProjectNumber varchar(100)");
        createTable.append(" ) ");
        return createTable;
    }

    protected String getTempExceptionTable() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempExceptionTable(");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) ");
        createTable.append(",FDetailID           varchar(44)   DEFAULT(' ')");
        createTable.append(",FMaterialID         varchar(44)   DEFAULT(' ')");
        createTable.append(",FExceptionNumber    varchar(80)   DEFAULT(' ')");
        createTable.append(" ) ");
        return createTable.toString();
    }

    private String getCreateAdjustTableSql() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getTempPlanAdvice( ");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null ");
        createTable.append(",FMaterialID      nvarchar(44)   DEFAULT(' ') ");
        createTable.append(",FMaterialNum     nvarchar(80)   DEFAULT(' ') ");
        createTable.append(",FMaterialName    nvarchar(200)  DEFAULT(' ') ");
        createTable.append(",FMaterialModel   nvarchar(255)   DEFAULT(' ') ");
        createTable.append(",FMaterialAttr    nvarchar(255)   DEFAULT(' ') ");
        createTable.append(",FBillNumber      varchar(80)    DEFAULT(' ') ");
        createTable.append(",FBizTypeID       varchar(44)    DEFAULT(' ') ");
        createTable.append(",FBillTypeID      varchar(44)    DEFAULT(' ') ");
        createTable.append(",FSrcBillTypeName      varchar(255)    DEFAULT(' ') ");
        createTable.append(",FSrcBillID      \t  varchar(44)    DEFAULT(' ') ");
        createTable.append(",FSrcBillEntryID      \t  varchar(44)    DEFAULT(' ') ");
        createTable.append(",FSrcBillQty         NUMERIC(21,8)  DEFAULT(0)   ");
        createTable.append(",FSrcBillDate        DateTime                    ");
        createTable.append(",FBizTypeName     varchar(200)   DEFAULT(' ') ");
        createTable.append(",FBillState       Integer        DEFAULT(0)   ");
        createTable.append(",FBeginDate       DateTime                    ");
        createTable.append(",FCompletionDate  DateTime                    ");
        createTable.append(",FOrderQty        NUMERIC(21,8)  DEFAULT(0)   ");
        createTable.append(",FResetDate       DateTime                    ");
        createTable.append(",FResetQty        NUMERIC(21,8)  DEFAULT(0)   ");
        createTable.append(",FAdjustDay       Integer        DEFAULT(0)   ");
        createTable.append(",FAdjustType      nvarchar(10)                ");
        createTable.append(",FBillStateName   nvarchar(44)                 ");
        createTable.append(",FMaterialUnit    nvarchar(55)   DEFAULT(' ') ");
        createTable.append(",FBaseQtyPrc      Integer        DEFAULT(4)   ");
        createTable.append(",Fexception1      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception2      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception3      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception4      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception5      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception6      Integer        DEFAULT(0)   ");
        createTable.append(",Fexception7      Integer        DEFAULT(0)   ");
        createTable.append(",FAvailableDate   DateTime   ");
        createTable.append(",FTrackNumber     nvarchar(255)   DEFAULT(' ') ");
        createTable.append(",FDetailID   nvarchar(44)   ");
        createTable.append(",FISProcessed   Integer default(0)   ");
        createTable.append(",FProcessedRemark   varchar(500)   ");
        createTable.append(",FProjectID varchar(44)");
        createTable.append(",FProjectNumber varchar(100)");
        createTable.append(" ) ");
        return createTable.toString();
    }

    protected StringBuffer getTempCollectTable() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getPlanerWorkPlatformCollent(");
        createTable.append("KSQL_SEQ INT IDENTITY (1, 1) not null");
        createTable.append(",FMaterialNum   nvarchar(80)   DEFAULT(' ')");
        createTable.append(",FMaterialName  nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FMaterialModel   nvarchar(255)  DEFAULT(' ')");
        createTable.append(",FMaterialUnit          nvarchar(55)   DEFAULT(' ')");
        createTable.append(",FMaterialAttr          nvarchar(55)   DEFAULT(' ')");
        createTable.append(",FsafeStock   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FgRuqQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FcurStoreQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FperiodStoreQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FinvStoreQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FpurveyQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FrequirementQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FplannedOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FplannOrderCoByProductQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FpurRequestQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FpurContractQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FpurReqOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FouterPurReqQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FouterPurQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FstockTransferBillQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FtransferOrderBillQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FprodOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FmanufactureOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FrequirementPlanQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FparentPlanOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FouterPurReqEntryQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FouterOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FprodOrderReqQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FmanufactureOrderReqQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FSubstituteSupplyQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FSubstituteDemandQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FCoPlanOrderQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FpreUsedQty   NUMERIC(21,8)   DEFAULT(0)");
        createTable.append(",FMaterialId    varchar(44)   DEFAULT(' ')");
        createTable.append(",FBaseQtyPrc     Integer      DEFAULT(4)");
        createTable.append(",Fexception1     Integer       DEFAULT(0)");
        createTable.append(",Fexception2     Integer       DEFAULT(0)");
        createTable.append(",Fexception3     Integer       DEFAULT(0)");
        createTable.append(",Fexception4     Integer       DEFAULT(0)");
        createTable.append(",Fexception5     Integer       DEFAULT(0)");
        createTable.append(",Fexception6     Integer       DEFAULT(0)");
        createTable.append(",Fexception7     Integer       DEFAULT(0)");
        createTable.append(",FProjectID varchar(44)");
        createTable.append(",FProjectNumber varchar(100)");
        createTable.append(" ) ");
        return createTable;
    }

    private String insertIntoExceptionTable(String tempTableNameMain, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into  " + tempTableNameMain + "( ");
        sql.append("KSQL_SEQ ,FPlanNum , FMaterialNum , FMaterialName , FMaterialAtr ,Fprocess \n ");
        sql.append(",Funit ,FStorageNum  \n");
        sql.append(",Fplanner , FMRPDate ,FBaseQtyPrc ,FMaterialId, ").append("FException1,FException2,FException3,FException4,FException5,FException6,FException7, ").append("FException8,FsafeStock, FMaterialModel, FProjectID, FProjectNumber,FProcessedRemark) (\n");
        sql.append(this.getExceptionQuerySql(filter)).append(")");
        return sql.toString();
    }

    private String buildException(RptParams filter, String tempTableAlias) {
        String whereStr;
        StringBuffer sql = new StringBuffer();
        StringBuffer where2 = new StringBuffer();
        boolean flag = true;
        if (filter.getString("exception_none") != null && filter.getString("exception_none").equalsIgnoreCase("true")) {
            where2.append(" ( (" + tempTableAlias + ".FException1 = 0  and  ");
            where2.append(tempTableAlias + ".FException2 =0  and  ");
            where2.append(tempTableAlias + ".FException3 = 0 and   ");
            where2.append(tempTableAlias + ".FException4 = 0 and  ");
            where2.append(tempTableAlias + ".FException5 = 0 and  ");
            where2.append(tempTableAlias + ".FException6 = 0 and  ");
            where2.append(tempTableAlias + ".FException7 = 0 and  ");
            where2.append(tempTableAlias + ".FException8 = 0)  ");
            flag = false;
        }
        if (filter.getString("exception_1") != null && filter.getString("exception_1").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException1 > 1 ");
        }
        if (filter.getString("exception_2") != null && filter.getString("exception_2").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException2 > 1 ");
        }
        if (filter.getString("exception_3") != null && filter.getString("exception_3").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException3 > 1 ");
        }
        if (filter.getString("exception_7") != null && filter.getString("exception_7").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException7 > 1 ");
        }
        if (filter.getString("exception_4") != null && filter.getString("exception_4").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException4 > 1 ");
        }
        if (filter.getString("exception_5") != null && filter.getString("exception_5").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException5 > 1 ");
        }
        if (filter.getString("exception_6") != null && filter.getString("exception_6").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException6 > 1 ");
        }
        if (filter.getString("exception_8") != null && filter.getString("exception_8").equalsIgnoreCase("true")) {
            if (flag) {
                sql.append(" and ( ");
            } else {
                sql.append(" or  ");
            }
            flag = false;
            sql.append(tempTableAlias + ".FException8 > 1 ");
        }
        if (!flag) {
            sql.append("  )");
        }
        if (sql.length() > 3) {
            sql.replace(0, 4, " or ");
        }
        if ((whereStr = where2.toString()).length() == 0) {
            sql.replace(0, 3, " ");
        }
        String str = sql.toString();
        return " and ( " + whereStr + str + " ) ";
    }

    private void buildTitles(RptParams filter) throws BaseException {
        StringBuffer sql;
        Locale locale = this.getContext().getLocale();
        PlanerWorkUtil.clearStrings((String[])this.storageUnit);
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            sql = new StringBuffer();
            sql.append(" select FName_" + locale + ", FNumber, Fid  ");
            sql.append("from T_ORG_Storage storage where  storage.FNumber in ('");
            sql.append(filter.getString("storageOrgUnit"));
            sql.append("')");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.storageUnit);
        }
        if (filter.getString("planNumFrom") != null && !"".equals(filter.getString("planNumFrom"))) {
            sql = new StringBuffer();
            sql.append("select t.fid ");
            sql.append(" from CT_BAS_PlanDefined t \n");
            sql.append(" left outer join  t_org_storage s on t.CFStorageOrgID = s.fid \n");
            sql.append(" where t.fnumber in ('");
            sql.append(filter.getString("planNumFrom"));
            sql.append("')");
            sql.append(" and  s.fid in ('");
            sql.append(this.storageUnit[2]);
            sql.append("')");
            PlanerWorkUtil.getTitleFields((StringBuffer)sql, (Context)this.getContext(), (String[])this.planVesion);
        }
        if (this.planVesion[0] == null || "".equals(this.planVesion[0].trim())) {
            throw new MMCommonException(MMCommonException.PLANVERSION_NOT_EXIST, new Object[]{filter.getString("planNumFrom")});
        }
        String oql = "SELECT * WHERE ID IN (";
        oql = oql + "SELECT TOP 1 FID FROM T_MRP_PMRPRunLog WHERE FPercent=100 AND FstorageOrgUnitID='" + this.storageUnit[2];
        oql = oql + "' and FPlanDefinedID='" + this.planVesion[0];
        oql = oql + "' and FMRPCalcDetailTbl IS NOT NULL order by fbizdate desc";
        oql = oql + ")";
        try {
            PMRPRunLogInfo info = PMRPRunLogFactory.getLocalInstance(this.getContext()).getPMRPRunLogInfo(oql);
            this.calcDetailTbl = info.getMrpCalcDetailTbl();
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(this.getContext(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0000")));
        }
    }

    public int executeUpdateProcess(String sqlParams) throws BaseException {
        throw new BaseException("un implemented");
    }

    public int executeUpdateProcess(ArrayList list) throws BaseException {
        String FProcessedRemark = null;
        UserInfo curUserInfo = (UserInfo)this.getContext().get((Object)"UserInfo");
        Timestamp now = new Timestamp(new Date().getTime());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String detailTbl = this.calcDetailTbl;
        StringBuffer updateSQL = new StringBuffer();
        if (list.isEmpty()) {
            return -2;
        }
        boolean withFID = String.valueOf(list.get(0)).split(":").length > 3;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String[] params = ((String)iter.next()).split(":");
            FProcessedRemark = new Integer(params[1]) == 1 ? this.getResourceString(this.getContext(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0003") + curUserInfo.getName() + sdf.format(now) : "";
            updateSQL.setLength(0);
            updateSQL.append("update ");
            updateSQL.append(detailTbl);
            updateSQL.append(" set fisprocessed=").append(params[1]);
            updateSQL.append(" , FProcessedRemark= '").append(FProcessedRemark).append("'");
            updateSQL.append(" where FMaterialID=(select fid from t_bd_material where fnumber='").append(params[0]).append("')");
            updateSQL.append(" and FMaterialAttr=").append(params[2]);
            if (withFID) {
                updateSQL.append(" and FID in('").append(params[3]).append("') ");
            }
            DbUtil.execute((Context)this.getContext(), (String)updateSQL.toString());
        }
        return 0;
    }

    private String insertIntoCollectTable(String tempCollectTableName, String exceptionTableName, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into  " + tempCollectTableName + "( ");
        sql.append("KSQL_SEQ , FMaterialNum , FMaterialName , FMaterialModel , FmaterialUnit , FsafeStock \n ");
        sql.append(",FcurStoreQty,FperiodStoreQty,FinvStoreQty,FplannedOrderQty ,FplannOrderCoByProductQty  \n");
        sql.append(",FpurRequestQty ,FpurContractQty, FpurReqOrderQty ,FouterPurReqQty , FouterPurQty, FstockTransferBillQty \n");
        sql.append(",FtransferOrderBillQty ,FprodOrderQty ,FmanufactureOrderQty ,FrequirementPlanQty \n");
        sql.append(",FparentPlanOrderQty,FouterPurReqEntryQty ,FouterOrderQty ,FprodOrderReqQty ,FmanufactureOrderReqQty \n");
        sql.append(",FMaterialId,FrequirementQty,FpurveyQty,FBaseQtyPrc, FSubstituteSupplyQty, FSubstituteDemandQty,FCoPlanOrderQty, FMaterialAttr, FProjectID, FProjectNumber)\n");
        if (this.isSupportCoByProduct()) {
            sql.append(this.getCollectionForCoByProQuerySql(exceptionTableName, filter));
        } else {
            sql.append(this.getCollectionQuerySql(exceptionTableName, filter));
        }
        return sql.toString();
    }

    private String updateTempCollectTable(String tempCollectTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempCollectTableName).append(" set FgRuqQty=FrequirementQty ,FpreUsedQty=FcurStoreQty+FpurveyQty+FrequirementQty");
        return sql.toString();
    }

    public HashMap<?, ?> getAjust(RptParams filter) throws BaseException {
        return null;
    }

    private boolean isSupportCoByProduct() {
        CustomizationConfigBase configBase = new CustomizationConfigBase();
        return configBase.getCoByProductCustomFlag();
    }

    private static Locale getLocale() {
        try {
            return ContextUtils.getContextFromSession().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    private String insertIntoAdjustTable(String tempPlanAdviceTableName, String exceptionTableName, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into  " + tempPlanAdviceTableName + "( ");
        sql.append(" KSQL_SEQ,FMaterialID,FMaterialNum,FMaterialName,FMaterialModel,FBillNumber,");
        sql.append(" FBeginDate,FCompletionDate,FOrderQty,FResetDate,FResetQty,");
        sql.append(" FAdjustDay,FBizTypeID,FBillState,FBillTypeID,FBillStateName,FAdjustType,FMaterialUnit,FBaseQtyPrc, ");
        sql.append(" FBizTypeName, FavailableDate, FTrackNumber, FMaterialAttr, FDetailID, FISProcessed, FProjectID, FProjectNumber, FSrcBillTypeName, FSrcBillID, FSrcBillEntryID, FSrcBillQty, FSrcBillDate,FProcessedRemark)\r\n");
        sql.append(this.getAdjustQuerySql(exceptionTableName, filter));
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempExceptionTable(String tempExceptionTable, String tempTableNameMain, RptParams filter) throws BOSException {
        String detailTbl = this.calcDetailTbl;
        StringBuffer insert = new StringBuffer();
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException1) from ").append(detailTbl);
        insert.append(" where FException1 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException2) from ").append(detailTbl).append(" ");
        insert.append(" where FException2 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException3) from ").append(detailTbl).append(" ");
        insert.append(" where FException3 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException4) from ").append(detailTbl).append(" ");
        insert.append(" where FException4 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException5) from ").append(detailTbl).append(" ");
        insert.append(" where FException5 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException6) from ").append(detailTbl).append(" ");
        insert.append(" where FException6 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException7) from ").append(detailTbl).append(" ");
        insert.append(" where FException7 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select FID,FMaterialID,to_char(FException8) from ").append(detailTbl).append(" ");
        insert.append(" where FException8 <> 0 ");
        insert.append(this.buildException(filter, detailTbl));
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" insert into ").append(tempExceptionTable).append("(FDetailID,FMaterialID,FExceptionNumber)");
        insert.append(" select ' ',FMaterialID,to_char(FhasStockExp) from ").append(detailTbl).append(" ");
        insert.append(" where FhasStockExp >0 ");
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        Statement pstmt = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            pstmt = conn.createStatement();
            pstmt.execute("CREATE INDEX " + PMRPPlanerWorkPlatformTotalServer.getValidIndexName(this.getContext()) + " ON " + tempExceptionTable + " (FMaterialID)");
            pstmt.execute("CREATE INDEX " + PMRPPlanerWorkPlatformTotalServer.getValidIndexName(this.getContext()) + " ON " + tempExceptionTable + " (FExceptionNumber)");
            pstmt.execute("CREATE INDEX " + PMRPPlanerWorkPlatformTotalServer.getValidIndexName(this.getContext()) + " ON " + tempTableNameMain + " (FMaterialID)");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        insert.setLength(0);
        insert.append(" update ").append(tempExceptionTable).append(" set fexceptionnumber = '03' where fexceptionnumber = '3' ");
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        insert.append(" update ").append(tempExceptionTable).append(" set fexceptionnumber = '02' where fexceptionnumber = '2' ");
        DbUtil.execute((Context)this.getContext(), (String)insert.toString());
        insert.setLength(0);
        StringBuffer update = new StringBuffer();
        update.append(" update  ").append(tempTableNameMain).append(" as t10 set (FColor) = ");
        update.append(" ( select tt.prio from ");
        update.append(" ( select  min(FPriority) as prio,t2.FMaterialID as mid from T_MM_MRPRunException as t1 inner join  ");
        update.append(tempExceptionTable).append(" as t2 ");
        update.append(" on t1.FNumber = t2.FExceptionNumber where t1.FStorageOrgUnitID = '" + this.storageUnit[2] + "' group by t2.FMaterialID) as tt ");
        update.append(" where t10.FMaterialID = tt.mid)");
        DbUtil.execute((Context)this.getContext(), (String)update.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIndexExists(Context ctx, String indexName) throws SQLException {
        boolean bl;
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ? )";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, indexName);
            rs = pstmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }

    private static String getValidIndexName(Context ctx) throws SQLException {
        String indexName;
        do {
            indexName = new UUTN("ZC").toString();
            if ((indexName = indexName.replaceFirst("ZC", "T_EMM_DT")).length() <= 10) continue;
            indexName = indexName.substring(0, 10);
        } while (PMRPPlanerWorkPlatformTotalServer.isIndexExists(ctx, indexName));
        return indexName;
    }

    private String getCollectionQuerySql(String exceptionTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        String detailTbl = this.calcDetailTbl;
        sql.append("select m.fnumber  as FMaterialNum,\n");
        sql.append("m.fname_" + PMRPPlanerWorkPlatformTotalServer.getLocale() + " as FMaterialName, \n");
        sql.append("m.FModel as FMaterialModel,\n");
        sql.append("unit.fname_" + PMRPPlanerWorkPlatformTotalServer.getLocale() + " as FmaterialUnit,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FSafeStock,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as FSafeStock,\n");
        sql.append("round(decimal((isnull(exceptionDetail.FStorageNum,0)-isnull(exceptionDetail.FSafeStock,0))/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as fcurStoreQty,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FSafeStock,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as fPeriodStoreQty,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FStorageNum,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as invStoreQty,\n");
        sql.append("isnull(supply.fplannedOrderQty,0) as fplannedOrderQty,\n");
        sql.append("0 as fplannOrderCoByProductQty, -- materialGroup.fplannOrderCoByProductQty\n");
        sql.append("isnull(supply.fpurRequestQty,0) as fpurRequestQty,\n");
        sql.append("isnull(supply.fpurContractQty,0) as fpurContractQty,\n");
        sql.append("isnull(supply.fpurReqOrderQty,0) as fpurReqOrderQty,\n");
        sql.append("isnull(supply.fouterPurReqQty,0) as fouterPurReqQty,\n");
        sql.append("isnull(supply.fouterPurQty,0) as fouterPurQty,\n");
        sql.append("isnull(supply.fstockTransferBillQty,0) as fstockTransferBillQty,\n");
        sql.append("isnull(supply.ftransferOrderBillQty,0) as ftransferOrderBillQty,\n");
        sql.append("isnull(supply.fprodOrderQty,0) as fprodOrderQty,\n");
        sql.append("isnull(supply.fmanufactureOrderQty,0) as fmanufactureOrderQty,\n");
        sql.append("isnull(materialGroup.frequirementPlanQty,0) as frequirementPlanQty,\n");
        sql.append("isnull(materialGroup.fparentPlanOrderQty,0) as fparentPlanOrderQty,\n");
        sql.append("isnull(materialGroup.fouterPurReqEntryQty,0) as fouterPurReqEntryQty,\n");
        sql.append("isnull(materialGroup.fouterOrderQty,0) as fouterOrderQty,\n");
        sql.append("isnull(materialGroup.fprodOrderReqQty,0) as fprodOrderReqQty,\n");
        sql.append("isnull(materialGroup.fmanufactureOrderReqQty,0) as fmanufactureOrderReqQty ,\n");
        sql.append("exceptionDetail.fMaterialId as fmaterialid,\n");
        sql.append("(isnull(materialGroup.FrequirementPlanQty,0) +\n");
        sql.append(" isnull(materialGroup.FparentPlanOrderQty,0) +\n");
        sql.append(" isnull(materialGroup.fouterPurReqEntryQty,0) +\n");
        sql.append(" isnull(materialGroup.FouterOrderQty,0) +\n");
        sql.append(" isnull(materialGroup.FprodOrderReqQty,0) +\n");
        sql.append(" isnull(materialGroup.fmanufactureOrderReqQty,0) +\n");
        sql.append(" isnull(materialGroup.fSubstituteDemandQty,0) \n");
        sql.append(") as FrequirementQty,\n");
        sql.append("(isnull(FplannedOrderQty,0) +\n");
        sql.append(" isnull(FCoPlanOrderQty,0) +\n");
        sql.append(" isnull(FpurRequestQty,0) +\n");
        sql.append(" isnull(FpurContractQty,0) +\n");
        sql.append(" isnull(FpurReqOrderQty,0) + \n");
        sql.append(" isnull(FouterPurReqQty,0)+\n");
        sql.append(" isnull(FouterPurQty,0) +\n");
        sql.append(" isnull(FstockTransferBillQty,0) +\n");
        sql.append(" isnull(FtransferOrderBillQty,0) +\n");
        sql.append(" isnull(FprodOrderQty,0) +\n");
        sql.append(" isnull(FmanufactureOrderQty,0) +\n");
        sql.append(" isnull(fSubstituteSupplyQty,0) \n");
        sql.append(") as FpurveyQty,\n");
        sql.append("mu.FQtyPrecision as FBaseQtyPrc,\n");
        sql.append("isnull(materialGroup.fSubstituteSupplyQty,0) as fSubstituteSupplyQty,\n");
        sql.append("isnull(materialGroup.fSubstituteDemandQty,0) as fSubstituteDemandQty,\n");
        sql.append("isnull(materialGroup.FCoPlanOrderQty,0) as FCoPlanOrderQty,\n");
        sql.append("exceptionDetail.FMaterialAtr,\n");
        sql.append("exceptionDetail.FProjectID,\n");
        sql.append("exceptionDetail.FProjectNumber\n");
        sql.append("from ").append(exceptionTableName).append(" exceptionDetail\n");
        sql.append("inner join t_bd_material m on m.fid = exceptionDetail.fMaterialId\n");
        sql.append("inner join t_bd_measureunit unit on unit.fid = m.fBaseUnit\n");
        sql.append("inner join t_bd_multimeasureunit mu on m.FID = mu.FMaterialID and m.fBaseUnit =mu.fmeasureunitid\n");
        sql.append("left outer join (\n");
        sql.append("select \n");
        sql.append("mrpDetail.fMaterialId as fmaterialid ,mrpDetail.fMaterialAttr,mrpDetail.fprojectid,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 251 then mrpDetail.fdependent else 0 end ) as fplannOrderCoByProductQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 300 or mrpDetail.fmrpitem = 310 or mrpDetail.fmrpitem = 320 or mrpDetail.fmrpitem = 340 or mrpDetail.fmrpitem = 270\n");
        sql.append(" or mrpDetail.fmrpitem = 330  or mrpDetail.fmrpitem = 400 or mrpDetail.fmrpitem = 331 or mrpDetail.fmrpitem = 390 \n");
        sql.append(" or mrpDetail.fmrpitem = 255 or mrpDetail.fmrpitem = 258 or mrpDetail.fmrpitem = 256 or mrpDetail.fmrpitem = 257\n");
        sql.append(" then mrpDetail.findependent else 0  end ) as frequirementPlanQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 340 then mrpDetail.fdependent else 0 end ) as fparentPlanOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 370 then mrpDetail.fdependent else 0 end ) as fouterPurReqEntryQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 365 then mrpDetail.fdependent else 0 end ) as fouterOrderQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 350 then mrpDetail.fdependent else 0 end ) as fprodOrderReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 360 then mrpDetail.fdependent else 0 end ) as fmanufactureOrderReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 260 then mrpDetail.fsr else 0 end ) as fSubstituteSupplyQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 380 then mrpDetail.fdependent else 0 end ) as fSubstituteDemandQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 270 then mrpDetail.fdependent else 0 end ) as FCoPlanOrderQty\n");
        sql.append("from ").append(detailTbl).append(" mrpDetail\n");
        sql.append("where 1 = 1 ");
        if (filter.getString("planDateFrom") != null) {
            sql.append("and mrpDetail.FBillDate >= to_date('" + filter.getString("planDateFrom") + "') \n");
        }
        if (filter.getString("planDateTo") != null) {
            sql.append("and mrpDetail.FBillDate <= to_date('" + filter.getString("planDateTo") + "') \n");
        }
        sql.append("");
        sql.append("group by mrpDetail.fMaterialId,mrpDetail.fMaterialAttr,mrpDetail.fprojectid\n");
        sql.append(") materialGroup\n");
        sql.append("on materialGroup.fMaterialId = exceptionDetail.fMaterialId and materialGroup.fMaterialAttr=exceptionDetail.FMaterialAtr and isnull(materialGroup.fprojectid, '*')=isnull(exceptionDetail.fprojectid,'*')\n");
        sql.append("left outer join (\n");
        sql.append("select \n");
        sql.append("mrpDetail.fMaterialId as fmaterialid ,mrpDetail.fMaterialAttr,mrpDetail.fprojectid,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 250 and mrpDetail.FDesc64 is not null and mrpDetail.FIsSurplusDivert=1 then 0 \n");
        sql.append("when mrpDetail.fmrpitem = 250 and mrpDetail.FIsSurplusDivert=1 and mrpDetail.FAjustFlag=4 then 0 \n");
        sql.append(" when mrpDetail.fmrpitem = 250 then mrpDetail.FSR end) as fplannedOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 240 then mrpDetail.fsr else 0 end ) as fpurRequestQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 235 then mrpDetail.fsr else 0 end ) as fpurContractQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 230 then mrpDetail.fsr else 0 end ) as fpurReqOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 207 then mrpDetail.fsr else 0 end ) as fouterPurReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 209 then mrpDetail.fsr else 0 end ) as fouterPurQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 210 then mrpDetail.fsr else 0 end ) as fstockTransferBillQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 220 then mrpDetail.fsr else 0 end ) as ftransferOrderBillQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 200 then mrpDetail.fsr else 0 end ) as fprodOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 205 then mrpDetail.fsr else 0 end ) as fmanufactureOrderQty\n");
        sql.append("from ").append(detailTbl).append(" mrpDetail\n");
        sql.append("where 1 = 1 ");
        if (filter.getString("planDateFrom") != null) {
            sql.append("and mrpDetail.FBillDate >= to_date('" + filter.getString("planDateFrom") + "') \n");
        }
        if (filter.getString("planDateTo") != null) {
            sql.append("and mrpDetail.FBillDate <= to_date('" + filter.getString("planDateTo") + "') \n");
        }
        sql.append(" and (((mrpDetail.FSID is null or mrpDetail.FSID=mrpDetail.FID) and mrpDetail.FIsSurplusDivert=0) ");
        sql.append(" or mrpDetail.FIsSurplusDivert=1) ");
        sql.append("group by mrpDetail.fMaterialId,mrpDetail.fMaterialAttr,mrpdetail.fprojectid\n");
        sql.append(") supply\n");
        sql.append("on supply.fMaterialId = exceptionDetail.fMaterialId and exceptionDetail.FMaterialAtr=supply.fMaterialAttr and isnull(supply.fprojectid, '*')=isnull(exceptionDetail.fprojectid,'*')\n");
        sql.append("order by m.fnumber\n");
        return sql.toString();
    }

    private String getCollectionForCoByProQuerySql(String exceptionTableName, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        String MPRDetail = this.calcDetailTbl;
        sql.append("select m.fnumber  as FMaterialNum,\n");
        sql.append("m.fname_" + PMRPPlanerWorkPlatformTotalServer.getLocale() + " as FMaterialName, \n");
        sql.append("m.FModel as FMaterialModel,\n");
        sql.append("unit.fname_" + PMRPPlanerWorkPlatformTotalServer.getLocale() + " as FmaterialUnit,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FSafeStock,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as FSafeStock,\n");
        sql.append("round(decimal((isnull(exceptionDetail.FStorageNum,0)-isnull(exceptionDetail.FSafeStock,0))/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as fcurStoreQty,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FSafeStock,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as fPeriodStoreQty,\n");
        sql.append("round(decimal(isnull(exceptionDetail.FStorageNum,0)/mu.FBaseConvsRate,21,8),mu.FQtyPrecision) as invStoreQty,\n");
        sql.append("isnull(supply.fplannedOrderQty,0) as fplannedOrderQty,\n");
        sql.append("isnull(materialGroup.fplannOrderCoByProductQty,0) as fplannOrderCoByProductQty,\n");
        sql.append("isnull(supply.fpurRequestQty,0) as fpurRequestQty,\n");
        sql.append("isnull(supply.fpurContractQty,0) as fpurContractQty,\n");
        sql.append("isnull(supply.fpurReqOrderQty,0) as fpurReqOrderQty,\n");
        sql.append("isnull(supply.fouterPurReqQty,0) as fouterPurReqQty,\n");
        sql.append("isnull(supply.fouterPurQty,0) as fouterPurQty,\n");
        sql.append("isnull(supply.fstockTransferBillQty,0) as fstockTransferBillQty,\n");
        sql.append("isnull(supply.ftransferOrderBillQty,0) as ftransferOrderBillQty,\n");
        sql.append("isnull(supply.fprodOrderQty,0) as fprodOrderQty,\n");
        sql.append("isnull(supply.fmanufactureOrderQty,0) as fmanufactureOrderQty,\n");
        sql.append("isnull(materialGroup.frequirementPlanQty,0) as frequirementPlanQty,\n");
        sql.append("isnull(materialGroup.fparentPlanOrderQty,0) as fparentPlanOrderQty,\n");
        sql.append("isnull(materialGroup.fouterPurReqEntryQty,0) as fouterPurReqEntryQty,\n");
        sql.append("isnull(materialGroup.fouterOrderQty,0) as fouterOrderQty,\n");
        sql.append("isnull(materialGroup.fprodOrderReqQty,0) as fprodOrderReqQty,\n");
        sql.append("isnull(materialGroup.fmanufactureOrderReqQty,0) as fmanufactureOrderReqQty ,\n");
        sql.append(" exceptionDetail.fMaterialId as fmaterialid,\n");
        sql.append("(isnull(materialGroup.FrequirementPlanQty,0) +\n");
        sql.append(" isnull(materialGroup.FparentPlanOrderQty,0) +\n");
        sql.append(" isnull(materialGroup.fouterPurReqEntryQty,0) +\n");
        sql.append(" isnull(materialGroup.FouterOrderQty,0) +\n");
        sql.append(" isnull(materialGroup.FprodOrderReqQty,0) +\n");
        sql.append(" isnull(materialGroup.fmanufactureOrderReqQty,0) +\n");
        sql.append(" isnull(materialGroup.fSubstituteDemandQty,0) \n");
        sql.append(") as FrequirementQty,\n");
        sql.append("(isnull(FplannedOrderQty,0) +\n");
        sql.append(" isnull(FCoPlanOrderQty,0) +\n");
        sql.append(" isnull(FpurRequestQty,0) +\n");
        sql.append(" isnull(FpurContractQty,0) +\n");
        sql.append(" isnull(FpurReqOrderQty,0) + \n");
        sql.append(" isnull(FouterPurReqQty,0)+\n");
        sql.append(" isnull(FouterPurQty,0) +\n");
        sql.append(" isnull(FstockTransferBillQty,0) +\n");
        sql.append(" isnull(FtransferOrderBillQty,0) +\n");
        sql.append(" isnull(FprodOrderQty,0) +\n");
        sql.append(" isnull(FmanufactureOrderQty,0) +\n");
        sql.append(" isnull(fSubstituteSupplyQty,0) +\n");
        sql.append(" isnull(fplannOrderCoByProductQty,0) \n");
        sql.append(") as FpurveyQty,\n");
        sql.append("mu.FQtyPrecision as FBaseQtyPrc,\n");
        sql.append("isnull(materialGroup.fSubstituteSupplyQty,0) as fSubstituteSupplyQty,\n");
        sql.append("isnull(materialGroup.fSubstituteDemandQty,0) as fSubstituteDemandQty,\n");
        sql.append("isnull(materialGroup.FCoPlanOrderQty,0) as FCoPlanOrderQty\n");
        sql.append("from  " + exceptionTableName + " exceptionDetail\n");
        sql.append("inner join t_bd_material m on m.fid = exceptionDetail.fMaterialId\n");
        sql.append("inner join t_bd_measureunit unit on unit.fid = m.fBaseUnit\n");
        sql.append("inner join t_bd_multimeasureunit mu on m.FID = mu.FMaterialID and m.fBaseUnit =mu.fmeasureunitid\n");
        sql.append("left outer join (\n");
        sql.append("select \n");
        sql.append("mrpDetail.fMaterialId as fmaterialid ,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 251 then mrpDetail.fdependent else 0 end ) as fplannOrderCoByProductQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 300 or mrpDetail.fmrpitem = 310 or mrpDetail.fmrpitem = 320 or\n");
        sql.append("    mrpDetail.fmrpitem = 330  or mrpDetail.fmrpitem = 400 or mrpDetail.fmrpitem = 331 or mrpDetail.fmrpitem = 390 then mrpDetail.findependent else 0  end ) as frequirementPlanQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 340 then mrpDetail.fdependent-mrpDetail.FSR else 0 end ) as fparentPlanOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 370 then mrpDetail.fdependent else 0 end ) as fouterPurReqEntryQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 365 then mrpDetail.fdependent else 0 end ) as fouterOrderQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 350 then mrpDetail.fdependent else 0 end ) as fprodOrderReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 360 then mrpDetail.fdependent else 0 end ) as fmanufactureOrderReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 260 then mrpDetail.fsr else 0 end ) as fSubstituteSupplyQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 380 then mrpDetail.fdependent else 0 end ) as fSubstituteDemandQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 270 then mrpDetail.fsr else 0 end ) as FCoPlanOrderQty\n");
        sql.append("from " + MPRDetail + " mrpDetail\n");
        sql.append("where 1 = 1 ");
        if (filter.getString("planDateFrom") != null) {
            sql.append("and mrpDetail.FBillDate >= to_date('" + filter.getString("planDateFrom") + "') \n");
        }
        if (filter.getString("planDateTo") != null) {
            sql.append("and mrpDetail.FBillDate <= to_date('" + filter.getString("planDateTo") + "') \n");
        }
        sql.append("");
        sql.append("group by mrpDetail.fMaterialId\n");
        sql.append(") materialGroup\n");
        sql.append("on materialGroup.fMaterialId = exceptionDetail.fMaterialId\n");
        sql.append("left outer join (\n");
        sql.append("select \n");
        sql.append("mrpDetail.fMaterialId as fmaterialid ,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 250 and mrpDetail.FDesc64 is not null and mrpDetail.FIsSurplusDivert=1 then 0 \n");
        sql.append("when mrpDetail.fmrpitem = 250 and mrpDetail.FIsSurplusDivert=1 and mrpDetail.FAjustFlag=4 then 0 \n");
        sql.append(" when mrpDetail.fmrpitem = 250 then mrpDetail.FSR end) as fplannedOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 240 then mrpDetail.fsr else 0 end ) as fpurRequestQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 235 then mrpDetail.fsr else 0 end ) as fpurContractQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 230 then mrpDetail.fsr else 0 end ) as fpurReqOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 207 then mrpDetail.fsr else 0 end ) as fouterPurReqQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 209 then mrpDetail.fsr else 0 end ) as fouterPurQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 210 then mrpDetail.fsr else 0 end ) as fstockTransferBillQty, \n");
        sql.append("sum(case when mrpDetail.fmrpitem = 220 then mrpDetail.fsr else 0 end ) as ftransferOrderBillQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 200 then mrpDetail.fsr else 0 end ) as fprodOrderQty,\n");
        sql.append("sum(case when mrpDetail.fmrpitem = 205 then mrpDetail.fsr else 0 end ) as fmanufactureOrderQty\n");
        sql.append("from " + MPRDetail + " mrpDetail\n");
        sql.append("where 1 = 1 ");
        if (filter.getString("planDateFrom") != null) {
            sql.append("and mrpDetail.FBillDate >= to_date('" + filter.getString("planDateFrom") + "') \n");
        }
        if (filter.getString("planDateTo") != null) {
            sql.append("and mrpDetail.FBillDate <= to_date('" + filter.getString("planDateTo") + "') \n");
        }
        sql.append(" and (((mrpDetail.FSID is null or mrpDetail.FSID=mrpDetail.FID) and mrpDetail.FIsSurplusDivert=0) ");
        sql.append(" or mrpDetail.FIsSurplusDivert=1) ");
        sql.append("group by mrpDetail.fMaterialId\n");
        sql.append(") supply\n");
        sql.append("on supply.fMaterialId = exceptionDetail.fMaterialId\n");
        sql.append("order by m.fnumber\n");
        return sql.toString();
    }

    private String getExceptionQuerySql(RptParams filter) {
        String local = PMRPPlanerWorkPlatformTotalServer.getLocale().toString();
        String detailTbl = this.calcDetailTbl;
        StringBuffer sql = new StringBuffer();
        sql.append("select fplannum,fmaterialnum,fmaterialname,fmaterialatr,fprocess,funit,sum(fstoragenum) as fstoragenum,fplanner,fmrpdate,fbaseqtyprc,fmaterialid,sum(fexception1),");
        sql.append("sum(fexception2),sum(fexception3),sum(fexception4),sum(fexception5),sum(fexception6),sum(fexception7),sum(fexception8),sum(fsafestock),fmaterialmodel,fprojectid,fprojectnumber,fprocessedremark \r\n");
        sql.append("from  (");
        sql.append("select\n");
        sql.append("distinct\n");
        sql.append("pv.fnumber as FPlanNum,\n");
        sql.append("m.fnumber as FMaterialNum,\n");
        sql.append("m.fname_").append(local).append(" as FMaterialName,\n");
        sql.append("mrpMaterial.fmaterialattr as FMaterialAtr,\n");
        sql.append("(case when mrpMaterial.fisprocessed=0 then '");
        sql.append(this.getResourceString(this.getContext(), this.resClassName, "PROJECT_NO"));
        sql.append("' when mrpMaterial.fisprocessed = 1 then '");
        sql.append(this.getResourceString(this.getContext(), this.resClassName, "PROJECT_YES"));
        sql.append("' end) as Fprocess, \n");
        sql.append("unit.fname_").append(local).append("  as Funit,\n");
        sql.append("(case when mp.FMANUFACTURESTRATEGYID in ('");
        sql.append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("','").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("','").append("NUnM+gEcEADgAA3cwKgL09g0uEU=").append("') then materialGroup.FStock \n");
        sql.append("when mp.FMANUFACTURESTRATEGYID='").append("NUnM+gEcEADgAA3ewKgL09g0uEU=").append("' then 0 \n");
        sql.append(" else 0 end) as FStorageNum,\n");
        sql.append("person.FName_").append(local).append(" as Fplanner,\n");
        sql.append("to_char(log.FBizDate,'YYYY-MM-DD') as  FMRPDate,\n");
        sql.append("u3.FQtyPrecision as FBaseQtyPrc,\n");
        sql.append("m.fid as FMaterialId,\n");
        sql.append("isnull(materialGroup.Fexception1,0) as Fexception1,\n");
        sql.append("isnull(materialGroup.Fexception2,0) as Fexception2,\n");
        sql.append("isnull(materialGroup.Fexception3,0) as Fexception3,\n");
        sql.append("isnull((case when mrpMaterial.FhasStockExp=31 or mrpMaterial.FhasStockExp=30 then 1 else 0 end + materialGroup.Fexception4),0) as Fexception4,\n");
        sql.append("isnull(materialGroup.Fexception5,0) as Fexception5,\n");
        sql.append("isnull(materialGroup.Fexception6,0) as Fexception6,\n");
        sql.append("isnull(materialGroup.Fexception7,0) as Fexception7,\n");
        sql.append("isnull(materialGroup.Fexception8,0) as Fexception8,\n");
        sql.append("isnull((case when mrpMaterial.FPlanStrategy='").append("NUnM+gEcEADgAA3ewKgL09g0uEU=").append("' then 0 else mi.FQtySafety end),0) as FsafeStock,\n");
        sql.append("m.FModel as FMaterialModel, ");
        sql.append("(case mp.fmanufacturestrategyid when '").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("' then mrpMaterial.fprojectid else null end) As fprojectid, ");
        sql.append("(case mp.fmanufacturestrategyid when '").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("' then mrpMaterial.fprojectnumber else null end) As fprojectnumber, ");
        sql.append("mrpMaterial.FProcessedRemark as FProcessedRemark \n");
        sql.append("from ").append(detailTbl).append(" as mrpMaterial \n");
        sql.append("left outer join T_MRP_PMRPRunLog log on log.fid=mrpMaterial.frunlogid\n");
        sql.append("left outer join t_bd_material m on m.fid = mrpMaterial.fMaterialId\n");
        sql.append("left outer join CT_BAS_PlanDefined pv on pv.fID = mrpMaterial.fPlanversionID\n");
        sql.append("left outer join t_bd_materialgroup mg on mg.fId = m.fMaterialgroupid\n");
        sql.append("left outer join t_bd_materialplan mp on mp.fMaterialId=m.fId and mrpMaterial.FSupplyOrgUnitID=mp.forgunit\n");
        sql.append("left outer join t_bd_person person on person.fId = mp.fPlanner\n");
        sql.append("left outer join t_bd_measureunit unit on unit.fid = m.fBaseUnit\n");
        sql.append("left outer join t_org_storage storage on storage.fid = mrpMaterial.FOrgUnitID\n");
        sql.append("left outer join t_bd_materialinventory mi on mi.fMaterialId=m.fId and mrpMaterial.FSupplyOrgUnitID = mi.forgunit\n");
        sql.append("inner join T_BD_MultiMeasureUnit u3 on mp.FMaterialID=u3.FMaterialID and mp.FProductUnitID=u3.FMeasureUnitID\n");
        sql.append("left outer join (select \n");
        sql.append("mrpDetail.fMaterialId as fmaterialid,mrpDetail.FMaterialAttr,(case mrpDetail.FPlanStrategy when '").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("' then mrpDetail.fprojectid else null end) As fprojectid, \n");
        sql.append("sum(case when fmrpitem = 110 then FAvaliable else 0 end) as FStock,\n");
        sql.append("sum(case when FException1>0 and (FSID is null or FSID=FID) then 1 else 0 end) as FException1,\n");
        sql.append("sum(case when FException2>0 and (FSID is null or FSID=FID) then 1 else 0 end) as FException2,\n");
        sql.append("sum(case when FException3>0 then 1 else 0 end) as FException3,\n");
        sql.append("sum(case when FException4>0 and FDesc64 is null then 1 ");
        sql.append("when FException4>0 and FDesc64 is not null and to_char(FException4)=FDesc64 then 1 ");
        sql.append("when FException4>0 and FDesc64 is not null and to_char(FException4)<>FDesc64 then 2 ");
        sql.append("else 0 end) as FException4,\n");
        sql.append("sum(case when FException5>0 then 1 else 0 end) as FException5,\n");
        sql.append("sum(case when FException6>0 then 1 else 0 end) as FException6,\n");
        sql.append("0 as FException7,\n");
        sql.append("sum(case when FException8>0 then 1 else 0 end) as FException8,\n");
        sql.append("sum(mrpDetail.FException1+mrpDetail.FException2+mrpDetail.FException3+mrpDetail.FException4+mrpDetail.FException5+mrpDetail.FException6+mrpDetail.FException7+mrpDetail.FException8) as FexceptionSum\n");
        sql.append("from ").append(detailTbl).append(" as mrpDetail\n");
        sql.append("group by mrpDetail.fMaterialId,mrpDetail.FMaterialAttr,mrpDetail.fprojectid,mrpDetail.FPlanStrategy \n");
        sql.append(") materialGroup on materialGroup.fMaterialId = mrpMaterial.fMaterialId ");
        sql.append(" and materialGroup.FMaterialAttr=mrpMaterial.FMaterialAttr ");
        sql.append(" and isnull(materialGroup.fprojectid,'*')=isnull((case mp.fmanufacturestrategyid when '").append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("' then mrpMaterial.fprojectid else null end),'*') \n");
        sql.append(this.mrpMaterialWhereStr(filter));
        sql.append("and mrpMaterial.fmrpitem<>120").append("\r\n");
        sql.append("order by m.fnumber\n");
        sql.append(")");
        sql.append("group by fplannum,fmaterialnum,fmaterialname,fmaterialatr,fprocess,funit,fplanner,fmrpdate,fbaseqtyprc,fmaterialid,");
        sql.append("fmaterialmodel,");
        sql.append("fprojectid, ");
        sql.append("fprojectnumber, ");
        sql.append("fprocessedremark");
        return sql.toString();
    }

    private String getAdjustQuerySql(String exceptionTableName, RptParams filter) {
        BillBaseStatusEnum value;
        String detailTbl = this.calcDetailTbl;
        String ajustFlagFilter = this.getAjustFlagFilter(filter);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct * from (");
        sql.append("select\n");
        sql.append("m.FID,\n");
        sql.append("m.FNumber,\n");
        sql.append("m.FName_" + PMRPPlanerWorkPlatformTotalServer.getLocale() + ",\n");
        sql.append("m.FModel,\n");
        sql.append("(to_char(detail.FBillNumber) || '/' || to_char(detail.FBillRowSeq)),\n");
        sql.append("detail.FPlanBeginDate,\n");
        sql.append("detail.FPlanEndDate,detail.FSSR,\n");
        sql.append(" case when detail.FAjustFlag =0 or detail.FAjustFlag =4 then null ");
        sql.append(" when detail.fmrpitem=110 then null ");
        sql.append(" when detail.fmrpitem=120 then null ");
        sql.append(" when detail.fmrpitem=131 then null ");
        sql.append(" when detail.fmrpitem=132 then null ");
        sql.append(" when detail.fmrpitem=140 then null ");
        sql.append(" when detail.fmrpitem=320 then null ");
        sql.append(" when detail.fmrpitem=330 then null ");
        sql.append(" when detail.fmrpitem=331 then null ");
        sql.append(" when detail.fmrpitem=390 then null ");
        sql.append(" when detail.fmrpitem=400 then null ");
        sql.append(" when detail.FIsSurplusDivert=1 and (detail.FSID is null or detail.FSID=detail.fid) then null ");
        sql.append(" when caentry.FWorkDate = detail.FBillDate  then null ");
        sql.append(" else caentry.FWorkDate end as FAjustDate,\n");
        sql.append("case when detail.FAjustFlag = 4  then detail.FNetReq  else (detail.FSR - detail.FAjustQty) end ,\n");
        sql.append("(case when detail.FAjustFlag=4 or detail.FAjustFlag=6 or detail.FAjustFlag=9 then 0 ");
        sql.append("when (detail.FSID is null or detail.FSID=detail.fid) and detail.FAjustFlag=0 then 0 ");
        sql.append(" else  abs(detail.FSPeriod-detail.FPeriod)end )as FAdjustDay,\n");
        sql.append("detail.FBizTypeID,\n");
        sql.append("detail.FBaseStatus,\n");
        sql.append("detail.FBillType ,\n");
        sql.append("case when detail.FMRPItem=140 then null \n");
        Iterator iter = BillBaseStatusEnum.iterator();
        while (iter.hasNext()) {
            value = (BillBaseStatusEnum)iter.next();
            sql.append("when detail.FBaseStatus =").append(value.getValue()).append(" then '").append(value.getAlias(PMRPPlanerWorkPlatformTotalServer.getLocale())).append("' \n");
        }
        sql.append("end ,\n");
        sql.append("case ");
        iter = MRPAjustEnum.iterator();
        while (iter.hasNext()) {
            value = (MRPAjustEnum)iter.next();
            sql.append("when detail.FAjustFlag =").append(value.getValue()).append(" then '").append(value.getAlias(PMRPPlanerWorkPlatformTotalServer.getLocale())).append("' \n");
        }
        sql.append("end ,\n");
        sql.append("unit.fname_").append(PMRPPlanerWorkPlatformTotalServer.getLocale()).append(" as unitName,\n");
        sql.append("isnull(mu.FQtyPrecision,0) as prec,\n");
        sql.append("case when detail.FBizTypeID is not null \n");
        sql.append(" then bizType.fname_").append(PMRPPlanerWorkPlatformTotalServer.getLocale()).append("\n");
        sql.append(" else billType.fname_").append(PMRPPlanerWorkPlatformTotalServer.getLocale()).append(" end as FBizTypeName,\n ");
        sql.append(" detail.FbillDate, \n ");
        sql.append(" detail.FBTrackNumber, \n ");
        sql.append(" detail.FMaterialAttr, \n");
        sql.append(" detail.FID as FDetailID,\n");
        sql.append(" detail.FISProcessed as FISProcessed\n");
        sql.append(" ,detail.FProjectID as FProjectID\n");
        sql.append(" ,detail.FProjectNumber as FProjectNumber\n");
        sql.append(" ,billType.FName_").append(PMRPPlanerWorkPlatformTotalServer.getLocale()).append(" as FSrcBillType\n");
        sql.append(" ,detail.FBillID as FSrcBillID");
        sql.append(" ,detail.FBillEntryID as FSrcBillEntryID");
        sql.append(" ,case when detail.FBillType='510b6503-0105-1000-e000-0107c0a812fd463ED552' then (select FQty FROM T_SM_PurRequestEntry pre where pre.fid=detail.FBillEntryID)");
        sql.append("       when detail.FBillType='xY8YcglBRDqUyT1SHhR3QUY+1VI=' then (select fqty from t_mrp_pmrpplannedorder po where po.fid=detail.FBillID)");
        sql.append("       when detail.FBillType='B2aZSVXaSx6qxdfekgCmrEY+1VI=' then (select fqty from T_MM_MANUFACTUREORDER mo where mo.fid=detail.FBillID)");
        sql.append("       when detail.FBillType='510b6503-0105-1000-e000-010bc0a812fd463ED552' then (select fqty from T_SM_PURORDERENTRY poe where poe.fid=detail.FBillEntryID)");
        sql.append("  else -1 end as FSrcBillQty");
        sql.append(" ,case when detail.FBillType='510b6503-0105-1000-e000-0107c0a812fd463ED552' then (select FRequirementDate FROM T_SM_PurRequestEntry pre where pre.fid=detail.FBillEntryID)");
        sql.append("       when detail.FBillType='xY8YcglBRDqUyT1SHhR3QUY+1VI=' then (select FAvilableDate from t_mrp_pmrpplannedorder po where po.fid=detail.FBillID)");
        sql.append("       when detail.FBillType='B2aZSVXaSx6qxdfekgCmrEY+1VI=' then (select FPlanEndDate from T_MM_MANUFACTUREORDER mo where mo.fid=detail.FBillID)");
        sql.append("       when detail.FBillType='510b6503-0105-1000-e000-010bc0a812fd463ED552' then (select FDeliveryDate FROM T_SM_PURORDERENTRY pre where pre.fid=detail.FBillEntryID)");
        sql.append("  else to_date('1970-01-01') end as FSrcBillDate \r\n");
        sql.append(" ,detail.FProcessedRemark as FProcessedRemark \n");
        sql.append("from ").append(detailTbl).append(" as detail\n");
        sql.append("inner join ").append(exceptionTableName).append(" exceptionDetail on detail.FMaterialID = exceptionDetail.fmaterialid \n");
        sql.append("inner join  t_bd_material as m  on exceptionDetail.FMaterialID = m.FID\n");
        sql.append("inner join  t_bd_measureunit unit on  unit.fid = m.fbaseunit \n");
        sql.append("inner join t_bd_multimeasureunit mu on m.FID = mu.FMaterialID and m.fBaseUnit =mu.fmeasureunitid\n");
        sql.append("inner join T_MM_FactoryCalendar ca on ca.FIsDefault = 1 and ca.FStorageOrgUnitID=detail.FSupplyOrgUnitID\n");
        sql.append("inner join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID and caentry.FWorkDateSeq = detail.FPeriod  \n");
        sql.append("left outer join T_SCM_BizType bizType on detail.FBizTypeID = bizType.fid\n");
        sql.append("left outer join T_SCM_BillType billType on detail.fbilltype = billType.fid\n");
        sql.append("where detail.FAjustFlag in (");
        sql.append(ajustFlagFilter);
        sql.append(") \n");
        sql.append("order by m.FNumber,detail.FBizTypeID,detail.FBillNumber,caentry.FWorkDate");
        sql.append(")");
        return sql.toString();
    }

    private String getAjustFlagFilter(RptParams filter) {
        StringBuffer ajustFlagFilter = new StringBuffer();
        ajustFlagFilter.append("null");
        if ("true".equals(filter.getString("advance"))) {
            ajustFlagFilter.append(", ").append(2);
        }
        if ("true".equals(filter.getString("delay"))) {
            ajustFlagFilter.append(", ").append(3);
        }
        if ("true".equals(filter.getString("cancel"))) {
            ajustFlagFilter.append(", ").append(4);
        }
        if ("true".equals(filter.getString("byScheduling"))) {
            ajustFlagFilter.append(", ").append(6);
        }
        if ("true".equals(filter.getString("supplyCurrentPeriod"))) {
            ajustFlagFilter.append(", ").append(9);
        }
        if ("true".equals(filter.getString("supplyAdvance"))) {
            ajustFlagFilter.append(", ").append(10);
        }
        if ("true".equals(filter.getString("supplyDelay"))) {
            ajustFlagFilter.append(", ").append(11);
        }
        return ajustFlagFilter.toString();
    }

    private String mrpMaterialWhereStr(RptParams filter) {
        StringBuffer whereStr = new StringBuffer();
        String processFlag = "";
        if (filter.getString("uProcess") != null && filter.getString("uProcess").equalsIgnoreCase("true")) {
            processFlag = "0";
        }
        if (filter.getString("Process") != null && filter.getString("Process").equalsIgnoreCase("true")) {
            processFlag = "1";
        }
        boolean exceptionFlag = false;
        whereStr.append("where \n");
        whereStr.append("mrpMaterial.fmaterialattr in (");
        if (filter.getString("materialAtr_1") != null && filter.getString("materialAtr_1").equalsIgnoreCase("true")) {
            whereStr.append("10030 , ");
        }
        if (filter.getString("materialAtr_2") != null && filter.getString("materialAtr_2").equalsIgnoreCase("true")) {
            whereStr.append(" 10040 ,");
        }
        if (filter.getString("materialAtr_3") != null && filter.getString("materialAtr_3").equalsIgnoreCase("true")) {
            whereStr.append(" 10050 ,");
        }
        if (filter.getString("kdMaterialAtr_other") != null && filter.getString("kdMaterialAtr_other").equalsIgnoreCase("true")) {
            whereStr.append(" 10060 ,");
        }
        whereStr.append("-1)\n");
        if (filter.getString("materialGrpFrom") != null) {
            whereStr.append("and mg.fNumber >= '").append(filter.getString("materialGrpFrom")).append("' ");
        }
        if (filter.getString("materialGrpTo") != null) {
            whereStr.append("and mg.fNumber <= '").append(filter.getString("materialGrpTo")).append("'\n");
        }
        if (filter.getString("materialNumFrom") != null) {
            whereStr.append("and m.fNumber >= '").append(filter.getString("materialNumFrom")).append("' ");
        }
        if (filter.getString("materialNumTo") != null) {
            whereStr.append("and m.fNumber<='" + filter.getString("materialNumTo") + "'\n");
        }
        if (filter.getString("orgUnit") != null) {
            whereStr.append("and storage.fnumber ='" + filter.getString("orgUnit") + "'\n");
        }
        if (filter.getString("billNumber") != null) {
            whereStr.append("and mrpMaterial.FBillNumber ='" + filter.getString("billNumber") + "'\n");
        }
        if (filter.getString("plannerFrom") != null) {
            whereStr.append("and person.fNumber>='" + filter.getString("plannerFrom") + "' ");
        }
        if (filter.getString("plannerTo") != null) {
            whereStr.append("and person.fNumber<='" + filter.getString("plannerTo") + "'\n");
        }
        whereStr.append("and ( \n");
        if (filter.getString("exception_1") != null && filter.getString("exception_1").equalsIgnoreCase("true")) {
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException1 > 0 \n");
        }
        if (filter.getString("exception_2") != null && filter.getString("exception_2").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException2 > 0\n");
        }
        if (filter.getString("exception_3") != null && filter.getString("exception_3").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException3 > 0\n");
        }
        if (filter.getString("exception_4") != null && filter.getString("exception_4").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException4 > 0\n");
            whereStr.append("or mrpMaterial.FhasStockExp > 0\n");
        }
        if (filter.getString("exception_5") != null && filter.getString("exception_5").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException5 > 0\n");
        }
        if (filter.getString("exception_6") != null && filter.getString("exception_6").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException6 > 0\n");
        }
        if (filter.getString("exception_7") != null && filter.getString("exception_7").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException7 > 0\n");
        }
        if (filter.getString("exception_8") != null && filter.getString("exception_8").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" materialGroup.FException8 > 0\n");
        }
        if (filter.getString("exception_none") != null && filter.getString("exception_none").equalsIgnoreCase("true")) {
            if (exceptionFlag) {
                whereStr.append(" or ");
            }
            exceptionFlag = true;
            whereStr.append(" (\n");
            whereStr.append(" \t (materialGroup.FexceptionSum = 0 and mrpMaterial.FhasStockExp = 0) or ");
            whereStr.append("    (materialGroup.FException1 is null\n");
            whereStr.append("    and  materialGroup.FException2 is null\n");
            whereStr.append("    and  materialGroup.FException3 is null\n");
            whereStr.append("    and  materialGroup.FException4 is null\n");
            whereStr.append("    and  materialGroup.FException5 is null\n");
            whereStr.append("    and  materialGroup.FException6 is null\n");
            whereStr.append("    and  materialGroup.FException7 is null\n");
            whereStr.append("    and  materialGroup.FException8 is null)\n");
            whereStr.append("    )\n");
        }
        whereStr.append(")\n");
        if (!"".equals(processFlag)) {
            whereStr.append("and mrpMaterial.fisprocessed = " + processFlag + "\n");
        }
        if (filter.getString("showNew") != null && filter.getString("showNew").equalsIgnoreCase("true")) {
            whereStr.append("and mrpMaterial.FisNewOrder= 1\n");
        }
        return whereStr.toString();
    }

    public IObjectPK getMainBizOrgById(String fid, String sql) throws BOSException {
        return null;
    }

    private void filterExceptionColor(String tempExceptionTable, String collTableName, String totaTable, RptParams filter) throws BOSException {
        String strRed = filter.getString("Red");
        String strYellow = filter.getString("Yellow");
        String strGreen = filter.getString("Green");
        String strOrgId = filter.getString("storageOrgID");
        StringBuffer sqlBuff = new StringBuffer("delete from ");
        sqlBuff.append(tempExceptionTable);
        sqlBuff.append(" where fmaterialid not in(select d.FMaterialID from ").append(tempExceptionTable);
        sqlBuff.append(" d left join  T_MM_MRPRunException e on d.fcolor=e.fpriority ");
        sqlBuff.append("and  e.fstorageorgunitid='").append(strOrgId).append("'");
        if (strRed.toUpperCase(Locale.ENGLISH).equals("TRUE")) {
            sqlBuff.append(" where e.fcolor=1 ");
        } else if (strYellow.toUpperCase(Locale.ENGLISH).equals("TRUE")) {
            sqlBuff.append(" where e.fcolor= 2 ");
        } else if (strGreen.toUpperCase(Locale.ENGLISH).equals("TRUE")) {
            sqlBuff.append(" where e.fcolor= 3 or d.fcolor =-1 ");
        }
        sqlBuff.append(")");
        DbUtil.execute((Context)this.getContext(), (String)sqlBuff.toString());
        sqlBuff = null;
        StringBuffer sqlCollTable = new StringBuffer("delete from ").append(collTableName);
        sqlCollTable.append(" where fmaterialid not in (select fmaterialid from ");
        sqlCollTable.append(tempExceptionTable);
        sqlCollTable.append(" )");
        DbUtil.execute((Context)this.getContext(), (String)sqlCollTable.toString());
        sqlCollTable = null;
        StringBuffer sqlTotalTable = new StringBuffer("delete from ").append(totaTable);
        sqlTotalTable.append(" where fmaterialid not in(select fmaterialid from ");
        sqlTotalTable.append(tempExceptionTable);
        sqlTotalTable.append(" )");
        DbUtil.execute((Context)this.getContext(), (String)sqlTotalTable.toString());
        sqlTotalTable = null;
    }

    protected void resetAutoSeq(String strTable) throws BOSException, SQLException {
        if (strTable == null || strTable.trim().length() == 0) {
            return;
        }
        String strSql = "select fmaterialid from " + strTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)strSql);
        int seq = 1;
        ArrayList<Object[]> param = new ArrayList<Object[]>();
        Object[] objs = null;
        while (rs.next()) {
            objs = new Object[2];
            objs[0] = new Integer(seq);
            ++seq;
            String strMatId = rs.getString("fmaterialid");
            objs[1] = strMatId;
            param.add(objs);
        }
        String sql = "SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME = 'Ksql_seq1' AND KSQL_COL_TABNAME = '" + strTable + "'";
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (!rs.next()) {
            sql = "alter table " + strTable + " add " + COLUMN_KEY + " Integer DEFAULT(0) ";
            DbUtil.execute((Context)this.getContext(), (String)sql);
            sql = null;
        }
        String updateSql = "update " + strTable + " set " + COLUMN_KEY + " = ? where fmaterialid =? ";
        DbUtil.executeBatch((Context)this.getContext(), (String)updateSql, param);
        strSql = null;
        updateSql = null;
    }

    protected void mergeAdjustTableName(Context ctx, String adjustTableName_Temp, String adjustTableName) throws BOSException, SQLException {
        if (adjustTableName == null || adjustTableName.trim().length() == 0 || adjustTableName_Temp == null || adjustTableName_Temp.trim().length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into  " + adjustTableName + "( ");
        sql.append(" KSQL_SEQ,FMaterialID,FMaterialNum,FMaterialName,FMaterialModel,FBillNumber,");
        sql.append(" FBeginDate,FCompletionDate,FOrderQty,FResetDate,FResetQty,");
        sql.append(" FAdjustDay,FBizTypeID,FBillState,FBillTypeID,FBillStateName,FAdjustType,FMaterialUnit,FBaseQtyPrc, ");
        sql.append(" FBizTypeName, FavailableDate, FTrackNumber, FMaterialAttr, FDetailID, FISProcessed, FProjectID, ");
        sql.append(" FProjectNumber, FSrcBillTypeName, FSrcBillID, FSrcBillEntryID, FSrcBillQty, FSrcBillDate, ");
        sql.append(" FProcessedRemark ) \r\n");
        sql.append(" Select  ");
        sql.append(" FMaterialID,FMaterialNum,FMaterialName,FMaterialModel,FBillNumber,");
        sql.append(" FBeginDate,FCompletionDate,FOrderQty,FResetDate,Sum(FResetQty) As FResetQty ,");
        sql.append(" FAdjustDay,FBizTypeID,FBillState,FBillTypeID,FBillStateName,FAdjustType,FMaterialUnit,FBaseQtyPrc, ");
        sql.append(" FBizTypeName, FavailableDate, FTrackNumber, FMaterialAttr, MAx(FDetailID) as FDetailID , FISProcessed, FProjectID, ");
        sql.append(" FProjectNumber, FSrcBillTypeName, FSrcBillID, FSrcBillEntryID, FSrcBillQty, FSrcBillDate, ");
        sql.append(" FProcessedRemark  \r\n");
        sql.append(" From \r\n").append(adjustTableName_Temp);
        sql.append(" Group By \r\n");
        sql.append(" FMaterialID,FMaterialNum,FMaterialName,FMaterialModel,FBillNumber,");
        sql.append(" FBeginDate,FCompletionDate,FOrderQty,FResetDate,");
        sql.append(" FAdjustDay,FBizTypeID,FBillState,FBillTypeID,FBillStateName,FAdjustType,FMaterialUnit,FBaseQtyPrc, ");
        sql.append(" FBizTypeName, FavailableDate, FTrackNumber, FMaterialAttr, FISProcessed, FProjectID, ");
        sql.append(" FProjectNumber, FSrcBillTypeName, FSrcBillID, FSrcBillEntryID, FSrcBillQty, FSrcBillDate, ");
        sql.append(" FProcessedRemark  \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(adjustTableName_Temp);
    }

    protected String getCalDetialIDStr(Context ctx, String ftableName, String fid) throws BOSException, EASBizException {
        String fdetialIDStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        sql.append(" distinct a.fid,a.FAjustFlag ");
        sql.append(" From ").append(ftableName).append(" a ");
        sql.append(" Inner Join ").append(ftableName).append(" b ");
        sql.append(" on b.FMaterialID = a.FMaterialID ");
        sql.append(" and b.FMRPClassify = a.FMRPClassify ");
        sql.append(" and b.FMRPItem = a.FMRPItem ");
        sql.append(" and b.FBillID = a.FBillID ");
        sql.append(" and isnull(b.FBillEntryID, '*') = isnull(a.FBillEntryID , '*') ");
        sql.append(" and b.FSupplyOrgUnitID = a.FSupplyOrgUnitID ");
        sql.append(" and isnull(b.FPROJECTID,'*') = isnull(a.FPROJECTID,'*') ");
        sql.append(" and isnull(b.FTRACKID, '*') = ISNULL(a.FTRACKID, '*') ");
        sql.append(" and b.FAjustFlag = a.FAjustFlag ");
        sql.append(" and b.FRePlanDATE = a.FRePlanDATE ");
        sql.append(" and b.FMaterialAttr = a.FMaterialAttr ");
        sql.append(" where b.fid = '").append(fid).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (fdetialIDStr == null) {
                    fdetialIDStr = "'" + rs.getString("fid") + "'";
                    continue;
                }
                fdetialIDStr = fdetialIDStr + ",'" + rs.getString("fid") + "'";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return fdetialIDStr;
    }
}

