/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.AbstractPMRPPlanOrderTransform;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.PMRPReleaseUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PMRPPlanOrder2OutPurRequest
extends AbstractPMRPPlanOrderTransform {
    private static Logger logger = MMLogger.getLogger();
    Map purchaseOrgUnitMap = new HashMap();

    public PMRPPlanOrder2OutPurRequest(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"25428F2E");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new PurRequestInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "purreq_addnew";
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        Map resultMap = this.getResultMap();
        Iterator<Object> it = this.getPlanOrderSet().iterator();
        PMRPPlannedOrderInfo plan = null;
        PurchaseOrgUnitInfo purchase = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        PlanOrderException poException = new PlanOrderException(PlanOrderException.PURCHASEORG_CANNOT_NULL);
        while (it.hasNext()) {
            plan = (PMRPPlannedOrderInfo)it.next();
            purchase = this.getPurchaseOrgUnitInfo(this.ctx, plan);
            if (purchase == null) {
                resultMap.put(plan.getNumber(), poException.getMessage());
                it.remove();
                continue;
            }
            paramMap.put(plan.getNumber(), plan.getMaterial().getId().toString() + "_" + purchase.getId().toString());
        }
        if (paramMap.size() == 0) {
            return;
        }
        StringBuffer whereClause = new StringBuffer();
        it = paramMap.entrySet().iterator();
        Map.Entry mapEntry = null;
        String plannedNumber = null;
        String value = null;
        String materialId = null;
        String orgId = null;
        while (it.hasNext()) {
            mapEntry = (Map.Entry)it.next();
            value = (String)mapEntry.getValue();
            materialId = value.substring(0, value.indexOf("_"));
            orgId = value.substring(value.indexOf("_") + 1);
            if (whereClause.length() > 0) {
                whereClause.append(" or ");
            }
            whereClause.append(" (");
            whereClause.append("  FMaterialID = '").append(materialId).append("'");
            whereClause.append("  and FOrgUnit = '").append(orgId).append("'");
            whereClause.append(" )");
        }
        String sql = "select FStatus,FMaterialID,FOrgUnit from t_bd_materialpurchasing where " + whereClause.toString();
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql);
        try {
            poException = new PlanOrderException(PlanOrderException.PURATTR_NULL);
            while (rs.next()) {
                if (rs.getInt("FStatus") == 1) continue;
                materialId = rs.getString("FMaterialID");
                orgId = rs.getString("FOrgUnit");
                plannedNumber = this.getMapKey(paramMap, materialId + "_" + orgId);
                if (plannedNumber == null) continue;
                resultMap.put(plannedNumber, poException.getMessage());
                paramMap.remove(plannedNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        PurRequestInfo pur;
        logger.info((Object)"set2Collection");
        PMRPPlannedOrderCollection poCollection = PMRPReleaseUtil.set2Collection(this.getPlanOrderSet());
        IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)this.ctx);
        PurRequestInfo[] purRequestInfo = new PurRequestInfo[billCollection.size()];
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)Constants.PRMPPlannedOrderBizTypeID));
        PMRPPlannedOrderInfo planned = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        String plannedId = null;
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        for (int i = 0; i < billCollection.size(); ++i) {
            pur = (PurRequestInfo)billCollection.getObject(i);
            MeasureUnitInfo qtyUnit = null;
            BigDecimal qty = null;
            for (int j = 0; j < pur.getEntries().size(); ++j) {
                String stroageOrgUnitID;
                String materialID;
                String FPurOrgID;
                plannedId = pur.getEntries().get(j).getSourceBillId();
                planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                    thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                    pur.getEntries().get(j).setQty(thisTotalReleaseQty);
                    pur.getEntries().get(j).setRequestQty(thisTotalReleaseQty);
                }
                if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                    thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                    pur.getEntries().get(j).setBaseQty(thisTotalReleasebaseQty);
                }
                if ((FPurOrgID = PMRPReleaseUtil.getDefaultPurOrgID(this.ctx, materialID = pur.getEntries().get(j).getMaterial().getId().toString(), stroageOrgUnitID = pur.getEntries().get(j).getStorageOrgUnit().getId().toString())) == null) continue;
                PurchaseOrgUnitInfo purOrg = new PurchaseOrgUnitInfo();
                purOrg.setId(BOSUuid.read((String)FPurOrgID));
                pur.getEntries().get(j).setPurchaseOrgUnit(purOrg);
                MaterialPurchasingCollection materialPurcon = null;
                MaterialPurchasingInfo materialPurInfo = null;
                FilterInfo matFilter = new FilterInfo();
                matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
                matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)purOrg.getId().toString()));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(matFilter);
                materialPurcon = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx).getMaterialPurchasingCollection(viewInfo);
                if (materialPurcon.size() <= 0 || materialPurcon.get(0) == null) continue;
                materialPurInfo = materialPurcon.get(0);
                qtyUnit = materialPurInfo.getUnit();
                qty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialID, (MeasureUnitInfo)planned.getProductUnit(), (MeasureUnitInfo)qtyUnit, (BigDecimal)pur.getEntries().get(j).getQty());
                pur.getEntries().get(j).setQty(qty);
                pur.getEntries().get(j).setRequestQty(qty);
                pur.getEntries().get(j).setUnit(qtyUnit);
            }
            pur.setSourceBillType(billType);
            purRequestInfo[i] = pur;
        }
        logger.info((Object)"iPurRequest.submitForPlan");
        Map errormap = iPurRequest.submitForPlan(purRequestInfo);
        logger.info((Object)"if (errormap == null || errormap.size() == 0) {\t");
        pur = null;
        if (errormap == null || errormap.size() == 0) {
            for (int i = 0; i < purRequestInfo.length; ++i) {
                pur = purRequestInfo[i];
                if (pur == null || pur.getEntries().size() == 0) continue;
                for (int m = 0; m < pur.getEntries().size(); ++m) {
                    plannedId = pur.getEntries().get(m).getSourceBillId();
                    planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                    successPOs.add(planned);
                }
                successDestBillIds.add(pur.getId().toString());
            }
            failedDestBillIds.clear();
        } else {
            for (int j = 0; j < purRequestInfo.length; ++j) {
                pur = (PurRequestInfo)billCollection.getObject(j);
                if (pur == null || pur.getEntries().size() == 0) continue;
                for (int n = 0; n < pur.getEntries().size(); ++n) {
                    plannedId = pur.getEntries().get(n).getSourceBillId();
                    planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                    if (errormap.containsKey(plannedId)) {
                        failedDestBillIds.add(pur.getId().toString());
                        this.getResultMap().put(planned.getNumber().toString(), errormap.get(plannedId));
                        continue;
                    }
                    successDestBillIds.add(pur.getId().toString());
                    successPOs.add(planned);
                }
            }
        }
        logger.info((Object)"doAfterTransform.end");
    }

    @Override
    protected String getDestBillMainOrgUnitId() {
        String storageOrgUnitId = this.getStorageOrgUnitId();
        String orgUnitId = null;
        try {
            CompanyOrgUnitInfo orgUnit = PMRPReleaseUtil.getCompanyOrgUnitInfo(this.ctx, storageOrgUnitId);
            if (orgUnit != null) {
                orgUnitId = orgUnit.getId().toString();
            }
        }
        catch (BOSException e) {
            logger.error((Object)("PlanOrder2OutPurRequest getDestBillMainOrgUnitId exception 1" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("PlanOrder2OutPurRequest getDestBillMainOrgUnitId exception 2" + e.getMessage()), (Throwable)e);
        }
        return orgUnitId;
    }

    @Override
    protected String getBotpRuleName() {
        return this.getResouce("PUTIN_08_PURCHARE", this.ctx);
    }

    private String getResouce(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.mm.basedata.PlannedOrderPutInParamResource", (String)key, (Context)ctx);
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitInfo(Context ctx, PMRPPlannedOrderInfo plan) throws EASBizException, BOSException {
        String materialID = plan.getMaterial().getId().toString();
        String stroageOrgUnitID = plan.getStorageOrgUnit().getId().toString();
        String key = stroageOrgUnitID + materialID;
        PurchaseOrgUnitInfo purInfo = null;
        if (this.purchaseOrgUnitMap.containsKey(key)) {
            purInfo = (PurchaseOrgUnitInfo)this.purchaseOrgUnitMap.get(key);
        } else {
            purInfo = PMRPReleaseUtil.getPurOrgUnitInfo(ctx, plan);
            this.purchaseOrgUnitMap.put(key, purInfo);
        }
        return purInfo;
    }

    private String getMapKey(Map map, String value) {
        Iterator it = map.entrySet().iterator();
        Map.Entry mEntry = null;
        String val = null;
        String key = null;
        while (it.hasNext()) {
            mEntry = it.next();
            val = (String)mEntry.getValue();
            if (!value.equals(val)) continue;
            key = (String)mEntry.getKey();
            break;
        }
        return key;
    }
}

