/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.AbstractPMRPPlanOrderTransform;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.PMRPReleaseUtil;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.planning.MappingReturnTypeEnum;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PMRPPlanOrder2PurOrder
extends AbstractPMRPPlanOrderTransform {
    private Map companyOrgUnitMap = new HashMap();

    public PMRPPlanOrder2PurOrder(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"3171BFAD");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new PurOrderInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "purorder_addnew";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        logger.info((Object)"ReleaseUtil.set2Collection(getPlanOrderSet()");
        PMRPPlannedOrderCollection poCollection = PMRPReleaseUtil.set2Collection(this.getPlanOrderSet());
        PurOrderInfo purInfo = null;
        PMRPPlannedOrderInfo planned = null;
        String plannedId = null;
        HashMap<String, String> plannedMap = new HashMap<String, String>();
        String storageOrgId = null;
        String materialId = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        PurOrderEntryInfo entryInfo = null;
        PurchaseOrgUnitInfo purOrgInfo = null;
        MaterialPurchasingInfo materialPurInfo = null;
        MeasureUnitInfo qtyUnit = null;
        BigDecimal qty = null;
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        for (int i = 0; i < billCollection.size(); ++i) {
            purInfo = (PurOrderInfo)billCollection.getObject(i);
            plannedId = purInfo.getSourceBillId();
            planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
            storageOrgId = planned.getStorageOrgUnit().getId().toString();
            materialId = planned.getMaterial().getId().toString();
            purInfo.setCompanyOrgUnit(this.getCompanyOrgUnitInfo(storageOrgId));
            purOrgInfo = PMRPReleaseUtil.getPurOrgUnitInfo(this.ctx, storageOrgId, materialId);
            purInfo.setPurchaseOrgUnit(purOrgInfo);
            entryInfo = purInfo.getEntries().get(0);
            if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                entryInfo.setQty(thisTotalReleaseQty);
            }
            if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                entryInfo.setBaseQty(thisTotalReleasebaseQty);
            }
            logger.info((Object)"ReleaseUtil.getMaterialPurchasing");
            materialPurInfo = PMRPReleaseUtil.getMaterialPurchasing(this.ctx, purOrgInfo.getId().toString(), materialId);
            if (materialPurInfo != null) {
                qtyUnit = materialPurInfo.getUnit();
                qty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialId, (MeasureUnitInfo)planned.getProductUnit(), (MeasureUnitInfo)qtyUnit, (BigDecimal)entryInfo.getQty());
                entryInfo.setQty(qty);
                entryInfo.setUnit(qtyUnit);
            } else {
                String errMsg = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)"PLEASE_INPUT_PURCHASEINFO", (String[])new String[]{planned.getMaterial().getName(), purOrgInfo.getName()});
                this.getResultMap().put(planned.getNumber(), errMsg);
            }
            plannedMap.put(plannedId, planned.getNumber());
            successDestBillIds.add(purInfo.getId().toString());
            successPOs.add(planned);
        }
        PurOrderCollection purColl = (PurOrderCollection)billCollection;
        logger.info((Object)("PurOrderFactory.getLocalInstance(ctx).submitForPlan(purColl),size=" + String.valueOf(purColl.size())));
        Map errorMap = PurOrderFactory.getLocalInstance((Context)this.ctx).submitForPlan(purColl);
        logger.info((Object)("PurOrderFactory.getLocalInstance(ctx).submitForPlan(purColl),size=" + String.valueOf(purColl.size()) + ",end"));
        if (errorMap != null && errorMap.size() > 0) {
            Iterator it = errorMap.entrySet().iterator();
            Map.Entry mapEntry = null;
            block1: while (it.hasNext()) {
                mapEntry = it.next();
                plannedId = (String)mapEntry.getKey();
                planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                successPOs.remove(planned);
                for (int i = 0; i < billCollection.size(); ++i) {
                    purInfo = (PurOrderInfo)billCollection.getObject(i);
                    if (!plannedId.equals(purInfo.getSourceBillId())) continue;
                    successDestBillIds.remove(purInfo.getId().toString());
                    failedDestBillIds.add(purInfo.getId().toString());
                    this.getResultMap().put(plannedMap.get(plannedId), mapEntry.getValue());
                    continue block1;
                }
            }
        }
    }

    @Override
    public void checkPermission() throws EASBizException, BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        Set planOrderSet = this.getPlanOrderSet();
        Map resultMap = this.getResultMap();
        if (userInfo.getType() != UserType.PERSON) {
            PMRPReleaseUtil.cleanSet(planOrderSet, resultMap, MappingReturnTypeEnum.CURR_OPERATOR_NOT_CLERK);
            return;
        }
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        PMRPPlannedOrderInfo plannedInfo = null;
        Iterator it = planOrderSet.iterator();
        ObjectUuidPK userPK = new ObjectUuidPK(this.ctx.getCaller().toString());
        ObjectUuidPK orgPK = null;
        String storageOrgUnitId = null;
        String materialId = null;
        PurchaseOrgUnitInfo purOrg = null;
        boolean isExistNumber = true;
        while (it.hasNext()) {
            plannedInfo = (PMRPPlannedOrderInfo)it.next();
            storageOrgUnitId = plannedInfo.getStorageOrgUnit().getId().toString();
            materialId = plannedInfo.getMaterial().getId().toString();
            try {
                purOrg = PMRPReleaseUtil.getPurOrgUnitInfo(this.ctx, storageOrgUnitId, materialId);
            }
            catch (Exception e) {
                resultMap.put(plannedInfo.getNumber(), e.getMessage());
                it.remove();
                continue;
            }
            try {
                orgPK = new ObjectUuidPK(purOrg.getId());
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, this.getDestBillPermission());
            }
            catch (Exception e) {
                resultMap.put(plannedInfo.getNumber(), MappingReturnTypeEnum.NO_NEW_PERRMISSION);
                it.remove();
                continue;
            }
            isExistNumber = null == purOrg ? false : CommonUtils.existCodingRule((Context)this.ctx, (IObjectValue)this.getDestBillInfo(), (String)purOrg.getId().toString());
            if (isExistNumber) continue;
            resultMap.put(plannedInfo.getNumber(), MappingReturnTypeEnum.NO_CODINGRULE);
            it.remove();
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(String storageOrgUnitId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo comOrgInfo = null;
        if (this.companyOrgUnitMap.containsKey(storageOrgUnitId)) {
            comOrgInfo = (CompanyOrgUnitInfo)this.companyOrgUnitMap.get(storageOrgUnitId);
        } else {
            SelectorItemCollection companySelectorColl = new SelectorItemCollection();
            companySelectorColl.add("id");
            companySelectorColl.add("name");
            companySelectorColl.add("number");
            companySelectorColl.add("baseCurrency.id");
            companySelectorColl.add("baseCurrency.name");
            companySelectorColl.add("baseCurrency.number");
            companySelectorColl.add("baseCurrency.precision");
            companySelectorColl.add("baseExchangeTable.id");
            comOrgInfo = PMRPReleaseUtil.getCompanyOrgUnitInfo(this.ctx, storageOrgUnitId, companySelectorColl);
            this.companyOrgUnitMap.put(storageOrgUnitId, comOrgInfo);
        }
        return comOrgInfo;
    }
}

