/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.AbstractPMRPPlanOrderTransform;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.PMRPReleaseUtil;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PMRPPlanOrder2PurRequest
extends AbstractPMRPPlanOrderTransform {
    private static Logger logger = MMLogger.getLogger();

    public PMRPPlanOrder2PurRequest(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"25428F2E");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new PurRequestInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "purreq_addnew";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        logger.info((Object)"ReleaseUtil.set2Collection(getPlanOrderSet()");
        PMRPPlannedOrderCollection poCollection = PMRPReleaseUtil.set2Collection(this.getPlanOrderSet());
        PurRequestInfo reqInfo = null;
        PMRPPlannedOrderInfo planned = poCollection.get(0);
        SelectorItemCollection _ = new SelectorItemCollection();
        _.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo comInfo = PMRPReleaseUtil.getCompanyOrgUnitInfo(this.ctx, planned.getStorageOrgUnit().getId().toString(), _);
        MaterialPurchasingCollection materialPurcon = null;
        String plannedId = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)this.ctx);
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        for (int i = 0; i < billCollection.size(); ++i) {
            reqInfo = (PurRequestInfo)billCollection.getObject(i);
            PurchaseOrgUnitInfo purOrg = null;
            MeasureUnitInfo qtyUnit = null;
            BigDecimal qty = null;
            BigDecimal _qty = SysConstant.BIGZERO;
            BigDecimal _price = SysConstant.BIGZERO;
            BigDecimal _amount = SysConstant.BIGZERO;
            BigDecimal _sumAmount = SysConstant.BIGZERO;
            int scale = 4;
            if (null != comInfo && null != comInfo.getBaseCurrency()) {
                scale = comInfo.getBaseCurrency().getPrecision();
            }
            PurRequestEntryInfo entryInfo = null;
            for (int j = 0; j < reqInfo.getEntries().size(); ++j) {
                String materialID = reqInfo.getEntries().get(j).getMaterial().getId().toString();
                plannedId = reqInfo.getEntries().get(j).getSourceBillId();
                planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                purOrg = PMRPReleaseUtil.getPurOrgUnitInfo(this.ctx, planned);
                reqInfo.getEntries().get(j).setPurchaseOrgUnit(purOrg);
                entryInfo = reqInfo.getEntries().get(j);
                if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                    thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                    reqInfo.getEntries().get(j).setQty(thisTotalReleaseQty);
                    reqInfo.getEntries().get(j).setRequestQty(thisTotalReleaseQty);
                }
                if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                    thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                    reqInfo.getEntries().get(j).setBaseQty(thisTotalReleasebaseQty);
                }
                if (purOrg != null && purOrg.getId() != null) {
                    MaterialPurchasingInfo materialPurInfo = null;
                    FilterInfo matFilter = new FilterInfo();
                    matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
                    matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)purOrg.getId().toString()));
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.setFilter(matFilter);
                    materialPurcon = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx).getMaterialPurchasingCollection(viewInfo);
                    if (materialPurcon.size() > 0 && materialPurcon.get(0) != null) {
                        materialPurInfo = materialPurcon.get(0);
                        reqInfo.getEntries().get(j).setPurchasePerson(materialPurInfo.getPurPerson());
                        reqInfo.getEntries().get(j).setPurchaseGroup(materialPurInfo.getPurGroup());
                        reqInfo.getEntries().get(j).setIsQuantityUnCtrl(materialPurInfo.isIsNotControlQty());
                        qtyUnit = materialPurInfo.getUnit();
                        qty = SCMUtils.getExchangePrecisionQtyForServer((Context)this.ctx, (String)materialID, (MeasureUnitInfo)planned.getProductUnit(), (MeasureUnitInfo)qtyUnit, (BigDecimal)reqInfo.getEntries().get(j).getQty());
                        reqInfo.getEntries().get(j).setQty(qty);
                        reqInfo.getEntries().get(j).setRequestQty(qty);
                        reqInfo.getEntries().get(j).setUnit(qtyUnit);
                    }
                }
                reqInfo.setPerson(userInfo.getPerson());
                reqInfo.getEntries().get(j).setBaseStatus(EntryBaseStatusEnum.ADD);
                if (planned != null) {
                    reqInfo.setSourceBillId(planned.getId().toString());
                    reqInfo.setSourceBillType(planned.getBillType());
                }
                reqInfo.getEntries().get(j).setExchangeRate(new BigDecimal("1.00"));
                _qty = entryInfo.getQty();
                _price = null == entryInfo.getPrice() ? SysConstant.BIGZERO : entryInfo.getPrice();
                _amount = _qty.multiply(_price).setScale(scale, 4);
                entryInfo.setAmount(_amount);
                entryInfo.setLocalAmount(_amount);
                _sumAmount = _sumAmount.add(_amount).setScale(scale, 4);
                reqInfo.getEntries().get(j).setOrderedQty(new BigDecimal("0.00"));
                if (null == reqInfo.getEntries().get(j).getAssistUnit()) {
                    reqInfo.getEntries().get(j).setAssistQty(new BigDecimal("0.00"));
                }
                if (comInfo == null || comInfo.getBaseCurrency() == null) continue;
                reqInfo.getEntries().get(j).setCurrency(comInfo.getBaseCurrency());
            }
            reqInfo.setTotalAmount(_sumAmount);
            reqInfo.setLocalTotalAmount(_sumAmount);
            if (reqInfo.getPerson() != null && reqInfo.getPerson().getId() != null) {
                try {
                    if (reqInfo.getPerson().getId() != null) {
                        reqInfo.setAdminOrg(this.getAdminOrgUnitInfoToPerson(this.ctx, reqInfo.getPerson().getId().toString()));
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            logger.info((Object)"iPurRequest.update(pkReq, reqInfo)");
            iPurRequest.submit((CoreBaseInfo)reqInfo);
            for (int k = 0; k < reqInfo.getEntries().size(); ++k) {
                PurRequestEntryInfo reqEntryInfo = reqInfo.getEntries().get(k);
                String poId = reqEntryInfo.getSourceBillId();
                planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, poId);
                successPOs.add(planned);
            }
            successDestBillIds.add(reqInfo.getId().toString());
        }
    }

    @Override
    protected String getDestBillMainOrgUnitId() throws EASBizException, BOSException {
        String storageOrgUnitId = this.getStorageOrgUnitId();
        String orgUnitId = null;
        try {
            CompanyOrgUnitInfo orgUnit = PMRPReleaseUtil.getCompanyOrgUnitInfo(this.ctx, storageOrgUnitId);
            if (orgUnit != null) {
                orgUnitId = orgUnit.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("PlanOrder2OutPurRequest getDestBillMainOrgUnitId exception 1" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return orgUnitId;
    }

    @Override
    protected String getBotpRuleName() {
        return this.getResouce("PUT_INI_07", this.ctx);
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        PlanOrderException excep = new PlanOrderException(PlanOrderException.PURORG_IS_NULL);
        Object[] poIds = PMRPReleaseUtil.getPlanOrderIds(this.getPlanOrderSet());
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID FPoId from t_mm_plannedorder t \n");
        sql.append("inner join t_bd_materialPlan mp ");
        sql.append(" on t.FMaterialId=mp.FMaterialId and t.FStorageOrgUnitId=mp.FOrgUnit \n");
        sql.append("left outer join T_ORG_UnitRelation t1 on t.FStorageOrgUnitId=t1.FFromUnitID \n");
        sql.append(" and t1.FTypeRelationID='").append("00000000-0000-0000-0000-0000000000080FE9F8B5").append("' ");
        sql.append("where t.FID in (").append(SQLUtil.arrayToString((Object[])poIds)).append(") \n");
        sql.append("and mp.FPurOrgID is null and t1.FToUnitID is null ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PMRPReleaseUtil.setResultMap(this.getPlanOrderSet(), this.getResultMap(), rs.getString("FPoId"), (Exception)((Object)excep));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getResouce(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.mm.basedata.PlannedOrderPutInParamResource", (String)key, (Context)ctx);
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfoToPerson(Context ctx, String personid) throws Exception {
        if (personid == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        SorterItemInfo sorterItem = new SorterItemInfo("isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getPosition().getAdminOrgUnit();
        }
        return null;
    }

    private SelectorItemCollection getDestOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("sourcebillid");
        sic.add("entries.id");
        sic.add("entries.sourcebillid");
        return sic;
    }
}

