/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.app.release;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.AbstractPMRPPlanOrderTransform;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.release.PMRPReleaseUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PMRPPlanOrder2StockTransferBill
extends AbstractPMRPPlanOrderTransform {
    public PMRPPlanOrder2StockTransferBill(Context ctx) {
        super(ctx);
    }

    @Override
    protected BOSObjectType getDestBOSType() {
        return BOSObjectType.create((String)"2239F30A");
    }

    @Override
    protected IObjectValue getDestBillInfo() {
        return new StockTransferBillInfo();
    }

    @Override
    protected String getDestBillPermission() {
        return "stocktransfer_new";
    }

    @Override
    protected void doAfterTransform(IObjectCollection billCollection, Set successPOs, List failedDestBillIds, List successDestBillIds) throws EASBizException, BOSException {
        logger.info((Object)("ReleaseUtil.set2Collection(getPlanOrderSet()):size=" + String.valueOf(this.getPlanOrderSet().size())));
        PMRPPlannedOrderCollection poCollection = PMRPReleaseUtil.set2Collection(this.getPlanOrderSet());
        StockTransferBillInfo stockInfo = null;
        IStockTransferBill iStockTransferBill = null;
        iStockTransferBill = StockTransferBillFactory.getLocalInstance((Context)this.ctx);
        IObjectPK pkst = null;
        BillTypeInfo stockTsfTypeInfo = new BillTypeInfo();
        stockTsfTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        PMRPPlannedOrderInfo planned = poCollection.get(0);
        CompanyOrgUnitInfo company = PMRPReleaseUtil.getCompanyOrgUnitInfo(this.ctx, planned.getProductionOrgUnit().getId().toString());
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-011a-1000-e000-04c5c0a812202407435C"));
        StockTransferBillEntryInfo stockEntryInfo = null;
        BigDecimal thisTotalReleaseQty = null;
        BigDecimal thisTotalReleasebaseQty = null;
        LinkedHashSet<StockTransferBillInfo> stockTransferBills = new LinkedHashSet<StockTransferBillInfo>();
        logger.info((Object)("doAfterTransform.[for (int i = 0; i < " + String.valueOf(billCollection.size()) + "; i++)]"));
        for (int i = 0; i < billCollection.size(); ++i) {
            stockInfo = (StockTransferBillInfo)billCollection.getObject(i);
            stockInfo.setIssueCompanyOrgUnit(company);
            stockInfo.setReceiptCompanyOrgUnit(company);
            stockInfo.setBizType(bizTypeInfo);
            stockInfo.setBillType(stockTsfTypeInfo);
            stockInfo.setIsInTax(true);
            logger.info((Object)"iStockTransferBill.save(stockInfo)");
            pkst = iStockTransferBill.save((CoreBaseInfo)stockInfo);
            logger.info((Object)("iStockTransferBill.save(stockInfo),pk=" + pkst.toString()));
            stockInfo = iStockTransferBill.getStockTransferBillInfo(pkst, this.getDestOrderSelector());
            stockInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            for (int j = 0; j < stockInfo.getEntry().size(); ++j) {
                stockEntryInfo = stockInfo.getEntry().get(j);
                stockEntryInfo.setIsPresent(false);
                String plannedId = stockEntryInfo.getSourceBillId();
                planned = PMRPReleaseUtil.getPlannedOrderInfo(poCollection, plannedId);
                if (planned != null && planned.get("thisTotalReleaseQty") != null) {
                    thisTotalReleaseQty = (BigDecimal)planned.get("thisTotalReleaseQty");
                    stockEntryInfo.setQty(thisTotalReleaseQty);
                }
                if (planned != null && planned.get("thisTotalReleaseBaseQty") != null) {
                    thisTotalReleasebaseQty = (BigDecimal)planned.get("thisTotalReleaseBaseQty");
                    stockEntryInfo.setBaseQty(thisTotalReleasebaseQty);
                }
                stockEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                successPOs.add(planned);
            }
            logger.info((Object)("iStockTransferBill.update(pkst, stockInfo),pk=" + pkst.toString()));
            iStockTransferBill.update(pkst, (CoreBaseInfo)stockInfo);
            stockTransferBills.add(stockInfo);
            successDestBillIds.add(stockInfo.getId().toString());
        }
        if (stockTransferBills.size() > 0) {
            logger.info((Object)("InvServerUtils.handleBatchReqPlan,size=" + String.valueOf(stockTransferBills.size())));
            InvServerUtils.handleBatchReqPlan(stockTransferBills, (String)"50957179-0105-1000-e003-3152c0a812fd463ED552", (BizActionEnum)BizActionEnum.SUBMIT, (Context)this.ctx);
        }
    }

    @Override
    protected void checkAdditionalItems() throws EASBizException, BOSException {
        Map checkRstMap = PMRPReleaseUtil.checkMaterialInventory(this.ctx, this.getPlanOrderSet());
        this.getResultMap().putAll(checkRstMap);
    }

    private SelectorItemCollection getDestOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("entry.id");
        sic.add("entry.sourceBillId");
        return sic;
    }
}

