/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class PMRPCounter {
    private PMRPCalcParam runParam;
    private int materialCalcCount;
    private int genOrderCount = 0;
    private int underSaftQtyMaterialCount = 0;
    private int expMaterialCount = 0;
    private int currentMaterialCalcCount;

    public PMRPCounter(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    public int getMaterialCalcCount() {
        return this.materialCalcCount;
    }

    public void setMaterialCalcCount(int materialCalcCount) {
        this.materialCalcCount = materialCalcCount;
    }

    public int getCurrentMaterialCalcCount() {
        return this.currentMaterialCalcCount;
    }

    public synchronized void logMaterialCalcFinished() throws PMRPException {
        if (this.materialCalcCount == 0) {
            return;
        }
        ++this.currentMaterialCalcCount;
        int avg = this.materialCalcCount / 20;
        int progress = 3;
        if (avg == 0) {
            avg = 1;
            progress = 60 / this.materialCalcCount;
        }
        if (this.currentMaterialCalcCount % avg == 0 || this.currentMaterialCalcCount == this.materialCalcCount) {
            this.updateProgress(progress);
        }
    }

    public synchronized void generateOrder() {
        ++this.genOrderCount;
    }

    public synchronized void setGenOrderCount(int genOrderCount) {
        this.genOrderCount = genOrderCount;
    }

    public synchronized void underSafeQty() {
        ++this.underSaftQtyMaterialCount;
    }

    public int getUnderSaftQtyMaterialCount() {
        return this.underSaftQtyMaterialCount;
    }

    public synchronized void generateException() {
        ++this.expMaterialCount;
    }

    public int getExpMaterialCount() {
        return this.expMaterialCount;
    }

    public synchronized int getGenOrderCount() {
        return this.genOrderCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(int progress) throws PMRPException {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(Constants.TableName.MRP_LOG_TABLE);
        sql.append(" SET fpercent=fpercent + ?, flastupdatetime=sysDate WHERE fid=? AND fpercent + ? < 100");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getEasCtx());
            ps = conn.prepareStatement(sql.toString());
            ps.setQueryTimeout(2);
            ps.setInt(1, new Integer(progress));
            ps.setString(2, this.runParam.getRunLog().getId().toString());
            ps.setInt(3, new Integer(progress));
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        catch (SQLException exc) {
            exc.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
    }
}

