/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.ComputeTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.mm.planning.CooperatePlanOrderInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PMRPPONumberUtil {
    private SCMBillBaseInfo PO_Instance = null;
    private ICodingRuleManager codingRuleManager = null;
    private PMRPCalcParam runParam = null;
    private List<String> numberList = new ArrayList<String>();
    private Map orgUnitMap = new HashMap();
    private boolean inited = false;
    private boolean isNumCodingRuleExist = false;

    public PMRPPONumberUtil(PMRPCalcParam runParam) throws BOSException, PMRPException {
        this.runParam = runParam;
        this.codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)runParam.getEasCtx());
        this.generateInfo();
    }

    public synchronized String getNumber(String orgUnitID) throws PMRPException, BOSException {
        ArrayList orgNumberList = null;
        orgNumberList = this.orgUnitMap != null && this.orgUnitMap.containsKey(orgUnitID) ? (ArrayList)this.orgUnitMap.get(orgUnitID) : new ArrayList();
        String number = null;
        if (orgNumberList.size() > 0) {
            number = (String)orgNumberList.get(0);
            orgNumberList.remove(0);
        } else {
            int numberOfbatch = 10;
            int matCount = this.runParam.getCounter().getMaterialCalcCount();
            if (matCount <= 100) {
                numberOfbatch = 10;
            } else if (matCount > 100 && matCount <= 1000) {
                numberOfbatch = 50;
            } else if (matCount > 1000) {
                numberOfbatch = 100;
            }
            if (this.runParam.getRunLog().getComputeType() != null && this.runParam.getRunLog().getComputeType().equals((Object)ComputeTypeEnum.PSP)) {
                for (int i = 0; i < numberOfbatch; ++i) {
                    orgNumberList.add("PSP_" + BOSUuid.create((String)"12345678").toString());
                }
            } else {
                PMRPPlannedOrderCollection coll = new PMRPPlannedOrderCollection();
                StorageOrgUnitInfo storageorgUnitInfo = new StorageOrgUnitInfo();
                storageorgUnitInfo.setId(BOSUuid.read((String)orgUnitID));
                for (int i = 0; i < numberOfbatch; ++i) {
                    PMRPPlannedOrderInfo info = new PMRPPlannedOrderInfo();
                    info.setStorageOrgUnit(storageorgUnitInfo);
                    coll.add(info);
                }
                try {
                    AutoNumberUtil.initNumber((Context)this.runParam.getEasCtx(), (IObjectCollection)coll);
                }
                catch (Exception e) {
                    System.out.println("------------------------------MRP(GEN_PLANORDER_NUMBER_FAILED) coding rule exsists,failed to gen number AutoNumberUtil.initNumber(runParam.getEasCtx(), coll);----------------------------------");
                    e.printStackTrace();
                    System.out.println("-----------------------------------------------------------------------------------------------------------------------------------------");
                }
                for (int i = 0; i < coll.size(); ++i) {
                    orgNumberList.add(coll.get(i).getNumber());
                }
            }
            number = (String)orgNumberList.get(0);
            orgNumberList.remove(0);
            this.orgUnitMap.put(orgUnitID, orgNumberList);
        }
        return number;
    }

    private void preGetBillNumbers() throws PMRPException, BOSException {
        String[] nums;
        if (!this.numberList.isEmpty()) {
            return;
        }
        int numberOfbatch = 10;
        int matCount = this.runParam.getCounter().getMaterialCalcCount();
        if (matCount <= 100) {
            numberOfbatch = 10;
        } else if (matCount > 100 && matCount <= 1000) {
            numberOfbatch = 50;
        } else if (matCount > 1000) {
            numberOfbatch = 100;
        }
        try {
            nums = this.codingRuleManager.getBatchNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID(), numberOfbatch);
        }
        catch (EASBizException e) {
            System.out.println("------------------------------MRP(GEN_PLANORDER_NUMBER_FAILED) coding rule exsists,failed to gen number----------------------------------");
            e.printStackTrace();
            System.out.println("-----------------------------------------------------------------------------------------------------------------------------------------");
            return;
        }
        for (int i = 0; i < nums.length; ++i) {
            this.numberList.add(nums[i]);
        }
    }

    public boolean isHasNumCodingRule() throws PMRPException, BOSException {
        CodingRuleInfo codingRuleInfo;
        if (this.inited) {
            return this.isNumCodingRuleExist;
        }
        this.inited = true;
        try {
            codingRuleInfo = this.codingRuleManager.getCodingRule((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID());
        }
        catch (EASBizException e) {
            throw new PMRPException(PMRPException.GEN_PLANORDER_NUMBER_FAILED, e);
        }
        this.isNumCodingRuleExist = codingRuleInfo != null;
        return this.isNumCodingRuleExist;
    }

    public void recycleNumbers() throws PMRPException, BOSException {
        if (this.isHasNumCodingRule() && this.numberList.size() > 0) {
            try {
                if (this.codingRuleManager.isUseIntermitNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID())) {
                    String[] nums = new String[this.numberList.size()];
                    System.arraycopy(this.numberList.toArray(), 0, nums, 0, this.numberList.size());
                    this.codingRuleManager.recycleBatchNumber((IObjectValue)this.PO_Instance, this.runParam.getStorageOrgUnitID(), nums);
                }
            }
            catch (EASBizException e) {
                throw new PMRPException(PMRPException.RELEASE_PLANORDER_NUMBER_FAILED, e);
            }
        }
    }

    private void generateInfo() {
        this.PO_Instance = Constants.MRPConfig.ISCOOPERATEPLAN ? new CooperatePlanOrderInfo() : new PMRPPlannedOrderInfo();
    }
}

