/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.impl;

import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.IPMRPBatchPolicy;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import java.math.BigDecimal;

public class PMRPFixedbatchPolicy
implements IPMRPBatchPolicy {
    private int startPeroid = -1;
    private PMRPCalcParam runParam;

    public PMRPCalcParam getRunParam() {
        return this.runParam;
    }

    public void setRunParam(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    @Override
    public void initRunParam(PMRPCalcParam runParam) {
        this.setRunParam(runParam);
    }

    @Override
    public PMRPBatchPolicyResult[] batchComputing(PMRPBatchPolicyVO batchPolocyVO) throws PMRPException {
        BigDecimal batchNum;
        BigDecimal batchQty;
        BigDecimal batchIncQty;
        BigDecimal zero = new BigDecimal("0");
        if (batchPolocyVO.getNetRequirementQty() == null || batchPolocyVO.getNetRequirementQty().compareTo(zero) >= 0) {
            return null;
        }
        this.startPeroid = batchPolocyVO.getCurrentPeriod();
        BigDecimal reqQty = batchPolocyVO.getNetRequirementQty().abs();
        BigDecimal yieldRate = batchPolocyVO.getYield();
        if (yieldRate == null) {
            yieldRate = new BigDecimal("100.00");
        }
        if ((yieldRate = yieldRate.divide(new BigDecimal(100), 4, 2)).compareTo(MRPConstant.ZERO) > 0 && batchPolocyVO.getMaterialAttriBute() == 10030) {
            reqQty = reqQty.divide(yieldRate, batchPolocyVO.getQtyPrc(), 2);
        }
        if ((batchIncQty = batchPolocyVO.getBatchIncQty()) == null) {
            batchIncQty = zero;
        }
        if ((batchQty = batchPolocyVO.getFixationBatchQty()) == null || batchQty.compareTo(zero) == 0) {
            batchIncQty = zero;
            batchQty = reqQty;
        }
        reqQty = reqQty.add(batchIncQty).divide(batchQty, 0, 0).multiply(batchQty).setScale(batchPolocyVO.getQtyPrc(), 0);
        BigDecimal roundUp = batchPolocyVO.getRoundUpMultipleQty();
        if (roundUp == null || roundUp.compareTo(zero) == 0) {
            roundUp = batchQty;
        }
        if ((batchNum = reqQty.divide(roundUp, 0, 0)).intValue() > 100) {
            throw new PMRPException(PMRPException.BATCH_OUT, new Object[]{batchPolocyVO.getMaterialNumber()});
        }
        int partition = batchPolocyVO.getPartitionQty();
        PMRPBatchPolicyResult[] result = new PMRPBatchPolicyResult[batchNum.intValue()];
        int peroid = this.startPeroid;
        int peroidOffset = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PMRPBatchPolicyResult();
            result[i].setQty(roundUp);
            result[i].setPeriod(peroid);
            result[i].setPeriodOffset(peroidOffset);
            if (partition != 0 && i != 0) {
                result[i].setException(63);
            }
            peroid += partition;
            peroidOffset += partition;
        }
        return result;
    }
}

