/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.runner.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFacadeFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHFactory;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.mm.ps.ScheduleTypeEnum;
import com.kingdee.eas.industry.emm.mm.ps.WorkShopPlanCollection;
import com.kingdee.eas.industry.emm.mm.ps.WorkShopPlanFactory;
import com.kingdee.eas.industry.emm.mm.ps.WorkShopPlanInfo;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.IPMRPPlannedOrder;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.runner.IPlannedOrderReleaseRunner;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.IReleaseStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl.ManufactureOrderInfoReleaseStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl.PurOrderInfoReleaseStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl.PurRequestInfoReleaseStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl.SubContractOrderInfoReleaseStep;
import com.kingdee.eas.mm.basedata.FactoryCalendarCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.EngineeringChangeFormMaterialAudit;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DefaultPOReleaseRunner
implements IPlannedOrderReleaseRunner {
    public static String MAPPING_MUTEX = "MM_PLANNEDORDER_RELEASE";

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    public Map<Class<?>, IReleaseStep> createSteps() throws BOSException, EASBizException {
        HashMap steps = new HashMap();
        steps.put(ManufactureOrderInfo.class, new ManufactureOrderInfoReleaseStep());
        steps.put(PurOrderInfo.class, new PurOrderInfoReleaseStep());
        steps.put(PurRequestInfo.class, new PurRequestInfoReleaseStep());
        steps.put(SubContractOrderInfo.class, new SubContractOrderInfoReleaseStep());
        return steps;
    }

    @Override
    public Map<String, Object> release(Context ctx, BOSUuid botpRuleId, Map<String, Object>[] plannedOrders) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<BOSUuid> successPlannedOrderList = new ArrayList<BOSUuid>();
        ArrayList<String> errorPlannedOrderList = new ArrayList<String>();
        HashMap<String, Object> errorPlannedOrderMap = new HashMap<String, Object>();
        returnMap.put("result", "ok");
        returnMap.put("errorPlannedOrderID", errorPlannedOrderList);
        returnMap.put("errorPlannedOrderResult", errorPlannedOrderMap);
        ArrayList<String> AllIDList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        String[] orgunits = this.checkDataMapping(ctx, botpRuleId, plannedOrders, errorPlannedOrderList, AllIDList, errorPlannedOrderMap);
        if (errorPlannedOrderList != null && errorPlannedOrderList.size() > 0) {
            returnMap.put("result", "error");
        }
        if (AllIDList == null || AllIDList.size() < 1) {
            return returnMap;
        }
        BOTMappingInfo botMappingInfo = this.getBOTMappingInfo(ctx, botpRuleId.toString());
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        ArrayList<Uuid> mutexUuids = new ArrayList<Uuid>();
        try {
            IMutexServiceControl iMutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            for (String orgUnitID : orgunits) {
                Uuid mutexUuid = Uuid.create();
                MutexParameter mutexParam = new MutexParameter();
                mutexParam.setRequestId(mutexUuid);
                mutexParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
                mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
                mutexParam.setMutexName(MAPPING_MUTEX);
                boolean requestFlag = iMutexService.requestMutex(mutexParam);
                if (!requestFlag) {
                    throw new PlanOrderException(PlanOrderException.SIMULANT_TRANSFER_LOCKED);
                }
                mutexUuids.add(mutexUuid);
            }
            MutexServiceControlFacadeFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(AllIDList);
            ArrayList<String> orderIDList = new ArrayList<String>();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.id"));
            sic.add(new SelectorItemInfo("storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("bom.id"));
            sic.add(new SelectorItemInfo("bom.number"));
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            IPMRPPlannedOrder iPlannedOrder = PMRPPlannedOrderFactory.getLocalInstance(ctx);
            Map<Class<?>, IReleaseStep> steps = this.createSteps();
            IRowSet rs = null;
            if (botMappingInfo.getDestEntityName().equals("1D0D80DD")) {
                block12: for (int i = 0; i < plannedOrders.length; ++i) {
                    BTPTransformResult result;
                    Map<String, Object> dataMap = plannedOrders[i];
                    if (dataMap.get("BillID") == null || errorPlannedOrderList != null && errorPlannedOrderList.contains(dataMap.get("BillID").toString())) continue;
                    BigDecimal ftfqty = new BigDecimal(dataMap.get("qty").toString());
                    BigDecimal releaseqty = new BigDecimal(dataMap.get("baseReleaseQty").toString());
                    if (ftfqty.compareTo(BigDecimal.ZERO) == 0 || releaseqty.compareTo(BigDecimal.ZERO) == 0) continue;
                    Date startDate = null;
                    if (dataMap.get("startDate") != null) {
                        startDate = (Date)dataMap.get("startDate");
                    }
                    Date endDate = null;
                    if (dataMap.get("endDate") != null) {
                        endDate = (Date)dataMap.get("endDate");
                    }
                    String schemeid = null;
                    if (dataMap.get("schemeid") != null) {
                        schemeid = dataMap.get("schemeid").toString();
                    }
                    ProductLineInfo productLineInfo = null;
                    if (dataMap.get("productLine") != null) {
                        productLineInfo = (ProductLineInfo)dataMap.get("productLine");
                    }
                    PMRPPlannedOrderInfo info = iPlannedOrder.getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(dataMap.get("BillID").toString()), sic);
                    if (startDate != null) {
                        info.setStartDate(startDate);
                    }
                    if (endDate != null) {
                        info.setEndDate(endDate);
                    }
                    BOTRelationCollection botRelationCollection = (result = iBTPManager.transform((CoreBillBaseInfo)info, botMappingInfo)) == null ? null : result.getBOTRelationCollection();
                    IObjectCollection billCollection = result.getBills();
                    ManufactureOrderCollection billAfterCol = new ManufactureOrderCollection();
                    for (int index = 0; index < billCollection.size(); ++index) {
                        if (billCollection.getObject(index) == null) continue;
                        CoreBillBaseInfo targetInfo = (CoreBillBaseInfo)billCollection.getObject(index);
                        IReleaseStep step = steps.get(targetInfo.getClass());
                        if (step != null) {
                            targetInfo.put("productLine", (Object)productLineInfo);
                            targetInfo.put("sourceScheduleID", (Object)schemeid);
                            try {
                                step.action(ctx, targetInfo, info, ftfqty);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                String errorString = e.getMessage();
                                if (errorString == null || "".equals(errorString) || "null".equals(errorString)) {
                                    StringWriter writer = new StringWriter();
                                    e.printStackTrace(new PrintWriter(writer));
                                    errorString = writer.toString();
                                }
                                returnMap.put("result", "error");
                                errorPlannedOrderList.add(info.getId().toString());
                                errorPlannedOrderMap.put(info.getId().toString(), "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0069") + errorString);
                                continue block12;
                            }
                            if (errorPlannedOrderList.contains(info.getId().toString())) continue;
                            iBTPManager.saveRelations(targetInfo, botRelationCollection);
                            billAfterCol.addObject((IObjectValue)targetInfo);
                            if (targetInfo.getId() == null) continue;
                            if (info.getQty().compareTo(this.getTotalManuOrderQty(ctx, info.getId().toString())) < 0) {
                                String errorString = ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_MORETHANQTY2", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()});
                                returnMap.put("result", "error");
                                errorPlannedOrderList.add(info.getId().toString());
                                errorPlannedOrderMap.put(info.getId().toString(), "[" + info.getNumber() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0069") + errorString);
                                ManufactureOrderFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(targetInfo.getId()));
                                continue block12;
                            }
                            orderIDList.add(targetInfo.getId().toString());
                            continue;
                        }
                        throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0070") + targetInfo.getClass().getName()));
                    }
                    EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance(ctx).relOrderIDCostObject(orderIDList);
                    if (errorPlannedOrderList.contains(info.getId().toString())) continue;
                    this.HandleTOWSP(ctx, (IObjectCollection)billAfterCol, info);
                    sql.setLength(0);
                    sql.append(" update t_mrp_pmrpplannedorder set ftotalreleaseqty = isnull(ftotalreleaseqty,0) + ");
                    sql.append(ftfqty);
                    sql.append(" , fbasetotalreleaseqty = isnull(fbasetotalreleaseqty,0) + ");
                    sql.append(releaseqty);
                    sql.append(" where fid =  ? ");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{info.getId().toString()});
                    sql.setLength(0);
                    sql.append(" select fid from t_mrp_pmrpplannedorder where fid = ? and ftotalreleaseqty > fqty ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{info.getId().toString()});
                    try {
                        if (rs != null && rs.size() > 0 && rs.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("error", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_MORETHANQTY", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()})));
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        throw new BOSException((Throwable)e);
                    }
                    sql.setLength(0);
                    sql.append(" update t_mrp_pmrpplannedorder set fbasestatus = 7 ");
                    sql.append(" where fid =  ? ");
                    sql.append(" and ftotalreleaseqty >= fqty");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{info.getId().toString()});
                    if (schemeid != null && !"".equals(schemeid)) {
                        sql.setLength(0);
                        sql.append(" update t_sch_poscheduleentry set freleaseqty = isnull(freleaseqty,0) + ");
                        sql.append(ftfqty);
                        sql.append(" , freleasedate = sysdate,freleaseuserid =  '");
                        sql.append(curUserID);
                        sql.append("' where fid =  '").append(schemeid).append("'");
                        DbUtil.execute((Context)ctx, (String)sql.toString());
                    }
                    successPlannedOrderList.add(info.getId());
                }
            } else {
                HashMap<String, BigDecimal> idqtymap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> baseQtymap = new HashMap<String, BigDecimal>();
                CoreBillBaseCollection coll = new CoreBillBaseCollection();
                for (int i = 0; i < plannedOrders.length; ++i) {
                    Map<String, Object> dataMap = plannedOrders[i];
                    if (dataMap.get("BillID") == null || errorPlannedOrderList != null && errorPlannedOrderList.contains(dataMap.get("BillID").toString())) continue;
                    BigDecimal ftfqty = new BigDecimal(dataMap.get("qty").toString());
                    BigDecimal releaseqty = new BigDecimal(dataMap.get("baseReleaseQty").toString());
                    if (ftfqty.compareTo(BigDecimal.ZERO) == 0 || releaseqty.compareTo(BigDecimal.ZERO) == 0) continue;
                    Date startDate = null;
                    if (dataMap.get("startDate") != null) {
                        startDate = (Date)dataMap.get("startDate");
                    }
                    Date endDate = null;
                    if (dataMap.get("endDate") != null) {
                        endDate = (Date)dataMap.get("endDate");
                    }
                    String schemeid = null;
                    if (dataMap.get("schemeid") != null) {
                        schemeid = dataMap.get("schemeid").toString();
                    }
                    PMRPPlannedOrderInfo info = iPlannedOrder.getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(dataMap.get("BillID").toString()), sic);
                    if (startDate != null) {
                        info.setStartDate(startDate);
                    }
                    if (endDate != null) {
                        info.setEndDate(endDate);
                    }
                    coll.add((CoreBillBaseInfo)info);
                    idqtymap.put(dataMap.get("BillID").toString(), ftfqty);
                    baseQtymap.put(dataMap.get("BillID").toString(), releaseqty);
                    if (schemeid == null || "".equals(schemeid)) continue;
                    sql.setLength(0);
                    sql.append(" update t_sch_poscheduleentry set freleaseqty = isnull(freleaseqty,0) + ");
                    sql.append(ftfqty);
                    sql.append(" , freleasedate = sysdate,freleaseuserid =  '");
                    sql.append(curUserID);
                    sql.append("' where fid =  '").append(schemeid).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                BTPTransformResult result = iBTPManager.transform(coll, botMappingInfo);
                BOTRelationCollection botRelationCollection = result == null ? null : result.getBOTRelationCollection();
                IObjectCollection billCollection = result.getBills();
                for (int index = 0; index < billCollection.size(); ++index) {
                    if (billCollection.getObject(index) == null) continue;
                    CoreBillBaseInfo targetInfo = (CoreBillBaseInfo)billCollection.getObject(index);
                    IReleaseStep step = steps.get(targetInfo.getClass());
                    if (step != null) {
                        step.action(ctx, targetInfo, coll, idqtymap);
                        if (botRelationCollection == null) continue;
                        BOTRelationInfo relation = botRelationCollection.get(index);
                        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(relation);
                        continue;
                    }
                    throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0070") + targetInfo.getClass().getName()));
                }
                Set set = idqtymap.keySet();
                Set baSet = baseQtymap.keySet();
                Iterator it = set.iterator();
                Iterator baSetit = baSet.iterator();
                while (it.hasNext() && baSetit.hasNext()) {
                    String key = String.valueOf(it.next());
                    String id = String.valueOf(baSetit.next());
                    BigDecimal ftfqty = new BigDecimal(idqtymap.get(key).toString());
                    BigDecimal releaseqty = new BigDecimal(baseQtymap.get(id).toString());
                    sql.setLength(0);
                    sql.append(" update t_mrp_pmrpplannedorder set ftotalreleaseqty = isnull(ftotalreleaseqty,0) + ");
                    sql.append(ftfqty);
                    sql.append(" , fbasetotalreleaseqty = isnull(fbasetotalreleaseqty,0) + ");
                    sql.append(releaseqty);
                    sql.append(" where fid =  '").append(key).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql.setLength(0);
                    sql.append(" update t_mrp_pmrpplannedorder set fbasestatus = 7 ");
                    sql.append(" where fid =  '").append(key).append("'");
                    sql.append(" and ftotalreleaseqty >= fqty");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    successPlannedOrderList.add(BOSUuid.read((String)key));
                }
            }
            Iterator<IReleaseStep> iter = steps.values().iterator();
            while (iter.hasNext()) {
                iter.next().afterResolved(ctx);
            }
        }
        catch (BTPException e) {
            StringBuffer exceptionMessage = new StringBuffer();
            exceptionMessage.append("BOTP [").append(botMappingInfo == null || botMappingInfo.getName() == null ? "" : botMappingInfo.getName()).append("] ,").append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0071")).append(e.getMessage());
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0072"), exceptionMessage.toString()));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            int size = mutexUuids.size();
            for (int i = 0; i < size; ++i) {
                IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex((Uuid)mutexUuids.get(i));
            }
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(AllIDList);
        }
        return returnMap;
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    protected BigDecimal getTotalManuOrderQty(Context ctx, String plannedorderID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(fqty) As fqty from t_mm_manufactureorder where fsourcebillid = ?  and  fsourcebilltypeid = 'xY8YcglBRDqUyT1SHhR3QUY+1VI=' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{plannedorderID});
        try {
            if (rs.next()) {
                return rs.getBigDecimal("fqty");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return BigDecimal.ZERO;
    }

    protected void HandleTOWSP(Context ctx, IObjectCollection targetCol, PMRPPlannedOrderInfo plannedOrderInfo) throws BOSException, EASBizException {
        if (targetCol == null || targetCol.size() <= 0) {
            return;
        }
        HashMap newWSPMap = new HashMap();
        HashMap<String, HashMap> wcMap = new HashMap<String, HashMap>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("parentWC.*"));
        for (int j = 0; j < targetCol.size(); ++j) {
            ManufactureOrderInfo manuOrderInfo = (ManufactureOrderInfo)targetCol.getObject(j);
            String projectID = manuOrderInfo.getProject() == null ? null : manuOrderInfo.getProject().getId().toString();
            String trackID = manuOrderInfo.getTrackNumber() == null ? null : manuOrderInfo.getTrackNumber().getId().toString();
            String proJCHID = manuOrderInfo.getProjectJCH() == null ? null : manuOrderInfo.getProjectJCH().getId().toString();
            ManufactureOrderTechnicsCollection mtCol = manuOrderInfo.getTechnics();
            if (mtCol == null) continue;
            for (int i = 0; i < mtCol.size(); ++i) {
                String storageID;
                ManufactureOrderTechnicsInfo motInfo = mtCol.get(i);
                HashMap tmpmap = new HashMap();
                String workcenterID = motInfo.getWorkcenter() == null ? null : motInfo.getWorkcenter().getId().toString();
                String string = storageID = motInfo.getStorageOrgUnit() == null ? null : motInfo.getStorageOrgUnit().getId().toString();
                if (IndustryUtils.isEmptyString((String)workcenterID)) continue;
                WorkCenterInfo wcInfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(workcenterID), selector);
                if (IndustryUtils.isEmptyString((String)storageID)) continue;
                String key = storageID + (IndustryUtils.isEmptyString((String)projectID) ? "null" : projectID) + (IndustryUtils.isEmptyString((String)trackID) ? "null" : trackID) + (IndustryUtils.isEmptyString((String)proJCHID) ? "null" : proJCHID);
                if (wcInfo != null && wcInfo.isIsWorkshop() && ((Boolean)wcInfo.get("isGenWSP")).booleanValue()) {
                    key = key + wcInfo.getId().toString();
                } else {
                    if (wcInfo == null || wcInfo.getParentWC() == null || !wcInfo.getParentWC().isIsWorkshop() || !((Boolean)wcInfo.getParentWC().get("isGenWSP")).booleanValue()) continue;
                    key = key + wcInfo.getParentWC().getId().toString();
                }
                if (wcMap.containsKey(key)) {
                    tmpmap = (HashMap)wcMap.get(key);
                    Timestamp startTimeC = motInfo.getEarlistWoktime();
                    Timestamp endTimeC = motInfo.getEarlistCmpTime();
                    Date startTime = (Date)tmpmap.get("startTime");
                    Date endTime = (Date)tmpmap.get("endTime");
                    if (startTimeC.before(startTime)) {
                        tmpmap.put("startTime", startTimeC);
                    }
                    if (!endTimeC.after(endTime)) continue;
                    tmpmap.put("endTime", endTimeC);
                    continue;
                }
                tmpmap.put("storageID", storageID);
                tmpmap.put("projectID", projectID);
                tmpmap.put("trackID", trackID);
                tmpmap.put("proJCHID", proJCHID);
                if (wcInfo != null && wcInfo.isIsWorkshop() && ((Boolean)wcInfo.get("isGenWSP")).booleanValue()) {
                    tmpmap.put("workCenter", wcInfo);
                } else if (wcInfo != null && wcInfo.getParentWC() != null && wcInfo.getParentWC().isIsWorkshop() && ((Boolean)wcInfo.getParentWC().get("isGenWSP")).booleanValue()) {
                    tmpmap.put("workCenter", wcInfo.getParentWC());
                }
                tmpmap.put("startTime", motInfo.getEarlistWoktime());
                tmpmap.put("endTime", motInfo.getEarlistCmpTime());
                wcMap.put(key, tmpmap);
            }
        }
        if (wcMap != null && wcMap.size() > 0) {
            for (Object key : wcMap.keySet()) {
                HashMap tmpmap = new HashMap();
                tmpmap = (HashMap)wcMap.get(key);
                String storageID = tmpmap.get("storageID").toString();
                String projectID = tmpmap.get("projectID") == null ? null : tmpmap.get("projectID").toString();
                String trackID = tmpmap.get("trackID") == null ? null : tmpmap.get("trackID").toString();
                String proJCHID = tmpmap.get("proJCHID") == null ? null : tmpmap.get("proJCHID").toString();
                WorkCenterInfo wcInfo = (WorkCenterInfo)tmpmap.get("workCenter");
                Date startTime = (Date)tmpmap.get("startTime");
                Date compTime = (Date)tmpmap.get("endTime");
                if (IndustryUtils.isEmptyString((String)storageID) || wcInfo == null) continue;
                StorageOrgUnitInfo storageInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageID));
                ProjectInfo projectInfo = null;
                if (!IndustryUtils.isEmptyString((String)projectID)) {
                    projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
                }
                TrackNumberInfo trackInfo = null;
                if (!IndustryUtils.isEmptyString((String)trackID)) {
                    trackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackID));
                }
                ProjectJCHInfo proJCHInfo = null;
                if (!IndustryUtils.isEmptyString((String)proJCHID)) {
                    proJCHInfo = ProjectJCHFactory.getLocalInstance((Context)ctx).getProjectJCHInfo((IObjectPK)new ObjectUuidPK(proJCHID));
                }
                SelectorItemCollection fceSelectorItemCollection = new SelectorItemCollection();
                fceSelectorItemCollection.add(new SelectorItemInfo("id"));
                fceSelectorItemCollection.add(new SelectorItemInfo("planStartDate"));
                fceSelectorItemCollection.add(new SelectorItemInfo("planCompletionDate"));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)wcInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("trackNum.id", (Object)trackID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("jchProject.id", (Object)proJCHID, CompareType.EQUALS));
                filter.setMaskString("( #0 And #1 And #2 And #3 And #4 )");
                view.setFilter(filter);
                view.setSelector(fceSelectorItemCollection);
                WorkShopPlanCollection wcCol = WorkShopPlanFactory.getLocalInstance((Context)ctx).getWorkShopPlanCollection(view);
                if (wcCol == null || wcCol.size() <= 0) {
                    WorkShopPlanInfo newWCInfo = new WorkShopPlanInfo();
                    newWCInfo.setStorageOrgUnit(storageInfo);
                    newWCInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                    EntityViewInfo viewInfoSP = new EntityViewInfo();
                    FilterInfo filterInfoSP = new FilterInfo();
                    filterInfoSP.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageInfo.getId().toString(), CompareType.EQUALS));
                    filterInfoSP.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"1", CompareType.EQUALS));
                    viewInfoSP.setFilter(filterInfoSP);
                    FactoryCalendarCollection fcCols = FactoryCalendarFactory.getLocalInstance((Context)ctx).getFactoryCalendarCollection(viewInfoSP);
                    if (fcCols != null && fcCols.size() > 0) {
                        newWCInfo.setFactoryCalendar(fcCols.get(0));
                    }
                    newWCInfo.setPlanStartDate(startTime);
                    newWCInfo.setPlanCompletionDate(compTime);
                    newWCInfo.setScheduleType(ScheduleTypeEnum.FS);
                    newWCInfo.setProject(projectInfo);
                    newWCInfo.setTrackNum(trackInfo);
                    newWCInfo.setJchProject(proJCHInfo);
                    newWCInfo.setWorkCenter(wcInfo);
                    newWCInfo.setIsComplete(false);
                    newWCInfo.setMaterial(this.getProjectTrackNumberMaterial(ctx, newWCInfo));
                    this.setBillNumber(ctx, (IObjectValue)newWCInfo, storageInfo.getId().toString());
                    IObjectPK pk = WorkShopPlanFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)newWCInfo);
                    this.generateBOTPRelation(ctx, "46D6DB79", "B356336E", plannedOrderInfo.getId().toString(), pk.toString());
                    continue;
                }
                WorkShopPlanInfo WCInfo = wcCol.get(0);
                if (!WCInfo.getBillStatus().equals((Object)BillBaseStatusEnum.ADD) && !WCInfo.getBillStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !WCInfo.getBillStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) continue;
                if (WCInfo.getPlanStartDate().after(startTime)) {
                    WCInfo.setPlanStartDate(startTime);
                }
                if (WCInfo.getPlanCompletionDate().before(compTime)) {
                    WCInfo.setPlanCompletionDate(compTime);
                }
                SelectorItemCollection select = new SelectorItemCollection();
                select.add(new SelectorItemInfo("planStartDate"));
                select.add(new SelectorItemInfo("planCompletionDate"));
                WorkShopPlanFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)WCInfo, select);
                this.generateBOTPRelation(ctx, "46D6DB79", "B356336E", plannedOrderInfo.getId().toString(), WCInfo.getId().toString());
            }
        }
    }

    protected void generateBOTPRelation(Context ctx, String sourceBillType, String destBillType, String sourceBillID, String destBillID) throws BOSException, EASBizException {
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        SQLUtils.execute((Context)ctx, (String)EngineeringChangeFormMaterialAudit.sql_BOTPRelation.replace("CURDate()", "now()"), (Object[])new Object[]{sourceBillType, destBillType, sourceBillID, destBillID, curUserID});
    }

    protected String[] checkDataMapping(Context ctx, BOSUuid botpRuleId, Map<String, Object>[] plannedOrders, List<String> errorPlannedOrderList, List<String> AllIDList, Map<String, Object> errorPlannedOrderMap) throws BOSException, EASBizException {
        String errorStr = null;
        IPMRPPlannedOrder iPlannedOrder = PMRPPlannedOrderFactory.getLocalInstance(ctx);
        HashSet<String> orgUnits = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("totalReleaseQty"));
        sic.add(new SelectorItemInfo("baseTotalReleaseQty"));
        sic.add(new SelectorItemInfo("productionOrgUnit.id"));
        sic.add(new SelectorItemInfo("isSimulant"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        HashMap<String, BigDecimal> idQtyMap = new HashMap<String, BigDecimal>();
        BigDecimal fcomputedQty = new BigDecimal(0);
        for (int i = 0; i < plannedOrders.length; ++i) {
            BigDecimal fplanQty;
            Map<String, Object> dataMap = plannedOrders[i];
            if (dataMap.get("BillID") == null) continue;
            PMRPPlannedOrderInfo info = iPlannedOrder.getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(dataMap.get("BillID").toString()), sic);
            AllIDList.add(dataMap.get("BillID").toString());
            if (dataMap.get("qty") == null) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0074");
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            BigDecimal ftfqty = new BigDecimal(dataMap.get("qty").toString());
            if (ftfqty.compareTo(BigDecimal.ZERO) < 0) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0075") + "[" + ftfqty.toString() + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0076");
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            if (ftfqty.compareTo(BigDecimal.ZERO) == 0) continue;
            fcomputedQty = BigDecimal.ZERO;
            if (idQtyMap != null && idQtyMap.containsKey(info.getId().toString())) {
                fcomputedQty = new BigDecimal(idQtyMap.get(info.getId().toString()).toString());
            }
            if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0077");
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            if (info.isIsSimulant()) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0078");
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            BigDecimal fqty = info.getBaseQty();
            BigDecimal fTotalReleaseQty = new BigDecimal(0);
            if (info.getTotalReleaseQty() != null) {
                fTotalReleaseQty = info.getTotalReleaseQty();
            }
            if (ftfqty.compareTo((fplanQty = info.getQty()).subtract(fcomputedQty.add(fTotalReleaseQty))) > 0) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0080") + "[" + fqty + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0081") + "[" + fTotalReleaseQty + "]+" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0082") + ftfqty.add(fcomputedQty) + "]";
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            fcomputedQty = fcomputedQty.add(ftfqty);
            idQtyMap.put(info.getId().toString(), fcomputedQty);
            StorageOrgUnitInfo storageOrgUnitInfo = info.getStorageOrgUnit();
            MaterialInfo materialInfo = info.getMaterial();
            String fmaterialPlanCheck = this.checkMaterialPlan(ctx, materialInfo, storageOrgUnitInfo);
            if (!"ok".equals(fmaterialPlanCheck)) {
                errorStr = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0073") + "[" + info.getNumber() + "]," + fmaterialPlanCheck;
                this.setErrorMap(errorPlannedOrderMap, info.getId().toString(), errorStr);
                errorPlannedOrderList.add(info.getId().toString());
                continue;
            }
            if (!orgUnits.contains(storageOrgUnitInfo.getId().toString())) {
                orgUnits.add(storageOrgUnitInfo.getId().toString());
            }
            if (orgUnits.contains(info.getProductionOrgUnit().getId().toString())) continue;
            orgUnits.add(info.getProductionOrgUnit().getId().toString());
        }
        String[] s = new String[orgUnits.size()];
        return orgUnits.toArray(s);
    }

    protected BOTMappingInfo getBOTMappingInfo(Context ctx, String fid) throws BOSException, EASBizException {
        if (fid == null) {
            return null;
        }
        if (fid.trim().length() == 0) {
            return null;
        }
        BOTMappingInfo botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(fid));
        if (botMappingInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0083"), ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"MYZDIDWZHGZ", (Locale)ctx.getLocale(), (Object[])new Object[]{fid})));
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0083"), ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"BOTPWZMYQY", (Locale)ctx.getLocale(), (Object[])new Object[]{botMappingInfo.getName()})));
        }
        return botMappingInfo;
    }

    protected void setErrorMap(Map<String, Object> errorPlannedOrderMap, String errorID, String errorStr) {
        if (errorID == null || "".equals(errorID)) {
            return;
        }
        if (errorStr == null) {
            errorStr = "";
        }
        if (errorPlannedOrderMap != null && errorPlannedOrderMap.containsKey(errorID)) {
            String folderrStr = errorPlannedOrderMap.get(errorID).toString();
            errorPlannedOrderMap.put(errorID, folderrStr + " " + errorStr);
        } else {
            errorPlannedOrderMap.put(errorID, errorStr);
        }
    }

    protected String checkMaterialPlan(Context ctx, MaterialInfo minfo, StorageOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        if (minfo == null || orgInfo == null) {
            return this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0084");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select mp.fstatus   from T_BD_MaterialPlan mp  where  mp.fmaterialid = '" + minfo.getId() + "' and mp.Forgunit = '" + orgInfo.getId() + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() < 1) {
            return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"WLZKCZZXMYWHJHYQ", (Locale)ctx.getLocale(), (Object[])new Object[]{minfo.getNumber(), orgInfo.getNumber() + orgInfo.getName()});
        }
        try {
            while (rs.next()) {
                if (rs.getString("fstatus") != null && !"0".equals(rs.getString("fstatus"))) continue;
                return ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"JHYQMYSH", (Locale)ctx.getLocale(), (Object[])new Object[]{minfo.getNumber(), orgInfo.getNumber() + orgInfo.getName()});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return "ok";
    }

    protected MaterialInfo getProjectTrackNumberMaterial(Context ctx, WorkShopPlanInfo wsInfo) throws EASBizException, BOSException {
        MaterialInfo materialInfo = null;
        if (wsInfo == null) {
            return null;
        }
        if (wsInfo.getTrackNum() == null || wsInfo.getProject() == null || wsInfo.getStorageOrgUnit() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select d.cfmaterialid as cfmaterialid from  CT_BAS_ProductProject h ");
        sql.append(" inner join ct_bas_productprojectentry d on h.fid = d.fparentid ");
        sql.append(" where h.cfstorageorgunitid = '" + wsInfo.getStorageOrgUnit().getId() + "' ");
        sql.append(" and h.cfprojectid = '" + wsInfo.getProject().getId() + "' ");
        sql.append(" and d.cftracknumberid = '" + wsInfo.getTrackNum().getId() + "' ");
        sql.append(" and rownum = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(rs.getString("cfmaterialid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return materialInfo;
    }
}

