/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.AbstractPlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderMappingFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.IReleaseStep;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.util.Map;

public class PurOrderInfoReleaseStep
implements IReleaseStep {
    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        this.purOrderDeal(ctx, (PurOrderInfo)targetInfo, plannedOrderInfo, fReleaseQty);
    }

    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, CoreBillBaseCollection plannedOrderCollection, Map ReleaseQtyMap) throws BOSException, EASBizException {
        for (int i = 0; i < plannedOrderCollection.size(); ++i) {
            PMRPPlannedOrderInfo plannedOrderInfo = (PMRPPlannedOrderInfo)plannedOrderCollection.get(i);
            BigDecimal fReleaseQty = new BigDecimal(ReleaseQtyMap.get(plannedOrderInfo.getId().toString()).toString());
            this.purOrderDeal(ctx, (PurOrderInfo)targetInfo, plannedOrderInfo, fReleaseQty);
        }
        PurOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)targetInfo);
    }

    @Override
    public void afterResolved(Context ctx) throws BOSException, EASBizException {
    }

    protected void purOrderDeal(Context ctx, PurOrderInfo purOrderInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        if (purOrderInfo == null) {
            return;
        }
        if (purOrderInfo.getSourceBillId() == null) {
            purOrderInfo.setSourceBillId(plannedOrderInfo.getId().toString());
        }
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)Constants.PRMPPlannedOrderBizTypeID));
        if (purOrderInfo.getSourceBillType() == null) {
            purOrderInfo.setSourceBillType(billTypeInfo);
        }
        StorageOrgUnitInfo storageOrgUnitInfo = plannedOrderInfo.getStorageOrgUnit();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        if (purOrderInfo.getCompanyOrgUnit() == null) {
            String[] s = new String[]{storageOrgUnitInfo.getId().toString()};
            Map companyOrgmap = PMRPPlannedOrderMappingFacadeFactory.getLocalInstance(ctx).getCouOrgUnit(s);
            if (companyOrgmap != null) {
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                String fcompID = companyOrgmap.get(storageOrgUnitInfo.getId().toString()).toString();
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fcompID));
                purOrderInfo.setCompanyOrgUnit(companyOrgUnitInfo);
            }
        }
        AbstractPlanDefinedInfo pdinfo = null;
        if (purOrderInfo.getPurchaseOrgUnit() == null) {
            if (purchaseOrgUnitInfo == null) {
                if (plannedOrderInfo.getScheme() != null) {
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("PurchaseRelation.id"));
                    sic.add(new SelectorItemInfo("PurchaseRelation.Entry.*"));
                    pdinfo = PlanDefinedFactory.getLocalInstance(ctx).getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(plannedOrderInfo.getScheme().getId()), sic);
                }
                if (pdinfo != null && pdinfo.getPurchaseRelation() != null) {
                    PurRelationshipDefinitionInfo purRelInto = pdinfo.getPurchaseRelation();
                    for (int j = 0; j < purRelInto.getEntry().size(); ++j) {
                        PurRelationshipDefinitionEntryInfo purRelEntryInto = purRelInto.getEntry().get(j);
                        if (purRelEntryInto.getProductOrgUnit() == null || purRelEntryInto.getPurchaseOrgUnit() == null || !purRelEntryInto.getProductOrgUnit().getId().toString().equals(storageOrgUnitInfo.getId().toString())) continue;
                        purchaseOrgUnitInfo = new PurchaseOrgUnitInfo();
                        purchaseOrgUnitInfo.setId(BOSUuid.read((String)purRelEntryInto.getPurchaseOrgUnit().getId().toString()));
                        purOrderInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
                    }
                }
            } else {
                purOrderInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
            }
        }
        for (int i = 0; i < purOrderInfo.getEntries().size(); ++i) {
            PurOrderEntryInfo entryInfo = purOrderInfo.getEntries().get(i);
            if (entryInfo.getSourceBillId() == null || !entryInfo.getSourceBillId().equals(plannedOrderInfo.getId().toString())) continue;
            if (entryInfo.getCompanyOrgUnit() == null && purOrderInfo.getCompanyOrgUnit() != null) {
                entryInfo.setCompanyOrgUnit(purOrderInfo.getCompanyOrgUnit());
            }
            entryInfo.setQty(fReleaseQty);
            entryInfo.setBaseQty(fReleaseQty);
            if (entryInfo.getPurchaseOrgUnit() == null) {
                if (purchaseOrgUnitInfo == null) {
                    if (pdinfo != null && pdinfo.getPurchaseRelation() != null) {
                        PurRelationshipDefinitionInfo purRelInto = pdinfo.getPurchaseRelation();
                        for (int j = 0; j < purRelInto.getEntry().size(); ++j) {
                            PurRelationshipDefinitionEntryInfo purRelEntryInto = purRelInto.getEntry().get(j);
                            if (purRelEntryInto.getProductOrgUnit() == null || purRelEntryInto.getPurchaseOrgUnit() == null || !purRelEntryInto.getProductOrgUnit().getId().toString().equals(storageOrgUnitInfo.getId().toString())) continue;
                            purchaseOrgUnitInfo = new PurchaseOrgUnitInfo();
                            purchaseOrgUnitInfo.setId(BOSUuid.read((String)purRelEntryInto.getPurchaseOrgUnit().getId().toString()));
                            entryInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo.getId().toString());
                        }
                    }
                } else {
                    entryInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo.getId().toString());
                }
            }
            if (entryInfo.getStorageOrgUnit() == null) {
                entryInfo.setStorageOrgUnit(plannedOrderInfo.getProductionOrgUnit());
            }
            if (entryInfo.getSourceBillNumber() == null) {
                entryInfo.setSourceBillNumber(plannedOrderInfo.getNumber());
            }
            if (entryInfo.getSourceBillId() == null) {
                entryInfo.setSourceBillId(plannedOrderInfo.getId().toString());
            }
            if (entryInfo.getSourceBillType() == null) {
                entryInfo.setSourceBillType(billTypeInfo);
            }
            if (entryInfo.getMaterial() == null || entryInfo.getPurchaseOrgUnit() == null || purOrderInfo.getPurchaseGroup() != null && purOrderInfo.getPurchasePerson() != null) continue;
            MaterialPurchasingInfo mp = Material8FacadeFactory.getLocalInstance((Context)ctx).getPurchasingInfo(entryInfo.getMaterial().getId().toString(), entryInfo.getPurchaseOrgUnit());
            purOrderInfo.setPurchaseGroup(mp.getPurGroup());
            purOrderInfo.setPurchasePerson(mp.getPurPerson());
        }
    }
}

