/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.AbstractPlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderMappingFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.IReleaseStep;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class PurRequestInfoReleaseStep
implements IReleaseStep {
    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        this.purRequestDeal(ctx, (PurRequestInfo)targetInfo, plannedOrderInfo, fReleaseQty);
    }

    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, CoreBillBaseCollection plannedOrderCollection, Map ReleaseQtyMap) throws BOSException, EASBizException {
        if (targetInfo != null) {
            PurRequestInfo purRequestInfo = (PurRequestInfo)targetInfo;
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new PurRequestInfo(), purRequestInfo.getCompanyOrgUnit().getId().toString());
            if (!ruleStatus.isExist()) {
                throw new EASBizException(new NumericExceptionSubItem("\u5916\u8d2d\u7c7b\u6295\u653e\u5931\u8d25", "\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u7f16\u7801\u89c4\u5219\u672a\u542f\u7528"));
            }
            String fnumber = codingRuleManager.getNumber((IObjectValue)purRequestInfo, purRequestInfo.getCompanyOrgUnit().getId().toString());
            targetInfo.setNumber(fnumber);
        }
        for (int i = 0; i < plannedOrderCollection.size(); ++i) {
            PMRPPlannedOrderInfo plannedOrderInfo = (PMRPPlannedOrderInfo)plannedOrderCollection.get(i);
            BigDecimal fReleaseQty = new BigDecimal(ReleaseQtyMap.get(plannedOrderInfo.getId().toString()).toString());
            this.purRequestDeal(ctx, (PurRequestInfo)targetInfo, plannedOrderInfo, fReleaseQty);
        }
    }

    @Override
    public void afterResolved(Context ctx) throws BOSException, EASBizException {
    }

    protected void purRequestDeal(Context ctx, PurRequestInfo purRequestInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        if (purRequestInfo == null) {
            return;
        }
        if (purRequestInfo.getSourceBillId() == null) {
            purRequestInfo.setSourceBillId(plannedOrderInfo.getId().toString());
        }
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)Constants.PRMPPlannedOrderBizTypeID));
        if (purRequestInfo.getSourceBillType() == null) {
            purRequestInfo.setSourceBillType(billTypeInfo);
        }
        StorageOrgUnitInfo storageOrgUnitInfo = plannedOrderInfo.getStorageOrgUnit();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        AbstractPlanDefinedInfo pdinfo = null;
        if (purRequestInfo.getCompanyOrgUnit() == null) {
            String[] s = new String[]{storageOrgUnitInfo.getId().toString()};
            Map companyOrgmap = PMRPPlannedOrderMappingFacadeFactory.getLocalInstance(ctx).getCouOrgUnit(s);
            if (companyOrgmap != null) {
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                String fcompID = companyOrgmap.get(storageOrgUnitInfo.getId().toString()).toString();
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fcompID));
                purRequestInfo.setCompanyOrgUnit(companyOrgUnitInfo);
            }
        }
        for (int i = 0; i < purRequestInfo.getEntries().size(); ++i) {
            PurRequestEntryInfo entryInfo = purRequestInfo.getEntries().get(i);
            if (entryInfo.getSourceBillId() == null || !entryInfo.getSourceBillId().equals(plannedOrderInfo.getId().toString())) continue;
            if (entryInfo.getCompanyOrgUnit() == null && purRequestInfo.getCompanyOrgUnit() != null) {
                entryInfo.setCompanyOrgUnit(purRequestInfo.getCompanyOrgUnit().getId().toString());
            }
            entryInfo.setQty(fReleaseQty);
            entryInfo.setBaseQty(fReleaseQty);
            entryInfo.put("unTotalDownQty", (Object)fReleaseQty);
            entryInfo.setRequestQty(fReleaseQty);
            entryInfo.setUnOrderedQty(fReleaseQty);
            entryInfo.setUnOrderedBaseQty(fReleaseQty);
            entryInfo.setUnTotalReqQty(fReleaseQty);
            if (entryInfo.getPurchaseOrgUnit() == null) {
                if (purchaseOrgUnitInfo == null) {
                    if (plannedOrderInfo.getScheme() != null) {
                        sic.add(new SelectorItemInfo("*"));
                        sic.add(new SelectorItemInfo("PurchaseRelation.id"));
                        sic.add(new SelectorItemInfo("PurchaseRelation.Entry.*"));
                        pdinfo = PlanDefinedFactory.getLocalInstance(ctx).getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(plannedOrderInfo.getScheme().getId()), sic);
                    }
                    if (pdinfo != null && pdinfo.getPurchaseRelation() != null) {
                        PurRelationshipDefinitionInfo purRelInto = pdinfo.getPurchaseRelation();
                        for (int j = 0; j < purRelInto.getEntry().size(); ++j) {
                            PurRelationshipDefinitionEntryInfo purRelEntryInto = purRelInto.getEntry().get(j);
                            if (purRelEntryInto.getProductOrgUnit() == null || purRelEntryInto.getPurchaseOrgUnit() == null || !purRelEntryInto.getProductOrgUnit().getId().toString().equals(storageOrgUnitInfo.getId().toString())) continue;
                            purchaseOrgUnitInfo = new PurchaseOrgUnitInfo();
                            purchaseOrgUnitInfo.setId(BOSUuid.read((String)purRelEntryInto.getPurchaseOrgUnit().getId().toString()));
                            entryInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
                        }
                    }
                } else {
                    entryInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
                }
            }
            if (entryInfo.getStorageOrgUnit() == null) {
                entryInfo.setStorageOrgUnit(plannedOrderInfo.getProductionOrgUnit());
            }
            if (entryInfo.getSourceBillNumber() == null) {
                entryInfo.setSourceBillNumber(plannedOrderInfo.getNumber());
            }
            if (entryInfo.getSourceBillId() == null) {
                entryInfo.setSourceBillId(plannedOrderInfo.getId().toString());
            }
            if (entryInfo.getSourceBillType() == null) {
                entryInfo.setSourceBillType(billTypeInfo);
            }
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            entryInfo.setBizDate(new Date());
            if (entryInfo.getMaterial() == null || entryInfo.getPurchaseOrgUnit() == null) continue;
            MaterialPurchasingInfo mp = Material8FacadeFactory.getLocalInstance((Context)ctx).getPurchasingInfo(entryInfo.getMaterial().getId().toString(), entryInfo.getPurchaseOrgUnit().getId().toString());
            if (mp == null) {
                MaterialInfo m = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId().toString()));
                throw new EASBizException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0092"), this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0093") + m.getName() + "(" + entryInfo.getMaterial().getNumber() + ")," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0094") + entryInfo.getPurchaseOrgUnit().getName() + "(" + entryInfo.getPurchaseOrgUnit().getNumber() + ")," + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0095")));
            }
            entryInfo.setPurchaseGroup(mp.getPurGroup());
            entryInfo.setPurchasePerson(mp.getPurPerson());
        }
        purRequestInfo.setBizDate(new Date());
        purRequestInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        PurRequestFactory.getLocalInstance((Context)ctx).save((IObjectPK)new ObjectUuidPK(purRequestInfo.getId().toString()), (CoreBaseInfo)purRequestInfo);
    }
}

