/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.runner;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.ComputeTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPSQLUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.PMRPRunCrush;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.InventoryDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.MaterialDetailTableDefine;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

public abstract class PMRPRunner {
    public static String MRP_MUTEX = "MRP_MUTEX";
    protected Context ctx;
    protected PMRPCalcParam runParam;

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    public PMRPRunner(Context ctx) {
        this.ctx = ctx;
    }

    public void run(PMRPRunLogInfo logInfo) throws BOSException, PMRPException {
        long startTime = System.currentTimeMillis();
        this.runParam = this.initCalcParam();
        this.runParam.setRunLog(logInfo);
        this.setisPMRPTraceSQL(logInfo);
        try {
            this.beforeMRP();
            List<PMRPStep> stepList = this.getStepList();
            int i = 0;
            while (i < stepList.size()) {
                PMRPStep step = stepList.get(i);
                if (step.isLogRequired()) {
                    step.createLogInfo(this.runParam, null, ++i);
                }
                step.execute(this.runParam);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PMRPRunCrush crush = new PMRPRunCrush(e);
            crush.execute(this.runParam);
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof PMRPException) {
                throw (PMRPException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            this.afterMRP();
            System.out.println("-----------------MRP4Global time cost:" + (System.currentTimeMillis() - startTime) + "-----------------");
        }
    }

    protected void beforeMRP() throws BOSException, PMRPException {
        boolean isLocked;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        String runPlaDefineID = "";
        if (this.runParam.getRunLog() != null) {
            runPlaDefineID = this.runParam.getRunLog().getComputeType() != null && this.runParam.getRunLog().getComputeType().equals((Object)ComputeTypeEnum.DeliveryPlan) ? this.runParam.getRunLog().getDpOperationScheme().getId().toString() : this.runParam.getRunLog().getPlanDefined().getId().toString();
        }
        if (!(isLocked = mutex.requestObjIDForUpdate(runPlaDefineID, this.ctx.getUserName(), this.ctx.getAIS(), this.getResourceString(this.ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0096")))) {
            throw new PMRPException(PMRPException.LOCK_ERROR);
        }
        String sql = "";
        sql = this.runParam.getRunLog().getComputeType() != null && this.runParam.getRunLog().getComputeType().equals((Object)ComputeTypeEnum.DeliveryPlan) ? "SELECT top 1 FStatus FROM T_MRP_PMRPRunLog WHERE FStatus = 40 AND FdpOperationSchemeID = ? AND FID <> ? ORDER BY FCreateTime DESC" : "SELECT top 1 FStatus FROM T_MRP_PMRPRunLog WHERE FStatus = 40 AND FPlanDefinedID = ? AND FID <> ? ORDER BY FCreateTime DESC";
        IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql, (Object[])new Object[]{runPlaDefineID, this.runParam.getRunLog().getId().toString()});
        try {
            if (rs.next()) {
                throw new PMRPException(PMRPException.LOCK_ERROR);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public void shutDownNow() {
        if (this.runParam.getService() != null && !this.runParam.getService().isShutdown()) {
            this.runParam.getService().shutdownNow();
            try {
                new PMRPRunCrush((Exception)((Object)new PMRPException(new NumericExceptionSubItem(PMRPStepStatusEnum.MANU_STOP.getName(), PMRPStepStatusEnum.MANU_STOP.getName())))).execute(this.runParam);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void afterMRP() throws BOSException, PMRPException {
        if (this.runParam.getService() != null && !this.runParam.getService().isShutdown()) {
            this.runParam.getService().shutdown();
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        String runPlaDefineID = this.runParam.getRunLog().getComputeType() != null && this.runParam.getRunLog().getComputeType().equals((Object)ComputeTypeEnum.DeliveryPlan) ? this.runParam.getRunLog().getDpOperationScheme().getId().toString() : this.runParam.getRunLog().getPlanDefined().getId().toString();
        mutex.releaseObjIDForUpdate(runPlaDefineID);
        String tableName0 = this.runParam.getTableManager().getTempTableDefine(MaterialDetailTableDefine.class).getTableName();
        String tableName1 = this.runParam.getTableManager().getTempTableDefine(FactoryCalendarTableDefine.class).getTableName();
        String tableName2 = this.runParam.getTableManager().getTempTableDefine(InventoryDetailTableDefine.class).getTableName();
        PMRPSQLUtil.dropTables(this.runParam.getEasCtx(), tableName0, tableName1, tableName2);
    }

    protected PMRPCalcParam initCalcParam() {
        return new PMRPCalcParam(this.ctx);
    }

    protected abstract List<PMRPStep> getStepList() throws EASBizException, BOSException;

    protected void setisPMRPTraceSQL(PMRPRunLogInfo logInfo) {
        if (logInfo.get("isPMRPTraceSQL") != null && ((Boolean)logInfo.get("isPMRPTraceSQL")).booleanValue()) {
            this.runParam.setPMRPTraceSQL(true);
        } else {
            this.runParam.setPMRPTraceSQL(false);
        }
    }
}

