/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.industry.emm.project.biz.basedata.BOMTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ILLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ProConfigBOMLLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ProcessBomLLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.IndependentRequireTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.ProcessBOMExpandTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PMRPCalcLowLevelCode
extends PMRPStep
implements IConfigurableStep {
    private ILLCComputer computer;

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "CALC_LLC");
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        List<String> ids;
        PlanDefinedInfo pd = runParam.getRunLog().getPlanDefined();
        BOMTypeEnum bomType = pd.getBomType();
        if (BOMTypeEnum.ProcessBOM.equals((Object)bomType)) {
            this.computer = new ProcessBomLLCComputer();
        } else if (BOMTypeEnum.MfgBOM.equals((Object)bomType)) {
            this.computer = new ProConfigBOMLLCComputer();
        } else {
            throw new PMRPException(PMRPException.UNKNOWN_BOM_TYPE);
        }
        try {
            ids = this.getProjectIDs(runParam);
        }
        catch (SQLException e) {
            throw new PMRPException(PMRPException.LLC_NULL_PROJECT, e);
        }
        IPMRPTableDefine table = runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class).createTable(runParam.getEasCtx());
        for (String projectID : ids) {
            this.computer.calcLLC(runParam, projectID, null, null).reset(runParam);
        }
        if (this.computer instanceof ProcessBomLLCComputer) {
            this.computer.calcLLC(runParam, null, null, null).reset(runParam);
        } else if (ids.isEmpty()) {
            this.computer.calcLLC(runParam, null, null, null).reset(runParam);
        }
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)("SELECT COUNT(1) FROM " + table.getTableName()));
        try {
            if (rs.next()) {
                this.dataAmount = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new PMRPException(PMRPException.NO_LOWEST_CODE, e);
        }
        try {
            this.checkIndependentMaterialBOM(runParam);
            this.updateLowCode();
            PMRPCalcLowLevelCode.checkMaterialPlan(runParam);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw new PMRPException(PMRPException.SQL_EXEX_ERROR, e1);
        }
        return null;
    }

    private List<String> getProjectIDs(PMRPCalcParam runParam) throws BOSException, SQLException, PMRPException {
        ArrayList<String> ids = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT FPROJECTID FROM ");
        sb.append(runParam.getTableManager().getTempTableDefine(CalcDetailTableDefine.class).getTableName());
        sb.append(" WHERE FPROJECTID IS NOT NULL");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sb.toString());
        while (rs.next()) {
            ids.add(rs.getString("FPROJECTID"));
        }
        return ids;
    }

    private void checkIndependentMaterialBOM(PMRPCalcParam runParam) throws BOSException, SQLException, PMRPException {
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        StringBuilder sb = new StringBuilder();
        StringBuilder errorstr = new StringBuilder();
        if (pdInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM)) {
            sb.append("SELECT DISTINCT m.fnumber as fmaterialNumber  ");
            sb.append(",m.fname_l2 as fmaterialname  ");
            sb.append(",s.fname_l2 as forgUnitName  ");
            sb.append(",pj.fname_l2 as fprojectname  ");
            sb.append(",t1.FSourceID");
            sb.append(",t1.FSourceEntryID");
            sb.append(",t1.FBosType");
            sb.append(",t1.FSrcBillEntrySeq");
            sb.append(",t1.FSrcBillNumber");
            sb.append(",ms.FNumber as MSNumber");
            sb.append(",ms.FID as MSID");
            sb.append(",t.fnumber as ftrackNumber FROM ");
            sb.append(runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName());
            sb.append(" t1 ");
            sb.append(" INNER JOIN T_BD_MaterialPlan mp on mp.FMaterialID = t1.FMaterialID AND mp.FOrgUnit = t1.FOrgUnitID");
            sb.append(" INNER JOIN T_BD_ManufactureStrategy ms on mp.FManufactureStrategyID = ms.FID");
            sb.append(" left outer join t_bd_material m on m.fid = t1.FMaterialID");
            sb.append(" left outer join t_mm_project pj on pj.fid = t1.FProjectID");
            sb.append(" left outer join t_mm_trackNumber t on t.fid = t1.FTrackNumberID");
            sb.append(" left outer join t_org_storage s on s.fid = t1.FOrgUnitID");
            sb.append(" WHERE t1.FMaterialAttr in (10020,10030)");
            sb.append(" And t1.FBosType in ( 'EF558EA7','35F08CE1','CFFE2CB6' )");
            sb.append(" and Not Exists( Select 1 from ct_zjb_processbombill bom \r\n");
            sb.append(" left outer join t_mm_tracknumber bt on bt.fid = bom.cfbegincarnoid \r\n");
            sb.append(" left outer join t_mm_tracknumber et on et.fid = bom.cfendcarnoid \r\n");
            sb.append(" where bom.cfparentid = t1.FMaterialID \r\n");
            sb.append(" And bom.cfstorageorgunitid = t1.FOrgUnitID \r\n");
            sb.append(" and (bom.cfprojectid = t1.FProjectID or bom.cfprojectid is null) \r\n");
            sb.append(" and (bt.fnumber <= t1.FTrackNumber or bom.cfbegincarnoid is null)  \r\n");
            sb.append(" and (et.fnumber >= t1.FTrackNumber or bom.cfendcarnoid is null) \r\n");
            sb.append(" and bom.cfstate = 4 \r\n");
            sb.append(" and bom.cfration > 0 \r\n");
            sb.append(" ) ");
        } else {
            sb.append(" SELECT * FROM (");
            sb.append(" SELECT DISTINCT m.fnumber as fmaterialNumber  ");
            sb.append(",m.fname_l2 as fmaterialname  ");
            sb.append(",s.fname_l2 as forgUnitName  ");
            sb.append(",pj.fname_l2 as fprojectname  ");
            sb.append(",t1.FSourceID");
            sb.append(",t1.FSourceEntryID");
            sb.append(",t1.FBosType");
            sb.append(",t1.FSrcBillEntrySeq");
            sb.append(",t1.FSrcBillNumber");
            sb.append(",t.fnumber as ftrackNumber");
            sb.append(",ms.FNumber as MSNumber");
            sb.append(",ms.FID as MSID");
            sb.append(" FROM ");
            sb.append(runParam.getTableManager().getTempTableDefine(IndependentRequireTableDefine.class).getTableName());
            sb.append(" t1 ");
            sb.append(" INNER JOIN T_BD_MaterialPlan mp on mp.FMaterialID = t1.FMaterialID AND mp.FOrgUnit = t1.FOrgUnitID");
            sb.append(" INNER JOIN T_BD_ManufactureStrategy ms on mp.FManufactureStrategyID = ms.FID");
            sb.append(" left outer join t_bd_material m on m.fid = t1.FMaterialID");
            sb.append(" left outer join t_mm_project pj on pj.fid = t1.FProjectID");
            sb.append(" left outer join t_mm_trackNumber t on t.fid = t1.FTrackNumberID");
            sb.append(" left outer join t_org_storage s on s.fid = t1.FOrgUnitID");
            sb.append(" WHERE t1.FMaterialAttr in (10020,10030)");
            sb.append(" And t1.FBosType in ( 'CFFE2CB6' )");
            sb.append(" and Not Exists( Select 1 from t_mm_bom h inner join t_mm_bomentry d on h.fid  = d.fparentid \r\n");
            sb.append(" left outer join t_mm_tracknumber bt on bt.fid = d.fbegincarnoid \r\n");
            sb.append(" left outer join t_mm_tracknumber et on et.fid = d.fendcarnoid \r\n");
            sb.append(" where h.fmaterialid = t1.FMaterialID \r\n");
            sb.append(" And h.fstorageorgunitid = t1.FOrgUnitID \r\n");
            sb.append(" and (h.fprojectid = t1.FProjectID or h.fprojectid is null) \r\n");
            sb.append(" and (bt.fnumber <= t1.FTrackNumber or d.fbegincarnoid is null)  \r\n");
            sb.append(" and (et.fnumber >= t1.FTrackNumber or d.fendcarnoid is null) \r\n");
            sb.append(" and h.fbasestatus = 4 \r\n");
            sb.append(" and d.fconsumefixqty > 0 \r\n");
            sb.append(" ) ");
            sb.append(") tmp ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sb.toString());
        while (rs.next()) {
            if (errorstr == null || errorstr.length() < 1) {
                errorstr.append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0119")).append(":\r\n");
            }
            errorstr.append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0106")).append(":[(" + rs.getString("fmaterialNumber") + ")" + rs.getString("fmaterialname") + "]");
            errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0120")).append(":[" + rs.getString("MSNumber") + "]");
            errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + rs.getString("forgUnitName") + "]");
            if (rs.getString("fprojectname") != null) {
                errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0107")).append("[" + rs.getString("fprojectname") + "]");
            }
            if (rs.getString("ftrackNumber") != null) {
                errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0108")).append("[" + rs.getString("ftrackNumber") + "]");
            }
            errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0121")).append("[");
            errorstr.append(rs.getString("FSrcBillNumber"));
            errorstr.append("]");
            errorstr.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0122")).append("[");
            errorstr.append(rs.getString("FSrcBillEntrySeq"));
            errorstr.append("],");
            errorstr.append(pdInfo.getBomType().equals((Object)BOMTypeEnum.ProcessBOM) ? PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0123") : ("NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(rs.getString("MSID")) ? PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0124") : PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0125")));
            errorstr.append("\r\n");
        }
        if (errorstr.length() > 0) {
            logger.info((Object)(" materialbom Data check,err result = " + errorstr));
            PMRPException exp = new PMRPException(new NumericExceptionSubItem("", errorstr.toString()));
            throw exp;
        }
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    protected void updateLowCode() throws BOSException, PMRPException {
        Context ctx = this.runParam.getEasCtx();
        PMRPRunTableManager manager = this.runParam.getTableManager();
        IPMRPTableDefine lldwm = this.runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
        String calcTable = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(calcTable).append(" t1 ").append(" set FLowsetCode = Isnull((select Max(lc.CFLowCode) from ").append(lldwm.getTableName()).append(" lc").append(" where lc.CFMaterialID = t1.Fmaterialid ").append(" and lc.CFMaterialATTR = t1.fmaterialattr").append(" and isnull(lc.CFProjectID,'*') = isnull(t1.fprojectid,'*')").append(" ),99) ").append(" where FLowsetCode = 99 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(calcTable).append(" t1 ").append(" set FLowsetCode = Isnull((select Max(lc.CFLowCode) from ").append(lldwm.getTableName()).append(" lc").append(" where lc.CFMaterialID = t1.Fmaterialid ").append(" and lc.CFMaterialATTR = t1.fmaterialattr").append(" and lc.CFProjectID is null ").append(" ),99) ").append(" where FBProjectID is null ").append("  And FLowsetCode = 99 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(calcTable).append(" t1 ").append(" set FLowsetCode = Isnull((select Max(lc.CFLowCode) from ").append(lldwm.getTableName()).append(" lc").append(" where lc.CFMaterialID = t1.Fmaterialid ").append(" and lc.CFMaterialATTR = t1.fmaterialattr").append(" ),99) ").append(" where FBProjectID is null ").append("  And FLowsetCode = 99 ");
        MRPUtil.executeUpdate((Context)ctx, (String)sql.toString());
    }

    private static void checkMaterialPlan(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlerrtext = new StringBuilder();
        sql.append("SELECT DISTINCT ");
        sql.append(" m.fnumber as fmaterialNumber");
        sql.append(" ,m.fname_l2 as fmaterialName");
        sql.append(" ,ms.fnumber as fStorageOrgUnitNumber");
        sql.append(" ,ms.fname_l2 as fStorageOrgUnitame");
        sql.append(" ,mp.fid as fmpid");
        sql.append(" ,mp.fstatus as fmpstatus");
        sql.append(" ,a.FMaterialAttribute as FMaterialAttr");
        sql.append(" FROM ");
        sql.append(runParam.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class).getTableName());
        sql.append(" a left outer join t_bd_material m on m.fid = a.FMaterialID ");
        sql.append(" left outer join t_org_storage ms on ms.fid = a.FSupplyStorageOrgUnitID ");
        sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = a.FMaterialID and mp.Forgunit = a.FSupplyStorageOrgUnitID ");
        sql.append(" where ( mp.fid is null or ");
        sql.append(" mp.fstatus <> 1 )");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString());
        logger.info((Object)(" materialPlan Data check,data rows = " + rs.size()));
        try {
            while (rs.next()) {
                String fmaterialNumber = rs.getString("fmaterialNumber");
                String fmaterialName = rs.getString("fmaterialName");
                String fStorageOrgUnitNumber = rs.getString("fStorageOrgUnitNumber");
                String fStorageOrgUnitame = rs.getString("fStorageOrgUnitame");
                String fmpid = rs.getString("fmpid");
                String fmpstatus = rs.getString("fmpstatus");
                if (sqlerrtext == null || sqlerrtext.length() < 1) {
                    sqlerrtext.append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                } else {
                    sqlerrtext.append("\r\n").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                }
                if (fmpid == null || "".equals(fmpid)) {
                    sqlerrtext.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                    sqlerrtext.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0100"));
                    continue;
                }
                if (fmpstatus != null && "1".equals(fmpstatus)) continue;
                sqlerrtext.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                sqlerrtext.append(",").append(PMRPCalcLowLevelCode.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0101"));
            }
            if (sqlerrtext != null && sqlerrtext.length() > 0) {
                logger.info((Object)(" materialPlan Data check,err result = " + sqlerrtext));
                PMRPException exp = new PMRPException(new NumericExceptionSubItem("", sqlerrtext.toString()));
                throw exp;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

