/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PSPGenPlanDatas
extends PMRPStep
implements IConfigurableStep {
    protected Map<String, Integer> leadMap = null;

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        this.deleteOldPspStockingDemand(runParam);
        this.insertPspStockingDemand(runParam);
        return null;
    }

    protected void deleteOldPspStockingDemand(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_PSP_PspStockingDemand where fpurorgid = ? ");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        sql.setLength(0);
        sql.append(" delete from T_PSP_PSPTOFBDETAIL where exists (select 1 from t_psp_stockingplan where ");
        sql.append(" FPurChaseOrgUnitID = ? ");
        sql.append(" and  CFStockingPlanType in ('10','20') And t_psp_stockingplan.fid = T_PSP_PSPTOFBDETAIL.fstockingplanID )");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        sql.setLength(0);
        sql.append(" delete from t_psp_stockingplandetail where FPurchaseOrgID = ? ");
        sql.append(" and  CFStockingPlanType in ('10','20')");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        sql.setLength(0);
        sql.append("delete from t_psp_stockingplan where FPurChaseOrgUnitID = ? ");
        sql.append(" and  CFStockingPlanType in ('10','20')");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        sql.setLength(0);
        sql.append("delete from t_psp_pspmiddle where FPurOrgID = ? ");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
    }

    protected void insertPspStockingDemand(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        PMRPRunTableManager manager = runParam.getTableManager();
        String calTableCalc = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        UserInfo userInfo = (UserInfo)runParam.getEasCtx().get((Object)"UserInfo");
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)runParam.getEasCtx()).getId().toString();
        sql.setLength(0);
        sql.append(" insert into T_PSP_PspStockingDemand   \r\n");
        sql.append(" (Fid,FProjectID,FMaterialID,FTrackNumberID,  FFinishTime,FCreatorID,  \r\n");
        sql.append(" FLastUpdateUserID,fcreatetime,fleadtime,fpurorgid,fdemandqty,fAllocateqty,fmaterialname,FMaterialModel,fmaterialUnit,  \r\n ");
        sql.append(" fproductorgunitid ,FsupplyStorageOrgUnitID,FControlUnitID ,fseq ,CFDemandTime,fsourcebillid,FIssolateRule,FpspRunLogID )    \r\n ");
        sql.append(" Select  \r\n ");
        sql.append(" newbosid('00CB57F2') As Fid  \r\n ");
        sql.append(" ,tb.FprojectID As FProjectID  \r\n ");
        sql.append(" ,tb.FMaterialID As FMaterialID  \r\n ");
        sql.append(" ,tb.FTrackNumberID As FTrackNumberID  \r\n ");
        sql.append(" ,tb.fbilldate As FFinishTime  \r\n ");
        sql.append(" ,'").append(userInfo.getId().toString()).append("' As FCreatorID  \r\n ");
        sql.append(" ,'").append(userInfo.getId().toString()).append("' As FLastUpdateUserID  \r\n ");
        sql.append(" ,now() As fcreatetime  \r\n ");
        sql.append(" ,tb.fbilldate As fleadtime  \r\n ");
        sql.append(" , isnull(tpe.fpurChaseOrgUnitID,'").append(runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()).append("') As fpurorgid \t\n ");
        sql.append(" , tb.fdependent As fdemandqty  \r\n ");
        sql.append(" , tb.fdependent As fAllocateqty  \r\n ");
        sql.append(" , tm.fname_l2 As fmaterialname  \t\n");
        sql.append(" , tm.fmodel As FMaterialModel \t\n");
        sql.append(" , tmu.fname_l2 As fmaterialUnit   \t\n");
        sql.append(" , tb.FOrgUnitID As fproductorgunitid \r\n ");
        sql.append(" , tb.fsupplyorgunitid As FsupplyStorageOrgUnitID  \r\n ");
        sql.append(" , '").append(cuID).append("' As FControlUnitID  \r\n ");
        sql.append(" , 0 As fseq  \r\n ");
        sql.append(" , tb.fbilldate As CFDemandTime  \r\n ");
        sql.append(" , null As fsourcebillid  \r\n ");
        sql.append(" , ISNULL(mp.FIsolatedRule,'NONE') As FIssolateRule  \r\n ");
        sql.append(" , '").append(runParam.getRunLog().getId()).append("' As FpspRunLogID  \r\n ");
        sql.append(" from ( ");
        sql.append(" select (case fbprojectid when '*' then null else fbprojectid end ) As FprojectID,\r\n ");
        sql.append(" FMaterialID, \r\n ");
        sql.append(" (case fbtrackid when '*' then null else fbtrackid end ) As FTrackNumberID, \r\n ");
        sql.append(" isnull(FRePlanDATE,fbilldate) As fbilldate, \r\n ");
        sql.append(" sum(abs(fdependent)) + sum(abs(findependent)) as fdependent, \r\n ");
        sql.append(" FOrgUnitID, \r\n ");
        sql.append(" fsupplyorgunitid \r\n ");
        sql.append(" from ").append(calTableCalc).append("  \r\n ");
        sql.append(" where FMaterialAttr in( 10040 ,10090)  and (FisZSPur is null  or FisZSPur = 0 )  \r\n ");
        sql.append("and  (abs(fdependent)+abs(findependent)) > 0");
        sql.append(" group by  fbprojectid,FMaterialID,fbtrackid,isnull(FRePlanDATE,fbilldate),FOrgUnitID,fsupplyorgunitid ) tb \r\n ");
        sql.append(" left join t_bd_material tm on tm.fid = tb.FMaterialID  \r\n ");
        sql.append(" left join t_bd_materialplan mp on mp.fmaterialid = tb.FMaterialID And mp.forgunit = tb.fsupplyorgunitid  \r\n ");
        sql.append(" left join t_bd_measureunit  tmu on tm.fbaseunit = tmu.fid  \r\n ");
        sql.append(" left join (Select CFProductOrgUnitID,Max(CFPurchaseOrgUnitI) As fpurChaseOrgUnitID  from CT_BAS_PurRDE where fparentid = '").append(runParam.getRunLog().getPlanDefined().getPurchaseRelation().getId().toString()).append("' Group by CFProductOrgUnitID) tpe on tb.FOrgUnitID = tpe.CFProductOrgUnitID  \t\n");
        this.dataAmount = MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sql.toString());
        this.leadMap = new HashMap<String, Integer>();
        sql.setLength(0);
        sql.append(" Select FFinishTime,fid,fproductorgunitid ,FMaterialID   \r\n");
        sql.append(" from T_PSP_PspStockingDemand   \r\n");
        sql.append(" where  fpurorgid = ? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        try {
            int leadTime = 0;
            sql.setLength(0);
            sql.append(" update T_PSP_PspStockingDemand set ");
            sql.append(" FFinishTime = ?,fleadtime = ? ");
            sql.append(" where fid = ? ");
            while (rs.next()) {
                leadTime = this.getLeadTime(runParam.getEasCtx(), rs.getString("FMaterialID"), rs.getString("fproductorgunitid"));
                Date newDate = DateUtil.addDay((Date)rs.getDate("FFinishTime"), (int)(leadTime * -1));
                Timestamp dateTime = new Timestamp(newDate.getTime());
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{dateTime, dateTime, rs.getString("fid")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        this.leadMap.clear();
    }

    protected int getLeadTime(Context ctx, String fmaterialid, String forgUnitID) throws BOSException, PMRPException, SQLException {
        String key = fmaterialid + forgUnitID;
        if (this.leadMap != null && this.leadMap.containsKey(key)) {
            return this.leadMap.get(key);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select top 1 FLeadTime from T_PSP_PspMaterialLeadTime pmlt where pmlt.FStorageOrgUnitID = ?  And pmlt.FStatus='10'  And (pmlt.FMaterialID = ? or pmlt.FMaterialID is null) order by pmlt.FMaterialID desc   ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{forgUnitID, fmaterialid});
        int FLeadTime = 0;
        if (rs.next()) {
            FLeadTime = rs.getInt("FLeadTime");
        }
        this.leadMap.put(key, FLeadTime);
        return FLeadTime;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_PSP_GENPLAN");
    }
}

