/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PSPMateInventory
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        List<String> materialIDList = this.getAllMaterialIDList(runParam);
        if (materialIDList == null || materialIDList.size() < 1) {
            return null;
        }
        int splitCount = 200;
        int times = materialIDList.size() / splitCount;
        if (materialIDList.size() % splitCount > 0) {
            ++times;
        }
        List<Object> subList = new ArrayList();
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)runParam.getService());
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? materialIDList.subList(splitCount * (i - 1), splitCount * i) : materialIDList.subList(splitCount * (i - 1), materialIDList.size());
            UpdateWorker worker = new UpdateWorker(runParam, subList);
            try {
                ecs.submit((Callable)worker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        try {
            for (int i = 1; i <= times; ++i) {
                this.dataAmount += ((Integer)ecs.take().get()).intValue();
                if (this.logInfo == null) continue;
                sql.setLength(0);
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        return null;
    }

    public static Map<String, BigDecimal> getInvDatasMap(PMRPCalcParam runParam, String materialID, String supplyOrgUnitID, String fproductionOrgUnitID, String fprojectID, String ftrackNumberID) throws BOSException, PMRPException {
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        SupplyRelationshipDefinitionInfo info = pdInfo.getSupplyRelation();
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select  ttv.fid , ttv.Fcurstoreqty as qty,s.Cfprioritylevel \n");
        sql.append(" from T_IM_Inventory ttv  \n");
        sql.append(" inner join CT_BAS_SupplyRDE s on s.Cfproductorgunitid = ? And s.Cfsupplyorgunitid = ttv.fstorageorgunitid   \n");
        sql.append(" and ttv.fwarehouseid = Isnull(s.Cfwarehouseid,ttv.fwarehouseid) ");
        sql.append(" and Isnull(ttv.flocationid,'EgkAAABc3XMgX/hq') = Isnull(s.Cflocationid,Isnull(ttv.flocationid,'EgkAAABc3XMgX/hq')) ");
        paramList.add(fproductionOrgUnitID);
        sql.append(" where ttv.fmaterialid = ? ");
        paramList.add(materialID);
        sql.append(" And ttv.fstorageorgunitid = ? ");
        paramList.add(supplyOrgUnitID);
        if (fprojectID != null && !"".equals(fprojectID)) {
            sql.append(" and ttv.fprojectid = ? ");
            paramList.add(fprojectID);
        }
        if (ftrackNumberID != null && !"".equals(ftrackNumberID)) {
            sql.append(" and ttv.fprojectid = ? ");
            paramList.add(ftrackNumberID);
        }
        sql.append(" And ttv.FBaseQty > 0 ");
        if (info.getWsRange() == 1) {
            sql.append(" and ttv.Fwarehouseid in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = ? ) ");
            paramList.add(info.getId().toString());
        } else if (info.getWsRange() == 2) {
            sql.append(" and ttv.Fwarehouseid not in(select Fwarehouseid from T_BAS_SupplyRDWE where fparentid = ? ) ");
            paramList.add(info.getId().toString());
        }
        sql.append(" order by s.Cfprioritylevel desc  \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        try {
            while (irs.next()) {
                String fid = irs.getString("fid");
                BigDecimal qty = irs.getBigDecimal("qty");
                if (returnMap != null && returnMap.containsKey(fid)) continue;
                returnMap.put(fid, qty);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    protected List<String> getAllMaterialIDList(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fmaterialid  \n");
        sql.append(" from t_psp_pspstockingdemand   \n");
        sql.append(" where fpurorgid = ? \n");
        sql.append(" group by fmaterialid   \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        ArrayList<String> aList = new ArrayList<String>();
        try {
            while (irs.next()) {
                aList.add(irs.getString("fmaterialid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return aList;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_PSP_MATEINV");
    }

    private static class UpdateWorker
    implements Callable {
        private List<String> materialIDList;
        private PMRPCalcParam runParam;
        private int dataAmount;

        public UpdateWorker(PMRPCalcParam runParam, List<String> materialidList) {
            this.runParam = runParam;
            this.materialIDList = materialidList;
        }

        public Object call() throws Exception {
            if (this.materialIDList.size() > 0) {
                SupplyRelationshipDefinitionInfo suprInfo = this.runParam.getRunLog().getPlanDefined().getSupplyRelation();
                SupplyRelationshipDefinitionEntryCollection supeCol = suprInfo.getEntry();
                StringBuffer sql = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                sql.setLength(0);
                sql.append(" select a.fid,a.fallocateqty,a.fproductorgunitid,a.FMaterialID,a.fsupplystorageorgunitid,a.fprojectid,a.ftracknumberid \n");
                sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule \n");
                sql.append(" from t_psp_pspstockingdemand a \n");
                sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = a.FMaterialID and mp.forgunit = a.fsupplystorageorgunitid \n");
                sql.append(" where ( \n");
                for (int i = 0; i < this.materialIDList.size(); ++i) {
                    sql.append(" a.FMaterialID = ? ");
                    if (i == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" ) and  a.fpurorgid = ?  \n");
                sql.append(" and a.fallocateqty > 0");
                sql.append(" order by a.FMaterialID,a.fsupplystorageorgunitid,a.fprojectid,a.ftracknumberid,a.fleadtime \n");
                paramList.addAll(this.materialIDList);
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                HashMap<String, BigDecimal> invUsedCacheMap = new HashMap<String, BigDecimal>();
                while (rs.next()) {
                    BigDecimal demandQty;
                    String fproductorgunitid = rs.getString("fproductorgunitid");
                    String fsupplystorageorgunitid = rs.getString("fsupplystorageorgunitid");
                    String fprojectid = rs.getString("fprojectid") == null ? "" : rs.getString("fprojectid");
                    String ftracknumberid = rs.getString("ftracknumberid") == null ? "" : rs.getString("ftracknumberid");
                    String FMaterialID = rs.getString("FMaterialID");
                    String fmanufacturestrategyid = rs.getString("fmanufacturestrategyid");
                    String fisolatedrule = rs.getString("fisolatedrule");
                    BigDecimal initDemandQty = demandQty = rs.getBigDecimal("fallocateqty");
                    if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                        if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                            ftracknumberid = "";
                        }
                    } else {
                        fprojectid = "";
                        ftracknumberid = "";
                    }
                    BigDecimal invQty = null;
                    BigDecimal invUsedQty = null;
                    BigDecimal updateInvqty = BigDecimal.ZERO;
                    Map<String, BigDecimal> invMap = PSPMateInventory.getInvDatasMap(this.runParam, FMaterialID, fsupplystorageorgunitid, fproductorgunitid, fprojectid, ftracknumberid);
                    if (invMap != null && invMap.size() > 0) {
                        Set<String> keys = invMap.keySet();
                        for (String key : keys) {
                            invQty = invMap.get(key);
                            if (invQty.compareTo(BigDecimal.ZERO) <= 0 || demandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                            invUsedQty = BigDecimal.ZERO;
                            if (invUsedCacheMap != null && invUsedCacheMap.containsKey(key)) {
                                invUsedQty = (BigDecimal)invUsedCacheMap.get(key);
                                invQty = invQty.subtract(invUsedQty);
                            }
                            if (invQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                            if (invQty.compareTo(demandQty) >= 0) {
                                updateInvqty = updateInvqty.add(demandQty);
                                invUsedQty = invUsedQty.add(demandQty);
                                demandQty = BigDecimal.ZERO;
                            } else {
                                updateInvqty = updateInvqty.add(invQty);
                                invUsedQty = invUsedQty.add(invQty);
                                demandQty = demandQty.subtract(invQty);
                            }
                            invUsedCacheMap.put(key, invUsedQty);
                        }
                    }
                    if (updateInvqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    sql.setLength(0);
                    sql.append(" update t_psp_pspstockingdemand \n");
                    sql.append(" set fallocateqty = ? \n");
                    sql.append(" , fallocatedqty = ?  \n");
                    sql.append(" , funallocatedqty = ?  \n");
                    sql.append(" where fid = ?  \n");
                    DbUtil.execute((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{initDemandQty.subtract(updateInvqty), updateInvqty, initDemandQty.subtract(updateInvqty), rs.getString("fid")});
                    ++this.dataAmount;
                }
                invUsedCacheMap.clear();
            }
            return this.dataAmount;
        }
    }
}

