/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;

public class PSPRefreshBackFS
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        int i;
        List<String> materialIDList = this.getAllMaterialIDList(runParam);
        if (materialIDList == null || materialIDList.size() < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ct_psp_stockingplanfbdetail set cfbasestatus = '20', cfuncloseqty = 0 \n");
        sql.append(" where cfspqty = cffbqty \n");
        sql.append(" and cfspqty = cfdeliveredqty \n");
        sql.append(" and cfpurchaseorguniti = ? \n");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        sql.setLength(0);
        sql.append(" update ct_psp_stockingplanfbdetail set cfuncloseqty = isnull(cffbqty,0) - isnull(cfdeliveredqty,0) \n");
        sql.append(" where cfpurchaseorguniti = ?  \n");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        int splitCount = 200;
        int times = materialIDList.size() / splitCount;
        if (materialIDList.size() % splitCount > 0) {
            ++times;
        }
        List<Object> subList = new ArrayList();
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)runParam.getService());
        for (i = 1; i <= times; ++i) {
            subList = i < times ? materialIDList.subList(splitCount * (i - 1), splitCount * i) : materialIDList.subList(splitCount * (i - 1), materialIDList.size());
            UpdateWorker worker = new UpdateWorker(runParam, subList);
            try {
                ecs.submit((Callable)worker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        try {
            for (i = 1; i <= times; ++i) {
                this.dataAmount += ((Integer)ecs.take().get()).intValue();
                if (this.logInfo == null) continue;
                sql.setLength(0);
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        return null;
    }

    protected static void insetNewRelation(Context ctx, BigDecimal updateQty, java.util.Date spDate, java.util.Date fbDate, String spID, String fbID) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        sql.append(" insert into t_psp_psptofbdetail (fid,fstockingplanid ,fstockingplanfbdetailid,fusefbqty,fdemanddate,fsupplydate)  \n");
        sql.append(" values (?,? ,?,?,?,?)  \n");
        paramsList.add(new Object[]{BOSUuid.create((String)"88888888").toString(), spID, fbID, updateQty, spDate, fbDate});
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    protected static String getKey(String purchaseorgunitid, String supplyorgunitid, String supplierid, String materialid, String projectid, String tracknumberid) {
        String returValue = "";
        returValue = returValue + (purchaseorgunitid == null ? "" : purchaseorgunitid);
        returValue = returValue + (supplyorgunitid == null ? "" : supplyorgunitid);
        returValue = returValue + (supplierid == null ? "" : supplierid);
        returValue = returValue + (materialid == null ? "" : materialid);
        returValue = returValue + (projectid == null ? "" : projectid);
        returValue = returValue + (tracknumberid == null ? "" : tracknumberid);
        return returValue;
    }

    protected static java.util.Date getZERO(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected List<String> getAllMaterialIDList(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select CFMaterialID As fmaterialid  \n");
        sql.append(" from CT_PSP_StockingPlanFBdetail   \n");
        sql.append(" where CFPurchaseOrgUnitI = ? And CFMaterialID is not null \n");
        sql.append(" group by CFMaterialID \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        ArrayList<String> aList = new ArrayList<String>();
        try {
            while (irs.next()) {
                aList.add(irs.getString("fmaterialid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return aList;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_PSP_UPDATEBACKFS");
    }

    private static class UpdateWorker
    implements Callable {
        private List<String> materialIDList;
        private PMRPCalcParam runParam;
        private int dataAmount;

        public UpdateWorker(PMRPCalcParam runParam, List<String> materialidList) {
            this.runParam = runParam;
            this.materialIDList = materialidList;
        }

        public Object call() throws Exception {
            if (this.materialIDList.size() > 0) {
                int i;
                ArrayList<String> paramList = new ArrayList<String>();
                StringBuffer sql = new StringBuffer();
                IRowSet rs = null;
                String key = null;
                String fid = null;
                BigDecimal qty = null;
                Date fdate = null;
                String purchaseorgunitid = null;
                String materialid = null;
                String projectid = null;
                String tracknumberid = null;
                String supplierid = null;
                String supplyorgunitid = null;
                sql.setLength(0);
                sql.append(" select  psp.fid As fid  \n");
                sql.append(" , psp.fqty  as qty  \n");
                sql.append(" ,psp.frequirementdate  as fdate \n");
                sql.append(" ,psp.fpurchaseorgunitid as purchaseorgunitid \n");
                sql.append(" ,psp.fmaterialid as materialid \n");
                sql.append(" ,psp.fprojectid  as projectid \n");
                sql.append(" ,psp.ftracenoid as tracknumberid \n");
                sql.append(" ,psp.fsupplierid   as supplierid \n");
                sql.append(" ,psp.fsupplystorageOrgunitid  as supplyorgunitid \n");
                sql.append("  from t_psp_stockingplan psp  \n");
                sql.append(" where  psp.fpurchaseorgunitid = ?    \n");
                sql.append(" and  ( ");
                for (int i2 = 0; i2 < this.materialIDList.size(); ++i2) {
                    sql.append(" psp.fmaterialid = ? ");
                    if (i2 == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" )  ");
                sql.append("  order by psp.frequirementdate");
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                paramList.addAll(this.materialIDList);
                rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                List spMapList = null;
                HashMap spMap = new HashMap();
                while (rs.next()) {
                    fid = rs.getString("fid");
                    qty = rs.getBigDecimal("qty");
                    fdate = rs.getDate("fdate");
                    purchaseorgunitid = rs.getString("purchaseorgunitid");
                    materialid = rs.getString("materialid");
                    projectid = rs.getString("projectid");
                    tracknumberid = rs.getString("tracknumberid");
                    supplierid = rs.getString("supplierid");
                    supplyorgunitid = rs.getString("supplyorgunitid");
                    key = PSPRefreshBackFS.getKey(purchaseorgunitid, supplyorgunitid, supplierid, materialid, projectid, tracknumberid);
                    spMapList = spMap.containsKey(key) ? (List)spMap.get(key) : new ArrayList();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("fid", fid);
                    dataMap.put("qty", qty);
                    dataMap.put("fdate", fdate);
                    spMapList.add(dataMap);
                    spMap.put(key, spMapList);
                }
                BigDecimal updateQty = null;
                sql.setLength(0);
                sql.append(" select  SFB.fid As fid  \n");
                sql.append(" , isnull(SFB.cfuncloseqty,0)  as qty  \n");
                sql.append(" ,SFB.CFSupplierDate  as fdate \n");
                sql.append(" ,SFB.CFPurchaseOrgUnitI as purchaseorgunitid \n");
                sql.append(" ,SFB.CFMaterialID as materialid \n");
                sql.append(" ,SFB.CFProjectID  as projectid \n");
                sql.append(" ,SFB.CFTrackNumberID as tracknumberid \n");
                sql.append(" ,SFB.CFSupplierID   as supplierid \n");
                sql.append(" ,SFB.CFSupplyStorageOrg  as supplyorgunitid \n");
                sql.append(" from CT_PSP_StockingPlanFBdetail SFB    \n");
                sql.append(" where  SFB.CFBaseStatus = '10'    \n");
                sql.append(" And SFB.CFPurchaseOrgUnitI = ?    \n");
                sql.append(" and  ( ");
                for (i = 0; i < this.materialIDList.size(); ++i) {
                    sql.append(" SFB.CFMaterialID = ? ");
                    if (i == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" )  ");
                sql.append(" And SFB.cfuncloseqty > 0   \n");
                sql.append(" order by SFB.CFSupplierDate    \n");
                paramList = new ArrayList();
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                paramList.addAll(this.materialIDList);
                rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                this.dataAmount = rs.size();
                while (rs.next()) {
                    fid = rs.getString("fid");
                    qty = rs.getBigDecimal("qty");
                    fdate = rs.getDate("fdate");
                    purchaseorgunitid = rs.getString("purchaseorgunitid");
                    materialid = rs.getString("materialid");
                    projectid = rs.getString("projectid");
                    tracknumberid = rs.getString("tracknumberid");
                    supplierid = rs.getString("supplierid");
                    supplyorgunitid = rs.getString("supplyorgunitid");
                    key = PSPRefreshBackFS.getKey(purchaseorgunitid, supplyorgunitid, supplierid, materialid, projectid, tracknumberid);
                    if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    spMapList = null;
                    spMapList = (List)spMap.get(key);
                    if (spMapList == null || spMapList.size() <= 0) continue;
                    for (i = 0; i < spMapList.size(); ++i) {
                        Map dataMap = (Map)spMapList.get(i);
                        String fspid = (String)dataMap.get("fid");
                        BigDecimal fspQty = new BigDecimal(dataMap.get("qty").toString());
                        java.util.Date fspDate = (java.util.Date)dataMap.get("fdate");
                        if (!DateUtils.isSameDay((java.util.Date)fspDate, (java.util.Date)fdate) && !PSPRefreshBackFS.getZERO(fspDate).after(PSPRefreshBackFS.getZERO(fdate)) || fspQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (fspQty.compareTo(qty) >= 0) {
                            updateQty = qty;
                            qty = BigDecimal.ZERO;
                            fspQty = fspQty.subtract(qty);
                        } else {
                            updateQty = fspQty;
                            qty = qty.subtract(fspQty);
                            fspQty = BigDecimal.ZERO;
                        }
                        dataMap.put("qty", fspQty);
                        if (updateQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        PSPRefreshBackFS.insetNewRelation(this.runParam.getEasCtx(), updateQty, fspDate, fdate, fspid, fid);
                    }
                }
            }
            return this.dataAmount;
        }
    }
}

