/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ILLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCBillTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCEntryTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCExpandTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;

public abstract class AbstractBomLLCComputer
implements ILLCComputer {
    private IPMRPTableDefine llcTbl;
    private IPMRPTableDefine bomTbl;
    private IPMRPTableDefine bomEntryTbl;

    @Override
    public ILLCComputer calcLLC(PMRPCalcParam runParam, String fprojectID, String ftopMaterialid, String ftrackNumberID) throws PMRPException, BOSException {
        Context ctx = runParam.getEasCtx();
        this.llcTbl = runParam.getTableManager().getTempTableDefine(BOMLLCExpandTableDefine.class);
        if (this.llcTbl.getTableName() == null) {
            this.llcTbl.createTable(ctx);
        }
        this.bomTbl = runParam.getTableManager().getTempTableDefine(BOMLLCBillTableDefine.class);
        if (this.bomTbl.getTableName() == null) {
            this.bomTbl.createTable(ctx);
        }
        this.bomEntryTbl = runParam.getTableManager().getTempTableDefine(BOMLLCEntryTableDefine.class);
        if (this.bomEntryTbl.getTableName() == null) {
            this.bomEntryTbl.createTable(ctx);
        }
        this.insertTmpDatas(runParam, fprojectID);
        this.calculate(ctx);
        this.saveLLC(runParam, fprojectID);
        return this;
    }

    @Override
    public void reset(PMRPCalcParam runParam) throws BOSException, PMRPException {
        String tbl = this.llcTbl.getTableName();
        DbUtil.execute((Context)runParam.getEasCtx(), (String)("DELETE " + tbl));
        tbl = this.bomTbl.getTableName();
        DbUtil.execute((Context)runParam.getEasCtx(), (String)("DELETE " + tbl));
        tbl = this.bomEntryTbl.getTableName();
        DbUtil.execute((Context)runParam.getEasCtx(), (String)("DELETE " + tbl));
    }

    private void insertTmpDatas(PMRPCalcParam runParam, String fprojectID) throws BOSException, PMRPException {
        StringBuffer inserBomTable = new StringBuffer();
        StringBuffer insertBomEntry = new StringBuffer();
        inserBomTable.append("insert into ").append(this.bomTbl.getTableName());
        inserBomTable.append(" (").append(this.bomTbl.getTableCols()).append(") ");
        inserBomTable.append(" ( select bom.FID, bom.FNumber, bom.FBaseStatus,");
        inserBomTable.append(" bom.FBomType, bom.FUsageType, bom.FMaterialID");
        inserBomTable.append(", '-1'");
        inserBomTable.append(" from t_mm_bom as bom ");
        inserBomTable.append(" where bom.FProjectID = '" + fprojectID + "' ");
        inserBomTable.append(" and bom.FUsageType= ").append(10);
        inserBomTable.append(" and bom.FBaseStatus= ").append(4);
        inserBomTable.append(")");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)inserBomTable.toString());
        insertBomEntry.append("insert into ").append(this.bomEntryTbl.getTableName());
        insertBomEntry.append(" (").append(this.bomEntryTbl.getTableCols()).append(") ");
        insertBomEntry.append(" ( select entry.FID, entry.FMaterialID, entry.FParentID,  0");
        insertBomEntry.append(", '-1'");
        insertBomEntry.append(" from t_mm_bomentry as entry");
        insertBomEntry.append(" inner join t_mm_bom as bom on bom.fid=entry.FParentID");
        insertBomEntry.append(" where bom.FProjectID = '");
        insertBomEntry.append(fprojectID).append("'");
        insertBomEntry.append(" and bom.FUsageType= ").append(10);
        insertBomEntry.append(" and bom.FBaseStatus= ").append(4);
        insertBomEntry.append(" ) ");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)insertBomEntry.toString());
    }

    private void calculate(Context ctx) throws BOSException, PMRPException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.setLength(0);
        sqlBuf.append("INSERT INTO ");
        sqlBuf.append(this.llcTbl.getTableName());
        sqlBuf.append("( FLevel,");
        sqlBuf.append(" FMaterialID, FMaterialAttribute )");
        sqlBuf.append(" SELECT DISTINCT 0,bom.FMaterialID,FMaterialAttribute ");
        sqlBuf.append(" FROM ").append(this.bomTbl.getTableName()).append(" as bom ");
        int count = SQLUtils.execute((Context)ctx, (String)sqlBuf.toString());
        sqlBuf.setLength(0);
        sqlBuf.append("INSERT INTO ");
        sqlBuf.append(this.llcTbl.getTableName());
        sqlBuf.append("( FLevel,");
        sqlBuf.append(" FMaterialID, FMaterialAttribute)");
        sqlBuf.append(" SELECT DISTINCT 999, entry.FMaterialID, entry.FMaterialAttribute ");
        sqlBuf.append(" FROM ").append(this.bomEntryTbl.getTableName()).append(" as entry ");
        sqlBuf.append(" left join ").append(this.llcTbl.getTableName()).append(" as bom ");
        sqlBuf.append(" on bom.FMaterialID = entry.fmaterialid ");
        sqlBuf.append(" where bom.fmaterialID is null ");
        count = SQLUtils.execute((Context)ctx, (String)sqlBuf.toString());
        for (int i = 0; count > 0 && i <= Constants.MAX_BOM_LEVEL; ++i) {
            if (i > Constants.MAX_BOM_LEVEL) {
                throw new PMRPException(PMRPException.LLC_LEVEL_OVERFLOW);
            }
            sqlBuf.setLength(0);
            sqlBuf.append(" update ");
            sqlBuf.append(this.llcTbl.getTableName());
            sqlBuf.append(" set FLevel = ").append(i + 1);
            sqlBuf.append(" where  fmaterialid in (");
            sqlBuf.append(" select c.fmaterialid from  ").append(this.llcTbl.getTableName()).append(" as a ");
            sqlBuf.append(" inner join ").append(this.bomTbl.getTableName()).append(" as b ");
            sqlBuf.append(" on a.fmaterialid = b.fmaterialid ");
            sqlBuf.append(" inner join ").append(this.bomEntryTbl.getTableName()).append(" as c ");
            sqlBuf.append(" on b.fid = c.fparentid ");
            sqlBuf.append(" where a.FLevel = ").append(i);
            sqlBuf.append(" )");
            count = SQLUtils.execute((Context)ctx, (String)sqlBuf.toString());
        }
    }

    protected void saveLLC(PMRPCalcParam runParam, String fprojectID) throws PMRPException, BOSException {
        IPMRPTableDefine table = runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
        if (table.getTableName() == null) {
            table.createTable(runParam.getEasCtx());
        }
        UserInfo curUserInfo = (UserInfo)runParam.getEasCtx().get((Object)"UserInfo");
        String fcuid = "";
        fcuid = curUserInfo.getCU() != null ? curUserInfo.getCU().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
        StringBuilder sql = new StringBuilder();
        sql.append("  /*dialect*/  \n");
        sql.append(" Insert Into ").append(table.getTableName()).append(" A \r\n");
        sql.append(" (");
        sql.append(table.getTableCols());
        sql.append(" ) \r\n");
        sql.append(" Select newbosid('").append(Constants.BosType.MRP_TMP_LLC).append("'),'");
        sql.append(curUserInfo.getId());
        sql.append("',sysdate,'");
        sql.append(fcuid);
        sql.append("','").append(fcuid).append("','").append(fprojectID).append("',  \r\n");
        sql.append(" temp.FMaterialID,temp.FLevel,temp.FMaterialAttribute From  \r\n");
        sql.append(" (Select a.FMaterialID,a.FMaterialAttribute,Max(a.FLevel) as FLevel  From ");
        sql.append(this.llcTbl.getTableName());
        sql.append(" a  group by a.FMaterialID,a.FMaterialAttribute ) temp \r\n");
        DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString());
    }

    protected abstract BOMTypeEnum getBOMType();
}

