/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.AbstractBomLLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ILLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.ProcessBOMExpandTableDefine;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ProConfigBOMLLCComputer
extends AbstractBomLLCComputer {
    @Override
    public final ILLCComputer calcLLC(PMRPCalcParam runParam, String FProjectID, String ftopMaterialid, String ftrackNumberID) throws PMRPException, BOSException {
        if (this.calc(runParam, FProjectID, ftopMaterialid, ftrackNumberID)) {
            this.saveLLC(runParam, FProjectID);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calc(PMRPCalcParam runParam, String fprojectID, String ftopMaterialid, String ftrackNumberID) throws PMRPException, BOSException {
        StringBuffer sql = new StringBuffer();
        TrackNumberInfo trackNumberInfo = null;
        if (ftrackNumberID != null && !"".equals(ftrackNumberID) && !"NOTExpand".equals(ftrackNumberID)) {
            try {
                trackNumberInfo = TrackNumberFactory.getLocalInstance((Context)runParam.getEasCtx()).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(ftrackNumberID));
            }
            catch (EASBizException e) {
                throw new PMRPException(PMRPException.LLC_WRONG_TRACKNUMBER, e);
            }
        }
        ArrayList<String> ProjectIDList = new ArrayList<String>();
        if (fprojectID != null && !"".equals(fprojectID)) {
            ProjectIDList.add(fprojectID);
        }
        try {
            IPMRPTableDefine table;
            if (ProjectIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)runParam.getEasCtx()).batchRequestObjIDForUpdate(ProjectIDList);
            }
            if ((table = runParam.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class)).getTableName() == null) {
                table.createTable(runParam.getEasCtx());
            }
            String expandPBBTempTable = table.getTableName();
            int effectedRows = 0;
            int level = 0;
            while (level < Constants.MAX_BOM_LEVEL) {
                effectedRows = 0;
                if (level == 0) {
                    sql.setLength(0);
                    sql.append(this.getInsertExpandPBBTempTableSQL(expandPBBTempTable));
                    sql.append("Select\r\n");
                    sql.append(" NewBOSID('").append(Constants.BosType.MRP_TMP_BOSTYPE).append("') FID,\r\n");
                    sql.append(" 0 FLevel,\r\n");
                    sql.append(" a.FStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append(" a.FStorageOrgUnitID FSupplyStorageOrgUnitID,\r\n");
                    if (fprojectID == null || "".equals(fprojectID)) {
                        sql.append(" null As FProjectID, ");
                    } else {
                        sql.append(" '").append(fprojectID).append("' As FProjectID, ");
                    }
                    if (ftrackNumberID == null || "".equals(ftrackNumberID) || "NOTExpand".equals(ftrackNumberID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(ftrackNumberID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append(" a.fmaterialid As FMaterialID,\r\n");
                    sql.append(" mp.fmaterialattr As FMaterialAttribute, \r\n");
                    sql.append(" a.FMainTenanceLevelID \r\n");
                    sql.append(",Null");
                    sql.append(" From t_mm_bom a \r\n");
                    sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = a.fmaterialid and mp.Forgunit = a.FStorageOrgUnitID \r\n");
                    sql.append(" WHERE a.fbasestatus = 4 \r\n");
                    if (fprojectID != null && !"".equals(fprojectID)) {
                        sql.append(" AND (a.FProjectID = '").append(fprojectID).append("' or a.FProjectID is null )\r\n");
                    } else {
                        sql.append(" AND a.FProjectID is null \r\n");
                    }
                    if (ftopMaterialid != null && !"".equals(ftopMaterialid)) {
                        sql.append(" AND a.fmaterialid = '").append(ftopMaterialid).append("'\r\n");
                    } else {
                        sql.append(" AND Not Exists(select 1 from T_MM_BomEntry d  Inner join T_MM_Bom h on h.fid = d.fparentid \r\n");
                        sql.append(" where d.fmaterialid = a.fmaterialid  \r\n");
                        sql.append(" And d.FSupplyStorageOrgUnitID = a.FStorageOrgUnitID  \r\n");
                        sql.append(" AND h.fdesignModeid  is not null \r\n");
                        sql.append(" And (h.fprojectid = a.fprojectid or a.fprojectid is null ) \r\n");
                        sql.append(" And isnull(h.fmainTenanceLevelID,'*') = isnull(a.fmainTenanceLevelID,'*')  \r\n");
                        sql.append(" And h.fbasestatus = 4 )\r\n");
                    }
                    sql.append(" AND a.fdesignModeid  is not null \r\n");
                    effectedRows = this.executeSQL(runParam.getEasCtx(), sql.toString());
                } else {
                    sql.setLength(0);
                    sql.append(this.getInsertExpandPBBTempTableSQL(expandPBBTempTable));
                    sql.append("Select\r\n");
                    sql.append("NewBOSID('").append(Constants.BosType.MRP_TMP_BOSTYPE).append("') FID,\r\n");
                    sql.append(level).append(" FLevel,\r\n");
                    sql.append("a.FStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append("b.fsupplystorageorgunitid FsupplyOrgid,\r\n");
                    if (fprojectID == null || "".equals(fprojectID)) {
                        sql.append(" null As FProjectID, ");
                    } else {
                        sql.append(" '").append(fprojectID).append("' As FProjectID, ");
                    }
                    if (ftrackNumberID == null || "".equals(ftrackNumberID) || "NOTExpand".equals(ftrackNumberID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(ftrackNumberID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append("b.fmaterialid FMaterialID,\r\n");
                    sql.append(" mp.fmaterialattr FMaterialAttribute, \r\n");
                    sql.append(" a.FMainTenanceLevelID \r\n");
                    sql.append(",a.FMaterialID\r\n");
                    sql.append("From ").append(expandPBBTempTable).append(" T \r\n");
                    sql.append("Inner Join t_mm_bom a On a.fmaterialid = T.FMaterialID and a.FStorageOrgUnitID = T.FSupplyStorageOrgUnitID \r\n");
                    sql.append("Inner Join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                    sql.append("left outer Join t_mm_trackNumber bt on b.fbegincarnoid = bt.fid \r\n");
                    sql.append("left outer Join t_mm_trackNumber et on b.fendcarnoid = et.fid \r\n");
                    sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = b.fmaterialid and mp.Forgunit = b.fsupplystorageorgunitid \r\n");
                    sql.append(" left outer join t_bd_materialplan mp2 on mp2.Fmaterialid =  T.FMaterialID  and mp2.Forgunit = T.FSupplyStorageOrgUnitID \r\n");
                    sql.append("Where\r\n");
                    sql.append("T.FLevel=").append(level - 1).append("\r\n");
                    sql.append(" And a.fbasestatus = 4  \r\n");
                    sql.append(" And (a.fprojectid = T.fprojectid or a.fprojectid is null ) \r\n");
                    sql.append(" And isnull(a.fmainTenanceLevelID,'*') = isnull(T.fmainTenanceLevelID,'*')  \r\n");
                    sql.append(" AND a.fdesignModeid  is not null \r\n");
                    if (ftrackNumberID != null && !"".equals(ftrackNumberID) && !"NOTExpand".equals(ftrackNumberID) && trackNumberInfo != null) {
                        sql.append(" AND (bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("' or b.fbegincarnoid)\r\n");
                        sql.append(" AND (et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' or b.fendcarnoid)\r\n");
                    }
                    effectedRows = this.executeSQL(runParam.getEasCtx(), sql.toString());
                }
                if (effectedRows > 0 && (!"NOTExpand".equals(ftrackNumberID) || ++level != 2)) continue;
            }
            Context ctx = runParam.getEasCtx();
            UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
            String fcuid = "";
            fcuid = curUserInfo.getCU() != null ? curUserInfo.getCU().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
            table = runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
            if (table.getTableName() == null) {
                table.createTable(ctx);
            }
            sql.setLength(0);
            sql.append(" Insert Into ").append(table.getTableName()).append("  \r\n");
            sql.append(" (");
            sql.append(table.getTableCols());
            sql.append(" ) \r\n");
            sql.append(" Select newbosid('").append(Constants.BosType.MRP_TMP_LLC).append("'),'");
            sql.append(curUserInfo.getId());
            sql.append("',sysdate,'");
            sql.append(fcuid);
            sql.append("','").append(fcuid).append("',  \r\n");
            sql.append(" temp.FProjectID,  \r\n");
            sql.append(" temp.FMaterialID,temp.FLevel,temp.FMaterialAttribute, temp.CFOrgUnitID, temp.CFParentOrgUnitID From  \r\n");
            sql.append(" (Select a.FMaterialID,a.FMaterialAttribute,Max(a.FLevel) as FLevel,a.FProjectID");
            sql.append(",  Max(a.FSupplyStorageOrgUnitID) as CFOrgUnitID");
            sql.append(", Max(a.FStorageOrgUnitID) as CFParentOrgUnitID");
            sql.append(" From\r\n");
            sql.append(expandPBBTempTable).append(" a");
            sql.append(" group by a.FMaterialID,a.FMaterialAttribute,a.FProjectID ) temp \r\n");
            sql.append(" where not exists(Select 1 from ").append(table.getTableName()).append(" b  \r\n");
            sql.append(" where b.CFMaterialID = temp.FMaterialID  \r\n");
            sql.append(" And b.CFMaterialATTR = temp.FMaterialAttribute  \r\n");
            sql.append(" And isnull(b.CFProjectID,'*') = isnull(temp.FProjectID,'*') ) \r\n");
            this.executeSQL(ctx, sql.toString());
        }
        finally {
            if (ProjectIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)runParam.getEasCtx()).batchReleaseObjIDForUpdate(ProjectIDList);
            }
        }
        return true;
    }

    @Override
    protected void saveLLC(PMRPCalcParam runParam, String FProjectID) throws PMRPException, BOSException {
    }

    @Override
    public void reset(PMRPCalcParam runParam) throws BOSException, PMRPException {
        String tbl = runParam.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class).getTableName();
        this.executeSQL(runParam.getEasCtx(), "DELETE " + tbl);
    }

    protected int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected String getInsertExpandPBBTempTableSQL(String expandPPBTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(expandPPBTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FSupplyStorageOrgUnitID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTrackNumberID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FMaterialAttribute,\r\n");
        sql.append("FMainTenanceLevelID,\r\n");
        sql.append("FParentMaterialID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    @Override
    protected BOMTypeEnum getBOMType() {
        return BOMTypeEnum.ProConfigBOM;
    }
}

