/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPSysConfig;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPAjustMent;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPAjustResult;
import com.kingdee.eas.mm.common.app.SQLUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class PMRPCalcLevelCode
extends PMRPStep {
    private static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2 > 20 ? (Runtime.getRuntime().availableProcessors() > 20 ? Runtime.getRuntime().availableProcessors() : 20) : Runtime.getRuntime().availableProcessors() * 2;
    protected int materialCount = 0;
    protected PMRPAjustResult result = null;
    protected int currentLevel = -1;

    @Override
    public String getStepDesc(Locale locale) {
        if (this.runParam == null) {
            PMRPResource.getString(locale, "SP_CALCLEVELCODE");
        }
        return PMRPResource.getString(locale, "NO") + String.valueOf(this.runParam.getLevel()) + PMRPResource.getString(locale, "LEVEL") + "," + PMRPResource.getString(locale, "SP_CALCLEVELCODE");
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        this.result = new PMRPAjustResult();
        this.doCalcNetDemand(runParam);
        return this.result;
    }

    private void doCalcNetDemand(PMRPCalcParam mrpCalcParam) throws BOSException, PMRPException {
        List<List<String>> idList = this.distrubteMaterials(mrpCalcParam);
        int size = idList.size();
        if (size == 0) {
            return;
        }
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)this.runParam.getService());
        for (int i = 0; i < size; ++i) {
            PMRPAjustMent calc = this.getCalcThread(idList.get(i), mrpCalcParam);
            ecs.submit((Callable)calc);
        }
        idList.clear();
        try {
            for (int j = 0; j < size; ++j) {
                this.result.mergeResult((PMRPAjustResult)ecs.take().get());
                if (this.logInfo == null) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            throw new BOSException(e.getCause());
        }
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    public final List<List<String>> distrubteMaterials(PMRPCalcParam mrpCalcParam) throws PMRPException, BOSException {
        List<String> idList = this.getLevelMaterialIDs(mrpCalcParam);
        ArrayList<List<String>> groupList = new ArrayList<List<String>>();
        this.materialCount = idList.size();
        if (idList.size() > 0) {
            int threadCount = (Integer)mrpCalcParam.getSysConfig().getCfgValue(PMRPSysConfig.ConfigItem.MAX_MRP_CALC_LEVEL_CODE_PROCESSOR, THREAD_COUNT);
            int n = idList.size() / threadCount;
            ArrayList<String> subList = null;
            for (int i = 1; i <= threadCount; ++i) {
                subList = i < threadCount ? new ArrayList<String>(idList.subList(n * (i - 1), n * i)) : new ArrayList<String>(idList.subList(n * (i - 1), idList.size()));
                groupList.add(subList);
            }
        }
        return groupList;
    }

    protected abstract List<String> getLevelMaterialIDs(PMRPCalcParam var1) throws PMRPException, BOSException;

    public abstract PMRPAjustMent getCalcThread(List<String> var1, PMRPCalcParam var2) throws PMRPException, BOSException;

    @Override
    public int getDataAmount() {
        return this.result.getDataAmount();
    }

    @Override
    protected void logBegin() throws BOSException, PMRPException {
        if (this.currentLevel != this.runParam.getLevel()) {
            super.logBegin();
            this.currentLevel = this.runParam.getLevel();
        }
    }

    @Override
    public PMRPRunLogEntryInfo createLogInfo(PMRPCalcParam runParam, PMRPRunLogEntryInfo parent, int numSeq) throws PMRPException, BOSException {
        if (this.currentLevel != runParam.getLevel()) {
            return super.createLogInfo(runParam, parent, numSeq);
        }
        return this.logInfo;
    }

    public void shutDown() {
        if (this.runParam != null && this.runParam.getService() != null) {
            this.runParam.getService().shutdown();
        }
    }
}

