/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPFetchMaterialDataUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.StatisticsTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.TempAdvanceTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.TempQtyAdjustTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PMRPFetchDetailDataUtil {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPFetchDetailDataUtil");
    private HashMap<String, List<PMRPDetailInfo>> materialDetials = new HashMap();
    private int lastSeq = -1;
    private int hitCount = 0;
    private List<String> materialIds = null;
    private PMRPFetchMaterialDataUtil materialDataUtil = null;
    private int detailCount = 0;

    public void setMaterialIds(List<String> materialIds, PMRPFetchMaterialDataUtil materialDataUtil) {
        this.materialIds = materialIds;
        this.materialDataUtil = materialDataUtil;
    }

    public List<PMRPDetailInfo> getAdvanceDetailsData(PMRPCalcParam runParam, String materialID, String projectNumber, String trackNumber, int period, String supplyOrgUnitID) throws BOSException, PMRPException {
        ArrayList<PMRPDetailInfo> adetail = new ArrayList<PMRPDetailInfo>();
        int periodMore = runParam.getDateManager().getPlanDate(supplyOrgUnitID).getPeriod() + (this.canNotDoAdvance(runParam) ? 0 : runParam.getRunLog().getPlanDefined().getAdjustPeriod());
        if (period > periodMore) {
            return adetail;
        }
        PMRPRunTableManager manager = runParam.getTableManager();
        String calcTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select d.*, s.FRQty FRQty, s.KSQL_SEQ from ").append(calcTbl).append(" d \n").append("inner join ").append(statisticsTbl).append(" s \n").append(" on s.fMaterialId = d.fMaterialId and s.FPeriod = d.FPeriod ").append(" and isnull(s.FProjectNumber,'*') = isnull(d.FProjectNumber,'*')  and isnull(s.FTrackNumber,'*')  = isnull(d.FTrackNumber,'*')    and s.FSupplyOrgUnitID = d.FSupplyOrgUnitID \n").append("where s.FMaterialID = ? and s.FSupplyOrgUnitID = ? and s.FPeriod> ? and  s.FPeriod<= ? ");
        if (projectNumber != null) {
            sql.append(" and isnull(s.FProjectNumber, '*') = ?");
        }
        if (trackNumber != null) {
            sql.append(" and isnull(s.FTrackNumber, '*') = ?");
        }
        if (runParam.getAdvanceType() == 0) {
            sql.append(" and s.FSurplusQty > 0 ");
        }
        sql.append(" and d.FSR-d.FAjustQty > 0 and d.FIsAjust = 1 and d.FMRPClassify = 20 ").append(" and (d.fsid is null or d.fid = d.fsid) \n").append("order by d.FMrpSeq ");
        IRowSet rs = projectNumber != null && trackNumber != null ? SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, supplyOrgUnitID, new Integer(period), new Integer(periodMore), projectNumber, trackNumber}) : (projectNumber != null ? SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, supplyOrgUnitID, new Integer(period), new Integer(periodMore), projectNumber}) : (trackNumber != null ? SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, supplyOrgUnitID, new Integer(period), new Integer(periodMore), trackNumber}) : SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, supplyOrgUnitID, new Integer(period), new Integer(periodMore)})));
        logger.debug((Object)("material: " + materialID + " period: " + period + " advance bills: " + rs.size()));
        try {
            PMRPDetailInfo detailInfo = null;
            BigDecimal periodReqQty = MRPConstant.ZERO;
            BigDecimal surplusQty = MRPConstant.ZERO;
            BigDecimal amountQty = MRPConstant.ZERO;
            int lastPeriod = -1;
            int curPeriod = -1;
            while (rs.next()) {
                detailInfo = this.getDetailInMemory(rs.getString("FMaterialID"), rs.getInt("FPeriod"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"), rs.getString("FID"), rs.getString("FSupplyOrgUnitID"));
                if (detailInfo == null) {
                    detailInfo = PMRPDetailInfo.readRow(rs);
                }
                surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
                curPeriod = detailInfo.getPeriod();
                if (curPeriod != lastPeriod) {
                    amountQty = MRPConstant.ZERO;
                    periodReqQty = rs.getBigDecimal("FRQty").abs();
                }
                if ((amountQty = amountQty.add(surplusQty)).compareTo(periodReqQty) > 0) {
                    if (amountQty.subtract(periodReqQty).compareTo(surplusQty) < 0) {
                        surplusQty = amountQty.subtract(periodReqQty);
                    }
                    detailInfo.setSurplusQty(surplusQty);
                    adetail.add(detailInfo);
                    logger.debug((Object)("material: " + materialID + " billNumber: " + detailInfo.getBillNumber() + " surplusQty: " + detailInfo.getSurplusQty() + " srQty: " + detailInfo.getScheduledReceiptQty()));
                }
                lastPeriod = curPeriod;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return adetail;
    }

    private boolean canNotDoAdvance(PMRPCalcParam runParam) {
        return !runParam.getRunLog().getPlanDefined().isIsConsiderAjustPeriod();
    }

    public void clear() {
        logger.info((Object)("detail data buffer hit count:" + String.valueOf(this.hitCount)));
        this.materialDetials.clear();
        this.lastSeq = -1;
        this.hitCount = 0;
        this.detailCount = 0;
    }

    private void getNextData(PMRPCalcParam runParam, List<Integer> seqList) throws BOSException, PMRPException {
        int i;
        PMRPRunTableManager manager = runParam.getTableManager();
        String calcTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select d.* ,s.KSQL_seq from ").append(calcTbl).append(" d").append(" inner join ").append(statisticsTbl).append(" s on").append(" d.FMaterialID = s.FMaterialID  and isnull(s.FProjectNumber,'*') = isnull(d.FProjectNumber,'*')").append(" and isnull(s.FTrackNumber,'*') = isnull(d.FTrackNumber,'*') and s.FPeriod = d.FPeriod").append(" and s.FSupplyOrgUnitID = d.FSupplyOrgUnitID").append(" and d.FLowsetCode = ").append(runParam.getLevel()).append(" where ( ");
        for (i = 0; i < this.materialIds.size(); ++i) {
            sql.append(" s.FMaterialID = ?");
            if (i == this.materialIds.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and (");
        for (i = 0; i < this.materialIds.size(); ++i) {
            sql.append(" d.FMaterialID = ?");
            if (i == this.materialIds.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") and (");
        for (i = 0; i < seqList.size(); ++i) {
            sql.append(" s.KSQL_seq = ?");
            if (i == seqList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") ").append(" and d.FMRPItem<>").append(110);
        sql.append(" order by s.KSQL_seq,d.FMRPSeq  ");
        ArrayList<Object> idList = new ArrayList<Object>();
        idList.addAll(this.materialIds);
        idList.addAll(this.materialIds);
        idList.addAll(seqList);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])idList.toArray());
        if (rs.size() > 0) {
            this.detailCount += rs.size();
            logger.debug((Object)("get detail data count:" + rs.size()));
            this.toMap(rs);
        }
    }

    private PMRPDetailInfo toMap(IRowSet rs) throws BOSException {
        String key = null;
        List<Object> detList = null;
        PMRPDetailInfo detailInfo = null;
        try {
            while (rs.next()) {
                key = this.getKey(rs.getInt("FPeriod"), rs.getString("FMaterialID"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"), rs.getString("FSupplyOrgUnitID"));
                if (this.materialDetials.containsKey(key)) {
                    detList = this.materialDetials.get(key);
                } else {
                    detList = new ArrayList();
                    this.materialDetials.put(key, detList);
                }
                this.lastSeq = rs.getInt("KSQL_seq");
                detailInfo = PMRPDetailInfo.readRow(rs);
                detList.add(detailInfo);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return detailInfo;
    }

    public List<PMRPDetailInfo> getOneMaterialDetialData(PMRPCalcParam runParam, int period, String materialId, String projectNumber, String trackNumber, int theSeq, String supplyOrgUnitID) throws BOSException, PMRPException {
        String key = this.getKey(period, materialId, projectNumber, trackNumber, supplyOrgUnitID);
        if (this.materialDetials.containsKey(key)) {
            List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
            this.materialDetials.remove(key);
            ++this.hitCount;
            return detialList;
        }
        List<Integer> seqList = this.materialDataUtil.getNextSeq(theSeq);
        int nextSeq = seqList.get(0);
        if (this.lastSeq < nextSeq) {
            this.getNextData(runParam, seqList);
            if (this.materialDetials.containsKey(key)) {
                List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
                this.materialDetials.remove(key);
                return detialList;
            }
            return new ArrayList<PMRPDetailInfo>();
        }
        return new ArrayList<PMRPDetailInfo>();
    }

    private String getKey(int period, String materialId, String projectNumber, String trackNumber, String supplyOrgUnitID) {
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(period);
        keyBuf.append(materialId);
        if (projectNumber == null || "".equals(projectNumber)) {
            keyBuf.append("*");
        } else {
            keyBuf.append(projectNumber);
        }
        if (trackNumber == null || "".equals(trackNumber)) {
            keyBuf.append("*");
        } else {
            keyBuf.append(trackNumber);
        }
        keyBuf.append(supplyOrgUnitID);
        String key = keyBuf.toString();
        return key;
    }

    private PMRPDetailInfo getDetailInMemory(String materialId, int period, String projectNumber, String TrackNumber, String ID, String supplyOrgUnitID) throws BOSException {
        String key = this.getKey(period, materialId, projectNumber, TrackNumber, supplyOrgUnitID);
        if (this.materialDetials.containsKey(key)) {
            List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                PMRPDetailInfo detailInfo = detialList.get(i);
                if (!detailInfo.getID().equals(ID)) continue;
                return detailInfo;
            }
        }
        return null;
    }

    public void clearDetailInMemory(PMRPDetailInfo adetailInfo) throws BOSException {
        int period = adetailInfo.getSperiod();
        if (period <= 0) {
            period = adetailInfo.getPeriod();
        }
        this.clearDetailInMemory(adetailInfo.getMaterialID(), period, adetailInfo.getProjectNumber(), adetailInfo.getTrackNumber(), adetailInfo.getID(), adetailInfo.getSupplyStorageOrgUnitID());
    }

    private void clearDetailInMemory(String materialId, int period, String projectNumber, String TrackNumber, String ID, String supplyOrgUnitID) throws BOSException {
        String key = this.getKey(period, materialId, projectNumber, TrackNumber, supplyOrgUnitID);
        if (this.materialDetials.containsKey(key)) {
            List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
            for (int i = 0; i < detialList.size(); ++i) {
                PMRPDetailInfo detailInfo = detialList.get(i);
                if (!detailInfo.getID().equals(ID)) continue;
                detialList.remove(i);
            }
        }
    }

    public void releaseTemptable(PMRPCalcParam runParam) throws BOSException, PMRPException {
        PMRPRunTableManager manager = runParam.getTableManager();
        manager.realeaseTempTableDefine(runParam.getEasCtx(), TempAdvanceTableDefine.class);
        manager.realeaseTempTableDefine(runParam.getEasCtx(), TempQtyAdjustTableDefine.class);
    }

    public int getDetailCount() {
        return this.detailCount;
    }
}

