/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPNetReqSaver;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialDataInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialStatisticsInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.StatisticsTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PMRPFetchMaterialDataUtil {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPFetchMaterialDataUtil");
    protected HashMap<String, BigDecimal> preQty = new HashMap();
    private List<String> materialIdList = null;
    private HashMap<String, PMRPMaterialDataInfo> materials = new HashMap();
    private PMRPCalcParam runParam = null;
    private List<PMRPMaterialStatisticsInfo> statisticsBufferList = new ArrayList<PMRPMaterialStatisticsInfo>();
    private int lastSeq = 0;
    private boolean hasGetAllData = false;
    private PMRPNetReqSaver dataSaver;

    public PMRPFetchMaterialDataUtil(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    public void setDataSaver(PMRPNetReqSaver dataSaver) {
        this.dataSaver = dataSaver;
    }

    public int[] setMaterialIdList(List<String> idList) throws PMRPException, BOSException {
        this.materialIdList = idList;
        this.statisticsBufferList.clear();
        this.lastSeq = 0;
        this.hasGetAllData = false;
        this.materials = PMRPFetchMaterialDataUtil.getLevelMaterialInfo(this.runParam, idList);
        return this.getCalcPeriod(idList);
    }

    public static HashMap<String, PMRPMaterialDataInfo> getLevelMaterialInfo(PMRPCalcParam runParam, List<String> idList) throws PMRPException, BOSException {
        return PMRPFetchMaterialDataUtil.getLevelMaterialInfoImpl(runParam, idList);
    }

    private static HashMap<String, PMRPMaterialDataInfo> getLevelMaterialInfoImpl(PMRPCalcParam runParam, List<String> idList) throws PMRPException, BOSException {
        PMRPRunTableManager manager = runParam.getTableManager();
        String calcTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        if (idList == null || idList.size() == 0) {
            return null;
        }
        HashMap<String, PMRPMaterialDataInfo> materialDatas = new HashMap<String, PMRPMaterialDataInfo>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select ").append("mcal.FID As FID,").append("mcal.Fmaterialid As FMaterialID ,").append("m.Fnumber As FMaterialNumber ,").append("m.FBaseUnit As FBaseUnitID,").append("u1.FQtyPrecision As FBaseQtyPrc,").append("mp.FProductUnitID As FProdUnitID,").append("u3.FQTYPRECISION As FProdQtyPrc,").append("u3.FBASECONVSRATE As FConvertRate,").append("mp.FPlanner  As FPlanner,").append(" 0 As FOnHand ,").append("Isnull(round(decimal(isnull(mi.FQtySafety,0) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),0) As FSafeStock,").append("Isnull(round(decimal(isnull(mi.FQtyMax,-1) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION),0) As FQtyMax,").append("mp.FIsMergeSign As FIsMergeSign,").append("100 As FYield, ").append("mp.FManufactureStrategyID As FPlanStrategy,").append("mp.FBatchPolicy As FBatchPolicy,").append("round(decimal(isnull(mp.FFixationBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION) As FFixationBatchQty,").append("round(decimal(isnull(mp.FMinBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION) AS FMinBatchQty,").append("round(decimal(isnull(mp.FRoundUpMultipleQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION) As FRoundUpMultipleQty,").append("round(decimal(isnull(mp.FBatchIncQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION) As FBatchIncQty,").append("mcal.FMaterialAttr As FMaterialAttr,").append("mp.FPlanningMode As FPlanningMode,").append("mp.FRecevingLeadTime As FRecevingLeadTime,").append("mp.FProduceLeadTime As FProduceLeadTime,").append("mp.FForwardProcessTime As FForwardProcessTime,").append("mp.FBackwardProcessTime As FBackwardProcessTime,").append("mcal.FBOMID As FBOMID,").append("mp.FProvideType As FSupplyType,").append("mcal.FOrgUnitID As FOrgUnitID ,").append("mcal.FSupplyOrgUnitID As FSupplyOrgUnitID ,").append("round(decimal(isnull(mi.FQtyMinPackage ,0) * u2.FBASECONVSRATE,21,8),u1.FQTYPRECISION) As FQtyMinPackage,").append("mp.FReqUniteRuleID As FRequirementUniteRuleID,").append("mp.FdutyDepartment As FManufactureDepartment, ").append("case when mp.FMaterialAttr = 10030 then pt.FID else null end As FProductTranTypeID ,").append("mp.FLeadTimeType As FLeadTimeType,").append("isnull(mp.FChangeLeadTime,0) As FChangeLeadTime,").append("isnull(mp.FChangeBatch,0) As FChangeBatch,").append("mp.FIsPlanNoRelease As FIsCanNotThrow,").append("(case when mp.FPartitionType = 10 then mp.FPartitionDays else 0 - mp.FPartitionDays end) As FPartitionQty,").append("round(decimal(isnull(mp.FMaxBatchQty,0) * u3.FBASECONVSRATE,21,8),u1.FQTYPRECISION) As FMaxBatchQty,").append("mp.FBatchCycle As FBatchCycle,").append("mp.FISOLATEDRULE As FisolateRules,").append(" 1 As FIsSurplusDivert, ").append("mp.FisComReqConsume AS FisComReqConsume,").append("mp.FPlanOrgID As FPlanOrgUnit, ").append("mcal.FLowsetCode As FLowsetCode ");
            sb.append("from ").append(calcTbl).append(" mcal ");
            sb.append(" inner join t_bd_material m on m.fid = mcal.fmaterialid ");
            sb.append(" inner join t_bd_materialplan mp on mp.fmaterialid = mcal.Fmaterialid and mp.Forgunit = mcal.FSupplyOrgUnitID ");
            sb.append(" left outer join t_bd_materialinventory mi on mi.fmaterialid = mcal.Fmaterialid and mi.Forgunit = mcal.FSupplyOrgUnitID ");
            sb.append(" left outer join t_mm_producttransactiontype pt on mp.FProductTranType=pt.FID ");
            sb.append(" and pt.FStatus=20 ").append("\r\n");
            sb.append(" left join T_BD_MultiMeasureUnit u1 on m.fid=u1.FMaterialID and m.FBaseUnit=u1.FMeasureUnitID ");
            sb.append(" left join T_BD_MultiMeasureUnit u2 on mi.FMaterialID=u2.FMaterialID and mi.FUnitID=u2.FMeasureUnitID ");
            sb.append(" left join T_BD_MultiMeasureUnit u3 on mp.FMaterialID=u3.FMaterialID and mp.FProductUnitID=u3.FMeasureUnitID ");
            sb.append(" where mcal.FLowsetCode =  ").append(runParam.getLevel()).append(" and mp.fplanningmode in (2,3) ");
            ArrayList<String> oneUpdateList = new ArrayList<String>();
            for (int i = 0; i < idList.size(); ++i) {
                if (oneUpdateList.size() > 1000) {
                    PMRPFetchMaterialDataUtil.execMaterialRowData(runParam, oneUpdateList, materialDatas, sb);
                    oneUpdateList = new ArrayList();
                }
                oneUpdateList.add(idList.get(i));
            }
            if (oneUpdateList.size() > 0) {
                PMRPFetchMaterialDataUtil.execMaterialRowData(runParam, oneUpdateList, materialDatas, sb);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }

    private static void execMaterialRowData(PMRPCalcParam runParam, List<String> oneUpdateList, HashMap<String, PMRPMaterialDataInfo> materialDatas, StringBuffer sb) throws PMRPException, BOSException, SQLException {
        StringBuffer sbwhere = new StringBuffer();
        sbwhere.append("  And (");
        for (int i = 0; i < oneUpdateList.size(); ++i) {
            sbwhere.append(" mcal.FMaterialID = ?");
            if (i == oneUpdateList.size() - 1) continue;
            sbwhere.append(" OR ");
        }
        sbwhere.append(") ");
        Object[] params = new Object[oneUpdateList.size()];
        System.arraycopy(oneUpdateList.toArray(), 0, params, 0, oneUpdateList.size());
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)(sb.toString() + sbwhere.toString()), (Object[])params);
        PMRPMaterialDataInfo dataInfo = null;
        String fkeyid = null;
        while (rs.next()) {
            dataInfo = PMRPMaterialDataInfo.readRow(runParam, rs, null);
            fkeyid = dataInfo.getMaterialID() + dataInfo.getSupplyStorageOrgUnitID();
            if (materialDatas != null && materialDatas.containsKey(fkeyid)) continue;
            materialDatas.put(fkeyid, dataInfo);
        }
    }

    private int[] getCalcPeriod(List<String> idList) throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPeriod from ").append(statisticsTbl).append(" where ");
        for (int i = 0; i < idList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == idList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" order by FPeriod ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])idList.toArray());
        int[] periods = new int[rs.size()];
        try {
            int i = 0;
            while (rs.next()) {
                periods[i++] = rs.getInt("FPeriod");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return periods;
    }

    public List<PMRPMaterialStatisticsInfo> getDeLayPerid(PMRPCalcParam runParam, String materialID, String projectNumber, String trackNumber, int period, int lastSeq, String supplyOrgUnitID) throws BOSException, PMRPException {
        PMRPRunTableManager manager = runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        LinkedList<PMRPMaterialStatisticsInfo> delayPeriod = new LinkedList<PMRPMaterialStatisticsInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from  ").append(statisticsTbl).append(" s ").append(" where s.FMaterialID = ?   and s.FSupplyOrgUnitID = ?  and s.Fperiod");
        sql.append(" > ? and s.FOnHand+s.FSqty+s.FRQty<0").append(" and isnull(s.FProjectNumber, '*') = ? and isnull(s.FTrackNumber, '*') = ? and s.KSQL_SEQ>?").append(" order by  s.KSQL_SEQ");
        if (projectNumber == null) {
            projectNumber = "*";
        }
        if (trackNumber == null) {
            trackNumber = "*";
        }
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, supplyOrgUnitID, new Integer(period), projectNumber, trackNumber, new Integer(lastSeq)});
        try {
            PMRPMaterialStatisticsInfo statisticsInfo = null;
            while (rs.next()) {
                statisticsInfo = this.getStatisticsInfoInMemory(rs.getInt("KSQL_seq"));
                if (statisticsInfo == null) {
                    statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                }
                delayPeriod.add(statisticsInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return delayPeriod;
    }

    private PMRPMaterialStatisticsInfo getStatisticsInfoInMemory(int period, String materialID, String supplyOrgUnitID, String projectNumber, String trackNumber) {
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = this.statisticsBufferList.get(i);
            if (statisticsInfo.getPeriod() != period || !statisticsInfo.getMaterialID().equals(materialID) || !statisticsInfo.getSupplyOrgUnitID().equals(supplyOrgUnitID) || !StringUtil.equals((String)statisticsInfo.getProjectNumber(), (String)(projectNumber == null ? "*" : projectNumber)) || !StringUtil.equals((String)statisticsInfo.getTrackNumber(), (String)(trackNumber == null ? "*" : trackNumber))) continue;
            return statisticsInfo;
        }
        return null;
    }

    public PMRPMaterialStatisticsInfo getStatisticsInfo(PMRPDetailInfo detailInfo) throws PMRPException, BOSException {
        PMRPMaterialStatisticsInfo statisticsInfo = this.getStatisticsInfoInMemory(detailInfo.getPeriod(), detailInfo.getMaterialID(), detailInfo.getSupplyStorageOrgUnitID(), detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
        if (statisticsInfo == null) {
            this.fillBuffer(detailInfo.getSeq());
            statisticsInfo = this.getStatisticsInfoInMemory(detailInfo.getPeriod(), detailInfo.getMaterialID(), detailInfo.getSupplyStorageOrgUnitID(), detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
        }
        return statisticsInfo;
    }

    private PMRPMaterialStatisticsInfo getStatisticsInfoInMemory(int seq) {
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() != seq) continue;
            return statisticsInfo;
        }
        return null;
    }

    public PMRPMaterialStatisticsInfo getNextStatisticData(String materialID, String supplyOrgUnitID, int period) throws BOSException {
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = this.statisticsBufferList.get(0);
            if (materialID.equals(statisticsInfo.getMaterialID()) && supplyOrgUnitID.equals(statisticsInfo.getSupplyOrgUnitID()) && period == statisticsInfo.getPeriod()) {
                this.statisticsBufferList.remove(0);
            } else {
                statisticsInfo = null;
            }
        }
        return statisticsInfo;
    }

    public boolean hasNextMaterial(int period) throws BOSException, PMRPException {
        return this.hasNextStatisticData(null, null, period);
    }

    public PMRPMaterialDataInfo getNextMaterial(int period) throws BOSException {
        PMRPMaterialStatisticsInfo statisticsInfo;
        PMRPMaterialDataInfo materialInfo = null;
        if (this.statisticsBufferList.size() > 0 && period == (statisticsInfo = this.statisticsBufferList.get(0)).getPeriod()) {
            materialInfo = this.getMaterialInfo(statisticsInfo.getMaterialID() + statisticsInfo.getSupplyOrgUnitID());
        }
        if (materialInfo == null) {
            System.out.println("----PMRPFetchMaterialDataUtil.getNextMaterial \u83b7\u53d6materialInfo \u4e3a\u7a7a\uff1a-----period:" + period);
            if (this.statisticsBufferList.size() > 0) {
                PMRPMaterialStatisticsInfo statisticsNullInfo = this.statisticsBufferList.get(0);
                System.out.println("----PMRPFetchMaterialDataUtil.getNextMaterial \u83b7\u53d6materialInfo \u4e3a\u7a7a\uff1a-----statisticsInfo:" + statisticsNullInfo.toString());
                System.out.println("----PMRPFetchMaterialDataUtil.getNextMaterial \u83b7\u53d6materialInfo \u4e3a\u7a7a\uff1a-----statisticsInfo.getMaterialID():" + statisticsNullInfo.getMaterialID());
                System.out.println("----PMRPFetchMaterialDataUtil.getNextMaterial \u83b7\u53d6materialInfo \u4e3a\u7a7a\uff1a-----statisticsInfo.getSupplyOrgUnitID():" + statisticsNullInfo.getSupplyOrgUnitID());
            }
        }
        return materialInfo;
    }

    public boolean hasNextStatisticData(String materialID, String supplyOrgUnitID, int period) throws BOSException, PMRPException {
        boolean bret = false;
        if (this.statisticsBufferList.size() <= 0 && !this.hasGetAllData) {
            this.fillBuffer();
        }
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = this.statisticsBufferList.get(0);
        }
        if (statisticsInfo != null) {
            bret = materialID != null ? materialID.equals(statisticsInfo.getMaterialID()) && supplyOrgUnitID.equals(statisticsInfo.getSupplyOrgUnitID()) && period == statisticsInfo.getPeriod() : period == statisticsInfo.getPeriod();
        }
        return bret;
    }

    private void fillBuffer() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        try {
            this.dataSaver.execute(true);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ").append(statisticsTbl).append(" where ( ");
        for (int i = 0; i < this.materialIdList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == this.materialIdList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" ) AND KSQL_seq> ? ").append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(this.materialIdList);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                PMRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                    if (statisticsInfo.getMaterialID() != null && statisticsInfo.getSupplyOrgUnitID() != null) continue;
                    if (statisticsInfo == null) {
                        System.out.println("----statisticsInfo\u7684\u7269\u6599\u6216\u8005\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff1a-----statisticsInfo:\u7a7a");
                    } else {
                        System.out.println("----statisticsInfo\u7684\u7269\u6599\u6216\u8005\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff1a-----statisticsInfo:" + statisticsInfo.toString());
                    }
                    System.out.println("----statisticsInfo\u7684\u7269\u6599\u6216\u8005\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff1a-----sql:" + sql.toString());
                    System.out.println("----statisticsInfo\u7684\u7269\u6599\u6216\u8005\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff1a-----params.toArray():" + params.toArray().toString());
                }
                if (statisticsInfo != null) {
                    this.lastSeq = statisticsInfo.getSeq();
                }
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    private void fillBuffer(int newLastSeq) throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(statisticsTbl).append(" where ( ");
        for (int i = 0; i < this.materialIdList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == this.materialIdList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" ) AND KSQL_seq> ? and KSQL_seq<=?").append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(this.materialIdList);
        params.add(new Integer(this.lastSeq));
        params.add(new Integer(newLastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.size() > 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"33_MRPFetchMaterialDataUtil", (Locale)this.runParam.getEasCtx().getLocale()) + String.valueOf(rs.size())));
            }
            PMRPMaterialStatisticsInfo statisticsInfo = null;
            while (rs.next()) {
                statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                this.statisticsBufferList.add(statisticsInfo);
            }
            if (statisticsInfo != null) {
                this.lastSeq = statisticsInfo.getSeq();
            }
            sql.setLength(0);
            sql.append("select * from ").append(statisticsTbl).append(" where ");
            sql.append(" KSQL_seq> ? and FPeriod=? and FMaterialId=?").append(" order by KSQL_seq ");
            params.clear();
            params.add(new Integer(this.lastSeq));
            if (statisticsInfo != null) {
                params.add(new Integer(statisticsInfo.getPeriod()));
                params.add(statisticsInfo.getMaterialID());
            }
            if ((rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray())).size() > 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"33_MRPFetchMaterialDataUtil", (Locale)this.runParam.getEasCtx().getLocale()) + String.valueOf(rs.size())));
            }
            while (rs.next()) {
                statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                this.statisticsBufferList.add(statisticsInfo);
            }
            if (statisticsInfo != null) {
                this.lastSeq = statisticsInfo.getSeq();
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public List<Integer> getNextSeq(int fromSeq) {
        int detailCount = 0;
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        seqList.add(new Integer(fromSeq));
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() <= fromSeq) continue;
            if ((detailCount += statisticsInfo.getDetailCount()) >= 2000 || this.materialIdList.size() * 2 + seqList.size() >= 2000) break;
            seqList.add(new Integer(statisticsInfo.getSeq()));
        }
        return seqList;
    }

    public PMRPMaterialDataInfo getMaterialInfo(String key) {
        PMRPMaterialDataInfo materialDataInfo = null;
        if (this.materials != null) {
            materialDataInfo = this.materials.get(key);
        }
        return materialDataInfo;
    }

    protected void setPreQty(HashMap<String, BigDecimal> preQty) {
        this.preQty = preQty;
    }

    public HashMap<String, PMRPMaterialDataInfo> getMaterials() {
        return this.materials;
    }
}

