/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPFetchMaterialDataUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialDataInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialStatisticsInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.StatisticsTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PMRPFetchSurplusDivertDataUtil {
    private String materialId;
    private PMRPCalcParam runParam;
    private HashMap<String, List<PMRPDetailInfo>> materialDetials = new HashMap();
    private int detailType;
    public static final int REQ = 10;
    public static final int SUPPLY = 20;
    public static final int ALL = 30;
    private List<PMRPMaterialStatisticsInfo> statisticsBufferList = new ArrayList<PMRPMaterialStatisticsInfo>();
    private int lastSeq = 0;
    private int lastDetailSeq = 0;
    private boolean hasGetAllData = false;

    public PMRPFetchSurplusDivertDataUtil(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    public void setMaterialId(String strId) throws PMRPException, BOSException {
        this.materialId = strId;
        this.statisticsBufferList.clear();
        this.materialDetials.clear();
        this.lastSeq = 0;
        this.hasGetAllData = false;
    }

    public int[] getCalcPeriod() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPeriod from ").append(statisticsTbl).append(" where ");
        sql.append(" FMaterialID = ?");
        if (this.detailType == 10) {
            sql.append(" and FSurplusQty < 0 ");
        } else if (this.detailType == 20) {
            sql.append(" and FSurplusQty > 0 ");
        } else if (this.detailType == 30) {
            sql.append(" and FSurplusQty <> 0 ");
        }
        sql.append(" order by FPeriod ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{this.materialId});
        int[] periods = new int[rs.size()];
        try {
            int i = 0;
            while (rs.next()) {
                periods[i++] = rs.getInt("FPeriod");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return periods;
    }

    public PMRPMaterialDataInfo getMaterialInfo(String materialID, String supplyOrgUnitID) throws BOSException {
        HashMap<String, PMRPMaterialDataInfo> materials;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.materialId);
        try {
            materials = PMRPFetchMaterialDataUtil.getLevelMaterialInfo(this.runParam, idList);
        }
        catch (PMRPException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        return (PMRPMaterialDataInfo)materials.get(this.materialId + supplyOrgUnitID);
    }

    private void fillBuffer4Req() throws PMRPException, BOSException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ").append(statisticsTbl).append(" where ");
        sql.append(" FMaterialID = ? ");
        sql.append(" AND FSurplusQty < 0 ");
        sql.append(" AND KSQL_seq> ? ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                PMRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                if (statisticsInfo != null) {
                    this.lastSeq = statisticsInfo.getSeq();
                }
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    private void fillBuffer4Supply(int period, String projectNumber, String trackNumber) throws PMRPException, BOSException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ");
        sql.append(statisticsTbl).append(" where ");
        sql.append(" FMaterialID = ?");
        if (projectNumber != null) {
            sql.append(" AND FProjectNumber = ? ");
        }
        if (trackNumber != null) {
            sql.append(" AND FTrackNumber = ? ");
        }
        sql.append(" AND KSQL_seq > ? ");
        sql.append(" AND FSurplusQty > 0 ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        if (projectNumber != null) {
            params.add(projectNumber);
        }
        if (trackNumber != null) {
            params.add(trackNumber);
        }
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                PMRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                if (statisticsInfo != null) {
                    this.lastSeq = statisticsInfo.getSeq();
                }
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    public List<PMRPDetailInfo> getOneMaterialDetialData(int period, String materialId, String projectNumber, String trackNumber, int theSeq) throws BOSException, PMRPException {
        String key = this.getKey(period, materialId, projectNumber, trackNumber);
        if (this.materialDetials.containsKey(key)) {
            List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
            this.materialDetials.remove(key);
            return detialList;
        }
        List<Integer> seqList = this.getNextSeq(theSeq);
        int nextSeq = seqList.get(0);
        if (this.lastDetailSeq < nextSeq) {
            this.getNextData(seqList);
            if (this.materialDetials.containsKey(key)) {
                List<PMRPDetailInfo> detialList = this.materialDetials.get(key);
                this.materialDetials.remove(key);
                return detialList;
            }
            return new ArrayList<PMRPDetailInfo>();
        }
        return new ArrayList<PMRPDetailInfo>();
    }

    private void getNextData(List<Integer> seqList) throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String calcTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select d.* ,s.KSQL_seq from ").append(calcTbl).append(" d");
        sql.append(" inner join ").append(statisticsTbl).append(" s ");
        sql.append(" on d.FMaterialID = s.FMaterialID  and s.FProjectNumber = d.FProjectNumber ");
        sql.append(" and s.FTrackNumber = d.FTrackNumber and s.FPeriod = d.FPeriod ");
        sql.append(" and d.FLowsetCode = ").append(this.runParam.getLevel());
        sql.append(" inner join CT_BAS_PlanDefined pd on  d.FPlanVersionID=pd.FID").append(" inner join CT_BAS_SupplyRD srd on pd.CFSupplyRelationID=srd.FID").append(" left join CT_BAS_SupplyRDE srde on srd.FID=srde.FParentID and srde.CFProductOrgUnitID=s.FOrgUnitID and s.FSupplyOrgUnitID=srde.CFSupplyOrgUnitID");
        sql.append(" where s.FMaterialID = ?");
        sql.append(" and d.FMaterialID = ?");
        sql.append(" and (");
        for (int i = 0; i < seqList.size(); ++i) {
            sql.append(" s.KSQL_seq = ?");
            if (i == seqList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(") ");
        sql.append(" and d.FMRPItem<>").append(110);
        sql.append(" and d.FMRPItem<>").append(120);
        if (this.detailType == 10) {
            sql.append(" and d.FNetReq < 0 ");
        } else if (this.detailType == 20) {
            sql.append(" and d.FNetReq > 0 ");
            sql.append(" and d.FIsAjust = 1 ");
        }
        sql.append(" order by srde.CFPriorityLevel");
        ArrayList<Object> idList = new ArrayList<Object>();
        idList.add(this.materialId);
        idList.add(this.materialId);
        idList.addAll(seqList);
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])idList.toArray());
        if (rs.size() > 0) {
            this.toMap(rs);
        }
    }

    private PMRPDetailInfo toMap(IRowSet rs) throws BOSException {
        String key = null;
        List<Object> detList = null;
        PMRPDetailInfo detailInfo = null;
        try {
            while (rs.next()) {
                key = this.getKey(rs.getInt("FPeriod"), rs.getString("FMaterialID"), rs.getString("FProjectNumber"), rs.getString("FTrackNumber"));
                if (this.materialDetials.containsKey(key)) {
                    detList = this.materialDetials.get(key);
                } else {
                    detList = new ArrayList();
                    this.materialDetials.put(key, detList);
                }
                this.lastDetailSeq = rs.getInt("KSQL_seq");
                detailInfo = PMRPDetailInfo.readRow(rs);
                detList.add(detailInfo);
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return detailInfo;
    }

    public List<Integer> getNextSeq(int fromSeq) {
        int detailCount = 0;
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        seqList.add(new Integer(fromSeq));
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() <= fromSeq) continue;
            if ((detailCount += statisticsInfo.getDetailCount()) >= 2000) break;
            seqList.add(new Integer(statisticsInfo.getSeq()));
        }
        return seqList;
    }

    private String getKey(int period, String materialId, String projectNumber, String trackNumber) {
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(period);
        keyBuf.append(materialId);
        keyBuf.append(projectNumber);
        keyBuf.append(trackNumber);
        String key = keyBuf.toString();
        return key;
    }

    public void clearSeq() {
        this.lastDetailSeq = 0;
    }

    public PMRPMaterialDataInfo getNextMaterial(int period) throws BOSException {
        PMRPMaterialStatisticsInfo statisticsInfo;
        PMRPMaterialDataInfo materialInfo = null;
        if (this.statisticsBufferList.size() > 0 && period == (statisticsInfo = this.statisticsBufferList.get(0)).getPeriod()) {
            materialInfo = this.getMaterialInfo(statisticsInfo.getMaterialID(), statisticsInfo.getSupplyOrgUnitID());
        }
        return materialInfo;
    }

    public boolean hasNextMaterial(int period) throws BOSException, PMRPException {
        return this.hasNextStatisticData(period, null, null, null);
    }

    public boolean hasNextStatisticData(int period, String materialID, String projectNumber, String trackNumber) throws BOSException, PMRPException {
        boolean bret = false;
        if (this.statisticsBufferList.size() <= 0 && !this.hasGetAllData) {
            if (this.detailType == 10) {
                this.fillBuffer4Req();
            } else if (this.detailType == 20) {
                this.fillBuffer4Supply(period, projectNumber, trackNumber);
            } else if (this.detailType == 30) {
                this.fillBuffer();
            }
        }
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = this.statisticsBufferList.get(0);
        }
        if (statisticsInfo != null) {
            bret = materialID != null ? this.isMatch(statisticsInfo, period, materialID, projectNumber, trackNumber) : period == statisticsInfo.getPeriod();
        }
        return bret;
    }

    private void fillBuffer() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String statisticsTbl = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ");
        sql.append(statisticsTbl).append(" where ");
        sql.append(" FMaterialID = ?");
        sql.append(" AND KSQL_seq > ? ");
        sql.append(" AND FSurplusQty <> 0 ");
        sql.append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.materialId);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            try {
                PMRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = PMRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                if (statisticsInfo != null) {
                    this.lastSeq = statisticsInfo.getSeq();
                }
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    public PMRPMaterialStatisticsInfo getNextStatisticData(int period, String materialID, String projectNumber, String trackNumber) throws BOSException {
        PMRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = this.statisticsBufferList.get(0);
            if (this.isMatch(statisticsInfo, period, materialID, projectNumber, trackNumber)) {
                this.statisticsBufferList.remove(0);
            } else {
                statisticsInfo = null;
            }
        }
        return statisticsInfo;
    }

    private boolean isMatch(PMRPMaterialStatisticsInfo statisticsInfo, int period, String materialID, String projectNumber, String trackNumber) {
        boolean ret = false;
        if (this.detailType == 20) {
            if (projectNumber != null && trackNumber != null) {
                if (materialID.equals(statisticsInfo.getMaterialID()) && projectNumber.equals(statisticsInfo.getProjectNumber()) && trackNumber.equals(statisticsInfo.getTrackNumber())) {
                    ret = true;
                }
            } else if (materialID.equals(statisticsInfo.getMaterialID())) {
                ret = true;
            }
        } else if (materialID.equals(statisticsInfo.getMaterialID()) && period == statisticsInfo.getPeriod()) {
            ret = true;
        }
        return ret;
    }

    public Map<String, PMRPDetailInfo> getIsolatorOnhandDetail() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String calcTbl = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        HashMap<String, PMRPDetailInfo> map = new HashMap<String, PMRPDetailInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.*, 0 KSQL_seq from ").append(calcTbl).append(" t0 where FMaterialID='").append(this.materialId).append("'").append(" and FMRPItem = ").append(110);
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString());
        try {
            while (rs.next()) {
                PMRPDetailInfo info = PMRPDetailInfo.readRow(rs);
                info.setNetReqQty(info.getAvaliableQty());
                map.put(info.getProjectNumber() + info.getTrackNumber(), info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public int getDetailType() {
        return this.detailType;
    }

    public void setDetailType(int detailType) {
        this.detailType = detailType;
    }
}

