/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPElementEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPDate;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPAjustMent;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPFetchSurplusDivertDataUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialDataInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PMRPSurplusDivertAjustMent
extends PMRPAjustMent {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPSurplusDivertAjustMent");
    protected PMRPFetchSurplusDivertDataUtil materialDataUtil;
    protected PMRPFetchSurplusDivertDataUtil reqMaterialDataUtil;
    protected PMRPFetchSurplusDivertDataUtil supplyMaterialDataUtil;
    private Map<String, PMRPDetailInfo> onHandMap;
    private List<Object[]> fristPeriodList;

    public PMRPSurplusDivertAjustMent(List<String> materialIDLst, PMRPCalcParam runParam, List<Object[]> materialFristPeriodList) throws PMRPException, BOSException {
        super(materialIDLst, runParam);
        this.fristPeriodList = materialFristPeriodList;
        this.materialDataUtil = new PMRPFetchSurplusDivertDataUtil(runParam);
        this.materialDataUtil.setDetailType(30);
        this.reqMaterialDataUtil = new PMRPFetchSurplusDivertDataUtil(runParam);
        this.reqMaterialDataUtil.setDetailType(10);
        this.supplyMaterialDataUtil = new PMRPFetchSurplusDivertDataUtil(runParam);
        this.supplyMaterialDataUtil.setDetailType(20);
    }

    @Override
    protected void cycCalc() throws BOSException, PMRPException {
        int[] periods = null;
        PMRPMaterialDataInfo materialDataInfo = null;
        int n = this.materialIDLst.size();
        for (int i = 0; i < n; ++i) {
            String materialID = (String)this.materialIDLst.get(i);
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0102", (Locale)this.runParam.getEasCtx().getLocale()) + materialID + "."));
            this.fristPeriodList.add(new Object[]{new Integer(this.runParam.getDateManager().getBeginDate(this.runParam.getStorageOrgUnitID()).getPeriod()), new Timestamp(this.runParam.getDateManager().getBeginDate(this.runParam.getStorageOrgUnitID()).getDate().getTime().getTime()), materialID});
            this.materialDataUtil.setMaterialId(materialID);
            periods = this.materialDataUtil.getCalcPeriod();
            this.materialDataUtil.clearSeq();
            this.onHandMap = null;
            for (int j = 0; j < periods.length; ++j) {
                int period = periods[j];
                while (this.materialDataUtil.hasNextMaterial(period)) {
                    materialDataInfo = this.materialDataUtil.getNextMaterial(period);
                    this.createMaterialDataInfo(materialDataInfo);
                    this.oneDayCalc(materialDataInfo, period);
                }
                this.dataSaver.execute(true);
            }
            this.afterCalcLoopHook();
            this.dataAmount += this.detailDataUtil.getDetailCount();
            this.detailDataUtil.clear();
            this.runParam.getCounter().logMaterialCalcFinished();
            this.doSurplusQtyDivert(materialID, false);
            this.doSurplusQtyDivert(materialID, true);
            this.dealSurplusReq(materialID);
            this.dealSurplusSupply(materialID);
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"36_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + materialID + "\u3002"));
        }
        this.materialException.clear();
        this.underSafeStockIds.clear();
        this.dataSaver.executeUpdateMaterial();
    }

    @Override
    protected void oneDayCalc(PMRPMaterialDataInfo materialDataInfo, int period) throws BOSException, PMRPException {
        PMRPMaterialStatisticsInfo materialStatisticsInfo = null;
        List<PMRPDetailInfo> detailDatas = null;
        while (this.materialDataUtil.hasNextStatisticData(period, materialDataInfo.getMaterialID(), null, null)) {
            BigDecimal pab;
            materialStatisticsInfo = this.materialDataUtil.getNextStatisticData(period, materialDataInfo.getMaterialID(), null, null);
            detailDatas = this.materialDataUtil.getOneMaterialDetialData(period, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), materialStatisticsInfo.getSeq());
            if (detailDatas == null || detailDatas.size() == 0) continue;
            if (this.onHandMap == null) {
                this.onHandMap = this.materialDataUtil.getIsolatorOnhandDetail();
            }
            if ((pab = materialStatisticsInfo.getRQty().add(materialStatisticsInfo.getSQty())).compareTo(MRPConstant.ZERO) > 0) {
                this.dealSupplyOneByOne(detailDatas, materialStatisticsInfo.getRQty());
                continue;
            }
            this.dealReqOneByOne(detailDatas, materialStatisticsInfo.getSQty());
        }
    }

    @Override
    protected PMRPDetailInfo getNextMergeRequire(String planStrategy, List<PMRPDetailInfo> detailDatas, IsolatedRuleEnum isolateRule) {
        PMRPDetailInfo newDetailInfo;
        PMRPDetailInfo detailInfo;
        PMRPDetailInfo lastDetailInfo = detailInfo = detailDatas.get(0);
        boolean isDirectTransport = detailInfo.isDirectTransport();
        BigDecimal rqty = MRPConstant.ZERO;
        int group = detailInfo.getPriority();
        Iterator<PMRPDetailInfo> iterator = detailDatas.iterator();
        if ("qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(planStrategy) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(planStrategy) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(planStrategy)) {
            boolean isCanNotThrow = detailInfo.isCanNotThrow();
            while (iterator.hasNext()) {
                detailInfo = iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority() && isCanNotThrow == detailInfo.isCanNotThrow()) {
                    rqty = rqty.add(detailInfo.getSurplusQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        } else {
            while (iterator.hasNext()) {
                detailInfo = iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority()) {
                    rqty = rqty.add(detailInfo.getSurplusQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
        if (this.isNotProjectNoIsolation(planStrategy, newDetailInfo = (PMRPDetailInfo)lastDetailInfo.clone())) {
            newDetailInfo.setBProjectID(null);
            newDetailInfo.setBProjectNumber(null);
        }
        if (this.isNotTrackNoIsolation(planStrategy, isolateRule, newDetailInfo)) {
            newDetailInfo.setBTrackID(null);
            newDetailInfo.setBTrackNumber(null);
        }
        newDetailInfo.setDirectTransport(isDirectTransport);
        newDetailInfo.setDependentQty(rqty);
        newDetailInfo.setIndependentQty(MRPConstant.ZERO);
        newDetailInfo.setNetReqQty(rqty);
        return newDetailInfo;
    }

    private void dealReqOneByOne(List<PMRPDetailInfo> detailDatas, BigDecimal supplyQty) throws PMRPException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            PMRPDetailInfo detailInfo = detailDatas.get(i);
            BigDecimal reqQty = detailInfo.getIndependentQty().add(detailInfo.getDependentQty());
            if (reqQty.compareTo(MRPConstant.ZERO) < 0) {
                if ((supplyQty = supplyQty.add(reqQty)).compareTo(MRPConstant.ZERO) >= 0) continue;
                detailInfo.setSurplusQty(supplyQty);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"37_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"38_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqQty + "\u3002"));
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                supplyQty = MRPConstant.ZERO;
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"39_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + "\u3002"));
        }
    }

    private void dealSupplyOneByOne(List<PMRPDetailInfo> detailDatas, BigDecimal reqQty) throws PMRPException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            PMRPDetailInfo detailInfo = detailDatas.get(i);
            BigDecimal supplyQty = detailInfo.getScheduledReceiptQty().add(detailInfo.getAllocationQty());
            if (supplyQty.compareTo(MRPConstant.ZERO) > 0) {
                if ((reqQty = reqQty.add(supplyQty)).compareTo(MRPConstant.ZERO) <= 0) continue;
                detailInfo.setSurplusQty(reqQty);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"37_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"40_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqQty + "\u3002"));
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                reqQty = MRPConstant.ZERO;
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"41_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + "\u3002"));
        }
    }

    private void doSplitStock(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, PMRPDetailInfo onhandDetail, BigDecimal splitQty) throws PMRPException, BOSException {
        PMRPDate billDate = this.runParam.getUtilManager().getCalendarUtil(this.runParam.getStorageOrgUnitID()).getDate(statisticsInfo.getPeriod());
        PMRPDetailInfo onhandDetailCopy = (PMRPDetailInfo)onhandDetail.clone();
        onhandDetailCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        onhandDetailCopy.setMrpItem(PMRPElementEnum.I_DivertInv);
        onhandDetailCopy.setRePlanDATE(billDate);
        onhandDetailCopy.setProjectNumber(statisticsInfo.getProjectNumber());
        onhandDetailCopy.setTrackNumber(statisticsInfo.getTrackNumber());
        onhandDetailCopy.setProjectID(statisticsInfo.getProjectId());
        onhandDetailCopy.setTrackID(statisticsInfo.getTrackNumberId());
        onhandDetailCopy.setBProjectID(onhandDetail.getProjectID());
        onhandDetailCopy.setBProjectNumber(onhandDetail.getProjectNumber());
        onhandDetailCopy.setBTrackID(onhandDetail.getTrackID());
        onhandDetailCopy.setBTrackNumber(onhandDetail.getTrackNumber());
        if (onhandDetailCopy.getTrackNumber() == null) {
            onhandDetailCopy.setIsDeaultTNO(1);
        } else {
            onhandDetailCopy.setIsDeaultTNO(2);
        }
        onhandDetailCopy.setPeriod(statisticsInfo.getPeriod());
        onhandDetailCopy.setBillDate(billDate);
        onhandDetailCopy.setSperiod(onhandDetail.getPeriod());
        onhandDetailCopy.setSID(onhandDetail.getID());
        onhandDetailCopy.setAjustQty(splitQty);
        onhandDetailCopy.setAjustFlag(8);
        this.runParam.getUtilManager().getExceptionUtil().setException(onhandDetailCopy, 80);
        this.generateException(materialDataInfo);
        onhandDetailCopy.setMrpSeq(PMRPAjustMent.getMRPSeq(onhandDetailCopy));
        onhandDetailCopy.setAvaliableQty(splitQty);
        onhandDetailCopy.setScheduledReceiptQty(splitQty);
        onhandDetailCopy.setNewOrder(false);
        onhandDetailCopy.setNetReqQty(MRPConstant.ZERO);
        this.dataSaver.addInsertList(onhandDetailCopy);
        onhandDetail.setHasSplit(true);
        onhandDetail.setAvaliableQty(onhandDetail.getAvaliableQty().subtract(splitQty));
        onhandDetail.setAjustQty(onhandDetail.getAjustQty().add(splitQty));
        onhandDetail.setNetReqQty(onhandDetail.getNetReqQty().subtract(splitQty));
        this.dataSaver.addUpdateList4Split(onhandDetail);
    }

    private void dealSurplusReq(String materialID) throws PMRPException, BOSException {
        this.reqMaterialDataUtil.setMaterialId(materialID);
        int[] reqPeriods = this.reqMaterialDataUtil.getCalcPeriod();
        this.reqMaterialDataUtil.clearSeq();
        for (int j = 0; j < reqPeriods.length; ++j) {
            int period = reqPeriods[j];
            while (this.reqMaterialDataUtil.hasNextStatisticData(period, materialID, null, null)) {
                PMRPMaterialStatisticsInfo reqMaterialStatisticsInfo = this.reqMaterialDataUtil.getNextStatisticData(period, materialID, null, null);
                List<PMRPDetailInfo> reqDetailDatas = this.reqMaterialDataUtil.getOneMaterialDetialData(reqMaterialStatisticsInfo.getPeriod(), materialID, reqMaterialStatisticsInfo.getProjectNumber(), reqMaterialStatisticsInfo.getTrackNumber(), reqMaterialStatisticsInfo.getSeq());
                if (reqDetailDatas == null || reqDetailDatas.size() == 0) continue;
                PMRPMaterialDataInfo materialDataInfo = this.reqMaterialDataUtil.getMaterialInfo(materialID, reqMaterialStatisticsInfo.getSupplyOrgUnitID());
                this.dealOnePeriodSurplusReq(materialDataInfo, reqMaterialStatisticsInfo, reqDetailDatas);
            }
            this.dataSaver.execute(true);
        }
    }

    private void dealOnePeriodSurplusReq(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, List<PMRPDetailInfo> detailDatas) throws PMRPException, BOSException {
        if (materialDataInfo.getBatchPolicy() == 1 || materialDataInfo.getBatchPolicy() == 2) {
            if (this.isMerge(materialDataInfo)) {
                while (detailDatas.size() > 0) {
                    PMRPDetailInfo detailInfo = this.getNextMergeRequire(materialDataInfo.getPlanStrategy(), detailDatas, materialDataInfo.getIsolatedRule());
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"42_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                    this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
                }
            } else {
                int n = detailDatas.size();
                for (int i = 0; i < n; ++i) {
                    PMRPDetailInfo detailInfo = detailDatas.get(i);
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"43_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                    this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
                }
            }
        } else {
            int n = detailDatas.size();
            for (int i = 0; i < n; ++i) {
                PMRPDetailInfo detailInfo = detailDatas.get(i);
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"43_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getNetReqQty() + "\u3002"));
                this.batchCal(materialDataInfo, statisticsInfo.getPeriod(), detailInfo.getNetReqQty(), detailInfo.getNetReqQty(), false, detailInfo.getNetReqQty(), detailInfo, true);
            }
        }
    }

    private void dealSurplusSupply(String materialID) throws PMRPException, BOSException {
        this.supplyMaterialDataUtil.setMaterialId(materialID);
        int[] supplyPeriods = this.supplyMaterialDataUtil.getCalcPeriod();
        this.supplyMaterialDataUtil.clearSeq();
        for (int j = 0; j < supplyPeriods.length; ++j) {
            int period = supplyPeriods[j];
            while (this.supplyMaterialDataUtil.hasNextStatisticData(period, materialID, null, null)) {
                PMRPMaterialStatisticsInfo supplyMaterialStatisticsInfo = this.supplyMaterialDataUtil.getNextStatisticData(period, materialID, null, null);
                List<PMRPDetailInfo> supplyDetailDatas = this.supplyMaterialDataUtil.getOneMaterialDetialData(supplyMaterialStatisticsInfo.getPeriod(), materialID, supplyMaterialStatisticsInfo.getProjectNumber(), supplyMaterialStatisticsInfo.getTrackNumber(), supplyMaterialStatisticsInfo.getSeq());
                if (supplyDetailDatas == null || supplyDetailDatas.size() == 0) continue;
                PMRPMaterialDataInfo materialDataInfo = this.supplyMaterialDataUtil.getMaterialInfo(materialID, supplyMaterialStatisticsInfo.getSupplyOrgUnitID());
                this.dealOnePeriodSurplusSupply(materialDataInfo, supplyMaterialStatisticsInfo, supplyDetailDatas);
            }
            this.dataSaver.execute(true);
        }
    }

    private void dealOnePeriodSurplusSupply(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo supplyMaterialStatisticsInfo, List<PMRPDetailInfo> detailDatas) throws PMRPException, BOSException {
        for (int i = 0; i < detailDatas.size(); ++i) {
            PMRPDetailInfo detailInfo = detailDatas.get(i);
            BigDecimal needDelayQty = this.calcCancelQty(materialDataInfo, detailInfo, detailInfo.getNetReqQty());
            if (needDelayQty.compareTo(MRPConstant.ZERO) <= 0) continue;
            if (needDelayQty.compareTo(detailInfo.getNetReqQty()) <= 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"44_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + needDelayQty + "\u3002"));
                PMRPDetailInfo detailInfoCopy = (PMRPDetailInfo)detailInfo.clone();
                detailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
                detailInfoCopy.setSperiod(detailInfo.getPeriod());
                detailInfoCopy.setPeriod(this.runParam.getDateManager().getEndDate(detailInfo.getOrgUnitID()).getWorkDaySeqID());
                if (this.runParam.getUtilManager().getExceptionUtil().setException(detailInfoCopy, 62)) {
                    this.statisticException(materialDataInfo);
                }
                detailInfoCopy.setRePlanDATE(null);
                detailInfoCopy.setSID(detailInfo.getID());
                detailInfoCopy.setAjustQty(needDelayQty);
                detailInfoCopy.setScheduledReceiptQty(needDelayQty);
                detailInfoCopy.setNetReqQty(MRPConstant.ZERO);
                detailInfoCopy.setAjustFlag(4);
                detailInfoCopy.setPriority(99999);
                detailInfoCopy.setMrpSeq(PMRPAjustMent.getMRPSeq(detailInfoCopy));
                this.dataSaver.addInsertList(detailInfoCopy);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                detailInfo.setScheduledReceiptQty(detailInfo.getScheduledReceiptQty().subtract(needDelayQty));
                detailInfo.setNetReqQty(MRPConstant.ZERO);
                detailInfo.setHasSplit(true);
                this.dataSaver.addUpdateList4Split(detailInfo);
                continue;
            }
            logger.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"45_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()));
        }
    }

    private void doSurplusQtyDivert(String materialID, boolean isCross) throws PMRPException, BOSException {
        this.reqMaterialDataUtil.setMaterialId(materialID);
        int[] reqPeriods = this.reqMaterialDataUtil.getCalcPeriod();
        this.reqMaterialDataUtil.clearSeq();
        for (int j = 0; j < reqPeriods.length; ++j) {
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"46_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"47_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqPeriods[j] + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"48_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"47_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqPeriods[j] + "\u3002"));
            }
            int period = reqPeriods[j];
            this.oneDayDivert(materialID, period, isCross);
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"49_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"50_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale())));
                continue;
            }
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"51_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"50_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale())));
        }
    }

    private void oneDayDivert(String materialID, int period, boolean isCross) throws BOSException, PMRPException {
        PMRPMaterialStatisticsInfo reqMaterialStatisticsInfo = null;
        PMRPMaterialStatisticsInfo supplyMaterialStatisticsInfo = null;
        List<PMRPDetailInfo> reqDetailDatas = null;
        List<PMRPDetailInfo> supplyDetailDatas = null;
        BigDecimal pab = MRPConstant.ZERO;
        String projectNumber = null;
        String trackNumber = null;
        ArrayList<PMRPDetailInfo> divertList = new ArrayList<PMRPDetailInfo>();
        while (this.reqMaterialDataUtil.hasNextStatisticData(period, materialID, null, null)) {
            reqMaterialStatisticsInfo = this.reqMaterialDataUtil.getNextStatisticData(period, materialID, null, null);
            PMRPMaterialDataInfo materialDataInfo = this.reqMaterialDataUtil.getMaterialInfo(materialID, reqMaterialStatisticsInfo.getSupplyOrgUnitID());
            reqDetailDatas = this.reqMaterialDataUtil.getOneMaterialDetialData(period, materialDataInfo.getMaterialID(), reqMaterialStatisticsInfo.getProjectNumber(), reqMaterialStatisticsInfo.getTrackNumber(), reqMaterialStatisticsInfo.getSeq());
            if (reqDetailDatas == null || reqDetailDatas.size() == 0) continue;
            BigDecimal reqQty = reqMaterialStatisticsInfo.getSurplusQty();
            if (Constants.MRPConfig.ISINVENTORYFIRST) {
                reqQty = this.dealDiverStock(materialDataInfo, reqMaterialStatisticsInfo, reqQty, isCross);
            }
            if (reqQty.compareTo(MRPConstant.ZERO) < 0) {
                this.supplyMaterialDataUtil.setMaterialId(materialDataInfo.getMaterialID());
                this.supplyMaterialDataUtil.clearSeq();
                if (!isCross) {
                    projectNumber = reqMaterialStatisticsInfo.getProjectNumber();
                    trackNumber = reqMaterialStatisticsInfo.getTrackNumber();
                }
                while (this.supplyMaterialDataUtil.hasNextStatisticData(period, materialDataInfo.getMaterialID(), projectNumber, trackNumber)) {
                    supplyMaterialStatisticsInfo = this.supplyMaterialDataUtil.getNextStatisticData(period, materialDataInfo.getMaterialID(), projectNumber, trackNumber);
                    supplyDetailDatas = this.supplyMaterialDataUtil.getOneMaterialDetialData(supplyMaterialStatisticsInfo.getPeriod(), materialDataInfo.getMaterialID(), supplyMaterialStatisticsInfo.getProjectNumber(), supplyMaterialStatisticsInfo.getTrackNumber(), supplyMaterialStatisticsInfo.getSeq());
                    if (supplyDetailDatas == null || supplyDetailDatas.size() == 0) continue;
                    pab = supplyMaterialStatisticsInfo.getSurplusQty().add(reqQty);
                    if (pab.compareTo(MRPConstant.ZERO) < 0) {
                        divertList.addAll(supplyDetailDatas);
                        reqQty = pab;
                        supplyMaterialStatisticsInfo.setSurplusQty(MRPConstant.ZERO);
                        this.dataSaver.addUpdateSurplusQtyList(supplyMaterialStatisticsInfo);
                        continue;
                    }
                    int n = supplyDetailDatas.size();
                    for (int i = 0; i < n; ++i) {
                        PMRPDetailInfo supplyDetailInfo = supplyDetailDatas.get(i);
                        divertList.add(supplyDetailInfo);
                        reqQty = reqQty.add(supplyDetailInfo.getSurplusQty());
                        if (reqQty.compareTo(MRPConstant.ZERO) >= 0) break;
                    }
                    supplyMaterialStatisticsInfo.setSurplusQty(pab);
                    this.dataSaver.addUpdateSurplusQtyList(supplyMaterialStatisticsInfo);
                    break;
                }
            }
            if (!Constants.MRPConfig.ISINVENTORYFIRST) {
                reqQty = this.dealDiverStock(materialDataInfo, reqMaterialStatisticsInfo, reqQty, isCross);
            }
            reqMaterialStatisticsInfo.setSurplusQty(reqQty.compareTo(MRPConstant.ZERO) > 0 ? MRPConstant.ZERO : reqQty);
            this.dataSaver.addUpdateSurplusQtyList(reqMaterialStatisticsInfo);
            this.dealDivertReq(reqDetailDatas, reqQty, isCross);
            if (divertList != null && divertList.size() > 0) {
                this.dealDivertSupply(materialDataInfo, reqMaterialStatisticsInfo, divertList, reqQty, isCross);
                divertList.clear();
            }
            this.dataSaver.execute(true);
        }
    }

    private BigDecimal dealDiverStock(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo reqMaterialStatisticsInfo, BigDecimal reqQty, boolean isCross) throws PMRPException, BOSException {
        if (reqQty.compareTo(MRPConstant.ZERO) >= 0) {
            return reqQty;
        }
        BigDecimal safeStock = this.runParam.getRunLog().getPlanDefined().isIsCalcSafeInv() ? materialDataInfo.getSafeStockQty() : MRPConstant.ZERO;
        for (Map.Entry<String, PMRPDetailInfo> entry : this.onHandMap.entrySet()) {
            PMRPDetailInfo onhandDetail;
            BigDecimal onHandQty;
            BigDecimal onHand;
            String key = reqMaterialStatisticsInfo.getProjectNumber() + reqMaterialStatisticsInfo.getTrackNumber();
            if (!isCross && !key.equals(entry.getKey()) || (onHand = (onHandQty = (onhandDetail = this.onHandMap.get(entry.getKey())).getNetReqQty()).compareTo(safeStock) >= 0 ? onHandQty.subtract(safeStock) : MRPConstant.ZERO).compareTo(MRPConstant.ZERO) == 0) continue;
            BigDecimal pab = onHand.add(reqQty);
            if (pab.compareTo(MRPConstant.ZERO) >= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"52_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqQty + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + onHandQty.add(reqQty) + "\u3002"));
                    this.doSplitStock(materialDataInfo, reqMaterialStatisticsInfo, onhandDetail, reqQty.abs());
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"54_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + reqQty + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + onHandQty.add(reqQty) + "\u3002"));
                    onhandDetail.setNetReqQty(onHandQty.add(reqQty));
                }
                reqQty = MRPConstant.ZERO;
                break;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"52_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + onHand + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + safeStock + "\u3002"));
                this.doSplitStock(materialDataInfo, reqMaterialStatisticsInfo, onhandDetail, onHand);
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"54_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + onHand + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"53_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + safeStock + "\u3002"));
                onhandDetail.setNetReqQty(safeStock);
            }
            reqQty = pab;
        }
        return reqQty;
    }

    private void dealDivertReq(List<PMRPDetailInfo> detailDatas, BigDecimal surplusQty, boolean isCross) throws PMRPException, BOSException {
        for (int i = detailDatas.size() - 1; i >= 0; --i) {
            PMRPDetailInfo detailInfo = detailDatas.get(i);
            if (surplusQty.compareTo(MRPConstant.ZERO) >= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"55_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"57_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                }
                detailInfo.setSurplusQty(MRPConstant.ZERO);
                this.dataSaver.addUpdateDetailNetReqList(detailInfo);
                continue;
            }
            if (surplusQty.compareTo(detailInfo.getSurplusQty()) <= 0) {
                surplusQty = surplusQty.subtract(detailInfo.getSurplusQty());
                continue;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"58_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + surplusQty + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"60_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + surplusQty + "\u3002"));
            }
            detailInfo.setSurplusQty(surplusQty);
            this.dataSaver.addUpdateDetailNetReqList(detailInfo);
            surplusQty = MRPConstant.ZERO;
        }
    }

    private void dealDivertSupply(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, List<PMRPDetailInfo> detailDatas, BigDecimal surplusQty, boolean isCross) throws PMRPException, BOSException {
        for (int i = detailDatas.size() - 1; i >= 0; --i) {
            PMRPDetailInfo detailInfo = detailDatas.get(i);
            if (surplusQty.compareTo(MRPConstant.ZERO) <= 0) {
                if (isCross) {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"61_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                } else {
                    logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"62_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty() + "\u3002"));
                }
                this.doPartAdjust(materialDataInfo, statisticsInfo, detailInfo, detailInfo.getSurplusQty());
                continue;
            }
            if (surplusQty.compareTo(detailInfo.getSurplusQty()) > 0) {
                surplusQty = surplusQty.subtract(detailInfo.getSurplusQty());
                continue;
            }
            if (isCross) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"63_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + surplusQty + "\u3002"));
            } else {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"64_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getBillNumber() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"56_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + detailInfo.getSurplusQty().subtract(surplusQty) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"59_MRPSurplusDivertAjustMent", (Locale)this.runParam.getEasCtx().getLocale()) + surplusQty + "\u3002"));
            }
            this.doPartAdjust(materialDataInfo, statisticsInfo, detailInfo, detailInfo.getSurplusQty().subtract(surplusQty));
            surplusQty = MRPConstant.ZERO;
        }
    }

    private void doPartAdjust(PMRPMaterialDataInfo materialDataInfo, PMRPMaterialStatisticsInfo statisticsInfo, PMRPDetailInfo detailInfo, BigDecimal adjustQty) throws BOSException, PMRPException {
        PMRPDate billDate = this.runParam.getUtilManager().getCalendarUtil(detailInfo.getOrgUnitID()).getDate(statisticsInfo.getPeriod());
        PMRPDetailInfo detailInfoCopy = (PMRPDetailInfo)detailInfo.clone();
        detailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        detailInfoCopy.setRePlanDATE(billDate);
        detailInfoCopy.setProjectNumber(statisticsInfo.getProjectNumber());
        detailInfoCopy.setTrackNumber(statisticsInfo.getTrackNumber());
        detailInfoCopy.setProjectID(statisticsInfo.getProjectId());
        detailInfoCopy.setTrackID(statisticsInfo.getTrackNumberId());
        detailInfoCopy.setBProjectID(statisticsInfo.getProjectId());
        detailInfoCopy.setBProjectNumber(statisticsInfo.getProjectNumber());
        detailInfoCopy.setBTrackID(statisticsInfo.getTrackNumberId());
        detailInfoCopy.setBTrackNumber(statisticsInfo.getTrackNumber());
        if (detailInfoCopy.getTrackNumber() == null) {
            detailInfoCopy.setIsDeaultTNO(1);
        } else {
            detailInfoCopy.setIsDeaultTNO(2);
        }
        detailInfoCopy.setPeriod(statisticsInfo.getPeriod());
        detailInfoCopy.setBillDate(billDate);
        detailInfoCopy.setSperiod(detailInfo.getPeriod());
        detailInfoCopy.setSID(detailInfo.getID());
        detailInfoCopy.setAjustQty(MRPConstant.ZERO);
        int ajustValue = this.getAdjustType(statisticsInfo, detailInfo);
        detailInfoCopy.setAjustFlag(ajustValue);
        this.addException4DetailInfo(materialDataInfo, detailInfoCopy);
        detailInfoCopy.setMrpSeq(PMRPAjustMent.getMRPSeq(detailInfoCopy));
        detailInfoCopy.setHasSplit(true);
        detailInfoCopy.setScheduledReceiptQty(adjustQty);
        detailInfoCopy.setAjustQty(adjustQty);
        detailInfoCopy.setSurplusQty(MRPConstant.ZERO);
        detailInfoCopy.setNetReqQty(MRPConstant.ZERO);
        detailInfoCopy.setNewOrder(false);
        this.dataSaver.addInsertList(detailInfoCopy);
        detailInfo.setHasSplit(true);
        detailInfo.setSurplusQty(detailInfo.getSurplusQty().subtract(adjustQty));
        detailInfo.setScheduledReceiptQty(detailInfo.getScheduledReceiptQty().subtract(adjustQty));
        detailInfo.setNetReqQty(detailInfo.getSurplusQty());
        this.dataSaver.addUpdateList4Split(detailInfo);
    }

    private int getAdjustType(PMRPMaterialStatisticsInfo statisticsInfo, PMRPDetailInfo detailInfo) {
        int ajustValue = 0;
        if (statisticsInfo.getProjectNumber().equals(detailInfo.getProjectNumber()) && statisticsInfo.getTrackNumber().equals(detailInfo.getTrackNumber())) {
            if (detailInfo.getPeriod() < statisticsInfo.getPeriod()) {
                ajustValue = statisticsInfo.getPeriod() - detailInfo.getPeriod() <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt() ? 5 : 3;
            } else if (detailInfo.getPeriod() > statisticsInfo.getPeriod()) {
                ajustValue = detailInfo.getPeriod() - statisticsInfo.getPeriod() <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt() ? 1 : 2;
            }
        } else {
            ajustValue = detailInfo.getPeriod() < statisticsInfo.getPeriod() ? (statisticsInfo.getPeriod() - detailInfo.getPeriod() <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt() ? 9 : 11) : (detailInfo.getPeriod() > statisticsInfo.getPeriod() ? (detailInfo.getPeriod() - statisticsInfo.getPeriod() <= this.runParam.getRunLog().getPlanDefined().getTolerOfDisplacemt() ? 9 : 10) : 9);
        }
        return ajustValue;
    }

    private void addException4DetailInfo(PMRPMaterialDataInfo materialDataInfo, PMRPDetailInfo detailInfo) throws BOSException {
        int ajustValue = detailInfo.getAjustFlag();
        if (ajustValue == 3) {
            this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 61);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 2) {
            this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 60);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 9) {
            this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 81);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 11) {
            this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 83);
            this.generateException(materialDataInfo);
        }
        if (ajustValue == 10) {
            this.runParam.getUtilManager().getExceptionUtil().setException(detailInfo, 82);
            this.generateException(materialDataInfo);
        }
    }

    private void generateException(PMRPMaterialDataInfo materialDataInfo) {
        if (!this.materialException.contains(materialDataInfo.getMaterialID())) {
            this.materialException.add(materialDataInfo.getMaterialID());
            if (this.isContainMaterial(materialDataInfo)) {
                this.runParam.getCounter().generateException();
            }
        }
    }
}

