/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.supply;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.industry.emm.project.biz.basedata.MergeDimensionEnum;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPBillParamInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.supply.PMRPGetData;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.FactoryCalendarDateHelperTableDefine;
import com.kingdee.eas.util.ResourceBase;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class PMRPGetPlanOrder
extends PMRPGetData {
    public PMRPGetPlanOrder(PMRPBillParamInfo info) {
        super(info);
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_GETPLANORDER");
    }

    @Override
    protected Object getBillDataSQL(PMRPCalcParam runParam, StringBuffer sqlBuf, List<Object> paramList) throws BOSException, PMRPException {
        PlanDefinedInfo pdInfo = runParam.getRunLog().getPlanDefined();
        PurRelationshipDefinitionInfo purinfo = pdInfo.getPurchaseRelation();
        IPMRPTableDefine fchTable = runParam.getTableManager().getTempTableDefine(FactoryCalendarDateHelperTableDefine.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String thisDate = df.format(runParam.getDateManager().getPlanDate(runParam.getStorageOrgUnitID()).getDate().getTime());
        String endDate = df.format(runParam.getDateManager().getEndDateOutLook(runParam.getStorageOrgUnitID()).getDate().getTime());
        String beginDate = df.format(runParam.getDateManager().getBeginDateRequire(runParam.getStorageOrgUnitID()).getDate().getTime());
        sqlBuf.setLength(0);
        sqlBuf.append(this.getInsert()).append("(").append("FID").append(",FPlanVersionID").append(",FRunLogID").append(",FPlanningMode").append(",FMaterialID").append(",FMRPClassify").append(",FMRPItem").append(",FBillID").append(",FBillType").append(",FBizTypeID").append(",FBillNumber").append(",FBillSeqNo").append(",FWorkDaySeqID").append(",FBillDate").append(",FSR").append(",FSSR").append(",FPlanBeginDate").append(",FPlanEndDate").append(",FSupplyOrgUnitID").append(",FProjectID").append(",FTrackID").append(",FProjectNumber").append(",FTrackNumber").append(",FBProjectID").append(",FBTrackID").append(",FBProjectNumber").append(",FBTrackNumber").append(",FIsDefaultTNO").append(",FPeriod").append(",FRePlanDATE").append(",FIsAjust").append(",FPriority").append(",FBaseStatus").append(",FOrgUnitID").append(",FPurChaseOrgUnitID").append(",FMaterialAttr").append(",FLowsetCode").append(",FIsSurplusDivert").append(",FPlanStrategy").append(",FIsolatedRule").append(",fsourceremark").append(")\r\n").append("Select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("')").append(",'").append(runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(runParam.getRunLog().getId()).append("'").append(",mp.Fplanningmode").append(",bill.FMaterialID").append(",").append(20).append(",").append(250).append(",").append("bill.FID").append(",'").append(Constants.PRMPPlannedOrderBizTypeID).append("'").append(",").append("bill.FBizTypeID").append(",bill.FNumber").append(",").append(250).append(",").append("-1");
        if (pdInfo.getMergeDimension() != null && pdInfo.getMergeDimension().equals((Object)MergeDimensionEnum.ByReqDate)) {
            sqlBuf.append(",to_date(to_char(bill.FAvilableDate,'yyyy-mm-dd')||' 00:00:00') ");
        } else {
            sqlBuf.append(" ,isnull(fch.FPlanDate, to_date('" + thisDate + "'||' 00:00:00'))");
        }
        sqlBuf.append(",").append(this.getFSRStr(false)).append(" fsr").append(",").append(this.getFSRStr(false)).append(" fssr");
        if (pdInfo.getMergeDimension() != null && pdInfo.getMergeDimension().equals((Object)MergeDimensionEnum.ByReqDate)) {
            sqlBuf.append(",to_date(to_char(bill.FStartDate,'yyyy-mm-dd')||' 00:00:00')");
            sqlBuf.append(",to_date(to_char(bill.FEndDate,'yyyy-mm-dd')||' 00:00:00')");
        } else {
            sqlBuf.append(" ,isnull(fch.FPlanDate, to_date('" + thisDate + "'||' 00:00:00'))");
            sqlBuf.append(" ,isnull(fch.FPlanDate, to_date('" + thisDate + "'||' 00:00:00'))");
        }
        sqlBuf.append(",bill.FProductionOrgUnitID").append(runParam.getProjectNoAndTrackNoJoint(runParam, "mp.Fmanufacturestrategyid", "mp.FIsolatedRule", "mp.Fmaterialattr", "P.FID", "T.Fid", "P.FNUMBER", "T.FNUMBER")).append(",-1").append(",to_date(to_char(bill.FAvilableDate,'yyyy-mm-dd')||' 00:00:00')").append(",").append(this.isAdjust()).append(",").append(this.getPriority()).append(",bill.FBaseStatus").append(",bill.Fstorageorgunitid").append(",null As FPurChaseOrgUnitID ").append(",mp.Fmaterialattr As FMaterialAttr ").append(",99 As FLowsetCode").append(",ISNULL(mp.FIsMargin, 0)").append(",mp.Fmanufacturestrategyid").append(",mp.FIsolatedRule").append(",'PMRPGetPlanOrder-").append(ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"PROJECT_QJHDDBT", (Locale)runParam.getEasCtx().getLocale())).append("'").append(" from ").append(Constants.TableName.MRP_PLAN_ORDER_TABLE).append(" as bill").append(" inner join t_bd_materialPlan mp on mp.Fmaterialid = bill.fmaterialid and mp.Forgunit = bill.Fstorageorgunitid and mp.fstatus = 1  ").append(" Left join T_MM_TrackNumber T on bill.FTrackID = T.FID").append(" Left join T_MM_Project P on bill.FProjectID = P.FID").append(" left outer join ").append(fchTable.getTableName()).append(" fch on fch.FStorageOrgUnitID = bill.Fstorageorgunitid").append(" where bill.FPlanOrgUnitID = ?").append(" And bill.FIsSimulant=0").append(" and bill.FBaseStatus = 4").append(runParam.getStorageOrgUnitWhereSql("bill.FStorageOrgUnitID")).append(" and bill.FAvilableDate between fch.FBeginDateSupply and fch.FEndDateOutLook ").append(" and ").append(this.getFSRStr(true)).append(" > 0");
        sqlBuf.append(runParam.getProjectTrackWhereSql("p", "t"));
        sqlBuf.append(runParam.getMaterialWhereSql("mp"));
        paramList.add(runParam.getRunLog().getPlanDefined().getPlanOrgUnit().getId().toString());
        return new Integer(this.dataAmount);
    }

    private String getFSRStr(boolean forFilter) {
        StringBuffer sql = new StringBuffer();
        if (Constants.MRPConfig.ISYIELDPRODUCT) {
            sql.append("to_decimal(to_decimal(floor(to_decimal( ");
            if (forFilter) {
                sql.append("(bill.FQty-bill.FTotalReleaseQty)").append("* to_decimal((bill.FFinalProductsrate / 100),6,2)").append(",21,8) ").append("* power(10,mm.FProdQtyPrc)),31,1) / to_decimal(power(10,mm.FProdQtyPrc),12,1),21,8)");
            } else {
                sql.append("(bill.FBaseQty-bill.FBaseTotalReleaseQty)").append("* to_decimal((bill.FFinalProductsrate / 100),6,2)").append(",21,8) ").append("* power(10,mm.FBaseQtyPrc)),31,1) / to_decimal(power(10,mm.FBaseQtyPrc),12,1),21,8)");
            }
        } else {
            sql.append("(bill.FBaseQty-bill.FBaseTotalReleaseQty)");
        }
        return sql.toString();
    }
}

