/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.AbstractPurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.runner.impl.PMRPRunner4PSP;
import com.kingdee.eas.industry.emm.project.biz.psp.IPspStockPlanMiddle;
import com.kingdee.eas.industry.emm.project.biz.psp.IPspStockingDemand;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlan;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlanPurOrder;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeState;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeType;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockPlanMiddleCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockPlanMiddleFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockPlanMiddleInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanPurOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanPurOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanPurOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.TrialOpeScheme;
import com.kingdee.eas.industry.emm.project.biz.psp.app.AbstractPspStockingMakingControllerBean;
import com.kingdee.eas.industry.emm.project.biz.psp.app.PspDemand;
import com.kingdee.eas.industry.emm.project.biz.psp.app.PspInventoryInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.app.PspProjectInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.util.PspParameterSet;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PspStockingMakingControllerBean
extends AbstractPspStockingMakingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.psp.app.PspStockingMakingControllerBean");
    private PspParameterSet pspParams = new PspParameterSet();
    private static UserInfo userInfo = null;
    private static Map<String, List<PspInventoryInfo>> inventoryMap = new HashMap<String, List<PspInventoryInfo>>();
    private static Map<String, List<PspInventoryInfo>> mapSupplyRelation = new HashMap<String, List<PspInventoryInfo>>();
    private static List listStorageOrgIdByProduct;
    private static List listStorageOrgIdBySupply;
    private static String planOrgUnitId;
    static final String SOLATEDRULE_NONE = "NONE";
    static final String SOLATEDRULE_ITEM = "ITEM";
    static final String SOLATEDRULE_ITEMTRACK = "ITEM_TRACKNO";
    static final String SOLATEDRULE = "FISOLATEDRULE";
    static final String MergeMaterialReqDate = "MergeMaterialReqDate";
    static final String EARLIEST = "0";
    static final String LATEST = "1";
    static final String INVENTORY = "INVENTORY";
    static final String PROJECTID = "PROJECTID";
    static final String TRACKID = "TRACKID";
    static final String ORGID = "ORGID";
    static final String MATERIALID = "MATERIALID";
    static final String ISSOLATERULE = "ISSOLATERULE";
    static final String QTY = "QTY";
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.project.biz.psp.PSPGenrateResource";
    static final String queryInventory_itemtrack = "select fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,fprojectid,ftracknumberid,a.fstoretypeid,a.fstorestatusid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  left join (select cfsupplyorgunitid,FStoreTypeID,FStoreStateID,max(cfprioritylevel)as cfprioritylevel from CT_BAS_SupplyRDE  where fparentid=? group by cfsupplyorgunitid ,FStoreTypeID,FStoreStateID) sr  on sr.cfsupplyorgunitid = a.fstorageOrgunitid  where a.fmaterialid=?  and exists(select 1 from CT_BAS_SupplyRDE d where d.cfsupplyorgunitid = a.fstorageorgunitid and d.fparentid = ? )  and a.fprojectid=? and a.ftracknumberid=?  and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,fprojectid,ftracknumberid,a.fstoretypeid,a.fstorestatusid";
    static final String queryInventory_item = "select fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,fprojectid,a.fstoretypeid,a.fstorestatusid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  left join (select cfsupplyorgunitid,FStoreTypeID,FStoreStateID,max(cfprioritylevel)as cfprioritylevel from CT_BAS_SupplyRDE  where fparentid=? group by cfsupplyorgunitid, FStoreTypeID,FStoreStateID) sr  on sr.cfsupplyorgunitid = a.fstorageOrgunitid  where a.fmaterialid=?  and exists(select 1 from CT_BAS_SupplyRDE d where d.cfsupplyorgunitid = a.fstorageorgunitid and d.fparentid = ? )  and a.fprojectid=?   and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,fprojectid,a.fstoretypeid,a.fstorestatusid";
    static final String queryInventory = "select fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,a.fstoretypeid,a.fstorestatusid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  left join (select cfsupplyorgunitid,FStoreTypeID,FStoreStateID,max(cfprioritylevel)as cfprioritylevel from CT_BAS_SupplyRDE  where fparentid=? group by cfsupplyorgunitid,FStoreTypeID,FStoreStateID ) sr  on sr.cfsupplyorgunitid = a.fstorageOrgunitid  where a.fmaterialid=?  and exists(select 1 from CT_BAS_SupplyRDE d where d.cfsupplyorgunitid = a.fstorageorgunitid and d.fparentid = ? )  and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fwarehouseid,flocationid,sr.cfprioritylevel,a.fstoretypeid,a.fstorestatusid";

    @Override
    public void _generatePSP(Context ctx, PspParameterSet paramsSet) throws BOSException, EASBizException {
        this.checkParams(paramsSet);
        this.pspParams = paramsSet;
        this.handlePspList(ctx);
    }

    private void checkParams(PspParameterSet paramsSet) throws EASBizException {
        if (paramsSet == null) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label113"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label114")));
        }
        if (paramsSet.getPspOperationSchemeInfo() == null) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label113"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label115")));
        }
    }

    private void handlePspList(Context ctx) throws EASBizException {
        String tmpDemandTable;
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        StringBuffer log = new StringBuffer();
        try {
            tmpDemandTable = this.createTempStockingPlanDemand(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label183"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label183") + "\n" + e.getMessage()));
        }
        if (TrialOpeScheme.DEFAULTALG.equals((Object)this.pspParams.getPspOperationSchemeInfo().getTrialOpeScheme())) {
            try {
                startTime = System.currentTimeMillis();
                this.algorithmGenPSP(ctx);
                endTime = System.currentTimeMillis();
                log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label184", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label185"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label185") + "\n" + e.getMessage()));
            }
        }
        if (TrialOpeScheme.TEMPLATE.equals((Object)this.pspParams.getPspOperationSchemeInfo().getTrialOpeScheme())) {
            try {
                startTime = System.currentTimeMillis();
                this.templateGenPSD(ctx, tmpDemandTable);
                endTime = System.currentTimeMillis();
                log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label186", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label187"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label187") + "\n" + e.getMessage()));
            }
        }
        try {
            startTime = System.currentTimeMillis();
            this.handleBatchProject(ctx);
            endTime = System.currentTimeMillis();
            log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label188", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label189"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label189") + "\n" + e.getMessage()));
        }
        catch (PMRPException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label189"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label189") + "\n" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label189"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label189") + "\n" + e.getMessage()));
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update T_PSP_PspStockingDemand psd set FIssolateRule =    (select ISNULL(FIsolatedRule,'NONE') from T_BD_MaterialPlan mp  where psd.FMaterialID = mp.fmaterialid and mp.forgunit=psd.FProductOrgUnitID)");
        try {
            SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label190"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label190") + "\n" + e.getMessage()));
        }
        startTime = System.currentTimeMillis();
        try {
            IPspStockingDemand ipsd = PspStockingDemandFactory.getLocalInstance(ctx);
            PspStockingDemandCollection psdCol = ipsd.getPspStockingDemandCollection();
            if (psdCol != null && psdCol.size() > 0) {
                for (int i = 0; i < psdCol.size(); ++i) {
                    PspStockingDemandInfo info = psdCol.get(i);
                    if (info == null || info.getPurOrg() == null || info.getPurOrg().getId() == null) continue;
                    String storageorgid = this.getPurOrgFindStorageOrg(ctx, info.getPurOrg().getId().toString());
                    this.setBillNumber(ctx, (IObjectValue)info, storageorgid);
                    ipsd.save((CoreBaseInfo)info);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label191"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label191") + "\n" + e.getMessage()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label191"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label191") + "\n" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label191"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label191") + "\n" + e.getMessage()));
        }
        endTime = System.currentTimeMillis();
        log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label192", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        try {
            startTime = System.currentTimeMillis();
            this.matchingInventoryQty(ctx);
            endTime = System.currentTimeMillis();
            log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label193", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label194"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label194") + "\n" + e.getMessage()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label194"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label194") + "\n" + e.getMessage()));
        }
        try {
            startTime = System.currentTimeMillis();
            this.verifyMergerRuler(ctx);
            endTime = System.currentTimeMillis();
            log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label195", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            startTime = System.currentTimeMillis();
            this.mergeDemand2(ctx, tmpDemandTable);
            endTime = System.currentTimeMillis();
            log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label196", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label197"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label197") + "\n" + e.getMessage()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label197"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label197") + "\n" + e.getMessage()));
        }
        try {
            startTime = System.currentTimeMillis();
            this.genStockingPlan(ctx, LATEST, tmpDemandTable);
            endTime = System.currentTimeMillis();
            log.append(ResourceBase.getString((String)this.RESOURCE_NAME, (String)"label198", (Locale)ctx.getLocale(), (Object[])new String[]{Long.toString(endTime - startTime)}));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label199"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label199") + "\n" + e.getMessage()));
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpDemandTable);
        System.out.println(log.toString());
    }

    protected void verifyMergerRuler(Context ctx) throws EASBizException, BOSException, SQLException {
        PspOperationSchemeInfo osInfo = this.pspParams.getPspOperationSchemeInfo();
        PspMergingRulesInfo mrInfo = osInfo.getMergerRules();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select pdorgid ,tg.fname_l2,tg.fnumber from (  select pd.fproductorgunitid as pdorgid,pr.fproductionorgid as prorgid from t_psp_pspstockingdemand  pd   left join  T_PSP_PspMergingRulesEntry  pr   on pr.fparentid = '" + mrInfo.getId().toString() + "'  and pd.fproductorgunitid = pr.fproductionorgid)   left join t_org_storage tg on tg.fid = pdorgid  where prorgid is null  group by  pdorgid ,tg.fname_l2,tg.fnumber ");
        IRowSet rs = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
        if (IndustryUtils.isEmptyRowSet((IRowSet)rs)) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        while (rs.next()) {
            str.append("\t" + rs.getString("fname_l2") + "(" + rs.getString("fnumber") + ")\n");
        }
        if (str.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("401", EASResource.getString((String)this.RESOURCE_NAME, (String)"label200") + "\n" + str.toString()));
        }
    }

    protected void handleBatchProject(Context ctx) throws Exception {
        PMRPRunner4PSP psprun = new PMRPRunner4PSP(ctx);
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String tableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append(" insert into T_PSP_PspStockingDemand  ");
        sql.append(" (Fid,FProjectID,FMaterialID,FTrackNumberID,  FFinishTime,FCreatorID, ");
        sql.append(" FLastUpdateUserID,fleadtime,fpurorgid,fdemandqty,fAllocateqty,fmaterialname,FMaterialModel, ");
        sql.append(" fmaterialUnit,fproductorgunitid ,FControlUnitID ,fseq )   ");
        sql.append(" select newbosid('00CB57F2'),tb.FPROJECTID,tb.FMaterialID,tb.FTRACKID,ISNULL(tb.FRePlanDATE,tb.fbilldate) , ");
        sql.append("'");
        sql.append(userInfo.getId().toString());
        sql.append("','");
        sql.append(userInfo.getId().toString());
        sql.append("', ");
        sql.append(" ISNULL(tb.FRePlanDATE,tb.fbilldate) ,tpe.CFPurchaseOrgUnitI,abs(tb.fdependent),abs(tb.fdependent), ");
        sql.append(" tm.fname_l2,tm.fmodel,tmu.fname_l2, ");
        sql.append(" ISNULL(tb.FOrgUnitID,tb.fsupplyorgunitid), ");
        sql.append("'" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' , rownum ");
        sql.append(" from " + tableName + " tb ");
        sql.append(" left join t_bd_material tm on tm.fid = tb.FMaterialID ");
        sql.append(" left join  t_bd_measureunit  tmu on tm.fbaseunit = tmu.fid ");
        sql.append(" left join CT_BAS_PurRDE tpe on tpe.fparentid = '");
        sql.append(this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getPurchaseRelation().getId().toString() + "' ");
        sql.append(" and ISNULL(tb.FOrgUnitID ,tb.fsupplyorgunitid) = tpe.CFProductOrgUnitID ");
        sql.append(" where tb.FMaterialAttr = 10040 and (abs(tb.fdependent))> 0");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" select  og.fname_l2 from T_PSP_PspStockingDemand tp ");
        sql.append(" left join t_org_baseunit og on tp.fproductorgunitid = og.fid");
        sql.append(" where tp.fpurorgid is null group by og.fname_l2");
        IRowSet rs = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
        StringBuffer errorStr = new StringBuffer();
        errorStr.setLength(0);
        while (rs.next()) {
            errorStr.append(rs.getString("fname_l2") + "\n");
        }
        if (errorStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("401", EASResource.getString((String)this.RESOURCE_NAME, (String)"label201") + "\n" + errorStr.toString()));
        }
    }

    @Override
    public List getPCP(Context ctx) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyString((String)this.pspParams.getPSPExpandDay())) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ \r\n");
        sql.append("  select pcp.FPROJECTID,pro.fnumber,pro.fname_l2,nvl(pur.CFRunStatus ,0) CFRunStatus ").append(" from T_PCP_ProjectCP pcp ").append(" left join T_MM_PROJECT pro  ON pcp.fprojectid = pro.fid ").append(" left join CT_PUR_BOMPurRequest pur on  pcp.fprojectid = pur.cfprojectnoid ").append(" where pcp.FFINISHTIME >= trunc(sysdate ,'dd') ").append(" and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),").append(this.pspParams.getPSPExpandDay()).append(" ) ").append("  order by pcp.FFINISHTIME");
        try {
            IRowSet rs = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
            if (IndustryUtils.isEmptyRowSet((IRowSet)rs)) {
                return null;
            }
            ArrayList list = new ArrayList();
            ArrayList<PspProjectInfo> list1 = new ArrayList<PspProjectInfo>();
            ArrayList<PspProjectInfo> list2 = new ArrayList<PspProjectInfo>();
            while (rs.next()) {
                PspProjectInfo pspProjectInfo;
                if (rs.getInt("CFRunStatus") == 0) {
                    pspProjectInfo = new PspProjectInfo(rs.getString("FPROJECTID"), rs.getString("fnumber"), rs.getString("fname_l2"), rs.getInt("CFRunStatus"));
                    list1.add(pspProjectInfo);
                    continue;
                }
                pspProjectInfo = new PspProjectInfo(rs.getString("FPROJECTID"), rs.getString("fnumber"), rs.getString("fname_l2"), rs.getInt("CFRunStatus"));
                list2.add(pspProjectInfo);
            }
            list.add(list1);
            list.add(list2);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label202"), e.getMessage()));
        }
    }

    private void algorithmGenPSP(Context ctx) throws Exception {
        listStorageOrgIdByProduct = this.getProductOrgByScheme(ctx);
        listStorageOrgIdBySupply = this.getSupplyOrgByScheme(ctx);
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String sqld = " delete from T_PSP_PspStockingDemand";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sqld);
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" insert into T_PSP_PspStockingDemand (Fid,FProjectID,FMaterialID,FTrackNumberID, ");
        sql.append(" FFinishTime,FCreatorID,FLastUpdateUserID,fleadtime,fpurorgid,ftmpmod,fmaterialname,fmaterialUnit,fproductorgunitid ,FControlUnitID , fsourcebillid , fseq ) ");
        sql.append(" select newbosid('00CB57F2'),pcpe.fprojectid,pue.fmaterialid,pcpe.ftracknumberid,pcpe.FFINISHTIME, ");
        sql.append(" '");
        sql.append(userInfo.getId().toString());
        sql.append("','");
        sql.append(userInfo.getId().toString());
        sql.append("', ");
        sql.append(" pcpe.ffinishtime  - ");
        sql.append(this.pspParams.getPspOperationSchemeInfo().getLeadTime());
        sql.append(" ,pr.fpurchaseorgunitid,pue.fqty , ");
        sql.append(" pue.fmaterialname ,tmu.fname_l2,pcpe.fstorageorgunitid ,");
        sql.append("'" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' ,pue.fid ,rownum");
        sql.append(" from T_PCP_projectcp   pcp  ");
        sql.append(" inner join T_PCP_projectcpse pcpe on pcp.fid = pcpe.fparentid ");
        sql.append(" left join T_PCP_ProjectPlanModel pcm on pcp.fprojectplanmodelid = pcm.fid ");
        sql.append(" left join t_mm_projectcar pcr on pcpe.fprojectid = pcr.fprojectid and pcpe.FTrackNumberID = pcr.FTrackNumberID ");
        sql.append(" inner join T_SM_PurOrderEntry pue on pcp.fprojectid = pue.fprojectid  ");
        sql.append(" left join T_SM_PurOrder pr on pr.fid = pue.fparentid  ");
        sql.append(" and pr.fpurchaseorgunitid in ( ");
        sql.append(this.getPurOrgList(ctx));
        sql.append(" ) ");
        sql.append(" and pue.fstorageorgunitid in  ");
        sql.append(this.getStringIDByList(listStorageOrgIdBySupply));
        sql.append(" left join  t_bd_measureunit  tmu on pue.funitid = tmu.fid  ");
        sql.append(" where pcp.fstorageorgunitid = '");
        sql.append(this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getStorageOrg().getId().toString());
        sql.append("' and pr.fbasestatus = 4  ");
        sql.append(" and pcr.fistest = 1  and pcp.fstate = 4 ");
        sql.append(" and pcpe.FFINISHTIME >= GETDATE() ");
        sql.append(" and pcpe.FFINISHTIME <= ADD_DAYS (GETDATE(), " + this.pspParams.getPspOperationSchemeInfo().getPlanTime() + ") ");
        sql.append(" and pcpe.fstorageorgunitid in ");
        sql.append(this.getStringIDByList(listStorageOrgIdByProduct));
        sql.append(" and pcm.fproductmodelid = pcpe.fproductmodelid  and pcm.fparentid is null ");
        sql.append(" order by pcp.ffinishtime  ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" ");
        sql.append(" update T_PSP_PspStockingDemand  set  (fdemandqty,ftmpmod)  =(  ");
        sql.append(" select  (num - mod(num,n))/n,mod(num,n) from ( ");
        sql.append(" select psp.fprojectid as fpid,psp.fmaterialid as fmid,psp.fpurorgid as frid ,psp.fsourcebillid as fsid , ");
        sql.append(" count(FTrackNumberID) as n,sum(psp.ftmpmod)/count(FTrackNumberID) as num ");
        sql.append(" from t_psp_pspstockingdemand psp where 1=1 ");
        sql.append(" group by psp.fprojectid,psp.fmaterialid,psp.fpurorgid ,psp.fsourcebillid ) ");
        sql.append(" where fprojectid = fpid and fmaterialid = fmid and fpurorgid =frid and fsourcebillid =fsid) ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" ");
        sql.append(" update T_PSP_PspStockingDemand set fdemandqty = fdemandqty + ftmpmod ,ftmpmod = 0    where fid in (   ");
        sql.append(" select min(fid) as fid from T_PSP_PspStockingDemand psp    ");
        sql.append(" group by  psp.fprojectid ,psp.fmaterialid,psp.fpurorgid,psp.fsourcebillid)  ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" ");
        sql.append(" update T_PSP_PspStockingDemand set fAllocateqty = fdemandqty where 1=1");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append("   ");
        sql.append("update T_PSP_PspStockingDemand set ftmpmod = 0 , fsourcebillid  = '' where 1=1");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
    }

    protected String getPurOrgList(Context ctx) throws EASBizException {
        PurRelationshipDefinitionEntryCollection prdentryCol;
        AbstractPurRelationshipDefinitionInfo purInfo;
        PspOperationSchemeInfo osInfo = this.pspParams.getPspOperationSchemeInfo();
        AbstractPurRelationshipDefinitionInfo abstractPurRelationshipDefinitionInfo = osInfo == null ? null : (osInfo.getBatchOpeScheme() == null ? null : (purInfo = osInfo.getBatchOpeScheme().getPurchaseRelation() == null ? null : osInfo.getBatchOpeScheme().getPurchaseRelation()));
        PurRelationshipDefinitionEntryCollection purRelationshipDefinitionEntryCollection = purInfo == null ? null : (prdentryCol = purInfo.getEntry() == null ? null : purInfo.getEntry());
        if (prdentryCol == null || prdentryCol.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label113"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label117")));
        }
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        for (int i = 0; i < prdentryCol.size(); ++i) {
            PurRelationshipDefinitionEntryInfo einfo = prdentryCol.get(i);
            str.append("'" + einfo.getPurchaseOrgUnit().getId().toString() + "'");
            if (i >= prdentryCol.size() - 1) continue;
            str.append(" , ");
        }
        if (str.length() == 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)this.RESOURCE_NAME, (String)"label113"), EASResource.getString((String)this.RESOURCE_NAME, (String)"label117")));
        }
        return str.toString();
    }

    private void templateGenPSP(Context ctx, List projectList) throws BOSException, EASBizException, SQLException {
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = " delete from T_PSP_PspStockingDemand";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/   insert into T_PSP_PspStockingDemand(Fid,FProjectID,FRunstatus,FMaterialID,FTrackNumberID,FDemandQty,FFinishTime,FCreatorID,FLastUpdateUserID,FMaterialPlanNode) select newbosid('00CB57F2'), pcp.FPROJECTID projectid, nvl(pur.CFRunStatus ,0) CFRunStatus,pspe.cfmaterialnumberid materialid, pc.ftracknumberid tracknumber, pspe.cfmaterialquota quota,pcp.FFINISHTIME,'" + userInfo.getId().toString() + "','" + userInfo.getId().toString() + "', pspe.cfplannode  from T_PCP_ProjectCP pcp  inner join T_MM_Projectcar pc on pcp.fprojectid = pc.fprojectid left join T_MM_TRACKNUMBER tn on pc.ftracknumberid = tn.fid left join T_MM_PROJECT pro  ON pcp.fprojectid = pro.fid left join CT_PUR_BOMPurRequest pur on  pcp.fprojectid = pur.cfprojectnoid inner join CT_PSP_PspTemplate psp on psp.cfprojectnumberid = pcp.fprojectid inner join CT_PSP_PspTemplateEntry pspe on psp.fid = pspe.fparentid left join T_BD_Material ma on pspe.cfmaterialnumberid = ma.fid left join T_BD_MeasureUnit mu on ma.fbaseunit = mu.fid where pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4) order by pcp.ffinishtime";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set FIssolateRule =    (select nvl(FIsolatedRule,'NONE') from T_BD_MaterialPlan mp  where psd.FMaterialID = mp.fmaterialid and mp.forgunit='" + ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString() + "')";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        String tmpTableLT = this.createTempLeadTimeTableSql(ctx);
        sql = " /*dialect*/    insert into " + tmpTableLT + "(fprojectid,FTrackNoID,Fmaterialid,Fpladnode,Fleadtime0, Fleadtime1) select psp.cfprojectnumberid, pcpe.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode,   pcpe.ffinishtime - pspe.cftataladvancedate - pspe.cfstockadvancedate,  pcpe.ffinishtime - 1 - pspe.cfstockadvancedate  from  CT_PSP_PspTemplate psp   inner join CT_PSP_PspTemplateEntry pspe on psp.fid =pspe.fparentid  left join T_PCP_ProjectCP pcp   on psp.cfprojectnumberid = pcp.fprojectid    left join t_Pcp_Projectcpse pcpe on pcp.fid = pcpe.fparentid and pspe.cfplannode = pcpe.fplannode  and pcpe.fprojectid = psp.cfprojectnumberid  where   pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4) ";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set Fleadtime = (select  case nvl(psd.FRunstatus, 0) when 0 then tmp1.Fleadtime0 when 1 then tmp1.Fleadtime1 end from  " + tmpTableLT + " tmp1  where psd.fprojectid = tmp1.fprojectid and psd.FTrackNumberID= tmp1.FTrackNoID and psd.Fmaterialid= tmp1.Fmaterialid and psd.FMaterialPlanNode = tmp1.Fpladnode)";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableLT);
    }

    private List getProductOrgByScheme(Context ctx) {
        ArrayList<String> list = null;
        SupplyRelationshipDefinitionEntryCollection srdeCol = this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getSupplyRelation().getEntry();
        if (srdeCol != null && srdeCol.size() > 0) {
            list = new ArrayList<String>();
            for (int i = 0; i < srdeCol.size(); ++i) {
                list.add(srdeCol.get(i).getProductOrgUnit().getId().toString());
            }
        }
        return list;
    }

    private List getSupplyOrgByScheme(Context ctx) {
        ArrayList<String> list = null;
        List<PspInventoryInfo> listInv = null;
        SupplyRelationshipDefinitionEntryCollection srdeCol = this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getSupplyRelation().getEntry();
        if (srdeCol != null && srdeCol.size() > 0) {
            list = new ArrayList<String>();
            mapSupplyRelation.clear();
            for (int i = 0; i < srdeCol.size(); ++i) {
                list.add(srdeCol.get(i).getSupplyOrgUnit().getId().toString());
                PspInventoryInfo pspInventoryInfo = new PspInventoryInfo();
                pspInventoryInfo.setStorageOrgUnitId(srdeCol.get(i).getSupplyOrgUnit().getId().toString());
                pspInventoryInfo.setLevel(srdeCol.get(i).getPriorityLevel());
                listInv = mapSupplyRelation.get(srdeCol.get(i).getProductOrgUnit().getId().toString());
                if (listInv == null) {
                    listInv = new ArrayList<PspInventoryInfo>();
                }
                listInv.add(pspInventoryInfo);
                mapSupplyRelation.put(srdeCol.get(i).getProductOrgUnit().getId().toString(), listInv);
            }
        }
        for (List<PspInventoryInfo> value : mapSupplyRelation.values()) {
            Collections.sort(value, new Comparator<PspInventoryInfo>(){

                @Override
                public int compare(PspInventoryInfo o1, PspInventoryInfo o2) {
                    if (o1.getLevel() > o2.getLevel()) {
                        return 1;
                    }
                    if (o1.getLevel() == o2.getLevel()) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        return list;
    }

    private void templateGenPSD(Context ctx, String tmpDemandTable) throws Exception {
        listStorageOrgIdByProduct = this.getProductOrgByScheme(ctx);
        listStorageOrgIdBySupply = this.getSupplyOrgByScheme(ctx);
        planOrgUnitId = this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getStorageOrg().getId().toString();
        String sql = " delete from T_PSP_PspStockingDemand";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        sql = "insert into T_PSP_PspStockingDemand(Fid,FProjectID,FRunstatus,FMaterialID,FTrackNumberID,FDemandQty,FAllocateQty,FFinishTime,FCreatorID,FLastUpdateUserID,FMaterialPlanNode,FPurOrgID,FProductOrgUnitID,FControlUnitID,FSOURCEBILLID,FSeq)select newbosid('00CB57F2'),t1.fprojectid, isNull(pur.CFRunStatus, 0) CFRunStatus,  pspe.cfmaterialnumberid materialid,  t1.ftracknumberid tracknumber,  pspe.cfmaterialquota quota,  pspe.cfmaterialquota quota2,  t1.FFINISHTIME, '" + userInfo.getId().toString() + "','" + userInfo.getId().toString() + "', pspe.cfplannode,  psp.cfpurorgunitid,   t1.fstorageorgunitid,   '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "',  t1.fid,rownum   from(   select  pcp.fid,pcpe.fstorageorgunitid,pcpe.fprojectid,pcpe.FTrackNumberID,pcpe.ffinishtime  from T_PCP_ProjectCP pcp  inner join t_Pcp_Projectcpse pcpe on pcpe.fparentid = pcp.fid  where  pcp.fstate=4  and pcp.fstorageorgunitid = '" + planOrgUnitId + "' and pcpe.FCTrackNumber is null  and pcpe.FFINISHTIME >= GETDATE()  and pcpe.FFINISHTIME <= ADD_DAYS (GETDATE(), " + this.pspParams.getPspOperationSchemeInfo().getPlanTime() + ")  and pcpe.fstorageorgunitid in " + this.getStringIDByList(listStorageOrgIdByProduct) + " )t1   left join T_MM_Projectcar pc on t1.FTrackNumberID = pc.FTrackNumberID  left join T_MM_TRACKNUMBER tn on t1.ftracknumberid = tn.fid  left join T_MM_PROJECT pro ON t1.fprojectid = pro.fid  left join CT_PUR_BOMPurRequest pur on t1.fprojectid = pur.cfprojectnoid   inner join CT_PSP_PspTemplate psp on psp.cfprojectnumberid =t1.fprojectid and psp.fstatus=2   inner join CT_PSP_PspTemplateEntry pspe on psp.fid = pspe.fparentid  left join T_BD_Material ma on pspe.cfmaterialnumberid = ma.fid  left join T_BD_MeasureUnit mu on ma.fbaseunit = mu.fid  where pc.fistest = 1  order by  t1.FFINISHTIME ";
        int iRow = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " update T_PSP_PspStockingDemand psd set (FProductOrgUnitID,ffinishtime) = (select  fproductorgunitid,max(ffinishtime) from t_Pcp_Projectcpse pe  where psd.fprojectid = pe.fprojectid and psd.ftracknumberid = pe.ftracknumberid  and psd.FMaterialPlanNode = pe.fplannode  and psd.fsourcebillid = pe.fparentid )";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        String tmpTableLT = this.createTempLeadTimeTableSql(ctx);
        sql = " insert into " + tmpTableLT + "(Fproductorgunitid,Fprojectid,FTrackNoID,Fmaterialid,Fpladnode,Fleadtime0, Fleadtime1,FMleadday0,FMleadday1) select psd.fproductorgunitid,psp.cfprojectnumberid, psd.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode,   min(psd.ffinishtime - pspe.cftataladvancedate - pspe.cfstockadvancedate),  min(psd.ffinishtime  - pspe.cfstockadvancedate),  max(pmlt.fleadtime),  max(pmlt2.fleadtime)  from T_PSP_PspStockingDemand psd   left join CT_PSP_PspTemplate psp on psd.FPurOrgID = psp.cfpurorgunitid and psd.fprojectid = psp.cfprojectnumberid  inner join CT_PSP_PspTemplateEntry pspe on psp.fid = pspe.fparentid and psd.fmaterialplannode = pspe.cfplannode   left join t_psp_PspMaterialLeadTime pmlt on pmlt.fstorageorgunitid = psd.fproductorgunitid and pmlt.fmaterialid is null and pmlt.FStatus =2  left join t_psp_PspMaterialLeadTime pmlt2 on pmlt2.fstorageorgunitid = psd.fproductorgunitid and pmlt2.fmaterialid = pspe.cfmaterialnumberid and pmlt2.FStatus =2 group by psd.fproductorgunitid,psp.cfprojectnumberid, psd.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " update " + tmpTableLT + " set Fleadtime1 = (case FMleadday1 when null then Fleadtime1-ISNULL(FMleadday0,0) else Fleadtime1-FMleadday1 end)";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " update T_PSP_PspStockingDemand psd set Fleadtime = (select  case ISNULL(psd.FRunstatus, 0) when 0 then tmp1.Fleadtime0 when 1 then tmp1.Fleadtime1 end from  " + tmpTableLT + " tmp1  where psd.fproductorgunitid = tmp1.fproductorgunitid and psd.fprojectid = tmp1.fprojectid and psd.FTrackNumberID= tmp1.FTrackNoID and psd.Fmaterialid= tmp1.Fmaterialid and psd.FMaterialPlanNode = tmp1.Fpladnode)";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableLT);
    }

    private void mergeDemand(Context ctx, String tempDemandTable) throws BOSException, EASBizException, SQLException {
        PspOperationSchemeInfo osInfo = this.pspParams.getPspOperationSchemeInfo();
        PspMergingRulesEntryCollection mrencol = null;
        PspMergingRulesInfo mrInfo = new PspMergingRulesInfo();
        ObjectUuidPK pk = new ObjectUuidPK();
        pk.setKeyValue("id", (Object)osInfo.getMergerRules().getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Entry.*"));
        mrInfo = PspMergingRulesFactory.getLocalInstance(ctx).getPspMergingRulesInfo((IObjectPK)pk, selector);
        mrencol = mrInfo.getEntry();
        if (mrencol == null || mrencol.size() == 0) {
            return;
        }
        HashMap<String, PspDemand> mapMergeDate = new HashMap<String, PspDemand>();
        EntityViewInfo ev = new EntityViewInfo();
        String sql = "";
        String sqlwhere = " where 1=1 ";
        String sqlorderby = "";
        IPspStockingDemand isp = PspStockingDemandFactory.getLocalInstance(ctx);
        ArrayList<String> sqls = new ArrayList<String>();
        ArrayList<String> listSqls = new ArrayList<String>();
        String strKey = "";
        for (int i = 0; i < mrencol.size(); ++i) {
            PspMergingRulesEntryInfo mren = mrencol.get(i);
            FilterInfo filtersp = new FilterInfo();
            filtersp.getFilterItems().add(new FilterItemInfo("StoreOrgUnit", (Object)mren.getSupplyOrg(), CompareType.EQUALS));
            ev.setFilter(filtersp);
            sqlwhere = " where 1=1 ";
            sqlorderby = "";
            strKey = "";
            if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null || SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                sqlwhere = sqlwhere + " and  FIssolateRule is null or  FIssolateRule in('NONE','')";
            } else if ("2".equals(mren.getMaterialRule().getValue())) {
                sqlwhere = sqlwhere + " and    FIssolateRule in('ITEM')";
            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                sqlwhere = sqlwhere + " and    FIssolateRule in('ITEM_TRACKNO')";
            }
            sqlorderby = LATEST.equals(mren.getMergeType().getValue()) ? " order by FPurOrgID,FMaterialID,FLeadTime" : ("2".equals(mren.getMergeType().getValue()) ? " order by FPurOrgID,FPROJECTID,FMaterialID,FLeadTime" : " order by FPurOrgID,FPROJECTID,FTrackNumberID,FMaterialID,FLeadTime");
            sql = " select * from   T_PSP_PspStockingDemand " + sqlwhere + sqlorderby;
            IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
            boolean j = false;
            String material = "";
            String project = "";
            String traceno = "";
            String purorg = "";
            String storageunitid = "";
            BigDecimal qty = BigDecimal.ZERO;
            Timestamp RequirementDate = null;
            String strDate = "";
            String isolatedrule = "";
            String demandId = "";
            Calendar cc = Calendar.getInstance();
            boolean year = false;
            boolean month = false;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            mapMergeDate.clear();
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    ArrayList<String> listIds;
                    PspDemand pspDemand;
                    demandId = rowSet.getString("FID");
                    purorg = rowSet.getString("FPurOrgID");
                    storageunitid = rowSet.getString("FProductOrgUnitID");
                    material = rowSet.getString("FMaterialID");
                    qty = rowSet.getBigDecimal("FAllocateQty");
                    RequirementDate = rowSet.getTimestamp("FLeadTime");
                    project = rowSet.getString("FPROJECTID");
                    traceno = rowSet.getString("FTrackNumberID");
                    isolatedrule = rowSet.getString("FIssolateRule");
                    strDate = format.format(RequirementDate);
                    if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null || SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                        strKey = purorg + material + strDate;
                    } else if ("2".equals(mren.getMaterialRule().getValue())) {
                        strKey = purorg + project + material;
                    } else if ("3".equals(mren.getMaterialRule().getValue())) {
                        strKey = purorg + project + traceno + material + strDate;
                    }
                    if (LATEST.equals(mren.getMergeType().getValue())) {
                        if (mapMergeDate.get(strKey) != null) {
                            pspDemand = (PspDemand)mapMergeDate.get(strKey);
                            pspDemand.setQty(pspDemand.getQty().add(qty));
                            pspDemand.setPurorgunit(purorg);
                            pspDemand.getDemandid().add(demandId);
                            mapMergeDate.put(strKey, pspDemand);
                            continue;
                        }
                        pspDemand = new PspDemand(purorg, null, null, material, RequirementDate, qty, isolatedrule);
                        if (!LATEST.equals(mren.getMaterialRule().getValue()) && mren.getMaterialRule() != null && !SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                            if ("2".equals(mren.getMaterialRule().getValue())) {
                                pspDemand.setProject(project);
                            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                                pspDemand.setProject(project);
                                pspDemand.setTracknumber(traceno);
                            }
                        }
                        listIds = new ArrayList<String>();
                        listIds.add(demandId);
                        pspDemand.setDemandid(listIds);
                        mapMergeDate.put(purorg + material + strDate, pspDemand);
                        continue;
                    }
                    if ("2".equals(mren.getMergeType().getValue())) {
                        if (mapMergeDate.get(strKey) != null) {
                            pspDemand = (PspDemand)mapMergeDate.get(strKey);
                            pspDemand.setPurorgunit(purorg);
                            pspDemand.setQty(pspDemand.getQty().add(qty));
                            if (pspDemand.getLeadTime().compareTo(RequirementDate) < 0) {
                                pspDemand.setLeadTime(RequirementDate);
                            }
                            pspDemand.getDemandid().add(demandId);
                            mapMergeDate.put(strKey, pspDemand);
                            continue;
                        }
                        pspDemand = new PspDemand(purorg, null, null, material, RequirementDate, qty, isolatedrule);
                        if (!LATEST.equals(mren.getMaterialRule().getValue()) && mren.getMaterialRule() != null && !SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                            if ("2".equals(mren.getMaterialRule().getValue())) {
                                pspDemand.setProject(project);
                            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                                pspDemand.setProject(project);
                                pspDemand.setTracknumber(traceno);
                            }
                        }
                        listIds = new ArrayList();
                        listIds.add(demandId);
                        pspDemand.setDemandid(listIds);
                        mapMergeDate.put(strKey, pspDemand);
                        continue;
                    }
                    if (mapMergeDate.get(strKey) != null) {
                        pspDemand = (PspDemand)mapMergeDate.get(strKey);
                        pspDemand.setPurorgunit(purorg);
                        pspDemand.setQty(pspDemand.getQty().add(qty));
                        if (pspDemand.getLeadTime().compareTo(RequirementDate) < 0) {
                            pspDemand.setLeadTime(RequirementDate);
                        }
                        pspDemand.getDemandid().add(demandId);
                        mapMergeDate.put(strKey, pspDemand);
                        continue;
                    }
                    pspDemand = new PspDemand(purorg, null, null, material, RequirementDate, qty, isolatedrule);
                    if (!LATEST.equals(mren.getMaterialRule().getValue()) && mren.getMaterialRule() != null && !SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                        if ("2".equals(mren.getMaterialRule().getValue())) {
                            pspDemand.setProject(project);
                        } else if ("3".equals(mren.getMaterialRule().getValue())) {
                            pspDemand.setProject(project);
                            pspDemand.setTracknumber(traceno);
                        }
                    }
                    listIds = new ArrayList();
                    listIds.add(demandId);
                    pspDemand.setDemandid(listIds);
                    mapMergeDate.put(strKey, pspDemand);
                }
            }
            int mapSize = 0;
            String tmpId = "";
            for (String key : mapMergeDate.keySet()) {
                PspDemand value = (PspDemand)mapMergeDate.get(key);
                tmpId = BOSUuid.create((String)"88888888").toString();
                sql = "insert into " + tempDemandTable + "(Fid,FPurOrgID,FProjectID,FTrackNumberID,FMaterialID,FLeadTime,FDemandQty,FIssolateRule,FStorageUnitId)values('" + tmpId + "','" + value.getPurorgunit() + "',";
                sql = value.getProject() == null ? sql + null + "," : sql + "'" + value.getProject() + "',";
                sql = value.getTracknumber() == null ? sql + null + "," : sql + "'" + value.getTracknumber() + "',";
                sql = sql + "'" + value.getMaterial() + "',TO_DATE('" + value.getLeadTime() + "')," + value.getQty() + ",";
                sql = value.getIsolatedrule() == null ? sql + "'NONE'," : sql + "'" + value.getIsolatedrule() + "',";
                sql = storageunitid == null ? sql + null : sql + "'" + storageunitid + "'";
                sql = sql + ")";
                sqls.add(sql);
                for (int k = 0; k < value.getDemandid().size(); ++k) {
                    sql = " insert into T_PSP_DEMANDIDTOPLANID(FDEMANDID,FTEMPID)VALUES( '" + value.getDemandid().get(k).toString() + "','" + tmpId + "')";
                    listSqls.add(sql);
                }
                ++mapSize;
            }
        }
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls.toArray(new String[sqls.size()]));
        SQLUtils.execute((Context)ctx, (String)" delete from T_PSP_DEMANDIDTOPLANID");
        String[] arraySqls = listSqls.toArray(new String[listSqls.size()]);
        SQLUtil.batchExecuteSql((Context)ctx, (String[])arraySqls);
    }

    private void mergeDemand2(Context ctx, String tempDemandTable) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        PspOperationSchemeInfo osInfo = this.pspParams.getPspOperationSchemeInfo();
        PspMergingRulesEntryCollection mrencol = null;
        PspMergingRulesInfo mrInfo = new PspMergingRulesInfo();
        ObjectUuidPK pk = new ObjectUuidPK();
        pk.setKeyValue("id", (Object)osInfo.getMergerRules().getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Entry.*"));
        mrInfo = PspMergingRulesFactory.getLocalInstance(ctx).getPspMergingRulesInfo((IObjectPK)pk, selector);
        mrencol = mrInfo.getEntry();
        if (mrencol == null || mrencol.size() == 0) {
            return;
        }
        sql.setLength(0);
        sql.append("update T_PSP_PspStockingDemand set fseq = rownum");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        for (int i = 0; i < mrencol.size(); ++i) {
            PspMergingRulesEntryInfo mren = mrencol.get(i);
            sql.setLength(0);
            sql.append("/*dialect*/ insert into ").append(tempDemandTable).append("(FPurOrgID,FStorageUnitId,FProjectID,FTrackNumberID,FMaterialID,FIssolateRule,").append("FDemandQty,FLeadTime,FDemandSeq)");
            if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null || SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                if (LATEST.equals(mren.getMergeType().getValue())) {
                    sql.append("select fpurorgid,FProductOrgUnitID,null,null,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),min(fleadtime),wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where (FIssolateRule='NONE' or  FIssolateRule is null) ").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fmaterialid,FIssolateRule,to_char(fleadtime,'yyyymm')");
                } else if ("2".equals(mren.getMergeType().getValue())) {
                    sql.append("select fpurorgid,FProductOrgUnitID,fprojectid,null,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),min(fleadtime),wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where (FIssolateRule='NONE' or  FIssolateRule is null)").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fprojectid,fmaterialid,FIssolateRule");
                } else if ("3".equals(mren.getMergeType().getValue())) {
                    sql.append("select fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),fleadtime,wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where (FIssolateRule='NONE' or  FIssolateRule is null)").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,fleadtime");
                }
            } else if ("2".equals(mren.getMaterialRule().getValue())) {
                if ("2".equals(mren.getMergeType().getValue())) {
                    sql.append("select fpurorgid,FProductOrgUnitID,fprojectid,null,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),min(fleadtime),wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where FIssolateRule='ITEM'").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fprojectid,fmaterialid,FIssolateRule");
                } else if ("3".equals(mren.getMergeType().getValue())) {
                    sql.append("select fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),fleadtime,wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where FIssolateRule='ITEM'").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,fleadtime");
                }
            } else if ("3".equals(mren.getMaterialRule().getValue()) && "3".equals(mren.getMergeType().getValue())) {
                sql.append("select fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,").append(" sum(fallocateqty),fleadtime,wm_concat(Fseq)").append(" from T_PSP_PspStockingDemand  ").append(" where FIssolateRule='ITEM_TRACKNO'").append(" and  FProductOrgUnitID ='").append(mren.getProductionOrg().getId()).append("' ").append(" group by fpurorgid,FProductOrgUnitID,fprojectid,ftracknumberid,fmaterialid,FIssolateRule,fleadtime");
            }
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        SQLUtils.execute((Context)ctx, (String)(" update " + tempDemandTable + " set fid=newbosid('88888888')"));
        SQLUtils.execute((Context)ctx, (String)" delete from T_PSP_DEMANDIDTOPLANID");
        ArrayList<String> listSqls = new ArrayList<String>();
        String strSql = "";
        sql.setLength(0);
        sql.append("select fid,fdemandseq from ").append(tempDemandTable);
        IRowSet rowSet = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                if (rowSet.getString("fdemandseq") == null) continue;
                String[] seqs = rowSet.getString("fdemandseq").split(",");
                for (int i = 0; i < seqs.length; ++i) {
                    if (seqs[i] == null || "".equals(seqs[i])) continue;
                    strSql = " insert into T_PSP_DEMANDIDTOPLANID(FTEMPID,FSEQ)VALUES( '" + rowSet.getString("fid") + "','" + seqs[i] + "')";
                    listSqls.add(strSql);
                }
            }
        }
        String[] arraySqls = listSqls.toArray(new String[listSqls.size()]);
        SQLUtil.batchExecuteSql((Context)ctx, (String[])arraySqls);
        SQLUtils.execute((Context)ctx, (String)" update T_PSP_DEMANDIDTOPLANID t1 set FDEMANDID = (select fid from T_PSP_PspStockingDemand t2 where t1.FSEQ = t2.fseq)");
    }

    private void macthInvAndpur(Context ctx, List projectList) throws BOSException, EASBizException, SQLException {
        PspStockingDemandInfo smInfo;
        int j;
        PspStockingDemandCollection cbc;
        SorterItemInfo sorter;
        SorterItemCollection sorters;
        FilterInfo filter;
        EntityViewInfo viewInfo;
        int i;
        IPspStockingDemand iPsd = PspStockingDemandFactory.getLocalInstance(ctx);
        String tmpTableInv = this.createTempInvTableSql(ctx);
        String sql = " /*dialect*/  insert into " + tmpTableInv + "(fmaterialid,FProjectID,FTrackNumberID,FCurStoreQty) select distinct t1.fmaterialid,t1.FProjectID, t1.FTrackNumberID ,nvl(inv.FCurStoreQty,0) FCurStoreQty  from T_PSP_PspStockingDemand t1 left join T_IM_Inventory inv on t1.FMaterialID = inv.fmaterialid ";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = "/*dialect*/ select * from  " + tmpTableInv;
        IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
        HashMap<String, Number> mapInv = new HashMap<String, Number>();
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                mapInv.put(rowSet.getString("fmaterialid"), rowSet.getInt("FCurStoreQty"));
            }
        }
        Object listPSSEInfo = null;
        for (i = 0; i < projectList.size(); ++i) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_NONE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)((PspProjectInfo)projectList.get(i)).getProjectId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            sorters = new SorterItemCollection();
            sorter = new SorterItemInfo("trackNumber.number");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            viewInfo.setSorter(sorters);
            cbc = iPsd.getPspStockingDemandCollection(viewInfo);
            if (cbc == null || cbc.size() <= 0) continue;
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                if (smInfo.getDemandQty().compareTo(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setAllocatedQty(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()));
                    mapInv.put(smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setAllocatedQty(smInfo.getDemandQty());
                    mapInv.put(smInfo.getMaterial().getId().toString(), new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()).subtract(smInfo.getDemandQty()));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
        for (i = 0; i < projectList.size(); ++i) {
            sql = " /*dialect*/ select * from T_PSP_PspStockingDemand where FIsolatedRule is  null and projectid='" + projectList.get(i) + "' order by FFINISHTIME ";
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_NONE, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)((PspProjectInfo)projectList.get(i)).getProjectId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            sorters = new SorterItemCollection();
            sorter = new SorterItemInfo("finishTime");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            viewInfo.setSorter(sorters);
            cbc = iPsd.getPspStockingDemandCollection(viewInfo);
            if (cbc == null || cbc.size() <= 0) continue;
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                if (smInfo.getDemandQty().compareTo(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setAllocatedQty(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()));
                    mapInv.put(smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setAllocatedQty(smInfo.getDemandQty());
                    mapInv.put(smInfo.getMaterial().getId().toString(), new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()).subtract(smInfo.getDemandQty()));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableInv);
        String tmpTablePur = this.createTempPurTableSql(ctx);
        HashSet<String> setProId = new HashSet<String>();
        for (int i2 = 0; i2 < projectList.size(); ++i2) {
            setProId.add(((PspProjectInfo)projectList.get(i2)).getProjectId());
        }
        sql = "/*dialect*/  insert into " + tmpTablePur + " (fprojectid,fmaterialid,FTrackNoID,FQty,FusedQty)  select pure.fprojectid, pure.fmaterialid,pure.FTrackNoID,sum(pure.FQty) FQty, 0 usedQty from T_SM_PurOrder pur  inner join t_Sm_Purorderentry pure on pur.fid = pure.fparentid  where pur.fbasestatus =  4 and pure.fprojectid in (" + SQLUtil.setToString(setProId) + " ) group by pure.fprojectid, pure.fmaterialid,pure.FTrackNoID";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = "/*dialect*/ select * from  " + tmpTablePur;
        rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
        HashMap<String, Number> mapPur = new HashMap<String, Number>();
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                mapPur.put(rowSet.getString("fprojectid") + rowSet.getString("FTrackNoID") + rowSet.getString("fmaterialid"), rowSet.getInt("FQty"));
            }
        }
        sql = " where   allocateQty =0 ";
        EntityViewInfo viewInfo2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("allocateQty", (Object)0, CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("allocateQty", (Object)"demandQty", CompareType.LESS));
        filter2.setMaskString("#0 or #1");
        viewInfo2.setFilter(filter2);
        cbc = iPsd.getPspStockingDemandCollection(sql);
        if (cbc != null && cbc.size() > 0) {
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                BigDecimal needQty = smInfo.getDemandQty().subtract(smInfo.getAllocateQty());
                if (needQty.compareTo(new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setOrderQty(new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString()));
                    mapPur.put(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setOrderQty(needQty);
                    mapPur.put(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString(), new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString()).subtract(needQty));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
    }

    public void genStockingPlan(Context ctx, String rule, String tmpDemandTable) throws Exception {
        String storageUnitId = ContextUtil.getCurrentStorageUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString();
        IPspStockPlanMiddle isp = PspStockPlanMiddleFactory.getLocalInstance(ctx);
        String sql = " select * from T_PSP_PspStockingDemand ";
        inventoryMap.clear();
        if (LATEST.equals(rule)) {
            sql = " delete from T_PSP_PspStockPlanMiddle";
            SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = "/*dialect*/ insert into T_PSP_PspStockPlanMiddle(fid,fprojectid,FTraceNoID,fmaterialid,FDemandQty, FQty,FCreatorID,FLastUpdateUserID,FRequirementDate,FIssolateRule,FSOURCEBILLID,FStatus,FStorageUnitId,FTEMPID,FPURORGUNITID) select newbosid('88888888'), FProjectID,FTrackNumberID,fmaterialid,nvl(FDemandQty,0),nvl(FDemandQty,0),'" + userInfo.getId().toString() + "','" + userInfo.getId().toString() + "',  fLeadTime,FIssolateRule,fid,1,FStorageUnitId,Fid,FPurOrgID  from " + tmpDemandTable;
            int iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = "/*dialect*/ update T_PSP_PspStockPlanMiddle t1 set (FStockingPlanId,FWayQty ) =  (select sp.fid, nvl(nvl(t1.FQty,0)  - (nvl(sp.fqty,0) - nvl(sp.finstorageqty,0)), FQty)  from T_PSP_StockingPlan sp where   t1.fprojectid = sp.fprojectid and t1.FTraceNoID = sp.FTraceNoID and t1.fmaterialid = sp.fmaterialid)  where fstatus = 1 and t1.fprojectid is not null  and t1.FTraceNoID is not null";
            iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = "/*dialect*/ update T_PSP_PspStockPlanMiddle t1 set (FStockingPlanId,FWayQty ) =  (select sp.fid,nvl(nvl(t1.FQty,0)  - (nvl(sp.fqty,0) - nvl(sp.finstorageqty,0)), FQty)  from T_PSP_StockingPlan sp where   t1.fprojectid = sp.fprojectid and t1.fmaterialid = sp.fmaterialid )  where fstatus = 1 and t1.fprojectid is not null  and t1.FTraceNoID is  null";
            iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = "/*dialect*/ update T_PSP_PspStockPlanMiddle t1 set (FStockingPlanId,FWayQty ) =  (select sp.fid,nvl(nvl(t1.FQty,0)  - (nvl(sp.fqty,0) - nvl(sp.finstorageqty,0)), FQty)  from T_PSP_StockingPlan sp where    TO_CHAR(t1.frequirementdate,'YYYY-MM') = TO_CHAR(sp.frequirementdate,'YYYY-MM') and t1.fmaterialid = sp.fmaterialid)  where fstatus = 1 and t1.fprojectid is  null and t1.FTraceNoID is  null";
            iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = "/*dialect*/ update T_PSP_PspStockPlanMiddle  set Fstatus = 2 ,FQty =FWayQty where FWayQty != FQty";
            iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            sql = " update T_PSP_DEMANDIDTOPLANID t1 set FSTOCKPLANID = ( select FStockingPlanId from T_PSP_PspStockPlanMiddle t2 where t1.FTEMPID = t2.FTEMPID )";
            SQLUtils.execute((Context)ctx, (String)sql);
            this.generatePspChange(ctx);
            sql = " /*dialect*/ insert into T_PSP_StockingPlan(fid,fprojectid,FTraceNoID,fmaterialid,FQty, FCreatorID,FLastUpdateUserID,FRequirementDate, FIssolateRule,FSOURCEBILLID,FStatus,FUnit,FStorageOrgUnitID,FPurOrderQty,FTEMPID,FPURCHASEORGUNITID) select newbosid('F3C21C47'), psp.FProjectID,psp.FTraceNoID,psp.fmaterialid,nvl(psp.FQty,0),psp.FCreatorID,psp.FLastUpdateUserID, psp.FRequirementDate,psp.FIssolateRule,null,1,unit.fname_l2,psp.fstorageunitid,nvl(psp.FQty,0),psp.FTEMPID,psp.FPURORGUNITID  from T_PSP_PspStockPlanMiddle psp  left join t_bd_material mr on psp.fmaterialid = mr.fid  left join t_bd_measureunit unit on mr.fbaseunit = unit.fid  where nvl(psp.FQty,0) > 0 and  psp.Fstatus = 1";
            iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            if (iRe == 0) {
                return;
            }
            sql = " update T_PSP_DEMANDIDTOPLANID t1 set FSTOCKPLANID = ( select fid from T_PSP_StockingPlan t2 where t1.FTEMPID = t2.FTEMPID ) where t1.FSTOCKPLANID is null";
            SQLUtils.execute((Context)ctx, (String)sql);
            IStockingPlan iStockingPlan = StockingPlanFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfoSP = new EntityViewInfo();
            FilterInfo filterInfoSP = new FilterInfo();
            filterInfoSP.getFilterItems().add(new FilterItemInfo("Status", (Object)LATEST, CompareType.EQUALS));
            viewInfoSP.setFilter(filterInfoSP);
            StockingPlanCollection spCol = iStockingPlan.getStockingPlanCollection(viewInfoSP);
            if (spCol != null && spCol.size() > 0) {
                for (int i = 0; i < spCol.size(); ++i) {
                    StockingPlanInfo info = spCol.get(i);
                    this.setBillNumber(ctx, (IObjectValue)info, storageUnitId);
                    iStockingPlan.save((CoreBaseInfo)info);
                }
            }
            this.matchingPurOrder(ctx);
            sql = "/*dialect*/ update T_PSP_StockingPlan set fstatus = 0  where fstatus = 1";
            SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        } else if ("2".equals(rule)) {
            // empty if block
        }
    }

    private void matchingInventoryQty(Context ctx) throws BOSException, EASBizException, SQLException {
        IPspStockingDemand iPspStockingDemand = PspStockingDemandFactory.getLocalInstance(ctx);
        HashMap resultMap = new HashMap();
        HashMap paramMap = new HashMap();
        EntityViewInfo viewPSD = new EntityViewInfo();
        SorterItemCollection sortersPSD = new SorterItemCollection();
        SorterItemInfo sorterPSD = new SorterItemInfo("leadTime");
        sorterPSD.setSortType(SortType.ASCEND);
        sortersPSD.add(sorterPSD);
        viewPSD.setSorter(sortersPSD);
        PspStockingDemandCollection psdc = iPspStockingDemand.getPspStockingDemandCollection(viewPSD);
        BigDecimal totalInvQty = BigDecimal.ZERO;
        BigDecimal usedInvQty = BigDecimal.ZERO;
        StringBuffer sql = new StringBuffer();
        if (psdc.size() > 0) {
            sql.setLength(0);
            sql.append("delete from T_PSP_INVERTORYQTY");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        inventoryMap.clear();
        List<PspInventoryInfo> listInv = null;
        String mapKey = null;
        for (int i = 0; i < psdc.size(); ++i) {
            resultMap.clear();
            paramMap.clear();
            PspStockingDemandInfo psdInfo = psdc.get(i);
            if (psdInfo.getTmpMod() != null) continue;
            mapKey = psdInfo.getProductOrgUnit().getId().toString() + "#" + psdInfo.getMaterial().getId().toString();
            if (SOLATEDRULE_ITEM.equals(psdInfo.getIssolateRule())) {
                mapKey = mapKey + "#" + psdInfo.getProject().getId().toString();
            }
            if (SOLATEDRULE_ITEMTRACK.equals(psdInfo.getIssolateRule())) {
                mapKey = mapKey + "#" + psdInfo.getProject().getId().toString();
                mapKey = mapKey + "#" + psdInfo.getTrackNumber().getId().toString();
            }
            if (inventoryMap.get(mapKey) != null) {
                listInv = inventoryMap.get(mapKey);
            } else {
                listInv = this.getInventoryQty(ctx, psdInfo.getProductOrgUnit().getId().toString(), psdInfo.getIssolateRule(), psdInfo.getMaterial().getId().toString(), psdInfo.getProject().getId().toString(), psdInfo.getTrackNumber().getId().toString(), this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getSupplyRelation().getId().toString());
                inventoryMap.put(mapKey, listInv);
            }
            Collections.sort(listInv, new Comparator<PspInventoryInfo>(){

                @Override
                public int compare(PspInventoryInfo o1, PspInventoryInfo o2) {
                    if (o1.getLevel() > o2.getLevel()) {
                        return 1;
                    }
                    if (o1.getLevel() == o2.getLevel()) {
                        return 0;
                    }
                    return -1;
                }
            });
            totalInvQty = BigDecimal.ZERO;
            usedInvQty = BigDecimal.ZERO;
            for (PspInventoryInfo invInfo : listInv) {
                totalInvQty = totalInvQty.add(invInfo.getQty());
            }
            for (PspInventoryInfo invInfo : listInv) {
                if (psdInfo.getAllocateQty().compareTo(BigDecimal.ZERO) <= 0) break;
                if (psdInfo.getAllocateQty().compareTo(invInfo.getQty()) >= 0) {
                    psdInfo.setAllocateQty(psdInfo.getAllocateQty().subtract(invInfo.getQty()));
                    usedInvQty = usedInvQty.add(invInfo.getQty());
                    invInfo.setQty(BigDecimal.ZERO);
                    continue;
                }
                invInfo.setQty(invInfo.getQty().subtract(psdInfo.getAllocateQty()));
                usedInvQty = usedInvQty.add(psdInfo.getAllocateQty());
                psdInfo.setAllocateQty(BigDecimal.ZERO);
            }
            inventoryMap.put(mapKey, listInv);
            sql.setLength(0);
            sql.append("insert into T_PSP_INVERTORYQTY(FPSPSTOCKDEMANDID,FBASEQTY,FUSEDQTY)VALUES(?,?,?)");
            SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{psdInfo.getId().toString(), totalInvQty, usedInvQty});
            iPspStockingDemand.save((CoreBaseInfo)psdInfo);
        }
    }

    private void matchingInventory(Context ctx) throws BOSException, EASBizException, SQLException {
        IPspStockPlanMiddle iPspStockPlanMiddle = PspStockPlanMiddleFactory.getLocalInstance(ctx);
        HashMap resultMap = new HashMap();
        HashMap paramMap = new HashMap();
        PspStockPlanMiddleCollection spmc = iPspStockPlanMiddle.getPspStockPlanMiddleCollection();
        BigDecimal totalInvQty = BigDecimal.ZERO;
        for (int i = 0; i < spmc.size(); ++i) {
            inventoryMap.clear();
            resultMap.clear();
            paramMap.clear();
            PspStockPlanMiddleInfo spmInfo = spmc.get(i);
            List<PspInventoryInfo> listInv = this.getInventoryQty(ctx, spmInfo.getStorageUnitId(), spmInfo.getIssolateRule(), spmInfo.getMaterial().getId().toString(), spmInfo.getProject().getId().toString(), spmInfo.getTraceNo().getId().toString(), this.pspParams.getPspOperationSchemeInfo().getBatchOpeScheme().getSupplyRelation().getId().toString());
            Collections.sort(listInv, new Comparator<PspInventoryInfo>(){

                @Override
                public int compare(PspInventoryInfo o1, PspInventoryInfo o2) {
                    if (o1.getLevel() > o2.getLevel()) {
                        return 1;
                    }
                    if (o1.getLevel() == o2.getLevel()) {
                        return 0;
                    }
                    return -1;
                }
            });
            totalInvQty = BigDecimal.ZERO;
            for (PspInventoryInfo invInfo : listInv) {
                totalInvQty = totalInvQty.add(invInfo.getQty());
            }
            for (PspInventoryInfo invInfo : listInv) {
                if (spmInfo.getQty().compareTo(BigDecimal.ZERO) <= 0) break;
                if (spmInfo.getQty().compareTo(invInfo.getQty()) >= 0) {
                    spmInfo.setQty(spmInfo.getQty().subtract(invInfo.getQty()));
                    spmInfo.setUsedInvQty(spmInfo.getUsedInvQty().add(invInfo.getQty()));
                    invInfo.setQty(BigDecimal.ZERO);
                    continue;
                }
                invInfo.setQty(invInfo.getQty().subtract(spmInfo.getQty()));
                spmInfo.setQty(BigDecimal.ZERO);
                spmInfo.setUsedInvQty(spmInfo.getUsedInvQty().add(spmInfo.getQty()));
            }
            spmInfo.setInventoryQty(totalInvQty);
            iPspStockPlanMiddle.save((CoreBaseInfo)spmInfo);
        }
    }

    private void mergeData(Context ctx) throws SQLException, BOSException, EASBizException {
        EntityViewInfo viewOS = new EntityViewInfo();
        SelectorItemCollection sicOS = new SelectorItemCollection();
        sicOS.add(new SelectorItemInfo("*"));
        sicOS.add(new SelectorItemInfo("MergerRules.*"));
        sicOS.add(new SelectorItemInfo("MergerRules.entry.*"));
        sicOS.add(new SelectorItemInfo("Storage.id"));
        viewOS.setSelector(sicOS);
        FilterInfo filterOS = new FilterInfo();
        filterOS.getFilterItems().add(new FilterItemInfo("Storage.id", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filterOS.getFilterItems().add(new FilterItemInfo("State", (Object)10, CompareType.EQUALS));
        viewOS.setFilter(filterOS);
        PspOperationSchemeCollection osc = PspOperationSchemeFactory.getLocalInstance(ctx).getPspOperationSchemeCollection(viewOS);
        PspMergingRulesEntryCollection mrencol = null;
        if (osc != null && osc.size() > 0) {
            PspOperationSchemeInfo osInfo = osc.get(0);
            PspMergingRulesInfo mrInfo = osInfo.getMergerRules();
            mrencol = mrInfo.getEntry();
        }
        if (mrencol == null || mrencol.size() == 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        String sql = "";
        IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
        for (int i = 0; i < mrencol.size(); ++i) {
            PspMergingRulesEntryInfo mren = mrencol.get(i);
            FilterInfo filtersp = new FilterInfo();
            filtersp.getFilterItems().add(new FilterItemInfo("StoreOrgUnit", (Object)mren.getSupplyOrg(), CompareType.EQUALS));
            ev.setFilter(filtersp);
            if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FRequirementDate";
            } else if ("2".equals(mren.getMaterialRule().getValue())) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FPROJECTID,FRequirementDate";
            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FPROJECTID,FTRACENOID,FRequirementDate";
            }
            IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
            int j = 0;
            String material = "";
            String project = "";
            String traceno = "";
            BigDecimal qty = BigDecimal.ZERO;
            Timestamp RequirementDate = null;
            Calendar cc = Calendar.getInstance();
            if (rowSet == null || rowSet.size() <= 0) continue;
            while (rowSet.next()) {
                TrackNumberInfo tn;
                ProjectInfo p;
                MaterialInfo m;
                StockingPlanInfo spInfo;
                if (j == 0) {
                    material = rowSet.getString("FMaterialID");
                    RequirementDate = rowSet.getTimestamp("FRequirementDate");
                    project = rowSet.getString("FPROJECTID");
                    traceno = rowSet.getString("FTRACENOID");
                    cc.setTime(RequirementDate);
                    cc.add(5, mren.getCycle().intValue());
                }
                if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null) {
                    if (material.equals(rowSet.getString("FMaterialID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                        qty = qty.add(rowSet.getBigDecimal("FQty"));
                        ++j;
                        continue;
                    }
                    spInfo = new StockingPlanInfo();
                    spInfo.setId(BOSUuid.create((String)"888888"));
                    m = new MaterialInfo();
                    m.setId(BOSUuid.read((String)material));
                    spInfo.setMaterial(m);
                    spInfo.setQty(qty);
                    spInfo.setRequirementDate(RequirementDate);
                    p = new ProjectInfo();
                    p.setId(BOSUuid.read((String)project));
                    spInfo.setProject(p);
                    tn = new TrackNumberInfo();
                    tn.setId(BOSUuid.read((String)traceno));
                    spInfo.setTraceNo(tn);
                    isp.save((CoreBaseInfo)spInfo);
                    j = 0;
                    qty = BigDecimal.ZERO;
                    rowSet.previous();
                    continue;
                }
                if ("2".equals(mren.getMaterialRule().getValue())) {
                    if (material.equals(rowSet.getString("FMaterialID")) && project.equals(rowSet.getString("FPROJECTID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                        qty = qty.add(rowSet.getBigDecimal("FQty"));
                        ++j;
                        continue;
                    }
                    spInfo = new StockingPlanInfo();
                    spInfo.setId(BOSUuid.create((String)"888888"));
                    m = new MaterialInfo();
                    m.setId(BOSUuid.read((String)material));
                    spInfo.setMaterial(m);
                    spInfo.setQty(qty);
                    spInfo.setRequirementDate(RequirementDate);
                    p = new ProjectInfo();
                    p.setId(BOSUuid.read((String)project));
                    spInfo.setProject(p);
                    tn = new TrackNumberInfo();
                    tn.setId(BOSUuid.read((String)traceno));
                    spInfo.setTraceNo(tn);
                    isp.save((CoreBaseInfo)spInfo);
                    j = 0;
                    qty = BigDecimal.ZERO;
                    rowSet.previous();
                    continue;
                }
                if (!"3".equals(mren.getMaterialRule().getValue())) continue;
                if (material.equals(rowSet.getString("FMaterialID")) && project.equals(rowSet.getString("FPROJECTID")) && traceno.equals(rowSet.getString("FTRACENOID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                    qty = qty.add(rowSet.getBigDecimal("FQty"));
                    ++j;
                    continue;
                }
                spInfo = new StockingPlanInfo();
                spInfo.setId(BOSUuid.create((String)"888888"));
                m = new MaterialInfo();
                m.setId(BOSUuid.read((String)material));
                spInfo.setMaterial(m);
                spInfo.setQty(qty);
                spInfo.setRequirementDate(RequirementDate);
                p = new ProjectInfo();
                p.setId(BOSUuid.read((String)project));
                spInfo.setProject(p);
                tn = new TrackNumberInfo();
                tn.setId(BOSUuid.read((String)traceno));
                spInfo.setTraceNo(tn);
                isp.save((CoreBaseInfo)spInfo);
                j = 0;
                qty = BigDecimal.ZERO;
                rowSet.previous();
            }
        }
    }

    private String createTempInvTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("Fmaterialid nvarchar(255)");
        sql.append(",\r\n FProjectID nvarchar(255)");
        sql.append(",\r\n FTrackNumberID nvarchar(255)");
        sql.append(",\r\n FCurStoreQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempPurTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("fprojectid nvarchar(255)");
        sql.append(",\r\n fmaterialid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n FQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FusedQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempSPTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("fprojectid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n fmaterialid nvarchar(255)");
        sql.append(",\r\n FQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FDateTime nvarchar(255)");
        sql.append(",\r\n FInWHQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FWayQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempLeadTimeTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("Fproductorgunitid nvarchar(255)");
        sql.append(",\r\n Fprojectid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n Fmaterialid nvarchar(255)");
        sql.append(",\r\n Fpladnode nvarchar(255)");
        sql.append(",\r\n Fleadtime0 timestamp");
        sql.append(",\r\n Fleadtime1 timestamp");
        sql.append(",\r\n FMleadday0 NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FMleadday1 NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempStockingPlanSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("FID nvarchar(44)");
        sql.append(",\r\n FREQUIREMENTDATE timestamp");
        sql.append(",\r\n FSUPPLIERID nvarchar(255)");
        sql.append(",\r\n FMATERIALID nvarchar(255)");
        sql.append(",\r\n FPROJECTID nvarchar(255)");
        sql.append(",\r\n FTRACENOID nvarchar(255)");
        sql.append(",\r\n FQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FSTATUS nvarchar(255)");
        sql.append(",\r\n FSOURCEBILLID nvarchar(255)");
        sql.append(",\r\n FSOURCEPSPDEMANDBI nvarchar(255)");
        sql.append(",\r\n FISSOLATERULE nvarchar(255)");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempStockingPlanDemand(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DataNew ( ");
        sql.append("FName_l1 NVARCHAR(255)");
        sql.append(",\r\n FName_l2 NVARCHAR(255)");
        sql.append(",\r\n FName_l3 NVARCHAR(255)");
        sql.append(",\r\n FNumber NVARCHAR(80)");
        sql.append(",\r\n FDescription_l1 NVARCHAR(255)");
        sql.append(",\r\n FDescription_l2 NVARCHAR(255)");
        sql.append(",\r\n FDescription_l3 NVARCHAR(255)");
        sql.append(",\r\n FSimpleName NVARCHAR(80)");
        sql.append(",\r\n FID VARCHAR(44) DEFAULT '' ");
        sql.append(",\r\n FCreatorID VARCHAR(44)");
        sql.append(",\r\n FCreateTime DateTime");
        sql.append(",\r\n FLastUpdateUserID VARCHAR(44)");
        sql.append(",\r\n FLastUpdateTime DateTime");
        sql.append(",\r\n FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4'");
        sql.append(",\r\n FProjectID VARCHAR(44)");
        sql.append(",\r\n FTmpMod NUMERIC(28, 10)");
        sql.append(",\r\n FPurOrgID VARCHAR(44)");
        sql.append(",\r\n FMaterialID VARCHAR(44)");
        sql.append(",\r\n FMaterialName NVARCHAR(80)");
        sql.append(",\r\n FMaterialModel NVARCHAR(80)");
        sql.append(",\r\n FMaterialUnit NVARCHAR(80)");
        sql.append(",\r\n FTrackNumberID VARCHAR(44)");
        sql.append(",\r\n FDemandQty NUMERIC(28, 10)");
        sql.append(",\r\n FLeadTime DateTime");
        sql.append(",\r\n FAllocateQty NUMERIC(28, 10)");
        sql.append(",\r\n FAllocatedQty NUMERIC(28, 10)");
        sql.append(",\r\n FUnAllocatedQty NUMERIC(28, 10)");
        sql.append(",\r\n FRunStatus INT");
        sql.append(",\r\n FIssolateRule NVARCHAR(100)");
        sql.append(",\r\n FFinishTime VARCHAR(44)");
        sql.append(",\r\n FOrderQty NUMERIC(28,10)");
        sql.append(",\r\n FUnOrderQty NUMERIC(28, 10)");
        sql.append(",\r\n FMaterialPlanNode NVARCHAR(100)");
        sql.append(",\r\n FDemandSeq CLOB");
        sql.append(",\r\n FStorageUnitId NVARCHAR(44));");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private BigDecimal getInventoryQty(Context ctx, String orgid, String solatedrule, String materialid, String projectid, String trackid, BigDecimal qty, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        BigDecimal inventoryqty = BigDecimal.ZERO;
        String sql = null;
        IRowSet rs = null;
        String materialkey = null;
        PspInventoryInfo invInfo = new PspInventoryInfo();
        ArrayList<PspInventoryInfo> listInv = new ArrayList<PspInventoryInfo>();
        if (SOLATEDRULE_NONE.equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + SOLATEDRULE_NONE;
            sql = queryInventory;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, this.getStringIDByList2(listStorageOrgIdBySupply)});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        } else if (SOLATEDRULE_ITEM.equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + SOLATEDRULE_ITEM;
            sql = queryInventory_item;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, this.getStringIDByList2(listStorageOrgIdBySupply)});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        } else {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + trackid + "#" + SOLATEDRULE_ITEM;
            sql = queryInventory_itemtrack;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, this.getStringIDByList2(listStorageOrgIdBySupply)});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        }
        inventoryMap.put(materialkey, listInv);
        return inventoryqty;
    }

    private List<PspInventoryInfo> getInventoryQty(Context ctx, String orgid, String solatedrule, String materialid, String projectid, String trackid, String supplyrelationid) throws SQLException, BOSException, EASBizException {
        BigDecimal inventoryqty = BigDecimal.ZERO;
        String sql = null;
        IRowSet rs = null;
        String materialkey = null;
        PspInventoryInfo invInfo = new PspInventoryInfo();
        ArrayList<PspInventoryInfo> listInv = new ArrayList<PspInventoryInfo>();
        if (SOLATEDRULE_NONE.equals(solatedrule) || solatedrule == null) {
            materialkey = materialid + "#" + orgid + "#" + SOLATEDRULE_NONE;
            sql = queryInventory;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplyrelationid, materialid, supplyrelationid});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        } else if (SOLATEDRULE_ITEM.equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + SOLATEDRULE_ITEM;
            sql = queryInventory_item;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplyrelationid, materialid, supplyrelationid, projectid});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        } else {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + trackid + "#" + SOLATEDRULE_ITEM;
            sql = queryInventory_itemtrack;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplyrelationid, materialid, supplyrelationid, projectid, trackid});
            if (rs.next()) {
                invInfo.setStorageOrgUnitId(rs.getString("fstorageOrgunitid"));
                invInfo.setLevel(rs.getInt("cfprioritylevel"));
                invInfo.setQty(rs.getBigDecimal(INVENTORY));
                listInv.add(invInfo);
            }
        }
        return listInv;
    }

    private void getResultMakeMap(IRowSet rs, String propName, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        if (rs.getObject(propName) instanceof String) {
            map.put(propName, rs.getString(propName));
        } else if (rs.getObject(propName) instanceof Timestamp) {
            map.put(propName, rs.getTimestamp(propName));
        } else if (rs.getObject(propName) instanceof BigDecimal) {
            map.put(propName, rs.getBigDecimal(propName));
        } else if (rs.getObject(propName) instanceof Date) {
            java.sql.Date date = rs.getDate(propName);
            Timestamp tmp = new Timestamp(date.getTime());
            map.put(propName, tmp);
        } else {
            map.put(propName, rs.getObject(propName));
        }
    }

    private void matchInventory(Context ctx, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        BigDecimal invqty = BigDecimal.ZERO;
        String materialid = (String)map.get(MATERIALID);
        String projectid = (String)map.get(PROJECTID);
        String trackid = (String)map.get(TRACKID);
        String orgid = (String)map.get(ORGID);
        BigDecimal qty = (BigDecimal)map.get(QTY);
        String solatedRule = (String)map.get(ISSOLATERULE);
        invqty = this.getInventoryQty(ctx, orgid, solatedRule, materialid, projectid, trackid, qty, map);
        map.put(ISSOLATERULE, solatedRule);
    }

    private String getPurOrgFindStorageOrg(Context ctx, String PurOrgId) throws SQLException, BOSException {
        String storageOrgId = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" Select aa.ftounitid  from T_ORG_UnitRelation aa ").append(" inner join T_ORG_TypeRelation bb on aa.ftyperelationid = bb.fid ").append(" where  aa.ffromunitid = ?").append(" and bb.ffromtype = 3 ").append(" and bb.ftotype = 4 ").append(" and rownum = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{PurOrgId});
        if (rs.next()) {
            storageOrgId = rs.getString("ftounitid");
        }
        return storageOrgId;
    }

    private void generatePspChange(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        try {
            sql.append(" /*dialect*/ ");
            sql.append(" select tm.fqty as qty,tm.frequirementdate as rdate,sp.fqty as spqty,sp.frequirementdate as sprdate ,tm.fstockingplanid as pspid");
            sql.append(" from T_PSP_PspStockPlanMiddle tm ");
            sql.append(" left join T_PSP_StockingPlan  sp on sp.fid = tm.fstockingplanid ");
            sql.append(" where tm.fstockingplanid is not null and tm.fstatus = 2 ");
            IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    int middleQty = rowSet.getInt("qty");
                    java.sql.Date middleDate = rowSet.getDate("rdate");
                    int pspPlanQty = rowSet.getInt("spqty");
                    java.sql.Date pspPlanDate = rowSet.getDate("sprdate");
                    String pspPlanId = rowSet.getString("pspid");
                    this.genPspChangeInfo(ctx, pspPlanId, middleQty, middleDate, pspPlanQty, pspPlanDate);
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void genPspChangeInfo(Context ctx, String pspPlanId, int middleQty, Date middleDate, int pspPlanQty, Date pspPlanDate) throws Exception {
        if (pspPlanId == null) {
            return;
        }
        int ToleranceDays = 7;
        int daysBetween = Math.abs(this.daysBetween(middleDate, pspPlanDate));
        if (middleQty == 0 && daysBetween < ToleranceDays) {
            return;
        }
        String existSPCid = this.getExistSPC(ctx, pspPlanId);
        StockingPlanChangeInfo pspChangeInfo = new StockingPlanChangeInfo();
        if (existSPCid != null) {
            ObjectUuidPK pk = new ObjectUuidPK();
            pk.setKeyValue("id", (Object)existSPCid);
            pspChangeInfo = StockingPlanChangeFactory.getLocalInstance(ctx).getStockingPlanChangeInfo((IObjectPK)pk);
            if (pspChangeInfo == null) {
                return;
            }
        } else {
            pspChangeInfo.setId(BOSUuid.create((BOSObjectType)pspChangeInfo.getBOSType()));
        }
        StockingPlanInfo sPInfo = new StockingPlanInfo();
        ObjectUuidPK pk = new ObjectUuidPK();
        pk.setKeyValue("id", (Object)pspPlanId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Material.*"));
        selector.add(new SelectorItemInfo("Project.*"));
        selector.add(new SelectorItemInfo("TrackNo.*"));
        sPInfo = StockingPlanFactory.getLocalInstance(ctx).getStockingPlanInfo((IObjectPK)pk, selector);
        if (sPInfo != null) {
            pspChangeInfo.setStockingPlan(sPInfo);
        }
        if (sPInfo.getMaterial() != null) {
            pspChangeInfo.setMaterial(sPInfo.getMaterial().getName());
        }
        if (sPInfo.getProject() != null) {
            pspChangeInfo.setProjectNumber(sPInfo.getProject().getNumber());
        }
        if (sPInfo.getTraceNo() != null) {
            pspChangeInfo.setTrackNo(sPInfo.getTraceNo().getNumber());
        }
        pspChangeInfo.setLeadQty(sPInfo.getQty());
        pspChangeInfo.setLeadDate(sPInfo.getRequirementDate());
        if (daysBetween > ToleranceDays) {
            pspChangeInfo.setChangeLeadDate(middleDate);
        } else {
            pspChangeInfo.setChangeLeadDate(pspPlanDate);
        }
        pspChangeInfo.setChangeQty(sPInfo.getQty().add(BigDecimal.valueOf(middleQty)));
        if (daysBetween > ToleranceDays && middleQty != 0) {
            pspChangeInfo.setChangeType(PspChangeType.TBQD);
        } else if (daysBetween > ToleranceDays && middleQty == 0) {
            pspChangeInfo.setChangeType(PspChangeType.TDATE);
        } else if (daysBetween <= ToleranceDays && middleQty != 0) {
            pspChangeInfo.setChangeType(PspChangeType.TQTY);
        }
        pspChangeInfo.setChangeStatus(PspChangeState.ADDNEW);
        this.setBillNumber(ctx, (IObjectValue)pspChangeInfo, sPInfo.getPurChaseOrgUnit().getId().toString());
        StockingPlanChangeFactory.getLocalInstance(ctx).save((CoreBaseInfo)pspChangeInfo);
    }

    private String getExistSPC(Context ctx, String spid) throws EASBizException, BOSException, SQLException {
        if (spid == null || spid.isEmpty()) {
            return null;
        }
        String fid = null;
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" /*dialect*/ ");
        sql.append(" select fid from T_psp_stockingplanchange where fstockingplanID = '");
        sql.append(spid);
        sql.append("' and fchangestatus < 30");
        IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
        if (rowSet != null && rowSet.size() > 0 && rowSet.next()) {
            fid = rowSet.getString("fid");
        }
        return fid;
    }

    public int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    private void matchingPurOrder(Context ctx) throws BOSException, EASBizException {
        String sql = "/*dialect*/ insert into T_PSP_StockingPlanPurOrder(Fid,Fusedpurqty,FMaterailID,FProjectID,FPurorder,FTracknoID,FSupplierID,FPurorderqty,FBeginTrackNumber,FEndTrackNumber,FCreatorID,FLastUpdateUserID,FAuditTime,FStorageOrgUnit)   select newbosid('178F0DA8'),0,fmaterialid,fprojectid,purfid,FTrackNoID,fsupplierid,FTotalUnReceiveQty,begtracknum,endtracknum,FCreatorID,FLastUpdateUserID,FAuditTime,fstorageorgunitid   from( select  distinct t1.fmaterialid,t1.fprojectid,pur.fid purfid,pure.FTrackNoID,pur.fsupplierid,pure.FTotalUnReceiveQty,begtn.fnumber begtracknum,endtn.fnumber endtracknum , t1.FCreatorID,t1.FLastUpdateUserID,pur.FAuditTime,pure.fstorageorgunitid from T_PSP_StockingPlan t1   left join T_SM_PurOrder pur on  pur.fpurchaseorgunitid = t1.fpurchaseorgunitid  inner join t_Sm_Purorderentry pure on  pur.fid =pure.fparentid and pure.fmaterialid = t1.fmaterialid    left join T_MM_TRACKNUMBER begtn on pure.ftracknoid = begtn.fid  left join T_MM_TRACKNUMBER endtn  on pure.cfendtracknoid = endtn.fid  where (t1.fissolaterule ='NONE' or t1.fissolaterule is null) and t1.FQty > 0 and  t1.fstatus = 1 and pur.fbasestatus = 4  and pure.fstorageorgunitid in " + this.getStringIDByList(listStorageOrgIdBySupply) + ")";
        int iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        this.matchingPurOrderData(ctx, 1);
        sql = "/*dialect*/ insert into T_PSP_StockingPlanPurOrder(Fid,Fusedpurqty,FMaterailID,FProjectID,FPurorder,FTracknoID,FSupplierID,FPurorderqty,FBeginTrackNumber,FEndTrackNumber,FCreatorID,FLastUpdateUserID,FAuditTime,FStorageOrgUnit)   select newbosid('178F0DA8'),0,fmaterialid,fprojectid,purfid,FTrackNoID,fsupplierid,FTotalUnReceiveQty,begtracknum,endtracknum,FCreatorID,FLastUpdateUserID,FAuditTime,fstorageorgunitid   from( select  distinct t1.fmaterialid,t1.fprojectid,pur.fid purfid,pure.FTrackNoID,pur.fsupplierid,pure.FTotalUnReceiveQty,begtn.fnumber begtracknum,endtn.fnumber endtracknum , t1.FCreatorID,t1.FLastUpdateUserID,pur.FAuditTime,pure.fstorageorgunitid from T_PSP_StockingPlan t1   left join T_SM_PurOrder pur on  pur.fpurchaseorgunitid = t1.fpurchaseorgunitid  inner join t_Sm_Purorderentry pure on pur.fid =pure.fparentid and pure.fprojectid = t1.fprojectid  and pure.fmaterialid = t1.fmaterialid  left join T_MM_TRACKNUMBER begtn on pure.ftracknoid = begtn.fid  left join T_MM_TRACKNUMBER endtn  on pure.cfendtracknoid = endtn.fid  where t1.fissolaterule ='ITEM'  and t1.FQty > 0 and  t1.fstatus = 1 and pur.fbasestatus = 4  and pure.fstorageorgunitid in " + this.getStringIDByList(listStorageOrgIdBySupply) + ")";
        iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        this.matchingPurOrderData(ctx, 2);
        sql = "/*dialect*/ insert into T_PSP_StockingPlanPurOrder(Fid,Fusedpurqty,FMaterailID,FProjectID,FPurorder,FTracknoID,FSupplierID,FPurorderqty,FBeginTrackNumber,FEndTrackNumber,FCreatorID,FLastUpdateUserID,FAuditTime,FStorageOrgUnit)   select newbosid('178F0DA8'),0,fmaterialid,fprojectid,purfid,FTrackNoID,fsupplierid,FTotalUnReceiveQty,begtracknum,endtracknum,FCreatorID,FLastUpdateUserID,FAuditTime,fstorageorgunitid   from( select  distinct t1.fmaterialid,t1.fprojectid,pur.fid purfid,pure.FTrackNoID,pur.fsupplierid,pure.FTotalUnReceiveQty,begtn.fnumber begtracknum,endtn.fnumber endtracknum , t1.FCreatorID,t1.FLastUpdateUserID,pur.FAuditTime,pure.fstorageorgunitid from T_PSP_StockingPlan t1   left join T_SM_PurOrder pur on  pur.fpurchaseorgunitid = t1.fpurchaseorgunitid  inner join t_Sm_Purorderentry pure on pur.fid =pure.fparentid and pure.fprojectid = t1.fprojectid and pure.ftracknoid = t1.FTraceNoID and pure.fmaterialid = t1.fmaterialid   left join T_MM_TRACKNUMBER begtn on pure.ftracknoid = begtn.fid  left join T_MM_TRACKNUMBER endtn  on pure.cfendtracknoid = endtn.fid  where t1.fissolaterule ='ITEM_TRACKNO'  and t1.FQty > 0 and  t1.fstatus = 1 and pur.fbasestatus = 4  and pure.fstorageorgunitid in " + this.getStringIDByList(listStorageOrgIdBySupply) + ")";
        iRe = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        this.matchingPurOrderData(ctx, 3);
        sql = " update T_PSP_StockingPlan set FPurorderqty = FQty - FPurorderqty ";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
    }

    private void matchingPurOrderData(Context ctx, int matchType) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        BigDecimal useQty = BigDecimal.ZERO;
        EntityViewInfo viewSP = new EntityViewInfo();
        SelectorItemCollection sicSP = new SelectorItemCollection();
        sicSP.add(new SelectorItemInfo("*"));
        sicSP.add(new SelectorItemInfo("TRACENO.number"));
        sicSP.add(new SelectorItemInfo("Project.number"));
        sicSP.add(new SelectorItemInfo("Material.number"));
        viewSP.setSelector(sicSP);
        FilterInfo filterSP = new FilterInfo();
        if (matchType == 1) {
            filterSP.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_NONE, CompareType.EQUALS));
            filterSP.getFilterItems().add(new FilterItemInfo("Qty", (Object)0, CompareType.GREATER));
            filterSP.getFilterItems().add(new FilterItemInfo("Status", (Object)1, CompareType.EQUALS));
            filterSP.setMaskString("#0 and #1 and #2");
        } else if (matchType == 2) {
            filterSP.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_ITEM, CompareType.EQUALS));
            filterSP.getFilterItems().add(new FilterItemInfo("Qty", (Object)0, CompareType.GREATER));
            filterSP.getFilterItems().add(new FilterItemInfo("Status", (Object)1, CompareType.EQUALS));
            filterSP.setMaskString("#0 and #1 and #2");
        } else {
            filterSP.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_ITEMTRACK, CompareType.EQUALS));
            filterSP.getFilterItems().add(new FilterItemInfo("Qty", (Object)0, CompareType.GREATER));
            filterSP.getFilterItems().add(new FilterItemInfo("Status", (Object)1, CompareType.EQUALS));
            filterSP.setMaskString("#0 and #1 and #2");
        }
        viewSP.setFilter(filterSP);
        SorterItemCollection sortersSP = new SorterItemCollection();
        SorterItemInfo sorterSP = new SorterItemInfo("TraceNo.number");
        sorterSP.setSortType(SortType.ASCEND);
        sortersSP.add(sorterSP);
        viewSP.setSorter(sortersSP);
        IStockingPlanPurOrder isppo = StockingPlanPurOrderFactory.getLocalInstance(ctx);
        IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
        CoreBaseCollection spColl = isp.getCollection(viewSP);
        StockingPlanPurOrderInfo sppoInfo = null;
        StockingPlanInfo spInfo = null;
        for (int i = 0; i < spColl.size(); ++i) {
            spInfo = (StockingPlanInfo)spColl.get(i);
            EntityViewInfo viewSPPO = new EntityViewInfo();
            SelectorItemCollection sicSPPO = new SelectorItemCollection();
            sicSPPO.add(new SelectorItemInfo("*"));
            sicSPPO.add(new SelectorItemInfo("material.number"));
            viewSPPO.setSelector(sicSPPO);
            FilterInfo filterSPPO = new FilterInfo();
            if (matchType == 1) {
                filterSPPO.getFilterItems().add(new FilterItemInfo("materail.number", (Object)spInfo.getMaterial().getNumber(), CompareType.EQUALS));
            } else if (matchType == 2) {
                if (spInfo.getProject() != null) {
                    filterSPPO.getFilterItems().add(new FilterItemInfo("project.number", (Object)spInfo.getProject().getNumber(), CompareType.EQUALS));
                }
                filterSPPO.getFilterItems().add(new FilterItemInfo("materail.number", (Object)spInfo.getMaterial().getNumber(), CompareType.EQUALS));
            } else {
                if (spInfo.getProject() != null) {
                    filterSPPO.getFilterItems().add(new FilterItemInfo("project.number", (Object)spInfo.getProject().getNumber(), CompareType.EQUALS));
                }
                filterSPPO.getFilterItems().add(new FilterItemInfo("materail.number", (Object)spInfo.getMaterial().getNumber(), CompareType.EQUALS));
                if (spInfo.getTraceNo() != null) {
                    filterSPPO.getFilterItems().add(new FilterItemInfo("beginTrackNumber", (Object)spInfo.getTraceNo().getNumber(), CompareType.LESS_EQUALS));
                    filterSPPO.getFilterItems().add(new FilterItemInfo("endTrackNumber", (Object)spInfo.getTraceNo().getNumber(), CompareType.GREATER_EQUALS));
                }
            }
            viewSPPO.setFilter(filterSPPO);
            SorterItemCollection sortersSPPO = new SorterItemCollection();
            SorterItemInfo sorterSPPO = new SorterItemInfo("auditTime");
            sorterSPPO.setSortType(SortType.ASCEND);
            sortersSPPO.add(sorterSPPO);
            viewSPPO.setSorter(sortersSPPO);
            StockingPlanPurOrderCollection sppoc = isppo.getStockingPlanPurOrderCollection(viewSPPO);
            if (sppoc == null || sppoc.size() <= 0) continue;
            if (sppoc.size() == 1) {
                sppoInfo = sppoc.get(0);
                if (sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty()) == BigDecimal.ZERO || spInfo.getPurOrderQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                useQty = BigDecimal.ZERO;
                if (spInfo.getPurOrderQty().compareTo(sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty())) <= 0) {
                    useQty = spInfo.getPurOrderQty();
                    sppoInfo.setUsedPurQty(sppoInfo.getUsedPurQty().add(useQty));
                    spInfo.setPurOrderQty(BigDecimal.ZERO);
                    spInfo.setSupplier(sppoInfo.getSupplier());
                } else {
                    useQty = sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty());
                    spInfo.setPurOrderQty(spInfo.getPurOrderQty().subtract(useQty));
                    spInfo.setSupplier(sppoInfo.getSupplier());
                    sppoInfo.setUsedPurQty(sppoInfo.getPurorderQty());
                }
                isppo.save((CoreBaseInfo)sppoInfo);
                isp.save((CoreBaseInfo)spInfo);
                sql.setLength(0);
                sql.append("insert into T_PSP_StockPlanMatchingPur(FPURORDER,FPURORDERQTY,FUSEDPURQTY,FSTOCKPLANID)values(?,?,?,?)");
                SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{sppoInfo.getPurorder(), sppoInfo.getPurorderQty(), useQty, spInfo.getId().toString()});
                continue;
            }
            for (int iList = 0; iList < sppoc.size() && !spInfo.getPurOrderQty().equals(BigDecimal.ZERO); ++iList) {
                sppoInfo = sppoc.get(iList);
                if (sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty()) == BigDecimal.ZERO) continue;
                useQty = BigDecimal.ZERO;
                if (spInfo.getPurOrderQty().compareTo(sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty())) <= 0) {
                    useQty = spInfo.getPurOrderQty();
                    sppoInfo.setUsedPurQty(sppoInfo.getUsedPurQty().add(useQty));
                    spInfo.setPurOrderQty(BigDecimal.ZERO);
                    spInfo.setSupplier(sppoInfo.getSupplier());
                } else {
                    useQty = sppoInfo.getPurorderQty().subtract(sppoInfo.getUsedPurQty());
                    spInfo.setPurOrderQty(spInfo.getPurOrderQty().subtract(useQty));
                    spInfo.setSupplier(sppoInfo.getSupplier());
                    sppoInfo.setUsedPurQty(sppoInfo.getPurorderQty());
                }
                isppo.save((CoreBaseInfo)sppoInfo);
                isp.save((CoreBaseInfo)spInfo);
                sql.setLength(0);
                sql.append("insert into T_PSP_StockPlanMatchingPur(FPURORDER,FPURORDERQTY,FUSEDPURQTY,FSTOCKPLANID)values(?,?,?,?)");
                SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{sppoInfo.getPurorder(), sppoInfo.getPurorderQty(), useQty, spInfo.getId().toString()});
            }
        }
    }

    private String getStringIDByList(List idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = idList.iterator();
        strBuf.append("(");
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.append(")");
        } else {
            strBuf.append(")");
        }
        return strBuf.toString();
    }

    private String getStringIDByList2(List idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
        }
        return strBuf.toString();
    }

    private String getStringIDByListInvInfo(List<PspInventoryInfo> idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator<PspInventoryInfo> it = idList.iterator();
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next().getStorageOrgUnitId());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
        }
        return strBuf.toString();
    }
}

