/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.IPspStockingDemand;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlan;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspMergingRulesInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspOperationSchemeInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.app.AbstractPspStockingScheduleControllerBean;
import com.kingdee.eas.industry.emm.project.biz.psp.app.PspDemand;
import com.kingdee.eas.industry.emm.project.biz.psp.app.PspProjectInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.util.PspParameterSet;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PspStockingScheduleControllerBean
extends AbstractPspStockingScheduleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.psp.app.PspStockingScheduleControllerBean");
    private PspParameterSet pspParams = new PspParameterSet();
    private static UserInfo userInfo = null;
    private Map<String, BigDecimal> inventoryMap = new HashMap<String, BigDecimal>();
    static final String SOLATEDRULE_NONE = "NONE";
    static final String SOLATEDRULE_ITEM = "ITEM";
    static final String SOLATEDRULE_ITEMTRACK = "ITEM_TRACKNO";
    static final String SOLATEDRULE = "FISOLATEDRULE";
    static final String MergeMaterialReqDate = "MergeMaterialReqDate";
    static final String EARLIEST = "0";
    static final String LATEST = "1";
    static final String INVENTORY = "INVENTORY";
    static final String PROJECTID = "PROJECTID";
    static final String TRACKID = "TRACKID";
    static final String ORGID = "ORGID";
    static final String MATERIALID = "MATERIALID";
    static final String ISSOLATERULE = "ISSOLATERULE";
    static final String QTY = "QTY";
    static final String queryInventory_itemtrack = "select fmaterialid,fstorageOrgunitid,fprojectid,ftracknumberid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=? and fprojectid=? and ftracknumberid=?  and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fprojectid,ftracknumberid";
    static final String queryInventory_item = "select fmaterialid,fstorageOrgunitid,fprojectid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=? and fprojectid=?   and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid,fprojectid";
    static final String queryInventory = "select fmaterialid,fstorageOrgunitid,SUM(fcurstoreqty) INVENTORY from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid \tleft join CT_IN_Depottype c on b.Cfdepottypeid = C.FID  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where a.fmaterialid=? and a.fstorageOrgunitid=?  and B.CFDEPOTTYPEID IS NOT NULL AND C.CFFATTRIBLE = 1 and e.fnumber in ('1','201','202','203')  group by fmaterialid,fstorageOrgunitid";

    @Override
    protected void _generatePSP(Context ctx, PspParameterSet paramsSet) throws BOSException, EASBizException {
        this.checkParams(paramsSet);
        this.pspParams = paramsSet;
        List pcpList = this.getPCP(ctx);
        if (pcpList == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u5236\u5931\u8d25", "\u5c55\u671b\u671f\u5185\u6ca1\u6709\u9879\u76ee\uff01"));
        }
        List pcpTrialList = (List)pcpList.get(0);
        List pcpMPList = (List)pcpList.get(1);
        try {
            this.handleTrialList(ctx, pcpTrialList);
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u5236\u5931\u8d25", e.getMessage()));
        }
    }

    private void checkParams(PspParameterSet paramsSet) throws EASBizException {
        if (paramsSet == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u5236\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (paramsSet.getPSPExpandDay() == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u5236\u5931\u8d25", "\u83b7\u53d6\u5c55\u671b\u671f\u5931\u8d25\uff01"));
        }
    }

    private void handleTrialList(Context ctx, List projectList) throws EASBizException, BOSException, SQLException {
        if (projectList == null) {
            return;
        }
        List pcpList1 = (List)projectList.get(0);
        List pcpList2 = (List)projectList.get(1);
        String tmpDemandTable = this.createTempStockingPlanDemand(ctx);
        this.templateGenPSD(ctx, pcpList1, tmpDemandTable);
        this.genStockingPlan(ctx, LATEST, tmpDemandTable);
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpDemandTable);
    }

    public List getPCP(Context ctx) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyString((String)this.pspParams.getPSPExpandDay())) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ \r\n");
        sql.append("  select pcp.FPROJECTID,pro.fnumber,pro.fname_l2,nvl(pur.CFRunStatus ,0) CFRunStatus ,nvl(pur.CFRunStatus ,0) hasTemplate ").append(" from T_PCP_ProjectCP pcp ").append(" left join T_MM_PROJECT pro  ON pcp.fprojectid = pro.fid ").append(" left join CT_PUR_BOMPurRequest pur on  pcp.fprojectid = pur.cfprojectnoid ").append(" left join CT_PSP_PspTemplate pt on pcp.fprojectid = pt.cfprojectnumberid ").append(" where pcp.FFINISHTIME >= trunc(sysdate ,'dd') ").append(" and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),").append(this.pspParams.getPSPExpandDay()).append(" ) ").append("  order by pcp.FFINISHTIME");
        try {
            IRowSet rs = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString());
            if (IndustryUtils.isEmptyRowSet((IRowSet)rs)) {
                return null;
            }
            ArrayList list = new ArrayList();
            ArrayList list1 = new ArrayList();
            ArrayList<PspProjectInfo> list2 = new ArrayList<PspProjectInfo>();
            ArrayList<PspProjectInfo> list3 = new ArrayList<PspProjectInfo>();
            ArrayList<PspProjectInfo> list4 = new ArrayList<PspProjectInfo>();
            while (rs.next()) {
                PspProjectInfo pspProjectInfo;
                if (rs.getInt("CFRunStatus") == 0) {
                    pspProjectInfo = new PspProjectInfo(rs.getString("FPROJECTID"), rs.getString("fnumber"), rs.getString("fname_l2"), rs.getInt("CFRunStatus"));
                    if (rs.getInt("hasTemplate") == 0) {
                        list3.add(pspProjectInfo);
                        continue;
                    }
                    list4.add(pspProjectInfo);
                    continue;
                }
                pspProjectInfo = new PspProjectInfo(rs.getString("FPROJECTID"), rs.getString("fnumber"), rs.getString("fname_l2"), rs.getInt("CFRunStatus"));
                list2.add(pspProjectInfo);
            }
            list1.add(list3);
            list1.add(list4);
            list.add(list1);
            list.add(list2);
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u6570\u636e\u51fa\u9519", e.getMessage()));
        }
    }

    private void algorithmGenPSP(Context ctx, List projectList) throws EASBizException, BOSException, SQLException {
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.setLength(0);
        for (int i = 0; i < projectList.size(); ++i) {
            PspProjectInfo pspProjectInfo = (PspProjectInfo)projectList.get(i);
            str.append(pspProjectInfo.getProjectId().toString());
            if (i >= projectList.size() - 1) continue;
            str.append(" , ");
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" /*dialect*/   ");
        sql.append("insert into CT_PSP_PSPSSE (Fid,FProjectID,FMaterialID,CFTrackNoID,FIssolateRule,FFinishTime) ");
        sql.append("select newbosid('88888888'),pcp.fprojectid,pue.fmaterialid,tn.fid,mp.FIsolatedRule,pcp.FFINISHTIME");
        sql.append("from T_PCP_projectcp   pcp ");
        sql.append("inner join t_mm_projectcar pc on pcp.fprojectid = pc.fprojectid ");
        sql.append("left join t_mm_tracknumber tn on pc.ftracknumberid = tn.fid ");
        sql.append("left join t_mm_project proj on pcp.fprojectid = proj.fid ");
        sql.append("inner join T_SM_PurOrderEntry pue on pcp.fprojectid = pue.fprojectid ");
        sql.append("left join T_SM_PurOrder pr on pr.fid = pue.fparentid ");
        sql.append("left join  t_bd_measureunit  tmu on pue.funitid = tmu.fid ");
        sql.append("left join T_BD_MaterialPlan mp on pue.fid = mp.fmaterialid ");
        sql.append("where pcp.fprojectid in ( '");
        sql.append(str);
        sql.append("' ) ");
        sql.append("and pr.fbasestatus = '1' ");
        sql.append("order by pcp.ffinishtime ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/   ");
        sql.append("update CT_PSP_PSPSSE psp set  (cfdemandqty,ftmpmod)  = (select m,n from( ");
        sql.append("select projectid,materialid,pjc.fid as projectcarid ,mod(qty , carnum) as n , (qty - mod(qty , carnum))/carnum as m from ( ");
        sql.append("select pue.fprojectid as projectid ,pue.fmaterialid as materialid ,count(pc.fid) as carnum,SUM(pue.fqty)/count(pc.fid)  as qty ");
        sql.append(",mod(SUM(pue.fqty)/count(pc.fid) ,count(pc.fid)) as n ,(SUM(pue.fqty)/count(pc.fid)-mod(SUM(pue.fqty)/count(pc.fid) ,count(pc.fid)))/count(pc.fid) as m ");
        sql.append("from  T_SM_PurOrderEntry pue ");
        sql.append("left join T_SM_PurOrder pr on pr.fid = pue.fparentid ");
        sql.append("left join T_PCP_projectcp  pcp on pcp.fprojectid = pue.fprojectid ");
        sql.append("left join t_mm_projectcar pc on pue.fprojectid = pc.fprojectid ");
        sql.append("where pcp.fprojectid in ( '");
        sql.append(str);
        sql.append("' ) ");
        sql.append("and pr.fbasestatus = '1' ");
        sql.append("group by pue.fprojectid,pue.fmaterialid) ");
        sql.append("inner join t_mm_projectcar pjc on pjc.fprojectid = projectid  ");
        sql.append(")where psp.fprojectid = projectid and psp.fmaterialid =materialid and psp.cftracknoid = projectcarid) ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/   ");
        sql.append("update ct_psp_pspsse set cfdemandqty = cfdemandqty+ ftmpmod,ftmpmod = 0    where fid in ( ");
        sql.append("select min(fid) as fid from ct_psp_pspsse psp  ");
        sql.append("where psp.fprojectid in ( '");
        sql.append(str);
        sql.append("' ) ");
        sql.append("group by  psp.fprojectid ,psp.fmaterialid) ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/   ");
        sql.append("update ct_psp_pspsse set ftmpmod = 0 ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
        sql.setLength(0);
        sql.append(" /*dialect*/   ");
        sql.append("delete ct_psp_pspsse where cfdemandqty = 0 ");
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql.toString());
    }

    private void templateGenPSP(Context ctx, List projectList) throws BOSException, EASBizException, SQLException {
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = " delete from T_PSP_PspStockingDemand";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/   insert into T_PSP_PspStockingDemand(Fid,FProjectID,FRunstatus,FMaterialID,FTrackNumberID,FDemandQty,FFinishTime,FCreatorID,FLastUpdateUserID,FMaterialPlanNode) select newbosid('00CB57F2'), pcp.FPROJECTID projectid, nvl(pur.CFRunStatus ,0) CFRunStatus,pspe.cfmaterialnumberid materialid, pc.ftracknumberid tracknumber, pspe.cfmaterialquota quota,pcp.FFINISHTIME,'" + userInfo.getId().toString() + "','" + userInfo.getId().toString() + "', pspe.cfplannode  from T_PCP_ProjectCP pcp  inner join T_MM_Projectcar pc on pcp.fprojectid = pc.fprojectid left join T_MM_TRACKNUMBER tn on pc.ftracknumberid = tn.fid left join T_MM_PROJECT pro  ON pcp.fprojectid = pro.fid left join CT_PUR_BOMPurRequest pur on  pcp.fprojectid = pur.cfprojectnoid inner join CT_PSP_PspTemplate psp on psp.cfprojectnumberid = pcp.fprojectid inner join CT_PSP_PspTemplateEntry pspe on psp.fid = pspe.fparentid left join T_BD_Material ma on pspe.cfmaterialnumberid = ma.fid left join T_BD_MeasureUnit mu on ma.fbaseunit = mu.fid where pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4) order by pcp.ffinishtime";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set FIssolateRule =    (select nvl(FIsolatedRule,'NONE') from T_BD_MaterialPlan mp  where psd.FMaterialID = mp.fmaterialid and mp.forgunit='" + ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString() + "')";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        String tmpTableLT = this.createTempLeadTimeTableSql(ctx);
        sql = " /*dialect*/    insert into " + tmpTableLT + "(fprojectid,FTrackNoID,Fmaterialid,Fpladnode,Fleadtime0, Fleadtime1) select psp.cfprojectnumberid, pcpe.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode,   pcpe.ffinishtime - pspe.cftataladvancedate - pspe.cfstockadvancedate,  pcpe.ffinishtime - 1 - pspe.cfstockadvancedate  from  CT_PSP_PspTemplate psp   inner join CT_PSP_PspTemplateEntry pspe on psp.fid =pspe.fparentid  left join T_PCP_ProjectCP pcp   on psp.cfprojectnumberid = pcp.fprojectid    left join t_Pcp_Projectcpse pcpe on pcp.fid = pcpe.fparentid and pspe.cfplannode = pcpe.fplannode  and pcpe.fprojectid = psp.cfprojectnumberid  where   pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4) ";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set Fleadtime = (select  case nvl(psd.FRunstatus, 0) when 0 then tmp1.Fleadtime0 when 1 then tmp1.Fleadtime1 end from  " + tmpTableLT + " tmp1  where psd.fprojectid = tmp1.fprojectid and psd.FTrackNumberID= tmp1.FTrackNoID and psd.Fmaterialid= tmp1.Fmaterialid and psd.FMaterialPlanNode = tmp1.Fpladnode)";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableLT);
    }

    private void templateGenPSD(Context ctx, List projectList, String tmpDemandTable) throws BOSException, EASBizException, SQLException {
        String sql = " delete from T_PSP_PspStockingDemand";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        sql = " /*dialect*/   insert into T_PSP_PspStockingDemand(Fid,FProjectID,FRunstatus,FMaterialID,FTrackNumberID,FDemandQty,FFinishTime,FCreatorID,FLastUpdateUserID,FMaterialPlanNode,FPurOrgID) select newbosid('00CB57F2'), pcp.FPROJECTID projectid, nvl(pur.CFRunStatus ,0) CFRunStatus,pspe.cfmaterialnumberid materialid, pc.ftracknumberid tracknumber, pspe.cfmaterialquota quota,pcp.FFINISHTIME,'" + userInfo.getId().toString() + "','" + userInfo.getId().toString() + "', pspe.cfplannode,psp.cfpurorgunitid  from T_PCP_ProjectCP pcp  inner join T_MM_Projectcar pc on pcp.fprojectid = pc.fprojectid left join T_MM_TRACKNUMBER tn on pc.ftracknumberid = tn.fid left join T_MM_PROJECT pro  ON pcp.fprojectid = pro.fid left join CT_PUR_BOMPurRequest pur on  pcp.fprojectid = pur.cfprojectnoid inner join CT_PSP_PspTemplate psp on psp.cfprojectnumberid = pcp.fprojectid inner join CT_PSP_PspTemplateEntry pspe on psp.fid = pspe.fparentid left join T_BD_Material ma on pspe.cfmaterialnumberid = ma.fid left join T_BD_MeasureUnit mu on ma.fbaseunit = mu.fid where pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4) order by pcp.ffinishtime";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set FIssolateRule =    (select nvl(FIsolatedRule,'NONE') from T_BD_MaterialPlan mp  where psd.FMaterialID = mp.fmaterialid and mp.forgunit='" + ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString() + "')";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        String tmpTableLT = this.createTempLeadTimeTableSql(ctx);
        sql = " /*dialect*/    insert into " + tmpTableLT + "(fprojectid,FTrackNoID,Fmaterialid,Fpladnode,Fleadtime0, Fleadtime1) select psp.cfprojectnumberid, pcpe.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode,   min(pcpe.ffinishtime - pspe.cftataladvancedate - pspe.cfstockadvancedate),  min(pcpe.ffinishtime - 1 - pspe.cfstockadvancedate)  from  CT_PSP_PspTemplate psp   inner join CT_PSP_PspTemplateEntry pspe on psp.fid =pspe.fparentid  left join T_PCP_ProjectCP pcp   on psp.cfprojectnumberid = pcp.fprojectid    left join t_Pcp_Projectcpse pcpe on pcp.fid = pcpe.fparentid and pspe.cfplannode = pcpe.fplannode  and pcpe.fprojectid = psp.cfprojectnumberid  where   pcp.FFINISHTIME >= trunc(sysdate ,'dd') and   pcp.FFINISHTIME <= add_months(trunc(sysdate ,'dd'),4)  group by psp.cfprojectnumberid, pcpe.ftracknumberid ,pspe.cfmaterialnumberid, pspe.cfplannode";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = " /*dialect*/    update T_PSP_PspStockingDemand psd set Fleadtime = (select  case nvl(psd.FRunstatus, 0) when 0 then tmp1.Fleadtime0 when 1 then tmp1.Fleadtime1 end from  " + tmpTableLT + " tmp1  where psd.fprojectid = tmp1.fprojectid and psd.FTrackNumberID= tmp1.FTrackNoID and psd.Fmaterialid= tmp1.Fmaterialid and psd.FMaterialPlanNode = tmp1.Fpladnode)";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableLT);
        this.mergeDemand(ctx, tmpDemandTable);
    }

    private void mergeDemand(Context ctx, String tempDemandTable) throws BOSException, EASBizException, SQLException {
        EntityViewInfo viewOS = new EntityViewInfo();
        SelectorItemCollection sicOS = new SelectorItemCollection();
        sicOS.add(new SelectorItemInfo("*"));
        sicOS.add(new SelectorItemInfo("MergerRules.*"));
        sicOS.add(new SelectorItemInfo("MergerRules.entry.*"));
        sicOS.add(new SelectorItemInfo("Storage.id"));
        viewOS.setSelector(sicOS);
        FilterInfo filterOS = new FilterInfo();
        filterOS.getFilterItems().add(new FilterItemInfo("Storage.id", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filterOS.getFilterItems().add(new FilterItemInfo("State", (Object)10, CompareType.EQUALS));
        viewOS.setFilter(filterOS);
        PspOperationSchemeCollection osc = PspOperationSchemeFactory.getLocalInstance(ctx).getPspOperationSchemeCollection(viewOS);
        PspMergingRulesEntryCollection mrencol = null;
        if (osc != null && osc.size() > 0) {
            PspOperationSchemeInfo osInfo = osc.get(0);
            PspMergingRulesInfo mrInfo = osInfo.getMergerRules();
            mrencol = mrInfo.getEntry();
        }
        if (mrencol == null || mrencol.size() == 0) {
            return;
        }
        HashMap<String, PspDemand> mapMergeDate = new HashMap<String, PspDemand>();
        EntityViewInfo ev = new EntityViewInfo();
        String sql = "";
        String sqlwhere = " where 1=1 ";
        String sqlorderby = "";
        IPspStockingDemand isp = PspStockingDemandFactory.getLocalInstance(ctx);
        for (int i = 0; i < mrencol.size(); ++i) {
            PspMergingRulesEntryInfo mren = mrencol.get(i);
            FilterInfo filtersp = new FilterInfo();
            filtersp.getFilterItems().add(new FilterItemInfo("StoreOrgUnit", (Object)mren.getSupplyOrg(), CompareType.EQUALS));
            ev.setFilter(filtersp);
            sqlwhere = " where 1=1 ";
            sqlorderby = "";
            if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null || SOLATEDRULE_NONE.equals((Object)mren.getMaterialRule())) {
                sqlwhere = sqlwhere + " and  FIssolateRule is null or  FIssolateRule in('NONE','')";
            } else if ("2".equals(mren.getMaterialRule().getValue())) {
                sqlwhere = sqlwhere + " and    FIssolateRule in('ITEM')";
            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                sqlwhere = sqlwhere + " and    FIssolateRule in('ITEM_TRACKNO')";
            }
            sqlorderby = LATEST.equals(mren.getMergeType().getValue()) ? " order by FPurOrgID,FMaterialID,FLeadTime" : ("2".equals(mren.getMergeType().getValue()) ? " order by FPurOrgID,FPROJECTID,FMaterialID,FLeadTime" : " order by FPurOrgID,FPROJECTID,FTrackNumberID,FMaterialID,FLeadTime");
            sql = " select * from   T_PSP_PspStockingDemand " + sqlwhere + sqlorderby;
            IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
            boolean j = false;
            String material = "";
            String project = "";
            String traceno = "";
            String purorg = "";
            BigDecimal qty = BigDecimal.ZERO;
            Timestamp RequirementDate = null;
            String strDate = "";
            String isolatedrule = "";
            Calendar cc = Calendar.getInstance();
            boolean year = false;
            boolean month = false;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            mapMergeDate.clear();
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    PspDemand pspDemand;
                    purorg = rowSet.getString("FPurOrgID");
                    material = rowSet.getString("FMaterialID");
                    qty = rowSet.getBigDecimal("FDemandQty");
                    RequirementDate = rowSet.getTimestamp("FLeadTime");
                    project = rowSet.getString("FPROJECTID");
                    traceno = rowSet.getString("FTrackNumberID");
                    isolatedrule = rowSet.getString("FIssolateRule");
                    strDate = format.format(RequirementDate);
                    if (LATEST.equals(mren.getMergeType().getValue())) {
                        if (mapMergeDate.get(purorg + material + strDate) != null) {
                            pspDemand = (PspDemand)mapMergeDate.get(purorg + material + strDate);
                            pspDemand.setQty(pspDemand.getQty().add(qty));
                            pspDemand.setProject(null);
                            pspDemand.setTracknumber(null);
                            mapMergeDate.put(purorg + material + strDate, pspDemand);
                            continue;
                        }
                        pspDemand = new PspDemand(purorg, project, traceno, material, RequirementDate, qty, isolatedrule);
                        mapMergeDate.put(purorg + material + strDate, pspDemand);
                        continue;
                    }
                    if ("2".equals(mren.getMergeType().getValue())) {
                        if (mapMergeDate.get(purorg + project + material) != null) {
                            pspDemand = (PspDemand)mapMergeDate.get(purorg + project + material);
                            pspDemand.setQty(pspDemand.getQty().add(qty));
                            if (pspDemand.getLeadTime().compareTo(RequirementDate) < 0) {
                                pspDemand.setLeadTime(RequirementDate);
                            }
                            pspDemand.setTracknumber(null);
                            mapMergeDate.put(purorg + project + material, pspDemand);
                            continue;
                        }
                        pspDemand = new PspDemand(purorg, project, traceno, material, RequirementDate, qty, isolatedrule);
                        mapMergeDate.put(purorg + project + material, pspDemand);
                        continue;
                    }
                    if (mapMergeDate.get(purorg + project + traceno + material + strDate) != null) {
                        pspDemand = (PspDemand)mapMergeDate.get(purorg + project + traceno + material + strDate);
                        pspDemand.setQty(pspDemand.getQty().add(qty));
                        if (pspDemand.getLeadTime().compareTo(RequirementDate) < 0) {
                            pspDemand.setLeadTime(RequirementDate);
                        }
                        mapMergeDate.put(purorg + project + traceno + material + strDate, pspDemand);
                        continue;
                    }
                    pspDemand = new PspDemand(purorg, project, traceno, material, RequirementDate, qty, isolatedrule);
                    mapMergeDate.put(purorg + project + traceno + material + strDate, pspDemand);
                }
            }
            for (String key : mapMergeDate.keySet()) {
                PspDemand value = (PspDemand)mapMergeDate.get(key);
                sql = " /*dialect*/   insert into " + tempDemandTable + "(Fid,FPurOrgID,FProjectID,FTrackNumberID,FMaterialID,FLeadTime,FDemandQty,FIssolateRule)values('" + BOSUuid.create((String)"88888888") + "','" + value.getPurorgunit() + "',";
                sql = value.getProject() == null ? sql + null + "," : sql + "'" + value.getProject() + "',";
                sql = value.getTracknumber() == null ? sql + null + "," : sql + "'" + value.getTracknumber() + "',";
                sql = sql + "'" + value.getMaterial() + "',TO_TIMESTAMP_TZ('" + value.getLeadTime() + "','yyyy-mm-dd hh24:mi:ss.ff')," + value.getQty() + ",";
                sql = value.getIsolatedrule() == null ? sql + "'NONE'" : sql + "'" + value.getIsolatedrule() + "'";
                sql = sql + ")";
                SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
            }
        }
    }

    private void macthInvAndpur(Context ctx, List projectList) throws BOSException, EASBizException, SQLException {
        PspStockingDemandInfo smInfo;
        int j;
        PspStockingDemandCollection cbc;
        SorterItemInfo sorter;
        SorterItemCollection sorters;
        FilterInfo filter;
        EntityViewInfo viewInfo;
        int i;
        IPspStockingDemand iPsd = PspStockingDemandFactory.getLocalInstance(ctx);
        String tmpTableInv = this.createTempInvTableSql(ctx);
        String sql = " /*dialect*/  insert into " + tmpTableInv + "(fmaterialid,FProjectID,FTrackNumberID,FCurStoreQty) select distinct t1.fmaterialid,t1.FProjectID, t1.FTrackNumberID ,nvl(inv.FCurStoreQty,0) FCurStoreQty  from T_PSP_PspStockingDemand t1 left join T_IM_Inventory inv on t1.FMaterialID = inv.fmaterialid ";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = "/*dialect*/ select * from  " + tmpTableInv;
        IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
        HashMap<String, Number> mapInv = new HashMap<String, Number>();
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                mapInv.put(rowSet.getString("fmaterialid"), rowSet.getInt("FCurStoreQty"));
            }
        }
        Object listPSSEInfo = null;
        for (i = 0; i < projectList.size(); ++i) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_NONE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)((PspProjectInfo)projectList.get(i)).getProjectId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            sorters = new SorterItemCollection();
            sorter = new SorterItemInfo("trackNumber.number");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            viewInfo.setSorter(sorters);
            cbc = iPsd.getPspStockingDemandCollection(viewInfo);
            if (cbc == null || cbc.size() <= 0) continue;
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                if (smInfo.getDemandQty().compareTo(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setAllocatedQty(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()));
                    mapInv.put(smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setAllocatedQty(smInfo.getDemandQty());
                    mapInv.put(smInfo.getMaterial().getId().toString(), new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()).subtract(smInfo.getDemandQty()));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
        for (i = 0; i < projectList.size(); ++i) {
            sql = " /*dialect*/ select * from T_PSP_PspStockingDemand where FIsolatedRule is  null and projectid='" + projectList.get(i) + "' order by FFINISHTIME ";
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("issolateRule", (Object)SOLATEDRULE_NONE, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)((PspProjectInfo)projectList.get(i)).getProjectId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            sorters = new SorterItemCollection();
            sorter = new SorterItemInfo("finishTime");
            sorter.setSortType(SortType.ASCEND);
            sorters.add(sorter);
            viewInfo.setSorter(sorters);
            cbc = iPsd.getPspStockingDemandCollection(viewInfo);
            if (cbc == null || cbc.size() <= 0) continue;
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                if (smInfo.getDemandQty().compareTo(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setAllocatedQty(new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()));
                    mapInv.put(smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setAllocatedQty(smInfo.getDemandQty());
                    mapInv.put(smInfo.getMaterial().getId().toString(), new BigDecimal(mapInv.get(smInfo.getMaterial().getId().toString()).toString()).subtract(smInfo.getDemandQty()));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTableInv);
        String tmpTablePur = this.createTempPurTableSql(ctx);
        HashSet<String> setProId = new HashSet<String>();
        for (int i2 = 0; i2 < projectList.size(); ++i2) {
            setProId.add(((PspProjectInfo)projectList.get(i2)).getProjectId());
        }
        sql = "/*dialect*/  insert into " + tmpTablePur + " (fprojectid,fmaterialid,FTrackNoID,FQty,FusedQty)  select pure.fprojectid, pure.fmaterialid,pure.FTrackNoID,sum(pure.FQty) FQty, 0 usedQty from T_SM_PurOrder pur  inner join t_Sm_Purorderentry pure on pur.fid = pure.fparentid  where pur.fbasestatus =  4 and pure.fprojectid in (" + SQLUtil.setToString(setProId) + " ) group by pure.fprojectid, pure.fmaterialid,pure.FTrackNoID";
        SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).execute(sql);
        sql = "/*dialect*/ select * from  " + tmpTablePur;
        rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
        HashMap<String, Number> mapPur = new HashMap<String, Number>();
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                mapPur.put(rowSet.getString("fprojectid") + rowSet.getString("FTrackNoID") + rowSet.getString("fmaterialid"), rowSet.getInt("FQty"));
            }
        }
        sql = " where   allocateQty =0 ";
        EntityViewInfo viewInfo2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("allocateQty", (Object)0, CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("allocateQty", (Object)"demandQty", CompareType.LESS));
        filter2.setMaskString("#0 or #1");
        viewInfo2.setFilter(filter2);
        cbc = iPsd.getPspStockingDemandCollection(sql);
        if (cbc != null && cbc.size() > 0) {
            for (j = 0; j < cbc.size(); ++j) {
                smInfo = cbc.get(j);
                BigDecimal needQty = smInfo.getDemandQty().subtract(smInfo.getAllocateQty());
                if (needQty.compareTo(new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString())) >= 0) {
                    smInfo.setOrderQty(new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString()));
                    mapPur.put(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString(), 0);
                } else {
                    smInfo.setOrderQty(needQty);
                    mapPur.put(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString(), new BigDecimal(mapPur.get(smInfo.getProject().getId().toString() + smInfo.getTrackNumber().getId().toString() + smInfo.getMaterial().getId().toString()).toString()).subtract(needQty));
                }
                iPsd.save((CoreBaseInfo)smInfo);
            }
        }
    }

    public void genStockingPlan(Context ctx, String rule, String tmpDemandTable) throws EASBizException, BOSException, SQLException {
    }

    private void mergeData(Context ctx) throws SQLException, BOSException, EASBizException {
        EntityViewInfo viewOS = new EntityViewInfo();
        SelectorItemCollection sicOS = new SelectorItemCollection();
        sicOS.add(new SelectorItemInfo("*"));
        sicOS.add(new SelectorItemInfo("MergerRules.*"));
        sicOS.add(new SelectorItemInfo("MergerRules.entry.*"));
        sicOS.add(new SelectorItemInfo("Storage.id"));
        viewOS.setSelector(sicOS);
        FilterInfo filterOS = new FilterInfo();
        filterOS.getFilterItems().add(new FilterItemInfo("Storage.id", (Object)ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filterOS.getFilterItems().add(new FilterItemInfo("State", (Object)10, CompareType.EQUALS));
        viewOS.setFilter(filterOS);
        PspOperationSchemeCollection osc = PspOperationSchemeFactory.getLocalInstance(ctx).getPspOperationSchemeCollection(viewOS);
        PspMergingRulesEntryCollection mrencol = null;
        if (osc != null && osc.size() > 0) {
            PspOperationSchemeInfo osInfo = osc.get(0);
            PspMergingRulesInfo mrInfo = osInfo.getMergerRules();
            mrencol = mrInfo.getEntry();
        }
        if (mrencol == null || mrencol.size() == 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        String sql = "";
        IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
        for (int i = 0; i < mrencol.size(); ++i) {
            PspMergingRulesEntryInfo mren = mrencol.get(i);
            FilterInfo filtersp = new FilterInfo();
            filtersp.getFilterItems().add(new FilterItemInfo("StoreOrgUnit", (Object)mren.getSupplyOrg(), CompareType.EQUALS));
            ev.setFilter(filtersp);
            if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FRequirementDate";
            } else if ("2".equals(mren.getMaterialRule().getValue())) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FPROJECTID,FRequirementDate";
            } else if ("3".equals(mren.getMaterialRule().getValue())) {
                sql = " select * from T_PSP_PspStockPlanMiddle   order by FMaterialID,FPROJECTID,FTRACENOID,FRequirementDate";
            }
            IRowSet rowSet = SqlExecuteFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql);
            int j = 0;
            String material = "";
            String project = "";
            String traceno = "";
            BigDecimal qty = BigDecimal.ZERO;
            Timestamp RequirementDate = null;
            Calendar cc = Calendar.getInstance();
            if (rowSet == null || rowSet.size() <= 0) continue;
            while (rowSet.next()) {
                TrackNumberInfo tn;
                ProjectInfo p;
                MaterialInfo m;
                StockingPlanInfo spInfo;
                if (j == 0) {
                    material = rowSet.getString("FMaterialID");
                    RequirementDate = rowSet.getTimestamp("FRequirementDate");
                    project = rowSet.getString("FPROJECTID");
                    traceno = rowSet.getString("FTRACENOID");
                    cc.setTime(RequirementDate);
                    cc.add(5, mren.getCycle().intValue());
                }
                if (LATEST.equals(mren.getMaterialRule().getValue()) || mren.getMaterialRule() == null) {
                    if (material.equals(rowSet.getString("FMaterialID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                        qty = qty.add(rowSet.getBigDecimal("FQty"));
                        ++j;
                        continue;
                    }
                    spInfo = new StockingPlanInfo();
                    spInfo.setId(BOSUuid.create((String)"888888"));
                    m = new MaterialInfo();
                    m.setId(BOSUuid.read((String)material));
                    spInfo.setMaterial(m);
                    spInfo.setQty(qty);
                    spInfo.setRequirementDate(RequirementDate);
                    p = new ProjectInfo();
                    p.setId(BOSUuid.read((String)project));
                    spInfo.setProject(p);
                    tn = new TrackNumberInfo();
                    tn.setId(BOSUuid.read((String)traceno));
                    spInfo.setTraceNo(tn);
                    isp.save((CoreBaseInfo)spInfo);
                    j = 0;
                    qty = BigDecimal.ZERO;
                    rowSet.previous();
                    continue;
                }
                if ("2".equals(mren.getMaterialRule().getValue())) {
                    if (material.equals(rowSet.getString("FMaterialID")) && project.equals(rowSet.getString("FPROJECTID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                        qty = qty.add(rowSet.getBigDecimal("FQty"));
                        ++j;
                        continue;
                    }
                    spInfo = new StockingPlanInfo();
                    spInfo.setId(BOSUuid.create((String)"888888"));
                    m = new MaterialInfo();
                    m.setId(BOSUuid.read((String)material));
                    spInfo.setMaterial(m);
                    spInfo.setQty(qty);
                    spInfo.setRequirementDate(RequirementDate);
                    p = new ProjectInfo();
                    p.setId(BOSUuid.read((String)project));
                    spInfo.setProject(p);
                    tn = new TrackNumberInfo();
                    tn.setId(BOSUuid.read((String)traceno));
                    spInfo.setTraceNo(tn);
                    isp.save((CoreBaseInfo)spInfo);
                    j = 0;
                    qty = BigDecimal.ZERO;
                    rowSet.previous();
                    continue;
                }
                if (!"3".equals(mren.getMaterialRule().getValue())) continue;
                if (material.equals(rowSet.getString("FMaterialID")) && project.equals(rowSet.getString("FPROJECTID")) && traceno.equals(rowSet.getString("FTRACENOID")) && rowSet.getTimestamp("FRequirementDate").compareTo(cc.getTime()) <= 0) {
                    qty = qty.add(rowSet.getBigDecimal("FQty"));
                    ++j;
                    continue;
                }
                spInfo = new StockingPlanInfo();
                spInfo.setId(BOSUuid.create((String)"888888"));
                m = new MaterialInfo();
                m.setId(BOSUuid.read((String)material));
                spInfo.setMaterial(m);
                spInfo.setQty(qty);
                spInfo.setRequirementDate(RequirementDate);
                p = new ProjectInfo();
                p.setId(BOSUuid.read((String)project));
                spInfo.setProject(p);
                tn = new TrackNumberInfo();
                tn.setId(BOSUuid.read((String)traceno));
                spInfo.setTraceNo(tn);
                isp.save((CoreBaseInfo)spInfo);
                j = 0;
                qty = BigDecimal.ZERO;
                rowSet.previous();
            }
        }
    }

    private String createTempInvTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("Fmaterialid nvarchar(255)");
        sql.append(",\r\n FProjectID nvarchar(255)");
        sql.append(",\r\n FTrackNumberID nvarchar(255)");
        sql.append(",\r\n FCurStoreQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempPurTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("fprojectid nvarchar(255)");
        sql.append(",\r\n fmaterialid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n FQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FusedQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempSPTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("fprojectid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n fmaterialid nvarchar(255)");
        sql.append(",\r\n FQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FDateTime nvarchar(255)");
        sql.append(",\r\n FInWHQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FWayQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempLeadTimeTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("Fprojectid nvarchar(255)");
        sql.append(",\r\n FTrackNoID nvarchar(255)");
        sql.append(",\r\n Fmaterialid nvarchar(255)");
        sql.append(",\r\n Fpladnode nvarchar(255)");
        sql.append(",\r\n Fleadtime0 timestamp");
        sql.append(",\r\n Fleadtime1 timestamp");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempStockingPlanSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("FID nvarchar(44)");
        sql.append(",\r\n FREQUIREMENTDATE timestamp");
        sql.append(",\r\n FSUPPLIERID nvarchar(255)");
        sql.append(",\r\n FMATERIALID nvarchar(255)");
        sql.append(",\r\n FPROJECTID nvarchar(255)");
        sql.append(",\r\n FTRACENOID nvarchar(255)");
        sql.append(",\r\n FQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n FSTATUS nvarchar(255)");
        sql.append(",\r\n FSOURCEBILLID nvarchar(255)");
        sql.append(",\r\n FSOURCEPSPDEMANDBI nvarchar(255)");
        sql.append(",\r\n FISSOLATERULE nvarchar(255)");
        sql.append(")");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private String createTempStockingPlanDemand(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DataNew ( ");
        sql.append("FName_l1 NVARCHAR(255)");
        sql.append(",\r\n FName_l2 NVARCHAR(255)");
        sql.append(",\r\n FName_l3 NVARCHAR(255)");
        sql.append(",\r\n FNumber NVARCHAR(80)");
        sql.append(",\r\n FDescription_l1 NVARCHAR(255)");
        sql.append(",\r\n FDescription_l2 NVARCHAR(255)");
        sql.append(",\r\n FDescription_l3 NVARCHAR(255)");
        sql.append(",\r\n FSimpleName NVARCHAR(80)");
        sql.append(",\r\n FID VARCHAR(44) DEFAULT '' NOT NULL ");
        sql.append(",\r\n FCreatorID VARCHAR(44)");
        sql.append(",\r\n FCreateTime DateTime");
        sql.append(",\r\n FLastUpdateUserID VARCHAR(44)");
        sql.append(",\r\n FLastUpdateTime DateTime");
        sql.append(",\r\n FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4'");
        sql.append(",\r\n FProjectID VARCHAR(44)");
        sql.append(",\r\n FTmpMod NUMERIC(28, 10)");
        sql.append(",\r\n FPurOrgID VARCHAR(44)");
        sql.append(",\r\n FMaterialID VARCHAR(44)");
        sql.append(",\r\n FMaterialName NVARCHAR(80)");
        sql.append(",\r\n FMaterialModel NVARCHAR(80)");
        sql.append(",\r\n FMaterialUnit NVARCHAR(80)");
        sql.append(",\r\n FTrackNumberID VARCHAR(44)");
        sql.append(",\r\n FDemandQty NUMERIC(28, 10)");
        sql.append(",\r\n FLeadTime DateTime");
        sql.append(",\r\n FAllocateQty NUMERIC(28, 10)");
        sql.append(",\r\n FAllocatedQty NUMERIC(28, 10)");
        sql.append(",\r\n FUnAllocatedQty NUMERIC(28, 10)");
        sql.append(",\r\n FRunStatus INT");
        sql.append(",\r\n FIssolateRule NVARCHAR(100)");
        sql.append(",\r\n FFinishTime VARCHAR(44)");
        sql.append(",\r\n FOrderQty NUMERIC(28,10)");
        sql.append(",\r\n FUnOrderQty NUMERIC(28, 10)");
        sql.append(",\r\n FMaterialPlanNode NVARCHAR(100));");
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private BigDecimal getInventoryQty(Context ctx, String orgid, String solatedrule, String materialid, String projectid, String trackid, BigDecimal qty, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        BigDecimal inventoryqty = BigDecimal.ZERO;
        String sql = null;
        IRowSet rs = null;
        String materialkey = null;
        if (SOLATEDRULE_NONE.equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + SOLATEDRULE_NONE;
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = queryInventory;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal(INVENTORY);
                }
            }
        } else if (SOLATEDRULE_ITEM.equals(solatedrule)) {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + SOLATEDRULE_ITEM;
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = queryInventory_item;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid, projectid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal(INVENTORY);
                }
            }
        } else {
            materialkey = materialid + "#" + orgid + "#" + projectid + "#" + trackid + "#" + SOLATEDRULE_ITEM;
            if (this.inventoryMap.get(materialkey) != null) {
                inventoryqty = this.inventoryMap.get(materialkey);
            } else {
                sql = queryInventory_itemtrack;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialid, orgid, projectid, trackid});
                if (rs.next()) {
                    inventoryqty = rs.getBigDecimal(INVENTORY);
                }
            }
        }
        this.inventoryMap.put(materialkey, inventoryqty);
        return inventoryqty;
    }

    private void getResultMakeMap(IRowSet rs, String propName, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        if (rs.getObject(propName) instanceof String) {
            map.put(propName, rs.getString(propName));
        } else if (rs.getObject(propName) instanceof Timestamp) {
            map.put(propName, rs.getTimestamp(propName));
        } else if (rs.getObject(propName) instanceof BigDecimal) {
            map.put(propName, rs.getBigDecimal(propName));
        } else if (rs.getObject(propName) instanceof java.util.Date) {
            Date date = rs.getDate(propName);
            Timestamp tmp = new Timestamp(date.getTime());
            map.put(propName, tmp);
        } else {
            map.put(propName, rs.getObject(propName));
        }
    }

    private void matchInventory(Context ctx, Map<String, Object> map) throws SQLException, BOSException, EASBizException {
        BigDecimal invqty = BigDecimal.ZERO;
        String materialid = (String)map.get(MATERIALID);
        String projectid = (String)map.get(PROJECTID);
        String trackid = (String)map.get(TRACKID);
        String orgid = (String)map.get(ORGID);
        BigDecimal qty = (BigDecimal)map.get(QTY);
        String solatedRule = (String)map.get(ISSOLATERULE);
        invqty = this.getInventoryQty(ctx, orgid, solatedRule, materialid, projectid, trackid, qty, map);
        map.put(ISSOLATERULE, solatedRule);
    }
}

