/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlan;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlanDetail;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class PurInvWB4PSPProcessor
extends AbstractBusinessProcessor {
    public PurInvWB4PSPProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInvWB4PSPProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurInvWB4PSPProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        this.passAudit(this.ctx, collection, this.batchAction);
    }

    private void passAudit(Context ctx, IObjectCollection purinvs, BatchActionEnum action) throws BOSException, EASBizException {
        IStockingPlanDetail ispd = StockingPlanDetailFactory.getLocalInstance(ctx);
        IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
        int size = purinvs.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = purinvs.getObject(i);
            if (vo == null) continue;
            PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)vo;
            PurInWarehsEntryCollection entries = purInWarehsBillInfo.getEntry();
            for (int j = 0; j < entries.size(); ++j) {
                PurInWarehsEntryInfo entry = entries.get(j);
                if (entry.getPurOrderEntry() == null) continue;
                PurOrderEntryInfo purEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(entry.getPurOrderEntry()));
                BigDecimal inwQty = purEntry == null ? BigDecimal.ZERO : purEntry.getTotalReceiptQty();
                StringBuffer sql = new StringBuffer();
                StringBuffer sqlSum = new StringBuffer();
                sql.append("select spd.fid spdId from T_PSP_StockingPlanDetail spd inner join T_SM_PurOrderEntry poe  on spd.fpurorderentryid = poe.fid ");
                sql.append(" where poe.fid='" + entry.getPurOrderEntry() + "' order by spd.fspTime,spd.fspQty ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                int flag = 1;
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            String detailId = rs.getString("spdId");
                            StockingPlanDetailInfo spdInfo = ispd.getStockingPlanDetailInfo((IObjectPK)new ObjectUuidPK(detailId));
                            SelectorItemCollection sic_spd = new SelectorItemCollection();
                            sic_spd.add(new SelectorItemInfo("inStorageQty"));
                            if (flag == rs.size()) {
                                spdInfo.setInStorageQty(inwQty);
                                ispd.updatePartial((CoreBaseInfo)spdInfo, sic_spd);
                            } else if (spdInfo.getSpQty().compareTo(inwQty) >= 0) {
                                spdInfo.setInStorageQty(inwQty);
                                inwQty = BigDecimal.ZERO;
                                ispd.updatePartial((CoreBaseInfo)spdInfo, sic_spd);
                            } else if (spdInfo.getSpQty().compareTo(inwQty) < 0) {
                                spdInfo.setInStorageQty(spdInfo.getSpQty());
                                inwQty = inwQty.subtract(spdInfo.getSpQty());
                                ispd.updatePartial((CoreBaseInfo)spdInfo, sic_spd);
                            }
                            ++flag;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sqlSum.append("select splan.fid stockId, sum(spd.fInStorageQty) inQty from T_PSP_StockingPlan splan inner join T_PSP_StockingPlanDetail spd on splan.fid=spd.fstockingplanid ");
                sqlSum.append(" where spd.fpurorderentryid ='" + entry.getPurOrderEntry() + "' group by splan.fid ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlSum.toString());
                SelectorItemCollection sic_sp = new SelectorItemCollection();
                sic_sp.add(new SelectorItemInfo("InStorageQty"));
                if (rs == null) continue;
                try {
                    while (rs.next()) {
                        String stockId = rs.getString("stockId");
                        BigDecimal inWqty = rs.getBigDecimal("inQty");
                        StockingPlanInfo spInfo = StockingPlanFactory.getLocalInstance(ctx).getStockingPlanInfo((IObjectPK)new ObjectUuidPK(stockId));
                        spInfo.setInStorageQty(inWqty);
                        isp.updatePartial((CoreBaseInfo)spInfo, sic_sp);
                    }
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

