/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlanDetail;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeState;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeType;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanChangeInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.app.AbstractStockingPlanChangeControllerBean;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockingPlanChangeControllerBean
extends AbstractStockingPlanChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.psp.app.StockingPlanChangeControllerBean");

    private void Audit(Context ctx, List idList, String userid) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" UPDATE t_psp_stockingplan sp ");
        sql.append(" SET (fqty, frequirementdate) = ( ");
        sql.append(" SELECT fchangeqty, fchangeleaddate ");
        sql.append(" FROM t_psp_stockingplanchange spc WHERE spc.fstockingplanid = sp.fid) ");
        sql.append(" WHERE sp.fid IN ");
        sql.append("(SELECT fstockingplanid FROM t_psp_stockingplanchange WHERE fid in ( ");
        sql.append(SQLUtil.arrayToString((Object[])idList.toArray()));
        sql.append(" ))");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private void updateSql(Context ctx, String action, List idList, String userid) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Update T_PSP_STOCKINGPLANCHANGE UT\r\n");
        sql.append("Set\r\n");
        sql.append("fchangestatus=").append(action.equals("Audit") ? "30" : (action.equals("Submit") ? "25" : (action.equals("Save") ? "20" : "20")));
        sql.append("\r\n");
        sql.append(",");
        sql.append("faudittime = now()");
        sql.append(",");
        sql.append("fauditorid = '");
        sql.append(userid);
        sql.append("'  ");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])idList.toArray())).append("\r\n");
        sql.append(")\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    protected Result _save(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._save(ctx, colls);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected Result _submit(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._submit(ctx, colls);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u63d0\u4ea4\u51fa\u9519", "\u53c2\u6570\u4f20\u9012\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userID = userInfo == null ? null : (userInfo.getId() == null ? null : userInfo.getId().toString());
        ArrayList<Object> idList = new ArrayList<Object>();
        if (model.get("id") != null && model.containsKey("changeStatus") && (model.getString("changeStatus").equals("10") || model.getString("changeStatus").equals("20"))) {
            idList.add(model.get("id"));
            this.updateSql(ctx, "Submit", idList, userID);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _batchExecute(Context ctx, Map params) throws BOSException, EASBizException {
        String userID;
        if (ctx == null || IndustryUtils.isEmptyMap((Map)params)) {
            throw new EASBizException(new NumericExceptionSubItem("\u6279\u5904\u7406\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List idList = IndustryUtils.getMapListData((Map)params, (Object)"IDList");
        String action = IndustryUtils.getMapStringData((Map)params, (Object)"Action");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String string = userInfo == null ? null : (userID = userInfo.getId() == null ? null : userInfo.getId().toString());
        if (IndustryUtils.isEmptyList((List)idList) || IndustryUtils.isEmptyString((String)action) || IndustryUtils.isEmptyString((String)userID)) {
            return;
        }
        for (int i = 0; i < idList.size(); ++i) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("stockingPlan.*"));
            StockingPlanChangeInfo info = StockingPlanChangeFactory.getLocalInstance(ctx).getStockingPlanChangeInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), selector);
            SelectorItemCollection sic = new SelectorItemCollection();
            if (action.equals("Submit")) {
                info.setChangeStatus(PspChangeState.SUBMIT);
                sic.add(new SelectorItemInfo("changeStatus"));
            } else if (action.equals("Audit")) {
                if (info.getStockingPlan() == null) continue;
                StockingPlanInfo spInfo = info.getStockingPlan();
                SelectorItemCollection sic_sp = new SelectorItemCollection();
                info.setChangeStatus(PspChangeState.CHANGED);
                info.setAuditor(userInfo);
                info.setAuditTime(new Date());
                sic.add(new SelectorItemInfo("auditor"));
                sic.add(new SelectorItemInfo("auditTime"));
                if (PspChangeType.TDATE.equals((Object)info.getChangeType()) || PspChangeType.TBQD.equals((Object)info.getChangeType())) {
                    spInfo.setRequirementDate(info.getChangeLeadDate());
                    sic_sp.add(new SelectorItemInfo("RequirementDate"));
                }
                if (PspChangeType.TQTY.equals((Object)info.getChangeType()) || PspChangeType.TBQD.equals((Object)info.getChangeType())) {
                    int isNegative = info.getLeadQty().compareTo(info.getChangeQty());
                    spInfo.setWayQty(spInfo.getWayQty().subtract(spInfo.getQty().subtract(info.getChangeQty())));
                    spInfo.setPurOrderQty(spInfo.getPurOrderQty().subtract(spInfo.getQty().subtract(info.getChangeQty())));
                    spInfo.setQty(info.getChangeQty());
                    if (isNegative > 0) {
                        this.changeSP(ctx, spInfo);
                    } else if (isNegative < 0) {
                        // empty if block
                    }
                    sic_sp.add(new SelectorItemInfo("Qty"));
                    sic_sp.add(new SelectorItemInfo("purOrderQty"));
                    sic_sp.add(new SelectorItemInfo("WayQty"));
                }
                sic.add(new SelectorItemInfo("changeStatus"));
                StockingPlanFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)spInfo, sic_sp);
            } else if (action.equals("UnAudit")) {
                info.setChangeStatus(PspChangeState.SUBMIT);
                sic.add(new SelectorItemInfo("changeStatus"));
            }
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    private void changeSP(Context ctx, StockingPlanInfo info) throws BOSException, EASBizException {
        IStockingPlanDetail ispd = StockingPlanDetailFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfoSP = new EntityViewInfo();
        FilterInfo filterInfoSP = new FilterInfo();
        filterInfoSP.getFilterItems().add(new FilterItemInfo("stockingPlan.id", (Object)info.getId().toString(), CompareType.EQUALS));
        viewInfoSP.setFilter(filterInfoSP);
        StockingPlanDetailCollection spdCol = ispd.getStockingPlanDetailCollection(viewInfoSP);
        for (int i = 0; i < spdCol.size(); ++i) {
            StockingPlanDetailInfo detailInfo = spdCol.get(i);
            if (detailInfo.isIsChange() && detailInfo.getChangeQty().compareTo(BigDecimal.ZERO) > 0) {
                detailInfo.setSpQty(detailInfo.getSpQty().subtract(detailInfo.getChangeQty()));
                detailInfo.setOnWayQty(detailInfo.getOnWayQty().subtract(detailInfo.getChangeQty()));
                detailInfo.setChangeQty(BigDecimal.ZERO);
                detailInfo.setPurQty(detailInfo.getPurQty().subtract(detailInfo.getChangeQty()));
                detailInfo.setIsChange(false);
            }
            SelectorItemCollection sic_sp = new SelectorItemCollection();
            sic_sp.add(new SelectorItemInfo("spQty"));
            sic_sp.add(new SelectorItemInfo("onWayQty"));
            sic_sp.add(new SelectorItemInfo("purQty"));
            sic_sp.add(new SelectorItemInfo("changeQty"));
            sic_sp.add(new SelectorItemInfo("isChange"));
            ispd.updatePartial((CoreBaseInfo)detailInfo, sic_sp);
        }
    }
}

