/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlan;
import com.kingdee.eas.industry.emm.project.biz.psp.SpFBStatus;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFBdetailEntryFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFBdetailEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFBdetailFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFBdetailInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanType;
import com.kingdee.eas.industry.emm.project.biz.psp.app.AbstractStockingPlanFeedbackFacadeControllerBean;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FBDetailSpVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FBListVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.FbVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.KeyDimensionForFBdetialVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.PspParameterSet;
import com.kingdee.eas.industry.emm.project.biz.psp.util.SpDemandMapVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.SpVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.StockingPlanSituationVO;
import com.kingdee.eas.industry.emm.project.biz.psp.util.pspPurVO;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class StockingPlanFeedbackFacadeControllerBean
extends AbstractStockingPlanFeedbackFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.psp.app.StockingPlanFeedbackFacadeControllerBean");
    String insert_sql = "  insert into t_psp_psptofbdetail (fid,fstockingplanid ,fstockingplanfbdetailid,fusefbqty,fdemanddate,fsupplydate) VALUES(?,?,?,?,?,?)) ";

    private StockingPlanInfo getspInfo(Context ctx, IRowSet irs) throws UuidException, SQLException {
        StockingPlanInfo spInfo = new StockingPlanInfo();
        spInfo.setId(BOSUuid.read((String)irs.getString("fid")));
        StorageOrgUnitInfo supOrgInfo = new StorageOrgUnitInfo();
        supOrgInfo.setId(BOSUuid.read((String)irs.getString("supplyorgID")));
        supOrgInfo.setName(irs.getString("supplyorgName"));
        supOrgInfo.setNumber(irs.getString("supplyorgNumber"));
        spInfo.setSupplyStorageOrgUnit(supOrgInfo);
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)irs.getString("materialID")));
        materialInfo.setName(irs.getString("materialName"));
        materialInfo.setNumber(irs.getString("materialNumber"));
        spInfo.setMaterial(materialInfo);
        PurchaseOrgUnitInfo purInfo = new PurchaseOrgUnitInfo();
        purInfo.setId(BOSUuid.read((String)irs.getString("purOrgID")));
        purInfo.setName(irs.getString("purOrgName"));
        purInfo.setNumber(irs.getString("purOrgNumber"));
        spInfo.setPurChaseOrgUnit(purInfo);
        if (!IndustryUtils.isEmptyString((String)irs.getString("projectID"))) {
            ProjectInfo proInfo = new ProjectInfo();
            proInfo.setId(BOSUuid.read((String)irs.getString("projectID")));
            proInfo.setNumber(irs.getString("projectNumber"));
            proInfo.setName(irs.getString("projectName"));
            spInfo.setProject(proInfo);
        }
        if (!IndustryUtils.isEmptyString((String)irs.getString("trackNoID"))) {
            TrackNumberInfo trcInfo = new TrackNumberInfo();
            trcInfo.setId(BOSUuid.read((String)irs.getString("trackNoID")));
            trcInfo.setNumber(irs.getString("trackNoNumber"));
            trcInfo.setName(irs.getString("trackNoName"));
            spInfo.setTraceNo(trcInfo);
        }
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)irs.getString("supplierID")));
        supplierInfo.setName(irs.getString("supplierName"));
        supplierInfo.setNumber(irs.getString("supplierNumber"));
        spInfo.setSupplier(supplierInfo);
        spInfo.setUnit(irs.getString("unitNumber"));
        spInfo.setRequirementDate(irs.getDate("fdemanddate"));
        spInfo.setQty(irs.getBigDecimal("fqty"));
        return spInfo;
    }

    @Override
    protected HashMap _getStockingPlanList(Context ctx, HashMap map) throws BOSException, EASBizException {
        if (map == null) {
            return null;
        }
        String queryString = (String)map.get("queryString");
        int maxCount = (Integer)map.get("maxCount");
        if (IndustryUtils.isEmptyString((String)queryString)) {
            return null;
        }
        HashMap<String, Cloneable> mapR = new HashMap<String, Cloneable>();
        ArrayList listOfVO = new ArrayList();
        HashMap<String, StockingPlanSituationVO> spVO_map = new HashMap<String, StockingPlanSituationVO>();
        HashSet<Date> setOfTime = new HashSet<Date>();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  select top ").append(maxCount).append(" psp.fid,sum(tof.fusefbqty) as supplyqty ,min(psp.frequirementdate) as fdemanddate  \n");
        sql.append("  ,max(psp.fqty) as fqty   \n");
        sql.append(" ,max(tspg.fid) as supplyorgID ,max(tspg.fnumber) as supplyorgNumber ,max(tspg.fname_l2) as supplyorgName  \n");
        sql.append("  , max(tp.fid) as projectID ,max(tp.fnumber) as projectNumber ,max(tp.fname_l2) as projectName  \n");
        sql.append("  , max(tn.fid) as trackNoID ,max(tn.fnumber) as trackNoNumber ,max(tn.fname_l2) as trackNoName  \n");
        sql.append("  ,max(tm.fid) as materialID ,max(tm.fnumber) as materialNumber ,max(tm.fname_l2) as materialName \n");
        sql.append("   ,max(tb.fid) as purOrgID ,max(tb.fnumber) as purOrgNumber ,max(tb.fname_l2) as purOrgName  \n");
        sql.append("    ,max(ts.fid) as supplierID ,max(ts.fnumber) as supplierNumber ,max(ts.fname_l2) as supplierName \n");
        sql.append("  ,max(mu.fid) as unitID ,max(mu.fnumber) as unitNumber ,max(mu.fname_l2) as unitName \n");
        sql.append(" ,max(pg.fname_l2) as purGroupName,max(pg.fnumber) as purGroupNumber, max (per.fname_l2) as purPersonName,max(per.fnumber) as purPersonNumber \n");
        sql.append("  ,min((select min(1) from CT_PSP_StockingPlanFBdetail \n");
        sql.append(" where CT_PSP_StockingPlanFBdetail.Cfmaterialid =psp.fmaterialid and  \n");
        sql.append(" isnull(CT_PSP_StockingPlanFBdetail.Cfprojectid,'none')=isnull(psp.fprojectid,'none') and \n");
        sql.append("  isnull(CT_PSP_StockingPlanFBdetail.Cftracknumberid,'none') =isnull(psp.ftracenoid,'none') and \n ");
        sql.append("   not exists (select 1 from T_PSP_PSPTOFBDETAIL where isnull(Fstockingplanfbdetailid,'none')=  isnull(CT_PSP_StockingPlanFBdetail.fid,'none') ))) as flag \n");
        sql.append("   from t_psp_stockingplan psp   \n");
        sql.append("   \t  left join T_MM_Project tp on tp.fid = psp.fprojectid   \n");
        sql.append("   \t  left join T_MM_TrackNumber tn on tn.fid = psp.ftracenoid   \n");
        sql.append("    \t  left join t_bd_material tm on tm.fid = psp.fmaterialid   \n");
        sql.append("        left join t_org_baseunit tb on tb.fid = psp.fpurchaseorgunitid   \n");
        sql.append("        left join T_BD_Supplier ts on ts.fid = psp.fsupplierid   \n");
        sql.append("      left join T_PSP_PSPTOFBDETAIL tof on tof.fstockingplanid = psp.fid   \n");
        sql.append("  left join t_org_baseunit tspg on psp.fsupplystorageorgunitid = tspg.fid   \n");
        sql.append("   left join T_BD_MeasureUnit mu on mu.fid = tm.fbaseunit \n");
        sql.append(" left join T_BD_PurchaseGroup pg on psp.cfpurchasegroupid = pg.fid \n");
        sql.append(" left join T_BD_Person per on psp.cfpurpersonid = per.fid \n");
        sql.append("        where  1=1   \n");
        sql.append(" and \n").append(queryString);
        sql.append(" and psp.fsupplierid is not null    \n");
        sql.append("  group by psp.fid     \n");
        sql.append(" order by  fdemanddate     \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
            StockingPlanInfo spInfo = null;
            try {
                while (rowSet.next()) {
                    List<StockingPlanInfo> spList;
                    SpDemandMapVO sdVo;
                    HashMap<java.util.Date, SpDemandMapVO> sdMap;
                    String stcokingplanID = rowSet.getString("fid");
                    BigDecimal supplyQty = rowSet.getBigDecimal("supplyqty");
                    BigDecimal flag = rowSet.getBigDecimal("flag") == null ? BigDecimal.ZERO : rowSet.getBigDecimal("flag");
                    Date demandDate = rowSet.getDate("fdemanddate");
                    String purGroupNumber = rowSet.getString("purGroupNumber");
                    String purGroupName = rowSet.getString("purGroupName");
                    String purPersonNumber = rowSet.getString("purPersonNumber");
                    String purPersonName = rowSet.getString("purPersonName");
                    setOfTime.add(demandDate);
                    spInfo = this.getspInfo(ctx, rowSet);
                    String key = (spInfo.getSupplier() != null ? spInfo.getSupplier().getId().toString() : "#") + (spInfo.getPurChaseOrgUnit() != null ? spInfo.getPurChaseOrgUnit().getId().toString() : "#") + spInfo.getMaterial().getId().toString() + (spInfo.getSupplyStorageOrgUnit() != null ? spInfo.getSupplyStorageOrgUnit().getId().toString() : "#") + (spInfo.getProject() != null ? spInfo.getProject().getId().toString() : "#") + (spInfo.getTraceNo() != null ? spInfo.getTraceNo().getId().toString() : "#");
                    StockingPlanSituationVO spVo = new StockingPlanSituationVO();
                    if (spVO_map.containsKey(key)) {
                        spVo = (StockingPlanSituationVO)spVO_map.get(key);
                        sdMap = spVo.getSdMap();
                        sdVo = new SpDemandMapVO();
                        if (sdMap.containsKey(spInfo.getRequirementDate())) {
                            sdVo = sdMap.get(spInfo.getRequirementDate());
                            sdVo.setDemandQty(sdVo.getDemandQty().add(spInfo.getQty()));
                            sdVo.setFlag(flag);
                            sdVo.setSupplierQty(sdVo.getSupplierQty().add(supplyQty != null ? supplyQty : BigDecimal.ZERO));
                            spList = sdVo.getStockingplanList();
                            spList.add(spInfo);
                            sdVo.setStockingplanList(spList);
                        } else {
                            sdVo.setDemandDate(spInfo.getRequirementDate());
                            sdVo.setDemandQty(spInfo.getQty());
                            sdVo.setFlag(flag);
                            sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                            spList = new ArrayList<StockingPlanInfo>();
                            spList.add(spInfo);
                            sdVo.setStockingplanList(spList);
                        }
                        sdMap.put(spInfo.getRequirementDate(), sdVo);
                        spVo.setSdMap(sdMap);
                    } else {
                        spVo.setPurchaseOrgUnitID(spInfo.getPurChaseOrgUnit() == null ? null : spInfo.getPurChaseOrgUnit().getId().toString());
                        spVo.setPurchaseOrgUnitName(spInfo.getPurChaseOrgUnit() == null ? null : spInfo.getPurChaseOrgUnit().getName());
                        spVo.setPurchaseOrgUnitNumber(spInfo.getPurChaseOrgUnit() == null ? null : spInfo.getPurChaseOrgUnit().getNumber());
                        spVo.setMaterialID(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getId().toString());
                        spVo.setMaterialName(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getName());
                        spVo.setMaterialNumber(spInfo.getMaterial() == null ? null : spInfo.getMaterial().getNumber());
                        spVo.setSupplyStroageOrgUnitID(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getId().toString());
                        spVo.setSupplyStroageOrgUnitName(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getName());
                        spVo.setSupplyStroageOrgUnitNumber(spInfo.getSupplyStorageOrgUnit() == null ? null : spInfo.getSupplyStorageOrgUnit().getNumber());
                        spVo.setProjectID(spInfo.getProject() == null ? null : spInfo.getProject().getId().toString());
                        spVo.setProjectName(spInfo.getProject() == null ? null : spInfo.getProject().getName());
                        spVo.setProjectNumber(spInfo.getProject() == null ? null : spInfo.getProject().getNumber());
                        spVo.setTrackNumberID(spInfo.getTraceNo() == null ? null : spInfo.getTraceNo().getId().toString());
                        spVo.setTrackNumberName(spInfo.getTraceNo() == null ? null : spInfo.getTraceNo().getName());
                        spVo.setTrackNumberNumber(spInfo.getTraceNo() == null ? null : spInfo.getTraceNo().getNumber());
                        spVo.setSupplierID(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getId().toString());
                        spVo.setSupplierName(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getName());
                        spVo.setSupplierNumber(spInfo.getSupplier() == null ? null : spInfo.getSupplier().getNumber());
                        spVo.setPurGroupName(purGroupName);
                        spVo.setPurGroupNumber(purGroupNumber);
                        spVo.setPurPersonName(purPersonName);
                        spVo.setPurPersonNumber(purPersonNumber);
                        spVo.setBaseunit(spInfo.getUnit());
                        sdMap = new HashMap();
                        sdVo = new SpDemandMapVO();
                        sdVo.setDemandDate(spInfo.getRequirementDate());
                        sdVo.setDemandQty(spInfo.getQty());
                        sdVo.setFlag(flag);
                        sdVo.setSupplierQty(supplyQty != null ? supplyQty : BigDecimal.ZERO);
                        spList = new ArrayList();
                        spList.add(spInfo);
                        sdVo.setStockingplanList(spList);
                        sdMap.put(spInfo.getRequirementDate(), sdVo);
                        spVo.setSdMap(sdMap);
                    }
                    spVO_map.put(key, spVo);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        mapR.put("spVO_map", spVO_map);
        mapR.put("setOfTime", setOfTime);
        return mapR;
    }

    @Override
    protected IObjectValue _getExistFBDetail(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        KeyDimensionForFBdetialVO spVo = (KeyDimensionForFBdetialVO)param.get("spVo");
        java.util.Date date = (java.util.Date)param.get("date");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select fid from ct_psp_stockingplanfbdetail  \n ");
        sql.append(" where isnull(cfsupplystorageorg,'0') = '").append(spVo.getSupplyStroageOrgUnit() != null ? spVo.getSupplyStroageOrgUnit().getId().toString() : "0").append("' \n ");
        sql.append(" and  isnull(cfpurchaseorguniti,'0')  = '").append(spVo.getPurchaseOrgUnit() != null ? spVo.getPurchaseOrgUnit().getId().toString() : "0").append("' \n ");
        sql.append(" and   isnull(cfmaterialid,'0')  = '").append(spVo.getMaterial() != null ? spVo.getMaterial().getId().toString() : "0").append("' \n ");
        sql.append(" and   isnull(cfsupplierid,'0')  = '").append(spVo.getSupplier() != null ? spVo.getSupplier().getId().toString() : "0").append("' \n ");
        sql.append(" and  isnull(cfprojectid ,'0') = '").append(spVo.getProject() != null ? spVo.getProject().getId().toString() : "0").append("' \n ");
        sql.append(" and  isnull(cftracknumberid ,'0') = '").append(spVo.getTrackNumber() != null ? spVo.getTrackNumber().getId().toString() : "0").append("' \n ");
        sql.append(" and  cfspdemanddate =  ");
        sql.append(" {ts'").append(sdf.format(spVo.getDemandDate())).append("'} ");
        sql.append(" and cfbasestatus = '10' \n ");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fid = null;
        if (irs != null) {
            try {
                if (irs.next()) {
                    fid = irs.getString("fid");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (fid != null) {
            StockingPlanFBdetailInfo spFbInfo = StockingPlanFBdetailFactory.getLocalInstance(ctx).getStockingPlanFBdetailInfo((IObjectPK)new ObjectUuidPK(fid));
            return spFbInfo;
        }
        return null;
    }

    @Override
    protected String _singleSupply(Context ctx, IObjectValue objectValue, KeyDimensionForFBdetialVO kfbvo) throws BOSException, EASBizException {
        if (objectValue == null) {
            return "\u53c2\u6570\u4f20\u9012\u6709\u8bef";
        }
        StockingPlanFBdetailInfo info = (StockingPlanFBdetailInfo)objectValue;
        IStockingPlan isp = StockingPlanFactory.getLocalInstance(ctx);
        if (info.getFbQty() == null || BigDecimal.ZERO.compareTo(info.getFbQty()) == 0) {
            return "\u53cd\u9988\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0";
        }
        BigDecimal totalQty = info.getUnCloseQty();
        if (totalQty.compareTo(BigDecimal.ZERO) <= 0) {
            return "\u65e0\u53ef\u5206\u914d\u6570\u91cf";
        }
        this.deleteFBusedQty(ctx, info.getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" select psp.fid as fid ,max(psp.fqty) as qty,sum(pfb.fusefbqty) as useqty,min(psp.frequirementdate) as redate  \n");
        sql.append(" from t_psp_stockingplan psp  \n");
        sql.append(" left join t_psp_psptofbdetail pfb on pfb.fstockingplanid = psp.fid  \n");
        sql.append(" where isnull(psp.fsupplierid,'0') = '").append(info.getSupplier() != null ? info.getSupplier().getId().toString() : "0").append("'  \n");
        sql.append(" and isnull(psp.fprojectid,'0') = '").append(info.getProject() != null ? info.getProject().getId().toString() : "0").append("'  \n");
        sql.append(" and isnull(psp.ftraceNoid,'0')= '").append(info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : "0").append("'  \n");
        sql.append(" and isnull(psp.fpurchaseorgunitid ,'0')= '").append(info.getPurchaseOrgUnit() != null ? info.getPurchaseOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and isnull(psp.fsupplystorageorgunitid,'0') = '").append(info.getSupplyStorageOrgUnit() != null ? info.getSupplyStorageOrgUnit().getId().toString() : "0").append("'  \n");
        sql.append(" and fmaterialid = '").append(info.getMaterial() != null ? info.getMaterial().getId().toString() : "0").append("'  \n");
        sql.append(" and psp.frequirementdate >= ");
        sql.append(" {ts'").append(sdf.format(info.getSupplierDate() == null ? new java.util.Date() : info.getSupplierDate())).append("'}");
        sql.append(" group by psp.fid   \n");
        sql.append(" order by redate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs != null) {
            try {
                while (irs.next() && totalQty.compareTo(BigDecimal.ZERO) > 0) {
                    String spfid = irs.getString("fid");
                    BigDecimal spQty = irs.getBigDecimal("qty");
                    BigDecimal userQty = irs.getBigDecimal("useqty") == null ? BigDecimal.ZERO : irs.getBigDecimal("useqty");
                    Date reDate = irs.getDate("redate");
                    if (userQty.compareTo(spQty) >= 0) continue;
                    if ((spQty = spQty.subtract(userQty)).compareTo(totalQty) < 0) {
                        this.updateFBTOTable(ctx, info, spfid, spQty, reDate);
                        totalQty = totalQty.subtract(spQty);
                        continue;
                    }
                    this.updateFBTOTable(ctx, info, spfid, totalQty, reDate);
                    totalQty = BigDecimal.ZERO;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5931\u8d25\uff01", "\u53cd\u9988\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(info.getId().toString());
        StockPlanSyncThread thread = new StockPlanSyncThread(ctx, pkList);
        thread.start();
        return "true";
    }

    private void updateFBTOTable(Context ctx, StockingPlanFBdetailInfo info, String spid, BigDecimal useQty, java.util.Date reDate) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" insert into t_psp_psptofbdetail (fid,fstockingplanid ,fstockingplanfbdetailid,fusefbqty,fdemanddate,fsupplydate)  \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spid).append("' ,");
        sql.append("'").append(info.getId().toString()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("{ts'").append(sdf.format(reDate)).append("'},");
        sql.append("{ts'").append(sdf.format(info.getSupplierDate())).append("'} )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteFBusedQty(Context ctx, String fbdID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  delete from t_psp_psptofbdetail   \n");
        sql.append("  where fstockingplanfbdetailid = '").append(fbdID).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private BigDecimal getPspFBDetail(Context ctx, String StockingplanID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" \n");
        sql.append("  select sum(fusefbqty) as useqty from t_psp_psptofbdetail  \n");
        sql.append("  where fstockingplanid = '").append(StockingplanID).append("' \n");
        sql.append("  group by fstockingplanid \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs != null) {
            try {
                if (irs.next()) {
                    BigDecimal qty = irs.getBigDecimal("useqty");
                    return qty == null ? BigDecimal.ZERO : qty;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5931\u8d25\uff01", "\u53cd\u9988\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    protected HashMap _refreshAllSupply(Context ctx, HashMap param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        PspParameterSet pspParam = (PspParameterSet)param.get("pspParam");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" update ct_psp_stockingplanfbdetail set cfbasestatus = '20', cfuncloseqty = 0 \n");
        sql.append(" where cfspqty = cffbqty \n");
        sql.append(" and cfspqty = cfdeliveredqty \n");
        sql.append(" and cfpurchaseorguniti = '" + pspParam.getPspOperationSchemeInfo().getPurchaseOrgUnit().getId().toString() + "' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update ct_psp_stockingplanfbdetail set cfuncloseqty = isnull(cffbqty,0) - isnull(cfdeliveredqty,0) \n");
        sql.append(" where 1=1 \n");
        sql.append(" \n");
        sql.append(" and cfpurchaseorguniti = '" + pspParam.getPspOperationSchemeInfo().getPurchaseOrgUnit().getId().toString() + "' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("  select  SFB.fid , isnull(SFB.cfuncloseqty,0)  as qty ,SFB.CFSupplierDate  as fbDate, \n");
        sql.append("  SFB.CFPurchaseOrgUnitI as purchaseorgunitid ,SFB.CFMaterialID as materialid ,SFB.CFProjectID  as projectid, SFB.CFTrackNumberID as tracknumberid, \n");
        sql.append("  SFB.CFSupplierID   as supplierid ,SFB.CFSupplyStorageOrg  as supplyorgunitid \n");
        sql.append(" from CT_PSP_StockingPlanFBdetail SFB    \n");
        sql.append(" inner join (select  fpurchaseorgunitid ,fmaterialid,fprojectid,ftracenoid,fsupplierid,FsupplyStorageOrgUnitID    \n");
        sql.append(" from  t_psp_stockingplan where FPurChaseOrgUnitID = '" + pspParam.getPspOperationSchemeInfo().getPurchaseOrgUnit().getId().toString() + "'   \n");
        sql.append("   and fsupplierid is not null group by fpurchaseorgunitid ,fmaterialid,fprojectid,ftracenoid,fsupplierid,FsupplyStorageOrgUnitID )psp   \n");
        sql.append(" on psp.fpurchaseorgunitid = SFB.CFPurchaseOrgUnitI  and psp.fmaterialid = SFB.CFMaterialID and isnull(psp.fprojectid,0) = isnull(SFB.CFProjectID,0)  \n");
        sql.append("  and  isnull(psp.ftracenoid,0) = isnull(SFB.CFTrackNumberID,0)  and isnull(psp.fsupplierid,0) = isnull(SFB.CFSupplierID,0)  and psp.fsupplystorageOrgunitid = SFB.CFSupplyStorageOrg   \n");
        sql.append("  where    SFB.CFBaseStatus = '10'    \n");
        sql.append(" order by SFB.CFSupplierDate    \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, FBDetailSpVO> fb_Map = new HashMap<String, FBDetailSpVO>();
        if (irs != null) {
            try {
                while (irs.next()) {
                    ArrayList<FbVO> fbList;
                    FBDetailSpVO fspVO;
                    String purchaseorgunitid = irs.getString("purchaseorgunitid");
                    String materialid = irs.getString("materialid");
                    String projectid = irs.getString("projectid");
                    String tracknumberid = irs.getString("tracknumberid");
                    String supplierid = irs.getString("supplierid");
                    String supplyorgunitid = irs.getString("supplyorgunitid");
                    String fid = irs.getString("fid");
                    BigDecimal qty = irs.getBigDecimal("qty");
                    Date fbDate = irs.getDate("fbDate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid);
                    if (fb_Map.containsKey(key)) {
                        fspVO = (FBDetailSpVO)fb_Map.get(key);
                        fbList = fspVO.getFbList();
                        fbList.add(new FbVO(fbDate, fid, qty));
                        fspVO.setFbList(fbList);
                        fb_Map.put(key, fspVO);
                        continue;
                    }
                    fspVO = new FBDetailSpVO();
                    fbList = new ArrayList();
                    fbList.add(new FbVO(fbDate, fid, qty));
                    fspVO.setFbList(fbList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        sql.setLength(0);
        sql.append("  select psp.fid ,psp.fqty ,psp.frequirementdate as rdate ,  \n");
        sql.append("  psp.fpurchaseorgunitid as purchaseorgunitid,  psp.fmaterialid as materialid,  psp.fprojectid as projectid,  \n");
        sql.append("  ftracenoid as tracknumberid,  fsupplierid as supplierid ,  fsupplystorageOrgunitid  as supplyorgunitid  \n");
        sql.append("  from t_psp_stockingplan psp  \n");
        sql.append("  inner join (  \n");
        sql.append("  select CFPurchaseOrgUnitI,CFMaterialID,CFProjectID,CFTrackNumberID,CFSupplierID,CFSupplyStorageOrg  \n");
        sql.append("  from CT_PSP_StockingPlanFBdetail   \n");
        sql.append("  where CFBaseStatus = '10' and CFPurchaseOrgUnitI = '" + pspParam.getPspOperationSchemeInfo().getPurchaseOrgUnit().getId().toString() + "'  \n");
        sql.append("  group by CFPurchaseOrgUnitI,CFMaterialID,CFProjectID,CFTrackNumberID,CFSupplierID,CFSupplyStorageOrg )SFB  \n");
        sql.append("  on psp.fpurchaseorgunitid = SFB.CFPurchaseOrgUnitI  and psp.fmaterialid = SFB.CFMaterialID and isnull(psp.fprojectid ,0)= isnull(SFB.CFProjectID ,0)   \n");
        sql.append("  and isnull(psp.ftracenoid,0) =isnull( SFB.CFTrackNumberID ,0) and isnull(psp.fsupplierid,0) = isnull(SFB.CFSupplierID,0)  and psp.fsupplystorageOrgunitid = SFB.CFSupplyStorageOrg    \n");
        sql.append("  order by psp.frequirementdate");
        IRowSet irs_SP = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs_SP != null) {
            try {
                while (irs_SP.next()) {
                    String purchaseorgunitid = irs_SP.getString("purchaseorgunitid");
                    String materialid = irs_SP.getString("materialid");
                    String projectid = irs_SP.getString("projectid");
                    String tracknumberid = irs_SP.getString("tracknumberid");
                    String supplierid = irs_SP.getString("supplierid");
                    String supplyorgunitid = irs_SP.getString("supplyorgunitid");
                    String fid = irs_SP.getString("fid");
                    BigDecimal spqty = irs_SP.getBigDecimal("fqty");
                    Date spDate = irs_SP.getDate("rdate");
                    String key = "#" + purchaseorgunitid + "#" + supplyorgunitid + "#" + supplierid + "#" + materialid + "#" + (projectid == null ? "" : projectid) + "#" + (tracknumberid == null ? "" : tracknumberid);
                    if (!fb_Map.containsKey(key)) continue;
                    FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
                    ArrayList<SpVO> spList = fspVO.getSpList();
                    spList.add(new SpVO(spDate, fid, spqty));
                    fspVO.setSpList(spList);
                    fb_Map.put(key, fspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
            }
        }
        Set keys = fb_Map.keySet();
        for (Object key : keys) {
            FBDetailSpVO fspVO = (FBDetailSpVO)fb_Map.get(key);
            this.handleProcess(ctx, fspVO);
        }
        return super._refreshAllSupply(ctx, param);
    }

    private void handleProcess(Context ctx, FBDetailSpVO fspVO) throws EASBizException {
        ArrayList<FbVO> fbList = fspVO.getFbList();
        ArrayList<SpVO> spList = fspVO.getSpList();
        if (spList == null || spList.size() == 0) {
            return;
        }
        int spCount = spList.size();
        int j = 0;
        for (int i = 0; i < fbList.size(); ++i) {
            FbVO fbVO = fbList.get(i);
            BigDecimal fbQty = fbVO.getQty();
            java.util.Date fbDate = fbVO.getFbDate();
            while (fbQty.compareTo(BigDecimal.ZERO) > 0 && j < spCount) {
                SpVO spVO = spList.get(j);
                if (DateUtils.isSameDay((java.util.Date)spVO.getSpDate(), (java.util.Date)fbDate) || this.getZERO(spVO.getSpDate()).after(this.getZERO(fbDate))) {
                    BigDecimal spQty = spVO.getSpqty();
                    if (spQty.compareTo(BigDecimal.ZERO) == 0) {
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) > 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(spQty.subtract(fbQty));
                        spList.set(j, spVO);
                        continue;
                    }
                    if (spQty.compareTo(fbQty) == 0) {
                        this.insetNewRelation(ctx, fbVO, spVO, fbQty);
                        fbQty = BigDecimal.ZERO;
                        spVO.setSpqty(BigDecimal.ZERO);
                        spList.set(j, spVO);
                        ++j;
                        continue;
                    }
                    if (spQty.compareTo(fbQty) >= 0) continue;
                    this.insetNewRelation(ctx, fbVO, spVO, spQty);
                    fbQty = fbQty.subtract(spQty);
                    spVO.setSpqty(BigDecimal.ZERO);
                    spList.set(j, spVO);
                    ++j;
                    continue;
                }
                ++j;
            }
            if (j >= spCount) break;
        }
    }

    private void insetNewRelation(Context ctx, FbVO fbVO, SpVO spVO, BigDecimal useQty) throws EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" insert into t_psp_psptofbdetail (fid,fstockingplanid ,fstockingplanfbdetailid,fusefbqty,fdemanddate,fsupplydate)  \n");
        sql.append(" VALUES ( \n");
        sql.append(" newbosid('88888888') ,");
        sql.append("'").append(spVO.getSpID()).append("' ,");
        sql.append("'").append(fbVO.getFbID()).append("' ,");
        sql.append("").append(useQty).append(" ,");
        sql.append("{ts'").append(sdf.format(spVO.getSpDate())).append("'},");
        sql.append("{ts'").append(sdf.format(fbVO.getFbDate())).append("'} )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff01", "\u53cd\u9988\u5237\u65b0\u5931\u8d25\uff1a\n" + e.getMessage()));
        }
    }

    private java.util.Date getZERO(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Override
    protected HashMap _singleSupply4Portal(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        KeyDimensionForFBdetialVO spVo = (KeyDimensionForFBdetialVO)param.get("spVo");
        if (spVo == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u53cd\u9988\u5931\u8d25\uff01", "\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a\n"));
        }
        StockingPlanFBdetailInfo fbInfo = new StockingPlanFBdetailInfo();
        StockingPlanFBdetailInfo obj = (StockingPlanFBdetailInfo)this._getExistFBDetail(ctx, param);
        if (obj != null) {
            fbInfo = obj;
            StockingPlanFBdetailEntryInfo fbeInfo = new StockingPlanFBdetailEntryInfo();
            fbeInfo.setProject(fbInfo.getProject());
            fbeInfo.setPurchaseOrgUnit(fbInfo.getPurchaseOrgUnit());
            fbeInfo.setParent(fbInfo);
            fbeInfo.setSupplyStorageOrgUnit(fbInfo.getSupplyStorageOrgUnit());
            fbeInfo.setSupplier(fbInfo.getSupplier());
            fbeInfo.setSupplierDate(fbInfo.getSupplierDate());
            fbeInfo.setSupplierFBStatus(fbInfo.getSupplierFBStatus());
            fbeInfo.setSupplierPerson(fbInfo.getSupplierPerson());
            fbeInfo.setSupplierReason(fbInfo.getSupplierReason());
            fbeInfo.setSupplierSituation(fbInfo.getSupplierSituation());
            fbeInfo.setTrackNumber(fbInfo.getTrackNumber());
            fbeInfo.setMaterial(fbInfo.getMaterial());
            fbeInfo.setMaterialName(fbInfo.getMaterialName());
            fbeInfo.setUnit(fbInfo.getUnit());
            fbeInfo.setSpDemandDate(fbInfo.getSpDemandDate());
            fbeInfo.setSpQty(fbInfo.getSpQty());
            fbeInfo.setFbQty(fbInfo.getFbQty());
            StockingPlanFBdetailEntryFactory.getLocalInstance(ctx).save((CoreBaseInfo)fbeInfo);
        } else {
            fbInfo.setPurchaseOrgUnit(spVo.getPurchaseOrgUnit());
            fbInfo.setSupplyStorageOrgUnit(spVo.getSupplyStroageOrgUnit());
            fbInfo.setMaterial(spVo.getMaterial());
            fbInfo.setSupplier(spVo.getSupplier());
            fbInfo.setProject(spVo.getProject());
            fbInfo.setTrackNumber(spVo.getTrackNumber());
            fbInfo.setSpDemandDate(spVo.getDemandDate());
            fbInfo.setSpQty(spVo.getDemandQty());
        }
        fbInfo.setSpQty(spVo.getDemandQty());
        fbInfo.setSupplierFBStatus(spVo.getSupplierFBStatus());
        fbInfo.setSupplierDate(spVo.getSupplierDate());
        BigDecimal demandQty = fbInfo.getSpQty() == null ? BigDecimal.ZERO : fbInfo.getSpQty();
        BigDecimal supDeQty = fbInfo.getFbQty() == null ? BigDecimal.ZERO : fbInfo.getFbQty();
        BigDecimal unCloseQty = fbInfo.getUnCloseQty() == null ? BigDecimal.ZERO : fbInfo.getUnCloseQty();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String deliverDate = sdf.format(fbInfo.getSpDemandDate());
        String supDeDate = "1900-01-01";
        if (fbInfo.getSupplierDate() != null) {
            supDeDate = sdf.format(fbInfo.getSupplierDate());
        }
        if (deliverDate.equals(supDeDate) && demandQty.compareTo(supDeQty) <= 0 && demandQty.compareTo(unCloseQty) != 0) {
            supDeQty = supDeQty.add(demandQty.subtract(unCloseQty));
            unCloseQty = unCloseQty.add(demandQty.subtract(unCloseQty));
            fbInfo.setFbQty(supDeQty);
            fbInfo.setUnCloseQty(unCloseQty);
        } else {
            fbInfo.setUnCloseQty(spVo.getSupplierQty().subtract(supDeQty).add(fbInfo.getUnCloseQty() == null ? BigDecimal.ZERO : fbInfo.getUnCloseQty()));
            fbInfo.setFbQty(spVo.getSupplierQty());
        }
        fbInfo.setSupplierPerson(spVo.getSupplierPerson());
        fbInfo.setSupplierReason(spVo.getSupplierReason());
        fbInfo.setSupplierSituation(spVo.getSupplierSituation());
        if (obj == null) {
            fbInfo.setBaseStatus(SpFBStatus.ON);
            IObjectPK pk = StockingPlanFBdetailFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)fbInfo);
            fbInfo.setId(BOSUuid.read((String)pk.toString()));
        } else {
            StockingPlanFBdetailFactory.getLocalInstance(ctx).save((CoreBaseInfo)fbInfo);
        }
        this._singleSupply(ctx, (IObjectValue)fbInfo, null);
        return super._singleSupply4Portal(ctx, param);
    }

    public static String getIsSupplier(String idListStr) throws EASBizException, BOSException, SQLException {
        String msg = null;
        StringBuffer sql = new StringBuffer();
        sql.append("  select sup.fid,sup.fname_l2 as name  from t_bd_supplier sup ");
        sql.append("  where sup.Cfpersonid is null and sup.fusedstatus = ").append(1);
        sql.append("    and sup.fid in ( ");
        sql.append("\t ").append(idListStr).append(")");
        sql.append("    )");
        IRowSet rowSet = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        while (rowSet.next()) {
            String fid = rowSet.getString("fid");
            String name = rowSet.getString("name");
            msg = msg + name + "\n";
        }
        return msg;
    }

    @Override
    protected HashMap _getFBDetailList(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        KeyDimensionForFBdetialVO spVo = (KeyDimensionForFBdetialVO)param.get("spVo");
        List stockingList = spVo.getStockingplaList();
        if (stockingList == null || stockingList.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("  \n");
        sql.append(" select fid,useqty,fnumber,spdate,fbqty,deqty from  \n");
        sql.append("  (select ptf.fstockingplanfbdetailid as fid ,sum(ptf.fusefbqty) as useqty ,\n");
        sql.append("  max(fb.fnumber) as fnumber ,max(fb.cfsupplierdate) as spdate , max(fb.cffbqty) as fbqty\n");
        sql.append("   ,max(fb.cfdeliveredqty) as deqty from  t_psp_psptofbdetail ptf\n");
        sql.append("  left join ct_psp_stockingplanfbdetail fb on ptf.fstockingplanfbdetailid = fb.fid\n");
        sql.append("  where fstockingplanid in " + this.getidList(stockingList) + "\n");
        sql.append("  group by ptf.fstockingplanfbdetailid \n");
        sql.append("  union  \n");
        sql.append("  select fb.fid,0,max(fb.fnumber) as fnumber ,max(fb.cfsupplierdate) as spdate , max(fb.cffbqty) as fbqty  \n");
        sql.append("  ,max(fb.cfdeliveredqty) as deqty  \n");
        sql.append("  from ct_psp_stockingplanfbdetail  fb  \n");
        sql.append("  left  join T_PSP_StockingPlan psp on psp.Fmaterialid=fb.cfmaterialid    \n");
        sql.append("  and psp.Fprojectid=fb.cfprojectid  \n");
        sql.append("  and psp.Ftracenoid=fb.cftracknumberid  \n");
        sql.append("   where not exists (select 1 from T_PSP_PSPTOFBDETAIL where T_PSP_PSPTOFBDETAIL.FSTOCKINGPLANFBDETAILID=fb.fid)  and psp.fid is not null  \n");
        sql.append("  group by fb.fid)  \n");
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<FBListVO> fblist = new ArrayList<FBListVO>();
        if (irs != null) {
            try {
                while (irs.next()) {
                    String fid = irs.getString("fid");
                    BigDecimal useQty = irs.getBigDecimal("useqty");
                    String fnumber = irs.getString("fnumber");
                    Date spDate = irs.getDate("spdate");
                    BigDecimal fbqty = irs.getBigDecimal("fbqty");
                    BigDecimal deqty = irs.getBigDecimal("deqty");
                    FBListVO fbVO = new FBListVO();
                    fbVO.setFid(fid);
                    fbVO.setUseQty(useQty);
                    fbVO.setSpDate(spDate);
                    fbVO.setSpQty(fbqty);
                    fbVO.setDeQty(deqty);
                    fbVO.setFnumber(fnumber);
                    fblist.add(fbVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<FBListVO>> mapR = new HashMap<String, ArrayList<FBListVO>>();
        mapR.put("fblist", fblist);
        return mapR;
    }

    private String getidList(List spList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = spList.iterator();
        strBuf.append("(");
        while (it.hasNext()) {
            strBuf.append("'");
            StockingPlanInfo info = (StockingPlanInfo)it.next();
            strBuf.append(info.getId().toString());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.append(")");
        } else {
            strBuf.append(")");
        }
        return strBuf.toString();
    }

    @Override
    protected HashMap _getPurList(Context ctx, HashMap param) throws BOSException, EASBizException {
        String idStr = (String)param.get("idStr");
        if (IndustryUtils.isEmptyString((String)idStr)) {
            return null;
        }
        StockingPlanInfo spInfo = StockingPlanFactory.getLocalInstance(ctx).getStockingPlanInfo((IObjectPK)new ObjectUuidPK(idStr));
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        ArrayList<pspPurVO> spPurList = new ArrayList<pspPurVO>();
        if (StockingPlanType.HOST.equals((Object)spInfo.getStockingPlanType())) {
            sql.setLength(0);
            sql.append(" \n");
            sql.append(" select ts.fid as purorderid ,ts.fnumber as purordernumber ,tse.fseq ,spd.fpurqty as fpurorderqty \n");
            sql.append(" from t_psp_stockingplandetail spd \n");
            sql.append(" left join t_sm_purorderentry tse on tse.fid = spd.fpurorderentryid \n");
            sql.append(" left join t_sm_purorder ts on ts.fid = tse.fparentid \n");
            sql.append(" where spd.fstockingplanid  =  '" + idStr + "' \n");
        } else {
            sql.setLength(0);
            sql.append(" \n");
            sql.append(" select ts.fid as purorderid ,ts.fnumber as purordernumber ,tse.fseq ,spd.fpurorderqty \n");
            sql.append(" from t_psp_stockingplan spd \n");
            sql.append(" left join t_sm_purorderentry tse on tse.fid = spd.cfsourcebillid \n");
            sql.append(" left join t_sm_purorder ts on ts.fid = tse.fparentid \n");
            sql.append(" where spd.fid = '" + idStr + "' \n");
        }
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (irs != null) {
            try {
                while (irs.next()) {
                    pspPurVO pspVO = new pspPurVO();
                    String purorderid = irs.getString("purorderid");
                    if (IndustryUtils.isEmptyString((String)purorderid)) continue;
                    String purordernumber = irs.getString("purordernumber");
                    String fseq = irs.getString("fseq");
                    BigDecimal fpurqty = irs.getBigDecimal("fpurorderqty");
                    pspVO.setPurorderID(purorderid);
                    pspVO.setPurorderNumber(purordernumber);
                    pspVO.setPurentrySeq(fseq);
                    pspVO.setPurQty(fpurqty);
                    spPurList.add(pspVO);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<pspPurVO>> mapR = new HashMap<String, ArrayList<pspPurVO>>();
        mapR.put("list", spPurList);
        return mapR;
    }

    private class StockPlanSyncThread
    extends Thread {
        private List<String> pkList;
        private Context ctx;

        private StockPlanSyncThread(Context _ctx, List<String> _pkList) {
            this.ctx = _ctx;
            this.pkList = _pkList;
        }

        @Override
        public void run() {
            Class<?> className = null;
            try {
                className = Class.forName("com.kingdee.eas.mm.mscp.app.PspStockingPlanSyncNextFacadeControllerBean");
                Method _method = className.getMethod("handSyncStockFeedback", Context.class, List.class);
                _method.invoke(className.newInstance(), this.ctx, this.pkList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

