/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.report.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.text.SimpleDateFormat;

public class MaterialStockUpQTReportServer
extends ReportServerBase {
    private String projectId;
    private String purchaseOrgId;
    private String storageOrgUnitId;
    private String tempTable;
    private Context ctx;
    private String beginTrack;
    private String endTrack;
    private String beginDate;
    private String endDate;
    private String isQT;

    protected IRowSet getReportData(String arg0, RptParams arg1) throws Exception {
        this.ctx = this.getContext();
        StringBuffer sql = new StringBuffer();
        this.initRptParams(arg1);
        this.tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTable, "projectid,materialId", false, false);
        this.insertTempData();
        sql.append("select * from ").append(this.tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.tempTable);
        return rs;
    }

    private void insertTempData() throws Exception {
        String tableTemp = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable2());
        TempTablePool.getInstance((Context)this.ctx).createIndex(this.tempTable, "fprojectid,ftrackNumberid", false, false);
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/Insert into ").append(tableTemp).append("\r\n");
        sql.append("Select fprojectid, ftrackNumberid  from T_PCP_ProjectCP\r\n");
        sql.append("where FState = 4\r\n");
        sql.append("and FFinishTime between to_date('" + this.beginDate + "','yyyy-MM-dd hh24:mi:ss')\r\nand to_date('" + this.endDate + "','yyyy-MM-dd hh24:mi:ss')\r\ngroup by fprojectid, ftrackNumberid");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/Insert into ").append(this.tempTable).append("\r\n");
        String tmpSQL = "select max(pro.fname_l2),\r\nmax(tk.fnumber),\r\nmax(mat.fnumber),\r\nmax(mat.fname_l2),\r\nmax(mat.fmodel),\r\nmax(splan.funit),\r\nmax(org.fname_l2),\r\nmax(t1.fdemandqty),\r\nmin(to_char(t1.fleadtime,'yyyy-MM-dd')),\r\nsum(t1.fspqty),\r\nmax(to_char(t1.fsptime,'yyyy-MM-dd')),\r\nnvl(sum(tof.fusefbqty), 0),\r\nmax(to_char(tof.fdemanddate,'yyyy-MM-dd')),\r\nnvl(sum(t1.fallocatedqty), 0),\r\nlistagg(t1.cfaffiliationunit,',') WITHIN GROUP (ORDER BY t1.cfaffiliationunit) cfaffiliationunit \r\nfrom t_psp_stockingplan splan\r\ninner join (select sum(dem.fdemandqty) fdemandqty,\r\nmin(dem.fleadtime) fleadtime,\r\nsum(dem.fallocatedqty) fallocatedqty,\r\ndet.fstockingplanid stockPlanid,\r\nmax(a1.cfaffiliationunit) cfaffiliationunit,\r\nsum(det.fspqty) fspqty,\r\nmax(det.fsptime) fsptime\r\nfrom t_psp_pspstockingdemand dem\r\n inner join (select cfdemandid,fmaterialid,fstockingplanid, max(fsptime) fsptime,sum(ff.fspqty) fspqty from t_psp_stockingplandetail ff \r\n  group by  ff.cfdemandid,ff.fmaterialid,ff.fstockingplanid,fsptime ) det\r\n on dem.fid = det.cfdemandid\r\ninner join (select cmd.cfmaterialid,\r\ncmd.cfaffiliationunit\r\nfrom " + tableTemp + " pcp\r\ninner join CT_BAS_CruxMaterialDefinition cmd\r\non cmd.cfprojectid = pcp.fprojectid\r\ngroup by cmd.cfprojectid,cfmaterialid,cmd.cfaffiliationunit) a1\r\non det.fmaterialid = a1.cfmaterialid\r\ngroup by det.fstockingplanid) t1\r\non t1.stockPlanid = splan.fid\r\ninner join " + tableTemp + " t2\r\non t2.fprojectid=splan.fprojectid and splan.ftracenoid = t2.ftrackNumberid \r\nleft join T_PSP_PSPTOFBDETAIL tof\r\non splan.fid = tof.fstockingplanid\r\nleft join t_mm_project pro\r\non pro.fid = splan.fprojectid\r\nleft join t_bd_material mat\r\non mat.fid = splan.fmaterialid\r\nleft join t_bd_material mat\r\non mat.fid = splan.fmaterialid\r\nleft join T_ORG_Storage org\r\non org.fid = splan.fstorageorgunitid\r\nleft join T_MM_TrackNumber tk\r\non tk.fid = splan.ftracenoid\r\nleft join T_ORG_Purchase chs\r\non chs.fid = splan.fpurChaseOrgUnitid\r\n";
        sql.append(tmpSQL);
        sql.append("Where 1=1\r\n");
        if (this.verifyUtil(this.projectId)) {
            sql.append("and pro.fid = '" + this.projectId + "'\r\n");
        }
        if (this.verifyUtil(this.purchaseOrgId)) {
            sql.append("And chs.fid = '" + this.purchaseOrgId + "'");
        }
        if (this.verifyUtil(this.storageOrgUnitId)) {
            sql.append("And org.fid = '" + this.purchaseOrgId + "'");
        }
        if (this.verifyUtil(this.beginTrack)) {
            sql.append("And tk.fnumber>='" + this.beginTrack + "'\r\n");
        }
        if (this.verifyUtil(this.endTrack)) {
            sql.append("And tk.fnumber<='" + this.endTrack + "'\r\n");
        }
        if ("true".equals(this.isQT)) {
            sql.append("And ((tof.fusefbqty<splan.fqty)or(tof.fdemanddate>splan.frequirementdate))");
        }
        sql.append("group by org.fid, mat.fid, pro.fid, tk.fid ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tableTemp);
    }

    private boolean verifyUtil(String str) {
        boolean flag = false;
        if (str != null && !"".equals(str) && str.length() > 0) {
            flag = true;
        }
        return flag;
    }

    private String createTempTable2() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create table t_msq_filterdata(");
        sql.append("fprojectid nvarchar(44),");
        sql.append("ftrackNumberid nvarchar(44)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create table t_msq_materialStockUp(");
        sql.append("projectName nvarchar(200),");
        sql.append("trackNumber nvarchar(200),");
        sql.append("materialNumber nvarchar(200),");
        sql.append("materialName nvarchar(200),");
        sql.append("model varchar(44),");
        sql.append("unit varchar(44),");
        sql.append("storageOrgUnitIdName nvarchar(200),");
        sql.append("requirementQty numeric(28,2),");
        sql.append("reqDate varchar(44),");
        sql.append("stockQty numeric(28,2),");
        sql.append("stockDate varchar(44),");
        sql.append("stockCNqty numeric(28,2),");
        sql.append("stockCNdate varchar(44),");
        sql.append("inventoryQty numeric(28,2),");
        sql.append("affiliationUnit varchar(300)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String arg0, RptParams arg1) throws BaseException {
        return null;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader temp = reportHeader.addChild("projectName", "\u9879\u76ee\u540d\u79f0");
        temp.setWidth(250);
        temp = reportHeader.addChild("trackNumber", "\u8ddf\u8e2a\u53f7");
        temp.setWidth(100);
        temp = reportHeader.addChild("materialNumber", "\u7269\u6599\u7f16\u7801");
        temp = reportHeader.addChild("materialName", "\u7269\u6599\u540d\u79f0");
        temp.setWidth(150);
        temp = reportHeader.addChild("model", "\u89c4\u683c\u578b\u53f7");
        temp.setWidth(120);
        temp = reportHeader.addChild("unit", "\u8ba1\u91cf\u5355\u4f4d");
        temp = reportHeader.addChild("storageOrgUnitIdName", "\u751f\u4ea7\u7ec4\u7ec7");
        temp.setWidth(200);
        temp = reportHeader.addChild("requirementQty", "\u9700\u6c42\u6570\u91cf");
        temp = reportHeader.addChild("reqDate", "\u9700\u6c42\u65e5\u671f");
        temp = reportHeader.addChild("stockQty", "\u5907\u8d27\u6570\u91cf");
        temp = reportHeader.addChild("stockDate", "\u5907\u8d27\u65e5\u671f");
        temp = reportHeader.addChild("stockCNqty", "\u5907\u8d27\u627f\u8bfa\u6570\u91cf");
        temp = reportHeader.addChild("stockCNdate", "\u5907\u8d27\u627f\u8bfa\u65e5\u671f");
        temp = reportHeader.addChild("inventoryQty", "\u5373\u65f6\u5e93\u5b58");
        temp = reportHeader.addChild("affiliationUnit", "\u6240\u5c5e\u90e8\u4ef6");
        return reportHeader;
    }

    private void initRptParams(RptParams param) throws Exception {
        String date;
        IRowSet rs;
        String sql;
        if (param.getObject("Project") != null) {
            this.projectId = (String)param.getObject("Project");
            sql = "select fid   from T_MM_Project where fnumber ='" + this.projectId + "'";
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            this.projectId = "";
            while (rs.next()) {
                this.projectId = rs.getString("fid");
            }
        } else {
            this.projectId = null;
        }
        this.beginTrack = param.getObject("TrackNumber") != null ? (String)param.getObject("TrackNumber") : null;
        this.endTrack = param.getObject("TrackNumber") != null ? (String)param.getObject("EndTrackNumber") : null;
        if (param.getObject("StorageOrgUnit") != null) {
            this.storageOrgUnitId = (String)param.getObject("StorageOrgUnit");
            sql = "select fid   from T_ORG_Storage where fnumber='" + this.storageOrgUnitId + "'";
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            this.storageOrgUnitId = "";
            while (rs.next()) {
                this.storageOrgUnitId = rs.getString("fid");
            }
        } else {
            this.storageOrgUnitId = null;
        }
        if (param.getObject("PurchaseOrg") != null) {
            this.purchaseOrgId = (String)param.getObject("PurchaseOrg");
            sql = "select fid   from T_ORG_Purchase where fnumber ='" + this.purchaseOrgId + "'";
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            this.purchaseOrgId = "";
            while (rs.next()) {
                this.purchaseOrgId = rs.getString("fid");
            }
        } else {
            this.purchaseOrgId = null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (param.getObject("beginDate") != null) {
            date = (String)param.getObject("beginDate");
            this.beginDate = df.format(df.parse(date));
        } else {
            this.beginDate = null;
        }
        if (param.getObject("endDate") != null) {
            date = (String)param.getObject("endDate");
            this.endDate = df.format(df.parse(date));
        } else {
            this.endDate = null;
        }
        this.isQT = (String)param.getObject("IsQT");
    }
}

