/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.reqclose.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.reqclose.IndepentRequireCloseRecordCollection;
import com.kingdee.eas.industry.emm.project.biz.reqclose.IndepentRequireCloseRecordFactory;
import com.kingdee.eas.industry.emm.project.biz.reqclose.IndepentRequireCloseRecordInfo;
import com.kingdee.eas.industry.emm.project.biz.reqclose.IndepentRequireTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.reqclose.app.AbstractIndepentRequireCloseRecordControllerBean;
import com.kingdee.eas.industry.emm.project.biz.reqclose.issueBillTypeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndepentRequireCloseRecordControllerBean
extends AbstractIndepentRequireCloseRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.reqclose.app.IndepentRequireCloseRecordControllerBean");

    @Override
    protected void _unClose(Context ctx, List idList, boolean closeChild) throws BOSException, EASBizException {
        if (idList == null || "".equals(idList)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        IndepentRequireCloseRecordInfo info = null;
        String wheresql = " where id in (" + SQLUtil.arrayToString((Object[])idList.toArray()) + ")  ";
        if (closeChild) {
            wheresql = wheresql + " or parentCloseRecordID in (" + SQLUtil.arrayToString((Object[])idList.toArray()) + ")";
        }
        IndepentRequireCloseRecordCollection coll = IndepentRequireCloseRecordFactory.getLocalInstance(ctx).getIndepentRequireCloseRecordCollection(wheresql);
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!info.isIsAutoClose() && info.getSourcebillid() != null && info.getIndepentRequireBillType().equals((Object)IndepentRequireTypeEnum.REQ)) {
                throw new EASBizException(new NumericExceptionSubItem("\u53cd\u5173\u95ed\u5931\u8d25", "\u6240\u9009\u5355\u636e\u6765\u6e90\u4e8e\u9700\u6c42\u7533\u8bf7\u5173\u95ed\u5355\uff0c\u8bf7\u5230\u9700\u6c42\u7533\u8bf7\u5173\u95ed\u5355\u754c\u9762\u8fdb\u884c\u6570\u636e\u53cd\u5ba1\u6838\uff01"));
            }
            BigDecimal unCloseQty = info.getCloseQty();
            String fbillid = info.getIndepentRequireBillID();
            String fbillentryid = info.getIndepentRequireBillEntryID();
            if (info.getIndepentRequireBillType().equals((Object)IndepentRequireTypeEnum.YXP)) {
                sql.setLength(0);
                sql.append("  update Ct_Pm_Marketingfrpe d \r\n");
                sql.append("  set Fcloseqty = isnull(d.Fcloseqty,0) - ").append(unCloseQty).append(" \r\n");
                sql.append("  ,Fisclosed = 0 \r\n");
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update Ct_Pm_Marketingfrpe d \r\n");
                sql.append("  set Fcloseqty = 0 \r\n");
                sql.append("  , Fclosetime = null \r\n");
                sql.append("  ,Fcloserid = null \r\n");
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                sql.append(" and Fcloseqty <= 0 \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update Ct_Pm_Marketingfrpe d \r\n");
                sql.append("  set Fstatus = \r\n").append(4);
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                sql.append("  and Fstatus = \r\n").append(7);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update Ct_Pm_Marketingfrp h \r\n");
                sql.append("  set CFBaseStatus= ").append(4);
                sql.append("  where fid = '").append(fbillid).append("' \r\n");
                sql.append("  and CFBaseStatus= ").append(7);
                sql.append("  and  exists(Select 1 from Ct_Pm_Marketingfrpe d where d.fparentid = h.fid and d.Fstatus <> ").append(7).append(" ) \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (info.getIndepentRequireBillType().equals((Object)IndepentRequireTypeEnum.PUR)) {
                sql.setLength(0);
                sql.append("  update CT_PUR_BOMPurRequestEntry d \r\n");
                sql.append("  set Fcloseqty = isnull(d.Fcloseqty,0) - ").append(unCloseQty).append(" \r\n");
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update CT_PUR_BOMPurRequestEntry d \r\n");
                sql.append("  set Fcloseqty = 0 \r\n");
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                sql.append(" and Fcloseqty < 0 \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update CT_PUR_BOMPurRequestEntry d \r\n");
                sql.append("  set cfstatus = \r\n").append(4);
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                sql.append("  and cfstatus = \r\n").append(7);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update CT_PUR_BOMPurRequest h \r\n");
                sql.append("  set CFBaseStatus= ").append(4);
                sql.append("  where fid = '").append(fbillid).append("' \r\n");
                sql.append("  and CFBaseStatus= ").append(7);
                sql.append("  and  exists(Select 1 from CT_PUR_BOMPurRequestEntry d where d.fparentid = h.fid and d.cfstatus <> ").append(7).append(" ) \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (info.getIndepentRequireBillType().equals((Object)IndepentRequireTypeEnum.PCP)) {
                sql.setLength(0);
                sql.append("  update T_PCP_ProjectCP h \r\n");
                sql.append("  set Fcloseqty = isnull(h.Fcloseqty,0) - ").append(unCloseQty).append(" \r\n");
                sql.append("  where fid = '").append(fbillid).append("' \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update T_PCP_ProjectCP  \r\n");
                sql.append("  set Fcloseqty = 0 \r\n");
                sql.append("  where fid = '").append(fbillid).append("' \r\n");
                sql.append(" and Fcloseqty < 0 \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("  update T_PCP_ProjectCP  \r\n");
                sql.append("  set fstate = \r\n").append(4);
                sql.append("  where fid = '").append(fbillentryid).append("' \r\n");
                sql.append("  and fstate = \r\n").append(7);
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else if (info.getIndepentRequireBillType().equals((Object)IndepentRequireTypeEnum.REQ)) {
                // empty if block
            }
            IndepentRequireCloseRecordFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    @Override
    protected String _checkCloseData(Context ctx, List idList, String billtype) throws BOSException, EASBizException {
        if (idList == null || "".equals(idList)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer errorTextAll = new StringBuffer();
        StringBuffer errorText = new StringBuffer();
        IRowSet rs = null;
        try {
            if (billtype.equals("MarketingFittingRollingPlan")) {
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from CT_PM_MarketingFRP h \r\n");
                sql.append(" inner join  Ct_Pm_Marketingfrpe d on h.fid = d.fparentid \r\n");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and h.cfbasestatus <> 4 \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \u4ee5\u4e0b\u8425\u9500\u914d\u4ef6\u6eda\u52a8\u8ba1\u5212\u5355\u636e\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from CT_PM_MarketingFRP h \r\n");
                sql.append(" inner join  Ct_Pm_Marketingfrpe d on h.fid = d.fparentid \r\n");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and d.Fcloseqty >= d.Cfrequireqty \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \r\n \u4ee5\u4e0b\u8425\u9500\u914d\u4ef6\u6eda\u52a8\u8ba1\u5212\u5355\u636e\u5206\u5f55\u7684\u5df2\u5173\u95ed\u6570\u636e\u5927\u4e8e\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
            } else if (billtype.equals("ProjectPurRequre")) {
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from CT_PUR_BOMPurRequest h \r\n");
                sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and h.cfbasestatus <> 4 \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \u4ee5\u4e0b\u9879\u76ee\u91c7\u8d2d\u9700\u6c42/\u5f52\u6863\u90e8\u4ef6\u5355\u636e\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from CT_PUR_BOMPurRequest h \r\n");
                sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and d.Fcloseqty >= d.Cfqty \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \r\n \u4ee5\u4e0b\u9879\u76ee\u91c7\u8d2d\u9700\u6c42/\u5f52\u6863\u90e8\u4ef6\u5355\u636e\u5206\u5f55\u7684\u5df2\u5173\u95ed\u6570\u636e\u5927\u4e8e\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
            } else if (billtype.equals("PCP")) {
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from T_PCP_ProjectCP h \r\n");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and h.fstate <> 4 \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \u4ee5\u4e0b\u9879\u76ee\u534f\u540c\u8ba1\u5212\u5355\u636e\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber \r\n");
                sql.append(" from T_PCP_ProjectCP h \r\n");
                sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                sql.append(" and h.Fcloseqty >= h.fqty \r\n");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorText.setLength(0);
                while (rs.next()) {
                    errorText.append(rs.getString("fnumber") + "\r\n");
                }
                if (errorText.length() > 0) {
                    errorTextAll.append(" \r\n \u4ee5\u4e0b\u9879\u76ee\u534f\u540c\u8ba1\u5212\u5355\u636e\u7684\u5df2\u5173\u95ed\u6570\u636e\u5927\u4e8e\u7b49\u4e8e\u9700\u6c42\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5173\u95ed!\r\n").append(errorText);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return errorTextAll.toString();
    }

    protected void setCloseRecordInfoOtherData(Context ctx, IndepentRequireCloseRecordInfo info, String billtype, String billid, String billentryID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        IndepentRequireTypeEnum iRType = null;
        if (billtype.equals("MarketingFittingRollingPlan")) {
            sql.append(" Select h.fnumber as fbillnumber \r\n");
            sql.append(" ,d.cfmaterialid as fmaterialid \r\n");
            sql.append(" ,h.cfprojectid as fprojectid \r\n");
            sql.append(" ,d.Cftracknumberid as ftrackid \r\n");
            sql.append(" ,h.Fcontrolunitid as Fcontrolunitid \r\n");
            sql.append(" from  Ct_Pm_Marketingfrp h \r\n");
            sql.append(" inner join  Ct_Pm_Marketingfrpe d on h.fid = d.fparentid \r\n");
            sql.append(" where d.fid = '").append(billentryID).append("' \r\n");
            iRType = IndepentRequireTypeEnum.YXP;
        } else if (billtype.equals("PCP")) {
            sql.append(" Select h.fnumber as fbillnumber \r\n");
            sql.append(" ,h.fmaterialid as fmaterialid \r\n");
            sql.append(" ,h.fprojectid as fprojectid \r\n");
            sql.append(" ,h.ftracknumberid as ftrackid \r\n");
            sql.append(" ,h.Fcontrolunitid as Fcontrolunitid \r\n");
            sql.append(" from  t_pcp_projectcp h \r\n");
            sql.append(" where h.fid = '").append(billentryID).append("' \r\n");
            iRType = IndepentRequireTypeEnum.PCP;
        } else if (billtype.equals("ProjectPurRequre")) {
            sql.append(" Select h.fnumber as fbillnumber \r\n");
            sql.append(" ,h.Cfmaterialid as fmaterialid \r\n");
            sql.append(" ,h.Cfprojectnoid as fprojectid \r\n");
            sql.append(" ,d.Cftracknumberid as ftrackid \r\n");
            sql.append(" ,h.Fcontrolunitid as Fcontrolunitid \r\n");
            sql.append(" from  CT_PUR_BOMPurRequest h \r\n");
            sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
            sql.append(" where d.fid = '").append(billentryID).append("' \r\n");
            iRType = IndepentRequireTypeEnum.PUR;
        } else if (billtype.equals("PurRequireMent")) {
            sql.append(" Select h.fnumber as fbillnumber \r\n");
            sql.append(" ,d.fmaterialid as fmaterialid \r\n");
            sql.append(" ,d.FProjectID as fprojectid \r\n");
            sql.append(" ,d.FTrackNoID as ftrackid \r\n");
            sql.append(" ,h.Fcontrolunitid as Fcontrolunitid \r\n");
            sql.append(" from  T_SM_PurRequirement h \r\n");
            sql.append(" inner join  T_SM_PurRequirementEntry d on h.fid = d.fparentid \r\n");
            sql.append(" where d.fid = '").append(billentryID).append("' \r\n");
            iRType = IndepentRequireTypeEnum.REQ;
        } else {
            return;
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fmaterialid = rs.getString("fmaterialid");
                String fbillnumber = rs.getString("fbillnumber");
                String fprojectid = rs.getString("fprojectid");
                String ftrackid = rs.getString("ftrackid");
                String Fcontrolunitid = rs.getString("Fcontrolunitid");
                MaterialInfo materialInfo = new MaterialInfo();
                if (fmaterialid != null) {
                    materialInfo.setId(BOSUuid.read((String)fmaterialid));
                }
                ProjectInfo projectInfo = new ProjectInfo();
                if (fprojectid != null) {
                    projectInfo.setId(BOSUuid.read((String)fprojectid));
                }
                TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                if (ftrackid != null) {
                    trackNumberInfo.setId(BOSUuid.read((String)ftrackid));
                }
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                if (Fcontrolunitid != null) {
                    cuInfo.setId(BOSUuid.read((String)Fcontrolunitid));
                }
                info.setCU(cuInfo);
                info.setIndepentRequireBillNumber(fbillnumber);
                info.setMaterial(materialInfo);
                info.setProject(projectInfo);
                info.setTrackNumber(trackNumberInfo);
                info.setIndepentRequireBillType(iRType);
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _closebill(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null || dataMap.get("closeDataList") == null) {
            return;
        }
        String closeReason = null;
        if (dataMap.get("closeReason") != null) {
            closeReason = (String)dataMap.get("closeReason");
        }
        ArrayList dataList = (ArrayList)dataMap.get("closeDataList");
        CoreBaseCollection coll = new CoreBaseCollection();
        Date closeDate = new Date();
        IndepentRequireCloseRecordInfo info = null;
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer sql = new StringBuffer();
        ArrayList<String> pcpIDList = new ArrayList<String>();
        HashMap<String, IndepentRequireCloseRecordInfo> pcpIDMap = new HashMap<String, IndepentRequireCloseRecordInfo>();
        for (int i = 0; i < dataList.size(); ++i) {
            HashMap entryDataMap = (HashMap)dataList.get(i);
            BigDecimal fthiscloseQty = new BigDecimal(entryDataMap.get("fthiscloseQty").toString());
            String billtype = (String)entryDataMap.get("billtype");
            if (fthiscloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            String billid = entryDataMap.get("billid").toString();
            String billentryid = entryDataMap.get("billentryid").toString();
            boolean isauto = false;
            if (dataMap.get("isauto") != null && dataMap.get("isauto").toString().equals("true")) {
                isauto = true;
            }
            info = this.createCloseRecordInfo(ctx, fthiscloseQty, closeReason, billid, billentryid, isauto, billtype);
            if (entryDataMap.get("parentID") != null) {
                info.setParentCloseRecordID(entryDataMap.get("parentID").toString());
            }
            if (entryDataMap.get("parentNumber") != null) {
                info.setParentNumber(entryDataMap.get("parentNumber").toString());
            }
            if (entryDataMap.get("id") != null && !"".equals(entryDataMap.get("id").toString())) {
                info.setId(BOSUuid.read((String)entryDataMap.get("id").toString()));
            }
            if (entryDataMap.get("issuebillID") != null) {
                info.setIssuebillID(entryDataMap.get("issuebillID").toString());
            }
            if (entryDataMap.get("issuebillEntryID") != null) {
                info.setIssuebillEntryID(entryDataMap.get("issuebillEntryID").toString());
            }
            if (entryDataMap.get("issuebillNumber") != null) {
                info.setIssuebillNumber(entryDataMap.get("issuebillNumber").toString());
            }
            if (entryDataMap.get("issuebillType") != null) {
                info.setIssuebillType((issueBillTypeEnum)((Object)entryDataMap.get("issuebillType")));
            }
            if (billtype.equals("PCP") && isauto) {
                if (info.getId() == null) {
                    info.setId(BOSUuid.create((String)"A9571F42"));
                }
                pcpIDList.add(info.getIndepentRequireBillID());
                pcpIDMap.put(info.getIndepentRequireBillID(), info);
            }
            coll.add((CoreBaseInfo)info);
            this.updateIndepentRequireCloseStatus(ctx, billtype, fthiscloseQty, billentryid, billid);
        }
        if (pcpIDList != null && pcpIDList.size() > 0) {
            this.closePCPChild(ctx, pcpIDList, pcpIDMap);
        }
        IndepentRequireCloseRecordFactory.getLocalInstance(ctx).save(coll);
    }

    protected IndepentRequireCloseRecordInfo createCloseRecordInfo(Context ctx, BigDecimal closeQty, String closeReason, String indepentRequireBillID, String indepentRequireBillEntryID, boolean isauto, String indepentRequireBillType) throws BOSException, EASBizException {
        Date closeDate = new Date();
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        IndepentRequireCloseRecordInfo info = new IndepentRequireCloseRecordInfo();
        info.setClosedate(closeDate);
        info.setCloseQty(closeQty);
        info.setCloser(curUserInfo);
        info.setCloseReason(closeReason);
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setIndepentRequireBillEntryID(indepentRequireBillEntryID);
        info.setIndepentRequireBillID(indepentRequireBillID);
        info.setIsAutoClose(isauto);
        this.setCloseRecordInfoOtherData(ctx, info, indepentRequireBillType, indepentRequireBillID, indepentRequireBillEntryID);
        return info;
    }

    protected void closePCPChild(Context ctx, List pcpIDList, Map pcpIDMap) throws BOSException, EASBizException {
        IndepentRequireCloseRecordInfo info = null;
        IRowSet childRS = this._getChildPCP(ctx, pcpIDList);
        IRowSet PPRRS = this.getPPR(ctx, pcpIDList);
        CoreBaseCollection childColl = new CoreBaseCollection();
        IndepentRequireCloseRecordInfo childinfo = null;
        try {
            HashMap<String, BigDecimal> childPCPCloseQty = new HashMap<String, BigDecimal>();
            BigDecimal parentCloseQty = null;
            BigDecimal childNeedCloseQty = null;
            BigDecimal childThisCloseQty = null;
            BigDecimal childCloseedQty = null;
            BigDecimal childAllowCloseQty = null;
            String FtagID = null;
            BigDecimal fupdateOneQty = null;
            for (int i = 0; i < pcpIDList.size(); ++i) {
                String fparentPCPID = pcpIDList.get(i).toString();
                info = (IndepentRequireCloseRecordInfo)pcpIDMap.get(fparentPCPID);
                parentCloseQty = info.getCloseQty();
                FtagID = null;
                while (childRS.next()) {
                    if (!fparentPCPID.equals(childRS.getString("fparentbillid"))) continue;
                    if (FtagID == null || "".equals(FtagID)) {
                        FtagID = childRS.getString("FtagID");
                        fupdateOneQty = childRS.getBigDecimal("fupdateOneQty");
                        childNeedCloseQty = fupdateOneQty.multiply(parentCloseQty);
                    } else if (!FtagID.equals(childRS.getString("FtagID"))) {
                        FtagID = childRS.getString("FtagID");
                        fupdateOneQty = childRS.getBigDecimal("fupdateOneQty");
                        childNeedCloseQty = fupdateOneQty.multiply(parentCloseQty);
                    }
                    if (childNeedCloseQty != null && childNeedCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    String fchildPCPID = childRS.getString("Fchildbillid");
                    BigDecimal fbillqty = childRS.getBigDecimal("fbillqty");
                    BigDecimal fcloseQty = childRS.getBigDecimal("fcloseQty");
                    childCloseedQty = childPCPCloseQty != null && childPCPCloseQty.containsKey(fchildPCPID) ? new BigDecimal(childPCPCloseQty.get(fchildPCPID).toString()) : BigDecimal.ZERO;
                    childAllowCloseQty = fbillqty.subtract(fcloseQty).subtract(childCloseedQty);
                    if (childAllowCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (childNeedCloseQty.compareTo(childAllowCloseQty) >= 0) {
                        childThisCloseQty = childAllowCloseQty;
                        childNeedCloseQty = childNeedCloseQty.subtract(childAllowCloseQty);
                    } else {
                        childThisCloseQty = childNeedCloseQty;
                        childNeedCloseQty = BigDecimal.ZERO;
                    }
                    if (childThisCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    childPCPCloseQty.put(fchildPCPID, childThisCloseQty.add(childCloseedQty));
                    childinfo = this.createCloseRecordInfo(ctx, childThisCloseQty, "\u51fa\u5e93\u5355\u5ba1\u6838\u81ea\u52a8\u5173\u95ed\u534f\u540c\u8ba1\u5212\u540e\uff0c\u5bf9\u534f\u540c\u8ba1\u5212\u5b50\u9879\u8fdb\u884c\u81ea\u52a8\u5173\u95ed", fchildPCPID, fchildPCPID, true, "PCP");
                    childinfo.setParentCloseRecordID(info.getId().toString());
                    childinfo.setParentNumber(info.getIndepentRequireBillNumber());
                    childinfo.setId(null);
                    childinfo.setIssuebillID(info.getIssuebillID());
                    childinfo.setIssuebillEntryID(info.getIssuebillEntryID());
                    childinfo.setIssuebillNumber(info.getIssuebillNumber());
                    childinfo.setIssuebillType(info.getIssuebillType());
                    childColl.add((CoreBaseInfo)childinfo);
                    this.updateIndepentRequireCloseStatus(ctx, "PCP", childThisCloseQty, fchildPCPID, fchildPCPID);
                }
                childRS.beforeFirst();
                FtagID = null;
                while (PPRRS.next()) {
                    if (!fparentPCPID.equals(PPRRS.getString("fparentbillid"))) continue;
                    if (FtagID == null || "".equals(FtagID)) {
                        FtagID = PPRRS.getString("FtagID");
                        childNeedCloseQty = parentCloseQty;
                    } else if (!FtagID.equals(PPRRS.getString("FtagID"))) {
                        FtagID = PPRRS.getString("FtagID");
                        childNeedCloseQty = parentCloseQty;
                    }
                    if (childNeedCloseQty != null && childNeedCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    String fpprID = PPRRS.getString("fbillid");
                    String fpprEntryID = PPRRS.getString("fbillentryid");
                    BigDecimal fbillqty = PPRRS.getBigDecimal("fbillqty");
                    BigDecimal fcloseQty = PPRRS.getBigDecimal("fcloseQty");
                    childCloseedQty = childPCPCloseQty != null && childPCPCloseQty.containsKey(fpprEntryID) ? new BigDecimal(childPCPCloseQty.get(fpprEntryID).toString()) : BigDecimal.ZERO;
                    childAllowCloseQty = fbillqty.subtract(fcloseQty).subtract(childCloseedQty);
                    if (childAllowCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (childNeedCloseQty.compareTo(childAllowCloseQty) >= 0) {
                        childThisCloseQty = childAllowCloseQty;
                        childNeedCloseQty = childNeedCloseQty.subtract(childAllowCloseQty);
                    } else {
                        childThisCloseQty = childNeedCloseQty;
                        childNeedCloseQty = BigDecimal.ZERO;
                    }
                    if (childThisCloseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    childPCPCloseQty.put(fpprEntryID, childThisCloseQty.add(childCloseedQty));
                    childinfo = this.createCloseRecordInfo(ctx, childThisCloseQty, "\u51fa\u5e93\u5355\u5ba1\u6838\u81ea\u52a8\u5173\u95ed\u534f\u540c\u8ba1\u5212\u540e\uff0c\u5bf9\u9879\u76ee\u91c7\u8d2d\u9700\u6c42/\u5f52\u6863\u90e8\u4ef6\u8fdb\u884c\u81ea\u52a8\u5173\u95ed", fpprID, fpprEntryID, true, "ProjectPurRequre");
                    childinfo.setParentCloseRecordID(info.getId().toString());
                    childinfo.setParentNumber(info.getIndepentRequireBillNumber());
                    childinfo.setId(null);
                    childinfo.setIssuebillID(info.getIssuebillID());
                    childinfo.setIssuebillEntryID(info.getIssuebillEntryID());
                    childinfo.setIssuebillNumber(info.getIssuebillNumber());
                    childinfo.setIssuebillType(info.getIssuebillType());
                    childColl.add((CoreBaseInfo)childinfo);
                    this.updateIndepentRequireCloseStatus(ctx, "ProjectPurRequre", childThisCloseQty, fpprEntryID, fpprID);
                }
                PPRRS.beforeFirst();
            }
            if (childColl != null && childColl.size() > 0) {
                IndepentRequireCloseRecordFactory.getLocalInstance(ctx).addnew(childColl);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateIndepentRequireCloseStatus(Context ctx, String billtype, BigDecimal fthiscloseQty, String billentryid, String billid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (billtype.equals("MarketingFittingRollingPlan")) {
            sql.append("  update Ct_Pm_Marketingfrpe d \r\n");
            sql.append("  set Fclosetime = sysdate \r\n");
            sql.append("  ,Fcloserid = '").append(curUserInfo.getId()).append("' \r\n");
            sql.append("  ,Fcloseqty = isnull(d.Fcloseqty,0) + ").append(fthiscloseQty).append(" \r\n");
            sql.append("  where fid = '").append(billentryid).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  update Ct_Pm_Marketingfrpe d \r\n");
            sql.append("  set Fstatus = \r\n").append(7);
            sql.append("  ,Fisclosed = 1 \r\n");
            sql.append("  where fid = '").append(billentryid).append("' \r\n");
            sql.append("  and Fcloseqty >= Cfrequireqty \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  update Ct_Pm_Marketingfrp h \r\n");
            sql.append("  set CFBaseStatus= ").append(7);
            sql.append("  where fid = '").append(billid).append("' \r\n");
            sql.append("  and CFBaseStatus= ").append(4);
            sql.append("  and not exists(Select 1 from Ct_Pm_Marketingfrpe d where d.fparentid = h.fid and d.Fstatus <> ").append(7).append(" ) \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (billtype.equals("ProjectPurRequre")) {
            sql.append("  update CT_PUR_BOMPurRequestEntry d \r\n");
            sql.append("  set Fcloseqty = isnull(d.Fcloseqty,0) + ").append(fthiscloseQty).append(" \r\n");
            sql.append("  where fid = '").append(billentryid).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  update CT_PUR_BOMPurRequestEntry d \r\n");
            sql.append("  set cFstatus = \r\n").append(7);
            sql.append("  where fid = '").append(billentryid).append("' \r\n");
            sql.append("  and Fcloseqty >= cfqty \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  update CT_PUR_BOMPurRequest h \r\n");
            sql.append("  set CFBaseStatus= ").append(7);
            sql.append("  where fid = '").append(billid).append("' \r\n");
            sql.append("  and CFBaseStatus= ").append(4);
            sql.append("  and not exists(Select 1 from CT_PUR_BOMPurRequestEntry d where d.fparentid = h.fid and d.cFstatus <> ").append(7).append(" ) \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (billtype.equals("PCP")) {
            sql.append("  update T_PCP_ProjectCP h \r\n");
            sql.append("  set Fcloseqty = isnull(h.Fcloseqty,0) + ").append(fthiscloseQty).append(" \r\n");
            sql.append("  where fid = '").append(billid).append("' \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("  update T_PCP_ProjectCP d \r\n");
            sql.append("  set fstate = \r\n").append(7);
            sql.append("  where fid = '").append(billid).append("' \r\n");
            sql.append("  and Fcloseqty >= fqty \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected Map _getCloseData(Context ctx, List idList, String billtype) throws BOSException, EASBizException {
        HashMap<String, IRowSet> returnMap = new HashMap<String, IRowSet>();
        if (idList == null || "".equals(idList)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        if (billtype.equals("MarketingFittingRollingPlan")) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,h.fnumber as fbillnumber \r\n");
            sql.append(" ,d.fid as fbillentryid \r\n");
            sql.append(" ,m.fid as fmaterialid \r\n");
            sql.append(" ,m.fnumber as fmaterialnumber \r\n");
            sql.append(" ,m.fname_l2 as fmaterialname \r\n");
            sql.append(" ,m.fmodel as fmaterialmodel \r\n");
            sql.append(" ,p.fnumber as fprojectnumber \r\n");
            sql.append(" ,p.fname_l2 as fprojectname \r\n");
            sql.append(" ,t.fnumber as ftracknumber \r\n");
            sql.append(" ,t.fname_l2 as ftrackname \r\n");
            sql.append(" ,mu.fname_l2 as funitname \r\n");
            sql.append(" ,d.Cfrequireqty as fbillqty \r\n");
            sql.append(" ,mu.FQTYPRECISION as FQTYPRECISION \r\n");
            sql.append(" ,isnull((Select sum(fcloseqty)  \r\n");
            sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
            sql.append(" where ir.findepentrequirebillentryid = d.fid \r\n");
            sql.append(" and ir.findepentrequirebilltype = ").append(2).append("),0) As fcloseQty \r\n");
            sql.append(" from  Ct_Pm_Marketingfrp h \r\n");
            sql.append(" inner join  Ct_Pm_Marketingfrpe d on h.fid = d.fparentid \r\n");
            sql.append(" left outer join  t_bd_material m on m.fid = d.Cfmaterialid \r\n");
            sql.append(" left outer  join  t_mm_project p on p.fid = h.cfprojectid \r\n");
            sql.append(" left outer  join  t_mm_tracknumber t on t.fid = d.Cftracknumberid \r\n");
            sql.append(" left outer  join  t_bd_measureunit mu on mu.fid = m.fbaseunit \r\n");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else if (billtype.equals("ProjectPurRequre")) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,h.fnumber as fbillnumber \r\n");
            sql.append(" ,d.fid as fbillentryid \r\n");
            sql.append(" ,m.fid as fmaterialid \r\n");
            sql.append(" ,m.fnumber as fmaterialnumber \r\n");
            sql.append(" ,m.fname_l2 as fmaterialname \r\n");
            sql.append(" ,m.fmodel as fmaterialmodel \r\n");
            sql.append(" ,p.fnumber as fprojectnumber \r\n");
            sql.append(" ,p.fname_l2 as fprojectname \r\n");
            sql.append(" ,t.fnumber as ftracknumber \r\n");
            sql.append(" ,t.fname_l2 as ftrackname \r\n");
            sql.append(" ,mu.fname_l2 as funitname \r\n");
            sql.append(" ,d.cfqty as fbillqty \r\n");
            sql.append(" ,isnull((Select sum(fcloseqty)  \r\n");
            sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
            sql.append(" where ir.findepentrequirebillentryid = d.fid \r\n");
            sql.append(" and ir.findepentrequirebilltype = ").append(3).append("),0) As fcloseQty \r\n");
            sql.append(" from  CT_PUR_BOMPurRequest h \r\n");
            sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
            sql.append(" left outer join  t_bd_material m on m.fid = h.Cfmaterialid \r\n");
            sql.append(" left outer  join  t_mm_project p on p.fid = h.Cfprojectnoid \r\n");
            sql.append(" left outer  join  t_mm_tracknumber t on t.fid = d.Cftracknumberid \r\n");
            sql.append(" left outer  join  t_bd_measureunit mu on mu.fid = m.fbaseunit \r\n");
            sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else if (billtype.equals("PCP")) {
            sql.append(" Select h.fid as fbillid \r\n");
            sql.append(" ,h.fnumber as fbillnumber \r\n");
            sql.append(" ,h.fid as fbillentryid \r\n");
            sql.append(" ,m.fid as fmaterialid \r\n");
            sql.append(" ,m.fnumber as fmaterialnumber \r\n");
            sql.append(" ,m.fname_l2 as fmaterialname \r\n");
            sql.append(" ,m.fmodel as fmaterialmodel \r\n");
            sql.append(" ,p.fnumber as fprojectnumber \r\n");
            sql.append(" ,p.fname_l2 as fprojectname \r\n");
            sql.append(" ,t.fnumber as ftracknumber \r\n");
            sql.append(" ,t.fname_l2 as ftrackname \r\n");
            sql.append(" ,mu.fname_l2 as funitname \r\n");
            sql.append(" ,h.fqty as fbillqty \r\n");
            sql.append(" ,isnull((Select sum(fcloseqty)  \r\n");
            sql.append(" from T_RC_IRequireCloseRecord ir  \r\n");
            sql.append(" where ir.findepentrequirebillentryid = h.fid \r\n");
            sql.append(" and ir.findepentrequirebilltype = ").append(1).append("),0) As fcloseQty \r\n");
            sql.append(" ,ppm.fnumber as fppmnumber \r\n");
            sql.append(" ,newbosid('A9571F42') as fcloseRecordID \r\n");
            sql.append(" from  T_PCP_ProjectCP h \r\n");
            sql.append(" left outer join  t_bd_material m on m.fid = h.fmaterialid \r\n");
            sql.append(" left outer  join  t_mm_project p on p.fid = h.fprojectid \r\n");
            sql.append(" left outer  join  t_mm_tracknumber t on t.fid = h.ftracknumberid \r\n");
            sql.append(" left outer  join  t_bd_measureunit mu on mu.fid = m.fbaseunit \r\n");
            sql.append(" left outer  join  T_PCP_ProjectPlanModel ppm on ppm.fid = h.Fprojectplanmodelid \r\n");
            sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            IRowSet childRS = this._getChildPCP(ctx, idList);
            returnMap.put("returnChildDateRS", childRS);
            IRowSet PPRRS = this.getPPR(ctx, idList);
            returnMap.put("returnPPRRS", PPRRS);
        }
        returnMap.put("returnDateRS", rs);
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet _getChildPCP(Context ctx, List idList) throws BOSException, EASBizException {
        String ftableName = this.expandBOM(ctx, idList);
        if (ftableName != null) {
            ArrayList<String> tempTableList = new ArrayList<String>();
            tempTableList.add(ftableName);
            try {
                IRowSet rs;
                StringBuffer sql = new StringBuffer();
                sql.append(" Select a.FBILLID As fparentbillid ");
                sql.append(" ,a.FID As FtagID ");
                sql.append(" ,a.FQty As fupdateOneQty ");
                sql.append(" ,b.fid As Fchildbillid ");
                sql.append(" ,a.flevel As flevel ");
                sql.append(" ,b.fnumber as fbillnumber \r\n");
                sql.append(" ,m.fid as fmaterialid \r\n");
                sql.append(" ,m.fnumber as fmaterialnumber \r\n");
                sql.append(" ,m.fname_l2 as fmaterialname \r\n");
                sql.append(" ,m.fmodel as fmaterialmodel \r\n");
                sql.append(" ,p.fnumber as fprojectnumber \r\n");
                sql.append(" ,p.fname_l2 as fprojectname \r\n");
                sql.append(" ,t.fnumber as ftracknumber \r\n");
                sql.append(" ,t.fname_l2 as ftrackname \r\n");
                sql.append(" ,mu.fname_l2 as funitname \r\n");
                sql.append(" ,b.fqty as fbillqty \r\n");
                sql.append(" ,isnull(b.fcloseqty,0) as fcloseQty \r\n");
                sql.append(" ,ppm.fnumber as fppmnumber \r\n");
                sql.append(" From ").append(ftableName).append(" a ");
                sql.append(" inner join T_PCP_ProjectCP b on b.fmaterialid = a.FMaterialID and b.fprojectid = a.fprojectid and Isnull(b.fprojectplanmodelid,'*') = Isnull(a.fprojectplanmodelid,'*') and b.ftracknumberid = a.FtrackNumberID ");
                sql.append(" left outer join  t_bd_material m on m.fid = b.fmaterialid \r\n");
                sql.append(" left outer  join  t_mm_project p on p.fid = b.fprojectid \r\n");
                sql.append(" left outer  join  t_mm_tracknumber t on t.fid = b.ftracknumberid \r\n");
                sql.append(" left outer  join  t_bd_measureunit mu on mu.fid = m.fbaseunit \r\n");
                sql.append(" left outer  join  T_PCP_ProjectPlanModel ppm on ppm.fid = b.Fprojectplanmodelid \r\n");
                sql.append(" where a.FsupplyOrgid = (Select Min(b1. Fstorageorgunitid) from T_PCP_ProjectCPSE b1 where b1.fparentid = b.fid and b1.fseq = (Select min(fseq) from T_PCP_ProjectCPSE b2 where b2.fparentid = b1.fparentid )    )  ");
                sql.append(" and b.fstate = 4 ");
                sql.append(" and b.fqty > Isnull(b.FcloseQty,0) ");
                sql.append(" order by a.FBILLID,a.flevel,a.FID, b.Ffinishtime ");
                IRowSet iRowSet = rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                return iRowSet;
            }
            finally {
                this.releaseTempTable(ctx, tempTableList);
            }
        }
        return null;
    }

    protected String expandBOM(Context ctx, List idList) throws BOSException {
        String ftableName = null;
        try {
            ftableName = this.createExpandBOMTempTable(ctx);
            int lL_level = 0;
            StringBuffer sql = new StringBuffer();
            while (lL_level < 50) {
                int effectedRows;
                if (lL_level == 49) {
                    if (ftableName != null) {
                        ArrayList<String> tempTableList = new ArrayList<String>();
                        tempTableList.add(ftableName);
                        this.releaseTempTable(ctx, tempTableList);
                        ftableName = null;
                    }
                    throw new BOSException("BOM\u5b58\u5728\u6b7b\u5faa\u73af\uff01");
                }
                sql.setLength(0);
                if (++lL_level == 1) {
                    sql.append(this.getInsertExpandBOMTempTableSQL(ftableName));
                    sql.append(" Select \r\n");
                    sql.append(" a.fid as FBILLID,\r\n");
                    sql.append(" newbosid('12345678') as FID,\r\n");
                    sql.append(" ").append(lL_level).append(" as flevel,\r\n");
                    sql.append(" h.fstorageorgunitid As FStorageOrgUnitID ,\r\n");
                    sql.append(" d.fsupplystorageorgunitid As FsupplyOrgid ,\r\n");
                    sql.append(" d.fmaterialid as FMaterialID ,\r\n");
                    sql.append(" Sum(d.fconsumefixqty) as FQty ,\r\n");
                    sql.append(" t.fnumber as FTrackNumber , \r\n");
                    sql.append(" h.fprojectid as FprojectID ,\r\n");
                    sql.append(" t.fid As FtrackNumberID ,\r\n");
                    sql.append(" h.fmaterialid As FParentMaterialID, \r\n");
                    sql.append(" a.fprojectplanmodelid As fprojectplanmodelid \r\n");
                    sql.append(" From T_PCP_ProjectCP a \r\n");
                    sql.append(" inner join t_mm_trackNumber t on t.fid = a.ftracknumberid \r\n");
                    sql.append(" inner join t_mm_bom h on h.fmaterialid = a.fmaterialid and h.fprojectid = a.fprojectid and h.fbasestatus = 4 and h.fbomtype = 80 \r\n");
                    sql.append(" inner Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
                    sql.append(" inner Join t_mm_trackNumber bt on d.fbegincarnoid = bt.fid \r\n");
                    sql.append(" inner Join t_mm_trackNumber et on d.fendcarnoid = et.fid \r\n");
                    sql.append(" WHERE a.fid in (").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
                    sql.append(" AND h.fstorageOrgUnitid =  (Select Min(b1. Fstorageorgunitid) from T_PCP_ProjectCPSE b1 where b1.fparentid = a.fid and b1.fseq = (Select min(fseq) from T_PCP_ProjectCPSE b2 where b2.fparentid = b1.fparentid )    )  \r\n");
                    sql.append(" AND d.fconsumefixqty > 0\r\n");
                    sql.append(" AND  t.fnumber >= bt.fnumber and t.fnumber <= et.fnumber \r\n");
                    sql.append(" Group by \r\n");
                    sql.append(" a.fid ,\r\n");
                    sql.append(" h.fstorageorgunitid ,\r\n");
                    sql.append(" d.fsupplystorageorgunitid ,\r\n");
                    sql.append(" d.fmaterialid ,\r\n");
                    sql.append(" t.fnumber  , \r\n");
                    sql.append(" h.fprojectid  ,\r\n");
                    sql.append(" t.fid ,\r\n");
                    sql.append(" h.fmaterialid , \r\n");
                    sql.append(" a.fprojectplanmodelid  \r\n");
                } else {
                    sql.append(this.getInsertExpandBOMTempTableSQL(ftableName));
                    sql.append(" Select \r\n");
                    sql.append(" a.FBILLID as FBILLID,\r\n");
                    sql.append(" newbosid('12345678') as FID,\r\n");
                    sql.append(" ").append(lL_level).append(" as flevel,\r\n");
                    sql.append(" h.fstorageorgunitid As FStorageOrgUnitID ,\r\n");
                    sql.append(" d.fsupplystorageorgunitid As FsupplyOrgid ,\r\n");
                    sql.append(" d.fmaterialid as FMaterialID ,\r\n");
                    sql.append(" Round(Sum(d.fconsumefixqty) * a.Fqty,4) as FQty ,\r\n");
                    sql.append(" a.FTrackNumber as FTrackNumber , \r\n");
                    sql.append(" h.fprojectid as FprojectID ,\r\n");
                    sql.append(" a.FtrackNumberID As FtrackNumberID ,\r\n");
                    sql.append(" h.fmaterialid As FParentMaterialID, \r\n");
                    sql.append(" a.fprojectplanmodelid As fprojectplanmodelid \r\n");
                    sql.append(" From " + ftableName + " a \r\n");
                    sql.append(" inner join t_mm_bom h on h.fmaterialid = a.FMaterialID and h.fprojectid = a.FprojectID and h.fstorageOrgUnitid = a.FsupplyOrgid and h.fbasestatus = 4 and h.fbomtype = 80 \r\n");
                    sql.append(" inner Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
                    sql.append(" inner Join t_mm_trackNumber bt on d.fbegincarnoid = bt.fid \r\n");
                    sql.append(" inner Join t_mm_trackNumber et on d.fendcarnoid = et.fid \r\n");
                    sql.append(" WHERE a.flevel = " + (lL_level - 1) + " \r\n");
                    sql.append(" AND d.fconsumefixqty > 0\r\n");
                    sql.append(" AND  a.FTrackNumber >= bt.fnumber and a.FTrackNumber <= et.fnumber \r\n");
                    sql.append(" Group by \r\n");
                    sql.append(" a.FBILLID ,\r\n");
                    sql.append(" h.fstorageorgunitid ,\r\n");
                    sql.append(" d.fsupplystorageorgunitid ,\r\n");
                    sql.append(" d.fmaterialid ,\r\n");
                    sql.append(" a.FTrackNumber  , \r\n");
                    sql.append(" a.Fqty  , \r\n");
                    sql.append(" h.fprojectid  ,\r\n");
                    sql.append(" a.FtrackNumberID ,\r\n");
                    sql.append(" h.fmaterialid , \r\n");
                    sql.append(" a.fprojectplanmodelid  \r\n");
                }
                if ((effectedRows = this.executeSQL(ctx, sql.toString())) >= 1) continue;
                break;
            }
        }
        catch (Exception e) {
            if (ftableName != null) {
                ArrayList<String> tempTableList = new ArrayList<String>();
                tempTableList.add(ftableName);
                this.releaseTempTable(ctx, tempTableList);
                ftableName = null;
            }
            throw new BOSException((Throwable)e);
        }
        return ftableName;
    }

    protected String createExpandBOMTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandBOMTempTable(\r\n");
        sql.append("FBILLID  VARCHAR(44), \r\n");
        sql.append("FID  VARCHAR(44), \r\n");
        sql.append("FLevel Int,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FsupplyOrgid VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,10),\r\n");
        sql.append("FTrackNumber NVARCHAR(100),\r\n");
        sql.append("FprojectID VARCHAR(44),\r\n");
        sql.append("FtrackNumberID VARCHAR(44),\r\n");
        sql.append("FParentMaterialID VARCHAR(44),\r\n");
        sql.append("fprojectplanmodelid VARCHAR(44)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMaterialID,FsupplyOrgid,FprojectID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FLevel", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FBILLID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String getInsertExpandBOMTempTableSQL(String expandPPBTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(expandPPBTempTableName).append("(\r\n");
        sql.append("FBILLID, \r\n");
        sql.append("FID, \r\n");
        sql.append("FLevel,\r\n");
        sql.append("FStorageOrgUnitID ,\r\n");
        sql.append("FsupplyOrgid ,\r\n");
        sql.append("FMaterialID ,\r\n");
        sql.append("FQty ,\r\n");
        sql.append("FTrackNumber ,\r\n");
        sql.append("FprojectID ,\r\n");
        sql.append("FtrackNumberID ,\r\n");
        sql.append("FParentMaterialID ,\r\n");
        sql.append("fprojectplanmodelid \r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected void releaseTempTable(Context ctx, List tempTableList) {
        if (ctx == null || tempTableList == null) {
            return;
        }
        if (tempTableList.size() == 0) {
            return;
        }
        for (int index = 0; index < tempTableList.size(); ++index) {
            String tempTable;
            String string = tempTable = tempTableList.get(index) == null ? null : tempTableList.get(index).toString();
            if (tempTable == null) {
                return;
            }
            if (tempTable.trim().length() == 0) {
                return;
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected IRowSet getPPR(Context ctx, List idList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select a.fid As fparentbillid ");
        sql.append(" ,a.fid As FtagID ");
        sql.append(" ,h.fid as fbillid \r\n");
        sql.append(" ,h.fnumber as fbillnumber \r\n");
        sql.append(" ,d.fid as fbillentryid \r\n");
        sql.append(" ,m.fid as fmaterialid \r\n");
        sql.append(" ,m.fnumber as fmaterialnumber \r\n");
        sql.append(" ,m.fname_l2 as fmaterialname \r\n");
        sql.append(" ,m.fmodel as fmaterialmodel \r\n");
        sql.append(" ,p.fnumber as fprojectnumber \r\n");
        sql.append(" ,p.fname_l2 as fprojectname \r\n");
        sql.append(" ,t.fnumber as ftracknumber \r\n");
        sql.append(" ,t.fname_l2 as ftrackname \r\n");
        sql.append(" ,mu.fname_l2 as funitname \r\n");
        sql.append(" ,d.cfqty as fbillqty \r\n");
        sql.append(" ,isnull(d.fcloseqty,0) As fcloseQty \r\n");
        sql.append(" from  CT_PUR_BOMPurRequest h \r\n");
        sql.append(" inner join  CT_PUR_BOMPurRequestEntry d on h.fid = d.fparentid \r\n");
        sql.append(" inner join  T_PCP_ProjectCP a on a.fmaterialid =h.Cfmaterialid and a.fprojectid = h.Cfprojectnoid and a.ftracknumberid = d.Cftracknumberid \r\n");
        sql.append(" left outer join  t_bd_material m on m.fid = h.Cfmaterialid \r\n");
        sql.append(" left outer  join  t_mm_project p on p.fid = h.Cfprojectnoid \r\n");
        sql.append(" left outer  join  t_mm_tracknumber t on t.fid = d.Cftracknumberid \r\n");
        sql.append(" left outer  join  t_bd_measureunit mu on mu.fid = m.fbaseunit \r\n");
        sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])idList.toArray())).append(") \r\n");
        sql.append(" and h.Cfbasestatus = 4 and d.cfqty > isnull(d.fcloseqty,0)  \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }
}

