/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.schedule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.industry.emm.mm.basedata.OperationScheduleUtils;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleEntryFactory;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleInfo;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleProductLineEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleProjectEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleProjectEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.schedule.app.AbstractPlannedOrderScheduleControllerBean;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlannedOrderScheduleControllerBean
extends AbstractPlannedOrderScheduleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.project.biz.schedule.app.PlannedOrderScheduleControllerBean");
    public static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public Map<String, String> fcOrgMap = null;
    public Map<String, List<String>> materialParentMap = null;

    @Override
    protected PlannedOrderScheduleInfo _schedule(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        this.checkData(ctx, info);
        if (this.isExistsReleaseData(ctx, info)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0000"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        boolean delolddate = false;
        if (info.get("delolddate") != null) {
            delolddate = (Boolean)info.get("delolddate");
        }
        info.getEntrys().clear();
        PlannedOrderScheduleEntryCollection entryColl = new PlannedOrderScheduleEntryCollection();
        PlannedOrderScheduleEntryInfo entryInfo = null;
        this.materialParentMap = new HashMap<String, List<String>>();
        if (delolddate) {
            this.deleteScheduleDate(ctx, info);
        }
        Map abilityMap = this.getEquipmentResourceDayQty(ctx, info);
        PMRPPlannedOrderCollection pdColl = this.getPlannedOrderCollection(ctx, info);
        java.util.Date beginDate = info.getBeginDate();
        java.util.Date endDate = info.getEndDate();
        java.util.Date thisDate = null;
        int diffDay = this.getDateSpace(beginDate, endDate);
        ++diffDay;
        String flastMaterialId = null;
        BigDecimal fSYbatchQty = new BigDecimal(0);
        for (int i = 0; i < pdColl.size(); ++i) {
            BigDecimal fsyqty;
            PMRPPlannedOrderInfo pdInfo = pdColl.get(i);
            if (pdInfo.getQty() == null || pdInfo.getQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal fpdqty = pdInfo.getQty();
            BigDecimal batchQty = new BigDecimal(0);
            if (pdInfo.get("batchQty") != null && ((batchQty = new BigDecimal(pdInfo.get("batchQty").toString())) == null || batchQty.compareTo(BigDecimal.ZERO) <= 0)) {
                batchQty = new BigDecimal(0);
            }
            MaterialInfo materialInfo = pdInfo.getMaterial();
            BigDecimal fqty = new BigDecimal(0);
            if (flastMaterialId == null || "".equals(flastMaterialId) || materialInfo != null && !flastMaterialId.equals(materialInfo.getId().toString()) || fSYbatchQty.compareTo(BigDecimal.ZERO) <= 0) {
                flastMaterialId = materialInfo.getId().toString();
                if (batchQty.compareTo(BigDecimal.ZERO) > 0) {
                    if (fpdqty.compareTo(batchQty) > 0) {
                        fSYbatchQty = BigDecimal.ZERO;
                        fqty = batchQty;
                        PMRPPlannedOrderInfo copypdInfo = (PMRPPlannedOrderInfo)pdInfo.clone();
                        copypdInfo.setQty(fpdqty.subtract(batchQty));
                        copypdInfo.setId(BOSUuid.create((BOSObjectType)copypdInfo.getBOSType()));
                        pdColl.add(copypdInfo);
                    } else {
                        fqty = fpdqty;
                        fSYbatchQty = batchQty.subtract(fpdqty);
                    }
                } else {
                    fqty = fpdqty;
                    fSYbatchQty = BigDecimal.ZERO;
                }
            } else if (fSYbatchQty.compareTo(BigDecimal.ZERO) > 0) {
                if (fpdqty.compareTo(fSYbatchQty) > 0) {
                    fSYbatchQty = BigDecimal.ZERO;
                    PMRPPlannedOrderInfo copypdInfo = (PMRPPlannedOrderInfo)pdInfo.clone();
                    copypdInfo.setQty(fpdqty.subtract(fSYbatchQty));
                    copypdInfo.setId(BOSUuid.create((BOSObjectType)copypdInfo.getBOSType()));
                    pdColl.add(copypdInfo);
                    fqty = fSYbatchQty;
                } else {
                    fqty = fpdqty;
                    fSYbatchQty = fSYbatchQty.subtract(fpdqty);
                }
            }
            if (pdInfo.get("realID") != null) {
                boolean isfind = false;
                for (int j = 0; j < entryColl.size(); ++j) {
                    if (entryColl.get(j).getPlannedOrderID() == null || !entryColl.get(j).getPlannedOrderID().equals(pdInfo.get("realID").toString()) || entryColl.get(j).getNewDate() != null || entryColl.get(j).getProductLine() != null) continue;
                    entryColl.get(j).setNewQty(entryColl.get(j).getNewQty().add(fqty));
                    isfind = true;
                    break;
                }
                if (isfind) continue;
            }
            PlannedOrderScheduleProductLineEntryCollection productLineColl = this.getPlannedOrderScheduleProductLineEntryCollection(ctx, info, materialInfo);
            if (fqty.compareTo(BigDecimal.ZERO) <= 0 || (fsyqty = this.scheduledatas(ctx, productLineColl, fqty, thisDate, diffDay, beginDate, abilityMap, pdInfo, entryInfo, entryColl, info)).compareTo(BigDecimal.ZERO) <= 0) continue;
            entryInfo = this.createPlannedOrderScheduleEntryInfo(ctx, pdInfo, null, fsyqty, null, false);
            entryColl.add(entryInfo);
            pdInfo.setQty(BigDecimal.ZERO);
        }
        this.setMergeData(ctx, entryColl);
        this.setScheculeEntryException(ctx, entryColl);
        info.getEntrys().addCollection(entryColl);
        return info;
    }

    protected BigDecimal scheduledatas(Context ctx, PlannedOrderScheduleProductLineEntryCollection productLineColl, BigDecimal fqty, java.util.Date thisDate, int diffDay, java.util.Date beginDate, Map abilityMap, PMRPPlannedOrderInfo pdInfo, PlannedOrderScheduleEntryInfo entryInfo, PlannedOrderScheduleEntryCollection entryColl, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        String fkey = null;
        BigDecimal fabilityQty = null;
        BigDecimal fnewqty = null;
        block0: for (int k = 0; k < productLineColl.size(); ++k) {
            ProductLineInfo productLineInfo = productLineColl.get(k).getProductLine();
            if (fqty.compareTo(BigDecimal.ZERO) <= 0) break;
            for (int j = 0; j < diffDay; ++j) {
                thisDate = DateUtil.addDay((java.util.Date)beginDate, (int)j);
                if (fqty.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                fkey = productLineInfo.getId().toString() + sdfDate.format(thisDate);
                if (abilityMap == null || !abilityMap.containsKey(fkey) || (fabilityQty = new BigDecimal(abilityMap.get(fkey).toString())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (fabilityQty.compareTo(fqty) >= 0) {
                    fnewqty = fqty;
                    fabilityQty = fabilityQty.subtract(fqty);
                    fqty = BigDecimal.ZERO;
                } else {
                    fnewqty = fabilityQty;
                    fqty = fqty.subtract(fabilityQty);
                    fabilityQty = BigDecimal.ZERO;
                }
                abilityMap.put(fkey, fabilityQty);
                entryInfo = this.createPlannedOrderScheduleEntryInfo(ctx, pdInfo, thisDate, fnewqty, productLineInfo, true);
                entryColl.add(entryInfo);
                this.expandChildMaterialSchedule(ctx, entryInfo, pdInfo.getStorageOrgUnit().getId().toString(), entryColl, info);
                pdInfo.setQty(pdInfo.getQty().subtract(fnewqty));
            }
        }
        return fqty;
    }

    protected PlannedOrderScheduleProductLineEntryCollection getPlannedOrderScheduleProductLineEntryCollection(Context ctx, PlannedOrderScheduleInfo info, MaterialInfo materialInfo) throws BOSException, EASBizException {
        PlannedOrderScheduleProductLineEntryCollection coll = new PlannedOrderScheduleProductLineEntryCollection();
        if (info.getProductLineEntry() == null || info.getProductLineEntry().size() < 1 || materialInfo == null) {
            return coll;
        }
        MMCommonUtils.objectValueSort((IObjectCollection)info.getProductLineEntry(), (boolean)true, (String)"level");
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        for (int i = info.getProductLineEntry().size() - 1; i >= 0; --i) {
            if (info.getProductLineEntry().get(i).getProductLine() == null) continue;
            ProductLineInfo plInfo = info.getProductLineEntry().get(i).getProductLine();
            sql.setLength(0);
            sql.append("select h.fid from CT_SCH_PRODUCTASSIGNMENT h ");
            sql.append(" Inner Join Ct_Sch_Productassignmententry d on h.fid = d.fparentid ");
            sql.append(" where h.Cfstorageorgunitid = '").append(info.getStorageOrgUnit().getId()).append("' ");
            sql.append(" and h.Cfproductlineid = '").append(info.getProductLineEntry().get(i).getProductLine().getId()).append("' ");
            sql.append(" and d.Cfmaterialid = '").append(materialInfo.getId()).append("' ");
            sql.append(" And h.Cfbasestatus = 1 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() <= 0) continue;
            coll.add(info.getProductLineEntry().get(i));
        }
        return coll;
    }

    protected PlannedOrderScheduleProjectEntryCollection getPlannedOrderScheduleProjectEntryCollection(Context ctx, PlannedOrderScheduleInfo info) {
        PlannedOrderScheduleProjectEntryCollection projectcoll = new PlannedOrderScheduleProjectEntryCollection();
        if (info.getProjectEntry() != null && info.getProjectEntry().size() > 0) {
            PlannedOrderScheduleProjectEntryInfo entryInfo;
            int i;
            if (info.getProjectEntry().size() == 1) {
                return info.getProjectEntry();
            }
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            ArrayList<String> trackNumberList = new ArrayList<String>();
            MMCommonUtils.objectValueSort((IObjectCollection)info.getProjectEntry(), (boolean)true, (String)"level");
            for (i = 0; i < info.getProjectEntry().size(); ++i) {
                entryInfo = info.getProjectEntry().get(i);
                if (levelList.contains(entryInfo.getLevel())) continue;
                levelList.add(entryInfo.getLevel());
            }
            trackNumberList.add("");
            MMCommonUtils.objectValueSort((IObjectCollection)info.getProjectEntry(), (boolean)true, (String)"trackNumber.number");
            for (i = 0; i < info.getProjectEntry().size(); ++i) {
                entryInfo = info.getProjectEntry().get(i);
                if (entryInfo.getTrackNumber() == null || trackNumberList.contains(entryInfo.getTrackNumber().getNumber())) continue;
                trackNumberList.add(entryInfo.getTrackNumber().getNumber());
            }
            for (i = 0; i < levelList.size(); ++i) {
                int level = (Integer)levelList.get(i);
                for (int j = 0; j < trackNumberList.size(); ++j) {
                    String ftrackNumber = (String)trackNumberList.get(j);
                    for (int k = 0; k < info.getProjectEntry().size(); ++k) {
                        PlannedOrderScheduleProjectEntryInfo entryInfo2 = info.getProjectEntry().get(k);
                        if ((ftrackNumber == null || "".equals(ftrackNumber)) && entryInfo2.getTrackNumber() == null && entryInfo2.getLevel() == level) {
                            projectcoll.add(entryInfo2);
                            continue;
                        }
                        if (ftrackNumber == null || "".equals(ftrackNumber) || entryInfo2.getTrackNumber() == null || !entryInfo2.getTrackNumber().getNumber().equals(ftrackNumber) || entryInfo2.getLevel() != level) continue;
                        projectcoll.add(entryInfo2);
                    }
                }
            }
        }
        return projectcoll;
    }

    protected int getloopvalue(Context ctx, PMRPPlannedOrderInfo pdInfo) throws BOSException, EASBizException {
        BigDecimal fqty = pdInfo.getQty();
        BigDecimal batchQty = null;
        int iloop = 1;
        if (pdInfo.get("batchQty") != null && ((batchQty = new BigDecimal(pdInfo.get("batchQty").toString())) == null || batchQty.compareTo(BigDecimal.ZERO) <= 0)) {
            batchQty = new BigDecimal(0);
        }
        if (batchQty != null && batchQty.compareTo(BigDecimal.ZERO) > 0) {
            iloop = (int)Math.ceil(fqty.divide(batchQty, 4).doubleValue());
        }
        if (iloop < 1) {
            iloop = 1;
        }
        return iloop;
    }

    protected PMRPPlannedOrderCollection getPlannedOrderCollection(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        PlannedOrderScheduleProjectEntryCollection projectColl = this.getPlannedOrderScheduleProjectEntryCollection(ctx, info);
        MMCommonUtils.objectValueSort((IObjectCollection)info.getMaterialEntry(), (boolean)true, (String)"level");
        StringBuffer sql = new StringBuffer();
        java.util.Date beginDate = info.getPlanBeginDate();
        java.util.Date endDate = info.getPlanEndDate();
        String beginDateStr = sdfDate.format(beginDate) + " 00:00:00";
        String endDateStr = sdfDate.format(endDate) + " 23:59:59";
        String fbillid = "1";
        if (info.getId() != null) {
            fbillid = info.getId().toString();
        }
        PMRPPlannedOrderCollection coll = new PMRPPlannedOrderCollection();
        sql.append(" Select a.fid,a.fbasestatus, \r\n");
        sql.append("  a.fqty,a.ftotalreleaseqty,a.fprojectid,p.fnumber as fprojectNumber,p.fname_l2 as fprojectName, \r\n");
        sql.append("  a.ftrackid,t.fnumber as ftrackNumber,t.fname_l2 as ftrackNumberName, \r\n");
        sql.append("  a.fstartdate,a.fenddate,a.favilabledate, \r\n");
        sql.append("  a.funitid ,unit.fnumber as funitnumber,unit.fname_l2 as funitname,unit.fqtyprecision as fqtyprecision, \r\n");
        sql.append("  a.fmaterialid,m.fnumber as fmaterialNumber,m.fname_l2 as fmaterialName,m.fmodel as fmodel, \r\n");
        sql.append("  a.fnumber as fnumber, \r\n");
        sql.append("  (Select Max(h.Ffinishtime) from T_PCP_ProjectCP h inner join  (Select fmaterialid,fprojectid,Max(fstorageorgunitid) As fstorageorgunitid   from t_mm_bom where fbasestatus = 4 and fbomtype = ").append(80).append(" group by fmaterialid,fprojectid) morg ON morg.fmaterialid= h.Fmaterialid and morg.fprojectid = h.fprojectid \r\n");
        sql.append("  where h.fprojectid = a.fprojectid and h.ftracknumberid = a.ftrackid \r\n");
        sql.append("  and h.fmaterialid = a.fmaterialid \r\n");
        sql.append("  and h.fstate = 4 and morg.fstorageorgunitid = a.fstorageorgunitid \r\n");
        sql.append("  ) as fmaxfinishdate, \r\n");
        sql.append(" Isnull((select sum(fnewqty - isnull(freleaseqty,0)) from t_sch_poscheduleentry sch where sch.fplannedorderid = a.fid and sch.fnewdate is not null and sch.fparentid <> '").append(fbillid).append("' ),0) as fscheduleQty  \r\n");
        sql.append(" from t_mrp_pmrpplannedorder a \r\n");
        sql.append(" left outer join t_mm_project p on a.fprojectid = p.fid \r\n");
        sql.append(" left outer join t_mm_tracknumber t on t.fid = a.ftrackid \r\n");
        sql.append(" left outer join t_bd_material m on m.fid = a.fmaterialid \r\n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = a.funitid \r\n");
        sql.append(" where a.fstorageorgunitid = '").append(info.getStorageOrgUnit().getId()).append("' \r\n");
        sql.append(" and a.fmaterialid = ? \r\n");
        sql.append(" and a.fprojectid = ? \r\n");
        sql.append(" and a.ftrackid = ? \r\n");
        sql.append(" and a.fstartdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and a.fstartdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" and a.fqty - a.ftotalreleaseqty > 0 and a.fbasestatus <> 7  \r\n");
        IRowSet rs = null;
        ArrayList<String> isExedList = new ArrayList<String>();
        String fmaterialid = null;
        for (int i = projectColl.size() - 1; i >= 0; --i) {
            if (projectColl.get(i).getProject() == null || projectColl.get(i).getTrackNumber() == null) continue;
            ProjectInfo projectInfo = projectColl.get(i).getProject();
            TrackNumberInfo trackNumberInfo = projectColl.get(i).getTrackNumber();
            for (int j = info.getMaterialEntry().size() - 1; j >= 0; --j) {
                if (info.getMaterialEntry().get(j).getMaterial() == null) continue;
                fmaterialid = info.getMaterialEntry().get(j).getMaterial().getId().toString();
                if (isExedList != null && isExedList.contains(projectInfo.getId().toString() + trackNumberInfo.getId().toString() + fmaterialid)) continue;
                isExedList.add(projectInfo.getId().toString() + trackNumberInfo.getId().toString() + fmaterialid);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fmaterialid, projectInfo.getId().toString(), trackNumberInfo.getId().toString()});
                try {
                    while (rs.next()) {
                        PMRPPlannedOrderInfo pinfo = new PMRPPlannedOrderInfo();
                        String fid = rs.getString("fid");
                        BigDecimal fqty = rs.getBigDecimal("fqty");
                        BigDecimal ftotalreleaseqty = rs.getBigDecimal("ftotalreleaseqty");
                        BigDecimal fscheduleQty = rs.getBigDecimal("fscheduleQty");
                        String fprojectid = rs.getString("fprojectid");
                        String fprojectNumber = rs.getString("fprojectNumber");
                        String fprojectName = rs.getString("fprojectName");
                        String ftrackid = rs.getString("ftrackid");
                        String ftrackNumber = rs.getString("ftrackNumber");
                        String ftrackNumberName = rs.getString("ftrackNumberName");
                        Date fstartdate = rs.getDate("fstartdate");
                        Date fenddate = rs.getDate("fenddate");
                        Date favilabledate = rs.getDate("favilabledate");
                        Date fmaxfinishdate = rs.getDate("fmaxfinishdate");
                        String fnumber = rs.getString("fnumber");
                        String funitid = rs.getString("funitid");
                        String funitnumber = rs.getString("funitnumber");
                        String funitname = rs.getString("funitname");
                        String fmaterialNumber = rs.getString("fmaterialNumber");
                        String fmaterialName = rs.getString("fmaterialName");
                        String fmodel = rs.getString("fmodel");
                        int fqtyprecision = rs.getInt("fqtyprecision");
                        if (ftotalreleaseqty == null) {
                            ftotalreleaseqty = BigDecimal.ZERO;
                        }
                        if (fscheduleQty == null) {
                            fscheduleQty = BigDecimal.ZERO;
                        }
                        if (fqty.compareTo(ftotalreleaseqty) <= 0 || fqty.compareTo(fscheduleQty) <= 0) continue;
                        pinfo.setId(BOSUuid.read((String)fid));
                        pinfo.setNumber(fnumber);
                        if (fprojectid != null && !"".equals(fprojectid)) {
                            ProjectInfo pjInfo = new ProjectInfo();
                            pjInfo.setId(BOSUuid.read((String)fprojectid));
                            pjInfo.setNumber(fprojectNumber);
                            pjInfo.setName(fprojectName);
                            pinfo.setProject(pjInfo);
                        }
                        if (ftrackid != null && !"".equals(ftrackid)) {
                            TrackNumberInfo trackInfo = new TrackNumberInfo();
                            trackInfo.setId(BOSUuid.read((String)ftrackid));
                            trackInfo.setNumber(ftrackNumber);
                            trackInfo.setName(ftrackNumberName);
                            pinfo.setTrackNumber(trackInfo);
                        }
                        if (funitid != null && !"".equals(funitid)) {
                            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
                            unitInfo.setId(BOSUuid.read((String)funitid));
                            unitInfo.setNumber(funitnumber);
                            unitInfo.setName(funitname);
                            unitInfo.setQtyPrecision(fqtyprecision);
                            pinfo.setUnit(unitInfo);
                        }
                        if (fmaterialid != null && !"".equals(fmaterialid)) {
                            MaterialInfo mInfo = new MaterialInfo();
                            mInfo.setId(BOSUuid.read((String)fmaterialid));
                            mInfo.setNumber(fmaterialNumber);
                            mInfo.setName(fmaterialName);
                            mInfo.setModel(fmodel);
                            pinfo.setMaterial(mInfo);
                        }
                        pinfo.setStartDate(fstartdate);
                        pinfo.setEndDate(fenddate);
                        pinfo.setAvilableDate(favilabledate);
                        pinfo.put("fmaxfinishdate", fmaxfinishdate);
                        pinfo.setStorageOrgUnit(info.getStorageOrgUnit());
                        if (fscheduleQty.compareTo(ftotalreleaseqty) > 0) {
                            pinfo.setQty(fqty.subtract(fscheduleQty));
                        } else {
                            pinfo.setQty(fqty.subtract(ftotalreleaseqty));
                        }
                        pinfo.setBaseQty(pinfo.getQty());
                        pinfo.put("batchQty", info.getMaterialEntry().get(j).getBatchQty());
                        pinfo.put("realID", fid);
                        coll.add(pinfo);
                    }
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
                    throw new InterfaceDataBaseException(interfaceException);
                }
            }
        }
        return coll;
    }

    protected Map getEquipmentResourceDayQty(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> productLineList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        for (i = 0; i < info.getProductLineEntry().size(); ++i) {
            ProductLineInfo plInfo;
            if (info.getProductLineEntry().get(i).getProductLine() == null || productLineList.contains((plInfo = info.getProductLineEntry().get(i).getProductLine()).getId().toString())) continue;
            productLineList.add(plInfo.getId().toString());
        }
        for (i = 0; i < info.getMaterialEntry().size(); ++i) {
            if (info.getMaterialEntry().get(i).getMaterial() == null || materialList.contains(info.getMaterialEntry().get(i).getMaterial().getId().toString())) continue;
            materialList.add(info.getMaterialEntry().get(i).getMaterial().getId().toString());
        }
        String fbillid = "1";
        if (info.getId() != null) {
            fbillid = info.getId().toString();
        }
        java.util.Date beginDate = info.getBeginDate();
        java.util.Date endDate = info.getEndDate();
        String beginDateStr = sdfDate.format(beginDate) + " 00:00:00";
        String endDateStr = sdfDate.format(endDate) + " 23:59:59";
        sql.append(" Select p.fid,\r\n");
        sql.append(" to_char(h.fworkdate,'yyyy-MM-dd') as fworkdate,\r\n");
        sql.append(" (case p.fscheduletype when 10 then (case isnull(FBatchTime,0) when 0 then 0 else (p.FAbility*FProductBatch)/(case FBatchTimeUnit when 20 then FBatchTime when 30 then FBatchTime/60 end) end ) else p.fdayability end)  as fdayability,  \r\n");
        sql.append(" isnull((Select sum(a.fnewqty - isnull(a.freleaseqty,0)) from t_sch_poscheduleentry a where a.fproductlineid = p.fid \r\n");
        sql.append(" and to_char(a.fnewdate,'yyyy-MM-dd') = to_char(h.fworkdate ,'yyyy-MM-dd') and a.fparentid <> '").append(fbillid).append("' ),0) fusedability, \r\n");
        sql.append(" isnull((Select sum(a.fqty) from t_mm_manufactureorder a where a.fproductline = p.fid \r\n");
        sql.append(" and to_char(a.fplanbegindate,'yyyy-MM-dd') = to_char(h.fworkdate ,'yyyy-MM-dd')),0) fmousedability \r\n");
        sql.append(" from T_MM_EquipmentCalendar h \r\n");
        sql.append(" inner join t_mm_equipmentcalendarentry d on h.fid = d.fparentid \r\n");
        sql.append(" inner join t_mm_productline p on p.fid = d.fproductlineid \r\n");
        sql.append(" where d.fproductlineid in(").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and h.fworkday = 1 \r\n");
        sql.append(" and h.fworkdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and h.fworkdate <= to_date('").append(endDateStr).append("') \r\n");
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fplid = null;
        String fworkDate = null;
        BigDecimal fusedability = new BigDecimal(0);
        BigDecimal fdayability = new BigDecimal(0);
        BigDecimal fmousedability = new BigDecimal(0);
        try {
            while (rs.next()) {
                fplid = rs.getString("fid");
                fworkDate = rs.getString("fworkdate");
                fdayability = rs.getBigDecimal("fdayability");
                fusedability = rs.getBigDecimal("fusedability");
                fmousedability = rs.getBigDecimal("fmousedability");
                dataMap.put(fplid + fworkDate, fdayability.subtract(fusedability.add(fmousedability)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return dataMap;
    }

    protected void deleteScheduleDate(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> productLineList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        for (i = 0; i < info.getProductLineEntry().size(); ++i) {
            ProductLineInfo plInfo;
            if (info.getProductLineEntry().get(i).getProductLine() == null || productLineList.contains((plInfo = info.getProductLineEntry().get(i).getProductLine()).getId().toString())) continue;
            productLineList.add(plInfo.getId().toString());
        }
        for (i = 0; i < info.getMaterialEntry().size(); ++i) {
            if (info.getMaterialEntry().get(i).getMaterial() == null || materialList.contains(info.getMaterialEntry().get(i).getMaterial().getId().toString())) continue;
            materialList.add(info.getMaterialEntry().get(i).getMaterial().getId().toString());
        }
        String fbillid = "1";
        if (info.getId() != null) {
            fbillid = info.getId().toString();
        }
        java.util.Date beginDate = info.getBeginDate();
        java.util.Date endDate = info.getEndDate();
        String beginDateStr = sdfDate.format(beginDate) + " 00:00:00";
        String endDateStr = sdfDate.format(endDate) + " 23:59:59";
        sql.setLength(0);
        sql.append(" delete from t_sch_poscheduleentry \r\n");
        sql.append(" where fsourceunionid in( \r\n");
        sql.append(" Select a.fid from t_sch_poscheduleentry a \r\n");
        sql.append(" where a.fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and a.fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and a.fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and a.fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" ) \r\n");
        sql.append(" and (freleaseqty is null or freleaseqty = 0 ) and fparentid <> '").append(fbillid).append("' \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_sch_poscheduleentry  set fnewqty = freleaseqty \r\n");
        sql.append(" where fsourceunionid in( \r\n");
        sql.append(" Select a.fid from t_sch_poscheduleentry a \r\n");
        sql.append(" where a.fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and a.fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and a.fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and a.fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" ) \r\n");
        sql.append(" and freleaseqty > 0 and freleaseqty < fnewqty and fparentid <> '").append(fbillid).append("' \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from t_sch_poscheduleentry \r\n");
        sql.append(" where fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" and (freleaseqty is null or freleaseqty = 0 ) and fparentid <> '").append(fbillid).append("' \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update t_sch_poscheduleentry  set fnewqty = freleaseqty \r\n");
        sql.append(" where fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" and freleaseqty > 0 and freleaseqty < fnewqty and fparentid <> '").append(fbillid).append("' \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void checkData(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        if (info.getStorageOrgUnit() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0001"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getBeginDate() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0002"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getEndDate() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0003"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        String beginDateS = sdfDate.format(info.getBeginDate());
        String endDateS = sdfDate.format(info.getEndDate());
        if (DateUtil.stringToDate((String)beginDateS).after(DateUtil.stringToDate((String)endDateS))) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0004"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getPlanBeginDate() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0005"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getPlanEndDate() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0006"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        beginDateS = sdfDate.format(info.getPlanBeginDate());
        endDateS = sdfDate.format(info.getPlanEndDate());
        if (DateUtil.stringToDate((String)beginDateS).after(DateUtil.stringToDate((String)endDateS))) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0007"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getProductLineEntry() == null || info.getProductLineEntry().size() < 1) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0008"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getMaterialEntry() == null || info.getMaterialEntry().size() < 1) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0009"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        boolean hasProductLine = false;
        for (int i = 0; i < info.getProductLineEntry().size(); ++i) {
            if (info.getProductLineEntry().get(i).get("productLine") == null) continue;
            hasProductLine = true;
            break;
        }
        if (!hasProductLine) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0008"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        boolean hasMaterial = false;
        for (int i = 0; i < info.getMaterialEntry().size(); ++i) {
            BigDecimal fbatchQty;
            int fbatchQtyinit;
            if (info.getMaterialEntry().get(i).get("material") != null) {
                hasMaterial = true;
            }
            if (info.getMaterialEntry().get(i).getBatchQty() == null || new BigDecimal((fbatchQtyinit = (fbatchQty = info.getMaterialEntry().get(i).getBatchQty()).intValue()) + "").compareTo(fbatchQty) == 0) continue;
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", (String)"DIJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0010"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (!hasMaterial) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0009"));
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected boolean isExistsReleaseData(Context ctx, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        boolean isExists = false;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getReleaseQty() == null || info.getEntrys().get(i).getReleaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            isExists = true;
            break;
        }
        if (info.getId() != null && !isExists) {
            StringBuffer sql = new StringBuffer();
            String fid = "";
            sql.setLength(0);
            sql.append(" Select * from  t_sch_poscheduleentry \r\n");
            sql.append(" where (freleaseqty > 0 ) and fparentid = '").append(info.getId()).append("' \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() > 0) {
                isExists = true;
            }
        }
        return isExists;
    }

    @Override
    protected PlannedOrderScheduleInfo _unionSchedule(Context ctx, PlannedOrderScheduleInfo info, Map dataMap) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        if (dataMap == null) {
            return info;
        }
        PlannedOrderScheduleEntryCollection entryColl = info.getEntrys();
        PlannedOrderScheduleEntryCollection updateEntryColl = (PlannedOrderScheduleEntryCollection)((Object)dataMap.get("entrycoll"));
        if (updateEntryColl == null || updateEntryColl.size() < 1) {
            return info;
        }
        PlannedOrderScheduleEntryCollection removecoll = new PlannedOrderScheduleEntryCollection();
        for (int i = 0; i < updateEntryColl.size(); ++i) {
            int j;
            PlannedOrderScheduleEntryInfo updateEntryInfo = updateEntryColl.get(i);
            if (updateEntryInfo.getNewDate() == null || updateEntryInfo.getProductLine() == null || updateEntryInfo.getNewQty() == null || updateEntryInfo.getNewQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (updateEntryInfo.getId() == null) {
                updateEntryInfo.setId(BOSUuid.create((String)"3E636AB1"));
            }
            for (j = 0; j < entryColl.size(); ++j) {
                if (entryColl.get(j).getId() != null && entryColl.get(j).getId().toString().equals(updateEntryInfo.getId().toString())) {
                    removecoll.add(entryColl.get(j));
                }
                if (entryColl.get(j).getSourceUnionID() == null || !entryColl.get(j).getSourceUnionID().toString().equals(updateEntryInfo.getId().toString())) continue;
                removecoll.add(entryColl.get(j));
            }
            if (removecoll.size() > 0) {
                for (j = 0; j < removecoll.size(); ++j) {
                    entryColl.remove(removecoll.get(j));
                }
            }
            entryColl.add(updateEntryInfo);
            this.expandChildMaterialSchedule(ctx, updateEntryInfo, info.getStorageOrgUnit().getId().toString(), entryColl, info);
        }
        return info;
    }

    protected PlannedOrderScheduleEntryInfo createPlannedOrderScheduleEntryInfo(Context ctx, PMRPPlannedOrderInfo pdInfo, java.util.Date newDate, BigDecimal newQty, ProductLineInfo productLineInfo, boolean isCreateID) throws BOSException, EASBizException {
        PlannedOrderScheduleEntryInfo entryInfo = new PlannedOrderScheduleEntryInfo();
        if (isCreateID) {
            entryInfo.setId(BOSUuid.create((String)"3E636AB1"));
        }
        entryInfo.setMaterial(pdInfo.getMaterial());
        if (pdInfo.get("fmaxfinishdate") != null) {
            entryInfo.setMaxEndDate((java.util.Date)pdInfo.get("fmaxfinishdate"));
        }
        entryInfo.setIsUnion(false);
        entryInfo.setExceptionNote(null);
        entryInfo.setNewBeginDate(newDate);
        entryInfo.setNewDate(newDate);
        entryInfo.setNewQty(newQty);
        entryInfo.setNewEndDate(newDate);
        entryInfo.setOldBeginDate(pdInfo.getStartDate());
        entryInfo.setOldEndDate(pdInfo.getEndDate());
        entryInfo.setAvilableDate(pdInfo.getAvilableDate());
        entryInfo.setOldQty(pdInfo.getBaseQty());
        if (pdInfo.get("realID") != null) {
            entryInfo.setPlannedOrderID(pdInfo.get("realID").toString());
        } else {
            entryInfo.setPlannedOrderID(pdInfo.getId().toString());
        }
        entryInfo.setPlannedOrderNumber(pdInfo.getNumber());
        entryInfo.setProductLine(productLineInfo);
        entryInfo.setProject(pdInfo.getProject());
        entryInfo.setTrackNumber(pdInfo.getTrackNumber());
        entryInfo.setUnit(pdInfo.getUnit());
        entryInfo.put("storageOrgUnitInfo", pdInfo.getStorageOrgUnit());
        entryInfo.put("pkstr", pdInfo.getMaterial().getId().toString() + pdInfo.getStorageOrgUnit().getId().toString() + pdInfo.getProject().getId().toString() + pdInfo.getTrackNumber().getId().toString());
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandChildMaterialSchedule(Context ctx, PlannedOrderScheduleEntryInfo entryInfo, String fstorageOrgUnitID, PlannedOrderScheduleEntryCollection entryColl, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        if (entryInfo == null || entryInfo.getId() == null || entryInfo.getNewDate() == null) {
            return;
        }
        if (entryInfo.getNewQty() == null || entryInfo.getNewQty().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        java.util.Date fnewDate = entryInfo.getNewDate();
        String fnewDateStr = sdfDateTime.format(fnewDate);
        boolean isbreak = false;
        ArrayList<String> tempTableList = new ArrayList<String>();
        try {
            String levelChar = ".";
            int bomtype = 90;
            int loopCount = 1;
            if (bomtype == 90) {
                loopCount = 2;
            }
            String expandZZBOMTempTable = this.createExpandZZBOMTempTable(ctx);
            tempTableList.add(expandZZBOMTempTable);
            int effectedRows = 0;
            int totalcount = 0;
            int level = 0;
            boolean hasChild = false;
            while (level < 50) {
                int i;
                levelChar = levelChar + ".";
                if (++level == 1) {
                    for (i = 0; i < loopCount; ++i) {
                        if (loopCount == 2) {
                            bomtype = i == 0 ? 90 : 80;
                        }
                        sql.setLength(0);
                        sql.append(this.getInsertExpandZZBOMTempTableSQL(expandZZBOMTempTable));
                        sql.append(" SELECT newbosid('12345678') as fid, \r\n");
                        sql.append(" ").append(level).append(" as FLevel, \r\n");
                        sql.append(" '").append(levelChar).append("' as FLevelChar, \r\n");
                        sql.append(" h.fstorageorgunitid as FStorageOrgUnitID, \r\n");
                        sql.append(" d.fsupplystorageorgunitid as FsupplyOrgid, \r\n");
                        sql.append(" d.fmaterialid as FMaterialID, \r\n");
                        sql.append(" d.fconsumefixqty * ").append(entryInfo.getNewQty()).append(" as FQty, \r\n");
                        sql.append(" d.FMATERIALPROP As Fsource , \r\n");
                        sql.append(" '").append(entryInfo.getTrackNumber().getNumber()).append("' As FTrackNumber, \r\n");
                        sql.append(" d.fconsumefixqty As FavgQty, \r\n");
                        sql.append(" '").append(entryInfo.getProject().getId()).append("' As Fprojectid, \r\n");
                        sql.append(" d.Fseq,  \r\n");
                        sql.append(" d.FProvideType As FProvideType,  \r\n");
                        sql.append(" '").append(entryInfo.getTrackNumber().getId()).append("' As FtrackNumberID ,  \r\n");
                        sql.append(" to_date('").append(fnewDateStr).append("') - Isnull(d.FLeadtime,0) - Isnull(mp.FRecevingLeadTime,0) - Isnull(mp.FProduceLeadTime,0) As FbeginDate, \r\n");
                        sql.append(" to_date('").append(fnewDateStr).append("') - Isnull(d.FLeadtime,0) - Isnull(mp.FRecevingLeadTime,0) As FendDate, \r\n");
                        sql.append(" h.fstorageorgunitid as FParentStorageOrgUnitID, \r\n");
                        sql.append(" h.fmaterialid as FParentMaterialID, \r\n");
                        sql.append(" '").append(entryInfo.getId().toString()).append("' as FParentEntryID \r\n");
                        sql.append(" FROM  t_mm_bom h \r\n");
                        sql.append(" Inner Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
                        sql.append(" inner join t_bd_materialplan mp on d.FMaterialID = mp.fmaterialid and d.fsupplystorageorgunitid = mp.forgunit ");
                        sql.append(" Inner join t_mm_tracknumber bt on d.fbegincarnoid = bt.fid \r\n");
                        sql.append(" Inner join t_mm_tracknumber et on d.fendcarnoid = et.fid \r\n");
                        sql.append(" WHERE  h.fstorageorgunitid = '").append(fstorageOrgUnitID).append("' \r\n");
                        sql.append(" and  h.fmaterialid = '").append(entryInfo.getMaterial().getId()).append("' \r\n");
                        sql.append(" and  h.fprojectid = '").append(entryInfo.getProject().getId()).append("' \r\n");
                        sql.append(" and  h.fbomtype = ").append(bomtype).append(" \r\n");
                        sql.append(" and  h.fbasestatus = ").append(4).append(" \r\n");
                        sql.append(" and  bt.fnumber <= '").append(entryInfo.getTrackNumber().getNumber()).append("' and et.fnumber >= '").append(entryInfo.getTrackNumber().getNumber()).append("' \r\n");
                        sql.append(" and  d.fconsumefixqty > 0 \r\n");
                        effectedRows = this.executeSQL(ctx, sql.toString());
                        totalcount += effectedRows;
                        if (effectedRows > 0 && !(hasChild = this.childMaterialSchedule(ctx, expandZZBOMTempTable, level, entryInfo.getId().toString(), entryColl, info))) {
                            isbreak = true;
                            break;
                        }
                        if (effectedRows > 0 && i == 0 && loopCount == 2) break;
                        if (effectedRows > 0 || i == 0 && loopCount == 2) continue;
                        isbreak = true;
                        break;
                    }
                    if (isbreak) {
                        break;
                    }
                } else {
                    isbreak = false;
                    for (i = 0; i < loopCount; ++i) {
                        if (loopCount == 2) {
                            bomtype = i == 0 ? 90 : 80;
                        }
                        sql.setLength(0);
                        sql.append(this.getInsertExpandZZBOMTempTableSQL(expandZZBOMTempTable));
                        sql.append(" SELECT newbosid('12345678') as fid, \r\n");
                        sql.append(" ").append(level).append(" as FLevel, \r\n");
                        sql.append(" '").append(levelChar).append("' as FLevelChar, \r\n");
                        sql.append(" h.fstorageorgunitid as FStorageOrgUnitID, \r\n");
                        sql.append(" d.fsupplystorageorgunitid as FsupplyOrgid, \r\n");
                        sql.append(" d.fmaterialid as FMaterialID, \r\n");
                        sql.append(" d.fconsumefixqty * tp.Fqty as FQty, \r\n");
                        sql.append(" d.FMATERIALPROP As Fsource , \r\n");
                        sql.append(" '").append(entryInfo.getTrackNumber().getNumber()).append("' As FTrackNumber, \r\n");
                        sql.append(" d.fconsumefixqty As FavgQty, \r\n");
                        sql.append(" '").append(entryInfo.getProject().getId()).append("' As Fprojectid, \r\n");
                        sql.append(" d.Fseq,  \r\n");
                        sql.append(" d.FProvideType As FProvideType,  \r\n");
                        sql.append(" '").append(entryInfo.getTrackNumber().getId()).append("' As FtrackNumberID ,  \r\n");
                        sql.append(" tp.FbeginDate - Isnull(d.FLeadtime,0) - Isnull(mp.FRecevingLeadTime,0) - Isnull(mp.FProduceLeadTime,0) As FbeginDate, \r\n");
                        sql.append(" tp.FbeginDate - Isnull(d.FLeadtime,0) - Isnull(mp.FRecevingLeadTime,0) As FendDate, \r\n");
                        sql.append(" tp.FParentStorageOrgUnitID, \r\n");
                        sql.append(" tp.FParentMaterialID, \r\n");
                        sql.append(" tp.FParentEntryID \r\n");
                        sql.append(" FROM  ").append(expandZZBOMTempTable).append(" tp  \r\n");
                        sql.append(" Inner Join t_mm_bom h  \r\n");
                        sql.append(" on tp.Fmaterialid = h.fmaterialid And tp.FsupplyOrgid = h.fstorageorgunitid and h.fbomtype = " + bomtype + " and h.fbasestatus = 4  \r\n");
                        sql.append(" Inner Join t_mm_bomentry d on h.fid = d.fparentid \r\n");
                        sql.append(" inner join t_bd_materialplan mp on d.FMaterialID = mp.fmaterialid and d.fsupplystorageorgunitid = mp.forgunit ");
                        sql.append(" Inner join t_mm_tracknumber bt on d.fbegincarnoid = bt.fid \r\n");
                        sql.append(" Inner join t_mm_tracknumber et on d.fendcarnoid = et.fid \r\n");
                        sql.append(" WHERE tp.FLevel = '").append(level - 1).append("' \r\n");
                        sql.append(" And h.fprojectid = '").append(entryInfo.getProject().getId()).append("' \r\n");
                        sql.append(" and bt.fnumber <= '").append(entryInfo.getTrackNumber().getNumber()).append("' and et.fnumber >= '").append(entryInfo.getTrackNumber().getNumber()).append("' \r\n");
                        effectedRows = this.executeSQL(ctx, sql.toString());
                        totalcount += effectedRows;
                        if (effectedRows > 0 && !(hasChild = this.childMaterialSchedule(ctx, expandZZBOMTempTable, level, entryInfo.getId().toString(), entryColl, info))) {
                            isbreak = true;
                            break;
                        }
                        if (effectedRows > 0 && i == 0 && loopCount == 2) break;
                        if (effectedRows > 0 || i == 0 && loopCount == 2) continue;
                        isbreak = true;
                        break;
                    }
                }
                if (!isbreak) continue;
                break;
            }
        }
        finally {
            this.releaseTempTable(ctx, tempTableList);
        }
    }

    public int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected String getInsertExpandZZBOMTempTableSQL(String expandZZBOMTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(expandZZBOMTempTableName).append("(\r\n");
        sql.append("fid ,\r\n");
        sql.append("FLevel ,\r\n");
        sql.append("FLevelChar ,\r\n");
        sql.append("FStorageOrgUnitID ,\r\n");
        sql.append("FsupplyOrgid ,\r\n");
        sql.append("FMaterialID ,\r\n");
        sql.append("FQty ,\r\n");
        sql.append("Fsource ,\r\n");
        sql.append("FTrackNumber ,\r\n");
        sql.append("FavgQty, \r\n");
        sql.append("Fprojectid,\r\n");
        sql.append("FSeq,\r\n");
        sql.append("FProvideType,\r\n");
        sql.append("FtrackNumberID,\r\n");
        sql.append("FbeginDate, \r\n");
        sql.append("FendDate, \r\n");
        sql.append("FParentStorageOrgUnitID,\r\n");
        sql.append("FParentMaterialID,\r\n");
        sql.append("FParentEntryID \r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected void releaseTempTable(Context ctx, List tempTableList) {
        if (ctx == null || tempTableList == null) {
            return;
        }
        if (tempTableList.size() == 0) {
            return;
        }
        for (int index = 0; index < tempTableList.size(); ++index) {
            String tempTable;
            String string = tempTable = tempTableList.get(index) == null ? null : tempTableList.get(index).toString();
            if (tempTable == null) {
                return;
            }
            if (tempTable.trim().length() == 0) {
                return;
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    protected String createExpandZZBOMTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandZZBOMTempTable(\r\n");
        sql.append("FID  VARCHAR(44), \r\n");
        sql.append("FLevel Int,\r\n");
        sql.append("FLevelChar  NVARCHAR(100), \r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FsupplyOrgid VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,14),\r\n");
        sql.append("Fsource NVARCHAR(30),\r\n");
        sql.append("FTrackNumber NVARCHAR(80),\r\n");
        sql.append("FavgQty Numeric(28,14),\r\n");
        sql.append("Fprojectid VARCHAR(44),\r\n");
        sql.append("FSeq Int, \r\n");
        sql.append("FProvideType Int, \r\n");
        sql.append("FtrackNumberID VARCHAR(44), \r\n");
        sql.append("FbeginDate DateTime, \r\n");
        sql.append("FendDate DateTime, \r\n");
        sql.append("FParentStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FParentMaterialID VARCHAR(44),\r\n");
        sql.append("FParentEntryID VARCHAR(44)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMaterialID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FLevel", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String getdefFactoryCalendarID(Context ctx, String forgID) throws BOSException, EASBizException {
        String fid = "";
        if (this.fcOrgMap == null || this.fcOrgMap.size() < 1 || !this.fcOrgMap.containsKey(forgID)) {
            if (this.fcOrgMap == null) {
                this.fcOrgMap = new HashMap<String, String>();
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" Select top 1 fid from T_MM_FactoryCalendar a \r\n");
            sql.append(" where a.Fstorageorgunitid = '").append(forgID).append("' \r\n");
            sql.append(" and a.Fisdefault = 1 \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    fid = rs.getString("fid");
                }
                if (fid == null) {
                    fid = "";
                }
                this.fcOrgMap.put(forgID, fid);
                return fid;
            }
            catch (SQLException e) {
                e.printStackTrace();
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
        return this.fcOrgMap.get(forgID).toString();
    }

    protected java.util.Date getNewDate(Context ctx, java.util.Date oldDate, String forgID, int updateWay) throws BOSException, EASBizException {
        String ffcID = this.getdefFactoryCalendarID(ctx, forgID);
        if (ffcID == null || "".equals(ffcID)) {
            return oldDate;
        }
        java.util.Date newDate = oldDate;
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("FWorkDate \"FWorkDate\"\r\n");
        sql.append("From T_MM_FactoryCalendarEntry \r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FParentID='").append(ffcID).append("'\r\n");
        sql.append("And FWorkDate Is Not Null\r\n");
        sql.append("And (\r\n");
        sql.append("FDateType=").append(1).append("\r\n");
        sql.append("Or FDateType=").append(4).append("\r\n");
        sql.append(")\r\n");
        if (updateWay == 0) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate ASC\r\n");
        } else if (updateWay == 1) {
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(OperationScheduleUtils.sdfDate.format(oldDate)).append("'\r\n");
            sql.append("Order By\r\n");
            sql.append("FWorkDate DESC\r\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                newDate = rs.getDate("FWorkDate");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return newDate;
    }

    protected void materialParentMap(Context ctx, String childPk, String parentPk, String parentEntryID) throws BOSException, EASBizException {
        ArrayList parentList = new ArrayList();
        if (this.materialParentMap != null && this.materialParentMap.containsKey(childPk)) {
            parentList = (ArrayList)this.materialParentMap.get(childPk);
        }
        if (!parentList.contains(parentEntryID)) {
            parentList.add(parentEntryID);
            this.materialParentMap.put(childPk, parentList);
        }
    }

    protected boolean childMaterialSchedule(Context ctx, String expandZZBOMTempTable, int level, String funionSourceID, PlannedOrderScheduleEntryCollection entryColl, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        boolean hasChild = false;
        StringBuffer sql = new StringBuffer();
        sql.append("Select ");
        sql.append("t.fid ,\r\n");
        sql.append("t.FsupplyOrgid ,\r\n");
        sql.append("t.FMaterialID ,\r\n");
        sql.append("t.Fprojectid ,\r\n");
        sql.append("t.FtrackNumberID As ftrackNumberID ,\r\n");
        sql.append("t.FbeginDate As FbeginDate ,\r\n");
        sql.append("t.FendDate As FendDate ,\r\n");
        sql.append("t.FQty As fqty, \r\n");
        sql.append("t.FParentStorageOrgUnitID As FParentStorageOrgUnitID, \r\n");
        sql.append("t.FParentMaterialID As FParentMaterialID, \r\n");
        sql.append("t.FParentEntryID As FParentEntryID \r\n");
        sql.append(" from \r\n").append(expandZZBOMTempTable).append(" t ");
        sql.append(" where t.FLevel =  ").append(level);
        sql.append(" and  exists ( Select 1 from t_mrp_pmrpplannedorder a \r\n");
        sql.append(" where a.fstorageorgunitid = t.FsupplyOrgid \r\n");
        sql.append(" and a.fmaterialid = t.FMaterialID \r\n");
        sql.append(" and a.fprojectid = t.Fprojectid \r\n");
        sql.append(" and a.ftrackid = t.FtrackNumberID \r\n");
        sql.append(" and a.fqty - a.ftotalreleaseqty > 0 and a.fbasestatus <> 7 and a.fordertype in(10,30) ) \r\n");
        sql.append(" order by t.FQty \r\n");
        BigDecimal fnewqty = new BigDecimal(0);
        PlannedOrderScheduleEntryInfo entryInfo = null;
        HashMap<String, PMRPPlannedOrderCollection> materialPlannedorderMap = new HashMap<String, PMRPPlannedOrderCollection>();
        String fkey = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PMRPPlannedOrderCollection pdColl = null;
        boolean hasExists = false;
        BigDecimal plannedOrderThisScheduleQty = new BigDecimal(0);
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fmaterialid = rs.getString("FMaterialID");
                String fstorageOrgUnitID = rs.getString("FsupplyOrgid");
                String ftrackNumberID = rs.getString("ftrackNumberID");
                String Fprojectid = rs.getString("Fprojectid");
                BigDecimal fneedQty = rs.getBigDecimal("fqty");
                Date FbeginDate = rs.getDate("FbeginDate");
                Date FendDate = rs.getDate("FendDate");
                String FParentStorageOrgUnitID = rs.getString("FParentStorageOrgUnitID");
                String FParentMaterialID = rs.getString("FParentMaterialID");
                String FParentEntryID = rs.getString("FParentEntryID");
                fkey = fmaterialid + fstorageOrgUnitID + Fprojectid + ftrackNumberID;
                hasExists = false;
                for (int j = 0; j < info.getMaterialEntry().size(); ++j) {
                    if (info.getMaterialEntry().get(j).getMaterial() == null || !info.getMaterialEntry().get(j).getMaterial().getId().toString().equals(fmaterialid) || !info.getStorageOrgUnit().getId().toString().equals(fstorageOrgUnitID)) continue;
                    hasExists = true;
                    break;
                }
                if (hasExists) {
                    this.materialParentMap(ctx, fkey, FParentMaterialID + FParentMaterialID + Fprojectid + ftrackNumberID, FParentEntryID);
                    sql.setLength(0);
                    sql.append(" delete from ").append(expandZZBOMTempTable).append("  ");
                    sql.append(" where fid = '").append(fid).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    continue;
                }
                java.util.Date fnewbeginDate = this.getNewDate(ctx, FbeginDate, fstorageOrgUnitID, 1);
                java.util.Date fnewendDate = this.getNewDate(ctx, FendDate, fstorageOrgUnitID, 0);
                if (materialPlannedorderMap != null && materialPlannedorderMap.containsKey(fkey)) {
                    pdColl = (PMRPPlannedOrderCollection)((Object)materialPlannedorderMap.get(fkey));
                } else {
                    pdColl = this.getChildPlannedOrderCollection(ctx, fmaterialid, fstorageOrgUnitID, Fprojectid, ftrackNumberID, info);
                    materialPlannedorderMap.put(fkey, pdColl);
                }
                for (int i = 0; i < pdColl.size() && fneedQty.compareTo(BigDecimal.ZERO) > 0; ++i) {
                    BigDecimal fqty;
                    PMRPPlannedOrderInfo pdInfo = pdColl.get(i);
                    plannedOrderThisScheduleQty = this.getPlannedOrderScheduleQty(ctx, entryColl, pdInfo);
                    if (pdInfo.getQty() == null || pdInfo.getQty().compareTo(BigDecimal.ZERO) <= 0 || (fqty = pdInfo.getQty()).compareTo(plannedOrderThisScheduleQty) <= 0) continue;
                    if ((fqty = fqty.subtract(plannedOrderThisScheduleQty)).compareTo(fneedQty) >= 0) {
                        fnewqty = fneedQty;
                        fneedQty = BigDecimal.ZERO;
                    } else {
                        fnewqty = fqty;
                        fneedQty = fneedQty.subtract(fqty);
                    }
                    entryInfo = this.createPlannedOrderScheduleEntryInfo(ctx, pdInfo, null, fnewqty, null, true);
                    entryInfo.setNewBeginDate(fnewbeginDate);
                    entryInfo.setNewDate(fnewbeginDate);
                    entryInfo.setNewEndDate(fnewendDate);
                    entryInfo.setNewQty(fnewqty);
                    entryInfo.setIsUnion(true);
                    entryInfo.setSourceUnionID(funionSourceID);
                    entryColl.add(entryInfo);
                    hasChild = true;
                }
                sql.setLength(0);
                sql.append(" update ").append(expandZZBOMTempTable).append(" a ");
                sql.append(" Set FbeginDate = to_date('").append(sdfDate.format(fnewbeginDate)).append(" 00:00:00') ");
                sql.append(" , FendDate = to_date('").append(sdfDate.format(fnewendDate)).append(" 23:59:59') ");
                sql.append(" where a.fid = '").append(fid).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return hasChild;
    }

    protected PMRPPlannedOrderCollection getChildPlannedOrderCollection(Context ctx, String materialid, String orgunitid, String projectid, String trackid, PlannedOrderScheduleInfo info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String fbillid = "1";
        if (info.getId() != null) {
            fbillid = info.getId().toString();
        }
        PMRPPlannedOrderCollection coll = new PMRPPlannedOrderCollection();
        sql.append(" Select a.fid,a.fbasestatus, \r\n");
        sql.append("  a.fqty,a.ftotalreleaseqty,a.fprojectid,p.fnumber as fprojectNumber,p.fname_l2 as fprojectName, \r\n");
        sql.append("  a.ftrackid,t.fnumber as ftrackNumber,t.fname_l2 as ftrackNumberName, \r\n");
        sql.append("  a.fstartdate,a.fenddate,a.favilabledate, \r\n");
        sql.append("  a.funitid ,unit.fnumber as funitnumber,unit.fname_l2 as funitname,unit.fqtyprecision as fqtyprecision, \r\n");
        sql.append("  a.fmaterialid,m.fnumber as fmaterialNumber,m.fname_l2 as fmaterialName,m.fmodel as fmodel, \r\n");
        sql.append("  a.fnumber as fnumber, \r\n");
        sql.append("  (Select Max(h.Ffinishtime) from T_PCP_ProjectCP h inner join (Select fmaterialid,fprojectid,Max(fstorageorgunitid) As fstorageorgunitid   from t_mm_bom where fbasestatus = 4 and fbomtype = ").append(80).append(" group by fmaterialid,fprojectid) morg ON morg.fmaterialid= h.Fmaterialid and morg.fprojectid = h.fprojectid \r\n");
        sql.append("  where h.fprojectid = a.fprojectid and h.ftracknumberid = a.ftrackid \r\n");
        sql.append("  and h.fmaterialid = a.fmaterialid \r\n");
        sql.append("  and h.fstate = 4 and morg.fstorageorgunitid = a.fstorageorgunitid \r\n");
        sql.append("  ) as fmaxfinishdate, \r\n");
        sql.append(" Isnull((select sum(fnewqty) from t_sch_poscheduleentry sch where sch.fplannedorderid = a.fid and sch.fnewdate is not null and sch.fparentid <> '" + fbillid + "'),0) as fscheduleQty   \r\n");
        sql.append(" from t_mrp_pmrpplannedorder a \r\n");
        sql.append(" left outer join t_mm_project p on a.fprojectid = p.fid \r\n");
        sql.append(" left outer join t_mm_tracknumber t on t.fid = a.ftrackid \r\n");
        sql.append(" left outer join t_bd_material m on m.fid = a.fmaterialid \r\n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = a.funitid \r\n");
        sql.append(" where a.fstorageorgunitid = '").append(orgunitid).append("' \r\n");
        sql.append(" and a.fmaterialid  = '").append(materialid).append("'  \r\n");
        sql.append(" and a.fprojectid = '").append(projectid).append("' \r\n");
        sql.append(" and a.ftrackid = '").append(trackid).append("' \r\n");
        sql.append(" and a.fqty - a.ftotalreleaseqty > 0 and a.fbasestatus <> 7  \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PMRPPlannedOrderInfo pinfo = new PMRPPlannedOrderInfo();
                String fid = rs.getString("fid");
                BigDecimal fqty = rs.getBigDecimal("fqty");
                BigDecimal ftotalreleaseqty = rs.getBigDecimal("ftotalreleaseqty");
                BigDecimal fscheduleQty = rs.getBigDecimal("fscheduleQty");
                String fprojectid = rs.getString("fprojectid");
                String fprojectNumber = rs.getString("fprojectNumber");
                String fprojectName = rs.getString("fprojectName");
                String ftrackid = rs.getString("ftrackid");
                String ftrackNumber = rs.getString("ftrackNumber");
                String ftrackNumberName = rs.getString("ftrackNumberName");
                Date fstartdate = rs.getDate("fstartdate");
                Date fenddate = rs.getDate("fenddate");
                Date favilabledate = rs.getDate("favilabledate");
                Date fmaxfinishdate = rs.getDate("fmaxfinishdate");
                String fnumber = rs.getString("fnumber");
                String funitid = rs.getString("funitid");
                String funitnumber = rs.getString("funitnumber");
                String funitname = rs.getString("funitname");
                String fmaterialid = rs.getString("fmaterialid");
                String fmaterialNumber = rs.getString("fmaterialNumber");
                String fmaterialName = rs.getString("fmaterialName");
                String fmodel = rs.getString("fmodel");
                int fqtyprecision = rs.getInt("fqtyprecision");
                if (ftotalreleaseqty == null) {
                    ftotalreleaseqty = BigDecimal.ZERO;
                }
                if (fscheduleQty == null) {
                    fscheduleQty = BigDecimal.ZERO;
                }
                if (fqty.compareTo(ftotalreleaseqty) <= 0 || fqty.compareTo(fscheduleQty) <= 0) continue;
                pinfo.setId(BOSUuid.read((String)fid));
                pinfo.setNumber(fnumber);
                if (fprojectid != null && !"".equals(fprojectid)) {
                    ProjectInfo pjInfo = new ProjectInfo();
                    pjInfo.setId(BOSUuid.read((String)fprojectid));
                    pjInfo.setNumber(fprojectNumber);
                    pjInfo.setName(fprojectName);
                    pinfo.setProject(pjInfo);
                }
                if (ftrackid != null && !"".equals(ftrackid)) {
                    TrackNumberInfo trackInfo = new TrackNumberInfo();
                    trackInfo.setId(BOSUuid.read((String)ftrackid));
                    trackInfo.setNumber(ftrackNumber);
                    trackInfo.setName(ftrackNumberName);
                    pinfo.setTrackNumber(trackInfo);
                }
                if (funitid != null && !"".equals(funitid)) {
                    MeasureUnitInfo unitInfo = new MeasureUnitInfo();
                    unitInfo.setId(BOSUuid.read((String)funitid));
                    unitInfo.setNumber(funitnumber);
                    unitInfo.setName(funitname);
                    unitInfo.setQtyPrecision(fqtyprecision);
                    pinfo.setUnit(unitInfo);
                }
                if (fmaterialid != null && !"".equals(fmaterialid)) {
                    MaterialInfo mInfo = new MaterialInfo();
                    mInfo.setId(BOSUuid.read((String)fmaterialid));
                    mInfo.setNumber(fmaterialNumber);
                    mInfo.setName(fmaterialName);
                    mInfo.setModel(fmodel);
                    pinfo.setMaterial(mInfo);
                }
                pinfo.setStartDate(fstartdate);
                pinfo.setEndDate(fenddate);
                pinfo.setAvilableDate(favilabledate);
                pinfo.put("fmaxfinishdate", fmaxfinishdate);
                StorageOrgUnitInfo soInfo = new StorageOrgUnitInfo();
                soInfo.setId(BOSUuid.read((String)orgunitid));
                pinfo.setStorageOrgUnit(soInfo);
                if (fscheduleQty.compareTo(ftotalreleaseqty) > 0) {
                    pinfo.setQty(fqty.subtract(fscheduleQty));
                } else {
                    pinfo.setQty(fqty.subtract(ftotalreleaseqty));
                }
                pinfo.setBaseQty(pinfo.getQty());
                coll.add(pinfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return coll;
    }

    protected void setScheculeEntryException(Context ctx, PlannedOrderScheduleEntryCollection entryColl) throws BOSException, EASBizException {
        block0: for (int i = 0; i < entryColl.size(); ++i) {
            PlannedOrderScheduleEntryInfo entryInfo = entryColl.get(i);
            if (entryInfo.getNewDate() == null && entryInfo.getProductLine() == null) {
                entryInfo.setExceptionNote(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0011"));
                continue;
            }
            if (entryInfo.getNewDate() != null && entryInfo.getMaxEndDate() != null && entryInfo.getMaxEndDate().before(entryInfo.getNewDate())) {
                entryInfo.setExceptionNote(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0012"));
                continue;
            }
            if (entryInfo.getNewDate() != null && entryInfo.getMaxEndDate() == null && entryInfo.getOldEndDate().before(entryInfo.getNewDate())) {
                entryInfo.setExceptionNote(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0012"));
                continue;
            }
            String fpkid = entryInfo.get("pkstr").toString();
            if (this.materialParentMap == null || !this.materialParentMap.containsKey(fpkid) || entryInfo.getNewDate() == null) continue;
            ArrayList parentList = new ArrayList();
            parentList = (ArrayList)this.materialParentMap.get(fpkid);
            boolean isbreak = false;
            for (int k = 0; k < parentList.size(); ++k) {
                for (int j = 0; j < entryColl.size(); ++j) {
                    PlannedOrderScheduleEntryInfo entryInfo2 = entryColl.get(j);
                    if (entryInfo2.getNewDate() == null || entryInfo2.getId() == null || !entryInfo2.getId().toString().equals(((String)parentList.get(k)).toString()) || !entryInfo2.getNewDate().before(entryInfo.getNewDate())) continue;
                    entryInfo.setExceptionNote(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0013"));
                    isbreak = true;
                    break;
                }
                if (isbreak) continue block0;
            }
        }
    }

    private final String getKey(MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnitInfo, ProjectInfo projectinfo, TrackNumberInfo trackNumberInfo) {
        StringBuffer keyBuf = new StringBuffer();
        if (materialInfo != null && materialInfo.getId() != null) {
            keyBuf.append(materialInfo.getId().toString());
        }
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            keyBuf.append(storageOrgUnitInfo.getId().toString());
        }
        if (projectinfo != null && projectinfo.getId() != null) {
            keyBuf.append(projectinfo.getId().toString());
        }
        if (trackNumberInfo != null && trackNumberInfo.getId() != null) {
            keyBuf.append(trackNumberInfo.getId().toString());
        }
        String key = keyBuf.toString();
        return key;
    }

    private BigDecimal getPlannedOrderScheduleQty(Context ctx, PlannedOrderScheduleEntryCollection entryColl, PMRPPlannedOrderInfo pdInfo) throws BOSException, EASBizException {
        BigDecimal fqty = new BigDecimal(0);
        if (entryColl == null || entryColl.size() < 1) {
            return fqty;
        }
        PlannedOrderScheduleEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (!entryInfo.getPlannedOrderID().equals(pdInfo.getId().toString())) continue;
            fqty = fqty.add(entryInfo.getNewQty());
        }
        return fqty;
    }

    private boolean isExistChildData(Context ctx, PlannedOrderScheduleEntryCollection entryColl, PMRPPlannedOrderInfo pdInfo) throws BOSException, EASBizException {
        if (entryColl == null || entryColl.size() < 1) {
            return false;
        }
        String fkeyid = this.getKey(pdInfo.getMaterial(), pdInfo.getStorageOrgUnit(), pdInfo.getProject(), pdInfo.getTrackNumber());
        String fkeyid2 = "";
        PlannedOrderScheduleEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            fkeyid2 = this.getKey(entryInfo.getMaterial(), (StorageOrgUnitInfo)entryInfo.get("storageOrgUnitInfo"), entryInfo.getProject(), entryInfo.getTrackNumber());
            if (!fkeyid2.equals(fkeyid) || !entryInfo.isIsUnion()) continue;
            return true;
        }
        return false;
    }

    private int getDateSpace(java.util.Date date1, java.util.Date date2) {
        boolean result = false;
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(date1);
        caled.setTime(date2);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    @Override
    protected String _haveScheduleData(Context ctx, Set idSet) throws BOSException, EASBizException {
        String idStr = null;
        idStr = SQLUtil.setToString((Set)idSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" Select h.fnumber from t_mrp_pmrpplannedorder h \r\n");
        sql.append(" where h.fid in (" + idStr + ")  \r\n");
        sql.append(" and exists(select 1 from t_sch_poscheduleentry d where d.fplannedorderid = h.fid \r\n");
        sql.append(" ) \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fplannedOrderNumber = "";
        try {
            while (rs.next()) {
                fplannedOrderNumber = "\r\n" + fplannedOrderNumber + rs.getString("fnumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return fplannedOrderNumber;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList plannedOrderIDList = new ArrayList();
        if (pk != null) {
            this.getPlannedOrderIDList(ctx, pk.toString(), plannedOrderIDList);
        }
        super._delete(ctx, pk);
        this._writeSchedlueQty(ctx, plannedOrderIDList);
    }

    protected void checkBillNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlannedOrderScheduleInfo info = (PlannedOrderScheduleInfo)model;
        if (info.getNumber() == null || "".equals(info.getNumber())) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0014"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select h.fnumber from T_SCH_PlannedOrderSchedule h \r\n");
        sql.append(" where h.fnumber = '").append(info.getNumber()).append("'  \r\n");
        if (info.getId() != null) {
            sql.append(" and h.fid <> '").append(info.getId()).append("'  \r\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", (String)"DJBMCFBYX", (Locale)ctx.getLocale(), (Object[])new Object[]{rs.getString("fnumber")}));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBillNumber(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkBillNumber(ctx, model);
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlannedOrderScheduleInfo info;
        ArrayList plannedOrderIDList = new ArrayList();
        if (model != null && (info = (PlannedOrderScheduleInfo)model).getId() != null) {
            this.getPlannedOrderIDList(ctx, info.getId().toString(), plannedOrderIDList);
            this.getPlannedOrderDelIDList(ctx, info, plannedOrderIDList);
        }
        this.checkBillNumber(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        if (pk != null) {
            this.getPlannedOrderIDList(ctx, pk.toString(), plannedOrderIDList);
            this.checkModifyPlannedOrderData(ctx, plannedOrderIDList, pk.toString());
        }
        this._writeSchedlueQty(ctx, plannedOrderIDList);
        return pk;
    }

    protected void getPlannedOrderIDList(Context ctx, String scheduleID, List plannedOrderIDList) throws BOSException, EASBizException {
        if (plannedOrderIDList == null) {
            plannedOrderIDList = new ArrayList<String>();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct fplannedorderid from t_sch_poscheduleentry d where d.fparentid = '").append(scheduleID).append("' \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (plannedOrderIDList.contains(rs.getString("fplannedorderid"))) continue;
                plannedOrderIDList.add(rs.getString("fplannedorderid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected void getPlannedOrderDelIDList(Context ctx, PlannedOrderScheduleInfo info, List plannedOrderIDList) throws BOSException, EASBizException {
        int i;
        if (plannedOrderIDList == null) {
            plannedOrderIDList = new ArrayList<String>();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> productLineList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        for (i = 0; i < info.getProductLineEntry().size(); ++i) {
            ProductLineInfo plInfo;
            if (info.getProductLineEntry().get(i).getProductLine() == null || productLineList.contains((plInfo = info.getProductLineEntry().get(i).getProductLine()).getId().toString())) continue;
            productLineList.add(plInfo.getId().toString());
        }
        for (i = 0; i < info.getMaterialEntry().size(); ++i) {
            if (info.getMaterialEntry().get(i).getMaterial() == null || materialList.contains(info.getMaterialEntry().get(i).getMaterial().getId().toString())) continue;
            materialList.add(info.getMaterialEntry().get(i).getMaterial().getId().toString());
        }
        java.util.Date beginDate = info.getBeginDate();
        java.util.Date endDate = info.getEndDate();
        String beginDateStr = sdfDate.format(beginDate) + " 00:00:00";
        String endDateStr = sdfDate.format(endDate) + " 23:59:59";
        sql.setLength(0);
        sql.append(" Select fplannedorderid from t_sch_poscheduleentry \r\n");
        sql.append(" where fsourceunionid in( \r\n");
        sql.append(" Select a.fid from t_sch_poscheduleentry a \r\n");
        sql.append(" where a.fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and a.fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and a.fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and a.fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" ) \r\n");
        sql.append(" union \r\n");
        sql.append(" Select fplannedorderid from t_sch_poscheduleentry \r\n");
        sql.append(" where fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (plannedOrderIDList.contains(rs.getString("fplannedorderid"))) continue;
                plannedOrderIDList.add(rs.getString("fplannedorderid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    protected void checkModifyPlannedOrderData(Context ctx, List idList, String fbillid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer errorsql = new StringBuffer();
        sql.append(" Select * from ( \r\n");
        sql.append(" Select a.fbasestatus,a.fnumber, \r\n");
        sql.append("  a.fqty,isnull(a.ftotalreleaseqty,0) As ftotalreleaseqty, \r\n");
        sql.append(" Isnull((select sum(fnewqty - isnull(freleaseqty,0)) from t_sch_poscheduleentry sch where sch.fplannedorderid = a.fid and sch.fnewdate is not null  ),0) as fscheduleQty,  \r\n");
        sql.append(" Isnull((select sum(fnewqty - isnull(freleaseqty,0)) from t_sch_poscheduleentry sch where sch.fplannedorderid = a.fid and sch.fnewdate is not null and sch.fparentid = '").append(fbillid).append("'  ),0) as fthisscheduleQty  \r\n");
        sql.append(" from t_mrp_pmrpplannedorder a \r\n");
        sql.append(" where a.fid in (Select fplannedorderid from t_sch_poscheduleentry where fparentid = '").append(fbillid).append("') \r\n");
        sql.append(" ) aa where (aa.fbasestatus = 7) or (aa.fqty - aa.ftotalreleaseqty < aa.fscheduleQty and aa.fthisscheduleQty > 0) \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("fbasestatus") != null && rs.getString("fbasestatus").equals("7")) {
                    errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0015") + "[" + rs.getString("fnumber") + "]" + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0016"));
                    continue;
                }
                errorsql.append(ResourceBase.getString((String)"com.kingdee.eas.industry.emm.project.biz.reqclose.EMMPROJECTprojectBizReqcloseResource", (String)"XMJHDDWTFS", (Locale)ctx.getLocale(), (Object[])new Object[]{rs.getString("fnumber"), rs.getBigDecimal("fqty").subtract(rs.getBigDecimal("ftotalreleaseqty")), rs.getBigDecimal("fscheduleQty")})).append(" \r\n");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (errorsql.length() > 0) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", errorsql.toString());
            throw new InterfaceDataBaseException(interfaceException);
        }
    }

    @Override
    protected void _writeSchedlueQty(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() < 1) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList oneUpdateList = new ArrayList();
        for (int i = 0; i < idList.size(); ++i) {
            if (oneUpdateList.size() > 997) {
                sql.setLength(0);
                sql.append(" update t_mrp_pmrpplannedorder a \r\n");
                sql.append(" set FScheduleQty = isnull((Select sum(d.fnewqty) from t_sch_poscheduleentry d  \r\n");
                sql.append(" where d.fplannedorderid = a.fid and d.fnewdate is not null),0) \r\n");
                sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])oneUpdateList.toArray())).append(") \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append(" update t_mrp_pmrpplannedorder a \r\n");
                sql.append(" set fbasescheduleqty = FScheduleQty  \r\n");
                sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])oneUpdateList.toArray())).append(") \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                oneUpdateList = new ArrayList();
            }
            oneUpdateList.add(idList.get(i));
        }
        if (oneUpdateList.size() > 0) {
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder a \r\n");
            sql.append(" set FScheduleQty = isnull((Select sum(d.fnewqty) from t_sch_poscheduleentry d  \r\n");
            sql.append(" where d.fplannedorderid = a.fid and d.fnewdate is not null),0) \r\n");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])oneUpdateList.toArray())).append(") \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update t_mrp_pmrpplannedorder a \r\n");
            sql.append(" set fbasescheduleqty = FScheduleQty  \r\n");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])oneUpdateList.toArray())).append(") \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected String createPlannedScheduleDelTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandZZBOMTempTable(\r\n");
        sql.append("FID  VARCHAR(44), \r\n");
        sql.append("FplannedorderID VARCHAR(44),\r\n");
        sql.append("FQty Numeric(28,14)\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FplannedorderID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected void insertIntoPlannedOrderScheduleDel(Context ctx, PlannedOrderScheduleInfo info, String tempTableName) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> productLineList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        for (i = 0; i < info.getProductLineEntry().size(); ++i) {
            ProductLineInfo plInfo;
            if (info.getProductLineEntry().get(i).getProductLine() == null || productLineList.contains((plInfo = info.getProductLineEntry().get(i).getProductLine()).getId().toString())) continue;
            productLineList.add(plInfo.getId().toString());
        }
        for (i = 0; i < info.getMaterialEntry().size(); ++i) {
            if (info.getMaterialEntry().get(i).getMaterial() == null || materialList.contains(info.getMaterialEntry().get(i).getMaterial().getId().toString())) continue;
            materialList.add(info.getMaterialEntry().get(i).getMaterial().getId().toString());
        }
        java.util.Date beginDate = info.getBeginDate();
        java.util.Date endDate = info.getEndDate();
        String beginDateStr = sdfDate.format(beginDate) + " 00:00:00";
        String endDateStr = sdfDate.format(endDate) + " 23:59:59";
        String fid = "";
        if (info.getId() != null) {
            fid = info.getId().toString();
        }
        sql.setLength(0);
        sql.append(" Insert Into  ").append(tempTableName).append(" (Fid,FplannedorderID,Fqty)\r\n");
        sql.append(" Select distinct fid,fplannedorderid,fnewqty - isnull(freleaseqty,0) from t_sch_poscheduleentry \r\n");
        sql.append(" where fsourceunionid in( \r\n");
        sql.append(" Select a.fid from t_sch_poscheduleentry a \r\n");
        sql.append(" where a.fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and a.fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and a.fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and a.fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" and a.fparentid <> '").append(fid).append("' \r\n");
        sql.append(" ) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert Into  ").append(tempTableName).append(" (Fid,FplannedorderID,Fqty)\r\n");
        sql.append(" Select distinct fid,fplannedorderid,fnewqty - isnull(freleaseqty,0) from t_sch_poscheduleentry \r\n");
        sql.append(" where fmaterialid in (").append(SQLUtil.arrayToString((Object[])materialList.toArray())).append(") \r\n");
        sql.append(" and fproductlineid in (").append(SQLUtil.arrayToString((Object[])productLineList.toArray())).append(") \r\n");
        sql.append(" and fnewdate >= to_date('").append(beginDateStr).append("') \r\n");
        sql.append(" and fnewdate <= to_date('").append(endDateStr).append("') \r\n");
        sql.append(" and a.fparentid <> '").append(fid).append("' \r\n");
        sql.append(" and not exists(Select 1 from ").append(tempTableName).append(" a where a.fid = t_sch_poscheduleentry.fid ) \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _releasecheck(Context ctx, Map dataMap) throws BOSException, EASBizException {
        if (dataMap == null) {
            return null;
        }
        HashSet entryIdSet = (HashSet)dataMap.get("entryIDSet");
        if (entryIdSet == null || entryIdSet.size() < 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer errorsql = new StringBuffer();
        StringBuffer errorAllsql = new StringBuffer();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("*"));
        sics.add(new SelectorItemInfo("parent.id"));
        sics.add(new SelectorItemInfo("parent.number"));
        sics.add(new SelectorItemInfo("productLine.id"));
        sics.add(new SelectorItemInfo("productLine.name"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(sics);
        PlannedOrderScheduleEntryCollection entryColl = PlannedOrderScheduleEntryFactory.getLocalInstance(ctx).getPlannedOrderScheduleEntryCollection(entityViewInfo);
        if (entryColl == null || entryColl.size() < 1) {
            return null;
        }
        HashMap plannedOrderMap = new HashMap();
        PMRPPlannedOrderInfo plannedOrderInfo = null;
        PlannedOrderTypeEnum poTypeEnum = null;
        ArrayList dataList = new ArrayList();
        String orgID = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.materialGroup.id"));
        sic.add(new SelectorItemInfo("material.materialGroup.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.coefficient"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("productUnit.id"));
        sic.add(new SelectorItemInfo("productUnit.name"));
        sic.add(new SelectorItemInfo("productionOrgUnit.id"));
        sic.add(new SelectorItemInfo("productionOrgUnit.name"));
        for (int i = 0; i < entryColl.size(); ++i) {
            PlannedOrderScheduleEntryInfo entryInfo = entryColl.get(i);
            HashMap<String, Serializable> billMap = new HashMap<String, Serializable>();
            errorsql.setLength(0);
            if (entryInfo.getNewDate() == null) {
                errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0017"));
            }
            if (entryInfo.getNewQty() == null || entryInfo.getNewQty().compareTo(BigDecimal.ZERO) <= 0) {
                errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0018"));
            }
            if (entryInfo.getReleaseQty() == null) {
                entryInfo.setReleaseQty(BigDecimal.ZERO);
            }
            if (entryInfo.getReleaseQty() != null && entryInfo.getNewQty().compareTo(entryInfo.getReleaseQty()) <= 0) {
                errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0019"));
            }
            plannedOrderInfo = null;
            if (plannedOrderMap != null && plannedOrderMap.containsKey(entryInfo.getPlannedOrderID())) {
                plannedOrderInfo = (PMRPPlannedOrderInfo)plannedOrderMap.get(entryInfo.getPlannedOrderID());
            } else if (PMRPPlannedOrderFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(entryInfo.getPlannedOrderID()))) {
                plannedOrderInfo = PMRPPlannedOrderFactory.getLocalInstance(ctx).getPMRPPlannedOrderInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPlannedOrderID()), sic);
            } else {
                errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0020"));
            }
            if (plannedOrderInfo != null) {
                if (!plannedOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0021"));
                }
                if (poTypeEnum == null) {
                    poTypeEnum = plannedOrderInfo.getOrderType();
                } else if (!poTypeEnum.equals((Object)plannedOrderInfo.getOrderType())) {
                    errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0022"));
                }
                if (plannedOrderInfo.getTotalReleaseQty() != null && plannedOrderInfo.getTotalReleaseQty().compareTo(plannedOrderInfo.getQty()) >= 0) {
                    errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0023"));
                }
                if (orgID == null) {
                    orgID = plannedOrderInfo.getStorageOrgUnit().getId().toString();
                } else if (!orgID.equals(plannedOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errorsql.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0024"));
                }
            }
            if (errorsql.length() > 0) {
                errorAllsql.append("\r\n ").append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0015")).append("[").append(entryInfo.getPlannedOrderNumber()).append("]").append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", "0EMMPROJECTSchedule-0025"));
                errorAllsql.append(errorsql);
                continue;
            }
            billMap.put("plannedOrderInfo", plannedOrderInfo);
            billMap.put("scheduleEntryInfo", entryInfo);
            dataList.add(billMap);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (errorAllsql.length() > 0) {
            returnMap.put("result", "failed");
            returnMap.put("errorMessage", errorAllsql.toString());
        } else {
            returnMap.put("result", "successful");
            returnMap.put("dataList", dataList);
        }
        return returnMap;
    }

    @Override
    protected Map _gettracklevel(Context ctx, List trackList, List materialIDList) throws BOSException, EASBizException {
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        if (trackList == null || trackList.size() < 1) {
            return returnMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from (");
        sql.append(" Select a.ftrackid,t.fnumber as ftracknumber,min(a.favilabledate) as favilabledate \r\n");
        sql.append(" from t_mrp_pmrpplannedorder a \r\n");
        sql.append(" left outer join t_mm_tracknumber t on t.fid = a.ftrackid \r\n");
        sql.append(" where 1 = 1 ");
        if (materialIDList != null && materialIDList.size() > 0) {
            sql.append("  and a.fmaterialid  in (").append(SQLUtil.arrayToString((Object[])materialIDList.toArray())).append(") \r\n");
        }
        sql.append(" and a.ftrackid in (").append(SQLUtil.arrayToString((Object[])trackList.toArray())).append(") \r\n");
        sql.append(" and a.fqty - a.ftotalreleaseqty > 0 and a.fbasestatus <> 7  \r\n");
        sql.append(" group by a.ftrackid,t.fnumber  \r\n");
        sql.append(" ) aa order by favilabledate desc,ftracknumber desc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int level = 0;
        try {
            while (rs.next()) {
                String ftrackid = rs.getString("ftrackid");
                returnMap.put(ftrackid, ++level);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", e.getMessage());
            throw new InterfaceDataBaseException(interfaceException);
        }
        return returnMap;
    }

    protected void setMergeData(Context ctx, PlannedOrderScheduleEntryCollection entryColl) throws BOSException, EASBizException {
        int i;
        PlannedOrderScheduleEntryCollection removeColl = new PlannedOrderScheduleEntryCollection();
        String fkeyid = null;
        String fkeyid2 = null;
        block0: for (i = 0; i < entryColl.size(); ++i) {
            PlannedOrderScheduleEntryInfo entryInfo = entryColl.get(i);
            if (entryInfo.getNewDate() == null || entryInfo.getProductLine() == null || i >= entryColl.size() - 1) continue;
            fkeyid = sdfDate.format(entryInfo.getNewDate()) + entryInfo.getProductLine().getId() + entryInfo.getPlannedOrderID();
            for (int j = i + 1; j < entryColl.size(); ++j) {
                PlannedOrderScheduleEntryInfo entryInfo2 = entryColl.get(j);
                if (entryInfo2.getNewDate() == null || entryInfo2.getProductLine() == null || !fkeyid.equals(fkeyid2 = sdfDate.format(entryInfo2.getNewDate()) + entryInfo2.getProductLine().getId() + entryInfo2.getPlannedOrderID())) continue;
                entryInfo2.setNewQty(entryInfo2.getNewQty().add(entryInfo.getNewQty()));
                removeColl.add(entryInfo);
                continue block0;
            }
        }
        for (i = 0; i < removeColl.size(); ++i) {
            entryColl.remove(removeColl.get(i));
        }
    }

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

