/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.zj.app.ZJDefaultWarehouseServerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.qm.qc.ClaimNoteFactory;
import com.kingdee.eas.industry.emm.qm.qc.ClaimNoteInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportInfo;
import com.kingdee.eas.industry.emm.qm.qc.app.AbstractClaimNoteControllerBean;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.OtherIssueBillCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClaimNoteControllerBean
extends AbstractClaimNoteControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.qm.qc.app.ClaimNoteControllerBean");
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.EMMSCMEMMBaseResource";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClaimNoteInfo claimNoteInfo = (ClaimNoteInfo)model;
        claimNoteInfo.setTotalDownQty(claimNoteInfo.getClaimQty());
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClaimNoteInfo claimNoteInfo = (ClaimNoteInfo)model;
        claimNoteInfo.setTotalDownQty(claimNoteInfo.getClaimQty());
        return super._submit(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            model = this.getClaimNoteInfo(ctx, pk);
        }
        super._passAudit(ctx, pk, model);
        ClaimNoteInfo claimNoteInfo = this.getClaimNoteInfo(ctx, pk);
        claimNoteInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.updateAuditStatus(ctx, (IObjectValue)model);
        this.transClaimAudit(ctx, (IObjectValue)model);
    }

    public void transClaimAudit(Context ctx, IObjectValue model) throws BOSException {
        try {
            ClaimNoteInfo claimNoteInfo = (ClaimNoteInfo)model;
            if (claimNoteInfo.getClaimAmount() != null && claimNoteInfo.getClaimAmount().compareTo(SCMServerUtils.ZERO) > 0) {
                this.transOtherBillByBOTP(ctx, claimNoteInfo);
            }
            if (claimNoteInfo.getClaimQty().compareTo(BigDecimal.ZERO) != 0) {
                this.transPurReceivalBillByBOTP(ctx, claimNoteInfo);
            }
            if (claimNoteInfo.getRejectQty().compareTo(BigDecimal.ZERO) != 0) {
                if (claimNoteInfo.isIsOtherInOut()) {
                    this.tranOtherIssueByBOTP(ctx, claimNoteInfo);
                } else {
                    this.tranPurInRetByBOTP(ctx, claimNoteInfo);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Map getMapByRelation(BOTRelationCollection relations) {
        HashMap<String, BOTRelationCollection> map = new HashMap<String, BOTRelationCollection>();
        for (int i = 0; i < relations.size(); ++i) {
            BOTRelationCollection botrelationcollection;
            BOTRelationInfo relationInfo = relations.get(i);
            String oid = relationInfo.getDestObjectID();
            if (map.get(oid) != null) {
                botrelationcollection = (BOTRelationCollection)map.get(oid);
                botrelationcollection.add(relationInfo);
                map.put(oid, botrelationcollection);
                continue;
            }
            botrelationcollection = new BOTRelationCollection();
            botrelationcollection.add(relationInfo);
            map.put(oid, botrelationcollection);
        }
        return map;
    }

    public NCRreportInfo getNcrRreportByClaim(Context ctx, ClaimNoteInfo claimNoteInfo) throws EASBizException, BOSException {
        String pk = claimNoteInfo.getSourceBillId();
        NCRreportInfo ncrReportInfo = NCRreportFactory.getLocalInstance(ctx).getNCRreportInfo((IObjectPK)new ObjectUuidPK(pk));
        return ncrReportInfo;
    }

    public void transOtherBillByBOTP(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException {
        try {
            IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='CLIAMTOOTHERBILL' and extRule.isEffected=1 ");
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            }
            if (botInfo == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", "CLIAMTOOTHERBILL" + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_GZBCZHWQY", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (botInfo != null) {
                IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult result = null;
                result = btp.transform((CoreBillBaseInfo)claimNoteInfo, botInfo);
                if (result.getBills().size() <= 0) {
                    return;
                }
                BOTRelationCollection relations = result.getBOTRelationCollection();
                Map map = this.getMapByRelation(relations);
                for (int i = 0; i < result.getBills().size(); ++i) {
                    IObjectValue destBillInfo = result.getBills().getObject(i);
                    OtherBillInfo otherBillInfo = (OtherBillInfo)destBillInfo;
                    BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(otherBillInfo.getId().toString());
                    otherBillInfo.setBillStatus(BillStatusEnum.SAVE);
                    btp.saveRelations((CoreBillBaseInfo)otherBillInfo, botrelationcollection);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void transPurReceivalBillByBOTP(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException {
        try {
            IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='CLIAMTOPURREC' and extRule.isEffected=1 ");
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            }
            if (botInfo == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", "CLIAMTOPURREC" + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_GZBCZHWQY", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (botInfo != null) {
                IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult result = null;
                result = btp.transform((CoreBillBaseInfo)claimNoteInfo, botInfo);
                if (result.getBills().size() <= 0) {
                    return;
                }
                BOTRelationCollection relations = result.getBOTRelationCollection();
                IObjectCollection billCollection = result.getBills();
                PurReceivalBillFactory.getLocalInstance((Context)ctx).handleAfterTransform("FromClaimNote", billCollection);
                Map map = this.getMapByRelation(relations);
                for (int i = 0; i < billCollection.size(); ++i) {
                    IObjectValue destBillInfo = billCollection.getObject(i);
                    PurReceivalBillInfo purReceivalBillInfo = (PurReceivalBillInfo)destBillInfo;
                    PurReceivalEntryCollection purRecEntrylColl = purReceivalBillInfo.getEntry();
                    if (claimNoteInfo.getSourceBillId() != null) {
                        NCRreportInfo ncrReportInfo = this.getNcrRreportByClaim(ctx, claimNoteInfo);
                        for (int j = 0; j < purRecEntrylColl.size(); ++j) {
                            PurReceivalEntryInfo purRecEntryInfo = purRecEntrylColl.get(j);
                            purRecEntryInfo.setProject(ncrReportInfo.getProject());
                            purRecEntryInfo.setTrackNumber(ncrReportInfo.getTrackNumber());
                        }
                    }
                    BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(purReceivalBillInfo.getId().toString());
                    btp.saveRelations((CoreBillBaseInfo)purReceivalBillInfo, botrelationcollection);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void tranPurInRetByBOTP(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException {
        try {
            IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='CLIAMTOPURRET' and extRule.isEffected=1 ");
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            }
            if (botInfo == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", "CLIAMTOPURRET" + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_GZBCZHWQY", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (botInfo != null) {
                IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult result = null;
                result = btp.transform((CoreBillBaseInfo)claimNoteInfo, botInfo);
                if (result.getBills().size() <= 0) {
                    return;
                }
                BOTRelationCollection relations = result.getBOTRelationCollection();
                Map map = this.getMapByRelation(relations);
                for (int i = 0; i < result.getBills().size(); ++i) {
                    IObjectValue destBillInfo = result.getBills().getObject(i);
                    PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)destBillInfo;
                    BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(purInWarehsBillInfo.getId().toString());
                    purInWarehsBillInfo.setBizType(BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0107-1000-e000-04c5c0a812202407435C")));
                    String sourcebillId = claimNoteInfo.getSourceBillId();
                    if (sourcebillId != null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("project.id"));
                        sic.add(new SelectorItemInfo("project.number"));
                        sic.add(new SelectorItemInfo("project.name"));
                        NCRreportInfo ncrReportInfo = NCRreportFactory.getLocalInstance(ctx).getNCRreportInfo((IObjectPK)new ObjectUuidPK(sourcebillId), sic);
                        ProjectInfo projectInfo = ncrReportInfo.getProject();
                        if (purInWarehsBillInfo.getStorageOrgUnit() == null) {
                            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_CGRKDKCZZWK", (Locale)ctx.getLocale()));
                            throw new InterfaceDataBaseException(interfaceException);
                        }
                        StorageOrgUnitInfo stoOrgUnitInfo = purInWarehsBillInfo.getStorageOrgUnit();
                        PurInWarehsEntryCollection purInWareEntryColl = purInWarehsBillInfo.getEntry();
                        for (int j = 0; j < purInWareEntryColl.size(); ++j) {
                            PurInWarehsEntryInfo purInEntryInfo = purInWareEntryColl.get(j);
                            MaterialInfo materialInfo = purInEntryInfo.getMaterial();
                            WarehouseInfo warehouseInfo = this.getDefaultWarehouseInfo(ctx, projectInfo, stoOrgUnitInfo, materialInfo);
                            if (warehouseInfo != null) {
                                WarehouseInfo disWarInfo = (WarehouseInfo)warehouseInfo.get("disWarehouse");
                                purInEntryInfo.setWarehouse(disWarInfo);
                            }
                            purInEntryInfo.setProject(projectInfo);
                            BigDecimal standardCost = this.getMaterialStandardCost(ctx, materialInfo.getId().toString(), stoOrgUnitInfo);
                            purInEntryInfo.setStandardCost(standardCost);
                            purInEntryInfo.setUnitStandardCost(standardCost);
                        }
                    }
                    btp.saveRelations((CoreBillBaseInfo)purInWarehsBillInfo, botrelationcollection);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BigDecimal getMaterialStandardCost(Context ctx, String materialID, StorageOrgUnitInfo storageOrgInfo) throws BOSException, EASBizException {
        BigDecimal standardCost = BigDecimal.ZERO;
        try {
            MaterialCompanyInfoInfo materialComInfo;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo orgUnitInfo = null;
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgInfo.getId().toString(), 4, 1);
            if (orgCol.size() <= 0) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0000", (Locale)ctx.getLocale()) + storageOrgInfo.getName() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0001", (Locale)ctx.getLocale()) + storageOrgInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0002", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            orgUnitInfo = orgCol.get(0);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialID));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitInfo.getId().toString()));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            MaterialCompanyInfoCollection materialComColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
            if (materialComColl.size() > 0 && (materialComInfo = materialComColl.get(0)).getStandardCost() != null) {
                standardCost = materialComInfo.getStandardCost();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return standardCost;
    }

    public WarehouseInfo getDefaultWarehouseInfo(Context ctx, ProjectInfo projectInfo, StorageOrgUnitInfo stoUnitInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        WarehouseInfo warehouseInfo = null;
        warehouseInfo = ZJDefaultWarehouseServerUtils.getDefaultWarehouse(ctx, stoUnitInfo, materialInfo, projectInfo, true);
        return warehouseInfo;
    }

    public void tranOtherIssueByBOTP(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException {
        try {
            IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='CLIAMTOOTHERISSUE' and extRule.isEffected=1 ");
            if (botCol.size() == 1) {
                botInfo = botCol.get(0);
            }
            if (botInfo == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", "CLIAMTOOTHERISSUE" + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_GZBCZHWQY", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            if (botInfo != null) {
                IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult result = null;
                result = btp.transform((CoreBillBaseInfo)claimNoteInfo, botInfo);
                if (result.getBills().size() <= 0) {
                    return;
                }
                BOTRelationCollection relations = result.getBOTRelationCollection();
                Map map = this.getMapByRelation(relations);
                for (int i = 0; i < result.getBills().size(); ++i) {
                    IObjectValue destBillInfo = result.getBills().getObject(i);
                    OtherIssueBillInfo otherIssueBillInfo = (OtherIssueBillInfo)destBillInfo;
                    BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(otherIssueBillInfo.getId().toString());
                    btp.saveRelations((CoreBillBaseInfo)otherIssueBillInfo, botrelationcollection);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit(ctx, pk);
        ClaimNoteInfo claimNoteInfo = this.getClaimNoteInfo(ctx, pk);
        claimNoteInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.updateUnAuditStatus(ctx, (IObjectValue)claimNoteInfo);
        this.transClaimUnAudit(ctx, (IObjectValue)claimNoteInfo);
    }

    protected void transClaimUnAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        try {
            ClaimNoteInfo claimNoteInfo = (ClaimNoteInfo)model;
            if (claimNoteInfo.getClaimAmount() != null && claimNoteInfo.getClaimAmount().compareTo(SCMServerUtils.ZERO) > 0) {
                this.transDelOtherBill(ctx, claimNoteInfo);
            }
            if (claimNoteInfo.getClaimQty().compareTo(BigDecimal.ZERO) != 0) {
                this.transDelPurReceivalBill(ctx, claimNoteInfo);
            }
            this.transDelPurInRetBill(ctx, claimNoteInfo);
            if (claimNoteInfo.getRejectQty().compareTo(BigDecimal.ZERO) != 0) {
                if (claimNoteInfo.isIsOtherInOut()) {
                    this.transDelOtherIssueBill(ctx, claimNoteInfo);
                } else {
                    this.transDelPurInRetBill(ctx, claimNoteInfo);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void transDelOtherBill(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException, EASBizException {
        OtherBillCollection otherBillcoll = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection("Where sourceBillId = '" + claimNoteInfo.getId().toString() + "'");
        if (otherBillcoll.size() > 0) {
            OtherBillInfo otherBillInfo = otherBillcoll.get(0);
            if (otherBillInfo.getBillStatus().equals((Object)BillStatusEnum.SAVE) || otherBillInfo.getBillStatus().equals((Object)com.kingdee.eas.fi.cas.BillStatusEnum.SUBMIT)) {
                DbUtil.execute((Context)ctx, (String)("update T_AR_OtherBill set fsourceBillType ='' where fid='" + otherBillInfo.getId().toString() + "'"));
                OtherBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(otherBillInfo.getId()));
            } else {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0003", (Locale)ctx.getLocale()) + otherBillInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0004", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
    }

    protected void transDelPurReceivalBill(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException, EASBizException {
        PurReceivalBillCollection purRecBillColl = PurReceivalBillFactory.getLocalInstance((Context)ctx).getPurReceivalBillCollection("Where sourceBillId = '" + claimNoteInfo.getId().toString() + "'");
        if (purRecBillColl.size() > 0) {
            for (int i = 0; i < purRecBillColl.size(); ++i) {
                PurReceivalBillInfo purRecBillInfo = purRecBillColl.get(i);
                if (!purRecBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !purRecBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0005", (Locale)ctx.getLocale()) + purRecBillInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0004", (Locale)ctx.getLocale()));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                DbUtil.execute((Context)ctx, (String)("update T_IM_PurReceivalBill set fsourceBillTypeid ='' where fid = '" + purRecBillInfo.getId().toString() + "'"));
                PurReceivalBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(purRecBillInfo.getId()));
            }
            claimNoteInfo.setTotalDownQty(claimNoteInfo.getClaimQty());
            ClaimNoteFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(claimNoteInfo.getId().toString()), claimNoteInfo);
        }
    }

    protected void transDelOtherIssueBill(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException, EASBizException {
        OtherIssueBillCollection otherBillColl = OtherIssueBillFactory.getLocalInstance((Context)ctx).getOtherIssueBillCollection("Where sourceBillId = '" + claimNoteInfo.getId().toString() + "'");
        if (otherBillColl.size() > 0) {
            OtherIssueBillInfo otherIsBillInfo = otherBillColl.get(0);
            if (otherIsBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || otherIsBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                DbUtil.execute((Context)ctx, (String)("update T_IM_OtherIssueBill set fsourceBillTypeid = '' where fid = '" + otherIsBillInfo.getId().toString() + "'"));
                OtherIssueBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(otherIsBillInfo.getId()));
            } else {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0006", (Locale)ctx.getLocale()) + otherIsBillInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0004", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
    }

    protected void transDelPurInRetBill(Context ctx, ClaimNoteInfo claimNoteInfo) throws BOSException, EASBizException {
        PurInWarehsBillCollection purInWareColl = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection("Where sourceBillId = '" + claimNoteInfo.getId().toString() + "'");
        if (purInWareColl.size() > 0) {
            PurInWarehsBillInfo purInWareBillInfo = purInWareColl.get(0);
            if (purInWareBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || purInWareBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                DbUtil.execute((Context)ctx, (String)("update T_IM_PurInWarehsBill set fsourceBillTypeid ='' where fid = '" + purInWareBillInfo.getId().toString() + "'"));
                PurInWarehsBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(purInWareBillInfo.getId()));
            } else {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0007", (Locale)ctx.getLocale()) + claimNoteInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"0EMMSCMNCRBiz-0004", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        ClaimNoteInfo claimNote = this.getClaimNoteInfo(ctx, pk, sic);
        this.beforeDelete(ctx, claimNote);
        super._delete(ctx, pk);
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector = super.getSelector(isNeedEntrySelector);
        selector.add(new SelectorItemInfo("purchaseOrgUnit.*"));
        return selector;
    }

    protected void beforeDelete(Context ctx, ClaimNoteInfo claimNote) throws BOSException, EASBizException {
        if (claimNote.getSourceBillType() != null && claimNote.getSourceBillType().getNumber().equals("NCR")) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_DJYNCRBGCS_BYXSC", (Locale)ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
    }
}

